// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanLibjarMetrics_h
#define mozilla_GleanLibjarMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace zero_byte_load {
  /**
   * generated from zero_byte_load.load_css
   */
  struct LoadCssExtra {
    mozilla::Maybe<nsCString> cancelReason;
    mozilla::Maybe<bool> cancelled;
    mozilla::Maybe<nsCString> fileName;
    mozilla::Maybe<nsCString> status;
    mozilla::Maybe<bool> sync;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cancelReason) {
        extraKeys.AppendElement()->AssignASCII("cancel_reason");
        extraValues.EmplaceBack(cancelReason.value());
      }
      if (cancelled) {
        extraKeys.AppendElement()->AssignASCII("cancelled");
        extraValues.AppendElement()->AssignASCII(cancelled.value() ? "true" : "false");
      }
      if (fileName) {
        extraKeys.AppendElement()->AssignASCII("file_name");
        extraValues.EmplaceBack(fileName.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.AppendElement()->AssignASCII(sync.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collection of zero_byte_load events as part of the Yellow Screen of Death analysis. When a file is loaded synchronously, this event gets recorded in nsJARChannel::Open if the content length is zero. For asynchronous loads, this event gets recorded in onStopRequest. Note that when the load has been cancelled, the consumer could already receive some data, so this event also captures non-zero-byte loads. This event was generated to correspond to the Legacy Telemetry event zero_byte_load.load#css.
   */
  constexpr impl::EventMetric<LoadCssExtra> load_css(4257);

  /**
   * generated from zero_byte_load.load_dtd
   */
  struct LoadDtdExtra {
    mozilla::Maybe<nsCString> cancelReason;
    mozilla::Maybe<bool> cancelled;
    mozilla::Maybe<nsCString> fileName;
    mozilla::Maybe<nsCString> status;
    mozilla::Maybe<bool> sync;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cancelReason) {
        extraKeys.AppendElement()->AssignASCII("cancel_reason");
        extraValues.EmplaceBack(cancelReason.value());
      }
      if (cancelled) {
        extraKeys.AppendElement()->AssignASCII("cancelled");
        extraValues.AppendElement()->AssignASCII(cancelled.value() ? "true" : "false");
      }
      if (fileName) {
        extraKeys.AppendElement()->AssignASCII("file_name");
        extraValues.EmplaceBack(fileName.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.AppendElement()->AssignASCII(sync.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collection of zero_byte_load events as part of the Yellow Screen of Death analysis. When a file is loaded synchronously, this event gets recorded in nsJARChannel::Open if the content length is zero. For asynchronous loads, this event gets recorded in onStopRequest. Note that when the load has been cancelled, the consumer could already receive some data, so this event also captures non-zero-byte loads. This event was generated to correspond to the Legacy Telemetry event zero_byte_load.load#dtd.
   */
  constexpr impl::EventMetric<LoadDtdExtra> load_dtd(4258);

  /**
   * generated from zero_byte_load.load_ftl
   */
  struct LoadFtlExtra {
    mozilla::Maybe<nsCString> cancelReason;
    mozilla::Maybe<bool> cancelled;
    mozilla::Maybe<nsCString> fileName;
    mozilla::Maybe<nsCString> status;
    mozilla::Maybe<bool> sync;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cancelReason) {
        extraKeys.AppendElement()->AssignASCII("cancel_reason");
        extraValues.EmplaceBack(cancelReason.value());
      }
      if (cancelled) {
        extraKeys.AppendElement()->AssignASCII("cancelled");
        extraValues.AppendElement()->AssignASCII(cancelled.value() ? "true" : "false");
      }
      if (fileName) {
        extraKeys.AppendElement()->AssignASCII("file_name");
        extraValues.EmplaceBack(fileName.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.AppendElement()->AssignASCII(sync.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collection of zero_byte_load events as part of the Yellow Screen of Death analysis. When a file is loaded synchronously, this event gets recorded in nsJARChannel::Open if the content length is zero. For asynchronous loads, this event gets recorded in onStopRequest. Note that when the load has been cancelled, the consumer could already receive some data, so this event also captures non-zero-byte loads. This event was generated to correspond to the Legacy Telemetry event zero_byte_load.load#ftl.
   */
  constexpr impl::EventMetric<LoadFtlExtra> load_ftl(4259);

  /**
   * generated from zero_byte_load.load_html
   */
  struct LoadHtmlExtra {
    mozilla::Maybe<nsCString> cancelReason;
    mozilla::Maybe<bool> cancelled;
    mozilla::Maybe<nsCString> fileName;
    mozilla::Maybe<nsCString> status;
    mozilla::Maybe<bool> sync;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cancelReason) {
        extraKeys.AppendElement()->AssignASCII("cancel_reason");
        extraValues.EmplaceBack(cancelReason.value());
      }
      if (cancelled) {
        extraKeys.AppendElement()->AssignASCII("cancelled");
        extraValues.AppendElement()->AssignASCII(cancelled.value() ? "true" : "false");
      }
      if (fileName) {
        extraKeys.AppendElement()->AssignASCII("file_name");
        extraValues.EmplaceBack(fileName.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.AppendElement()->AssignASCII(sync.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collection of zero_byte_load events as part of the Yellow Screen of Death analysis. When a file is loaded synchronously, this event gets recorded in nsJARChannel::Open if the content length is zero. For asynchronous loads, this event gets recorded in onStopRequest. Note that when the load has been cancelled, the consumer could already receive some data, so this event also captures non-zero-byte loads. This event was generated to correspond to the Legacy Telemetry event zero_byte_load.load#html.
   */
  constexpr impl::EventMetric<LoadHtmlExtra> load_html(4260);

  /**
   * generated from zero_byte_load.load_js
   */
  struct LoadJsExtra {
    mozilla::Maybe<nsCString> cancelReason;
    mozilla::Maybe<bool> cancelled;
    mozilla::Maybe<nsCString> fileName;
    mozilla::Maybe<nsCString> status;
    mozilla::Maybe<bool> sync;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cancelReason) {
        extraKeys.AppendElement()->AssignASCII("cancel_reason");
        extraValues.EmplaceBack(cancelReason.value());
      }
      if (cancelled) {
        extraKeys.AppendElement()->AssignASCII("cancelled");
        extraValues.AppendElement()->AssignASCII(cancelled.value() ? "true" : "false");
      }
      if (fileName) {
        extraKeys.AppendElement()->AssignASCII("file_name");
        extraValues.EmplaceBack(fileName.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.AppendElement()->AssignASCII(sync.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collection of zero_byte_load events as part of the Yellow Screen of Death analysis. When a file is loaded synchronously, this event gets recorded in nsJARChannel::Open if the content length is zero. For asynchronous loads, this event gets recorded in onStopRequest. Note that when the load has been cancelled, the consumer could already receive some data, so this event also captures non-zero-byte loads. This event was generated to correspond to the Legacy Telemetry event zero_byte_load.load#js.
   */
  constexpr impl::EventMetric<LoadJsExtra> load_js(4261);

  /**
   * generated from zero_byte_load.load_json
   */
  struct LoadJsonExtra {
    mozilla::Maybe<nsCString> cancelReason;
    mozilla::Maybe<bool> cancelled;
    mozilla::Maybe<nsCString> fileName;
    mozilla::Maybe<nsCString> status;
    mozilla::Maybe<bool> sync;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cancelReason) {
        extraKeys.AppendElement()->AssignASCII("cancel_reason");
        extraValues.EmplaceBack(cancelReason.value());
      }
      if (cancelled) {
        extraKeys.AppendElement()->AssignASCII("cancelled");
        extraValues.AppendElement()->AssignASCII(cancelled.value() ? "true" : "false");
      }
      if (fileName) {
        extraKeys.AppendElement()->AssignASCII("file_name");
        extraValues.EmplaceBack(fileName.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.AppendElement()->AssignASCII(sync.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collection of zero_byte_load events as part of the Yellow Screen of Death analysis. When a file is loaded synchronously, this event gets recorded in nsJARChannel::Open if the content length is zero. For asynchronous loads, this event gets recorded in onStopRequest. Note that when the load has been cancelled, the consumer could already receive some data, so this event also captures non-zero-byte loads. This event was generated to correspond to the Legacy Telemetry event zero_byte_load.load#json.
   */
  constexpr impl::EventMetric<LoadJsonExtra> load_json(4262);

  /**
   * generated from zero_byte_load.load_others
   */
  struct LoadOthersExtra {
    mozilla::Maybe<nsCString> cancelReason;
    mozilla::Maybe<bool> cancelled;
    mozilla::Maybe<nsCString> fileName;
    mozilla::Maybe<nsCString> status;
    mozilla::Maybe<bool> sync;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cancelReason) {
        extraKeys.AppendElement()->AssignASCII("cancel_reason");
        extraValues.EmplaceBack(cancelReason.value());
      }
      if (cancelled) {
        extraKeys.AppendElement()->AssignASCII("cancelled");
        extraValues.AppendElement()->AssignASCII(cancelled.value() ? "true" : "false");
      }
      if (fileName) {
        extraKeys.AppendElement()->AssignASCII("file_name");
        extraValues.EmplaceBack(fileName.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.AppendElement()->AssignASCII(sync.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collection of zero_byte_load events as part of the Yellow Screen of Death analysis. When a file is loaded synchronously, this event gets recorded in nsJARChannel::Open if the content length is zero. For asynchronous loads, this event gets recorded in onStopRequest. Note that when the load has been cancelled, the consumer could already receive some data, so this event also captures non-zero-byte loads. This event was generated to correspond to the Legacy Telemetry event zero_byte_load.load#others.
   */
  constexpr impl::EventMetric<LoadOthersExtra> load_others(4263);

  /**
   * generated from zero_byte_load.load_png
   */
  struct LoadPngExtra {
    mozilla::Maybe<nsCString> cancelReason;
    mozilla::Maybe<bool> cancelled;
    mozilla::Maybe<nsCString> fileName;
    mozilla::Maybe<nsCString> status;
    mozilla::Maybe<bool> sync;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cancelReason) {
        extraKeys.AppendElement()->AssignASCII("cancel_reason");
        extraValues.EmplaceBack(cancelReason.value());
      }
      if (cancelled) {
        extraKeys.AppendElement()->AssignASCII("cancelled");
        extraValues.AppendElement()->AssignASCII(cancelled.value() ? "true" : "false");
      }
      if (fileName) {
        extraKeys.AppendElement()->AssignASCII("file_name");
        extraValues.EmplaceBack(fileName.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.AppendElement()->AssignASCII(sync.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collection of zero_byte_load events as part of the Yellow Screen of Death analysis. When a file is loaded synchronously, this event gets recorded in nsJARChannel::Open if the content length is zero. For asynchronous loads, this event gets recorded in onStopRequest. Note that when the load has been cancelled, the consumer could already receive some data, so this event also captures non-zero-byte loads. This event was generated to correspond to the Legacy Telemetry event zero_byte_load.load#png.
   */
  constexpr impl::EventMetric<LoadPngExtra> load_png(4264);

  /**
   * generated from zero_byte_load.load_properties
   */
  struct LoadPropertiesExtra {
    mozilla::Maybe<nsCString> cancelReason;
    mozilla::Maybe<bool> cancelled;
    mozilla::Maybe<nsCString> fileName;
    mozilla::Maybe<nsCString> status;
    mozilla::Maybe<bool> sync;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cancelReason) {
        extraKeys.AppendElement()->AssignASCII("cancel_reason");
        extraValues.EmplaceBack(cancelReason.value());
      }
      if (cancelled) {
        extraKeys.AppendElement()->AssignASCII("cancelled");
        extraValues.AppendElement()->AssignASCII(cancelled.value() ? "true" : "false");
      }
      if (fileName) {
        extraKeys.AppendElement()->AssignASCII("file_name");
        extraValues.EmplaceBack(fileName.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.AppendElement()->AssignASCII(sync.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collection of zero_byte_load events as part of the Yellow Screen of Death analysis. When a file is loaded synchronously, this event gets recorded in nsJARChannel::Open if the content length is zero. For asynchronous loads, this event gets recorded in onStopRequest. Note that when the load has been cancelled, the consumer could already receive some data, so this event also captures non-zero-byte loads. This event was generated to correspond to the Legacy Telemetry event zero_byte_load.load#properties.
   */
  constexpr impl::EventMetric<LoadPropertiesExtra> load_properties(4265);

  /**
   * generated from zero_byte_load.load_svg
   */
  struct LoadSvgExtra {
    mozilla::Maybe<nsCString> cancelReason;
    mozilla::Maybe<bool> cancelled;
    mozilla::Maybe<nsCString> fileName;
    mozilla::Maybe<nsCString> status;
    mozilla::Maybe<bool> sync;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cancelReason) {
        extraKeys.AppendElement()->AssignASCII("cancel_reason");
        extraValues.EmplaceBack(cancelReason.value());
      }
      if (cancelled) {
        extraKeys.AppendElement()->AssignASCII("cancelled");
        extraValues.AppendElement()->AssignASCII(cancelled.value() ? "true" : "false");
      }
      if (fileName) {
        extraKeys.AppendElement()->AssignASCII("file_name");
        extraValues.EmplaceBack(fileName.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.AppendElement()->AssignASCII(sync.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collection of zero_byte_load events as part of the Yellow Screen of Death analysis. When a file is loaded synchronously, this event gets recorded in nsJARChannel::Open if the content length is zero. For asynchronous loads, this event gets recorded in onStopRequest. Note that when the load has been cancelled, the consumer could already receive some data, so this event also captures non-zero-byte loads. This event was generated to correspond to the Legacy Telemetry event zero_byte_load.load#svg.
   */
  constexpr impl::EventMetric<LoadSvgExtra> load_svg(4266);

  /**
   * generated from zero_byte_load.load_xhtml
   */
  struct LoadXhtmlExtra {
    mozilla::Maybe<nsCString> cancelReason;
    mozilla::Maybe<bool> cancelled;
    mozilla::Maybe<nsCString> fileName;
    mozilla::Maybe<nsCString> status;
    mozilla::Maybe<bool> sync;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cancelReason) {
        extraKeys.AppendElement()->AssignASCII("cancel_reason");
        extraValues.EmplaceBack(cancelReason.value());
      }
      if (cancelled) {
        extraKeys.AppendElement()->AssignASCII("cancelled");
        extraValues.AppendElement()->AssignASCII(cancelled.value() ? "true" : "false");
      }
      if (fileName) {
        extraKeys.AppendElement()->AssignASCII("file_name");
        extraValues.EmplaceBack(fileName.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.AppendElement()->AssignASCII(sync.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collection of zero_byte_load events as part of the Yellow Screen of Death analysis. When a file is loaded synchronously, this event gets recorded in nsJARChannel::Open if the content length is zero. For asynchronous loads, this event gets recorded in onStopRequest. Note that when the load has been cancelled, the consumer could already receive some data, so this event also captures non-zero-byte loads. This event was generated to correspond to the Legacy Telemetry event zero_byte_load.load#xhtml.
   */
  constexpr impl::EventMetric<LoadXhtmlExtra> load_xhtml(4267);

  /**
   * generated from zero_byte_load.load_xml
   */
  struct LoadXmlExtra {
    mozilla::Maybe<nsCString> cancelReason;
    mozilla::Maybe<bool> cancelled;
    mozilla::Maybe<nsCString> fileName;
    mozilla::Maybe<nsCString> status;
    mozilla::Maybe<bool> sync;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cancelReason) {
        extraKeys.AppendElement()->AssignASCII("cancel_reason");
        extraValues.EmplaceBack(cancelReason.value());
      }
      if (cancelled) {
        extraKeys.AppendElement()->AssignASCII("cancelled");
        extraValues.AppendElement()->AssignASCII(cancelled.value() ? "true" : "false");
      }
      if (fileName) {
        extraKeys.AppendElement()->AssignASCII("file_name");
        extraValues.EmplaceBack(fileName.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.AppendElement()->AssignASCII(sync.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collection of zero_byte_load events as part of the Yellow Screen of Death analysis. When a file is loaded synchronously, this event gets recorded in nsJARChannel::Open if the content length is zero. For asynchronous loads, this event gets recorded in onStopRequest. Note that when the load has been cancelled, the consumer could already receive some data, so this event also captures non-zero-byte loads. This event was generated to correspond to the Legacy Telemetry event zero_byte_load.load#xml.
   */
  constexpr impl::EventMetric<LoadXmlExtra> load_xml(4268);
}

} // namespace mozilla::glean

#endif // mozilla_GleanLibjarMetrics_h
