// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanAntitrackingBouncetrackingprotectionMetrics_h
#define mozilla_GleanAntitrackingBouncetrackingprotectionMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace bounce_tracking_protection {
  /**
   * generated from bounce.tracking.protection.mode
   * Records the pref value of privacy.bounceTrackingProtection.mode. Values are any of nsIBounceTrackingProtection#Modes.
   */
  constexpr impl::QuantityMetric mode(4629);

  /**
   * generated from bounce.tracking.protection.num_hosts_per_purge_run
   * Number of bounce trackers purged successfully per scheduled purge.
   */
  constexpr impl::CustomDistributionMetric num_hosts_per_purge_run(4630);

  /**
   * generated from bounce.tracking.protection.purge_action
   */
  struct PurgeActionExtra {
    mozilla::Maybe<uint32_t> bounceTime;
    mozilla::Maybe<bool> isDryRun;
    mozilla::Maybe<bool> requireStatefulBounces;
    mozilla::Maybe<nsCString> siteHost;
    mozilla::Maybe<bool> success;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (bounceTime) {
        extraKeys.AppendElement()->AssignASCII("bounce_time");
        extraValues.AppendElement()->AppendInt(bounceTime.value());
      }
      if (isDryRun) {
        extraKeys.AppendElement()->AssignASCII("is_dry_run");
        extraValues.AppendElement()->AssignASCII(isDryRun.value() ? "true" : "false");
      }
      if (requireStatefulBounces) {
        extraKeys.AppendElement()->AssignASCII("require_stateful_bounces");
        extraValues.AppendElement()->AssignASCII(requireStatefulBounces.value() ? "true" : "false");
      }
      if (siteHost) {
        extraKeys.AppendElement()->AssignASCII("site_host");
        extraValues.EmplaceBack(siteHost.value());
      }
      if (success) {
        extraKeys.AppendElement()->AssignASCII("success");
        extraValues.AppendElement()->AssignASCII(success.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched whenever a bounce tracker site is purged.
   */
  constexpr impl::EventMetric<PurgeActionExtra> purge_action(4631);

  /**
   * generated from bounce.tracking.protection.purge_count
   */
  enum class PurgeCountLabel: uint16_t {
    eSuccess = 0,
    eFailure = 1,
    eDry = 2,
    e__Other__,
  };
  /**
   * Counts how often we purge trackers. Giving a high level overview about the effectivness of bounce tracking protection. Allows determining error rate with failure/success label. When in dry mode, we count the purges that would have happened under the dry label.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, PurgeCountLabel> purge_count(4632);

  /**
   * generated from bounce.tracking.protection.purge_count_classified_tracker
   * Counts sites purged from BTP that are classified as trackers as part of the following lists: [emailtracking-protection, fingerprinting-protection, socialtracking-protection, tracking-protection]
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> purge_count_classified_tracker(4633);

  /**
   * generated from bounce.tracking.protection.purge_duration
   * For every purge that is scheduled, we call the ClearDataService to purge persistent storage for each detected bounce tracker. This may do some blocking work on main thread and dispatch some cleanups to other threads. Collect telemetry on how long it takes to clear in the wild to determine whether we need to improve performance here.
   */
  constexpr impl::TimingDistributionMetric purge_duration(4634);
}

} // namespace mozilla::glean

#endif // mozilla_GleanAntitrackingBouncetrackingprotectionMetrics_h
