// -*- mode: C++ -*-

// AUTOGENERATED BY toolkit/components/gecko_trace/scripts/codegen.py DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/. */

#ifndef GECKO_TRACE_GENERATED_EVENTS_E3B0C44298FC1C1_H
#define GECKO_TRACE_GENERATED_EVENTS_E3B0C44298FC1C1_H

#include "mozilla/Maybe.h"

#include "mozilla/gecko_trace/SpanEvent.h"


namespace mozilla::gecko_trace {

/**
 * Namespace containing auto-generated event classes for GeckoTrace.
 *
 * Each event class corresponds to a trace event definition and provides
 * a builder-pattern interface for setting attributes before emission.
 */
namespace events {

/**
 * Trace event class for "source_located" events.
 *
 *    Base event that adds source-code location capture
 *
 * Generated from: toolkit/components/gecko-trace/gecko-trace.yaml:11:4
 *
 * Usage:
 *   mozilla::gecko_trace::events::SourceLocated()
 *     .WithSourceFile(source.file)
 *     .WithSourceLine(source.line)
 *	   .Emit();
 *
 * Attributes:
 *   - source.file (string): Source file where the event was emitted
 *   - source.line (integer): Line number where the event was emitted
 */
template <class T>
class SourceLocatedEventBase : public virtual SpanEvent {
 public:
  /**
   * Set the source.file attribute for this trace event.
   *
   *    Source file where the event was emitted
   *
   * @param aSourceFile The source.file value
   *                     (type: std::string_view)
   * @return Reference to this event object for method chaining
   */
  T& WithSourceFile(std::string_view aSourceFile) {
    mSourceFile = mozilla::Some(aSourceFile);
    return static_cast<T&>(*this);
  }
  /**
   * Set the source.line attribute for this trace event.
   *
   *    Line number where the event was emitted
   *
   * @param aSourceLine The source.line value
   *                     (type: int64_t)
   * @return Reference to this event object for method chaining
   */
  T& WithSourceLine(int64_t aSourceLine) {
    mSourceLine = mozilla::Some(aSourceLine);
    return static_cast<T&>(*this);
  }

  bool ForEachKeyValue(
      std::function<bool(std::string_view, AttributeValue)> aCallback)
      const override {
    // Process this event's attributes
    if (mSourceFile.isSome() &&
        !aCallback("source.file",
                   AttributeValue(mSourceFile.value()))) {
      return false;
    }
    if (mSourceLine.isSome() &&
        !aCallback("source.line",
                   AttributeValue(mSourceLine.value()))) {
      return false;
    }

    return true;
  }

  std::string_view GetEventName() const override {
    return "source_located";
  }

  size_t Size() const override {
    size_t size = 2;
    return size;
  }

 private:
  mozilla::Maybe<std::string_view> mSourceFile;
  mozilla::Maybe<int64_t> mSourceLine;
};

class SourceLocatedEvent : public SourceLocatedEventBase<SourceLocatedEvent> { };

/**
 * Trace event class for "dom.quota.try" events.
 *
 *    An event recorded on an error of the quota manager or its clients.
 *
 * Generated from: dom/quota/gecko-trace.yaml:3:4
 *
 * Usage:
 *   mozilla::gecko_trace::events::DomQuotaTry()
 *     .WithFrameId(frame_id)
 *     .WithResult(result)
 *     .WithSeverity(severity)
 *	   .Emit();
 *
 * Inherits from:
 *   - SourceLocatedEvent
 *
 * Attributes:
 *   - frame_id (string): Optionally, the frame within stack_id.
 *   - result (string): Optionally, the name of the error that occurred.
 *   - severity (string): One of WARNING or ERROR.
 */
template <class T>
class DomQuotaTryEventBase : public SourceLocatedEventBase<T> {
 public:
  /**
   * Set the frame_id attribute for this trace event.
   *
   *    Optionally, the frame within stack_id.
   *
   * @param aFrameId The frame_id value
   *                     (type: std::string_view)
   * @return Reference to this event object for method chaining
   */
  T& WithFrameId(std::string_view aFrameId) {
    mFrameId = mozilla::Some(aFrameId);
    return static_cast<T&>(*this);
  }
  /**
   * Set the result attribute for this trace event.
   *
   *    Optionally, the name of the error that occurred.
   *
   * @param aResult The result value
   *                     (type: std::string_view)
   * @return Reference to this event object for method chaining
   */
  T& WithResult(std::string_view aResult) {
    mResult = mozilla::Some(aResult);
    return static_cast<T&>(*this);
  }
  /**
   * Set the severity attribute for this trace event.
   *
   *    One of WARNING or ERROR.
   *
   * @param aSeverity The severity value
   *                     (type: std::string_view)
   * @return Reference to this event object for method chaining
   */
  T& WithSeverity(std::string_view aSeverity) {
    mSeverity = mozilla::Some(aSeverity);
    return static_cast<T&>(*this);
  }

  bool ForEachKeyValue(
      std::function<bool(std::string_view, AttributeValue)> aCallback)
      const override {
    // Process attributes from parent classes first
    if (!SourceLocatedEventBase<T>::ForEachKeyValue(aCallback)) {
      return false;
    }

    // Process this event's attributes
    if (mFrameId.isSome() &&
        !aCallback("frame_id",
                   AttributeValue(mFrameId.value()))) {
      return false;
    }
    if (mResult.isSome() &&
        !aCallback("result",
                   AttributeValue(mResult.value()))) {
      return false;
    }
    if (mSeverity.isSome() &&
        !aCallback("severity",
                   AttributeValue(mSeverity.value()))) {
      return false;
    }

    return true;
  }

  std::string_view GetEventName() const override {
    return "dom.quota.try";
  }

  size_t Size() const override {
    size_t size = 3;
    size += SourceLocatedEventBase<T>::Size();
    return size;
  }

 private:
  mozilla::Maybe<std::string_view> mFrameId;
  mozilla::Maybe<std::string_view> mResult;
  mozilla::Maybe<std::string_view> mSeverity;
};

class DomQuotaTryEvent : public DomQuotaTryEventBase<DomQuotaTryEvent> { };

}  // namespace events

/**
 * Namespace containing factory functions for creating trace events.
 *
 * These functions provide a convenient way to create event objects using
 * the builder pattern. Each function returns an event object that can be
 * configured with attributes and then emitted.
 *
 * Example usage:
 *   mozilla::gecko_trace::events::SomeEvent()
 *     .WithAttribute1(value1)
 *     .WithAttribute2(value2)
 *     .Emit();
 */
namespace event {

/**
 * Create a new source_located trace event.
 *
 *  Base event that adds source-code location capture
 *
 * @return A new SourceLocatedEvent instance ready for
 *         configuration
 */
inline events::SourceLocatedEvent SourceLocated() {
  return events::SourceLocatedEvent{};
}

/**
 * Create a new dom.quota.try trace event.
 *
 *  An event recorded on an error of the quota manager or its clients.
 *
 * @return A new DomQuotaTryEvent instance ready for
 *         configuration
 */
inline events::DomQuotaTryEvent DomQuotaTry() {
  return events::DomQuotaTryEvent{};
}

}  // namespace event

}  // namespace mozilla::gecko_trace

#endif  // GECKO_TRACE_GENERATED_EVENTS_E3B0C44298FC1C1_H