// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "mozilla/glean/bindings/GleanJSPingsLookup.h"

#include "mozilla/PerfectHash.h"
#include "nsString.h"

#include "mozilla/PerfectHash.h"

#define GLEAN_PING_INDEX_BITS (16)
#define GLEAN_PING_ID(entry) ((entry) >> GLEAN_PING_INDEX_BITS)
#define GLEAN_PING_INDEX(entry) ((entry) & ((1UL << GLEAN_PING_INDEX_BITS) - 1))

namespace mozilla::glean {

// Contains the ping id and the index into the ping string table.
using ping_entry_t = uint32_t;

Maybe<uint32_t> ping_result_check(const nsACString& aKey, ping_entry_t aEntry);

#if defined(_MSC_VER) && !defined(__clang__)
const char gPingStringTable[] = {
#else
constexpr char gPingStringTable[] = {
#endif
  /*     0 - "messagingSystem" */ 'm', 'e', 's', 's', 'a', 'g', 'i', 'n', 'g', 'S', 'y', 's', 't', 'e', 'm', '\0',
  /*    16 - "microsurvey" */ 'm', 'i', 'c', 'r', 'o', 's', 'u', 'r', 'v', 'e', 'y', '\0',
  /*    28 - "postProfileRestore" */ 'p', 'o', 's', 't', 'P', 'r', 'o', 'f', 'i', 'l', 'e', 'R', 'e', 's', 't', 'o', 'r', 'e', '\0',
  /*    47 - "profileRestore" */ 'p', 'r', 'o', 'f', 'i', 'l', 'e', 'R', 'e', 's', 't', 'o', 'r', 'e', '\0',
  /*    62 - "newtab" */ 'n', 'e', 'w', 't', 'a', 'b', '\0',
  /*    69 - "newtabContent" */ 'n', 'e', 'w', 't', 'a', 'b', 'C', 'o', 'n', 't', 'e', 'n', 't', '\0',
  /*    83 - "spoc" */ 's', 'p', 'o', 'c', '\0',
  /*    88 - "topSites" */ 't', 'o', 'p', 'S', 'i', 't', 'e', 's', '\0',
  /*    97 - "profiles" */ 'p', 'r', 'o', 'f', 'i', 'l', 'e', 's', '\0',
  /*   106 - "searchWith" */ 's', 'e', 'a', 'r', 'c', 'h', 'W', 'i', 't', 'h', '\0',
  /*   117 - "serpCategorization" */ 's', 'e', 'r', 'p', 'C', 'a', 't', 'e', 'g', 'o', 'r', 'i', 'z', 'a', 't', 'i', 'o', 'n', '\0',
  /*   136 - "quickSuggest" */ 'q', 'u', 'i', 'c', 'k', 'S', 'u', 'g', 'g', 'e', 's', 't', '\0',
  /*   149 - "quickSuggestDeletionRequest" */ 'q', 'u', 'i', 'c', 'k', 'S', 'u', 'g', 'g', 'e', 's', 't', 'D', 'e', 'l', 'e', 't', 'i', 'o', 'n', 'R', 'e', 'q', 'u', 'e', 's', 't', '\0',
  /*   177 - "urlbarKeywordExposure" */ 'u', 'r', 'l', 'b', 'a', 'r', 'K', 'e', 'y', 'w', 'o', 'r', 'd', 'E', 'x', 'p', 'o', 's', 'u', 'r', 'e', '\0',
  /*   199 - "dataLeakBlocker" */ 'd', 'a', 't', 'a', 'L', 'e', 'a', 'k', 'B', 'l', 'o', 'c', 'k', 'e', 'r', '\0',
  /*   215 - "contextIdDeletionRequest" */ 'c', 'o', 'n', 't', 'e', 'x', 't', 'I', 'd', 'D', 'e', 'l', 'e', 't', 'i', 'o', 'n', 'R', 'e', 'q', 'u', 'e', 's', 't', '\0',
  /*   240 - "prototypeNoCodeEvents" */ 'p', 'r', 'o', 't', 'o', 't', 'y', 'p', 'e', 'N', 'o', 'C', 'o', 'd', 'e', 'E', 'v', 'e', 'n', 't', 's', '\0',
  /*   262 - "pageload" */ 'p', 'a', 'g', 'e', 'l', 'o', 'a', 'd', '\0',
  /*   271 - "pageloadBaseDomain" */ 'p', 'a', 'g', 'e', 'l', 'o', 'a', 'd', 'B', 'a', 's', 'e', 'D', 'o', 'm', 'a', 'i', 'n', '\0',
  /*   290 - "useCounters" */ 'u', 's', 'e', 'C', 'o', 'u', 'n', 't', 'e', 'r', 's', '\0',
  /*   302 - "unexpectedScriptLoad" */ 'u', 'n', 'e', 'x', 'p', 'e', 'c', 't', 'e', 'd', 'S', 'c', 'r', 'i', 'p', 't', 'L', 'o', 'a', 'd', '\0',
  /*   323 - "localNetworkAccess" */ 'l', 'o', 'c', 'a', 'l', 'N', 'e', 't', 'w', 'o', 'r', 'k', 'A', 'c', 'c', 'e', 's', 's', '\0',
  /*   342 - "urlClassifierHarmfulAddon" */ 'u', 'r', 'l', 'C', 'l', 'a', 's', 's', 'i', 'f', 'i', 'e', 'r', 'H', 'a', 'r', 'm', 'f', 'u', 'l', 'A', 'd', 'd', 'o', 'n', '\0',
  /*   368 - "fxAccounts" */ 'f', 'x', 'A', 'c', 'c', 'o', 'u', 'n', 't', 's', '\0',
  /*   379 - "sync" */ 's', 'y', 'n', 'c', '\0',
  /*   384 - "bounceTrackingProtection" */ 'b', 'o', 'u', 'n', 'c', 'e', 'T', 'r', 'a', 'c', 'k', 'i', 'n', 'g', 'P', 'r', 'o', 't', 'e', 'c', 't', 'i', 'o', 'n', '\0',
  /*   409 - "hangReport" */ 'h', 'a', 'n', 'g', 'R', 'e', 'p', 'o', 'r', 't', '\0',
  /*   420 - "backgroundTasks" */ 'b', 'a', 'c', 'k', 'g', 'r', 'o', 'u', 'n', 'd', 'T', 'a', 's', 'k', 's', '\0',
  /*   436 - "captchaDetection" */ 'c', 'a', 'p', 't', 'c', 'h', 'a', 'D', 'e', 't', 'e', 'c', 't', 'i', 'o', 'n', '\0',
  /*   453 - "geckoTrace" */ 'g', 'e', 'c', 'k', 'o', 'T', 'r', 'a', 'c', 'e', '\0',
  /*   464 - "dauReporting" */ 'd', 'a', 'u', 'R', 'e', 'p', 'o', 'r', 't', 'i', 'n', 'g', '\0',
  /*   477 - "collectionDisabledPing" */ 'c', 'o', 'l', 'l', 'e', 'c', 't', 'i', 'o', 'n', 'D', 'i', 's', 'a', 'b', 'l', 'e', 'd', 'P', 'i', 'n', 'g', '\0',
  /*   500 - "disabledPing" */ 'd', 'i', 's', 'a', 'b', 'l', 'e', 'd', 'P', 'i', 'n', 'g', '\0',
  /*   513 - "onePingOnly" */ 'o', 'n', 'e', 'P', 'i', 'n', 'g', 'O', 'n', 'l', 'y', '\0',
  /*   525 - "rideAlongPing" */ 'r', 'i', 'd', 'e', 'A', 'l', 'o', 'n', 'g', 'P', 'i', 'n', 'g', '\0',
  /*   539 - "testOhttpPing" */ 't', 'e', 's', 't', 'O', 'h', 't', 't', 'p', 'P', 'i', 'n', 'g', '\0',
  /*   553 - "testPing" */ 't', 'e', 's', 't', 'P', 'i', 'n', 'g', '\0',
  /*   562 - "heartbeat" */ 'h', 'e', 'a', 'r', 't', 'b', 'e', 'a', 't', '\0',
  /*   572 - "nimbusTargetingContext" */ 'n', 'i', 'm', 'b', 'u', 's', 'T', 'a', 'r', 'g', 'e', 't', 'i', 'n', 'g', 'C', 'o', 'n', 't', 'e', 'x', 't', '\0',
  /*   595 - "brokenSiteReport" */ 'b', 'r', 'o', 'k', 'e', 'n', 'S', 'i', 't', 'e', 'R', 'e', 'p', 'o', 'r', 't', '\0',
  /*   612 - "userCharacteristics" */ 'u', 's', 'e', 'r', 'C', 'h', 'a', 'r', 'a', 'c', 't', 'e', 'r', 'i', 's', 't', 'i', 'c', 's', '\0',
  /*   632 - "onboardingOptOut" */ 'o', 'n', 'b', 'o', 'a', 'r', 'd', 'i', 'n', 'g', 'O', 'p', 't', 'O', 'u', 't', '\0',
  /*   649 - "thirdPartyModules" */ 't', 'h', 'i', 'r', 'd', 'P', 'a', 'r', 't', 'y', 'M', 'o', 'd', 'u', 'l', 'e', 's', '\0',
  /*   667 - "usageDeletionRequest" */ 'u', 's', 'a', 'g', 'e', 'D', 'e', 'l', 'e', 't', 'i', 'o', 'n', 'R', 'e', 'q', 'u', 'e', 's', 't', '\0',
  /*   688 - "usageReporting" */ 'u', 's', 'a', 'g', 'e', 'R', 'e', 'p', 'o', 'r', 't', 'i', 'n', 'g', '\0',
  /*   703 - "firstStartup" */ 'f', 'i', 'r', 's', 't', 'S', 't', 'a', 'r', 't', 'u', 'p', '\0',
  /*   716 - "defaultAgent" */ 'd', 'e', 'f', 'a', 'u', 'l', 't', 'A', 'g', 'e', 'n', 't', '\0',
  /*   729 - "addons" */ 'a', 'd', 'd', 'o', 'n', 's', '\0',
  /*   736 - "backgroundUpdate" */ 'b', 'a', 'c', 'k', 'g', 'r', 'o', 'u', 'n', 'd', 'U', 'p', 'd', 'a', 't', 'e', '\0',
  /*   753 - "update" */ 'u', 'p', 'd', 'a', 't', 'e', '\0',
};



const ping_entry_t sPingByNameLookupEntries[] = {
  721013,
  1769881,
  589921,
  2818697,
  1966533,
  655466,
  786568,
  2753144,
  2622035,
  1114352,
  458835,
  2097629,
  65536,
  1048791,
  1835428,
  2032080,
  983239,
  196636,
  2294285,
  1245455,
  2425385,
  1573232,
  1507670,
  2884251,
  1311010,
  1442115,
  2359835,
  3146457,
  3080908,
  917681,
  1376558,
  393285,
  1638779,
  3212000,
  852117,
  327742,
  2687588,
  2490930,
  1704320,
  2163188,
  1900980,
  2228737,
  262191,
  2949808,
  2556476,
  524376,
  1179910,
  131088,
  3277553,
  3015359
};



Maybe<uint32_t>
PingByNameLookup(const nsACString& aKey)
{
  static const uint8_t BASES[] = {
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   0,   0,   0,   1,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   1,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,
       0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   2,   0,   0,   0,
       0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   2,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,
       3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  65,   0,   0,   0,   0,   1,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  68,   0,   0,   0,
       0,   0,   0,   0,   0,   0,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  };
  

  const char* bytes = aKey.BeginReading();
  size_t length = aKey.Length();
  auto& entry = mozilla::perfecthash::Lookup(bytes, length, BASES,
                                             sPingByNameLookupEntries);
  return ping_result_check(aKey, entry);
}


/**
 * Get a ping's name given its entry from the PHF.
 */
const char* GetPingName(ping_entry_t aEntry) {
  uint32_t idx = GLEAN_PING_INDEX(aEntry);
  MOZ_ASSERT(idx < sizeof(gPingStringTable), "Ping index larger than string table");
  return &gPingStringTable[idx];
}

/**
 * Check if the found entry is pointing at the correct ping.
 * PHF can false-positive a result when the key isn't present, so we check
 * for a string match. If it fails, return Nothing(). If we found it,
 * return the ping's id.
 */
Maybe<uint32_t> ping_result_check(const nsACString& aKey, ping_entry_t aEntry) {
  uint32_t idx = GLEAN_PING_INDEX(aEntry);
  uint32_t id = GLEAN_PING_ID(aEntry);

  if (MOZ_UNLIKELY(idx > sizeof(gPingStringTable))) {
    return Nothing();
  }

  if (aKey.EqualsASCII(&gPingStringTable[idx])) {
    return Some(id);
  }

  return Nothing();
}

#undef GLEAN_PING_INDEX_BITS
#undef GLEAN_PING_ID
#undef GLEAN_PING_INDEX

}  // namespace mozilla::glean
