//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PClientHandleParent.h"
#include "ipc/ErrorIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingIPCUtils.h"
#include "mozilla/dom/ClientIPCUtils.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"

#include "mozilla/dom/PClientManagerParent.h"
#include "mozilla/dom/PClientHandleOpParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PClientHandleParent::RecvPClientHandleOpConstructor(
        PClientHandleOpParent* actor,
        const ClientOpConstructorArgs& aArgs) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PClientHandleParent::PClientHandleParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PClientHandleParent);
}

PClientHandleParent::~PClientHandleParent()
{
    MOZ_COUNT_DTOR(PClientHandleParent);
}

auto PClientHandleParent::ActorAlloc() -> void
{
    AddRef();
}

auto PClientHandleParent::ActorDealloc() -> void
{
    Release();
}

auto PClientHandleParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PClientHandleParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PClientHandleParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PClientHandleParent::Manager() const -> PClientManagerParent*
{
    return static_cast<PClientManagerParent*>(IProtocol::Manager());
}

auto PClientHandleParent::ManagedPClientHandleOpParent(nsTArray<PClientHandleOpParent*>& aArr) const -> void
{
    mManagedPClientHandleOpParent.ToArray(aArr);
}

auto PClientHandleParent::ManagedPClientHandleOpParent() const -> const ManagedContainer<PClientHandleOpParent>&
{
    return mManagedPClientHandleOpParent;
}

auto PClientHandleParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PClientHandleOpMsgStart
    };
    return sIds;
}

auto PClientHandleParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PClientHandleOpMsgStart:
        return (&(mManagedPClientHandleOpParent));
    default:
        return nullptr;
    }
}

auto PClientHandleParent::OpenPClientHandleOpEndpoint(PClientHandleOpParent* aActor) -> ManagedEndpoint<PClientHandleOpChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PClientHandleOpParent actor");
        return ManagedEndpoint<PClientHandleOpChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientHandleOpParent actor");
        return ManagedEndpoint<PClientHandleOpChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PClientHandleOpChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PClientHandleParent::BindPClientHandleOpEndpoint(
        ManagedEndpoint<PClientHandleOpParent> aEndpoint,
        PClientHandleOpParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PClientHandleParent::SendExecutionReady(const IPCClientInfo& aClientInfo) -> bool
{
    UniquePtr<IPC::Message> msg__ = PClientHandle::Msg_ExecutionReady(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aClientInfo);
    // Sentinel = 'aClientInfo'
    ((&(writer__)))->WriteSentinel(422315085);


    if (mozilla::ipc::LoggingEnabledFor("PClientHandle", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientHandleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientHandle::Msg_ExecutionReady", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PClientHandleParent::Send__delete__(PClientHandleParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PClientHandle::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PClientHandle", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientHandleParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientHandle::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PClientHandleParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PClientHandleOpMsgStart:
        this->DeallocPClientHandleOpParent(static_cast<PClientHandleOpParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PClientHandleParent::OnMessageReceived(const Message& msg__) -> PClientHandleParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PClientHandle::Msg_Teardown__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientHandle", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientHandleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientHandle::Msg_Teardown", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvTeardown();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientHandle::Msg_PClientHandleOpConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientHandle", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientHandleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientHandle::Msg_PClientHandleOpConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__aArgs = IPC::ReadParam<ClientOpConstructorArgs>((&(reader__)));
            if (!maybe__aArgs) {
                FatalError("Error deserializing 'ClientOpConstructorArgs'");
                return MsgValueError;

            }
            auto& aArgs = *maybe__aArgs;
            // Sentinel = 'aArgs'
            if ((!(((&(reader__)))->ReadSentinel(92602863)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ClientOpConstructorArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            // Ensure the ID which was sent to us is valid, and reserve a spot
            // in the table for the new actor before we bother to alloc it.
            if (!ToplevelProtocol()->TryReserve(actorid__)) {
                NS_WARNING("Failed to reserve ActorId for constructor");
                return MsgValueError;
            }

            PClientHandleOpParent* actor = (this)->AllocPClientHandleOpParent(aArgs);

            if (!actor) {
                NS_WARNING("Alloc function returned null");
                // Clean up the reservation taken above if this fails, to avoid
                // leaving zombie entries in the map.
                ToplevelProtocol()->ClearReservation(actorid__);
                return MsgValueError;
            }

            // NOTE: SetManagerAndRegister unconditionally consumes the
            // reservation taken by TryReserve, so we don't need to clear it on
            // failure.
            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to set manager for constructor");
                return MsgValueError;
            }
            mozilla::ipc::IPCResult __ok = (this)->RecvPClientHandleOpConstructor(std::move(actor), std::move(aArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientHandle::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PClientHandleParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PClientHandleParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PClientHandleParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PClientHandle'
    (aWriter)->WriteSentinel(568198396);
}

auto ParamTraits<::mozilla::dom::PClientHandleParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PClientHandle actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PClientHandle'
    if ((!((aReader)->ReadSentinel(568198396)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PClientHandle actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PClientHandleMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PClientHandle)");

        return {};
    }
    return static_cast<::mozilla::dom::PClientHandleParent*>(actor);
}

} // namespace IPC
