//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PBackgroundSessionStorageManagerParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/quota/SerializationHelpers.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/ipc/PBackgroundParent.h"
#include "mozilla/dom/PBackgroundSessionStorageCacheParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PBackgroundSessionStorageManagerParent::RecvPBackgroundSessionStorageCacheConstructor(
        PBackgroundSessionStorageCacheParent* actor,
        const PrincipalInfo& aPrincipalInfo,
        const nsACString& aOriginKey) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBackgroundSessionStorageManagerParent::PBackgroundSessionStorageManagerParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PBackgroundSessionStorageManagerParent);
}

PBackgroundSessionStorageManagerParent::~PBackgroundSessionStorageManagerParent()
{
    MOZ_COUNT_DTOR(PBackgroundSessionStorageManagerParent);
}

auto PBackgroundSessionStorageManagerParent::ActorAlloc() -> void
{
    AddRef();
}

auto PBackgroundSessionStorageManagerParent::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundSessionStorageManagerParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundSessionStorageManagerParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundSessionStorageManagerParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundSessionStorageManagerParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PBackgroundSessionStorageManagerParent::ManagedPBackgroundSessionStorageCacheParent(nsTArray<PBackgroundSessionStorageCacheParent*>& aArr) const -> void
{
    mManagedPBackgroundSessionStorageCacheParent.ToArray(aArr);
}

auto PBackgroundSessionStorageManagerParent::ManagedPBackgroundSessionStorageCacheParent() const -> const ManagedContainer<PBackgroundSessionStorageCacheParent>&
{
    return mManagedPBackgroundSessionStorageCacheParent;
}

auto PBackgroundSessionStorageManagerParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PBackgroundSessionStorageCacheMsgStart
    };
    return sIds;
}

auto PBackgroundSessionStorageManagerParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PBackgroundSessionStorageCacheMsgStart:
        return (&(mManagedPBackgroundSessionStorageCacheParent));
    default:
        return nullptr;
    }
}

auto PBackgroundSessionStorageManagerParent::OpenPBackgroundSessionStorageCacheEndpoint(PBackgroundSessionStorageCacheParent* aActor) -> ManagedEndpoint<PBackgroundSessionStorageCacheChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundSessionStorageCacheParent actor");
        return ManagedEndpoint<PBackgroundSessionStorageCacheChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundSessionStorageCacheParent actor");
        return ManagedEndpoint<PBackgroundSessionStorageCacheChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundSessionStorageCacheChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundSessionStorageManagerParent::BindPBackgroundSessionStorageCacheEndpoint(
        ManagedEndpoint<PBackgroundSessionStorageCacheParent> aEndpoint,
        PBackgroundSessionStorageCacheParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundSessionStorageManagerParent::Send__delete__(PBackgroundSessionStorageManagerParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PBackgroundSessionStorageManager::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PBackgroundSessionStorageManager", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundSessionStorageManagerParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundSessionStorageManager::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PBackgroundSessionStorageManagerParent::SendClearStoragesForOrigin(
        const nsACString& aOriginAttrs,
        const nsACString& aOriginKey) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundSessionStorageManager::Msg_ClearStoragesForOrigin(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aOriginAttrs);
    // Sentinel = 'aOriginAttrs'
    ((&(writer__)))->WriteSentinel(513082584);
    IPC::WriteParam((&(writer__)), aOriginKey);
    // Sentinel = 'aOriginKey'
    ((&(writer__)))->WriteSentinel(358417395);


    if (mozilla::ipc::LoggingEnabledFor("PBackgroundSessionStorageManager", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundSessionStorageManagerParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundSessionStorageManager::Msg_ClearStoragesForOrigin", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundSessionStorageManagerParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    default:
        FatalError("unreached");
        return;
    }
}

auto PBackgroundSessionStorageManagerParent::OnMessageReceived(const Message& msg__) -> PBackgroundSessionStorageManagerParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundSessionStorageManager::Msg_PBackgroundSessionStorageCacheConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundSessionStorageManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundSessionStorageManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundSessionStorageManager::Msg_PBackgroundSessionStorageCacheConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__aPrincipalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__aPrincipalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& aPrincipalInfo = *maybe__aPrincipalInfo;
            // Sentinel = 'aPrincipalInfo'
            if ((!(((&(reader__)))->ReadSentinel(695272848)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            auto maybe__aOriginKey = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aOriginKey) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aOriginKey = *maybe__aOriginKey;
            // Sentinel = 'aOriginKey'
            if ((!(((&(reader__)))->ReadSentinel(358417395)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            // Ensure the ID which was sent to us is valid, and reserve a spot
            // in the table for the new actor before we bother to alloc it.
            if (!ToplevelProtocol()->TryReserve(actorid__)) {
                NS_WARNING("Failed to reserve ActorId for constructor");
                return MsgValueError;
            }

            RefPtr<PBackgroundSessionStorageCacheParent> actor = (this)->AllocPBackgroundSessionStorageCacheParent(aPrincipalInfo, aOriginKey);

            if (!actor) {
                NS_WARNING("Alloc function returned null");
                // Clean up the reservation taken above if this fails, to avoid
                // leaving zombie entries in the map.
                ToplevelProtocol()->ClearReservation(actorid__);
                return MsgValueError;
            }

            // NOTE: SetManagerAndRegister unconditionally consumes the
            // reservation taken by TryReserve, so we don't need to clear it on
            // failure.
            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to set manager for constructor");
                return MsgValueError;
            }
            mozilla::ipc::IPCResult __ok = (this)->RecvPBackgroundSessionStorageCacheConstructor(actor, std::move(aPrincipalInfo), std::move(aOriginKey));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundSessionStorageManager::Msg_ClearStorages__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundSessionStorageManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundSessionStorageManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundSessionStorageManager::Msg_ClearStorages", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPattern = IPC::ReadParam<OriginAttributesPattern>((&(reader__)));
            if (!maybe__aPattern) {
                FatalError("Error deserializing 'OriginAttributesPattern'");
                return MsgValueError;

            }
            auto& aPattern = *maybe__aPattern;
            // Sentinel = 'aPattern'
            if ((!(((&(reader__)))->ReadSentinel(236651328)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributesPattern'");
                return MsgValueError;
            }
            auto maybe__aOriginScope = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aOriginScope) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aOriginScope = *maybe__aOriginScope;
            // Sentinel = 'aOriginScope'
            if ((!(((&(reader__)))->ReadSentinel(512361668)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__aMode = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aMode) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aMode = *maybe__aMode;
            // Sentinel = 'aMode'
            if ((!(((&(reader__)))->ReadSentinel(93848039)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvClearStorages(std::move(aPattern), std::move(aOriginScope), std::move(aMode));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundSessionStorageManager::Msg_DeleteMe__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundSessionStorageManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundSessionStorageManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundSessionStorageManager::Msg_DeleteMe", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteMe();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundSessionStorageManager::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundSessionStorageManagerParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundSessionStorageManagerParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PBackgroundSessionStorageManagerParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PBackgroundSessionStorageManager'
    (aWriter)->WriteSentinel(3496152261);
}

auto ParamTraits<::mozilla::dom::PBackgroundSessionStorageManagerParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PBackgroundSessionStorageManager actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PBackgroundSessionStorageManager'
    if ((!((aReader)->ReadSentinel(3496152261)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PBackgroundSessionStorageManager actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PBackgroundSessionStorageManagerMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PBackgroundSessionStorageManager)");

        return {};
    }
    return static_cast<::mozilla::dom::PBackgroundSessionStorageManagerParent*>(actor);
}

} // namespace IPC
