/* THIS FILE IS AUTOGENERATED FROM OriginAttributes.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "OriginAttributesBinding.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



OriginAttributesDictionary::OriginAttributesDictionary()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
OriginAttributesDictionary::InitIds(JSContext* cx, OriginAttributesDictionaryAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->userContextId_id.init(cx, "userContextId") ||
      !atomsCache->privateBrowsingId_id.init(cx, "privateBrowsingId") ||
      !atomsCache->partitionKey_id.init(cx, "partitionKey") ||
      !atomsCache->geckoViewSessionContextId_id.init(cx, "geckoViewSessionContextId") ||
      !atomsCache->firstPartyDomain_id.init(cx, "firstPartyDomain")) {
    return false;
  }
  return true;
}

bool
OriginAttributesDictionary::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  OriginAttributesDictionaryAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<OriginAttributesDictionaryAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->firstPartyDomain_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mFirstPartyDomain)) {
      return false;
    }
  } else {
    mFirstPartyDomain.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->geckoViewSessionContextId_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mGeckoViewSessionContextId)) {
      return false;
    }
  } else {
    mGeckoViewSessionContextId.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->partitionKey_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mPartitionKey)) {
      return false;
    }
  } else {
    mPartitionKey.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->privateBrowsingId_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'privateBrowsingId' member of OriginAttributesDictionary", &mPrivateBrowsingId)) {
      return false;
    }
  } else {
    mPrivateBrowsingId = 0U;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->userContextId_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'userContextId' member of OriginAttributesDictionary", &mUserContextId)) {
      return false;
    }
  } else {
    mUserContextId = 0U;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
OriginAttributesDictionary::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
OriginAttributesDictionary::Init(const nsAString& aJSON)
{
  AutoJSAPI jsapi;
  JSObject* cleanGlobal = SimpleGlobalObject::Create(SimpleGlobalObject::GlobalType::BindingDetail);
  if (!cleanGlobal) {
    return false;
  }
  if (!jsapi.Init(cleanGlobal)) {
    return false;
  }
  JSContext* cx = jsapi.cx();
  JS::Rooted<JS::Value> json(cx);
  bool ok = ParseJSON(cx, aJSON, &json);
  NS_ENSURE_TRUE(ok, false);
  return Init(cx, json);
}

bool
OriginAttributesDictionary::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  OriginAttributesDictionaryAtoms* atomsCache = GetAtomCache<OriginAttributesDictionaryAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mFirstPartyDomain;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->firstPartyDomain_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mGeckoViewSessionContextId;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->geckoViewSessionContextId_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mPartitionKey;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->partitionKey_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mPrivateBrowsingId;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->privateBrowsingId_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mUserContextId;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->userContextId_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
OriginAttributesDictionary::TraceDictionary(JSTracer* trc)
{
}

OriginAttributesDictionary&
OriginAttributesDictionary::operator=(const OriginAttributesDictionary& aOther)
{
  DictionaryBase::operator=(aOther);
  mFirstPartyDomain = aOther.mFirstPartyDomain;
  mGeckoViewSessionContextId = aOther.mGeckoViewSessionContextId;
  mPartitionKey = aOther.mPartitionKey;
  mPrivateBrowsingId = aOther.mPrivateBrowsingId;
  mUserContextId = aOther.mUserContextId;
  return *this;
}

bool
OriginAttributesDictionary::operator==(const OriginAttributesDictionary& aOther) const
{
  if (mFirstPartyDomain != aOther.mFirstPartyDomain) {
      return false;
  }
  if (mGeckoViewSessionContextId != aOther.mGeckoViewSessionContextId) {
      return false;
  }
  if (mPartitionKey != aOther.mPartitionKey) {
      return false;
  }
  if (mPrivateBrowsingId != aOther.mPrivateBrowsingId) {
      return false;
  }
  if (mUserContextId != aOther.mUserContextId) {
      return false;
  }
  return true;
}



PartitionKeyPatternDictionary::PartitionKeyPatternDictionary()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
PartitionKeyPatternDictionary::InitIds(JSContext* cx, PartitionKeyPatternDictionaryAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->scheme_id.init(cx, "scheme") ||
      !atomsCache->port_id.init(cx, "port") ||
      !atomsCache->foreignByAncestorContext_id.init(cx, "foreignByAncestorContext") ||
      !atomsCache->baseDomain_id.init(cx, "baseDomain")) {
    return false;
  }
  return true;
}

bool
PartitionKeyPatternDictionary::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  PartitionKeyPatternDictionaryAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<PartitionKeyPatternDictionaryAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->baseDomain_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mBaseDomain.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mBaseDomain.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->foreignByAncestorContext_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mForeignByAncestorContext.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'foreignByAncestorContext' member of PartitionKeyPatternDictionary", &(mForeignByAncestorContext.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->port_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mPort.Construct();
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'port' member of PartitionKeyPatternDictionary", &(mPort.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->scheme_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mScheme.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mScheme.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
PartitionKeyPatternDictionary::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
PartitionKeyPatternDictionary::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  PartitionKeyPatternDictionaryAtoms* atomsCache = GetAtomCache<PartitionKeyPatternDictionaryAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mBaseDomain.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mBaseDomain.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->baseDomain_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mForeignByAncestorContext.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mForeignByAncestorContext.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->foreignByAncestorContext_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPort.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mPort.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->port_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mScheme.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mScheme.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->scheme_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
PartitionKeyPatternDictionary::TraceDictionary(JSTracer* trc)
{
}

PartitionKeyPatternDictionary&
PartitionKeyPatternDictionary::operator=(const PartitionKeyPatternDictionary& aOther)
{
  DictionaryBase::operator=(aOther);
  mBaseDomain.Reset();
  if (aOther.mBaseDomain.WasPassed()) {
    mBaseDomain.Construct(aOther.mBaseDomain.Value());
  }
  mForeignByAncestorContext.Reset();
  if (aOther.mForeignByAncestorContext.WasPassed()) {
    mForeignByAncestorContext.Construct(aOther.mForeignByAncestorContext.Value());
  }
  mPort.Reset();
  if (aOther.mPort.WasPassed()) {
    mPort.Construct(aOther.mPort.Value());
  }
  mScheme.Reset();
  if (aOther.mScheme.WasPassed()) {
    mScheme.Construct(aOther.mScheme.Value());
  }
  return *this;
}



OriginAttributesPatternDictionary::OriginAttributesPatternDictionary()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
OriginAttributesPatternDictionary::InitIds(JSContext* cx, OriginAttributesPatternDictionaryAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->userContextId_id.init(cx, "userContextId") ||
      !atomsCache->privateBrowsingId_id.init(cx, "privateBrowsingId") ||
      !atomsCache->partitionKeyPattern_id.init(cx, "partitionKeyPattern") ||
      !atomsCache->partitionKey_id.init(cx, "partitionKey") ||
      !atomsCache->geckoViewSessionContextId_id.init(cx, "geckoViewSessionContextId") ||
      !atomsCache->firstPartyDomain_id.init(cx, "firstPartyDomain")) {
    return false;
  }
  return true;
}

bool
OriginAttributesPatternDictionary::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  OriginAttributesPatternDictionaryAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<OriginAttributesPatternDictionaryAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->firstPartyDomain_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mFirstPartyDomain.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mFirstPartyDomain.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->geckoViewSessionContextId_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mGeckoViewSessionContextId.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mGeckoViewSessionContextId.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->partitionKey_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mPartitionKey.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mPartitionKey.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->partitionKeyPattern_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mPartitionKeyPattern.Construct();
    if (!(mPartitionKeyPattern.Value()).Init(cx, temp.ref(), "'partitionKeyPattern' member of OriginAttributesPatternDictionary", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->privateBrowsingId_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mPrivateBrowsingId.Construct();
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'privateBrowsingId' member of OriginAttributesPatternDictionary", &(mPrivateBrowsingId.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->userContextId_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mUserContextId.Construct();
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'userContextId' member of OriginAttributesPatternDictionary", &(mUserContextId.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
OriginAttributesPatternDictionary::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
OriginAttributesPatternDictionary::Init(const nsAString& aJSON)
{
  AutoJSAPI jsapi;
  JSObject* cleanGlobal = SimpleGlobalObject::Create(SimpleGlobalObject::GlobalType::BindingDetail);
  if (!cleanGlobal) {
    return false;
  }
  if (!jsapi.Init(cleanGlobal)) {
    return false;
  }
  JSContext* cx = jsapi.cx();
  JS::Rooted<JS::Value> json(cx);
  bool ok = ParseJSON(cx, aJSON, &json);
  NS_ENSURE_TRUE(ok, false);
  return Init(cx, json);
}

bool
OriginAttributesPatternDictionary::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  OriginAttributesPatternDictionaryAtoms* atomsCache = GetAtomCache<OriginAttributesPatternDictionaryAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mFirstPartyDomain.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mFirstPartyDomain.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->firstPartyDomain_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mGeckoViewSessionContextId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mGeckoViewSessionContextId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->geckoViewSessionContextId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPartitionKey.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mPartitionKey.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->partitionKey_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPartitionKeyPattern.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      PartitionKeyPatternDictionary const & currentValue = mPartitionKeyPattern.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->partitionKeyPattern_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPrivateBrowsingId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mPrivateBrowsingId.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->privateBrowsingId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mUserContextId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mUserContextId.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->userContextId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

bool
OriginAttributesPatternDictionary::ToJSON(nsAString& aJSON) const
{
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext *cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here
  // because we'll only be creating objects, in ways that have no
  // side-effects, followed by a call to JS::ToJSONMaybeSafely,
  // which likewise guarantees no side-effects for the sorts of
  // things we will pass it.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    JS_ReportOutOfMemory(cx);
    return false;
  }
  JSAutoRealm ar(cx, scope);
  JS::Rooted<JS::Value> val(cx);
  if (!ToObjectInternal(cx, &val)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &val.toObject());
  return StringifyToJSON(cx, obj, aJSON);
}

void
OriginAttributesPatternDictionary::TraceDictionary(JSTracer* trc)
{
}

OriginAttributesPatternDictionary&
OriginAttributesPatternDictionary::operator=(const OriginAttributesPatternDictionary& aOther)
{
  DictionaryBase::operator=(aOther);
  mFirstPartyDomain.Reset();
  if (aOther.mFirstPartyDomain.WasPassed()) {
    mFirstPartyDomain.Construct(aOther.mFirstPartyDomain.Value());
  }
  mGeckoViewSessionContextId.Reset();
  if (aOther.mGeckoViewSessionContextId.WasPassed()) {
    mGeckoViewSessionContextId.Construct(aOther.mGeckoViewSessionContextId.Value());
  }
  mPartitionKey.Reset();
  if (aOther.mPartitionKey.WasPassed()) {
    mPartitionKey.Construct(aOther.mPartitionKey.Value());
  }
  mPartitionKeyPattern.Reset();
  if (aOther.mPartitionKeyPattern.WasPassed()) {
    mPartitionKeyPattern.Construct(aOther.mPartitionKeyPattern.Value());
  }
  mPrivateBrowsingId.Reset();
  if (aOther.mPrivateBrowsingId.WasPassed()) {
    mPrivateBrowsingId.Construct(aOther.mPrivateBrowsingId.Value());
  }
  mUserContextId.Reset();
  if (aOther.mUserContextId.WasPassed()) {
    mUserContextId.Construct(aOther.mUserContextId.Value());
  }
  return *this;
}


} // namespace mozilla::dom
