/* THIS FILE IS AUTOGENERATED FROM HTMLDocument.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "DocumentBinding.h"
#include "HTMLDocumentBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "XrayWrapper.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/String.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_dom.h"
#include "mozilla/UseCounter.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMJSProxyHandler.h"
#include "mozilla/dom/Location.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ProxyHandlerUtils.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsHTMLDocument.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace HTMLDocument_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<Document_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_location(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLDocument", "location", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsHTMLDocument*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::Location>(MOZ_KnownLive(self)->GetLocation()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_location(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "HTMLDocument.location setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLDocument", "location", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::Rooted<JS::Value> v(cx);
  if (!JS_GetProperty(cx, obj, "location", &v)) {
    return false;
  }

  if (!v.isObject()) {
    return cx.ThrowErrorMessage<MSG_NOT_OBJECT>("HTMLDocument.location");
  }

  JS::Rooted<JSObject*> targetObj(cx, &v.toObject());
  return JS_SetProperty(cx, targetObj, "href", args[0]);
}

static const JSJitInfo location_getterinfo = {
  { get_location },
  { prototypes::id::HTMLDocument },
  { PrototypeTraits<prototypes::id::HTMLDocument>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo location_setterinfo = {
  { (JSJitGetterOp)set_location },
  { prototypes::id::HTMLDocument },
  { PrototypeTraits<prototypes::id::HTMLDocument>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_GLOBINIT static const JSPropertySpec sUnforgeableAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("location", JSPROP_ENUMERATE | JSPROP_PERMANENT, GenericGetter<NormalThisPolicy, ThrowExceptions>, &location_getterinfo, GenericSetter<NormalThisPolicy>, &location_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sUnforgeableAttributes[] = {
  { nullptr, &sUnforgeableAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[1];
static PropertyInfo sNativeProperties_propertyInfos[1];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  true,  0 /* sUnforgeableAttributes */,
  false, 0,
  -1,
  1,
  sNativeProperties_sortedPropertyIndices,
  {
    { sUnforgeableAttributes, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(1 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static_assert(std::is_base_of_v<nsISupports, nsHTMLDocument>,
              "We don't support non-nsISupports native classes for "
              "proxy-based bindings yet");


class DOMProxyHandler : public ShadowingDOMProxyHandler
{
public:
  using Base = ShadowingDOMProxyHandler;

  explicit constexpr DOMProxyHandler()
  {
  }

  bool
  getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const override;

  bool
  defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const override;

  using mozilla::dom::DOMProxyHandler::defineProperty;

  bool
  ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const override;

  bool
  hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const override;

  bool
  get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const override;

  const char*
  className(JSContext* cx, JS::Handle<JSObject*> proxy) const override;

  bool
  finalizeInBackground(const JS::Value& priv) const override;

  void
  finalize(JS::GCContext* gcx, JSObject* proxy) const override;

  static const DOMProxyHandler*
  getInstance();

  bool
  delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const override;

  size_t
  objectMoved(JSObject* obj, JSObject* old) const override;
};

MOZ_ALWAYS_INLINE bool
IsProxy(JSObject* obj)
{
  return js::IsProxy(obj) && js::GetProxyHandler(obj) == DOMProxyHandler::getInstance();
}

MOZ_ALWAYS_INLINE nsHTMLDocument*
UnwrapProxy(JSObject* obj)
{
  MOZ_ASSERT(js::IsProxy(obj));
  if (js::GetProxyHandler(obj) != DOMProxyHandler::getInstance()) {
    MOZ_ASSERT(xpc::WrapperFactory::IsXrayWrapper(obj));
    obj = js::UncheckedUnwrap(obj);
  }
  MOZ_ASSERT(IsProxy(obj));
  return static_cast<nsHTMLDocument*>(js::GetProxyReservedSlot(obj, DOM_OBJECT_SLOT).toPrivate());
}

// This may allocate too many slots, because we only really need
// slots for our non-interface-typed members that we cache.  But
// allocating slots only for those would make the slot index
// computations much more complicated, so let's do this the simple
// way for now.
DEFINE_XRAY_EXPANDO_CLASS_WITH_OPS(static, sXrayExpandoObjectClass, 1,
                                   &xpc::XrayExpandoObjectClassOps);

const NativeNamedOrIndexedPropertyHooks sNativeNamedOrIndexedPropertyHooks = {
  binding_detail::ResolveOwnProperty,
  binding_detail::EnumerateOwnProperties,
  nullptr
};
bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  &sNativeNamedOrIndexedPropertyHooks,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::HTMLDocument,
  constructors::id::HTMLDocument,
  &sXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  Document_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::HTMLDocument>::Depth,
  prototypes::id::HTMLDocument,
  true,
  0,
  "HTMLDocument",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "HTMLDocumentPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE + 1 /* slot for the JSObject holding the unforgeable properties */),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::HTMLDocument,
  PrototypeTraits<prototypes::id::HTMLDocument>::Depth,
  &sNativePropertyHooks,
  Document_Binding::GetProtoObject
};

bool
CountMaybeMissingProperty(JS::Handle<JSObject*> proxy, JS::Handle<jsid> id)
{
  MOZ_ASSERT(StaticPrefs::dom_missing_prop_counters_enabled() && id.isAtom());
  Maybe<UseCounter> counter;
  {
    // Scope for our no-GC section, so we don't need to rely on SetUseCounter not GCing.
    JS::AutoCheckCannotGC nogc;
    JSLinearString* str = JS::AtomToLinearString(id.toAtom());
    // Don't waste time fetching the chars until we've done the length switch.
    switch (JS::GetLinearStringLength(str)) {
      case 8: {
        StringIdChars chars(nogc, str);
        switch (chars[2]) {
          case 'c': {
            if (JS_LinearStringEqualsLiteral(str, "oncancel")) {
              counter.emplace(eUseCounter_HTMLDocument_oncancel);
            }
            break;
          }
          case 'f': {
            if (JS_LinearStringEqualsLiteral(str, "onfreeze")) {
              counter.emplace(eUseCounter_HTMLDocument_onfreeze);
            }
            break;
          }
          case 'r': {
            if (JS_LinearStringEqualsLiteral(str, "onresume")) {
              counter.emplace(eUseCounter_HTMLDocument_onresume);
            }
            break;
          }
          case 's': {
            if (JS_LinearStringEqualsLiteral(str, "onsearch")) {
              counter.emplace(eUseCounter_HTMLDocument_onsearch);
            }
            break;
          }
        }
        break;
      }
      case 10: {
        if (JS_LinearStringEqualsLiteral(str, "xmlVersion")) {
          counter.emplace(eUseCounter_HTMLDocument_xmlVersion);
        }
        break;
      }
      case 11: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'o': {
            if (JS_LinearStringEqualsLiteral(str, "onbeforecut")) {
              counter.emplace(eUseCounter_HTMLDocument_onbeforecut);
            }
            break;
          }
          case 'x': {
            if (JS_LinearStringEqualsLiteral(str, "xmlEncoding")) {
              counter.emplace(eUseCounter_HTMLDocument_xmlEncoding);
            }
            break;
          }
        }
        break;
      }
      case 12: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'o': {
            switch (chars[2]) {
              case 'b': {
                if (JS_LinearStringEqualsLiteral(str, "onbeforecopy")) {
                  counter.emplace(eUseCounter_HTMLDocument_onbeforecopy);
                }
                break;
              }
              case 'm': {
                if (JS_LinearStringEqualsLiteral(str, "onmousewheel")) {
                  counter.emplace(eUseCounter_HTMLDocument_onmousewheel);
                }
                break;
              }
            }
            break;
          }
          case 'w': {
            switch (chars[1]) {
              case 'a': {
                if (JS_LinearStringEqualsLiteral(str, "wasDiscarded")) {
                  counter.emplace(eUseCounter_HTMLDocument_wasDiscarded);
                }
                break;
              }
              case 'e': {
                if (JS_LinearStringEqualsLiteral(str, "webkitHidden")) {
                  counter.emplace(eUseCounter_HTMLDocument_webkitHidden);
                }
                break;
              }
            }
            break;
          }
        }
        break;
      }
      case 13: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'f': {
            if (JS_LinearStringEqualsLiteral(str, "featurePolicy")) {
              counter.emplace(eUseCounter_HTMLDocument_featurePolicy);
            }
            break;
          }
          case 'o': {
            if (JS_LinearStringEqualsLiteral(str, "onbeforepaste")) {
              counter.emplace(eUseCounter_HTMLDocument_onbeforepaste);
            }
            break;
          }
          case 'x': {
            if (JS_LinearStringEqualsLiteral(str, "xmlStandalone")) {
              counter.emplace(eUseCounter_HTMLDocument_xmlStandalone);
            }
            break;
          }
        }
        break;
      }
      case 15: {
        if (JS_LinearStringEqualsLiteral(str, "registerElement")) {
          counter.emplace(eUseCounter_HTMLDocument_registerElement);
        }
        break;
      }
      case 18: {
        if (JS_LinearStringEqualsLiteral(str, "webkitIsFullScreen")) {
          counter.emplace(eUseCounter_HTMLDocument_webkitIsFullScreen);
        }
        break;
      }
      case 19: {
        if (JS_LinearStringEqualsLiteral(str, "caretRangeFromPoint")) {
          counter.emplace(eUseCounter_HTMLDocument_caretRangeFromPoint);
        }
        break;
      }
      case 20: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'e': {
            if (JS_LinearStringEqualsLiteral(str, "exitPictureInPicture")) {
              counter.emplace(eUseCounter_HTMLDocument_exitPictureInPicture);
            }
            break;
          }
          case 'w': {
            if (JS_LinearStringEqualsLiteral(str, "webkitExitFullscreen")) {
              counter.emplace(eUseCounter_HTMLDocument_webkitExitFullscreen);
            }
            break;
          }
        }
        break;
      }
      case 21: {
        if (JS_LinearStringEqualsLiteral(str, "webkitVisibilityState")) {
          counter.emplace(eUseCounter_HTMLDocument_webkitVisibilityState);
        }
        break;
      }
      case 22: {
        if (JS_LinearStringEqualsLiteral(str, "webkitCancelFullScreen")) {
          counter.emplace(eUseCounter_HTMLDocument_webkitCancelFullScreen);
        }
        break;
      }
      case 23: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'o': {
            if (JS_LinearStringEqualsLiteral(str, "onwebkitfullscreenerror")) {
              counter.emplace(eUseCounter_HTMLDocument_onwebkitfullscreenerror);
            }
            break;
          }
          case 'p': {
            switch (chars[17]) {
              case 'l': {
                if (JS_LinearStringEqualsLiteral(str, "pictureInPictureElement")) {
                  counter.emplace(eUseCounter_HTMLDocument_pictureInPictureElement);
                }
                break;
              }
              case 'n': {
                if (JS_LinearStringEqualsLiteral(str, "pictureInPictureEnabled")) {
                  counter.emplace(eUseCounter_HTMLDocument_pictureInPictureEnabled);
                }
                break;
              }
            }
            break;
          }
          case 'w': {
            switch (chars[17]) {
              case 'l': {
                if (JS_LinearStringEqualsLiteral(str, "webkitFullscreenElement")) {
                  counter.emplace(eUseCounter_HTMLDocument_webkitFullscreenElement);
                }
                break;
              }
              case 'n': {
                if (JS_LinearStringEqualsLiteral(str, "webkitFullscreenEnabled")) {
                  counter.emplace(eUseCounter_HTMLDocument_webkitFullscreenEnabled);
                }
                break;
              }
            }
            break;
          }
        }
        break;
      }
      case 24: {
        if (JS_LinearStringEqualsLiteral(str, "onwebkitfullscreenchange")) {
          counter.emplace(eUseCounter_HTMLDocument_onwebkitfullscreenchange);
        }
        break;
      }
      case 30: {
        if (JS_LinearStringEqualsLiteral(str, "webkitCurrentFullScreenElement")) {
          counter.emplace(eUseCounter_HTMLDocument_webkitCurrentFullScreenElement);
        }
        break;
      }
    }
  }
  if (counter) {
    SetUseCounter(proxy, *counter);
    return true;
  }

  return false;
}

bool
InterfaceHasProperty(const nsAString& name)
{
  switch (name.Length()) {
    case 3: {
      switch (name[0]) {
        case 'U': {
          if (name == u"URL"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          if (name == u"all"_ns) {
            return true;
          }
          break;
        }
        case 'd': {
          if (name == u"dir"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 4: {
      switch (name[0]) {
        case 'b': {
          if (name == u"body"_ns) {
            return true;
          }
          break;
        }
        case 'h': {
          if (name == u"head"_ns) {
            return true;
          }
          break;
        }
        case 'l': {
          if (name == u"l10n"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          if (name == u"open"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 5: {
      switch (name[0]) {
        case 'c': {
          switch (name[2]) {
            case 'e': {
              if (name == u"clear"_ns) {
                return true;
              }
              break;
            }
            case 'o': {
              if (name == u"close"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'f': {
          switch (name[2]) {
            case 'n': {
              if (name == u"fonts"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              if (name == u"forms"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'l': {
          if (name == u"links"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          if (name == u"oncut"_ns) {
            return true;
          }
          break;
        }
        case 't': {
          if (name == u"title"_ns) {
            return true;
          }
          break;
        }
        case 'w': {
          if (name == u"write"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 6: {
      switch (name[0]) {
        case 'a': {
          if (name == u"append"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          if (name == u"cookie"_ns) {
            return true;
          }
          break;
        }
        case 'd': {
          if (name == u"domain"_ns) {
            return true;
          }
          break;
        }
        case 'e': {
          if (name == u"embeds"_ns) {
            return true;
          }
          break;
        }
        case 'h': {
          if (name == u"hidden"_ns) {
            return true;
          }
          break;
        }
        case 'i': {
          if (name == u"images"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'b': {
              if (name == u"onblur"_ns) {
                return true;
              }
              break;
            }
            case 'c': {
              if (name == u"oncopy"_ns) {
                return true;
              }
              break;
            }
            case 'd': {
              switch (name[4]) {
                case 'a': {
                  if (name == u"ondrag"_ns) {
                    return true;
                  }
                  break;
                }
                case 'o': {
                  if (name == u"ondrop"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'l': {
              if (name == u"onload"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              if (name == u"onplay"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
      }
      break;
    }
    case 7: {
      switch (name[0]) {
        case 'a': {
          switch (name[1]) {
            case 'n': {
              if (name == u"anchors"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              if (name == u"applets"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'b': {
          switch (name[1]) {
            case 'a': {
              if (name == u"baseURI"_ns) {
                return true;
              }
              break;
            }
            case 'g': {
              if (name == u"bgColor"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'c': {
          if (name == u"charset"_ns) {
            return true;
          }
          break;
        }
        case 'd': {
          if (name == u"doctype"_ns) {
            return true;
          }
          break;
        }
        case 'f': {
          if (name == u"fgColor"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'a': {
              if (name == u"onabort"_ns) {
                return true;
              }
              break;
            }
            case 'c': {
              switch (name[4]) {
                case 'i': {
                  if (name == u"onclick"_ns) {
                    return true;
                  }
                  break;
                }
                case 'o': {
                  if (name == u"onclose"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'e': {
              switch (name[3]) {
                case 'n': {
                  if (name == u"onended"_ns) {
                    return true;
                  }
                  break;
                }
                case 'r': {
                  if (name == u"onerror"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'f': {
              if (name == u"onfocus"_ns) {
                return true;
              }
              break;
            }
            case 'i': {
              if (name == u"oninput"_ns) {
                return true;
              }
              break;
            }
            case 'k': {
              if (name == u"onkeyup"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              switch (name[4]) {
                case 's': {
                  if (name == u"onpaste"_ns) {
                    return true;
                  }
                  break;
                }
                case 'u': {
                  if (name == u"onpause"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'r': {
              if (name == u"onreset"_ns) {
                return true;
              }
              break;
            }
            case 'w': {
              if (name == u"onwheel"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'p': {
          switch (name[1]) {
            case 'l': {
              if (name == u"plugins"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              if (name == u"prepend"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 's': {
          if (name == u"scripts"_ns) {
            return true;
          }
          break;
        }
        case 'v': {
          if (name == u"valueOf"_ns) {
            return true;
          }
          break;
        }
        case 'w': {
          if (name == u"writeln"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 8: {
      switch (name[0]) {
        case 'c': {
          switch (name[1]) {
            case 'h': {
              if (name == u"children"_ns) {
                return true;
              }
              break;
            }
            case 'o': {
              if (name == u"contains"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'e': {
          if (name == u"evaluate"_ns) {
            return true;
          }
          break;
        }
        case 'h': {
          if (name == u"hasFocus"_ns) {
            return true;
          }
          break;
        }
        case 'l': {
          if (name == u"location"_ns) {
            return true;
          }
          break;
        }
        case 'n': {
          switch (name[4]) {
            case 'N': {
              if (name == u"nodeName"_ns) {
                return true;
              }
              break;
            }
            case 'T': {
              if (name == u"nodeType"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'c': {
              switch (name[3]) {
                case 'a': {
                  if (name == u"oncancel"_ns) {
                    return true;
                  }
                  break;
                }
                case 'h': {
                  if (name == u"onchange"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'r': {
              if (name == u"onresize"_ns) {
                return true;
              }
              break;
            }
            case 's': {
              switch (name[3]) {
                case 'c': {
                  if (name == u"onscroll"_ns) {
                    return true;
                  }
                  break;
                }
                case 'e': {
                  switch (name[4]) {
                    case 'e': {
                      if (name == u"onseeked"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'l': {
                      if (name == u"onselect"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'u': {
                  if (name == u"onsubmit"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 't': {
              if (name == u"ontoggle"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'r': {
          if (name == u"referrer"_ns) {
            return true;
          }
          break;
        }
        case 't': {
          switch (name[1]) {
            case 'i': {
              if (name == u"timeline"_ns) {
                return true;
              }
              break;
            }
            case 'o': {
              if (name == u"toString"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
      }
      break;
    }
    case 9: {
      switch (name[0]) {
        case 'T': {
          if (name == u"TEXT_NODE"_ns) {
            return true;
          }
          break;
        }
        case '_': {
          if (name == u"__proto__"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          if (name == u"adoptNode"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          if (name == u"cloneNode"_ns) {
            return true;
          }
          break;
        }
        case 'l': {
          switch (name[1]) {
            case 'a': {
              if (name == u"lastChild"_ns) {
                return true;
              }
              break;
            }
            case 'i': {
              if (name == u"linkColor"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'n': {
          switch (name[2]) {
            case 'd': {
              if (name == u"nodeValue"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              if (name == u"normalize"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'c': {
              switch (name[3]) {
                case 'a': {
                  if (name == u"oncanplay"_ns) {
                    return true;
                  }
                  break;
                }
                case 'o': {
                  if (name == u"oncommand"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'd': {
              if (name == u"ondragend"_ns) {
                return true;
              }
              break;
            }
            case 'e': {
              if (name == u"onemptied"_ns) {
                return true;
              }
              break;
            }
            case 'i': {
              if (name == u"oninvalid"_ns) {
                return true;
              }
              break;
            }
            case 'k': {
              if (name == u"onkeydown"_ns) {
                return true;
              }
              break;
            }
            case 'm': {
              if (name == u"onmouseup"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              if (name == u"onplaying"_ns) {
                return true;
              }
              break;
            }
            case 's': {
              switch (name[3]) {
                case 'e': {
                  if (name == u"onseeking"_ns) {
                    return true;
                  }
                  break;
                }
                case 't': {
                  if (name == u"onstalled"_ns) {
                    return true;
                  }
                  break;
                }
                case 'u': {
                  if (name == u"onsuspend"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'w': {
              if (name == u"onwaiting"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'p': {
          if (name == u"parseHTML"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 10: {
      switch (name[0]) {
        case 'a': {
          switch (name[1]) {
            case 'l': {
              if (name == u"alinkColor"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              if (name == u"ariaNotify"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'c': {
          switch (name[1]) {
            case 'h': {
              if (name == u"childNodes"_ns) {
                return true;
              }
              break;
            }
            case 'o': {
              if (name == u"compatMode"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'd': {
          if (name == u"designMode"_ns) {
            return true;
          }
          break;
        }
        case 'f': {
          switch (name[1]) {
            case 'i': {
              if (name == u"firstChild"_ns) {
                return true;
              }
              break;
            }
            case 'u': {
              if (name == u"fullscreen"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'i': {
          switch (name[1]) {
            case 'm': {
              if (name == u"importNode"_ns) {
                return true;
              }
              break;
            }
            case 's': {
              if (name == u"isSameNode"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'm': {
          if (name == u"moveBefore"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'a': {
              if (name == u"onauxclick"_ns) {
                return true;
              }
              break;
            }
            case 'd': {
              switch (name[3]) {
                case 'b': {
                  if (name == u"ondblclick"_ns) {
                    return true;
                  }
                  break;
                }
                case 'r': {
                  switch (name[6]) {
                    case 'e': {
                      if (name == u"ondragexit"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'o': {
                      if (name == u"ondragover"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
              }
              break;
            }
            case 'f': {
              if (name == u"onformdata"_ns) {
                return true;
              }
              break;
            }
            case 'k': {
              if (name == u"onkeypress"_ns) {
                return true;
              }
              break;
            }
            case 'm': {
              if (name == u"onmouseout"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              if (name == u"onprogress"_ns) {
                return true;
              }
              break;
            }
            case 't': {
              if (name == u"ontouchend"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'p': {
          if (name == u"parentNode"_ns) {
            return true;
          }
          break;
        }
        case 'r': {
          if (name == u"readyState"_ns) {
            return true;
          }
          break;
        }
        case 'v': {
          if (name == u"vlinkColor"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 11: {
      switch (name[0]) {
        case 'E': {
          if (name == u"ENTITY_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          if (name == u"appendChild"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          switch (name[1]) {
            case 'o': {
              switch (name[3]) {
                case 's': {
                  if (name == u"constructor"_ns) {
                    return true;
                  }
                  break;
                }
                case 't': {
                  if (name == u"contentType"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'r': {
              switch (name[6]) {
                case 'E': {
                  if (name == u"createEvent"_ns) {
                    return true;
                  }
                  break;
                }
                case 'R': {
                  if (name == u"createRange"_ns) {
                    return true;
                  }
                  break;
                }
                case 'T': {
                  if (name == u"createTouch"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
          }
          break;
        }
        case 'd': {
          switch (name[1]) {
            case 'e': {
              if (name == u"defaultView"_ns) {
                return true;
              }
              break;
            }
            case 'o': {
              if (name == u"documentURI"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'e': {
          if (name == u"execCommand"_ns) {
            return true;
          }
          break;
        }
        case 'g': {
          switch (name[3]) {
            case 'B': {
              if (name == u"getBoxQuads"_ns) {
                return true;
              }
              break;
            }
            case 'R': {
              if (name == u"getRootNode"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'i': {
          switch (name[2]) {
            case 'C': {
              if (name == u"isConnected"_ns) {
                return true;
              }
              break;
            }
            case 'E': {
              if (name == u"isEqualNode"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'n': {
          if (name == u"nextSibling"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'c': {
              if (name == u"oncuechange"_ns) {
                return true;
              }
              break;
            }
            case 'd': {
              switch (name[6]) {
                case 'e': {
                  if (name == u"ondragenter"_ns) {
                    return true;
                  }
                  break;
                }
                case 'l': {
                  if (name == u"ondragleave"_ns) {
                    return true;
                  }
                  break;
                }
                case 's': {
                  if (name == u"ondragstart"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'l': {
              if (name == u"onloadstart"_ns) {
                return true;
              }
              break;
            }
            case 'm': {
              switch (name[7]) {
                case 'd': {
                  if (name == u"onmousedown"_ns) {
                    return true;
                  }
                  break;
                }
                case 'm': {
                  if (name == u"onmousemove"_ns) {
                    return true;
                  }
                  break;
                }
                case 'o': {
                  if (name == u"onmouseover"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'p': {
              if (name == u"onpointerup"_ns) {
                return true;
              }
              break;
            }
            case 's': {
              if (name == u"onscrollend"_ns) {
                return true;
              }
              break;
            }
            case 't': {
              if (name == u"ontouchmove"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'r': {
          switch (name[1]) {
            case 'e': {
              if (name == u"removeChild"_ns) {
                return true;
              }
              break;
            }
            case 'o': {
              if (name == u"rootElement"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 's': {
          if (name == u"styleSheets"_ns) {
            return true;
          }
          break;
        }
        case 't': {
          if (name == u"textContent"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 12: {
      switch (name[0]) {
        case 'C': {
          if (name == u"COMMENT_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'E': {
          if (name == u"ELEMENT_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          if (name == u"characterSet"_ns) {
            return true;
          }
          break;
        }
        case 'g': {
          if (name == u"getSelection"_ns) {
            return true;
          }
          break;
        }
        case 'i': {
          if (name == u"insertBefore"_ns) {
            return true;
          }
          break;
        }
        case 'l': {
          switch (name[1]) {
            case 'a': {
              if (name == u"lastModified"_ns) {
                return true;
              }
              break;
            }
            case 'o': {
              if (name == u"lookupPrefix"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'l': {
              if (name == u"onloadeddata"_ns) {
                return true;
              }
              break;
            }
            case 'm': {
              switch (name[7]) {
                case 'e': {
                  if (name == u"onmouseenter"_ns) {
                    return true;
                  }
                  break;
                }
                case 'l': {
                  if (name == u"onmouseleave"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'p': {
              if (name == u"onpointerout"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              if (name == u"onratechange"_ns) {
                return true;
              }
              break;
            }
            case 's': {
              if (name == u"onslotchange"_ns) {
                return true;
              }
              break;
            }
            case 't': {
              switch (name[3]) {
                case 'i': {
                  if (name == u"ontimeupdate"_ns) {
                    return true;
                  }
                  break;
                }
                case 'o': {
                  if (name == u"ontouchstart"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
          }
          break;
        }
        case 'r': {
          if (name == u"replaceChild"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 13: {
      switch (name[0]) {
        case 'D': {
          if (name == u"DOCUMENT_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'N': {
          if (name == u"NOTATION_NODE"_ns) {
            return true;
          }
          break;
        }
        case '_': {
          if (name == u"__namedgetter"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          if (name == u"activeElement"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          switch (name[1]) {
            case 'a': {
              if (name == u"captureEvents"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              switch (name[6]) {
                case 'C': {
                  if (name == u"createComment"_ns) {
                    return true;
                  }
                  break;
                }
                case 'E': {
                  if (name == u"createElement"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'u': {
              if (name == u"currentScript"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'd': {
          if (name == u"dispatchEvent"_ns) {
            return true;
          }
          break;
        }
        case 'f': {
          if (name == u"featurePolicy"_ns) {
            return true;
          }
          break;
        }
        case 'g': {
          if (name == u"getAnimations"_ns) {
            return true;
          }
          break;
        }
        case 'h': {
          if (name == u"hasChildNodes"_ns) {
            return true;
          }
          break;
        }
        case 'i': {
          switch (name[1]) {
            case 'n': {
              if (name == u"inputEncoding"_ns) {
                return true;
              }
              break;
            }
            case 's': {
              if (name == u"isPrototypeOf"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'm': {
          if (name == u"mozFullScreen"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[1]) {
            case 'n': {
              switch (name[2]) {
                case 'b': {
                  switch (name[8]) {
                    case 'i': {
                      if (name == u"onbeforeinput"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'm': {
                      if (name == u"onbeforematch"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'c': {
                  switch (name[9]) {
                    case 'l': {
                      if (name == u"oncontextlost"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'm': {
                      if (name == u"oncontextmenu"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'p': {
                  switch (name[9]) {
                    case 'd': {
                      if (name == u"onpointerdown"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'm': {
                      if (name == u"onpointermove"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'o': {
                      if (name == u"onpointerover"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 's': {
                  if (name == u"onselectstart"_ns) {
                    return true;
                  }
                  break;
                }
                case 't': {
                  if (name == u"ontouchcancel"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'w': {
              if (name == u"ownerDocument"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'p': {
          if (name == u"parentElement"_ns) {
            return true;
          }
          break;
        }
        case 'q': {
          if (name == u"querySelector"_ns) {
            return true;
          }
          break;
        }
        case 'r': {
          if (name == u"releaseEvents"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 14: {
      switch (name[0]) {
        case 'A': {
          if (name == u"ATTRIBUTE_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          if (name == u"accessibleNode"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          if (name == u"createTextNode"_ns) {
            return true;
          }
          break;
        }
        case 'e': {
          if (name == u"exitFullscreen"_ns) {
            return true;
          }
          break;
        }
        case 'g': {
          if (name == u"getElementById"_ns) {
            return true;
          }
          break;
        }
        case 'h': {
          if (name == u"hasOwnProperty"_ns) {
            return true;
          }
          break;
        }
        case 'i': {
          if (name == u"implementation"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'a': {
              if (name == u"onanimationend"_ns) {
                return true;
              }
              break;
            }
            case 'b': {
              if (name == u"onbeforetoggle"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              switch (name[9]) {
                case 'e': {
                  if (name == u"onpointerenter"_ns) {
                    return true;
                  }
                  break;
                }
                case 'l': {
                  if (name == u"onpointerleave"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'v': {
              if (name == u"onvolumechange"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'r': {
          if (name == u"releaseCapture"_ns) {
            return true;
          }
          break;
        }
        case 's': {
          if (name == u"styleSheetSets"_ns) {
            return true;
          }
          break;
        }
        case 't': {
          if (name == u"toLocaleString"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 15: {
      switch (name[0]) {
        case 'c': {
          switch (name[6]) {
            case 'A': {
              if (name == u"createAttribute"_ns) {
                return true;
              }
              break;
            }
            case 'E': {
              if (name == u"createElementNS"_ns) {
                return true;
              }
              break;
            }
            case 'T': {
              if (name == u"createTouchList"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'd': {
          if (name == u"documentElement"_ns) {
            return true;
          }
          break;
        }
        case 'e': {
          if (name == u"exitPointerLock"_ns) {
            return true;
          }
          break;
        }
        case 'g': {
          if (name == u"getNetErrorInfo"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'p': {
              if (name == u"onpointercancel"_ns) {
                return true;
              }
              break;
            }
            case 't': {
              switch (name[12]) {
                case 'e': {
                  if (name == u"ontransitionend"_ns) {
                    return true;
                  }
                  break;
                }
                case 'r': {
                  if (name == u"ontransitionrun"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
          }
          break;
        }
        case 'p': {
          switch (name[1]) {
            case 'a': {
              if (name == u"parseHTMLUnsafe"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              if (name == u"previousSibling"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'r': {
          if (name == u"replaceChildren"_ns) {
            return true;
          }
          break;
        }
        case 'v': {
          if (name == u"visibilityState"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 16: {
      switch (name[0]) {
        case '_': {
          switch (name[2]) {
            case 'd': {
              switch (name[8]) {
                case 'G': {
                  if (name == u"__defineGetter__"_ns) {
                    return true;
                  }
                  break;
                }
                case 'S': {
                  if (name == u"__defineSetter__"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'l': {
              switch (name[8]) {
                case 'G': {
                  if (name == u"__lookupGetter__"_ns) {
                    return true;
                  }
                  break;
                }
                case 'S': {
                  if (name == u"__lookupSetter__"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
          }
          break;
        }
        case 'a': {
          switch (name[3]) {
            case 'C': {
              if (name == u"addCertException"_ns) {
                return true;
              }
              break;
            }
            case 'E': {
              if (name == u"addEventListener"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'c': {
          switch (name[6]) {
            case 'E': {
              if (name == u"createExpression"_ns) {
                return true;
              }
              break;
            }
            case 'N': {
              if (name == u"createNSResolver"_ns) {
                return true;
              }
              break;
            }
            case 'T': {
              if (name == u"createTreeWalker"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'e': {
          if (name == u"elementFromPoint"_ns) {
            return true;
          }
          break;
        }
        case 'h': {
          if (name == u"hasStorageAccess"_ns) {
            return true;
          }
          break;
        }
        case 'i': {
          if (name == u"inAndroidPipMode"_ns) {
            return true;
          }
          break;
        }
        case 'l': {
          if (name == u"lastElementChild"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'a': {
              if (name == u"onanimationstart"_ns) {
                return true;
              }
              break;
            }
            case 'c': {
              if (name == u"oncanplaythrough"_ns) {
                return true;
              }
              break;
            }
            case 'd': {
              if (name == u"ondurationchange"_ns) {
                return true;
              }
              break;
            }
            case 'l': {
              if (name == u"onloadedmetadata"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'q': {
          if (name == u"querySelectorAll"_ns) {
            return true;
          }
          break;
        }
        case 's': {
          if (name == u"scrollingElement"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 17: {
      switch (name[0]) {
        case 'c': {
          switch (name[1]) {
            case 'h': {
              if (name == u"childElementCount"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              if (name == u"createAttributeNS"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'e': {
          if (name == u"elementsFromPoint"_ns) {
            return true;
          }
          break;
        }
        case 'f': {
          switch (name[1]) {
            case 'i': {
              if (name == u"firstElementChild"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              if (name == u"fragmentDirective"_ns) {
                return true;
              }
              break;
            }
            case 'u': {
              switch (name[11]) {
                case 'l': {
                  if (name == u"fullscreenElement"_ns) {
                    return true;
                  }
                  break;
                }
                case 'n': {
                  if (name == u"fullscreenEnabled"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
          }
          break;
        }
        case 'g': {
          if (name == u"getElementsByName"_ns) {
            return true;
          }
          break;
        }
        case 'l': {
          if (name == u"lastStyleSheetSet"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'a': {
              if (name == u"onanimationcancel"_ns) {
                return true;
              }
              break;
            }
            case 'c': {
              if (name == u"oncontextrestored"_ns) {
                return true;
              }
              break;
            }
            case 'f': {
              if (name == u"onfullscreenerror"_ns) {
                return true;
              }
              break;
            }
            case 's': {
              if (name == u"onselectionchange"_ns) {
                return true;
              }
              break;
            }
            case 't': {
              if (name == u"ontransitionstart"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'q': {
          switch (name[12]) {
            case 'S': {
              if (name == u"queryCommandState"_ns) {
                return true;
              }
              break;
            }
            case 'V': {
              if (name == u"queryCommandValue"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
      }
      break;
    }
    case 18: {
      switch (name[0]) {
        case 'C': {
          if (name == u"CDATA_SECTION_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'D': {
          if (name == u"DOCUMENT_TYPE_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          if (name == u"adoptedStyleSheets"_ns) {
            return true;
          }
          break;
        }
        case 'b': {
          if (name == u"blockUnblockOnload"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          switch (name[6]) {
            case 'C': {
              if (name == u"createCDATASection"_ns) {
                return true;
              }
              break;
            }
            case 'N': {
              if (name == u"createNodeIterator"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'i': {
          if (name == u"isDefaultNamespace"_ns) {
            return true;
          }
          break;
        }
        case 'l': {
          if (name == u"lookupNamespaceURI"_ns) {
            return true;
          }
          break;
        }
        case 'm': {
          if (name == u"mozSetImageElement"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'f': {
              if (name == u"onfullscreenchange"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              switch (name[9]) {
                case 'l': {
                  if (name == u"onpointerlockerror"_ns) {
                    return true;
                  }
                  break;
                }
                case 'r': {
                  if (name == u"onpointerrawupdate"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'r': {
              if (name == u"onreadystatechange"_ns) {
                return true;
              }
              break;
            }
            case 't': {
              if (name == u"ontransitioncancel"_ns) {
                return true;
              }
              break;
            }
            case 'v': {
              if (name == u"onvisibilitychange"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'p': {
          if (name == u"pointerLockElement"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 19: {
      switch (name[0]) {
        case 'c': {
          switch (name[7]) {
            case 'Q': {
              if (name == u"convertQuadFromNode"_ns) {
                return true;
              }
              break;
            }
            case 'R': {
              if (name == u"convertRectFromNode"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'm': {
          if (name == u"mozCancelFullScreen"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'g': {
              if (name == u"ongotpointercapture"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              if (name == u"onpointerlockchange"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'q': {
          if (name == u"queryCommandEnabled"_ns) {
            return true;
          }
          break;
        }
        case 'r': {
          if (name == u"removeEventListener"_ns) {
            return true;
          }
          break;
        }
        case 's': {
          if (name == u"startViewTransition"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 20: {
      switch (name[0]) {
        case 'a': {
          if (name == u"activeViewTransition"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          switch (name[3]) {
            case 't': {
              if (name == u"containingShadowRoot"_ns) {
                return true;
              }
              break;
            }
            case 'v': {
              if (name == u"convertPointFromNode"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'g': {
          if (name == u"getElementsByTagName"_ns) {
            return true;
          }
          break;
        }
        case 'm': {
          switch (name[3]) {
            case 'F': {
              switch (name[14]) {
                case 'l': {
                  if (name == u"mozFullScreenElement"_ns) {
                    return true;
                  }
                  break;
                }
                case 'n': {
                  if (name == u"mozFullScreenEnabled"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'S': {
              if (name == u"mozSyntheticDocument"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'a': {
              if (name == u"onanimationiteration"_ns) {
                return true;
              }
              break;
            }
            case 'l': {
              if (name == u"onlostpointercapture"_ns) {
                return true;
              }
              break;
            }
            case 'm': {
              if (name == u"onmozfullscreenerror"_ns) {
                return true;
              }
              break;
            }
            case 'w': {
              if (name == u"onwebkitanimationend"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'p': {
          if (name == u"propertyIsEnumerable"_ns) {
            return true;
          }
          break;
        }
        case 'q': {
          if (name == u"queryCommandIndeterm"_ns) {
            return true;
          }
          break;
        }
        case 'r': {
          if (name == u"requestStorageAccess"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 21: {
      switch (name[0]) {
        case 'E': {
          if (name == u"ENTITY_REFERENCE_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'm': {
              if (name == u"onmozfullscreenchange"_ns) {
                return true;
              }
              break;
            }
            case 'w': {
              if (name == u"onwebkittransitionend"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'q': {
          if (name == u"queryCommandSupported"_ns) {
            return true;
          }
          break;
        }
        case 's': {
          if (name == u"selectedStyleSheetSet"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 22: {
      switch (name[0]) {
        case 'D': {
          if (name == u"DOCUMENT_FRAGMENT_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          switch (name[1]) {
            case 'a': {
              if (name == u"caretPositionFromPoint"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              if (name == u"createDocumentFragment"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'g': {
          switch (name[13]) {
            case 'C': {
              if (name == u"getElementsByClassName"_ns) {
                return true;
              }
              break;
            }
            case 'T': {
              if (name == u"getElementsByTagNameNS"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'o': {
          if (name == u"onwebkitanimationstart"_ns) {
            return true;
          }
          break;
        }
        case 'p': {
          if (name == u"preferredStyleSheetSet"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 23: {
      switch (name[0]) {
        case 'c': {
          if (name == u"compareDocumentPosition"_ns) {
            return true;
          }
          break;
        }
        case 'e': {
          if (name == u"enableStyleSheetsForSet"_ns) {
            return true;
          }
          break;
        }
        case 'h': {
          if (name == u"hasPendingL10nMutations"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 25: {
      switch (name[0]) {
        case 'g': {
          if (name == u"getFailedCertSecurityInfo"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          if (name == u"onsecuritypolicyviolation"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 26: {
      switch (name[0]) {
        case 'D': {
          if (name == u"DOCUMENT_POSITION_CONTAINS"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          if (name == u"onwebkitanimationiteration"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 27: {
      switch (name[0]) {
        case 'D': {
          switch (name[18]) {
            case 'F': {
              if (name == u"DOCUMENT_POSITION_FOLLOWING"_ns) {
                return true;
              }
              break;
            }
            case 'P': {
              if (name == u"DOCUMENT_POSITION_PRECEDING"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'P': {
          if (name == u"PROCESSING_INSTRUCTION_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          if (name == u"createProcessingInstruction"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 28: {
      if (name == u"reloadWithHttpsOnlyException"_ns) {
        return true;
      }
      break;
    }
    case 29: {
      switch (name[20]) {
        case 'F': {
          if (name == u"requestStorageAccessForOrigin"_ns) {
            return true;
          }
          break;
        }
        case 'U': {
          if (name == u"requestStorageAccessUnderSite"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 30: {
      switch (name[18]) {
        case 'C': {
          if (name == u"DOCUMENT_POSITION_CONTAINED_BY"_ns) {
            return true;
          }
          break;
        }
        case 'D': {
          if (name == u"DOCUMENT_POSITION_DISCONNECTED"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 34: {
      if (name == u"oncontentvisibilityautostatechange"_ns) {
        return true;
      }
      break;
    }
    case 36: {
      if (name == u"completeStorageAccessRequestFromSite"_ns) {
        return true;
      }
      break;
    }
    case 41: {
      if (name == u"DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC"_ns) {
        return true;
      }
      break;
    }
  }

  return false;
}

bool
DOMProxyHandler::getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);
  if (StaticPrefs::dom_missing_prop_counters_enabled() && id.isAtom()) {
    CountMaybeMissingProperty(proxy, id);
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = GetExpandoObject(proxy))) {
    if (!JS_GetOwnPropertyDescriptorById(cx, expando, id, desc)) {
      return false;
    }
    if (desc.isSome()) {
      return true;
    }
  }

  bool callNamedGetter = false;
  if (!ignoreNamedProps) {
    if (!isXray) {
      callNamedGetter = true;
    } else {
      bool hasOnProto;
      if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
        return false;
      }
      callNamedGetter = !hasOnProto;
    }
  }
  if (callNamedGetter) {
    JS::Rooted<JS::Value> value(cx);
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      nsHTMLDocument* self = UnwrapProxy(proxy);
      bool found = false;
      FastErrorResult rv;
      JS::Rooted<JSObject*> result(cx);
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedGetter(cx, NonNullHelper(Constify(name)), found, &result, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->NamedGetter(cx, NonNullHelper(Constify(name)), found, &result, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLDocument named getter"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));

      if (found) {
        JS::ExposeObjectToActiveJS(result);
        value.setObject(*result);
        if (!MaybeWrapObjectValue(cx, &value)) {
          return false;
        }
        desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable, JS::PropertyAttribute::Enumerable })));
        return true;
      }
    }
  }

  desc.reset();
  return true;
}

bool
DOMProxyHandler::defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const
{
  JSContext* cx = cx_;
  bool found = false;
  FakeString<char16_t> name;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, name, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    nsHTMLDocument* self = UnwrapProxy(proxy);
    FastErrorResult rv;
    JS::Rooted<JSObject*> result(cx);
    // NOTE: This assert does NOT call the function.
    static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedGetter(cx, NonNullHelper(Constify(name)), found, &result, rv))>, "Should be returning void here");
    MOZ_KnownLive(self)->NamedGetter(cx, NonNullHelper(Constify(name)), found, &result, rv);
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLDocument named getter"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
  }

  if (found) {
    *done = true;
    return opresult.failNoNamedSetter();
  }
  return mozilla::dom::DOMProxyHandler::defineProperty(cx_, proxy, id, desc, opresult, done);
}


bool
DOMProxyHandler::ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);

  nsTArray<nsString> names;
  UnwrapProxy(proxy)->GetSupportedNames(names);
  if (!AppendNamedPropertyIds(cx, proxy, names, !isXray, props)) {
    return false;
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = DOMProxyHandler::GetExpandoObject(proxy)) &&
      !js::GetPropertyKeys(cx, expando, flags, props)) {
    return false;
  }

  return true;
}

bool
DOMProxyHandler::hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  if (StaticPrefs::dom_missing_prop_counters_enabled() && id.isAtom()) {
    CountMaybeMissingProperty(proxy, id);
  }

  JS::Rooted<JSObject*> expando(cx, GetExpandoObject(proxy));
  if (expando) {
    bool b = true;
    bool ok = JS_HasPropertyById(cx, expando, id, &b);
    *bp = !!b;
    if (!ok || *bp) {
      return ok;
    }
  }

  bool found = false;
  FakeString<char16_t> name;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, name, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    nsHTMLDocument* self = UnwrapProxy(proxy);
    FastErrorResult rv;
    JS::Rooted<JSObject*> result(cx);
    // NOTE: This assert does NOT call the function.
    static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedGetter(cx, NonNullHelper(Constify(name)), found, &result, rv))>, "Should be returning void here");
    MOZ_KnownLive(self)->NamedGetter(cx, NonNullHelper(Constify(name)), found, &result, rv);
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLDocument named getter"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
  }

  *bp = found;

  return true;
}

bool
DOMProxyHandler::get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
              "Should not have a XrayWrapper here");

  if (StaticPrefs::dom_missing_prop_counters_enabled() && id.isAtom()) {
    CountMaybeMissingProperty(proxy, id);
  }

  bool expandoHasProp = false;
  { // Scope for expando
    JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
    if (expando) {
      if (!JS_HasPropertyById(cx, expando, id, &expandoHasProp)) {
        return false;
      }

      if (expandoHasProp) {
        // Forward the get to the expando object, but our receiver is whatever our
        // receiver is.
        if (!JS_ForwardGetPropertyTo(cx, expando, id, receiver, vp)) {
          return false;
        }
      }
    }
  }

  if (expandoHasProp) {
    return true;
  }

  FakeString<char16_t> name;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, name, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    nsHTMLDocument* self = UnwrapProxy(proxy);
    bool found = false;
    FastErrorResult rv;
    JS::Rooted<JSObject*> result(cx);
    // NOTE: This assert does NOT call the function.
    static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedGetter(cx, NonNullHelper(Constify(name)), found, &result, rv))>, "Should be returning void here");
    MOZ_KnownLive(self)->NamedGetter(cx, NonNullHelper(Constify(name)), found, &result, rv);
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLDocument named getter"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      JS::ExposeObjectToActiveJS(result);
      vp.setObject(*result);
      if (!MaybeWrapObjectValue(cx, vp)) {
        return false;
      }
      return true;
    }
  }

  bool foundOnPrototype;
  if (!GetPropertyOnPrototype(cx, proxy, receiver, id, &foundOnPrototype, vp)) {
    return false;
  }

  if (foundOnPrototype) {
    return true;
  }

  MOZ_ASSERT(vp.isUndefined());
  return true;
}

const char*
DOMProxyHandler::className(JSContext* cx, JS::Handle<JSObject*> proxy) const
{
  return "HTMLDocument";
}

bool
DOMProxyHandler::finalizeInBackground(const JS::Value& priv) const
{
  return false;
}

void
DOMProxyHandler::finalize(JS::GCContext* gcx, JSObject* proxy) const
{
  nsHTMLDocument* self = UnwrapPossiblyNotInitializedDOMObject<nsHTMLDocument>(proxy);
  if (self) {
    JS::SetReservedSlot(proxy, DOM_OBJECT_SLOT, JS::UndefinedValue());
    // Either our proxy created an expando object or not.  If it did,
    // then we would have preserved ourselves, and hence if we're going
    // away so is our C++ object and we should reset its expando value.
    // It's possible that in this situation the C++ object's reflector
    // pointer has been nulled out, but if not it's pointing to us.  If
    // our proxy did _not_ create an expando object then it's possible
    // that we're no longer the reflector for our C++ object (and
    // incremental finalization is finally getting to us), and that in
    // the meantime the new reflector has created an expando object.
    // In that case we do NOT want to clear the expando pointer in the
    // C++ object.
    //
    // It's important to do this before we ClearWrapper, of course.
    JSObject* reflector = self->GetWrapperMaybeDead();
    if (!reflector || reflector == proxy) {
      self->mExpandoAndGeneration.expando = JS::UndefinedValue();
    }
    ClearWrapper(self, self, proxy);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(proxy, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<nsHTMLDocument>(self);
  }
}

const DOMProxyHandler*
DOMProxyHandler::getInstance()
{
  static const DOMProxyHandler instance;
  return &instance;
}

bool
DOMProxyHandler::delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  // Try named delete only if the named property visibility
  // algorithm says the property is visible.
  bool tryNamedDelete = true;
  { // Scope for expando
    JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
    if (expando) {
      bool hasProp;
      if (!JS_HasPropertyById(cx, expando, id, &hasProp)) {
        return false;
      }
      tryNamedDelete = !hasProp;
    }
  }
  if (tryNamedDelete) {
    bool found = false;
    bool deleteSucceeded;
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      nsHTMLDocument* self = UnwrapProxy(proxy);
      FastErrorResult rv;
      JS::Rooted<JSObject*> result(cx);
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedGetter(cx, NonNullHelper(Constify(name)), found, &result, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->NamedGetter(cx, NonNullHelper(Constify(name)), found, &result, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLDocument named getter"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      (void)result;
    }
    deleteSucceeded = !found;
    if (found) {
      return deleteSucceeded ? opresult.succeed() : opresult.failCantDelete();
    }
  }

  return dom::DOMProxyHandler::delete_(cx, proxy, id, opresult);
}

size_t
DOMProxyHandler::objectMoved(JSObject* obj, JSObject* old) const
{
  return NativeTypeHelpers<nsHTMLDocument>::ObjectMoved(obj, old);
}

static const DOMJSClass sClass = {
  PROXY_CLASS_DEF("HTMLDocument",
                  JSCLASS_IS_DOMJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(2)),
  { prototypes::id::EventTarget, prototypes::id::Node, prototypes::id::Document, prototypes::id::HTMLDocument, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, nsHTMLDocument>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<nsHTMLDocument>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<nsHTMLDocument>::Get(),
  nullptr,
  nullptr
};

bool
Wrap(JSContext* aCx, nsHTMLDocument* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, nsHTMLDocument>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), nsHTMLDocument*>);
  MOZ_ASSERT(static_cast<mozilla::dom::Document*>(aObject) ==
             reinterpret_cast<mozilla::dom::Document*>(aObject),
             "Multiple inheritance for mozilla::dom::Document is broken.");
  MOZ_ASSERT(static_cast<nsINode*>(aObject) ==
             reinterpret_cast<nsINode*>(aObject),
             "Multiple inheritance for nsINode is broken.");
  MOZ_ASSERT(static_cast<mozilla::dom::EventTarget*>(aObject) ==
             reinterpret_cast<mozilla::dom::EventTarget*>(aObject),
             "Multiple inheritance for mozilla::dom::EventTarget is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    DOMProxyHandler::getInstance()->finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<nsHTMLDocument> creator(aCx);
  aObject->mExpandoAndGeneration.expando.setUndefined();
  JS::Rooted<JS::Value> expandoValue(aCx, JS::PrivateValue(&aObject->mExpandoAndGeneration));
  creator.CreateProxyObject(aCx, &sClass.mBase, DOMProxyHandler::getInstance(),
                            proto, /* aLazyProto = */ false, aObject,
                            expandoValue, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);

  // Important: do unforgeable property setup after we have handed
  // over ownership of the C++ object to obj as needed, so that if
  // we fail and it ends up GCed it won't have problems in the
  // finalizer trying to drop its ownership of the C++ object.
  JS::Rooted<JSObject*> expando(aCx,
    DOMProxyHandler::EnsureExpandoObject(aCx, aReflector));
  if (!expando) {
    aCache->ReleaseWrapper(aObject);
    aCache->ClearWrapper();
    return false;
  }
  JS::Rooted<JSObject*> unforgeableHolder(aCx,
    &JS::GetReservedSlot(canonicalProto, DOM_INTERFACE_PROTO_SLOTS_BASE).toObject());
  if (!JS_InitializePropertiesFromCompatibleNativeObject(aCx, expando, unforgeableHolder)) {
    aCache->ReleaseWrapper(aObject);
    aCache->ClearWrapper();
    return false;
  }
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::HTMLDocument);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::HTMLDocument);

  JS::Handle<JSObject*> parentProto(Document_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(Document_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "HTMLDocument",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);

  JS::Rooted<JSObject*> unforgeableHolder(
      aCx, JS_NewObjectWithoutMetadata(aCx, nullptr, nullptr));
  if (!unforgeableHolder) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  if (!DefineLegacyUnforgeableAttributes(aCx, unforgeableHolder, sUnforgeableAttributes)) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  if (*protoCache) {
    JS::SetReservedSlot(*protoCache, DOM_INTERFACE_PROTO_SLOTS_BASE,
                        JS::ObjectValue(*unforgeableHolder));
  }
}

JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::HTMLDocument,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JSObject*
GetProtoObject(JSContext* aCx)
{
  return GetProtoObjectHandle(aCx);
}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::HTMLDocument,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace HTMLDocument_Binding



} // namespace mozilla::dom
