/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/xpcom/threads/nsIEventTarget.idl
 */

#ifndef __gen_nsIEventTarget_h__
#define __gen_nsIEventTarget_h__


#include "nsISupports.h"

#include "nsIRunnable.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#include "nsCOMPtr.h"
#include "mozilla/AlreadyAddRefed.h"
#include "mozilla/Atomics.h"
#include "mozilla/TypedEnumBits.h"
class nsITargetShutdownTask;

/* starting interface:    nsIEventTarget */
#define NS_IEVENTTARGET_IID_STR "a03b8b63-af8b-4164-b0e5-c41e8b2b7cfa"

#define NS_IEVENTTARGET_IID \
  {0xa03b8b63, 0xaf8b, 0x4164, \
    { 0xb0, 0xe5, 0xc4, 0x1e, 0x8b, 0x2b, 0x7c, 0xfa }}

class nsIEventTarget : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IEVENTTARGET_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIEventTarget;

  enum DispatchFlags : uint32_t {
    DISPATCH_NORMAL = 0,
    DISPATCH_AT_END = 2,
    DISPATCH_EVENT_MAY_BLOCK = 4,
    DISPATCH_IGNORE_BLOCK_DISPATCH = 8,
    DISPATCH_FALLIBLE = 16,
  };

 public:
  // Infallible. Defined in nsThreadUtils.cpp. Delegates to
  // IsOnCurrentThreadInfallible when mThread is null.
  bool IsOnCurrentThread();
protected:
  mozilla::Atomic<PRThread*> mThread;
  nsIEventTarget() : mThread(nullptr) {}
    /* [noscript,notxpcom] boolean isOnCurrentThreadInfallible (); */
  NS_IMETHOD_(bool) IsOnCurrentThreadInfallible(void) = 0;

 public:
    /* boolean isOnCurrentThread (); */
  NS_IMETHOD IsOnCurrentThread(bool *_retval) = 0;

     nsresult Dispatch(nsIRunnable* aEvent, DispatchFlags aFlags) {
      return Dispatch(nsCOMPtr<nsIRunnable>(aEvent).forget(), aFlags);
    }
  /* [binaryname(Dispatch),noscript] void dispatchFromC (in alreadyAddRefed_nsIRunnable event, [default (DISPATCH_NORMAL)] in nsIEventTarget_DispatchFlags flags); */
  NS_IMETHOD Dispatch(already_AddRefed<nsIRunnable> event, nsIEventTarget::DispatchFlags flags = DISPATCH_NORMAL) = 0;

  /* [binaryname(DispatchFromScript)] void dispatch (in nsIRunnable event, in nsIEventTarget_DispatchFlags flags); */
  NS_IMETHOD DispatchFromScript(nsIRunnable *event, nsIEventTarget::DispatchFlags flags) = 0;

  /* [noscript] void delayedDispatch (in alreadyAddRefed_nsIRunnable event, in unsigned long delay); */
  NS_IMETHOD DelayedDispatch(already_AddRefed<nsIRunnable> event, uint32_t delay) = 0;

  /* [noscript] void registerShutdownTask (in nsITargetShutdownTask task); */
  NS_IMETHOD RegisterShutdownTask(nsITargetShutdownTask * task) = 0;

  /* [noscript] void unregisterShutdownTask (in nsITargetShutdownTask task); */
  NS_IMETHOD UnregisterShutdownTask(nsITargetShutdownTask * task) = 0;

  enum FeatureFlags : uint32_t {
    SUPPORTS_BASE = 0,
    SUPPORTS_SHUTDOWN_TASKS = 1,
    SUPPORTS_SHUTDOWN_TASK_DISPATCH = 2,
  };

  /* [noscript,notxpcom] nsIEventTarget_FeatureFlags getFeatures (); */
  NS_IMETHOD_(nsIEventTarget::FeatureFlags) GetFeatures(void) = 0;

};
namespace mozilla::detail {
template <>
class InterfaceNeedsThreadSafeRefCnt<nsIEventTarget> : public std::true_type {};
}


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIEVENTTARGET \
  NS_IMETHOD_(bool) IsOnCurrentThreadInfallible(void) override; \
  NS_IMETHOD IsOnCurrentThread(bool *_retval) override; \
  NS_IMETHOD Dispatch(already_AddRefed<nsIRunnable> event, nsIEventTarget::DispatchFlags flags = DISPATCH_NORMAL) override; \
  NS_IMETHOD DispatchFromScript(nsIRunnable *event, nsIEventTarget::DispatchFlags flags) override; \
  NS_IMETHOD DelayedDispatch(already_AddRefed<nsIRunnable> event, uint32_t delay) override; \
  NS_IMETHOD RegisterShutdownTask(nsITargetShutdownTask * task) override; \
  NS_IMETHOD UnregisterShutdownTask(nsITargetShutdownTask * task) override; \
  NS_IMETHOD_(nsIEventTarget::FeatureFlags) GetFeatures(void) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIEVENTTARGET \
  nsresult_(bool) IsOnCurrentThreadInfallible(void); \
  nsresult IsOnCurrentThread(bool *_retval); \
  nsresult Dispatch(already_AddRefed<nsIRunnable> event, nsIEventTarget::DispatchFlags flags = DISPATCH_NORMAL); \
  nsresult DispatchFromScript(nsIRunnable *event, nsIEventTarget::DispatchFlags flags); \
  nsresult DelayedDispatch(already_AddRefed<nsIRunnable> event, uint32_t delay); \
  nsresult RegisterShutdownTask(nsITargetShutdownTask * task); \
  nsresult UnregisterShutdownTask(nsITargetShutdownTask * task); \
  nsresult_(nsIEventTarget::FeatureFlags) GetFeatures(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIEVENTTARGET(_to) \
  NS_IMETHOD_(bool) IsOnCurrentThreadInfallible(void) override { return _to IsOnCurrentThreadInfallible(); } \
  NS_IMETHOD IsOnCurrentThread(bool *_retval) override { return _to IsOnCurrentThread(_retval); } \
  NS_IMETHOD Dispatch(already_AddRefed<nsIRunnable> event, nsIEventTarget::DispatchFlags flags = DISPATCH_NORMAL) override { return _to Dispatch(event, flags); } \
  NS_IMETHOD DispatchFromScript(nsIRunnable *event, nsIEventTarget::DispatchFlags flags) override { return _to DispatchFromScript(event, flags); } \
  NS_IMETHOD DelayedDispatch(already_AddRefed<nsIRunnable> event, uint32_t delay) override { return _to DelayedDispatch(event, delay); } \
  NS_IMETHOD RegisterShutdownTask(nsITargetShutdownTask * task) override { return _to RegisterShutdownTask(task); } \
  NS_IMETHOD UnregisterShutdownTask(nsITargetShutdownTask * task) override { return _to UnregisterShutdownTask(task); } \
  NS_IMETHOD_(nsIEventTarget::FeatureFlags) GetFeatures(void) override { return _to GetFeatures(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIEVENTTARGET(_to) \
  NS_IMETHOD_(bool) IsOnCurrentThreadInfallible(void) override; \
  NS_IMETHOD IsOnCurrentThread(bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->IsOnCurrentThread(_retval); } \
  NS_IMETHOD Dispatch(already_AddRefed<nsIRunnable> event, nsIEventTarget::DispatchFlags flags = DISPATCH_NORMAL) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Dispatch(event, flags); } \
  NS_IMETHOD DispatchFromScript(nsIRunnable *event, nsIEventTarget::DispatchFlags flags) override { return !_to ? NS_ERROR_NULL_POINTER : _to->DispatchFromScript(event, flags); } \
  NS_IMETHOD DelayedDispatch(already_AddRefed<nsIRunnable> event, uint32_t delay) override { return !_to ? NS_ERROR_NULL_POINTER : _to->DelayedDispatch(event, delay); } \
  NS_IMETHOD RegisterShutdownTask(nsITargetShutdownTask * task) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RegisterShutdownTask(task); } \
  NS_IMETHOD UnregisterShutdownTask(nsITargetShutdownTask * task) override { return !_to ? NS_ERROR_NULL_POINTER : _to->UnregisterShutdownTask(task); } \
  NS_IMETHOD_(nsIEventTarget::FeatureFlags) GetFeatures(void) override; 

// convenient aliases:
#define NS_DISPATCH_NORMAL nsIEventTarget::DISPATCH_NORMAL
#define NS_DISPATCH_AT_END nsIEventTarget::DISPATCH_AT_END
#define NS_DISPATCH_EVENT_MAY_BLOCK nsIEventTarget::DISPATCH_EVENT_MAY_BLOCK
#define NS_DISPATCH_IGNORE_BLOCK_DISPATCH nsIEventTarget::DISPATCH_IGNORE_BLOCK_DISPATCH
#define NS_DISPATCH_FALLIBLE nsIEventTarget::DISPATCH_FALLIBLE
// Convenience bitwise operators for the flag cenum
MOZ_MAKE_ENUM_CLASS_BITWISE_OPERATORS(nsIEventTarget::DispatchFlags)
MOZ_MAKE_ENUM_CLASS_BITWISE_OPERATORS(nsIEventTarget::FeatureFlags)
// Convenient NS_DECL variant that includes some C++-only methods.
#define NS_DECL_NSIEVENTTARGET_FULL                                   \
    NS_DECL_NSIEVENTTARGET                                            \
    /* Avoid hiding these methods */                                  \
    using nsIEventTarget::Dispatch;                                   \
    using nsIEventTarget::IsOnCurrentThread;

#endif /* __gen_nsIEventTarget_h__ */
