/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* urlpattern is implemented in third_party Rust code.
 * Since the library doesn't expose itself with extern "C" FFI calls,
 * we make our own wrapper to be able to call from C++. This file contains the
 * C declarations of these files.

 * WARNING: DO NOT CALL ANY OF THESE FUNCTIONS. USE |URLPatternGlue| INSTEAD! */
 

#ifndef mozilla_net_urlpattern_glue_h
#define mozilla_net_urlpattern_glue_h

/* Generated with cbindgen:0.29.2 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. */

#include "nsTArray.h"
#include "nsString.h"

// using MozURL = mozilla::net::MozURL;
namespace mozilla {
namespace net {
class MozURL;
}
}

typedef struct UrlPatternOptions UrlPatternOptions;



#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>
#include "nsString.h"
#include "atomic"

enum class UrlpStringOrInitType {
  String,
  Init,
};

struct UrlpOptions {
  bool ignore_case;
};

struct UrlpPattern {
  void *_0;
};

struct MaybeString {
  nsCString string;
  bool valid;
};

struct UrlpInit {
  MaybeString protocol;
  MaybeString username;
  MaybeString password;
  MaybeString hostname;
  MaybeString port;
  MaybeString pathname;
  MaybeString search;
  MaybeString hash;
  MaybeString base_url;
};

using UrlpComponentPtr = void*;

struct UrlpMatchInput {
  nsCString protocol;
  nsCString username;
  nsCString password;
  nsCString hostname;
  nsCString port;
  nsCString pathname;
  nsCString search;
  nsCString hash;
};

struct UrlpInput {
  UrlpStringOrInitType string_or_init_type;
  nsCString str;
  UrlpInit init;
  MaybeString base;
};

struct UrlpMatchInputAndInputs {
  UrlpMatchInput input;
  UrlpInput inputs;
};

using RegExpObjWrapper = void*;

extern "C" {

bool urlp_parse_pattern_from_string(const nsACString *input,
                                    const nsACString *base_url,
                                    UrlpOptions options,
                                    UrlpPattern *res);

bool urlp_parse_pattern_from_init(const UrlpInit *init, UrlpOptions options, UrlpPattern *res);

void urlp_pattern_free(UrlpPattern pattern);

bool urlp_get_has_regexp_groups(UrlpPattern pattern);

UrlpComponentPtr *urlp_get_protocol_component(UrlpPattern pattern);

UrlpComponentPtr *urlp_get_username_component(UrlpPattern pattern);

UrlpComponentPtr *urlp_get_password_component(UrlpPattern pattern);

UrlpComponentPtr *urlp_get_hostname_component(UrlpPattern pattern);

UrlpComponentPtr *urlp_get_port_component(UrlpPattern pattern);

UrlpComponentPtr *urlp_get_pathname_component(UrlpPattern pattern);

UrlpComponentPtr *urlp_get_search_component(UrlpPattern pattern);

UrlpComponentPtr *urlp_get_hash_component(UrlpPattern pattern);

void urlp_component_get_pattern_string(UrlpComponentPtr *component_ptr, nsCString *res);

void urlp_component_get_regexp_string(UrlpComponentPtr *component_ptr, nsCString *res);

void urlp_component_get_group_name_list(UrlpComponentPtr *component_ptr, nsTArray<nsCString> *res);

bool urlp_component_matches(UrlpComponentPtr *component_ptr,
                            const nsACString *input,
                            bool match_only,
                            nsTArray<MaybeString> *res);

bool urlp_process_match_input_from_string(const nsACString *url_str,
                                          const nsACString *base_url,
                                          UrlpMatchInputAndInputs *res);

bool urlp_process_match_input_from_init(const UrlpInit *init,
                                        const nsACString *base_url,
                                        UrlpMatchInputAndInputs *res);

extern bool parse_regexp_ffi(const uint16_t *pattern,
                             uintptr_t pattern_len,
                             const uint16_t *flags,
                             uintptr_t flags_len,
                             RegExpObjWrapper **res);

extern bool matches_regexp_ffi(RegExpObjWrapper *const *regexp_wrapper,
                               const uint8_t *string,
                               uintptr_t string_len,
                               bool match_only,
                               bool *match_result,
                               nsTArray<MaybeString> *res);

extern void free_regexp_ffi(RegExpObjWrapper *regexp_wrapper);

}  // extern "C"

#endif  // mozilla_net_urlpattern_glue_h
