// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanLibprefMetrics_h
#define mozilla_GleanLibprefMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace security {
  /**
   * generated from security.pref_usage_content_process
   */
  struct PrefUsageContentProcessExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * We block certain preferences from being sent to the content process because they contain sensitive user data. Some preferences are blocked by name, others by heuristic. If one of the preferences so blocked is accidently accessed we want to know about it so we can allowlist it or refactor the access. This event was generated to correspond to the Legacy Telemetry event security.prefUsage#contentProcess.
   */
  constexpr impl::EventMetric<PrefUsageContentProcessExtra> pref_usage_content_process(503);
}

namespace preferences {
  /**
   * generated from preferences.prefs_file_was_invalid
   * Set to true if a failure occurred reading profile/prefs.js. This metric was generated to correspond to the Legacy Telemetry scalar preferences.prefs_file_was_invalid.
   */
  constexpr impl::BooleanMetric prefs_file_was_invalid(4268);

  /**
   * generated from preferences.user_prefs
   */

  struct UserPrefsObjectItem {
    Maybe<nsCString> name;
    Maybe<nsCString> value;
  };

  using UserPrefsObject = nsTArray<UserPrefsObjectItem>;
  /**
   * The fossilized remains of the Legacy Telemetry Environment's
   * `settings.userPrefs` structure.
   * A list of pref names and values.
   * Some values will be the string "<user-set>" to obscure the value.
   * Do not add more prefs to this list.
   * Prefer instead to instrument your prefs directly with individual metrics.
   * See Environment.sys.mjs' `DEFAULT_ENVIRONMENT_PREFS`.
   */
  constexpr impl::ObjectMetric<UserPrefsObject, struct UserPrefsObjectTag> user_prefs(4269);
}

template <>
inline void impl::ObjectMetric<preferences::UserPrefsObject, preferences::UserPrefsObjectTag>::Set(const preferences::UserPrefsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.name.isSome()) {
          writer.StringProperty("name", *(aobjItem.name));
        }
        if (aobjItem.value.isSome()) {
          writer.StringProperty("value", *(aobjItem.value));
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

} // namespace mozilla::glean

#endif // mozilla_GleanLibprefMetrics_h
