// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomMetrics_h
#define mozilla_GleanDomMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace security {
  /**
   * generated from security.fission_principals
   */
  struct FissionPrincipalsExtra {
    mozilla::Maybe<nsCString> principaltype;
    mozilla::Maybe<nsCString> scheme;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (principaltype) {
        extraKeys.AppendElement()->AssignASCII("principalType");
        extraValues.EmplaceBack(principaltype.value());
      }
      if (scheme) {
        extraKeys.AppendElement()->AssignASCII("scheme");
        extraValues.EmplaceBack(scheme.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * When running with Fission, we received an unexpected principal from the content process. Expected values for this telemetry event are the method names in ContentParent that received the unexpected principal. This event was generated to correspond to the Legacy Telemetry event security.fissionPrincipals#contentParent.
   */
  constexpr impl::EventMetric<FissionPrincipalsExtra> fission_principals(493);

  /**
   * generated from security.shadowed_html_document_property_access
   */
  struct ShadowedHtmlDocumentPropertyAccessExtra {
    mozilla::Maybe<nsCString> name;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (name) {
        extraKeys.AppendElement()->AssignASCII("name");
        extraValues.EmplaceBack(name.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * When accessing a property on the HTMLDocument like (document.currentScript), if that property was shadowed/"clobbered" (e.g. using <img name=currentScript>), the name of the shadowed built-in property is collected.
   */
  constexpr impl::EventMetric<ShadowedHtmlDocumentPropertyAccessExtra> shadowed_html_document_property_access(494);
}

namespace performance_page {
  /**
   * generated from performance.page.non_blank_paint
   * The time between navigationStart and the first non-blank paint of a foreground root content document, in milliseconds. This only records documents that were in an active docshell throughout the whole time between navigation start and non-blank paint. The non-blank paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric non_blank_paint(1339);
}

namespace dom {
  /**
   * generated from dom.blink_filesystem_used
   */
  enum class BlinkFilesystemUsedLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Webkit/Blink filesystem used
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram BLINK_FILESYSTEM_USED.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, BlinkFilesystemUsedLabel> blink_filesystem_used(3923);

  /**
   * generated from dom.forget_skippable_during_idle
   * Percent of the cycle collector's forget skippable done during idle time
   * This metric was generated to correspond to the Legacy Telemetry linear histogram FORGET_SKIPPABLE_DURING_IDLE.
   */
  constexpr impl::CustomDistributionMetric forget_skippable_during_idle(3924);

  /**
   * generated from dom.forget_skippable_frequency
   * Number of forget skippables occurred during a minute
   * This metric was generated to correspond to the Legacy Telemetry linear histogram FORGET_SKIPPABLE_FREQUENCY.
   */
  constexpr impl::CustomDistributionMetric forget_skippable_frequency(3925);

  /**
   * generated from dom.fullscreen_transition_black
   * The time spent in the fully-black screen in fullscreen transition
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FULLSCREEN_TRANSITION_BLACK_MS.
   */
  constexpr impl::TimingDistributionMetric fullscreen_transition_black(3926);

  /**
   * generated from dom.gc_in_progress
   * Time from the beginning of the first slice to the end of the last slice (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram GC_IN_PROGRESS_MS.
   */
  constexpr impl::TimingDistributionMetric gc_in_progress(3927);

  /**
   * generated from dom.gc_slice_during_idle
   * Percent of GC slice done during idle time
   * This metric was generated to correspond to the Legacy Telemetry linear histogram GC_SLICE_DURING_IDLE.
   */
  constexpr impl::CustomDistributionMetric gc_slice_during_idle(3928);

  /**
   * generated from dom.script_loading_source
   */
  enum class ScriptLoadingSourceLabel: uint16_t {
    eInline = 0,
    eSourcefallback = 1,
    eSource = 2,
    eAltdata = 3,
    e__Other__,
  };
  /**
   * Record the input from which the bytes are coming from, for each script in a document.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram DOM_SCRIPT_LOADING_SOURCE.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ScriptLoadingSourceLabel> script_loading_source(3929);

  /**
   * generated from dom.slow_script_notice_count
   * Count slow script notices
   * This metric was generated to correspond to the Legacy Telemetry count histogram SLOW_SCRIPT_NOTICE_COUNT.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> slow_script_notice_count(3930);

  /**
   * generated from dom.slow_script_page_count
   * The number of pages that trigger slow script notices
   * This metric was generated to correspond to the Legacy Telemetry count histogram SLOW_SCRIPT_PAGE_COUNT.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> slow_script_page_count(3931);

  /**
   * generated from dom.storage_access_api_ui
   */
  enum class StorageAccessApiUiLabel: uint16_t {
    eRequest = 0,
    eAllowautomatically = 1,
    eDeny = 2,
    eAllow = 3,
    eAllowonanysite = 4,
    e__Other__,
  };
  /**
   * Storage Access API UI events.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram STORAGE_ACCESS_API_UI.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, StorageAccessApiUiLabel> storage_access_api_ui(3932);

  /**
   * generated from dom.webkit_directory_used
   */
  enum class WebkitDirectoryUsedLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * HTMLInputElement.webkitdirectory attribute used
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram WEBKIT_DIRECTORY_USED.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, WebkitDirectoryUsedLabel> webkit_directory_used(3933);

  /**
   * generated from dom.xmlhttprequest_async_or_sync
   */
  enum class XmlhttprequestAsyncOrSyncLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Type of XMLHttpRequest, async or sync
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram XMLHTTPREQUEST_ASYNC_OR_SYNC.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, XmlhttprequestAsyncOrSyncLabel> xmlhttprequest_async_or_sync(3934);
}

namespace dom_contentprocess {
  /**
   * generated from dom.contentprocess.build_id_mismatch
   * The number of times the about:restartrequired page appeared due to a buildID mismatch between the parent and the content processes. This metric was generated to correspond to the Legacy Telemetry scalar dom.contentprocess.buildID_mismatch.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> build_id_mismatch(3935);

  /**
   * generated from dom.contentprocess.build_id_mismatch_false_positive
   * The number of times a process crashed early but we could verify it was not because of buildID mismatch between the parent and the content processes. This metric was generated to correspond to the Legacy Telemetry scalar dom.contentprocess.buildID_mismatch_false_positive.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> build_id_mismatch_false_positive(3936);

  /**
   * generated from dom.contentprocess.launch_is_sync
   */
  enum class LaunchIsSyncLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether a content process was launched synchronously (unnecessarily delaying UI response).
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CONTENT_PROCESS_LAUNCH_IS_SYNC.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, LaunchIsSyncLabel> launch_is_sync(3937);

  /**
   * generated from dom.contentprocess.launch_mainthread
   * Time spent on the main thread during asynchronous content process launch.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CONTENT_PROCESS_LAUNCH_MAINTHREAD_MS.
   */
  constexpr impl::TimingDistributionMetric launch_mainthread(3938);

  /**
   * generated from dom.contentprocess.launch_total
   * Total time elapsed during asynchronous content process launch, until the process is usable for loading content.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CONTENT_PROCESS_LAUNCH_TOTAL_MS.
   */
  constexpr impl::TimingDistributionMetric launch_total(3939);

  /**
   * generated from dom.contentprocess.os_priority_change_considered
   * The number of times we've had the opportunity to change content process priority due to a tab switch or a tab being opened. This metric was generated to correspond to the Legacy Telemetry scalar dom.contentprocess.os_priority_change_considered.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> os_priority_change_considered(3940);

  /**
   * generated from dom.contentprocess.os_priority_lowered
   * The number of times a content process has had its OS priority lowered due to only containing background tabs without audible media playing. This metric was generated to correspond to the Legacy Telemetry scalar dom.contentprocess.os_priority_lowered.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> os_priority_lowered(3941);

  /**
   * generated from dom.contentprocess.os_priority_raised
   * The number of times a content process has had its OS priority raised due to containing at least one foregrounded tab, or a tab with audible media has started playing in it. This metric was generated to correspond to the Legacy Telemetry scalar dom.contentprocess.os_priority_raised.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> os_priority_raised(3942);

  /**
   * generated from dom.contentprocess.sync_launch
   * Time elapsed during synchronous content process launch until the process is usable for loading content.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CONTENT_PROCESS_SYNC_LAUNCH_MS.
   */
  constexpr impl::TimingDistributionMetric sync_launch(3943);
}

namespace dom_parentprocess {
  /**
   * generated from dom.parentprocess.private_window_used
   * Whether a private browsing window has been used in the session. This metric was generated to correspond to the Legacy Telemetry scalar dom.parentprocess.private_window_used.
   */
  constexpr impl::BooleanMetric private_window_used(3944);

  /**
   * generated from dom.parentprocess.process_launch_errors
   * Collect precise set of error code and calling site upon process creation failure path. This metric was generated to correspond to the Legacy Telemetry scalar dom.parentprocess.process_launch_errors.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> process_launch_errors(3945);
}

namespace dom_textfragment {
  /**
   * generated from dom.textfragment.create_directive
   * Time spent in FragmentDirective::CreateTextDirective()
   */
  constexpr impl::TimingDistributionMetric create_directive(3946);

  /**
   * generated from dom.textfragment.find_directives
   * Time spent in TextDirectiveFinder::FindTextDirectivesInDocument() per page load
   */
  constexpr impl::TimingDistributionMetric find_directives(3947);
}

namespace perf {
  /**
   * generated from perf.cold_applink_main_to_load_uri
   * The duration from StartupTimeline::MAIN to load URI for an android cold applink.
   */
  constexpr impl::TimingDistributionMetric cold_applink_main_to_load_uri(3948);

  /**
   * generated from perf.cold_applink_process_launch_to_load_uri
   * The duration from cold process launch to load URI for an android cold applink.
   */
  constexpr impl::TimingDistributionMetric cold_applink_process_launch_to_load_uri(3949);

  /**
   * generated from perf.dns_first_byte
   * The time from a top-level document's HTTP channel open to the first byte of the reply is received (ms). Keyed by TRR domain for DoH or 'Native' otherwise
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_PERF_FIRST_BYTE_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> dns_first_byte(3950);

  /**
   * generated from perf.h3p_first_contentful_paint
   * The time between navigationStart and the first contentful paint of a foreground http or https root content document, in milliseconds. The contentful paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. This is collected only on page load where the main document uses HTTP3. It is keyed based on whether a "priority" header has been received.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram H3P_PERF_FIRST_CONTENTFUL_PAINT_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> h3p_first_contentful_paint(3951);

  /**
   * generated from perf.h3p_page_load_time
   * Time in milliseconds from navigationStart to loadEventStart for the foreground http or https root content document. This is collected only on page load where the main document uses HTTP3. It is keyed based on whether a "priority" header has been received.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram H3P_PERF_PAGE_LOAD_TIME_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> h3p_page_load_time(3952);

  /**
   * generated from perf.largest_contentful_paint
   * Time from navigation start to largest contentful paint.
   */
  constexpr impl::TimingDistributionMetric largest_contentful_paint(3953);

  /**
   * generated from perf.largest_contentful_paint_from_response_start
   * Time from response start to largest contentful paint.
   */
  constexpr impl::TimingDistributionMetric largest_contentful_paint_from_response_start(3954);

  /**
   * generated from perf.page_load
   */
  struct PageLoadExtra {
    mozilla::Maybe<uint32_t> androidAppLinkLaunchType;
    mozilla::Maybe<uint32_t> androidAppLinkToNavigationStart;
    mozilla::Maybe<nsCString> androidIsolationCategory;
    mozilla::Maybe<uint32_t> cacheDisposition;
    mozilla::Maybe<uint32_t> delazifyTime;
    mozilla::Maybe<uint32_t> dnsLookupTime;
    mozilla::Maybe<uint32_t> documentFeatures;
    mozilla::Maybe<uint32_t> fcpTime;
    mozilla::Maybe<bool> hasSsd;
    mozilla::Maybe<uint32_t> httpVer;
    mozilla::Maybe<uint32_t> jsExecTime;
    mozilla::Maybe<uint32_t> lcpTime;
    mozilla::Maybe<uint32_t> loadTime;
    mozilla::Maybe<nsCString> loadType;
    mozilla::Maybe<uint32_t> networkType;
    mozilla::Maybe<uint32_t> redirectCount;
    mozilla::Maybe<uint32_t> redirectTime;
    mozilla::Maybe<uint32_t> responseTime;
    mozilla::Maybe<bool> sameOriginNav;
    mozilla::Maybe<uint32_t> timeToRequestStart;
    mozilla::Maybe<uint32_t> tlsHandshakeTime;
    mozilla::Maybe<nsCString> trrDomain;
    mozilla::Maybe<uint32_t> userFeatures;
    mozilla::Maybe<bool> usingWebdriver;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (androidAppLinkLaunchType) {
        extraKeys.AppendElement()->AssignASCII("android_app_link_launch_type");
        extraValues.AppendElement()->AppendInt(androidAppLinkLaunchType.value());
      }
      if (androidAppLinkToNavigationStart) {
        extraKeys.AppendElement()->AssignASCII("android_app_link_to_navigation_start");
        extraValues.AppendElement()->AppendInt(androidAppLinkToNavigationStart.value());
      }
      if (androidIsolationCategory) {
        extraKeys.AppendElement()->AssignASCII("android_isolation_category");
        extraValues.EmplaceBack(androidIsolationCategory.value());
      }
      if (cacheDisposition) {
        extraKeys.AppendElement()->AssignASCII("cache_disposition");
        extraValues.AppendElement()->AppendInt(cacheDisposition.value());
      }
      if (delazifyTime) {
        extraKeys.AppendElement()->AssignASCII("delazify_time");
        extraValues.AppendElement()->AppendInt(delazifyTime.value());
      }
      if (dnsLookupTime) {
        extraKeys.AppendElement()->AssignASCII("dns_lookup_time");
        extraValues.AppendElement()->AppendInt(dnsLookupTime.value());
      }
      if (documentFeatures) {
        extraKeys.AppendElement()->AssignASCII("document_features");
        extraValues.AppendElement()->AppendInt(documentFeatures.value());
      }
      if (fcpTime) {
        extraKeys.AppendElement()->AssignASCII("fcp_time");
        extraValues.AppendElement()->AppendInt(fcpTime.value());
      }
      if (hasSsd) {
        extraKeys.AppendElement()->AssignASCII("has_ssd");
        extraValues.AppendElement()->AssignASCII(hasSsd.value() ? "true" : "false");
      }
      if (httpVer) {
        extraKeys.AppendElement()->AssignASCII("http_ver");
        extraValues.AppendElement()->AppendInt(httpVer.value());
      }
      if (jsExecTime) {
        extraKeys.AppendElement()->AssignASCII("js_exec_time");
        extraValues.AppendElement()->AppendInt(jsExecTime.value());
      }
      if (lcpTime) {
        extraKeys.AppendElement()->AssignASCII("lcp_time");
        extraValues.AppendElement()->AppendInt(lcpTime.value());
      }
      if (loadTime) {
        extraKeys.AppendElement()->AssignASCII("load_time");
        extraValues.AppendElement()->AppendInt(loadTime.value());
      }
      if (loadType) {
        extraKeys.AppendElement()->AssignASCII("load_type");
        extraValues.EmplaceBack(loadType.value());
      }
      if (networkType) {
        extraKeys.AppendElement()->AssignASCII("network_type");
        extraValues.AppendElement()->AppendInt(networkType.value());
      }
      if (redirectCount) {
        extraKeys.AppendElement()->AssignASCII("redirect_count");
        extraValues.AppendElement()->AppendInt(redirectCount.value());
      }
      if (redirectTime) {
        extraKeys.AppendElement()->AssignASCII("redirect_time");
        extraValues.AppendElement()->AppendInt(redirectTime.value());
      }
      if (responseTime) {
        extraKeys.AppendElement()->AssignASCII("response_time");
        extraValues.AppendElement()->AppendInt(responseTime.value());
      }
      if (sameOriginNav) {
        extraKeys.AppendElement()->AssignASCII("same_origin_nav");
        extraValues.AppendElement()->AssignASCII(sameOriginNav.value() ? "true" : "false");
      }
      if (timeToRequestStart) {
        extraKeys.AppendElement()->AssignASCII("time_to_request_start");
        extraValues.AppendElement()->AppendInt(timeToRequestStart.value());
      }
      if (tlsHandshakeTime) {
        extraKeys.AppendElement()->AssignASCII("tls_handshake_time");
        extraValues.AppendElement()->AppendInt(tlsHandshakeTime.value());
      }
      if (trrDomain) {
        extraKeys.AppendElement()->AssignASCII("trr_domain");
        extraValues.EmplaceBack(trrDomain.value());
      }
      if (userFeatures) {
        extraKeys.AppendElement()->AssignASCII("user_features");
        extraValues.AppendElement()->AppendInt(userFeatures.value());
      }
      if (usingWebdriver) {
        extraKeys.AppendElement()->AssignASCII("using_webdriver");
        extraValues.AppendElement()->AssignASCII(usingWebdriver.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a top level content document has been loaded.
   */
  constexpr impl::EventMetric<PageLoadExtra> page_load(3955);

  /**
   * generated from perf.page_load_domain
   */
  struct PageLoadDomainExtra {
    mozilla::Maybe<uint32_t> appVersionMajor;
    mozilla::Maybe<nsCString> channel;
    mozilla::Maybe<uint32_t> documentFeatures;
    mozilla::Maybe<nsCString> domain;
    mozilla::Maybe<uint32_t> httpVer;
    mozilla::Maybe<uint32_t> lcpTime;
    mozilla::Maybe<nsCString> loadType;
    mozilla::Maybe<bool> sameOriginNav;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (appVersionMajor) {
        extraKeys.AppendElement()->AssignASCII("app_version_major");
        extraValues.AppendElement()->AppendInt(appVersionMajor.value());
      }
      if (channel) {
        extraKeys.AppendElement()->AssignASCII("channel");
        extraValues.EmplaceBack(channel.value());
      }
      if (documentFeatures) {
        extraKeys.AppendElement()->AssignASCII("document_features");
        extraValues.AppendElement()->AppendInt(documentFeatures.value());
      }
      if (domain) {
        extraKeys.AppendElement()->AssignASCII("domain");
        extraValues.EmplaceBack(domain.value());
      }
      if (httpVer) {
        extraKeys.AppendElement()->AssignASCII("http_ver");
        extraValues.AppendElement()->AppendInt(httpVer.value());
      }
      if (lcpTime) {
        extraKeys.AppendElement()->AssignASCII("lcp_time");
        extraValues.AppendElement()->AppendInt(lcpTime.value());
      }
      if (loadType) {
        extraKeys.AppendElement()->AssignASCII("load_type");
        extraValues.EmplaceBack(loadType.value());
      }
      if (sameOriginNav) {
        extraKeys.AppendElement()->AssignASCII("same_origin_nav");
        extraValues.AppendElement()->AssignASCII(sameOriginNav.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a top level content document has been loaded. Includes ETLD+1 information and sent with ohttp.
   */
  constexpr impl::EventMetric<PageLoadDomainExtra> page_load_domain(3956);
}

namespace performance_pageload {
  /**
   * generated from performance.pageload.fcp
   * The time between navigationStart and the first contentful paint of a foreground http or https root content document, in milliseconds. The contentful paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric fcp(3957);

  /**
   * generated from performance.pageload.fcp_responsestart
   * The time between responseStart and the first contentful paint of a foreground http or https root content document, in milliseconds. The contentful paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric fcp_responsestart(3958);

  /**
   * generated from performance.pageload.h3p_fcp_with_priority
   * The time between navigationStart and the first contentful paint of a foreground http or https root content document, in milliseconds. The contentful paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. This is collected only on page load where the main document uses HTTP3. A "priority" header has been received.
   */
  constexpr impl::TimingDistributionMetric h3p_fcp_with_priority(3959);

  /**
   * generated from performance.pageload.http3_fcp_http3
   * The time between navigationStart and the first contentful paint of a foreground http or https root content document, in milliseconds. The contentful paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. This is collected only on page load where the main document uses or suppports HTTP3.
   */
  constexpr impl::TimingDistributionMetric http3_fcp_http3(3960);

  /**
   * generated from performance.pageload.http3_fcp_supports_http3
   * The time between navigationStart and the first contentful paint of a foreground http or https root content document, in milliseconds. The contentful paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. This is collected only on page load where the main document supports but is not using HTTP3.
   */
  constexpr impl::TimingDistributionMetric http3_fcp_supports_http3(3961);

  /**
   * generated from performance.pageload.http3_fcp_without_priority
   * The time between navigationStart and the first contentful paint of a foreground http or https root content document, in milliseconds. The contentful paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. This is collected only on page load where the main document uses HTTP3. A "priority" header has not been received.
   */
  constexpr impl::TimingDistributionMetric http3_fcp_without_priority(3962);

  /**
   * generated from performance.pageload.load_time
   * Time in milliseconds from navigationStart to loadEventStart for the foreground http or https root content document. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric load_time(3963);

  /**
   * generated from performance.pageload.load_time_responsestart
   * Time in milliseconds from responseStart to loadEventStart for the foreground http or https root content document. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric load_time_responsestart(3964);
}

namespace performance_time {
  /**
   * generated from performance.time.dom_complete
   * Time from navigationStart to domComplete as per the W3C Performance Timing API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric dom_complete(3965);

  /**
   * generated from performance.time.dom_content_loaded_end
   * Time from navigationStart to domContentLoadedEventEnd as per the W3C Performance Timing API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric dom_content_loaded_end(3966);

  /**
   * generated from performance.time.dom_content_loaded_start
   * Time from navigationStart to domContentLoadedEventStart as per the W3C Performance Timing API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric dom_content_loaded_start(3967);

  /**
   * generated from performance.time.dom_interactive
   * Time from navigationStart to domInteractive as per the W3C Performance Timing API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric dom_interactive(3968);

  /**
   * generated from performance.time.load_event_end
   * Time from navigationStart to loadEventEnd as per the W3C Performance Timing API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric load_event_end(3969);

  /**
   * generated from performance.time.load_event_start
   * Time from navigationStart to loadEventStart as per the W3C Performance Timing API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric load_event_start(3970);

  /**
   * generated from performance.time.to_dom_loading
   * Time in milliseconds from navigationStart to domLoading.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TIME_TO_DOM_LOADING_MS.
   */
  constexpr impl::TimingDistributionMetric to_dom_loading(3971);

  /**
   * generated from performance.time.to_first_contentful_paint
   * The time between navigation start and the first contentful paint of a foreground root content document, in milliseconds. This only records documents that were in an active docshell throughout the whole time between navigation start and contentful paint. The contentful paint timestamp is taken during display list building and does not include rasterization or compositing of that paint.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TIME_TO_FIRST_CONTENTFUL_PAINT_MS.
   */
  constexpr impl::TimingDistributionMetric to_first_contentful_paint(3972);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomMetrics_h
