// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomMediaHlsMetrics_h
#define mozilla_GleanDomMediaHlsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace hls {
  /**
   * generated from hls.canplay_requested
   * Record when a page requests canPlayType for a HLS media type.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> canplay_requested(3814);

  /**
   * generated from hls.canplay_supported
   * Record when a canPlayType request supports HLS.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> canplay_supported(3815);

  /**
   * generated from hls.media_load
   */
  struct MediaLoadExtra {
    mozilla::Maybe<nsCString> mediaExtension;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (mediaExtension) {
        extraKeys.AppendElement()->AssignASCII("media_extension");
        extraValues.EmplaceBack(mediaExtension.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record the information about the HLS playback on Android using ExoPlayer. The value of this event contains the media format.
   */
  constexpr impl::EventMetric<MediaLoadExtra> media_load(3816);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomMediaHlsMetrics_h
