// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomGeolocationMetrics_h
#define mozilla_GleanDomGeolocationMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace geolocation {
  /**
   * generated from geolocation.accuracy
   * Accuracy returned by the Geolocation API
   */
  constexpr impl::CustomDistributionMetric accuracy(3794);

  /**
   * generated from geolocation.fallback
   */
  enum class FallbackLabel: uint16_t {
    eNone = 0,
    eOnError = 1,
    eOnTimeout = 2,
    e__Other__,
  };
  /**
   * Whether the default provider falled back to NetworkGeolocationProvider.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, FallbackLabel> fallback(3795);

  /**
   * generated from geolocation.geoclue_error_code
   * Records the error code when Linux GeoClue geolocation fails. The GeoClue DBUS error domain is G_DBUS_ERROR and can usually be used to get a human readable error for these values.  Records up to 16 codes. Note that errors G_DBUS_ERROR_LIMITS_EXCEEDED (8), G_DBUS_ERROR_ACCESS_DENIED(9), and G_DBUS_ERROR_AUTH_FAILED (10) are considered by Firefox to mean that permission is not granted, as opposed to an internal error.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> geoclue_error_code(3796);

  /**
   * generated from geolocation.geolocation_cache_hit
   */
  enum class GeolocationCacheHitLabel: uint16_t {
    eNsgeolocationrequest = 0,
    eNetworkgeolocationprovider = 1,
    e__Other__,
  };
  /**
   * How many times was a geolocation request serviced by the given cache.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, GeolocationCacheHitLabel> geolocation_cache_hit(3797);

  /**
   * generated from geolocation.geolocation_service
   */
  enum class GeolocationServiceLabel: uint16_t {
    eSystem = 0,
    eNetworkWifiAndIp = 1,
    eNetworkIp = 2,
    eGeoclue = 3,
    e__Other__,
  };
  /**
   * How many geolocation requests were issued to the system provider, the network wifi-lookup provider, the network ip-lookup provider, and the Linux GeoClue service?  Wifi and IP currently use the same provider.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, GeolocationServiceLabel> geolocation_service(3798);

  /**
   * generated from geolocation.linux_portal_error
   */
  enum class LinuxPortalErrorLabel: uint16_t {
    eEmptyResponse = 0,
    eCantReadResponse = 1,
    e__Other__,
  };
  /**
   * Records the reason for failures in the PortalLocationProvider.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, LinuxPortalErrorLabel> linux_portal_error(3799);

  /**
   * generated from geolocation.linux_provider
   */
  enum class LinuxProviderLabel: uint16_t {
    eNone = 0,
    ePortal = 1,
    eGeoclue = 2,
    e__Other__,
  };
  /**
   * Which system provider are we using on Linux
   */
  constexpr impl::Labeled<impl::BooleanMetric, LinuxProviderLabel> linux_provider(3800);

  /**
   * generated from geolocation.macos_error_code
   * Records the error code when MacOS CoreLocation geolocation fails. The CoreLocation error domain is kCLErrorDomain and can usually be used to get a human readable error for these values.  Records up to 16 codes.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> macos_error_code(3801);

  /**
   * generated from geolocation.request_result
   */
  enum class RequestResultLabel: uint16_t {
    eSuccess = 0,
    ePermissionDenied = 1,
    ePositionUnavailable = 2,
    eTimeout = 3,
    e__Other__,
  };
  /**
   * The result for each geolocation request. Success label will only happen once for each request, even if it's a watch request.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, RequestResultLabel> request_result(3802);

  /**
   * generated from geolocation.windows_failure
   * Records the reason the WindowsLocationChild reported failure to get location.
   */
  constexpr impl::DualLabeledCounterMetric windows_failure(3803);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomGeolocationMetrics_h
