/* THIS FILE IS AUTOGENERATED FROM Window.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_WINDOWBINDING_H_
#define DOM_WINDOWBINDING_H_

#include "MessagePortBinding.h"
#include "js/CallAndConstruct.h"
#include "jsapi.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/RemoteObjectProxy.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"

class nsGlobalWindowInner;

namespace mozilla {
namespace dom {

class Event;
class IdleDeadline;
class IdleRequestCallback;
struct IdleRequestOptionsAtoms;
struct NativePropertyHooks;
class OwningEventOrUndefined;
class PromiseDocumentFlushedCallback;
class ProtoAndIfaceCache;
struct ScrollOptionsAtoms;
struct ScrollToOptionsAtoms;
struct SizeToContentConstraintsAtoms;
struct SynthesizeEventDataAtoms;
struct SynthesizeEventOptionsAtoms;
struct SynthesizeMouseEventDataAtoms;
struct SynthesizeMouseEventOptionsAtoms;
struct SynthesizeTouchEventDataAtoms;
struct SynthesizeTouchEventOptionsAtoms;
struct WindowPostMessageOptionsAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class ScrollBehavior : uint8_t {
  Auto,
  Instant,
  Smooth,
};

namespace binding_detail {
template <> struct EnumStrings<ScrollBehavior> {
  static constexpr nsLiteralCString Values[3] {
    "auto"_ns,
    "instant"_ns,
    "smooth"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ScrollBehavior aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningEventOrUndefined& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningEventOrUndefined& aUnion);


class EventOrUndefined : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eEvent,
    eUndefined
  };
public:
  enum class Type
  {
    eEvent = TypeOrUninit::eEvent,
    eUndefined = TypeOrUninit::eUndefined
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::Event> > mEvent;

  };

  TypeOrUninit mType;
  Value mValue;

  EventOrUndefined(const EventOrUndefined&) = delete;
  EventOrUndefined& operator=(const EventOrUndefined&) = delete;
public:
  explicit inline EventOrUndefined()
    : mType(eUninitialized)
  {
  }

  inline ~EventOrUndefined()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Event>&
  RawSetAsEvent()
  {
    if (mType == eEvent) {
      return mValue.mEvent.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eEvent;
    return mValue.mEvent.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Event>&
  SetAsEvent()
  {
    if (mType == eEvent) {
      return mValue.mEvent.Value();
    }
    Uninit();
    mType = eEvent;
    return mValue.mEvent.SetValue();
  }

  inline bool
  IsEvent() const
  {
    return mType == eEvent;
  }

  inline NonNull<mozilla::dom::Event>&
  GetAsEvent()
  {
    MOZ_RELEASE_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  inline mozilla::dom::Event&
  GetAsEvent() const
  {
    MOZ_RELEASE_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eEvent: {
        DestroyEvent();
        break;
      }
      case eUndefined: {
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToEvent(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToEvent(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyEvent()
  {
    MOZ_RELEASE_ASSERT(IsEvent(), "Wrong type!");
    mValue.mEvent.Destroy();
    mType = eUninitialized;
  }
};


class OwningEventOrUndefined : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningEventOrUndefined& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eEvent,
    eUndefined
  };
public:
  enum class Type
  {
    eEvent = TypeOrUninit::eEvent,
    eUndefined = TypeOrUninit::eUndefined
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Event> > mEvent;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningEventOrUndefined()
    : mType(eUninitialized)
  {
  }

  OwningEventOrUndefined(OwningEventOrUndefined&& aOther);

  explicit inline OwningEventOrUndefined(const OwningEventOrUndefined& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningEventOrUndefined()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Event>&
  RawSetAsEvent();

  [[nodiscard]] OwningNonNull<mozilla::dom::Event>&
  SetAsEvent();

  inline bool
  IsEvent() const
  {
    return mType == eEvent;
  }

  inline OwningNonNull<mozilla::dom::Event>&
  GetAsEvent()
  {
    MOZ_RELEASE_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  inline OwningNonNull<mozilla::dom::Event> const &
  GetAsEvent() const
  {
    MOZ_RELEASE_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningEventOrUndefined&
  operator=(OwningEventOrUndefined&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningEventOrUndefined&
  operator=(const OwningEventOrUndefined& aOther);

private:
  bool
  TrySetToEvent(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToEvent(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyEvent();
};


class IdleRequestCallback : public CallbackFunction
{
public:
  explicit inline IdleRequestCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IdleRequestCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IdleRequestCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IdleRequestCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, IdleDeadline& deadline, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "IdleRequestCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, deadline, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(IdleDeadline& deadline, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "IdleRequestCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, deadline, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, IdleDeadline& deadline, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, deadline, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(IdleDeadline& deadline, const char* aExecutionReason = nullptr)
  {
    return Call(deadline, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const IdleRequestCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, IdleDeadline& deadline, ErrorResult& aRv);
};


namespace binding_detail {
class FastIdleRequestCallback : public IdleRequestCallback
{
public:
  explicit inline FastIdleRequestCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : IdleRequestCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    IdleRequestCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    IdleRequestCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct IdleRequestOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mTimeout;

  IdleRequestOptions();

  explicit inline IdleRequestOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  IdleRequestOptions(IdleRequestOptions&& aOther) = default;

  explicit inline IdleRequestOptions(const IdleRequestOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  IdleRequestOptions&
  operator=(const IdleRequestOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, IdleRequestOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastIdleRequestOptions : public IdleRequestOptions
{
  inline FastIdleRequestOptions()
    : IdleRequestOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class PromiseDocumentFlushedCallback : public CallbackFunction
{
public:
  explicit inline PromiseDocumentFlushedCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline PromiseDocumentFlushedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline PromiseDocumentFlushedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline PromiseDocumentFlushedCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "PromiseDocumentFlushedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, aRetVal, aRv);
  }

  inline void
  Call(JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "PromiseDocumentFlushedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, aRetVal, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, JS::MutableHandle<JS::Value> aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, aRetVal, IgnoreErrors(), aExecutionReason);
  }

  inline void
  Call(JS::MutableHandle<JS::Value> aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(aRetVal, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const PromiseDocumentFlushedCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv);
};


namespace binding_detail {
class FastPromiseDocumentFlushedCallback : public PromiseDocumentFlushedCallback
{
public:
  explicit inline FastPromiseDocumentFlushedCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : PromiseDocumentFlushedCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    PromiseDocumentFlushedCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    PromiseDocumentFlushedCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct ScrollOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR ScrollBehavior mBehavior;

  ScrollOptions();

  explicit inline ScrollOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ScrollOptions(ScrollOptions&& aOther) = default;

  explicit inline ScrollOptions(const ScrollOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ScrollOptions&
  operator=(const ScrollOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ScrollOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastScrollOptions : public ScrollOptions
{
  inline FastScrollOptions()
    : ScrollOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SizeToContentConstraints : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR int32_t mMaxHeight;
  MOZ_INIT_OUTSIDE_CTOR int32_t mMaxWidth;
  MOZ_INIT_OUTSIDE_CTOR int32_t mPrefWidth;

  SizeToContentConstraints();

  explicit inline SizeToContentConstraints(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SizeToContentConstraints(SizeToContentConstraints&& aOther) = default;

  explicit inline SizeToContentConstraints(const SizeToContentConstraints& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SizeToContentConstraints&
  operator=(const SizeToContentConstraints& aOther);

private:
  static bool
  InitIds(JSContext* cx, SizeToContentConstraintsAtoms* atomsCache);
};

namespace binding_detail {
struct FastSizeToContentConstraints : public SizeToContentConstraints
{
  inline FastSizeToContentConstraints()
    : SizeToContentConstraints(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SynthesizeEventData : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mIdentifier;

  SynthesizeEventData();

  explicit inline SynthesizeEventData(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SynthesizeEventData(SynthesizeEventData&& aOther) = default;

  explicit inline SynthesizeEventData(const SynthesizeEventData& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SynthesizeEventData&
  operator=(const SynthesizeEventData& aOther);

private:
  static bool
  InitIds(JSContext* cx, SynthesizeEventDataAtoms* atomsCache);
};

namespace binding_detail {
struct FastSynthesizeEventData : public SynthesizeEventData
{
  inline FastSynthesizeEventData()
    : SynthesizeEventData(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SynthesizeEventOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mIsAsyncEnabled;
  MOZ_INIT_OUTSIDE_CTOR bool mToWindow;

  SynthesizeEventOptions();

  explicit inline SynthesizeEventOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SynthesizeEventOptions(SynthesizeEventOptions&& aOther) = default;

  explicit inline SynthesizeEventOptions(const SynthesizeEventOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SynthesizeEventOptions&
  operator=(const SynthesizeEventOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, SynthesizeEventOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastSynthesizeEventOptions : public SynthesizeEventOptions
{
  inline FastSynthesizeEventOptions()
    : SynthesizeEventOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct WindowPostMessageOptions : public StructuredSerializeOptions
{
  MOZ_INIT_OUTSIDE_CTOR nsString mTargetOrigin;

  WindowPostMessageOptions();

  explicit inline WindowPostMessageOptions(const FastDictionaryInitializer& )
    : StructuredSerializeOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  WindowPostMessageOptions(WindowPostMessageOptions&& aOther) = default;

private:
  WindowPostMessageOptions(const WindowPostMessageOptions&) = delete;
  WindowPostMessageOptions& operator=(const WindowPostMessageOptions&) = delete;

  static bool
  InitIds(JSContext* cx, WindowPostMessageOptionsAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastWindowPostMessageOptions : public WindowPostMessageOptions
{
  inline FastWindowPostMessageOptions()
    : WindowPostMessageOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ScrollToOptions : public ScrollOptions
{
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mLeft;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mTop;

  ScrollToOptions();

  explicit inline ScrollToOptions(const FastDictionaryInitializer& )
    : ScrollOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ScrollToOptions(ScrollToOptions&& aOther) = default;

  explicit inline ScrollToOptions(const ScrollToOptions& aOther)
    : ScrollOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ScrollToOptions&
  operator=(const ScrollToOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ScrollToOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastScrollToOptions : public ScrollToOptions
{
  inline FastScrollToOptions()
    : ScrollToOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SynthesizeMouseEventData : public SynthesizeEventData
{
  MOZ_INIT_OUTSIDE_CTOR int32_t mButton;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mButtons;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mClickCount;
  MOZ_INIT_OUTSIDE_CTOR int16_t mInputSource;
  MOZ_INIT_OUTSIDE_CTOR int32_t mModifiers;
  MOZ_INIT_OUTSIDE_CTOR float mPressure;

  SynthesizeMouseEventData();

  explicit inline SynthesizeMouseEventData(const FastDictionaryInitializer& )
    : SynthesizeEventData(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SynthesizeMouseEventData(SynthesizeMouseEventData&& aOther) = default;

  explicit inline SynthesizeMouseEventData(const SynthesizeMouseEventData& aOther)
    : SynthesizeEventData(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SynthesizeMouseEventData&
  operator=(const SynthesizeMouseEventData& aOther);

private:
  static bool
  InitIds(JSContext* cx, SynthesizeMouseEventDataAtoms* atomsCache);
};

namespace binding_detail {
struct FastSynthesizeMouseEventData : public SynthesizeMouseEventData
{
  inline FastSynthesizeMouseEventData()
    : SynthesizeMouseEventData(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SynthesizeMouseEventOptions : public SynthesizeEventOptions
{
  MOZ_INIT_OUTSIDE_CTOR bool mIgnoreRootScrollFrame;
  MOZ_INIT_OUTSIDE_CTOR bool mIsDOMEventSynthesized;
  MOZ_INIT_OUTSIDE_CTOR bool mIsWidgetEventSynthesized;

  SynthesizeMouseEventOptions();

  explicit inline SynthesizeMouseEventOptions(const FastDictionaryInitializer& )
    : SynthesizeEventOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SynthesizeMouseEventOptions(SynthesizeMouseEventOptions&& aOther) = default;

  explicit inline SynthesizeMouseEventOptions(const SynthesizeMouseEventOptions& aOther)
    : SynthesizeEventOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SynthesizeMouseEventOptions&
  operator=(const SynthesizeMouseEventOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, SynthesizeMouseEventOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastSynthesizeMouseEventOptions : public SynthesizeMouseEventOptions
{
  inline FastSynthesizeMouseEventOptions()
    : SynthesizeMouseEventOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SynthesizeTouchEventData : public SynthesizeEventData
{
  MOZ_INIT_OUTSIDE_CTOR int32_t mOffsetX;
  MOZ_INIT_OUTSIDE_CTOR int32_t mOffsetY;
  MOZ_INIT_OUTSIDE_CTOR float mPressure;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mRadiiX;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mRadiiY;
  MOZ_INIT_OUTSIDE_CTOR float mRotationAngle;
  MOZ_INIT_OUTSIDE_CTOR int32_t mTiltX;
  MOZ_INIT_OUTSIDE_CTOR int32_t mTiltY;
  MOZ_INIT_OUTSIDE_CTOR int32_t mTwist;

  SynthesizeTouchEventData();

  explicit inline SynthesizeTouchEventData(const FastDictionaryInitializer& )
    : SynthesizeEventData(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SynthesizeTouchEventData(SynthesizeTouchEventData&& aOther) = default;

  explicit inline SynthesizeTouchEventData(const SynthesizeTouchEventData& aOther)
    : SynthesizeEventData(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SynthesizeTouchEventData&
  operator=(const SynthesizeTouchEventData& aOther);

private:
  static bool
  InitIds(JSContext* cx, SynthesizeTouchEventDataAtoms* atomsCache);
};

namespace binding_detail {
struct FastSynthesizeTouchEventData : public SynthesizeTouchEventData
{
  inline FastSynthesizeTouchEventData()
    : SynthesizeTouchEventData(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SynthesizeTouchEventOptions : public SynthesizeEventOptions
{
  MOZ_INIT_OUTSIDE_CTOR bool mIsPen;

  SynthesizeTouchEventOptions();

  explicit inline SynthesizeTouchEventOptions(const FastDictionaryInitializer& )
    : SynthesizeEventOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SynthesizeTouchEventOptions(SynthesizeTouchEventOptions&& aOther) = default;

  explicit inline SynthesizeTouchEventOptions(const SynthesizeTouchEventOptions& aOther)
    : SynthesizeEventOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SynthesizeTouchEventOptions&
  operator=(const SynthesizeTouchEventOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, SynthesizeTouchEventOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastSynthesizeTouchEventOptions : public SynthesizeTouchEventOptions
{
  inline FastSynthesizeTouchEventOptions()
    : SynthesizeTouchEventOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Window_Binding {

  typedef nsGlobalWindowInner NativeType;

  static const uint16_t STATE_MAXIMIZED = 1;
  static const uint16_t STATE_MINIMIZED = 2;
  static const uint16_t STATE_NORMAL = 3;
  static const uint16_t STATE_FULLSCREEN = 4;
  bool
  CountMaybeMissingProperty(JS::Handle<JSObject*> proxy, JS::Handle<jsid> id);

  bool
  Wrap(JSContext* aCx, nsGlobalWindowInner* aObject, nsWrapperCache* aCache, JS::RealmOptions& aOptions, JSPrincipals* aPrincipal, JS::MutableHandle<JSObject*> aReflector);

  bool
  ClearCachedDocumentValue(JSContext* aCx, nsGlobalWindowInner* aObject);

  bool
  ClearCachedPerformanceValue(JSContext* aCx, nsGlobalWindowInner* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Window,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

  extern const CrossOriginProperties sCrossOriginProperties;

} // namespace Window_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::ScrollBehavior>
{
  static constexpr dom::ScrollBehavior value = dom::ScrollBehavior::Smooth;

  static_assert(static_cast<uint8_t>(dom::ScrollBehavior::Auto) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::ScrollBehavior>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_WINDOWBINDING_H_
