/* THIS FILE IS AUTOGENERATED FROM ChromeUtils.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_CHROMEUTILSBINDING_H_
#define DOM_CHROMEUTILSBINDING_H_

#include "OriginAttributesBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"
#include "nsCycleCollectionParticipant.h"
#include "nsIPrincipal.h"
#include "nsIURI.h"

class nsIPrincipal;
class nsIURI;

namespace mozilla {
namespace dom {

struct Base64URLDecodeOptionsAtoms;
struct Base64URLEncodeOptionsAtoms;
struct CDMInformationAtoms;
struct ChildProcInfoDictionary;
struct ChildProcInfoDictionaryAtoms;
class ChromeUtils;
struct ClearResourceCacheOptionsAtoms;
struct CompileScriptOptionsDictionaryAtoms;
struct FormAutofillConfidencesAtoms;
struct HTTPCacheControlParseResultAtoms;
struct HeapSnapshotBoundariesAtoms;
struct ImportESModuleOptionsDictionaryAtoms;
struct InteractionDataAtoms;
struct LibcConstantsAtoms;
class MozQueryInterface;
struct NativePropertyHooks;
struct OriginAttributesPatternDictionary;
struct ParentProcInfoDictionaryAtoms;
struct ProfilerMarkerOptionsAtoms;
class ProtoAndIfaceCache;
struct ThreadInfoDictionary;
struct ThreadInfoDictionaryAtoms;
struct UtilityActorsDictionary;
struct UtilityActorsDictionaryAtoms;
struct WindowInfoDictionary;
struct WindowInfoDictionaryAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class ResourceCacheType : uint8_t {
  Stylesheet,
  Script,
  Image,
};

namespace binding_detail {
template <> struct EnumStrings<ResourceCacheType> {
  static constexpr nsLiteralCString Values[3] {
    "stylesheet"_ns,
    "script"_ns,
    "image"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ResourceCacheType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class ResourceCacheTarget : uint8_t {
  Chrome,
  Content,
};

namespace binding_detail {
template <> struct EnumStrings<ResourceCacheTarget> {
  static constexpr nsLiteralCString Values[2] {
    "chrome"_ns,
    "content"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ResourceCacheTarget aArgument, JS::MutableHandle<JS::Value> aValue);


enum class WebIDLProcType : uint8_t {
  Web,
  WebIsolated,
  File,
  Extension,
  Privilegedabout,
  Privilegedmozilla,
  WithCoopCoep,
  WebServiceWorker,
  Browser,
  IpdlUnitTest,
  GmpPlugin,
  Gpu,
  Vr,
  Rdd,
  Socket,
  Inference,
  ForkServer,
  Utility,
  Preallocated,
  Unknown,
};

namespace binding_detail {
template <> struct EnumStrings<WebIDLProcType> {
  static constexpr nsLiteralCString Values[20] {
    "web"_ns,
    "webIsolated"_ns,
    "file"_ns,
    "extension"_ns,
    "privilegedabout"_ns,
    "privilegedmozilla"_ns,
    "withCoopCoep"_ns,
    "webServiceWorker"_ns,
    "browser"_ns,
    "ipdlUnitTest"_ns,
    "gmpPlugin"_ns,
    "gpu"_ns,
    "vr"_ns,
    "rdd"_ns,
    "socket"_ns,
    "inference"_ns,
    "forkServer"_ns,
    "utility"_ns,
    "preallocated"_ns,
    "unknown"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, WebIDLProcType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class WebIDLUtilityActorName : uint8_t {
  Unknown,
  AudioDecoder_Generic,
  AudioDecoder_AppleMedia,
  AudioDecoder_WMF,
  MfMediaEngineCDM,
  JSOracle,
  WindowsUtils,
  WindowsFileDialog,
  Pkcs11Module,
};

namespace binding_detail {
template <> struct EnumStrings<WebIDLUtilityActorName> {
  static constexpr nsLiteralCString Values[9] {
    "unknown"_ns,
    "audioDecoder_Generic"_ns,
    "audioDecoder_AppleMedia"_ns,
    "audioDecoder_WMF"_ns,
    "mfMediaEngineCDM"_ns,
    "jSOracle"_ns,
    "windowsUtils"_ns,
    "windowsFileDialog"_ns,
    "pkcs11Module"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, WebIDLUtilityActorName aArgument, JS::MutableHandle<JS::Value> aValue);


enum class ImportESModuleTargetGlobal : uint8_t {
  Shared,
  Devtools,
  Contextual,
  Current,
};

namespace binding_detail {
template <> struct EnumStrings<ImportESModuleTargetGlobal> {
  static constexpr nsLiteralCString Values[4] {
    "shared"_ns,
    "devtools"_ns,
    "contextual"_ns,
    "current"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ImportESModuleTargetGlobal aArgument, JS::MutableHandle<JS::Value> aValue);


enum class Base64URLDecodePadding : uint8_t {
  Require,
  Ignore,
  Reject,
};

namespace binding_detail {
template <> struct EnumStrings<Base64URLDecodePadding> {
  static constexpr nsLiteralCString Values[3] {
    "require"_ns,
    "ignore"_ns,
    "reject"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, Base64URLDecodePadding aArgument, JS::MutableHandle<JS::Value> aValue);


enum class PopupBlockerState : uint8_t {
  OpenAllowed,
  OpenControlled,
  OpenBlocked,
  OpenAbused,
  OpenOverridden,
};

namespace binding_detail {
template <> struct EnumStrings<PopupBlockerState> {
  static constexpr nsLiteralCString Values[5] {
    "openAllowed"_ns,
    "openControlled"_ns,
    "openBlocked"_ns,
    "openAbused"_ns,
    "openOverridden"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, PopupBlockerState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class JSRFPTarget : uint8_t {
  RoundWindowSize,
  SiteSpecificZoom,
  CSSPrefersColorScheme,
  JSLocalePrompt,
  HttpUserAgent,
};

namespace binding_detail {
template <> struct EnumStrings<JSRFPTarget> {
  static constexpr nsLiteralCString Values[5] {
    "RoundWindowSize"_ns,
    "SiteSpecificZoom"_ns,
    "CSSPrefersColorScheme"_ns,
    "JSLocalePrompt"_ns,
    "HttpUserAgent"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, JSRFPTarget aArgument, JS::MutableHandle<JS::Value> aValue);


struct Base64URLDecodeOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Base64URLDecodePadding mPadding;

  Base64URLDecodeOptions();

  explicit inline Base64URLDecodeOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  Base64URLDecodeOptions(Base64URLDecodeOptions&& aOther) = default;

  explicit inline Base64URLDecodeOptions(const Base64URLDecodeOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  Base64URLDecodeOptions&
  operator=(const Base64URLDecodeOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, Base64URLDecodeOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastBase64URLDecodeOptions : public Base64URLDecodeOptions
{
  inline FastBase64URLDecodeOptions()
    : Base64URLDecodeOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct Base64URLEncodeOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mPad;

  Base64URLEncodeOptions();

  explicit inline Base64URLEncodeOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  Base64URLEncodeOptions(Base64URLEncodeOptions&& aOther) = default;

  explicit inline Base64URLEncodeOptions(const Base64URLEncodeOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  Base64URLEncodeOptions&
  operator=(const Base64URLEncodeOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, Base64URLEncodeOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastBase64URLEncodeOptions : public Base64URLEncodeOptions
{
  inline FastBase64URLEncodeOptions()
    : Base64URLEncodeOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct CDMInformation : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mCapabilities;
  MOZ_INIT_OUTSIDE_CTOR bool mClearlead;
  MOZ_INIT_OUTSIDE_CTOR bool mIsHardwareDecryption;
  MOZ_INIT_OUTSIDE_CTOR nsString mKeySystemName;

  CDMInformation();

  explicit inline CDMInformation(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  CDMInformation(CDMInformation&& aOther) = default;

  explicit inline CDMInformation(const CDMInformation& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  CDMInformation&
  operator=(const CDMInformation& aOther);

private:
  static bool
  InitIds(JSContext* cx, CDMInformationAtoms* atomsCache);
};

namespace binding_detail {
struct FastCDMInformation : public CDMInformation
{
  inline FastCDMInformation()
    : CDMInformation(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ClearResourceCacheOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OriginAttributesPatternDictionary mPattern;
  MOZ_INIT_OUTSIDE_CTOR Optional<RefPtr<nsIPrincipal>> mPrincipal;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mSchemelessSite;
  MOZ_INIT_OUTSIDE_CTOR Optional<ResourceCacheTarget> mTarget;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<ResourceCacheType>> mTypes;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mUrl;

  ClearResourceCacheOptions();

  explicit inline ClearResourceCacheOptions(const FastDictionaryInitializer& )
    : mPattern(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ClearResourceCacheOptions(ClearResourceCacheOptions&& aOther) = default;

  explicit inline ClearResourceCacheOptions(const ClearResourceCacheOptions& aOther)
    : mPattern(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mPrincipal, "mPrincipal", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mPrincipal);
  }

  ClearResourceCacheOptions&
  operator=(const ClearResourceCacheOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ClearResourceCacheOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastClearResourceCacheOptions : public ClearResourceCacheOptions
{
  inline FastClearResourceCacheOptions()
    : ClearResourceCacheOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct CompileScriptOptionsDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mCharset;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mFilename;
  MOZ_INIT_OUTSIDE_CTOR bool mHasReturnValue;
  MOZ_INIT_OUTSIDE_CTOR bool mLazilyParse;

  CompileScriptOptionsDictionary();

  explicit inline CompileScriptOptionsDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  CompileScriptOptionsDictionary(CompileScriptOptionsDictionary&& aOther) = default;

  explicit inline CompileScriptOptionsDictionary(const CompileScriptOptionsDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  CompileScriptOptionsDictionary&
  operator=(const CompileScriptOptionsDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, CompileScriptOptionsDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastCompileScriptOptionsDictionary : public CompileScriptOptionsDictionary
{
  inline FastCompileScriptOptionsDictionary()
    : CompileScriptOptionsDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct FormAutofillConfidences : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR double mCcName;
  MOZ_INIT_OUTSIDE_CTOR double mCcNumber;

  FormAutofillConfidences();

  explicit inline FormAutofillConfidences(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  FormAutofillConfidences(FormAutofillConfidences&& aOther) = default;

  explicit inline FormAutofillConfidences(const FormAutofillConfidences& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  FormAutofillConfidences&
  operator=(const FormAutofillConfidences& aOther);

private:
  static bool
  InitIds(JSContext* cx, FormAutofillConfidencesAtoms* atomsCache);
};

namespace binding_detail {
struct FastFormAutofillConfidences : public FormAutofillConfidences
{
  inline FastFormAutofillConfidences()
    : FormAutofillConfidences(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct HTTPCacheControlParseResult : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mImmutable;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mMaxAge;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mMaxStale;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mMinFresh;
  MOZ_INIT_OUTSIDE_CTOR bool mNoCache;
  MOZ_INIT_OUTSIDE_CTOR bool mNoStore;
  MOZ_INIT_OUTSIDE_CTOR bool mPrivate;
  MOZ_INIT_OUTSIDE_CTOR bool mPublic;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mStaleWhileRevalidate;

  HTTPCacheControlParseResult();

  explicit inline HTTPCacheControlParseResult(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  HTTPCacheControlParseResult(HTTPCacheControlParseResult&& aOther) = default;

  explicit inline HTTPCacheControlParseResult(const HTTPCacheControlParseResult& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  HTTPCacheControlParseResult&
  operator=(const HTTPCacheControlParseResult& aOther);

private:
  static bool
  InitIds(JSContext* cx, HTTPCacheControlParseResultAtoms* atomsCache);
};

namespace binding_detail {
struct FastHTTPCacheControlParseResult : public HTTPCacheControlParseResult
{
  inline FastHTTPCacheControlParseResult()
    : HTTPCacheControlParseResult(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct HeapSnapshotBoundaries : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<JSObject*> mDebugger;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<JSObject*>> mGlobals;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mRuntime;

  HeapSnapshotBoundaries();

  explicit inline HeapSnapshotBoundaries(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  HeapSnapshotBoundaries(HeapSnapshotBoundaries&& aOther) = default;

private:
  HeapSnapshotBoundaries(const HeapSnapshotBoundaries&) = delete;
  HeapSnapshotBoundaries& operator=(const HeapSnapshotBoundaries&) = delete;

  static bool
  InitIds(JSContext* cx, HeapSnapshotBoundariesAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastHeapSnapshotBoundaries : public HeapSnapshotBoundaries
{
  inline FastHeapSnapshotBoundaries()
    : HeapSnapshotBoundaries(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ImportESModuleOptionsDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<ImportESModuleTargetGlobal> mGlobal;

  ImportESModuleOptionsDictionary();

  explicit inline ImportESModuleOptionsDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ImportESModuleOptionsDictionary(ImportESModuleOptionsDictionary&& aOther) = default;

  explicit inline ImportESModuleOptionsDictionary(const ImportESModuleOptionsDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ImportESModuleOptionsDictionary&
  operator=(const ImportESModuleOptionsDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, ImportESModuleOptionsDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastImportESModuleOptionsDictionary : public ImportESModuleOptionsDictionary
{
  inline FastImportESModuleOptionsDictionary()
    : ImportESModuleOptionsDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct InteractionData : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mInteractionCount;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mInteractionTimeInMilliseconds;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mScrollingDistanceInPixels;

  InteractionData();

  explicit inline InteractionData(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  InteractionData(InteractionData&& aOther) = default;

  explicit inline InteractionData(const InteractionData& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  InteractionData&
  operator=(const InteractionData& aOther);

private:
  static bool
  InitIds(JSContext* cx, InteractionDataAtoms* atomsCache);
};

namespace binding_detail {
struct FastInteractionData : public InteractionData
{
  inline FastInteractionData()
    : InteractionData(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct LibcConstants : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mAT_EACCESS;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mEACCES;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mEAGAIN;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mEINTR;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mEINVAL;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mENOSYS;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mEPERM;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mFD_CLOEXEC;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mF_SETFD;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mF_SETFL;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mO_CREAT;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mO_NONBLOCK;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mO_WRONLY;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mPOLLERR;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mPOLLHUP;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mPOLLIN;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mPOLLNVAL;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mPOLLOUT;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mPR_CAPBSET_READ;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mWNOHANG;

  LibcConstants();

  explicit inline LibcConstants(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  LibcConstants(LibcConstants&& aOther) = default;

  explicit inline LibcConstants(const LibcConstants& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  LibcConstants&
  operator=(const LibcConstants& aOther);

private:
  static bool
  InitIds(JSContext* cx, LibcConstantsAtoms* atomsCache);
};

namespace binding_detail {
struct FastLibcConstants : public LibcConstants
{
  inline FastLibcConstants()
    : LibcConstants(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ProfilerMarkerOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mCaptureStack;
  MOZ_INIT_OUTSIDE_CTOR nsCString mCategory;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mInnerWindowId;
  MOZ_INIT_OUTSIDE_CTOR double mStartTime;

  ProfilerMarkerOptions();

  explicit inline ProfilerMarkerOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ProfilerMarkerOptions(ProfilerMarkerOptions&& aOther) = default;

  explicit inline ProfilerMarkerOptions(const ProfilerMarkerOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ProfilerMarkerOptions&
  operator=(const ProfilerMarkerOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ProfilerMarkerOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastProfilerMarkerOptions : public ProfilerMarkerOptions
{
  inline FastProfilerMarkerOptions()
    : ProfilerMarkerOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ThreadInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuCycleCount;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuTime;
  MOZ_INIT_OUTSIDE_CTOR nsString mName;
  MOZ_INIT_OUTSIDE_CTOR int64_t mTid;

  ThreadInfoDictionary();

  explicit inline ThreadInfoDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ThreadInfoDictionary(ThreadInfoDictionary&& aOther) = default;

  explicit inline ThreadInfoDictionary(const ThreadInfoDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  ThreadInfoDictionary&
  operator=(const ThreadInfoDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, ThreadInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastThreadInfoDictionary : public ThreadInfoDictionary
{
  inline FastThreadInfoDictionary()
    : ThreadInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class UTF8StringOrObject : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eObject
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;
    UnionMember<JS::Rooted<JSObject*> > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrObject(const UTF8StringOrObject&) = delete;
  UTF8StringOrObject& operator=(const UTF8StringOrObject&) = delete;
public:
  explicit inline UTF8StringOrObject()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrObject()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (USVString or object)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }
};


class OwningUTF8StringOrObject : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eObject
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;
    UnionMember<JSObject* > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningUTF8StringOrObject(const OwningUTF8StringOrObject&) = delete;
  OwningUTF8StringOrObject& operator=(const OwningUTF8StringOrObject&) = delete;
public:
  explicit inline OwningUTF8StringOrObject()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrObject(OwningUTF8StringOrObject&& aOther);

  inline ~OwningUTF8StringOrObject()
  {
    Uninit();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (USVString or object)");
      return false;
    }
    return true;
  }

  [[nodiscard]] JSObject*&
  RawSetAsObject();

  [[nodiscard]] JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningUTF8StringOrObject&
  operator=(OwningUTF8StringOrObject&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();

  void
  DestroyObject();
};


struct UtilityActorsDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR WebIDLUtilityActorName mActorName;

  UtilityActorsDictionary();

  explicit inline UtilityActorsDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  UtilityActorsDictionary(UtilityActorsDictionary&& aOther) = default;

  explicit inline UtilityActorsDictionary(const UtilityActorsDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  UtilityActorsDictionary&
  operator=(const UtilityActorsDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, UtilityActorsDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastUtilityActorsDictionary : public UtilityActorsDictionary
{
  inline FastUtilityActorsDictionary()
    : UtilityActorsDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct WindowInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mDocumentTitle;
  MOZ_INIT_OUTSIDE_CTOR RefPtr<nsIURI> mDocumentURI;
  MOZ_INIT_OUTSIDE_CTOR bool mIsInProcess;
  MOZ_INIT_OUTSIDE_CTOR bool mIsProcessRoot;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mOuterWindowId;

  WindowInfoDictionary();

  explicit inline WindowInfoDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  WindowInfoDictionary(WindowInfoDictionary&& aOther) = default;

  explicit inline WindowInfoDictionary(const WindowInfoDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mDocumentURI, "mDocumentURI", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mDocumentURI);
  }

  WindowInfoDictionary&
  operator=(const WindowInfoDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, WindowInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastWindowInfoDictionary : public WindowInfoDictionary
{
  inline FastWindowInfoDictionary()
    : WindowInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ChildProcInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mChildID;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuCycleCount;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuTime;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mMemory;
  MOZ_INIT_OUTSIDE_CTOR nsCString mOrigin;
  MOZ_INIT_OUTSIDE_CTOR int64_t mPid;
  MOZ_INIT_OUTSIDE_CTOR Sequence<ThreadInfoDictionary> mThreads;
  MOZ_INIT_OUTSIDE_CTOR WebIDLProcType mType;
  MOZ_INIT_OUTSIDE_CTOR Sequence<UtilityActorsDictionary> mUtilityActors;
  MOZ_INIT_OUTSIDE_CTOR Sequence<WindowInfoDictionary> mWindows;

  ChildProcInfoDictionary();

  explicit inline ChildProcInfoDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ChildProcInfoDictionary(ChildProcInfoDictionary&& aOther) = default;

  explicit inline ChildProcInfoDictionary(const ChildProcInfoDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mWindows, "mWindows", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mWindows);
  }

  ChildProcInfoDictionary&
  operator=(const ChildProcInfoDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, ChildProcInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastChildProcInfoDictionary : public ChildProcInfoDictionary
{
  inline FastChildProcInfoDictionary()
    : ChildProcInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class ProfilerMarkerOptionsOrDouble : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eProfilerMarkerOptions,
    eDouble
  };
public:
  enum class Type
  {
    eProfilerMarkerOptions = TypeOrUninit::eProfilerMarkerOptions,
    eDouble = TypeOrUninit::eDouble
  };

private:
  union Value
  {
    UnionMember<binding_detail::FastProfilerMarkerOptions > mProfilerMarkerOptions;
    UnionMember<double > mDouble;

  };

  TypeOrUninit mType;
  Value mValue;

  ProfilerMarkerOptionsOrDouble(const ProfilerMarkerOptionsOrDouble&) = delete;
  ProfilerMarkerOptionsOrDouble& operator=(const ProfilerMarkerOptionsOrDouble&) = delete;
public:
  explicit inline ProfilerMarkerOptionsOrDouble()
    : mType(eUninitialized)
  {
  }

  inline ~ProfilerMarkerOptionsOrDouble()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FastProfilerMarkerOptions&
  RawSetAsProfilerMarkerOptions()
  {
    if (mType == eProfilerMarkerOptions) {
      return mValue.mProfilerMarkerOptions.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eProfilerMarkerOptions;
    return mValue.mProfilerMarkerOptions.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastProfilerMarkerOptions&
  SetAsProfilerMarkerOptions()
  {
    if (mType == eProfilerMarkerOptions) {
      return mValue.mProfilerMarkerOptions.Value();
    }
    Uninit();
    mType = eProfilerMarkerOptions;
    return mValue.mProfilerMarkerOptions.SetValue();
  }

  inline bool
  IsProfilerMarkerOptions() const
  {
    return mType == eProfilerMarkerOptions;
  }

  inline binding_detail::FastProfilerMarkerOptions&
  GetAsProfilerMarkerOptions()
  {
    MOZ_RELEASE_ASSERT(IsProfilerMarkerOptions(), "Wrong type!");
    return mValue.mProfilerMarkerOptions.Value();
  }

  inline const ProfilerMarkerOptions&
  GetAsProfilerMarkerOptions() const
  {
    MOZ_RELEASE_ASSERT(IsProfilerMarkerOptions(), "Wrong type!");
    return mValue.mProfilerMarkerOptions.Value();
  }

  [[nodiscard]] inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  [[nodiscard]] inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eProfilerMarkerOptions: {
        DestroyProfilerMarkerOptions();
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
    }
  }

private:
  bool
  TrySetToProfilerMarkerOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToProfilerMarkerOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyProfilerMarkerOptions()
  {
    MOZ_RELEASE_ASSERT(IsProfilerMarkerOptions(), "Wrong type!");
    mValue.mProfilerMarkerOptions.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }
};


class OwningProfilerMarkerOptionsOrDouble : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eProfilerMarkerOptions,
    eDouble
  };
public:
  enum class Type
  {
    eProfilerMarkerOptions = TypeOrUninit::eProfilerMarkerOptions,
    eDouble = TypeOrUninit::eDouble
  };

private:
  union Value
  {
    UnionMember<ProfilerMarkerOptions > mProfilerMarkerOptions;
    UnionMember<double > mDouble;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningProfilerMarkerOptionsOrDouble()
    : mType(eUninitialized)
  {
  }

  OwningProfilerMarkerOptionsOrDouble(OwningProfilerMarkerOptionsOrDouble&& aOther);

  explicit inline OwningProfilerMarkerOptionsOrDouble(const OwningProfilerMarkerOptionsOrDouble& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningProfilerMarkerOptionsOrDouble()
  {
    Uninit();
  }

  [[nodiscard]] ProfilerMarkerOptions&
  RawSetAsProfilerMarkerOptions();

  [[nodiscard]] ProfilerMarkerOptions&
  SetAsProfilerMarkerOptions();

  inline bool
  IsProfilerMarkerOptions() const
  {
    return mType == eProfilerMarkerOptions;
  }

  inline ProfilerMarkerOptions&
  GetAsProfilerMarkerOptions()
  {
    MOZ_RELEASE_ASSERT(IsProfilerMarkerOptions(), "Wrong type!");
    return mValue.mProfilerMarkerOptions.Value();
  }

  inline ProfilerMarkerOptions const &
  GetAsProfilerMarkerOptions() const
  {
    MOZ_RELEASE_ASSERT(IsProfilerMarkerOptions(), "Wrong type!");
    return mValue.mProfilerMarkerOptions.Value();
  }

  [[nodiscard]] double&
  RawSetAsDouble();

  [[nodiscard]] double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningProfilerMarkerOptionsOrDouble&
  operator=(OwningProfilerMarkerOptionsOrDouble&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningProfilerMarkerOptionsOrDouble&
  operator=(const OwningProfilerMarkerOptionsOrDouble& aOther);

private:
  bool
  TrySetToProfilerMarkerOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToProfilerMarkerOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyProfilerMarkerOptions();

  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();
};


struct ParentProcInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<ChildProcInfoDictionary> mChildren;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuCycleCount;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuTime;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mMemory;
  MOZ_INIT_OUTSIDE_CTOR int64_t mPid;
  MOZ_INIT_OUTSIDE_CTOR Sequence<ThreadInfoDictionary> mThreads;
  MOZ_INIT_OUTSIDE_CTOR WebIDLProcType mType;

  ParentProcInfoDictionary();

  explicit inline ParentProcInfoDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ParentProcInfoDictionary(ParentProcInfoDictionary&& aOther) = default;

  explicit inline ParentProcInfoDictionary(const ParentProcInfoDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mChildren, "mChildren", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mChildren);
  }

  ParentProcInfoDictionary&
  operator=(const ParentProcInfoDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, ParentProcInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastParentProcInfoDictionary : public ParentProcInfoDictionary
{
  inline FastParentProcInfoDictionary()
    : ParentProcInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace ChromeUtils_Binding {

  typedef mozilla::dom::ChromeUtils NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::ChromeUtils,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace ChromeUtils_Binding



namespace MozQueryInterface_Binding {

  typedef mozilla::dom::MozQueryInterface NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::MozQueryInterface* aObject, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::MozQueryInterface,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace MozQueryInterface_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::ResourceCacheType>
{
  static constexpr dom::ResourceCacheType value = dom::ResourceCacheType::Image;

  static_assert(static_cast<uint8_t>(dom::ResourceCacheType::Stylesheet) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::ResourceCacheType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::ResourceCacheTarget>
{
  static constexpr dom::ResourceCacheTarget value = dom::ResourceCacheTarget::Content;

  static_assert(static_cast<uint8_t>(dom::ResourceCacheTarget::Chrome) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::ResourceCacheTarget>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::WebIDLProcType>
{
  static constexpr dom::WebIDLProcType value = dom::WebIDLProcType::Unknown;

  static_assert(static_cast<uint8_t>(dom::WebIDLProcType::Web) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::WebIDLProcType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::WebIDLUtilityActorName>
{
  static constexpr dom::WebIDLUtilityActorName value = dom::WebIDLUtilityActorName::Pkcs11Module;

  static_assert(static_cast<uint8_t>(dom::WebIDLUtilityActorName::Unknown) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::WebIDLUtilityActorName>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::ImportESModuleTargetGlobal>
{
  static constexpr dom::ImportESModuleTargetGlobal value = dom::ImportESModuleTargetGlobal::Current;

  static_assert(static_cast<uint8_t>(dom::ImportESModuleTargetGlobal::Shared) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::ImportESModuleTargetGlobal>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::Base64URLDecodePadding>
{
  static constexpr dom::Base64URLDecodePadding value = dom::Base64URLDecodePadding::Reject;

  static_assert(static_cast<uint8_t>(dom::Base64URLDecodePadding::Require) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::Base64URLDecodePadding>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::PopupBlockerState>
{
  static constexpr dom::PopupBlockerState value = dom::PopupBlockerState::OpenOverridden;

  static_assert(static_cast<uint8_t>(dom::PopupBlockerState::OpenAllowed) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::PopupBlockerState>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::JSRFPTarget>
{
  static constexpr dom::JSRFPTarget value = dom::JSRFPTarget::HttpUserAgent;

  static_assert(static_cast<uint8_t>(dom::JSRFPTarget::RoundWindowSize) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::JSRFPTarget>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_CHROMEUTILSBINDING_H_
