/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*****************************************************************************/
/* This is an automatically generated file. If you're not                    */
/* RootCertificateTelemetryUtils.cpp, you shouldn't be #including it.        */
/*****************************************************************************/

#define HASH_LEN 32
struct CertAuthorityHash {
  // See bug 1338873 about making these fields const.
  uint8_t hash[HASH_LEN];
  int32_t binNumber;
};

static const struct CertAuthorityHash ROOT_TABLE[] = {
  {
    /* DigiCert TLS ECC P384 Root G5 */
    { 0x01, 0x8e, 0x13, 0xf0, 0x77, 0x25, 0x32, 0xcf, 0x80, 0x9b, 0xd1, 0xb1, 0x72, 0x81, 0x86, 0x72,
      0x83, 0xfc, 0x48, 0xc6, 0xe1, 0x3b, 0xe9, 0xc6, 0x98, 0x12, 0x85, 0x4a, 0x49, 0x0c, 0x1b, 0x05 },
    4 /* Bin Number */
  },
  {
    /* Entrust Root Certification Authority - EC1 */
    { 0x02, 0xed, 0x0e, 0xb2, 0x8c, 0x14, 0xda, 0x45, 0x16, 0x5c, 0x56, 0x67, 0x91, 0x70, 0x0d, 0x64,
      0x51, 0xd7, 0xfb, 0x56, 0xf0, 0xb2, 0xab, 0x1d, 0x3b, 0x8e, 0xb0, 0x70, 0xe5, 0x6e, 0xdf, 0xf5 },
    6 /* Bin Number */
  },
  {
    /* AffirmTrust Commercial */
    { 0x03, 0x76, 0xab, 0x1d, 0x54, 0xc5, 0xf9, 0x80, 0x3c, 0xe4, 0xb2, 0xe2, 0x01, 0xa0, 0xee, 0x7e,
      0xef, 0x7b, 0x57, 0xb6, 0x36, 0xe8, 0xa9, 0x3c, 0x9b, 0x8d, 0x48, 0x60, 0xc9, 0x6f, 0x5f, 0xa7 },
    7 /* Bin Number */
  },
  {
    /* D-TRUST BR Root CA 2 2023 */
    { 0x05, 0x52, 0xe6, 0xf8, 0x3f, 0xdf, 0x65, 0xe8, 0xfa, 0x96, 0x70, 0xe6, 0x66, 0xdf, 0x28, 0xa4,
      0xe2, 0x13, 0x40, 0xb5, 0x10, 0xcb, 0xe5, 0x25, 0x66, 0xf9, 0x7c, 0x4f, 0xb9, 0x4b, 0x2b, 0xd1 },
    8 /* Bin Number */
  },
  {
    /* TrustAsia TLS RSA Root CA */
    { 0x06, 0xc0, 0x8d, 0x7d, 0xaf, 0xd8, 0x76, 0x97, 0x1e, 0xb1, 0x12, 0x4f, 0xe6, 0x7f, 0x84, 0x7e,
      0xc0, 0xc7, 0xa1, 0x58, 0xd3, 0xea, 0x53, 0xcb, 0xe9, 0x40, 0xe2, 0xea, 0x97, 0x91, 0xf4, 0xc3 },
    147 /* Bin Number */
  },
  {
    /* D-TRUST EV Root CA 1 2020 */
    { 0x08, 0x17, 0x0d, 0x1a, 0xa3, 0x64, 0x53, 0x90, 0x1a, 0x2f, 0x95, 0x92, 0x45, 0xe3, 0x47, 0xdb,
      0x0c, 0x8d, 0x37, 0xab, 0xaa, 0xbc, 0x56, 0xb8, 0x1a, 0xa1, 0x00, 0xdc, 0x95, 0x89, 0x70, 0xdb },
    9 /* Bin Number */
  },
  {
    /* AffirmTrust Networking */
    { 0x0a, 0x81, 0xec, 0x5a, 0x92, 0x97, 0x77, 0xf1, 0x45, 0x90, 0x4a, 0xf3, 0x8d, 0x5d, 0x50, 0x9f,
      0x66, 0xb5, 0xe2, 0xc5, 0x8f, 0xcd, 0xb5, 0x31, 0x05, 0x8b, 0x0e, 0x17, 0xf3, 0xf0, 0xb4, 0x1b },
    10 /* Bin Number */
  },
  {
    /* COMODO Certification Authority */
    { 0x0c, 0x2c, 0xd6, 0x3d, 0xf7, 0x80, 0x6f, 0xa3, 0x99, 0xed, 0xe8, 0x09, 0x11, 0x6b, 0x57, 0x5b,
      0xf8, 0x79, 0x89, 0xf0, 0x65, 0x18, 0xf9, 0x80, 0x8c, 0x86, 0x05, 0x03, 0x17, 0x8b, 0xaf, 0x66 },
    11 /* Bin Number */
  },
  {
    /* emSign Root CA - C1 */
    { 0x12, 0x56, 0x09, 0xaa, 0x30, 0x1d, 0xa0, 0xa2, 0x49, 0xb9, 0x7a, 0x82, 0x39, 0xcb, 0x6a, 0x34,
      0x21, 0x6f, 0x44, 0xdc, 0xac, 0x9f, 0x39, 0x54, 0xb1, 0x42, 0x92, 0xf2, 0xe8, 0xc8, 0x60, 0x8f },
    13 /* Bin Number */
  },
  {
    /* COMODO ECC Certification Authority */
    { 0x17, 0x93, 0x92, 0x7a, 0x06, 0x14, 0x54, 0x97, 0x89, 0xad, 0xce, 0x2f, 0x8f, 0x34, 0xf7, 0xf0,
      0xb6, 0x6d, 0x0f, 0x3a, 0xe3, 0xa3, 0xb8, 0x4d, 0x21, 0xec, 0x15, 0xdb, 0xba, 0x4f, 0xad, 0xc7 },
    14 /* Bin Number */
  },
  {
    /* GlobalSign ECC Root CA - R5 */
    { 0x17, 0x9f, 0xbc, 0x14, 0x8a, 0x3d, 0xd0, 0x0f, 0xd2, 0x4e, 0xa1, 0x34, 0x58, 0xcc, 0x43, 0xbf,
      0xa7, 0xf5, 0x9c, 0x81, 0x82, 0xd7, 0x83, 0xa5, 0x13, 0xf6, 0xeb, 0xec, 0x10, 0x0c, 0x89, 0x24 },
    15 /* Bin Number */
  },
  {
    /* Amazon Root CA 3 */
    { 0x18, 0xce, 0x6c, 0xfe, 0x7b, 0xf1, 0x4e, 0x60, 0xb2, 0xe3, 0x47, 0xb8, 0xdf, 0xe8, 0x68, 0xcb,
      0x31, 0xd0, 0x2e, 0xbb, 0x3a, 0xda, 0x27, 0x15, 0x69, 0xf5, 0x03, 0x43, 0xb4, 0x6d, 0xb3, 0xa4 },
    16 /* Bin Number */
  },
  {
    /* QuoVadis Root CA 3 */
    { 0x18, 0xf1, 0xfc, 0x7f, 0x20, 0x5d, 0xf8, 0xad, 0xdd, 0xeb, 0x7f, 0xe0, 0x07, 0xdd, 0x57, 0xe3,
      0xaf, 0x37, 0x5a, 0x9c, 0x4d, 0x8d, 0x73, 0x54, 0x6b, 0xf4, 0xf1, 0xfe, 0xd1, 0xe1, 0x8d, 0x35 },
    17 /* Bin Number */
  },
  {
    /* SwissSign RSA TLS Root CA 2022 - 1 */
    { 0x19, 0x31, 0x44, 0xf4, 0x31, 0xe0, 0xfd, 0xdb, 0x74, 0x07, 0x17, 0xd4, 0xde, 0x92, 0x6a, 0x57,
      0x11, 0x33, 0x88, 0x4b, 0x43, 0x60, 0xd3, 0x0e, 0x27, 0x29, 0x13, 0xcb, 0xe6, 0x60, 0xce, 0x41 },
    148 /* Bin Number */
  },
  {
    /* Amazon Root CA 2 */
    { 0x1b, 0xa5, 0xb2, 0xaa, 0x8c, 0x65, 0x40, 0x1a, 0x82, 0x96, 0x01, 0x18, 0xf8, 0x0b, 0xec, 0x4f,
      0x62, 0x30, 0x4d, 0x83, 0xce, 0xc4, 0x71, 0x3a, 0x19, 0xc3, 0x9c, 0x01, 0x1e, 0xa4, 0x6d, 0xb4 },
    18 /* Bin Number */
  },
  {
    /* SSL.com EV Root Certification Authority ECC */
    { 0x22, 0xa2, 0xc1, 0xf7, 0xbd, 0xed, 0x70, 0x4c, 0xc1, 0xe7, 0x01, 0xb5, 0xf4, 0x08, 0xc3, 0x10,
      0x88, 0x0f, 0xe9, 0x56, 0xb5, 0xde, 0x2a, 0x4a, 0x44, 0xf9, 0x9c, 0x87, 0x3a, 0x25, 0xa7, 0xc8 },
    19 /* Bin Number */
  },
  {
    /* Telia Root CA v2 */
    { 0x24, 0x2b, 0x69, 0x74, 0x2f, 0xcb, 0x1e, 0x5b, 0x2a, 0xbf, 0x98, 0x89, 0x8b, 0x94, 0x57, 0x21,
      0x87, 0x54, 0x4e, 0x5b, 0x4d, 0x99, 0x11, 0x78, 0x65, 0x73, 0x62, 0x1f, 0x6a, 0x74, 0xb8, 0x2c },
    20 /* Bin Number */
  },
  {
    /* Izenpe.com */
    { 0x25, 0x30, 0xcc, 0x8e, 0x98, 0x32, 0x15, 0x02, 0xba, 0xd9, 0x6f, 0x9b, 0x1f, 0xba, 0x1b, 0x09,
      0x9e, 0x2d, 0x29, 0x9e, 0x0f, 0x45, 0x48, 0xbb, 0x91, 0x4f, 0x36, 0x3b, 0xc0, 0xd4, 0x53, 0x1f },
    21 /* Bin Number */
  },
  {
    /* GlobalSign Root CA - R6 */
    { 0x2c, 0xab, 0xea, 0xfe, 0x37, 0xd0, 0x6c, 0xa2, 0x2a, 0xba, 0x73, 0x91, 0xc0, 0x03, 0x3d, 0x25,
      0x98, 0x29, 0x52, 0xc4, 0x53, 0x64, 0x73, 0x49, 0x76, 0x3a, 0x3a, 0xb5, 0xad, 0x6c, 0xcf, 0x69 },
    22 /* Bin Number */
  },
  {
    /* Starfield Root Certificate Authority - G2 */
    { 0x2c, 0xe1, 0xcb, 0x0b, 0xf9, 0xd2, 0xf9, 0xe1, 0x02, 0x99, 0x3f, 0xbe, 0x21, 0x51, 0x52, 0xc3,
      0xb2, 0xdd, 0x0c, 0xab, 0xde, 0x1c, 0x68, 0xe5, 0x31, 0x9b, 0x83, 0x91, 0x54, 0xdb, 0xb7, 0xf5 },
    23 /* Bin Number */
  },
  {
    /* TunTrust Root CA */
    { 0x2e, 0x44, 0x10, 0x2a, 0xb5, 0x8c, 0xb8, 0x54, 0x19, 0x45, 0x1c, 0x8e, 0x19, 0xd9, 0xac, 0xf3,
      0x66, 0x2c, 0xaf, 0xbc, 0x61, 0x4b, 0x6a, 0x53, 0x96, 0x0a, 0x30, 0xf7, 0xd0, 0xe2, 0xeb, 0x41 },
    24 /* Bin Number */
  },
  {
    /* SSL.com EV Root Certification Authority RSA R2 */
    { 0x2e, 0x7b, 0xf1, 0x6c, 0xc2, 0x24, 0x85, 0xa7, 0xbb, 0xe2, 0xaa, 0x86, 0x96, 0x75, 0x07, 0x61,
      0xb0, 0xae, 0x39, 0xbe, 0x3b, 0x2f, 0xe9, 0xd0, 0xcc, 0x6d, 0x4e, 0xf7, 0x34, 0x91, 0x42, 0x5c },
    25 /* Bin Number */
  },
  {
    /* IdenTrust Public Sector Root CA 1 */
    { 0x30, 0xd0, 0x89, 0x5a, 0x9a, 0x44, 0x8a, 0x26, 0x20, 0x91, 0x63, 0x55, 0x22, 0xd1, 0xf5, 0x20,
      0x10, 0xb5, 0x86, 0x7a, 0xca, 0xe1, 0x2c, 0x78, 0xef, 0x95, 0x8f, 0xd4, 0xf4, 0x38, 0x9f, 0x2f },
    27 /* Bin Number */
  },
  {
    /* vTrus ECC Root CA */
    { 0x30, 0xfb, 0xba, 0x2c, 0x32, 0x23, 0x8e, 0x2a, 0x98, 0x54, 0x7a, 0xf9, 0x79, 0x31, 0xe5, 0x50,
      0x42, 0x8b, 0x9b, 0x3f, 0x1c, 0x8e, 0xeb, 0x66, 0x33, 0xdc, 0xfa, 0x86, 0xc5, 0xb2, 0x7d, 0xd3 },
    28 /* Bin Number */
  },
  {
    /* DigiCert Global Root G3 */
    { 0x31, 0xad, 0x66, 0x48, 0xf8, 0x10, 0x41, 0x38, 0xc7, 0x38, 0xf3, 0x9e, 0xa4, 0x32, 0x01, 0x33,
      0x39, 0x3e, 0x3a, 0x18, 0xcc, 0x02, 0x29, 0x6e, 0xf9, 0x7c, 0x2a, 0xc9, 0xef, 0x67, 0x31, 0xd0 },
    29 /* Bin Number */
  },
  {
    /* SSL.com Root Certification Authority ECC */
    { 0x34, 0x17, 0xbb, 0x06, 0xcc, 0x60, 0x07, 0xda, 0x1b, 0x96, 0x1c, 0x92, 0x0b, 0x8a, 0xb4, 0xce,
      0x3f, 0xad, 0x82, 0x0e, 0x4a, 0xa3, 0x0b, 0x9a, 0xcb, 0xc4, 0xa7, 0x4e, 0xbd, 0xce, 0xbc, 0x65 },
    30 /* Bin Number */
  },
  {
    /* GTS Root R4 */
    { 0x34, 0x9d, 0xfa, 0x40, 0x58, 0xc5, 0xe2, 0x63, 0x12, 0x3b, 0x39, 0x8a, 0xe7, 0x95, 0x57, 0x3c,
      0x4e, 0x13, 0x13, 0xc8, 0x3f, 0xe6, 0x8f, 0x93, 0x55, 0x6c, 0xd5, 0xe8, 0x03, 0x1b, 0x3c, 0x7d },
    31 /* Bin Number */
  },
  {
    /* GTS Root R3 */
    { 0x34, 0xd8, 0xa7, 0x3e, 0xe2, 0x08, 0xd9, 0xbc, 0xdb, 0x0d, 0x95, 0x65, 0x20, 0x93, 0x4b, 0x4e,
      0x40, 0xe6, 0x94, 0x82, 0x59, 0x6e, 0x8b, 0x6f, 0x73, 0xc8, 0x42, 0x6b, 0x01, 0x0a, 0x6f, 0x48 },
    32 /* Bin Number */
  },
  {
    /* Microsoft ECC Root Certificate Authority 2017 */
    { 0x35, 0x8d, 0xf3, 0x9d, 0x76, 0x4a, 0xf9, 0xe1, 0xb7, 0x66, 0xe9, 0xc9, 0x72, 0xdf, 0x35, 0x2e,
      0xe1, 0x5c, 0xfa, 0xc2, 0x27, 0xaf, 0x6a, 0xd1, 0xd7, 0x0e, 0x8e, 0x4a, 0x6e, 0xdc, 0xba, 0x02 },
    33 /* Bin Number */
  },
  {
    /* DigiCert TLS RSA4096 Root G5 */
    { 0x37, 0x1a, 0x00, 0xdc, 0x05, 0x33, 0xb3, 0x72, 0x1a, 0x7e, 0xeb, 0x40, 0xe8, 0x41, 0x9e, 0x70,
      0x79, 0x9d, 0x2b, 0x0a, 0x0f, 0x2c, 0x1d, 0x80, 0x69, 0x31, 0x65, 0xf7, 0xce, 0xc4, 0xad, 0x75 },
    34 /* Bin Number */
  },
  {
    /* Microsec e-Szigno Root CA 2009 */
    { 0x3c, 0x5f, 0x81, 0xfe, 0xa5, 0xfa, 0xb8, 0x2c, 0x64, 0xbf, 0xa2, 0xea, 0xec, 0xaf, 0xcd, 0xe8,
      0xe0, 0x77, 0xfc, 0x86, 0x20, 0xa7, 0xca, 0xe5, 0x37, 0x16, 0x3d, 0xf3, 0x6e, 0xdb, 0xf3, 0x78 },
    35 /* Bin Number */
  },
  {
    /* DigiCert Assured ID Root CA */
    { 0x3e, 0x90, 0x99, 0xb5, 0x01, 0x5e, 0x8f, 0x48, 0x6c, 0x00, 0xbc, 0xea, 0x9d, 0x11, 0x1e, 0xe7,
      0x21, 0xfa, 0xba, 0x35, 0x5a, 0x89, 0xbc, 0xf1, 0xdf, 0x69, 0x56, 0x1e, 0x3d, 0xc6, 0x32, 0x5c },
    36 /* Bin Number */
  },
  {
    /* SecureSign Root CA12 */
    { 0x3f, 0x03, 0x4b, 0xb5, 0x70, 0x4d, 0x44, 0xb2, 0xd0, 0x85, 0x45, 0xa0, 0x20, 0x57, 0xde, 0x93,
      0xeb, 0xf3, 0x90, 0x5f, 0xce, 0x72, 0x1a, 0xcb, 0xc7, 0x30, 0xc0, 0x6d, 0xda, 0xee, 0x90, 0x4e },
    37 /* Bin Number */
  },
  {
    /* TWCA CYBER Root CA */
    { 0x3f, 0x63, 0xbb, 0x28, 0x14, 0xbe, 0x17, 0x4e, 0xc8, 0xb6, 0x43, 0x9c, 0xf0, 0x8d, 0x6d, 0x56,
      0xf0, 0xb7, 0xc4, 0x05, 0x88, 0x3a, 0x56, 0x48, 0xa3, 0x34, 0x42, 0x4d, 0x6b, 0x3e, 0xc5, 0x58 },
    38 /* Bin Number */
  },
  {
    /* HARICA TLS ECC Root CA 2021 */
    { 0x3f, 0x99, 0xcc, 0x47, 0x4a, 0xcf, 0xce, 0x4d, 0xfe, 0xd5, 0x87, 0x94, 0x66, 0x5e, 0x47, 0x8d,
      0x15, 0x47, 0x73, 0x9f, 0x2e, 0x78, 0x0f, 0x1b, 0xb4, 0xca, 0x9b, 0x13, 0x30, 0x97, 0xd4, 0x01 },
    39 /* Bin Number */
  },
  {
    /* emSign Root CA - G1 */
    { 0x40, 0xf6, 0xaf, 0x03, 0x46, 0xa9, 0x9a, 0xa1, 0xcd, 0x1d, 0x55, 0x5a, 0x4e, 0x9c, 0xce, 0x62,
      0xc7, 0xf9, 0x63, 0x46, 0x03, 0xee, 0x40, 0x66, 0x15, 0x83, 0x3d, 0xc8, 0xc8, 0xd0, 0x03, 0x67 },
    40 /* Bin Number */
  },
  {
    /* Secure Global CA */
    { 0x42, 0x00, 0xf5, 0x04, 0x3a, 0xc8, 0x59, 0x0e, 0xbb, 0x52, 0x7d, 0x20, 0x9e, 0xd1, 0x50, 0x30,
      0x29, 0xfb, 0xcb, 0xd4, 0x1c, 0xa1, 0xb5, 0x06, 0xec, 0x27, 0xf1, 0x5a, 0xde, 0x7d, 0xac, 0x69 },
    41 /* Bin Number */
  },
  {
    /* DigiCert Global Root CA */
    { 0x43, 0x48, 0xa0, 0xe9, 0x44, 0x4c, 0x78, 0xcb, 0x26, 0x5e, 0x05, 0x8d, 0x5e, 0x89, 0x44, 0xb4,
      0xd8, 0x4f, 0x96, 0x62, 0xbd, 0x26, 0xdb, 0x25, 0x7f, 0x89, 0x34, 0xa4, 0x43, 0xc7, 0x01, 0x61 },
    42 /* Bin Number */
  },
  {
    /* Entrust Root Certification Authority - G2 */
    { 0x43, 0xdf, 0x57, 0x74, 0xb0, 0x3e, 0x7f, 0xef, 0x5f, 0xe4, 0x0d, 0x93, 0x1a, 0x7b, 0xed, 0xf1,
      0xbb, 0x2e, 0x6b, 0x42, 0x73, 0x8c, 0x4e, 0x6d, 0x38, 0x41, 0x10, 0x3d, 0x3a, 0xa7, 0xf3, 0x39 },
    43 /* Bin Number */
  },
  {
    /* Hellenic Academic and Research Institutions ECC RootCA 2015 */
    { 0x44, 0xb5, 0x45, 0xaa, 0x8a, 0x25, 0xe6, 0x5a, 0x73, 0xca, 0x15, 0xdc, 0x27, 0xfc, 0x36, 0xd2,
      0x4c, 0x1c, 0xb9, 0x95, 0x3a, 0x06, 0x65, 0x39, 0xb1, 0x15, 0x82, 0xdc, 0x48, 0x7b, 0x48, 0x33 },
    44 /* Bin Number */
  },
  {
    /* Go Daddy Root Certificate Authority - G2 */
    { 0x45, 0x14, 0x0b, 0x32, 0x47, 0xeb, 0x9c, 0xc8, 0xc5, 0xb4, 0xf0, 0xd7, 0xb5, 0x30, 0x91, 0xf7,
      0x32, 0x92, 0x08, 0x9e, 0x6e, 0x5a, 0x63, 0xe2, 0x74, 0x9d, 0xd3, 0xac, 0xa9, 0x19, 0x8e, 0xda },
    45 /* Bin Number */
  },
  {
    /* TUBITAK Kamu SM SSL Kok Sertifikasi - Surum 1 */
    { 0x46, 0xed, 0xc3, 0x68, 0x90, 0x46, 0xd5, 0x3a, 0x45, 0x3f, 0xb3, 0x10, 0x4a, 0xb8, 0x0d, 0xca,
      0xec, 0x65, 0x8b, 0x26, 0x60, 0xea, 0x16, 0x29, 0xdd, 0x7e, 0x86, 0x79, 0x90, 0x64, 0x87, 0x16 },
    46 /* Bin Number */
  },
  {
    /* D-TRUST Root Class 3 CA 2 2009 */
    { 0x49, 0xe7, 0xa4, 0x42, 0xac, 0xf0, 0xea, 0x62, 0x87, 0x05, 0x00, 0x54, 0xb5, 0x25, 0x64, 0xb6,
      0x50, 0xe4, 0xf4, 0x9e, 0x42, 0xe3, 0x48, 0xd6, 0xaa, 0x38, 0xe0, 0x39, 0xe9, 0x57, 0xb1, 0xc1 },
    47 /* Bin Number */
  },
  {
    /* SecureSign Root CA14 */
    { 0x4b, 0x00, 0x9c, 0x10, 0x34, 0x49, 0x4f, 0x9a, 0xb5, 0x6b, 0xba, 0x3b, 0xa1, 0xd6, 0x27, 0x31,
      0xfc, 0x4d, 0x20, 0xd8, 0x95, 0x5a, 0xdc, 0xec, 0x10, 0xa9, 0x25, 0x60, 0x72, 0x61, 0xe3, 0x38 },
    48 /* Bin Number */
  },
  {
    /* GlobalSign Root R46 */
    { 0x4f, 0xa3, 0x12, 0x6d, 0x8d, 0x3a, 0x11, 0xd1, 0xc4, 0x85, 0x5a, 0x4f, 0x80, 0x7c, 0xba, 0xd6,
      0xcf, 0x91, 0x9d, 0x3a, 0x5a, 0x88, 0xb0, 0x3b, 0xea, 0x2c, 0x63, 0x72, 0xd9, 0x3c, 0x40, 0xc9 },
    49 /* Bin Number */
  },
  {
    /* USERTrust ECC Certification Authority */
    { 0x4f, 0xf4, 0x60, 0xd5, 0x4b, 0x9c, 0x86, 0xda, 0xbf, 0xbc, 0xfc, 0x57, 0x12, 0xe0, 0x40, 0x0d,
      0x2b, 0xed, 0x3f, 0xbc, 0x4d, 0x4f, 0xbd, 0xaa, 0x86, 0xe0, 0x6a, 0xdc, 0xd2, 0xa9, 0xad, 0x7a },
    50 /* Bin Number */
  },
  {
    /* Security Communication RootCA2 */
    { 0x51, 0x3b, 0x2c, 0xec, 0xb8, 0x10, 0xd4, 0xcd, 0xe5, 0xdd, 0x85, 0x39, 0x1a, 0xdf, 0xc6, 0xc2,
      0xdd, 0x60, 0xd8, 0x7b, 0xb7, 0x36, 0xd2, 0xb5, 0x21, 0x48, 0x4a, 0xa4, 0x7a, 0x0e, 0xbe, 0xf6 },
    51 /* Bin Number */
  },
  {
    /* COMODO RSA Certification Authority */
    { 0x52, 0xf0, 0xe1, 0xc4, 0xe5, 0x8e, 0xc6, 0x29, 0x29, 0x1b, 0x60, 0x31, 0x7f, 0x07, 0x46, 0x71,
      0xb8, 0x5d, 0x7e, 0xa8, 0x0d, 0x5b, 0x07, 0x27, 0x34, 0x63, 0x53, 0x4b, 0x32, 0xb4, 0x02, 0x34 },
    52 /* Bin Number */
  },
  {
    /* DigiCert Trusted Root G4 */
    { 0x55, 0x2f, 0x7b, 0xdc, 0xf1, 0xa7, 0xaf, 0x9e, 0x6c, 0xe6, 0x72, 0x01, 0x7f, 0x4f, 0x12, 0xab,
      0xf7, 0x72, 0x40, 0xc7, 0x8e, 0x76, 0x1a, 0xc2, 0x03, 0xd1, 0xd9, 0xd2, 0x0a, 0xc8, 0x99, 0x88 },
    53 /* Bin Number */
  },
  {
    /* AC RAIZ FNMT-RCM SERVIDORES SEGUROS */
    { 0x55, 0x41, 0x53, 0xb1, 0x3d, 0x2c, 0xf9, 0xdd, 0xb7, 0x53, 0xbf, 0xbe, 0x1a, 0x4e, 0x0a, 0xe0,
      0x8d, 0x0a, 0xa4, 0x18, 0x70, 0x58, 0xfe, 0x60, 0xa2, 0xb8, 0x62, 0xb2, 0xe4, 0xb8, 0x7b, 0xcb },
    54 /* Bin Number */
  },
  {
    /* Trustwave Global ECC P384 Certification Authority */
    { 0x55, 0x90, 0x38, 0x59, 0xc8, 0xc0, 0xc3, 0xeb, 0xb8, 0x75, 0x9e, 0xce, 0x4e, 0x25, 0x57, 0x22,
      0x5f, 0xf5, 0x75, 0x8b, 0xbd, 0x38, 0xeb, 0xd4, 0x82, 0x76, 0x60, 0x1e, 0x1b, 0xd5, 0x80, 0x97 },
    55 /* Bin Number */
  },
  {
    /* Actalis Authentication Root CA */
    { 0x55, 0x92, 0x60, 0x84, 0xec, 0x96, 0x3a, 0x64, 0xb9, 0x6e, 0x2a, 0xbe, 0x01, 0xce, 0x0b, 0xa8,
      0x6a, 0x64, 0xfb, 0xfe, 0xbc, 0xc7, 0xaa, 0xb5, 0xaf, 0xc1, 0x55, 0xb3, 0x7f, 0xd7, 0x60, 0x66 },
    56 /* Bin Number */
  },
  {
    /* Starfield Services Root Certificate Authority - G2 */
    { 0x56, 0x8d, 0x69, 0x05, 0xa2, 0xc8, 0x87, 0x08, 0xa4, 0xb3, 0x02, 0x51, 0x90, 0xed, 0xcf, 0xed,
      0xb1, 0x97, 0x4a, 0x60, 0x6a, 0x13, 0xc6, 0xe5, 0x29, 0x0f, 0xcb, 0x2a, 0xe6, 0x3e, 0xda, 0xb5 },
    57 /* Bin Number */
  },
  {
    /* BJCA Global Root CA2 */
    { 0x57, 0x4d, 0xf6, 0x93, 0x1e, 0x27, 0x80, 0x39, 0x66, 0x7b, 0x72, 0x0a, 0xfd, 0xc1, 0x60, 0x0f,
      0xc2, 0x7e, 0xb6, 0x6d, 0xd3, 0x09, 0x29, 0x79, 0xfb, 0x73, 0x85, 0x64, 0x87, 0x21, 0x28, 0x82 },
    58 /* Bin Number */
  },
  {
    /* Telekom Security TLS ECC Root 2020 */
    { 0x57, 0x8a, 0xf4, 0xde, 0xd0, 0x85, 0x3f, 0x4e, 0x59, 0x98, 0xdb, 0x4a, 0xea, 0xf9, 0xcb, 0xea,
      0x8d, 0x94, 0x5f, 0x60, 0xb6, 0x20, 0xa3, 0x8d, 0x1a, 0x3c, 0x13, 0xb2, 0xbc, 0x7b, 0xa8, 0xe1 },
    59 /* Bin Number */
  },
  {
    /* Autoridad de Certificacion Firmaprofesional CIF A62634068 */
    { 0x57, 0xde, 0x05, 0x83, 0xef, 0xd2, 0xb2, 0x6e, 0x03, 0x61, 0xda, 0x99, 0xda, 0x9d, 0xf4, 0x64,
      0x8d, 0xef, 0x7e, 0xe8, 0x44, 0x1c, 0x3b, 0x72, 0x8a, 0xfa, 0x9b, 0xcd, 0xe0, 0xf9, 0xb2, 0x6a },
    60 /* Bin Number */
  },
  {
    /* TWCA Global Root CA */
    { 0x59, 0x76, 0x90, 0x07, 0xf7, 0x68, 0x5d, 0x0f, 0xcd, 0x50, 0x87, 0x2f, 0x9f, 0x95, 0xd5, 0x75,
      0x5a, 0x5b, 0x2b, 0x45, 0x7d, 0x81, 0xf3, 0x69, 0x2b, 0x61, 0x0a, 0x98, 0x67, 0x2f, 0x0e, 0x1b },
    61 /* Bin Number */
  },
  {
    /* Hongkong Post Root CA 3 */
    { 0x5a, 0x2f, 0xc0, 0x3f, 0x0c, 0x83, 0xb0, 0x90, 0xbb, 0xfa, 0x40, 0x60, 0x4b, 0x09, 0x88, 0x44,
      0x6c, 0x76, 0x36, 0x18, 0x3d, 0xf9, 0x84, 0x6e, 0x17, 0x10, 0x1a, 0x44, 0x7f, 0xb8, 0xef, 0xd6 },
    62 /* Bin Number */
  },
  {
    /* Certum Trusted Network CA */
    { 0x5c, 0x58, 0x46, 0x8d, 0x55, 0xf5, 0x8e, 0x49, 0x7e, 0x74, 0x39, 0x82, 0xd2, 0xb5, 0x00, 0x10,
      0xb6, 0xd1, 0x65, 0x37, 0x4a, 0xcf, 0x83, 0xa7, 0xd4, 0xa3, 0x2d, 0xb7, 0x68, 0xc4, 0x40, 0x8e },
    63 /* Bin Number */
  },
  {
    /* CFCA EV ROOT */
    { 0x5c, 0xc3, 0xd7, 0x8e, 0x4e, 0x1d, 0x5e, 0x45, 0x54, 0x7a, 0x04, 0xe6, 0x87, 0x3e, 0x64, 0xf9,
      0x0c, 0xf9, 0x53, 0x6d, 0x1c, 0xcc, 0x2e, 0xf8, 0x00, 0xf3, 0x55, 0xc4, 0xc5, 0xfd, 0x70, 0xfd },
    64 /* Bin Number */
  },
  {
    /* IdenTrust Commercial Root CA 1 */
    { 0x5d, 0x56, 0x49, 0x9b, 0xe4, 0xd2, 0xe0, 0x8b, 0xcf, 0xca, 0xd0, 0x8a, 0x3e, 0x38, 0x72, 0x3d,
      0x50, 0x50, 0x3b, 0xde, 0x70, 0x69, 0x48, 0xe4, 0x2f, 0x55, 0x60, 0x30, 0x19, 0xe5, 0x28, 0xae },
    65 /* Bin Number */
  },
  {
    /* SwissSign Gold CA - G2 */
    { 0x62, 0xdd, 0x0b, 0xe9, 0xb9, 0xf5, 0x0a, 0x16, 0x3e, 0xa0, 0xf8, 0xe7, 0x5c, 0x05, 0x3b, 0x1e,
      0xca, 0x57, 0xea, 0x55, 0xc8, 0x68, 0x8f, 0x64, 0x7c, 0x68, 0x81, 0xf2, 0xc8, 0x35, 0x7b, 0x95 },
    66 /* Bin Number */
  },
  {
    /* certSIGN Root CA G2 */
    { 0x65, 0x7c, 0xfe, 0x2f, 0xa7, 0x3f, 0xaa, 0x38, 0x46, 0x25, 0x71, 0xf3, 0x32, 0xa2, 0x36, 0x3a,
      0x46, 0xfc, 0xe7, 0x02, 0x09, 0x51, 0x71, 0x07, 0x02, 0xcd, 0xfb, 0xb6, 0xee, 0xda, 0x33, 0x05 },
    67 /* Bin Number */
  },
  {
    /* ISRG Root X2 */
    { 0x69, 0x72, 0x9b, 0x8e, 0x15, 0xa8, 0x6e, 0xfc, 0x17, 0x7a, 0x57, 0xaf, 0xb7, 0x17, 0x1d, 0xfc,
      0x64, 0xad, 0xd2, 0x8c, 0x2f, 0xca, 0x8c, 0xf1, 0x50, 0x7e, 0x34, 0x45, 0x3c, 0xcb, 0x14, 0x70 },
    68 /* Bin Number */
  },
  {
    /* Certum EC-384 CA */
    { 0x6b, 0x32, 0x80, 0x85, 0x62, 0x53, 0x18, 0xaa, 0x50, 0xd1, 0x73, 0xc9, 0x8d, 0x8b, 0xda, 0x09,
      0xd5, 0x7e, 0x27, 0x41, 0x3d, 0x11, 0x4c, 0xf7, 0x87, 0xa0, 0xf5, 0xd0, 0x6c, 0x03, 0x0c, 0xf6 },
    69 /* Bin Number */
  },
  {
    /* OISTE WISeKey Global Root GB CA */
    { 0x6b, 0x9c, 0x08, 0xe8, 0x6e, 0xb0, 0xf7, 0x67, 0xcf, 0xad, 0x65, 0xcd, 0x98, 0xb6, 0x21, 0x49,
      0xe5, 0x49, 0x4a, 0x67, 0xf5, 0x84, 0x5e, 0x7b, 0xd1, 0xed, 0x01, 0x9f, 0x27, 0xb8, 0x6b, 0xd6 },
    70 /* Bin Number */
  },
  {
    /* NetLock Arany (Class Gold) Főtanúsítvány */
    { 0x6c, 0x61, 0xda, 0xc3, 0xa2, 0xde, 0xf0, 0x31, 0x50, 0x6b, 0xe0, 0x36, 0xd2, 0xa6, 0xfe, 0x40,
      0x19, 0x94, 0xfb, 0xd1, 0x3d, 0xf9, 0xc8, 0xd4, 0x66, 0x59, 0x92, 0x74, 0xc4, 0x46, 0xec, 0x98 },
    71 /* Bin Number */
  },
  {
    /* AffirmTrust Premium */
    { 0x70, 0xa7, 0x3f, 0x7f, 0x37, 0x6b, 0x60, 0x07, 0x42, 0x48, 0x90, 0x45, 0x34, 0xb1, 0x14, 0x82,
      0xd5, 0xbf, 0x0e, 0x69, 0x8e, 0xcc, 0x49, 0x8d, 0xf5, 0x25, 0x77, 0xeb, 0xf2, 0xe9, 0x3b, 0x9a },
    72 /* Bin Number */
  },
  {
    /* Entrust Root Certification Authority */
    { 0x73, 0xc1, 0x76, 0x43, 0x4f, 0x1b, 0xc6, 0xd5, 0xad, 0xf4, 0x5b, 0x0e, 0x76, 0xe7, 0x27, 0x28,
      0x7c, 0x8d, 0xe5, 0x76, 0x16, 0xc1, 0xe6, 0xe6, 0x14, 0x1a, 0x2b, 0x2c, 0xbc, 0x7d, 0x8e, 0x4c },
    73 /* Bin Number */
  },
  {
    /* DigiCert High Assurance EV Root CA */
    { 0x74, 0x31, 0xe5, 0xf4, 0xc3, 0xc1, 0xce, 0x46, 0x90, 0x77, 0x4f, 0x0b, 0x61, 0xe0, 0x54, 0x40,
      0x88, 0x3b, 0xa9, 0xa0, 0x1e, 0xd0, 0x0b, 0xa6, 0xab, 0xd7, 0x80, 0x6e, 0xd3, 0xb1, 0x18, 0xcf },
    74 /* Bin Number */
  },
  {
    /* Certainly Root R1 */
    { 0x77, 0xb8, 0x2c, 0xd8, 0x64, 0x4c, 0x43, 0x05, 0xf7, 0xac, 0xc5, 0xcb, 0x15, 0x6b, 0x45, 0x67,
      0x50, 0x04, 0x03, 0x3d, 0x51, 0xc6, 0x0c, 0x62, 0x02, 0xa8, 0xe0, 0xc3, 0x34, 0x67, 0xd3, 0xa0 },
    75 /* Bin Number */
  },
  {
    /* Sectigo Public Server Authentication Root R46 */
    { 0x7b, 0xb6, 0x47, 0xa6, 0x2a, 0xee, 0xac, 0x88, 0xbf, 0x25, 0x7a, 0xa5, 0x22, 0xd0, 0x1f, 0xfe,
      0xa3, 0x95, 0xe0, 0xab, 0x45, 0xc7, 0x3f, 0x93, 0xf6, 0x56, 0x54, 0xec, 0x38, 0xf2, 0x5a, 0x06 },
    76 /* Bin Number */
  },
  {
    /* DigiCert Assured ID Root G2 */
    { 0x7d, 0x05, 0xeb, 0xb6, 0x82, 0x33, 0x9f, 0x8c, 0x94, 0x51, 0xee, 0x09, 0x4e, 0xeb, 0xfe, 0xfa,
      0x79, 0x53, 0xa1, 0x14, 0xed, 0xb2, 0xf4, 0x49, 0x49, 0x45, 0x2f, 0xab, 0x7d, 0x2f, 0xc1, 0x85 },
    77 /* Bin Number */
  },
  {
    /* DigiCert Assured ID Root G3 */
    { 0x7e, 0x37, 0xcb, 0x8b, 0x4c, 0x47, 0x09, 0x0c, 0xab, 0x36, 0x55, 0x1b, 0xa6, 0xf4, 0x5d, 0xb8,
      0x40, 0x68, 0x0f, 0xba, 0x16, 0x6a, 0x95, 0x2d, 0xb1, 0x00, 0x71, 0x7f, 0x43, 0x05, 0x3f, 0xc2 },
    78 /* Bin Number */
  },
  {
    /* Atos TrustedRoot Root CA RSA TLS 2021 */
    { 0x81, 0xa9, 0x08, 0x8e, 0xa5, 0x9f, 0xb3, 0x64, 0xc5, 0x48, 0xa6, 0xf8, 0x55, 0x59, 0x09, 0x9b,
      0x6f, 0x04, 0x05, 0xef, 0xbf, 0x18, 0xe5, 0x32, 0x4e, 0xc9, 0xf4, 0x57, 0xba, 0x00, 0x11, 0x2f },
    79 /* Bin Number */
  },
  {
    /* OISTE WISeKey Global Root GC CA */
    { 0x85, 0x60, 0xf9, 0x1c, 0x36, 0x24, 0xda, 0xba, 0x95, 0x70, 0xb5, 0xfe, 0xa0, 0xdb, 0xe3, 0x6f,
      0xf1, 0x1a, 0x83, 0x23, 0xbe, 0x94, 0x86, 0x85, 0x4f, 0xb3, 0xf3, 0x4a, 0x55, 0x71, 0x19, 0x8d },
    80 /* Bin Number */
  },
  {
    /* SSL.com Root Certification Authority RSA */
    { 0x85, 0x66, 0x6a, 0x56, 0x2e, 0xe0, 0xbe, 0x5c, 0xe9, 0x25, 0xc1, 0xd8, 0x89, 0x0a, 0x6f, 0x76,
      0xa8, 0x7e, 0xc1, 0x6d, 0x4d, 0x7d, 0x5f, 0x29, 0xea, 0x74, 0x19, 0xcf, 0x20, 0x12, 0x3b, 0x69 },
    81 /* Bin Number */
  },
  {
    /* QuoVadis Root CA 2 */
    { 0x85, 0xa0, 0xdd, 0x7d, 0xd7, 0x20, 0xad, 0xb7, 0xff, 0x05, 0xf8, 0x3d, 0x54, 0x2b, 0x20, 0x9d,
      0xc7, 0xff, 0x45, 0x28, 0xf7, 0xd6, 0x77, 0xb1, 0x83, 0x89, 0xfe, 0xa5, 0xe5, 0xc4, 0x9e, 0x86 },
    82 /* Bin Number */
  },
  {
    /* emSign ECC Root CA - G3 */
    { 0x86, 0xa1, 0xec, 0xba, 0x08, 0x9c, 0x4a, 0x8d, 0x3b, 0xbe, 0x27, 0x34, 0xc6, 0x12, 0xba, 0x34,
      0x1d, 0x81, 0x3e, 0x04, 0x3c, 0xf9, 0xe8, 0xa8, 0x62, 0xcd, 0x5c, 0x57, 0xa3, 0x6b, 0xbe, 0x6b },
    83 /* Bin Number */
  },
  {
    /* QuoVadis Root CA 3 G3 */
    { 0x88, 0xef, 0x81, 0xde, 0x20, 0x2e, 0xb0, 0x18, 0x45, 0x2e, 0x43, 0xf8, 0x64, 0x72, 0x5c, 0xea,
      0x5f, 0xbd, 0x1f, 0xc2, 0xd9, 0xd2, 0x05, 0x73, 0x07, 0x09, 0xc5, 0xd8, 0xb8, 0x69, 0x0f, 0x46 },
    84 /* Bin Number */
  },
  {
    /* NAVER Global Root Certification Authority */
    { 0x88, 0xf4, 0x38, 0xdc, 0xf8, 0xff, 0xd1, 0xfa, 0x8f, 0x42, 0x91, 0x15, 0xff, 0xe5, 0xf8, 0x2a,
      0xe1, 0xe0, 0x6e, 0x0c, 0x70, 0xc3, 0x75, 0xfa, 0xad, 0x71, 0x7b, 0x34, 0xa4, 0x9e, 0x72, 0x65 },
    85 /* Bin Number */
  },
  {
    /* vTrus Root CA */
    { 0x8a, 0x71, 0xde, 0x65, 0x59, 0x33, 0x6f, 0x42, 0x6c, 0x26, 0xe5, 0x38, 0x80, 0xd0, 0x0d, 0x88,
      0xa1, 0x8d, 0xa4, 0xc6, 0xa9, 0x1f, 0x0d, 0xcb, 0x61, 0x94, 0xe2, 0x06, 0xc5, 0xc9, 0x63, 0x87 },
    86 /* Bin Number */
  },
  {
    /* QuoVadis Root CA 1 G3 */
    { 0x8a, 0x86, 0x6f, 0xd1, 0xb2, 0x76, 0xb5, 0x7e, 0x57, 0x8e, 0x92, 0x1c, 0x65, 0x82, 0x8a, 0x2b,
      0xed, 0x58, 0xe9, 0xf2, 0xf2, 0x88, 0x05, 0x41, 0x34, 0xb7, 0xf1, 0xf4, 0xbf, 0xc9, 0xcc, 0x74 },
    87 /* Bin Number */
  },
  {
    /* GTS Root R2 */
    { 0x8d, 0x25, 0xcd, 0x97, 0x22, 0x9d, 0xbf, 0x70, 0x35, 0x6b, 0xda, 0x4e, 0xb3, 0xcc, 0x73, 0x40,
      0x31, 0xe2, 0x4c, 0xf0, 0x0f, 0xaf, 0xcf, 0xd3, 0x2d, 0xc7, 0x6e, 0xb5, 0x84, 0x1c, 0x7e, 0xa8 },
    88 /* Bin Number */
  },
  {
    /* D-TRUST EV Root CA 2 2023 */
    { 0x8e, 0x82, 0x21, 0xb2, 0xe7, 0xd4, 0x00, 0x78, 0x36, 0xa1, 0x67, 0x2f, 0x0d, 0xcc, 0x29, 0x9c,
      0x33, 0xbc, 0x07, 0xd3, 0x16, 0xf1, 0x32, 0xfa, 0x1a, 0x20, 0x6d, 0x58, 0x71, 0x50, 0xf1, 0xce },
    89 /* Bin Number */
  },
  {
    /* Amazon Root CA 1 */
    { 0x8e, 0xcd, 0xe6, 0x88, 0x4f, 0x3d, 0x87, 0xb1, 0x12, 0x5b, 0xa3, 0x1a, 0xc3, 0xfc, 0xb1, 0x3d,
      0x70, 0x16, 0xde, 0x7f, 0x57, 0xcc, 0x90, 0x4f, 0xe1, 0xcb, 0x97, 0xc6, 0xae, 0x98, 0x19, 0x6e },
    90 /* Bin Number */
  },
  {
    /* SSL.com TLS RSA Root CA 2022 */
    { 0x8f, 0xaf, 0x7d, 0x2e, 0x2c, 0xb4, 0x70, 0x9b, 0xb8, 0xe0, 0xb3, 0x36, 0x66, 0xbf, 0x75, 0xa5,
      0xdd, 0x45, 0xb5, 0xde, 0x48, 0x0f, 0x8e, 0xa8, 0xd4, 0xbf, 0xe6, 0xbe, 0xbc, 0x17, 0xf2, 0xed },
    91 /* Bin Number */
  },
  {
    /* QuoVadis Root CA 2 G3 */
    { 0x8f, 0xe4, 0xfb, 0x0a, 0xf9, 0x3a, 0x4d, 0x0d, 0x67, 0xdb, 0x0b, 0xeb, 0xb2, 0x3e, 0x37, 0xc7,
      0x1b, 0xf3, 0x25, 0xdc, 0xbc, 0xdd, 0x24, 0x0e, 0xa0, 0x4d, 0xaf, 0x58, 0xb4, 0x7e, 0x18, 0x40 },
    92 /* Bin Number */
  },
  {
    /* T-TeleSec GlobalRoot Class 2 */
    { 0x91, 0xe2, 0xf5, 0x78, 0x8d, 0x58, 0x10, 0xeb, 0xa7, 0xba, 0x58, 0x73, 0x7d, 0xe1, 0x54, 0x8a,
      0x8e, 0xca, 0xcd, 0x01, 0x45, 0x98, 0xbc, 0x0b, 0x14, 0x3e, 0x04, 0x1b, 0x17, 0x05, 0x25, 0x52 },
    93 /* Bin Number */
  },
  {
    /* Trustwave Global ECC P256 Certification Authority */
    { 0x94, 0x5b, 0xbc, 0x82, 0x5e, 0xa5, 0x54, 0xf4, 0x89, 0xd1, 0xfd, 0x51, 0xa7, 0x3d, 0xdf, 0x2e,
      0xa6, 0x24, 0xac, 0x70, 0x19, 0xa0, 0x52, 0x05, 0x22, 0x5c, 0x22, 0xa7, 0x8c, 0xcf, 0xa8, 0xb4 },
    94 /* Bin Number */
  },
  {
    /* ISRG Root X1 */
    { 0x96, 0xbc, 0xec, 0x06, 0x26, 0x49, 0x76, 0xf3, 0x74, 0x60, 0x77, 0x9a, 0xcf, 0x28, 0xc5, 0xa7,
      0xcf, 0xe8, 0xa3, 0xc0, 0xaa, 0xe1, 0x1a, 0x8f, 0xfc, 0xee, 0x05, 0xc0, 0xbd, 0xdf, 0x08, 0xc6 },
    95 /* Bin Number */
  },
  {
    /* Trustwave Global Certification Authority */
    { 0x97, 0x55, 0x20, 0x15, 0xf5, 0xdd, 0xfc, 0x3c, 0x87, 0x88, 0xc0, 0x06, 0x94, 0x45, 0x55, 0x40,
      0x88, 0x94, 0x45, 0x00, 0x84, 0xf1, 0x00, 0x86, 0x70, 0x86, 0xbc, 0x1a, 0x2b, 0xb5, 0x8d, 0xc8 },
    96 /* Bin Number */
  },
  {
    /* Buypass Class 2 Root CA */
    { 0x9a, 0x11, 0x40, 0x25, 0x19, 0x7c, 0x5b, 0xb9, 0x5d, 0x94, 0xe6, 0x3d, 0x55, 0xcd, 0x43, 0x79,
      0x08, 0x47, 0xb6, 0x46, 0xb2, 0x3c, 0xdf, 0x11, 0xad, 0xa4, 0xa0, 0x0e, 0xff, 0x15, 0xfb, 0x48 },
    97 /* Bin Number */
  },
  {
    /* GLOBALTRUST 2020 */
    { 0x9a, 0x29, 0x6a, 0x51, 0x82, 0xd1, 0xd4, 0x51, 0xa2, 0xe3, 0x7f, 0x43, 0x9b, 0x74, 0xda, 0xaf,
      0xa2, 0x67, 0x52, 0x33, 0x29, 0xf9, 0x0f, 0x9a, 0x0d, 0x20, 0x07, 0xc3, 0x34, 0xe2, 0x3c, 0x9a },
    98 /* Bin Number */
  },
  {
    /* ACCVRAIZ1 */
    { 0x9a, 0x6e, 0xc0, 0x12, 0xe1, 0xa7, 0xda, 0x9d, 0xbe, 0x34, 0x19, 0x4d, 0x47, 0x8a, 0xd7, 0xc0,
      0xdb, 0x18, 0x22, 0xfb, 0x07, 0x1d, 0xf1, 0x29, 0x81, 0x49, 0x6e, 0xd1, 0x04, 0x38, 0x41, 0x13 },
    99 /* Bin Number */
  },
  {
    /*  OISTE Server Root RSA G1 */
    { 0x9a, 0xe3, 0x62, 0x32, 0xa5, 0x18, 0x9f, 0xfd, 0xdb, 0x35, 0x3d, 0xfd, 0x26, 0x52, 0x0c, 0x01,
      0x53, 0x95, 0xd2, 0x27, 0x77, 0xda, 0xc5, 0x9d, 0xb5, 0x7b, 0x98, 0xc0, 0x89, 0xa6, 0x51, 0xe6 },
    150 /* Bin Number */
  },
  {
    /* UCA Global G2 Root */
    { 0x9b, 0xea, 0x11, 0xc9, 0x76, 0xfe, 0x01, 0x47, 0x64, 0xc1, 0xbe, 0x56, 0xa6, 0xf9, 0x14, 0xb5,
      0xa5, 0x60, 0x31, 0x7a, 0xbd, 0x99, 0x88, 0x39, 0x33, 0x82, 0xe5, 0x16, 0x1a, 0xa0, 0x49, 0x3c },
    100 /* Bin Number */
  },
  {
    /* Hellenic Academic and Research Institutions RootCA 2015 */
    { 0xa0, 0x40, 0x92, 0x9a, 0x02, 0xce, 0x53, 0xb4, 0xac, 0xf4, 0xf2, 0xff, 0xc6, 0x98, 0x1c, 0xe4,
      0x49, 0x6f, 0x75, 0x5e, 0x6d, 0x45, 0xfe, 0x0b, 0x2a, 0x69, 0x2b, 0xcd, 0x52, 0x52, 0x3f, 0x36 },
    101 /* Bin Number */
  },
  {
    /* SZAFIR ROOT CA2 */
    { 0xa1, 0x33, 0x9d, 0x33, 0x28, 0x1a, 0x0b, 0x56, 0xe5, 0x57, 0xd3, 0xd3, 0x2b, 0x1c, 0xe7, 0xf9,
      0x36, 0x7e, 0xb0, 0x94, 0xbd, 0x5f, 0xa7, 0x2a, 0x7e, 0x50, 0x04, 0xc8, 0xde, 0xd7, 0xca, 0xfe },
    102 /* Bin Number */
  },
  {
    /* GlobalSign ECC Root CA - R4 */
    { 0xb0, 0x85, 0xd7, 0x0b, 0x96, 0x4f, 0x19, 0x1a, 0x73, 0xe4, 0xaf, 0x0d, 0x54, 0xae, 0x7a, 0x0e,
      0x07, 0xaa, 0xfd, 0xaf, 0x9b, 0x71, 0xdd, 0x08, 0x62, 0x13, 0x8a, 0xb7, 0x32, 0x5a, 0x24, 0xa2 },
    103 /* Bin Number */
  },
  {
    /* Atos TrustedRoot Root CA ECC TLS 2021 */
    { 0xb2, 0xfa, 0xe5, 0x3e, 0x14, 0xcc, 0xd7, 0xab, 0x92, 0x12, 0x06, 0x47, 0x01, 0xae, 0x27, 0x9c,
      0x1d, 0x89, 0x88, 0xfa, 0xcb, 0x77, 0x5f, 0xa8, 0xa0, 0x08, 0x91, 0x4e, 0x66, 0x39, 0x88, 0xa8 },
    104 /* Bin Number */
  },
  {
    /* Certainly Root E1 */
    { 0xb4, 0x58, 0x5f, 0x22, 0xe4, 0xac, 0x75, 0x6a, 0x4e, 0x86, 0x12, 0xa1, 0x36, 0x1c, 0x5d, 0x9d,
      0x03, 0x1a, 0x93, 0xfd, 0x84, 0xfe, 0xbb, 0x77, 0x8f, 0xa3, 0x06, 0x8b, 0x0f, 0xc4, 0x2d, 0xc2 },
    105 /* Bin Number */
  },
  {
    /* Certum Trusted Network CA 2 */
    { 0xb6, 0x76, 0xf2, 0xed, 0xda, 0xe8, 0x77, 0x5c, 0xd3, 0x6c, 0xb0, 0xf6, 0x3c, 0xd1, 0xd4, 0x60,
      0x39, 0x61, 0xf4, 0x9e, 0x62, 0x65, 0xba, 0x01, 0x3a, 0x2f, 0x03, 0x07, 0xb6, 0xd0, 0xb8, 0x04 },
    106 /* Bin Number */
  },
  {
    /* emSign ECC Root CA - C3 */
    { 0xbc, 0x4d, 0x80, 0x9b, 0x15, 0x18, 0x9d, 0x78, 0xdb, 0x3e, 0x1d, 0x8c, 0xf4, 0xf9, 0x72, 0x6a,
      0x79, 0x5d, 0xa1, 0x64, 0x3c, 0xa5, 0xf1, 0x35, 0x8e, 0x1d, 0xdb, 0x0e, 0xdc, 0x0d, 0x7e, 0xb3 },
    107 /* Bin Number */
  },
  {
    /* AffirmTrust Premium ECC */
    { 0xbd, 0x71, 0xfd, 0xf6, 0xda, 0x97, 0xe4, 0xcf, 0x62, 0xd1, 0x64, 0x7a, 0xdd, 0x25, 0x81, 0xb0,
      0x7d, 0x79, 0xad, 0xf8, 0x39, 0x7e, 0xb4, 0xec, 0xba, 0x9c, 0x5e, 0x84, 0x88, 0x82, 0x14, 0x23 },
    108 /* Bin Number */
  },
  {
    /* TrustAsia Global Root CA G4 */
    { 0xbe, 0x4b, 0x56, 0xcb, 0x50, 0x56, 0xc0, 0x13, 0x6a, 0x52, 0x6d, 0xf4, 0x44, 0x50, 0x8d, 0xaa,
      0x36, 0xa0, 0xb5, 0x4f, 0x42, 0xe4, 0xac, 0x38, 0xf7, 0x2a, 0xf4, 0x70, 0xe4, 0x79, 0x65, 0x4c },
    109 /* Bin Number */
  },
  {
    /* e-Szigno Root CA 2017 */
    { 0xbe, 0xb0, 0x0b, 0x30, 0x83, 0x9b, 0x9b, 0xc3, 0x2c, 0x32, 0xe4, 0x44, 0x79, 0x05, 0x95, 0x06,
      0x41, 0xf2, 0x64, 0x21, 0xb1, 0x5e, 0xd0, 0x89, 0x19, 0x8b, 0x51, 0x8a, 0xe2, 0xea, 0x1b, 0x99 },
    110 /* Bin Number */
  },
  {
    /* FIRMAPROFESIONAL CA ROOT-A WEB */
    { 0xbe, 0xf2, 0x56, 0xda, 0xf2, 0x6e, 0x9c, 0x69, 0xbd, 0xec, 0x16, 0x02, 0x35, 0x97, 0x98, 0xf3,
      0xca, 0xf7, 0x18, 0x21, 0xa0, 0x3e, 0x01, 0x82, 0x57, 0xc5, 0x3c, 0x65, 0x61, 0x7f, 0x3d, 0x4a },
    111 /* Bin Number */
  },
  {
    /* TWCA Root Certification Authority */
    { 0xbf, 0xd8, 0x8f, 0xe1, 0x10, 0x1c, 0x41, 0xae, 0x3e, 0x80, 0x1b, 0xf8, 0xbe, 0x56, 0x35, 0x0e,
      0xe9, 0xba, 0xd1, 0xa6, 0xb9, 0xbd, 0x51, 0x5e, 0xdc, 0x5c, 0x6d, 0x5b, 0x87, 0x11, 0xac, 0x44 },
    112 /* Bin Number */
  },
  {
    /* GDCA TrustAUTH R5 ROOT */
    { 0xbf, 0xff, 0x8f, 0xd0, 0x44, 0x33, 0x48, 0x7d, 0x6a, 0x8a, 0xa6, 0x0c, 0x1a, 0x29, 0x76, 0x7a,
      0x9f, 0xc2, 0xbb, 0xb0, 0x5e, 0x42, 0x0f, 0x71, 0x3a, 0x13, 0xb9, 0x92, 0x89, 0x1d, 0x38, 0x93 },
    113 /* Bin Number */
  },
  {
    /* TrustAsia TLS ECC Root CA */
    { 0xc0, 0x07, 0x6b, 0x9e, 0xf0, 0x53, 0x1f, 0xb1, 0xa6, 0x56, 0xd6, 0x7c, 0x4e, 0xbe, 0x97, 0xcd,
      0x5d, 0xba, 0xa4, 0x1e, 0xf4, 0x45, 0x98, 0xac, 0xc2, 0x48, 0x98, 0x78, 0xc9, 0x2d, 0x87, 0x11 },
    149 /* Bin Number */
  },
  {
    /* ePKI Root Certification Authority */
    { 0xc0, 0xa6, 0xf4, 0xdc, 0x63, 0xa2, 0x4b, 0xfd, 0xcf, 0x54, 0xef, 0x2a, 0x6a, 0x08, 0x2a, 0x0a,
      0x72, 0xde, 0x35, 0x80, 0x3e, 0x2f, 0xf5, 0xff, 0x52, 0x7a, 0xe5, 0xd8, 0x72, 0x06, 0xdf, 0xd5 },
    146 /* Bin Number */
  },
  {
    /* SSL.com TLS ECC Root CA 2022 */
    { 0xc3, 0x2f, 0xfd, 0x9f, 0x46, 0xf9, 0x36, 0xd1, 0x6c, 0x36, 0x73, 0x99, 0x09, 0x59, 0x43, 0x4b,
      0x9a, 0xd6, 0x0a, 0xaf, 0xbb, 0x9e, 0x7c, 0xf3, 0x36, 0x54, 0xf1, 0x44, 0xcc, 0x1b, 0xa1, 0x43 },
    114 /* Bin Number */
  },
  {
    /* Microsoft RSA Root Certificate Authority 2017 */
    { 0xc7, 0x41, 0xf7, 0x0f, 0x4b, 0x2a, 0x8d, 0x88, 0xbf, 0x2e, 0x71, 0xc1, 0x41, 0x22, 0xef, 0x53,
      0xef, 0x10, 0xeb, 0xa0, 0xcf, 0xa5, 0xe6, 0x4c, 0xfa, 0x20, 0xf4, 0x18, 0x85, 0x30, 0x73, 0xe0 },
    115 /* Bin Number */
  },
  {
    /* Sectigo Public Server Authentication Root E46 */
    { 0xc9, 0x0f, 0x26, 0xf0, 0xfb, 0x1b, 0x40, 0x18, 0xb2, 0x22, 0x27, 0x51, 0x9b, 0x5c, 0xa2, 0xb5,
      0x3e, 0x2c, 0xa5, 0xb3, 0xbe, 0x5c, 0xf1, 0x8e, 0xfe, 0x1b, 0xef, 0x47, 0x38, 0x0c, 0x53, 0x83 },
    116 /* Bin Number */
  },
  {
    /* DigiCert Global Root G2 */
    { 0xcb, 0x3c, 0xcb, 0xb7, 0x60, 0x31, 0xe5, 0xe0, 0x13, 0x8f, 0x8d, 0xd3, 0x9a, 0x23, 0xf9, 0xde,
      0x47, 0xff, 0xc3, 0x5e, 0x43, 0xc1, 0x14, 0x4c, 0xea, 0x27, 0xd4, 0x6a, 0x5a, 0xb1, 0xcb, 0x5f },
    117 /* Bin Number */
  },
  {
    /* GlobalSign Root CA - R3 */
    { 0xcb, 0xb5, 0x22, 0xd7, 0xb7, 0xf1, 0x27, 0xad, 0x6a, 0x01, 0x13, 0x86, 0x5b, 0xdf, 0x1c, 0xd4,
      0x10, 0x2e, 0x7d, 0x07, 0x59, 0xaf, 0x63, 0x5a, 0x7c, 0xf4, 0x72, 0x0d, 0xc9, 0x63, 0xc5, 0x3b },
    118 /* Bin Number */
  },
  {
    /* GlobalSign Root E46 */
    { 0xcb, 0xb9, 0xc4, 0x4d, 0x84, 0xb8, 0x04, 0x3e, 0x10, 0x50, 0xea, 0x31, 0xa6, 0x9f, 0x51, 0x49,
      0x55, 0xd7, 0xbf, 0xd2, 0xe2, 0xc6, 0xb4, 0x93, 0x01, 0x01, 0x9a, 0xd6, 0x1d, 0x9f, 0x50, 0x58 },
    119 /* Bin Number */
  },
  {
    /* UCA Extended Validation Root */
    { 0xd4, 0x3a, 0xf9, 0xb3, 0x54, 0x73, 0x75, 0x5c, 0x96, 0x84, 0xfc, 0x06, 0xd7, 0xd8, 0xcb, 0x70,
      0xee, 0x5c, 0x28, 0xe7, 0x73, 0xfb, 0x29, 0x4e, 0xb4, 0x1e, 0xe7, 0x17, 0x22, 0x92, 0x4d, 0x24 },
    120 /* Bin Number */
  },
  {
    /* Certigna Root CA */
    { 0xd4, 0x8d, 0x3d, 0x23, 0xee, 0xdb, 0x50, 0xa4, 0x59, 0xe5, 0x51, 0x97, 0x60, 0x1c, 0x27, 0x77,
      0x4b, 0x9d, 0x7b, 0x18, 0xc9, 0x4d, 0x5a, 0x05, 0x95, 0x11, 0xa1, 0x02, 0x50, 0xb9, 0x31, 0x68 },
    121 /* Bin Number */
  },
  {
    /* GTS Root R1 */
    { 0xd9, 0x47, 0x43, 0x2a, 0xbd, 0xe7, 0xb7, 0xfa, 0x90, 0xfc, 0x2e, 0x6b, 0x59, 0x10, 0x1b, 0x12,
      0x80, 0xe0, 0xe1, 0xc7, 0xe4, 0xe4, 0x0f, 0xa3, 0xc6, 0x88, 0x7f, 0xff, 0x57, 0xa7, 0xf4, 0xcf },
    122 /* Bin Number */
  },
  {
    /* HARICA TLS RSA Root CA 2021 */
    { 0xd9, 0x5d, 0x0e, 0x8e, 0xda, 0x79, 0x52, 0x5b, 0xf9, 0xbe, 0xb1, 0x1b, 0x14, 0xd2, 0x10, 0x0d,
      0x32, 0x94, 0x98, 0x5f, 0x0c, 0x62, 0xd9, 0xfa, 0xbd, 0x9c, 0xd9, 0x99, 0xec, 0xcb, 0x7b, 0x1d },
    123 /* Bin Number */
  },
  {
    /* TeliaSonera Root CA v1 */
    { 0xdd, 0x69, 0x36, 0xfe, 0x21, 0xf8, 0xf0, 0x77, 0xc1, 0x23, 0xa1, 0xa5, 0x21, 0xc1, 0x22, 0x24,
      0xf7, 0x22, 0x55, 0xb7, 0x3e, 0x03, 0xa7, 0x26, 0x06, 0x93, 0xe8, 0xa2, 0x4b, 0x0f, 0xa3, 0x89 },
    124 /* Bin Number */
  },
  {
    /* TrustAsia Global Root CA G3 */
    { 0xe0, 0xd3, 0x22, 0x6a, 0xeb, 0x11, 0x63, 0xc2, 0xe4, 0x8f, 0xf9, 0xbe, 0x3b, 0x50, 0xb4, 0xc6,
      0x43, 0x1b, 0xe7, 0xbb, 0x1e, 0xac, 0xc5, 0xc3, 0x6b, 0x5d, 0x5e, 0xc5, 0x09, 0x03, 0x9a, 0x08 },
    125 /* Bin Number */
  },
  {
    /* CA Disig Root R2 */
    { 0xe2, 0x3d, 0x4a, 0x03, 0x6d, 0x7b, 0x70, 0xe9, 0xf5, 0x95, 0xb1, 0x42, 0x20, 0x79, 0xd2, 0xb9,
      0x1e, 0xdf, 0xbb, 0x1f, 0xb6, 0x51, 0xa0, 0x63, 0x3e, 0xaa, 0x8a, 0x9d, 0xc5, 0xf8, 0x07, 0x03 },
    126 /* Bin Number */
  },
  {
    /* Amazon Root CA 4 */
    { 0xe3, 0x5d, 0x28, 0x41, 0x9e, 0xd0, 0x20, 0x25, 0xcf, 0xa6, 0x90, 0x38, 0xcd, 0x62, 0x39, 0x62,
      0x45, 0x8d, 0xa5, 0xc6, 0x95, 0xfb, 0xde, 0xa3, 0xc2, 0x2b, 0x0b, 0xfb, 0x25, 0x89, 0x70, 0x92 },
    127 /* Bin Number */
  },
  {
    /* Certigna */
    { 0xe3, 0xb6, 0xa2, 0xdb, 0x2e, 0xd7, 0xce, 0x48, 0x84, 0x2f, 0x7a, 0xc5, 0x32, 0x41, 0xc7, 0xb7,
      0x1d, 0x54, 0x14, 0x4b, 0xfb, 0x40, 0xc1, 0x1f, 0x3f, 0x1d, 0x0b, 0x42, 0xf5, 0xee, 0xa1, 0x2d },
    128 /* Bin Number */
  },
  {
    /* D-TRUST BR Root CA 1 2020 */
    { 0xe5, 0x9a, 0xaa, 0x81, 0x60, 0x09, 0xc2, 0x2b, 0xff, 0x5b, 0x25, 0xba, 0xd3, 0x7d, 0xf3, 0x06,
      0xf0, 0x49, 0x79, 0x7c, 0x1f, 0x81, 0xd8, 0x5a, 0xb0, 0x89, 0xe6, 0x57, 0xbd, 0x8f, 0x00, 0x44 },
    129 /* Bin Number */
  },
  {
    /* Security Communication ECC RootCA1 */
    { 0xe7, 0x4f, 0xbd, 0xa5, 0x5b, 0xd5, 0x64, 0xc4, 0x73, 0xa3, 0x6b, 0x44, 0x1a, 0xa7, 0x99, 0xc8,
      0xa6, 0x8e, 0x07, 0x74, 0x40, 0xe8, 0x28, 0x8b, 0x9f, 0xa1, 0xe5, 0x0e, 0x4b, 0xba, 0xca, 0x11 },
    130 /* Bin Number */
  },
  {
    /* SecureSign Root CA15 */
    { 0xe7, 0x78, 0xf0, 0xf0, 0x95, 0xfe, 0x84, 0x37, 0x29, 0xcd, 0x1a, 0x00, 0x82, 0x17, 0x9e, 0x53,
      0x14, 0xa9, 0xc2, 0x91, 0x44, 0x28, 0x05, 0xe1, 0xfb, 0x1d, 0x8f, 0xb6, 0xb8, 0x88, 0x6c, 0x3a },
    131 /* Bin Number */
  },
  {
    /* USERTrust RSA Certification Authority */
    { 0xe7, 0x93, 0xc9, 0xb0, 0x2f, 0xd8, 0xaa, 0x13, 0xe2, 0x1c, 0x31, 0x22, 0x8a, 0xcc, 0xb0, 0x81,
      0x19, 0x64, 0x3b, 0x74, 0x9c, 0x89, 0x89, 0x64, 0xb1, 0x74, 0x6d, 0x46, 0xc3, 0xd4, 0xcb, 0xd2 },
    132 /* Bin Number */
  },
  {
    /* certSIGN ROOT CA */
    { 0xea, 0xa9, 0x62, 0xc4, 0xfa, 0x4a, 0x6b, 0xaf, 0xeb, 0xe4, 0x15, 0x19, 0x6d, 0x35, 0x1c, 0xcd,
      0x88, 0x8d, 0x4f, 0x53, 0xf3, 0xfa, 0x8a, 0xe6, 0xd7, 0xc4, 0x66, 0xa9, 0x4e, 0x60, 0x42, 0xbb },
    133 /* Bin Number */
  },
  {
    /* AC RAIZ FNMT-RCM */
    { 0xeb, 0xc5, 0x57, 0x0c, 0x29, 0x01, 0x8c, 0x4d, 0x67, 0xb1, 0xaa, 0x12, 0x7b, 0xaf, 0x12, 0xf7,
      0x03, 0xb4, 0x61, 0x1e, 0xbc, 0x17, 0xb7, 0xda, 0xb5, 0x57, 0x38, 0x94, 0x17, 0x9b, 0x93, 0xfa },
    134 /* Bin Number */
  },
  {
    /* Buypass Class 3 Root CA */
    { 0xed, 0xf7, 0xeb, 0xbc, 0xa2, 0x7a, 0x2a, 0x38, 0x4d, 0x38, 0x7b, 0x7d, 0x40, 0x10, 0xc6, 0x66,
      0xe2, 0xed, 0xb4, 0x84, 0x3e, 0x4c, 0x29, 0xb4, 0xae, 0x1d, 0x5b, 0x93, 0x32, 0xe6, 0xb2, 0x4d },
    135 /* Bin Number */
  },
  {
    /* D-TRUST Root Class 3 CA 2 EV 2009 */
    { 0xee, 0xc5, 0x49, 0x6b, 0x98, 0x8c, 0xe9, 0x86, 0x25, 0xb9, 0x34, 0x09, 0x2e, 0xec, 0x29, 0x08,
      0xbe, 0xd0, 0xb0, 0xf3, 0x16, 0xc2, 0xd4, 0x73, 0x0c, 0x84, 0xea, 0xf1, 0xf3, 0xd3, 0x48, 0x81 },
    136 /* Bin Number */
  },
  {
    /* OISTE Server Root ECC G1 */
    { 0xee, 0xc9, 0x97, 0xc0, 0xc3, 0x0f, 0x21, 0x6f, 0x7e, 0x3b, 0x8b, 0x30, 0x7d, 0x2b, 0xae, 0x42,
      0x41, 0x2d, 0x75, 0x3f, 0xc8, 0x21, 0x9d, 0xaf, 0xd1, 0x52, 0x0b, 0x25, 0x72, 0x85, 0x0f, 0x49 },
    151 /* Bin Number */
  },
  {
    /* Telekom Security TLS RSA Root 2023 */
    { 0xef, 0xc6, 0x5c, 0xad, 0xbb, 0x59, 0xad, 0xb6, 0xef, 0xe8, 0x4d, 0xa2, 0x23, 0x11, 0xb3, 0x56,
      0x24, 0xb7, 0x1b, 0x3b, 0x1e, 0xa0, 0xda, 0x8b, 0x66, 0x55, 0x17, 0x4e, 0xc8, 0x97, 0x86, 0x46 },
    137 /* Bin Number */
  },
  {
    /* HiPKI Root CA - G1 */
    { 0xf0, 0x15, 0xce, 0x3c, 0xc2, 0x39, 0xbf, 0xef, 0x06, 0x4b, 0xe9, 0xf1, 0xd2, 0xc4, 0x17, 0xe1,
      0xa0, 0x26, 0x4a, 0x0a, 0x94, 0xbe, 0x1f, 0x0c, 0x8d, 0x12, 0x18, 0x64, 0xeb, 0x69, 0x49, 0xcc },
    138 /* Bin Number */
  },
  {
    /* SecureTrust CA */
    { 0xf1, 0xc1, 0xb5, 0x0a, 0xe5, 0xa2, 0x0d, 0xd8, 0x03, 0x0e, 0xc9, 0xf6, 0xbc, 0x24, 0x82, 0x3d,
      0xd3, 0x67, 0xb5, 0x25, 0x57, 0x59, 0xb4, 0xe7, 0x1b, 0x61, 0xfc, 0xe9, 0xf7, 0x37, 0x5d, 0x73 },
    139 /* Bin Number */
  },
  {
    /* Atos TrustedRoot 2011 */
    { 0xf3, 0x56, 0xbe, 0xa2, 0x44, 0xb7, 0xa9, 0x1e, 0xb3, 0x5d, 0x53, 0xca, 0x9a, 0xd7, 0x86, 0x4a,
      0xce, 0x01, 0x8e, 0x2d, 0x35, 0xd5, 0xf8, 0xf9, 0x6d, 0xdf, 0x68, 0xa6, 0xf4, 0x1a, 0xa4, 0x74 },
    140 /* Bin Number */
  },
  {
    /* BJCA Global Root CA1 */
    { 0xf3, 0x89, 0x6f, 0x88, 0xfe, 0x7c, 0x0a, 0x88, 0x27, 0x66, 0xa7, 0xfa, 0x6a, 0xd2, 0x74, 0x9f,
      0xb5, 0x7a, 0x7f, 0x3e, 0x98, 0xfb, 0x76, 0x9c, 0x1f, 0xa7, 0xb0, 0x9c, 0x2c, 0x44, 0xd5, 0xae },
    141 /* Bin Number */
  },
  {
    /* ANF Secure Server Root CA */
    { 0xfb, 0x8f, 0xec, 0x75, 0x91, 0x69, 0xb9, 0x10, 0x6b, 0x1e, 0x51, 0x16, 0x44, 0xc6, 0x18, 0xc5,
      0x13, 0x04, 0x37, 0x3f, 0x6c, 0x06, 0x43, 0x08, 0x8d, 0x8b, 0xef, 0xfd, 0x1b, 0x99, 0x75, 0x99 },
    142 /* Bin Number */
  },
  {
    /* T-TeleSec GlobalRoot Class 3 */
    { 0xfd, 0x73, 0xda, 0xd3, 0x1c, 0x64, 0x4f, 0xf1, 0xb4, 0x3b, 0xef, 0x0c, 0xcd, 0xda, 0x96, 0x71,
      0x0b, 0x9c, 0xd9, 0x87, 0x5e, 0xca, 0x7e, 0x31, 0x70, 0x7a, 0xf3, 0xe9, 0x6d, 0x52, 0x2b, 0xbd },
    143 /* Bin Number */
  },
  {
    /* Certum Trusted Root CA */
    { 0xfe, 0x76, 0x96, 0x57, 0x38, 0x55, 0x77, 0x3e, 0x37, 0xa9, 0x5e, 0x7a, 0xd4, 0xd9, 0xcc, 0x96,
      0xc3, 0x01, 0x57, 0xc1, 0x5d, 0x31, 0x76, 0x5b, 0xa9, 0xb1, 0x57, 0x04, 0xe1, 0xae, 0x78, 0xfd },
    144 /* Bin Number */
  },
};
