//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PWebTransportParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/WebTransportParent.h"
#include "mozilla/ipc/DataPipe.h"
#include "mozilla/ipc/IPCCore.h"


#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PWebTransportParent::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PWebTransportParent::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PWebTransportParent::PWebTransportParent() :
    mozilla::ipc::IToplevelProtocol("PWebTransportParent", kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PWebTransportParent);
}

PWebTransportParent::~PWebTransportParent()
{
    MOZ_COUNT_DTOR(PWebTransportParent);
}

auto PWebTransportParent::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess(), "Invalid process for `PWebTransportParent'");
    AddRef();
}

auto PWebTransportParent::ActorDealloc() -> void
{
    Release();
}

auto PWebTransportParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PWebTransportParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PWebTransportParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PWebTransportParent::SendIncomingUnidirectionalStream(
        const uint64_t& streamId,
        DataPipeReceiver* receive) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebTransport::Msg_IncomingUnidirectionalStream(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), streamId);
    // Sentinel = 'streamId'
    ((&(writer__)))->WriteSentinel(254935866);
    IPC::WriteParam((&(writer__)), receive);
    // Sentinel = 'receive'
    ((&(writer__)))->WriteSentinel(194118372);


    if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebTransportParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebTransport::Msg_IncomingUnidirectionalStream", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebTransportParent::SendIncomingBidirectionalStream(
        const uint64_t& streamId,
        DataPipeReceiver* receive,
        DataPipeSender* send) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebTransport::Msg_IncomingBidirectionalStream(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), streamId);
    // Sentinel = 'streamId'
    ((&(writer__)))->WriteSentinel(254935866);
    IPC::WriteParam((&(writer__)), receive);
    // Sentinel = 'receive'
    ((&(writer__)))->WriteSentinel(194118372);
    IPC::WriteParam((&(writer__)), send);
    // Sentinel = 'send'
    ((&(writer__)))->WriteSentinel(71238059);


    if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebTransportParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebTransport::Msg_IncomingBidirectionalStream", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebTransportParent::SendIncomingDatagram(
        mozilla::Span<uint8_t const> data,
        const TimeStamp& receivedTime) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebTransport::Msg_IncomingDatagram(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), data);
    // Sentinel = 'data'
    ((&(writer__)))->WriteSentinel(67109275);
    IPC::WriteParam((&(writer__)), receivedTime);
    // Sentinel = 'receivedTime'
    ((&(writer__)))->WriteSentinel(532939991);


    if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebTransportParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebTransport::Msg_IncomingDatagram", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebTransportParent::SendRemoteClosed(
        const bool& cleanly,
        const uint32_t& code,
        const nsACString& reason) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebTransport::Msg_RemoteClosed(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), cleanly);
    // Sentinel = 'cleanly'
    ((&(writer__)))->WriteSentinel(190579433);
    IPC::WriteParam((&(writer__)), code);
    // Sentinel = 'code'
    ((&(writer__)))->WriteSentinel(67764636);
    IPC::WriteParam((&(writer__)), reason);
    // Sentinel = 'reason'
    ((&(writer__)))->WriteSentinel(148112009);


    if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebTransportParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebTransport::Msg_RemoteClosed", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebTransportParent::SendOnStreamResetOrStopSending(
        const uint64_t& streamId,
        const StreamResetOrStopSendingError& error) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebTransport::Msg_OnStreamResetOrStopSending(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), streamId);
    // Sentinel = 'streamId'
    ((&(writer__)))->WriteSentinel(254935866);
    IPC::WriteParam((&(writer__)), error);
    // Sentinel = 'error'
    ((&(writer__)))->WriteSentinel(107741739);


    if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebTransportParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebTransport::Msg_OnStreamResetOrStopSending", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebTransportParent::SendCloseAll(
        mozilla::ipc::ResolveCallback<nsresult>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PWebTransport::Msg_CloseAll(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebTransportParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebTransport::Msg_CloseAll", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PWebTransport::Reply_CloseAll__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__rv = IPC::ReadParam<nsresult>(aReader);
            if (!maybe__rv) {
                (aReader)->FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& rv = *maybe__rv;
            // Sentinel = 'rv'
            if ((!((aReader)->ReadSentinel(22806761)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(rv));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PWebTransportParent::SendCloseAll() -> RefPtr<CloseAllPromise>
{
    RefPtr<MozPromise<nsresult, ResponseRejectReason, true>::Private> promise__ = new MozPromise<nsresult, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendCloseAll([promise__](nsresult&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PWebTransportParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PWebTransportParent::OnMessageReceived(const Message& msg__) -> PWebTransportParent::Result
{
    switch (msg__.type()) {
    case PWebTransport::Msg_Close__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebTransport::Msg_Close", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__code = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__code) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& code = *maybe__code;
            // Sentinel = 'code'
            if ((!(((&(reader__)))->ReadSentinel(67764636)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__reason = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__reason) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& reason = *maybe__reason;
            // Sentinel = 'reason'
            if ((!(((&(reader__)))->ReadSentinel(148112009)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebTransportParent*>(this))->RecvClose(std::move(code), std::move(reason));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebTransport::Msg_CreateUnidirectionalStream__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebTransport::Msg_CreateUnidirectionalStream", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__sendOrder = IPC::ReadParam<mozilla::Maybe<int64_t>>((&(reader__)));
            if (!maybe__sendOrder) {
                FatalError("Error deserializing 'int64_t?'");
                return MsgValueError;

            }
            auto& sendOrder = *maybe__sendOrder;
            // Sentinel = 'sendOrder'
            if ((!(((&(reader__)))->ReadSentinel(307299239)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t?'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PWebTransport::Reply_CreateUnidirectionalStream(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            CreateUnidirectionalStreamResolver resolver = [resolver__ = std::move(resolver__)](const UnidirectionalStreamResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebTransportParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebTransportParent*>(this))->RecvCreateUnidirectionalStream(std::move(sendOrder), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebTransport::Msg_CreateBidirectionalStream__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebTransport::Msg_CreateBidirectionalStream", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__sendOrder = IPC::ReadParam<mozilla::Maybe<int64_t>>((&(reader__)));
            if (!maybe__sendOrder) {
                FatalError("Error deserializing 'int64_t?'");
                return MsgValueError;

            }
            auto& sendOrder = *maybe__sendOrder;
            // Sentinel = 'sendOrder'
            if ((!(((&(reader__)))->ReadSentinel(307299239)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t?'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PWebTransport::Reply_CreateBidirectionalStream(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            CreateBidirectionalStreamResolver resolver = [resolver__ = std::move(resolver__)](const BidirectionalStreamResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebTransportParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebTransportParent*>(this))->RecvCreateBidirectionalStream(std::move(sendOrder), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebTransport::Msg_OutgoingDatagram__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebTransport::Msg_OutgoingDatagram", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__data = IPC::ReadParam<nsTArray<uint8_t>>((&(reader__)));
            if (!maybe__data) {
                FatalError("Error deserializing 'uint8_t[]'");
                return MsgValueError;

            }
            auto& data = *maybe__data;
            // Sentinel = 'data'
            if ((!(((&(reader__)))->ReadSentinel(67109275)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t[]'");
                return MsgValueError;
            }
            auto maybe__expirationTime = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__expirationTime) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& expirationTime = *maybe__expirationTime;
            // Sentinel = 'expirationTime'
            if ((!(((&(reader__)))->ReadSentinel(743769555)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PWebTransport::Reply_OutgoingDatagram(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            OutgoingDatagramResolver resolver = [resolver__ = std::move(resolver__)](const nsresult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebTransportParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebTransportParent*>(this))->RecvOutgoingDatagram(std::move(data), std::move(expirationTime), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebTransport::Msg_GetMaxDatagramSize__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebTransport::Msg_GetMaxDatagramSize", OTHER);

            mozilla::ipc::ActorId id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PWebTransport::Reply_GetMaxDatagramSize(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetMaxDatagramSizeResolver resolver = [resolver__ = std::move(resolver__)](const uint64_t& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'maxDatagramSize'
                    ((&(writer__)))->WriteSentinel(801179139);

                    if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebTransportParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebTransportParent*>(this))->RecvGetMaxDatagramSize(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebTransport::Msg_GetHttpChannelID__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebTransport::Msg_GetHttpChannelID", OTHER);

            mozilla::ipc::ActorId id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PWebTransport::Reply_GetHttpChannelID(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetHttpChannelIDResolver resolver = [resolver__ = std::move(resolver__)](const uint64_t& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'httpChannelID'
                    ((&(writer__)))->WriteSentinel(617284871);

                    if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebTransportParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebTransportParent*>(this))->RecvGetHttpChannelID(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebTransport::Msg_SetSendOrder__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebTransport::Msg_SetSendOrder", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__streamId = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__streamId) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& streamId = *maybe__streamId;
            // Sentinel = 'streamId'
            if ((!(((&(reader__)))->ReadSentinel(254935866)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__sendOrder = IPC::ReadParam<mozilla::Maybe<int64_t>>((&(reader__)));
            if (!maybe__sendOrder) {
                FatalError("Error deserializing 'int64_t?'");
                return MsgValueError;

            }
            auto& sendOrder = *maybe__sendOrder;
            // Sentinel = 'sendOrder'
            if ((!(((&(reader__)))->ReadSentinel(307299239)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t?'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebTransportParent*>(this))->RecvSetSendOrder(std::move(streamId), std::move(sendOrder));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebTransport::Reply_CloseAll__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PWebTransport::Msg_CloseAll", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PWebTransportParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PWebTransportParent::Result
{
    MOZ_ASSERT_UNREACHABLE("message protocol not supported");
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PWebTransportParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PWebTransport'
    (aWriter)->WriteSentinel(582944060);
}

auto ParamTraits<::mozilla::dom::PWebTransportParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PWebTransport actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PWebTransport'
    if ((!((aReader)->ReadSentinel(582944060)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PWebTransport actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PWebTransportMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PWebTransport)");

        return {};
    }
    return static_cast<::mozilla::dom::PWebTransportParent*>(actor);
}

} // namespace IPC
