//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/gmp/PGMPContentParent.h"
#include "GMPContentChild.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/gmp/PGMPVideoDecoderParent.h"
#include "mozilla/gmp/PGMPVideoEncoderParent.h"
#include "mozilla/gmp/PChromiumCDMParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace gmp {


auto PGMPContentParent::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PGMPContentParent::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PGMPContentParent::PGMPContentParent() :
    mozilla::ipc::IToplevelProtocol("PGMPContentParent", kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PGMPContentParent);
}

PGMPContentParent::~PGMPContentParent()
{
    MOZ_COUNT_DTOR(PGMPContentParent);
}

auto PGMPContentParent::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess() || XRE_IsContentProcess(), "Invalid process for `PGMPContentParent'");
    AddRef();
}

auto PGMPContentParent::ActorDealloc() -> void
{
    Release();
}

auto PGMPContentParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PGMPContentParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PGMPContentParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PGMPContentParent::ManagedPGMPVideoDecoderParent(nsTArray<PGMPVideoDecoderParent*>& aArr) const -> void
{
    mManagedPGMPVideoDecoderParent.ToArray(aArr);
}

auto PGMPContentParent::ManagedPGMPVideoDecoderParent() const -> const ManagedContainer<PGMPVideoDecoderParent>&
{
    return mManagedPGMPVideoDecoderParent;
}

auto PGMPContentParent::ManagedPGMPVideoEncoderParent(nsTArray<PGMPVideoEncoderParent*>& aArr) const -> void
{
    mManagedPGMPVideoEncoderParent.ToArray(aArr);
}

auto PGMPContentParent::ManagedPGMPVideoEncoderParent() const -> const ManagedContainer<PGMPVideoEncoderParent>&
{
    return mManagedPGMPVideoEncoderParent;
}

auto PGMPContentParent::ManagedPChromiumCDMParent(nsTArray<PChromiumCDMParent*>& aArr) const -> void
{
    mManagedPChromiumCDMParent.ToArray(aArr);
}

auto PGMPContentParent::ManagedPChromiumCDMParent() const -> const ManagedContainer<PChromiumCDMParent>&
{
    return mManagedPChromiumCDMParent;
}

auto PGMPContentParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PGMPVideoDecoderMsgStart,
        PGMPVideoEncoderMsgStart,
        PChromiumCDMMsgStart
    };
    return sIds;
}

auto PGMPContentParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PGMPVideoDecoderMsgStart:
        return (&(mManagedPGMPVideoDecoderParent));
    case PGMPVideoEncoderMsgStart:
        return (&(mManagedPGMPVideoEncoderParent));
    case PChromiumCDMMsgStart:
        return (&(mManagedPChromiumCDMParent));
    default:
        return nullptr;
    }
}

auto PGMPContentParent::OpenPGMPVideoDecoderEndpoint(PGMPVideoDecoderParent* aActor) -> ManagedEndpoint<PGMPVideoDecoderChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PGMPVideoDecoderParent actor");
        return ManagedEndpoint<PGMPVideoDecoderChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PGMPVideoDecoderParent actor");
        return ManagedEndpoint<PGMPVideoDecoderChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PGMPVideoDecoderChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PGMPContentParent::BindPGMPVideoDecoderEndpoint(
        ManagedEndpoint<PGMPVideoDecoderParent> aEndpoint,
        PGMPVideoDecoderParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PGMPContentParent::OpenPGMPVideoEncoderEndpoint(PGMPVideoEncoderParent* aActor) -> ManagedEndpoint<PGMPVideoEncoderChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PGMPVideoEncoderParent actor");
        return ManagedEndpoint<PGMPVideoEncoderChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PGMPVideoEncoderParent actor");
        return ManagedEndpoint<PGMPVideoEncoderChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PGMPVideoEncoderChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PGMPContentParent::BindPGMPVideoEncoderEndpoint(
        ManagedEndpoint<PGMPVideoEncoderParent> aEndpoint,
        PGMPVideoEncoderParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PGMPContentParent::OpenPChromiumCDMEndpoint(PChromiumCDMParent* aActor) -> ManagedEndpoint<PChromiumCDMChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PChromiumCDMParent actor");
        return ManagedEndpoint<PChromiumCDMChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PChromiumCDMParent actor");
        return ManagedEndpoint<PChromiumCDMChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PChromiumCDMChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PGMPContentParent::BindPChromiumCDMEndpoint(
        ManagedEndpoint<PChromiumCDMParent> aEndpoint,
        PChromiumCDMParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PGMPContentParent::SendPGMPVideoDecoderConstructor(PGMPVideoDecoderParent* actor) -> PGMPVideoDecoderParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PGMPVideoDecoderParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PGMPVideoDecoderParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PGMPContent::Msg_PGMPVideoDecoderConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PGMPContent", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPContentParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMPContent::Msg_PGMPVideoDecoderConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PGMPVideoDecoderParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PGMPContentParent::SendPGMPVideoEncoderConstructor(PGMPVideoEncoderParent* actor) -> PGMPVideoEncoderParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PGMPVideoEncoderParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PGMPVideoEncoderParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PGMPContent::Msg_PGMPVideoEncoderConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PGMPContent", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPContentParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMPContent::Msg_PGMPVideoEncoderConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PGMPVideoEncoderParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PGMPContentParent::SendPChromiumCDMConstructor(
        PChromiumCDMParent* actor,
        const nsACString& aKeySystem) -> PChromiumCDMParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PChromiumCDMParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PChromiumCDMParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PGMPContent::Msg_PChromiumCDMConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), aKeySystem);
    // Sentinel = 'aKeySystem'
    ((&(writer__)))->WriteSentinel(362546192);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PGMPContent", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPContentParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMPContent::Msg_PChromiumCDMConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PChromiumCDMParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PGMPContentParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    default:
        FatalError("unreached");
        return;
    }
}

auto PGMPContentParent::OnMessageReceived(const Message& msg__) -> PGMPContentParent::Result
{
    IPC::Message::routeid_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PGMPContent", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPContentParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PGMPContent::Reply_PGMPVideoDecoderConstructor__ID:
        {
            return MsgProcessed;
        }
    case PGMPContent::Reply_PGMPVideoEncoderConstructor__ID:
        {
            return MsgProcessed;
        }
    case PGMPContent::Reply_PChromiumCDMConstructor__ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PGMPContentParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PGMPContentParent::Result
{
    IPC::Message::routeid_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            return MsgDropped;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__, reply__);
    }

    return MsgNotKnown;
}



} // namespace gmp
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::gmp::PGMPContentParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PGMPContent'
    (aWriter)->WriteSentinel(374998032);
}

auto ParamTraits<::mozilla::gmp::PGMPContentParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PGMPContent actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PGMPContent'
    if ((!((aReader)->ReadSentinel(374998032)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PGMPContent actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PGMPContentMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PGMPContent)");

        return {};
    }
    return static_cast<::mozilla::gmp::PGMPContentParent*>(actor);
}

} // namespace IPC
