//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/layers/PCanvasParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/layers/CanvasTranslator.h"
#include "mozilla/layers/LayersMessageUtils.h"

#include "mozilla/gfx/PCanvasManagerParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace layers {


auto PCanvasParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PCanvasParent::PCanvasParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PCanvasParent);
}

PCanvasParent::~PCanvasParent()
{
    MOZ_COUNT_DTOR(PCanvasParent);
}

auto PCanvasParent::ActorAlloc() -> void
{
    AddRef();
}

auto PCanvasParent::ActorDealloc() -> void
{
    Release();
}

auto PCanvasParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCanvasParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCanvasParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCanvasParent::Manager() const -> PCanvasManagerParent*
{
    return static_cast<PCanvasManagerParent*>(IProtocol::Manager());
}

auto PCanvasParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PCanvasParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PCanvasParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PCanvasParent::SendNotifyDeviceReset(mozilla::Span<RemoteTextureOwnerId const> aOwners) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCanvas::Msg_NotifyDeviceReset(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aOwners);
    // Sentinel = 'aOwners'
    ((&(writer__)))->WriteSentinel(186188512);


    if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvas::Msg_NotifyDeviceReset", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCanvasParent::SendDeactivate() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCanvas::Msg_Deactivate(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvas::Msg_Deactivate", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCanvasParent::SendBlockCanvas() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCanvas::Msg_BlockCanvas(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvas::Msg_BlockCanvas", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCanvasParent::SendNotifyRequiresRefresh(const RemoteTextureOwnerId& aTextureOwnerId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCanvas::Msg_NotifyRequiresRefresh(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aTextureOwnerId);
    // Sentinel = 'aTextureOwnerId'
    ((&(writer__)))->WriteSentinel(818415115);


    if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvas::Msg_NotifyRequiresRefresh", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCanvasParent::SendSnapshotShmem(
        const RemoteTextureOwnerId& aTextureOwnerId,
        ReadOnlySharedMemoryHandle&& aShmemHandle,
        mozilla::ipc::ResolveCallback<bool>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PCanvas::Msg_SnapshotShmem(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aTextureOwnerId);
    // Sentinel = 'aTextureOwnerId'
    ((&(writer__)))->WriteSentinel(818415115);
    IPC::WriteParam((&(writer__)), std::move(aShmemHandle));
    // Sentinel = 'aShmemHandle'
    ((&(writer__)))->WriteSentinel(501679272);


    if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvas::Msg_SnapshotShmem", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PCanvas::Reply_SnapshotShmem__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__aSuccess = IPC::ReadParam<bool>(aReader);
            if (!maybe__aSuccess) {
                (aReader)->FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aSuccess = *maybe__aSuccess;
            // Sentinel = 'aSuccess'
            if ((!((aReader)->ReadSentinel(236323643)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(aSuccess));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PCanvasParent::SendSnapshotShmem(
        const RemoteTextureOwnerId& aTextureOwnerId,
        ReadOnlySharedMemoryHandle&& aShmemHandle) -> RefPtr<SnapshotShmemPromise>
{
    RefPtr<MozPromise<bool, ResponseRejectReason, true>::Private> promise__ = new MozPromise<bool, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendSnapshotShmem(std::move(aTextureOwnerId), std::move(aShmemHandle), [promise__](bool&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PCanvasParent::SendNotifyTextureDestruction(const RemoteTextureOwnerId& aTextureOwnerId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCanvas::Msg_NotifyTextureDestruction(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aTextureOwnerId);
    // Sentinel = 'aTextureOwnerId'
    ((&(writer__)))->WriteSentinel(818415115);


    if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvas::Msg_NotifyTextureDestruction", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCanvasParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PCanvasParent::OnMessageReceived(const Message& msg__) -> PCanvasParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PCanvas::Msg_InitTranslator__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg_InitTranslator", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aTextureType = IPC::ReadParam<TextureType>((&(reader__)));
            if (!maybe__aTextureType) {
                FatalError("Error deserializing 'TextureType'");
                return MsgValueError;

            }
            auto& aTextureType = *maybe__aTextureType;
            // Sentinel = 'aTextureType'
            if ((!(((&(reader__)))->ReadSentinel(534119669)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TextureType'");
                return MsgValueError;
            }
            auto maybe__aWebglTextureType = IPC::ReadParam<TextureType>((&(reader__)));
            if (!maybe__aWebglTextureType) {
                FatalError("Error deserializing 'TextureType'");
                return MsgValueError;

            }
            auto& aWebglTextureType = *maybe__aWebglTextureType;
            // Sentinel = 'aWebglTextureType'
            if ((!(((&(reader__)))->ReadSentinel(1019348710)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TextureType'");
                return MsgValueError;
            }
            auto maybe__aBackendType = IPC::ReadParam<BackendType>((&(reader__)));
            if (!maybe__aBackendType) {
                FatalError("Error deserializing 'BackendType'");
                return MsgValueError;

            }
            auto& aBackendType = *maybe__aBackendType;
            // Sentinel = 'aBackendType'
            if ((!(((&(reader__)))->ReadSentinel(492176556)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BackendType'");
                return MsgValueError;
            }
            auto maybe__aHeaderHandle = IPC::ReadParam<MutableSharedMemoryHandle>((&(reader__)));
            if (!maybe__aHeaderHandle) {
                FatalError("Error deserializing 'MutableSharedMemoryHandle'");
                return MsgValueError;

            }
            auto& aHeaderHandle = *maybe__aHeaderHandle;
            // Sentinel = 'aHeaderHandle'
            if ((!(((&(reader__)))->ReadSentinel(570098935)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MutableSharedMemoryHandle'");
                return MsgValueError;
            }
            auto maybe__aBufferHandles = IPC::ReadParam<nsTArray<ReadOnlySharedMemoryHandle>>((&(reader__)));
            if (!maybe__aBufferHandles) {
                FatalError("Error deserializing 'ReadOnlySharedMemoryHandle[]'");
                return MsgValueError;

            }
            auto& aBufferHandles = *maybe__aBufferHandles;
            // Sentinel = 'aBufferHandles'
            if ((!(((&(reader__)))->ReadSentinel(673318267)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ReadOnlySharedMemoryHandle[]'");
                return MsgValueError;
            }
            auto maybe__aReaderSem = IPC::ReadParam<CrossProcessSemaphoreHandle>((&(reader__)));
            if (!maybe__aReaderSem) {
                FatalError("Error deserializing 'CrossProcessSemaphoreHandle'");
                return MsgValueError;

            }
            auto& aReaderSem = *maybe__aReaderSem;
            // Sentinel = 'aReaderSem'
            if ((!(((&(reader__)))->ReadSentinel(349045722)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CrossProcessSemaphoreHandle'");
                return MsgValueError;
            }
            auto maybe__aWriterSem = IPC::ReadParam<CrossProcessSemaphoreHandle>((&(reader__)));
            if (!maybe__aWriterSem) {
                FatalError("Error deserializing 'CrossProcessSemaphoreHandle'");
                return MsgValueError;

            }
            auto& aWriterSem = *maybe__aWriterSem;
            // Sentinel = 'aWriterSem'
            if ((!(((&(reader__)))->ReadSentinel(368772100)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CrossProcessSemaphoreHandle'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CanvasTranslator*>(this))->RecvInitTranslator(std::move(aTextureType), std::move(aWebglTextureType), std::move(aBackendType), std::move(aHeaderHandle), std::move(aBufferHandles), std::move(aReaderSem), std::move(aWriterSem));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvas::Msg_RestartTranslation__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg_RestartTranslation", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CanvasTranslator*>(this))->RecvRestartTranslation();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvas::Msg_AddBuffer__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg_AddBuffer", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aBufferHandle = IPC::ReadParam<ReadOnlySharedMemoryHandle>((&(reader__)));
            if (!maybe__aBufferHandle) {
                FatalError("Error deserializing 'ReadOnlySharedMemoryHandle'");
                return MsgValueError;

            }
            auto& aBufferHandle = *maybe__aBufferHandle;
            // Sentinel = 'aBufferHandle'
            if ((!(((&(reader__)))->ReadSentinel(581371144)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ReadOnlySharedMemoryHandle'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CanvasTranslator*>(this))->RecvAddBuffer(std::move(aBufferHandle));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvas::Msg_SetDataSurfaceBuffer__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg_SetDataSurfaceBuffer", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aId = *maybe__aId;
            // Sentinel = 'aId'
            if ((!(((&(reader__)))->ReadSentinel(35389711)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aBufferHandle = IPC::ReadParam<MutableSharedMemoryHandle>((&(reader__)));
            if (!maybe__aBufferHandle) {
                FatalError("Error deserializing 'MutableSharedMemoryHandle'");
                return MsgValueError;

            }
            auto& aBufferHandle = *maybe__aBufferHandle;
            // Sentinel = 'aBufferHandle'
            if ((!(((&(reader__)))->ReadSentinel(581371144)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MutableSharedMemoryHandle'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CanvasTranslator*>(this))->RecvSetDataSurfaceBuffer(std::move(aId), std::move(aBufferHandle));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvas::Msg_ClearCachedResources__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg_ClearCachedResources", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CanvasTranslator*>(this))->RecvClearCachedResources();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvas::Msg_DropFreeBuffersWhenDormant__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg_DropFreeBuffersWhenDormant", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CanvasTranslator*>(this))->RecvDropFreeBuffersWhenDormant();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvas::Msg_SnapshotExternalCanvas__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg_SnapshotExternalCanvas", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aSyncId = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aSyncId) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aSyncId = *maybe__aSyncId;
            // Sentinel = 'aSyncId'
            if ((!(((&(reader__)))->ReadSentinel(181666476)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aManagerId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aManagerId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aManagerId = *maybe__aManagerId;
            // Sentinel = 'aManagerId'
            if ((!(((&(reader__)))->ReadSentinel(347866058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aCanvasId = IPC::ReadParam<ActorId>((&(reader__)));
            if (!maybe__aCanvasId) {
                FatalError("Error deserializing 'ActorId'");
                return MsgValueError;

            }
            auto& aCanvasId = *maybe__aCanvasId;
            // Sentinel = 'aCanvasId'
            if ((!(((&(reader__)))->ReadSentinel(283509611)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CanvasTranslator*>(this))->RecvSnapshotExternalCanvas(std::move(aSyncId), std::move(aManagerId), std::move(aCanvasId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvas::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CanvasTranslator*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PCanvas::Reply_SnapshotShmem__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PCanvas::Msg_SnapshotShmem", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    default:
        return MsgNotKnown;
    }
}

auto PCanvasParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCanvasParent::Result
{
    return MsgNotKnown;
}



} // namespace layers
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::layers::PCanvasParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PCanvas'
    (aWriter)->WriteSentinel(167576237);
}

auto ParamTraits<::mozilla::layers::PCanvasParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PCanvas actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PCanvas'
    if ((!((aReader)->ReadSentinel(167576237)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PCanvas actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PCanvasMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PCanvas)");

        return {};
    }
    return static_cast<::mozilla::layers::PCanvasParent*>(actor);
}

} // namespace IPC
