//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/indexedDB/PBackgroundIDBCursorParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/indexedDB/ActorsChild.h"
#include "mozilla/dom/indexedDB/Key.h"
#include "mozilla/dom/indexedDB/KeyPath.h"
#include "mozilla/dom/indexedDB/SerializationHelpers.h"
#include "mozilla/dom/quota/SerializationHelpers.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/dom/indexedDB/PBackgroundIDBTransactionParent.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBVersionChangeTransactionParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace indexedDB {


MOZ_IMPLICIT PBackgroundIDBCursorParent::PBackgroundIDBCursorParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PBackgroundIDBCursorParent);
}

PBackgroundIDBCursorParent::~PBackgroundIDBCursorParent()
{
    MOZ_COUNT_DTOR(PBackgroundIDBCursorParent);
}

auto PBackgroundIDBCursorParent::ActorAlloc() -> void
{
    AddRef();
}

auto PBackgroundIDBCursorParent::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundIDBCursorParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundIDBCursorParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundIDBCursorParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundIDBCursorParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PBackgroundIDBCursorParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PBackgroundIDBCursorParent::Send__delete__(PBackgroundIDBCursorParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBCursor::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBCursor", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBCursorParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBCursor::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PBackgroundIDBCursorParent::SendResponse(const CursorResponse& response) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBCursor::Msg_Response(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), response);
    // Sentinel = 'response'
    ((&(writer__)))->WriteSentinel(260965232);


    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBCursor", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBCursorParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBCursor::Msg_Response", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBCursorParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PBackgroundIDBCursorParent::OnMessageReceived(const Message& msg__) -> PBackgroundIDBCursorParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundIDBCursor::Msg_DeleteMe__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBCursor", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBCursorParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBCursor::Msg_DeleteMe", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteMe();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBCursor::Msg_Continue__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBCursor", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBCursorParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBCursor::Msg_Continue", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__requestId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__requestId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& requestId = *maybe__requestId;
            // Sentinel = 'requestId'
            if ((!(((&(reader__)))->ReadSentinel(320799671)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__params = IPC::ReadParam<CursorRequestParams>((&(reader__)));
            if (!maybe__params) {
                FatalError("Error deserializing 'CursorRequestParams'");
                return MsgValueError;

            }
            auto& params = *maybe__params;
            // Sentinel = 'params'
            if ((!(((&(reader__)))->ReadSentinel(146997893)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CursorRequestParams'");
                return MsgValueError;
            }
            auto maybe__currentKey = IPC::ReadParam<Key>((&(reader__)));
            if (!maybe__currentKey) {
                FatalError("Error deserializing 'Key'");
                return MsgValueError;

            }
            auto& currentKey = *maybe__currentKey;
            // Sentinel = 'currentKey'
            if ((!(((&(reader__)))->ReadSentinel(388695085)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Key'");
                return MsgValueError;
            }
            auto maybe__currentObjectStoreKey = IPC::ReadParam<Key>((&(reader__)));
            if (!maybe__currentObjectStoreKey) {
                FatalError("Error deserializing 'Key'");
                return MsgValueError;

            }
            auto& currentObjectStoreKey = *maybe__currentObjectStoreKey;
            // Sentinel = 'currentObjectStoreKey'
            if ((!(((&(reader__)))->ReadSentinel(1594886289)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Key'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvContinue(std::move(requestId), std::move(params), std::move(currentKey), std::move(currentObjectStoreKey));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBCursor::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundIDBCursorParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundIDBCursorParent::Result
{
    return MsgNotKnown;
}



} // namespace indexedDB
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBCursorParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PBackgroundIDBCursor'
    (aWriter)->WriteSentinel(1310721950);
}

auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBCursorParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PBackgroundIDBCursor actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PBackgroundIDBCursor'
    if ((!((aReader)->ReadSentinel(1310721950)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PBackgroundIDBCursor actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PBackgroundIDBCursorMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PBackgroundIDBCursor)");

        return {};
    }
    return static_cast<::mozilla::dom::indexedDB::PBackgroundIDBCursorParent*>(actor);
}

} // namespace IPC
