/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM PerformanceEntryEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "PerformanceEntryEvent.h"
#include "PerformanceEntryEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PerformanceEntryEvent.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


PerformanceEntryEvent::PerformanceEntryEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

PerformanceEntryEvent::~PerformanceEntryEvent()
{
}

PerformanceEntryEvent*
PerformanceEntryEvent::AsPerformanceEntryEvent()
{
  return this;
}

JSObject*
PerformanceEntryEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return PerformanceEntryEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<PerformanceEntryEvent>
PerformanceEntryEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const PerformanceEntryEventInit& aEventInitDict)
{
  RefPtr<PerformanceEntryEvent> e = new PerformanceEntryEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mName = aEventInitDict.mName;
  e->mEntryType = aEventInitDict.mEntryType;
  e->mStartTime = aEventInitDict.mStartTime;
  e->mDuration = aEventInitDict.mDuration;
  e->mEpoch = aEventInitDict.mEpoch;
  e->mOrigin = aEventInitDict.mOrigin;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<PerformanceEntryEvent>
PerformanceEntryEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const PerformanceEntryEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

void
PerformanceEntryEvent::GetName(nsString& aRetVal) const
{
  aRetVal = mName;
}

void
PerformanceEntryEvent::GetEntryType(nsString& aRetVal) const
{
  aRetVal = mEntryType;
}

double
PerformanceEntryEvent::StartTime() const
{
  return mStartTime;
}

double
PerformanceEntryEvent::Duration() const
{
  return mDuration;
}

double
PerformanceEntryEvent::Epoch() const
{
  return mEpoch;
}

void
PerformanceEntryEvent::GetOrigin(nsString& aRetVal) const
{
  aRetVal = mOrigin;
}


} // namespace mozilla::dom
