/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM PageSwapEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "PageSwapEvent.h"
#include "PageSwapEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/NavigationActivation.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PageSwapEvent.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ViewTransition.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(PageSwapEvent)

NS_IMPL_ADDREF_INHERITED(PageSwapEvent, Event)
NS_IMPL_RELEASE_INHERITED(PageSwapEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(PageSwapEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mActivation)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mViewTransition)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(PageSwapEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(PageSwapEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mActivation)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mViewTransition)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(PageSwapEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

PageSwapEvent::PageSwapEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

PageSwapEvent::~PageSwapEvent()
{
}

PageSwapEvent*
PageSwapEvent::AsPageSwapEvent()
{
  return this;
}

JSObject*
PageSwapEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return PageSwapEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<PageSwapEvent>
PageSwapEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const PageSwapEventInit& aEventInitDict)
{
  RefPtr<PageSwapEvent> e = new PageSwapEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mActivation = aEventInitDict.mActivation;
  e->mViewTransition = aEventInitDict.mViewTransition;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<PageSwapEvent>
PageSwapEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const PageSwapEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

NavigationActivation*
PageSwapEvent::GetActivation() const
{
  return mActivation;
}

ViewTransition*
PageSwapEvent::GetViewTransition() const
{
  return mViewTransition;
}


} // namespace mozilla::dom
