/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM MediaQueryListEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "MediaQueryListEvent.h"
#include "MediaQueryListEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/MediaQueryListEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


MediaQueryListEvent::MediaQueryListEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

MediaQueryListEvent::~MediaQueryListEvent()
{
}

MediaQueryListEvent*
MediaQueryListEvent::AsMediaQueryListEvent()
{
  return this;
}

JSObject*
MediaQueryListEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return MediaQueryListEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<MediaQueryListEvent>
MediaQueryListEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const MediaQueryListEventInit& aEventInitDict)
{
  RefPtr<MediaQueryListEvent> e = new MediaQueryListEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mMedia = aEventInitDict.mMedia;
  e->mMatches = aEventInitDict.mMatches;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<MediaQueryListEvent>
MediaQueryListEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const MediaQueryListEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

void
MediaQueryListEvent::GetMedia(nsCString& aRetVal) const
{
  aRetVal = mMedia;
}

bool
MediaQueryListEvent::Matches() const
{
  return mMatches;
}


} // namespace mozilla::dom
