/* THIS FILE IS AUTOGENERATED FROM L10nOverlays.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "L10nOverlaysBinding.h"
#include "LocalizationBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/Element.h"
#include "mozilla/dom/L10nOverlays.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



L10nOverlaysError::L10nOverlaysError()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
L10nOverlaysError::InitIds(JSContext* cx, L10nOverlaysErrorAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->translatedElementName_id.init(cx, "translatedElementName") ||
      !atomsCache->sourceElementName_id.init(cx, "sourceElementName") ||
      !atomsCache->l10nName_id.init(cx, "l10nName") ||
      !atomsCache->code_id.init(cx, "code")) {
    return false;
  }
  return true;
}

bool
L10nOverlaysError::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
L10nOverlaysError::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  L10nOverlaysErrorAtoms* atomsCache = GetAtomCache<L10nOverlaysErrorAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mCode.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int16_t const & currentValue = mCode.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->code_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mL10nName.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mL10nName.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->l10nName_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mSourceElementName.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mSourceElementName.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->sourceElementName_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTranslatedElementName.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mTranslatedElementName.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->translatedElementName_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
L10nOverlaysError::TraceDictionary(JSTracer* trc)
{
}

L10nOverlaysError&
L10nOverlaysError::operator=(const L10nOverlaysError& aOther)
{
  DictionaryBase::operator=(aOther);
  mCode.Reset();
  if (aOther.mCode.WasPassed()) {
    mCode.Construct(aOther.mCode.Value());
  }
  mL10nName.Reset();
  if (aOther.mL10nName.WasPassed()) {
    mL10nName.Construct(aOther.mL10nName.Value());
  }
  mSourceElementName.Reset();
  if (aOther.mSourceElementName.WasPassed()) {
    mSourceElementName.Construct(aOther.mSourceElementName.Value());
  }
  mTranslatedElementName.Reset();
  if (aOther.mTranslatedElementName.WasPassed()) {
    mTranslatedElementName.Construct(aOther.mTranslatedElementName.Value());
  }
  return *this;
}


namespace L10nOverlays_Binding {

MOZ_CAN_RUN_SCRIPT static bool
translateElement(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "L10nOverlays.translateElement");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "L10nOverlays", "translateElement", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "L10nOverlays.translateElement", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FastL10nMessage arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  Nullable<nsTArray<L10nOverlaysError>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::L10nOverlays::TranslateElement(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), result))>, "Should be returning void here");
  mozilla::dom::L10nOverlays::TranslateElement(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }

  uint32_t length = result.Value().Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!result.Value()[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_GLOBINIT static const JSFunctionSpec sStaticMethods_specs[] = {
  JS_FNSPEC("translateElement", translateElement, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sStaticMethods[] = {
  { nullptr, &sStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const ConstantSpec sConstants_specs[] = {
  { "ERROR_UNKNOWN", JS::Int32Value(1) },
  { "ERROR_FORBIDDEN_TYPE", JS::Int32Value(2) },
  { "ERROR_NAMED_ELEMENT_MISSING", JS::Int32Value(3) },
  { "ERROR_NAMED_ELEMENT_TYPE_MISMATCH", JS::Int32Value(4) },
  { "ERROR_TRANSLATED_ELEMENT_DISCONNECTED", JS::Int32Value(5) },
  { "ERROR_TRANSLATED_ELEMENT_DISALLOWED_DOM", JS::Int32Value(6) },
  { 0, JS::UndefinedValue() }
};


static const Prefable<const ConstantSpec> sConstants[] = {
  { nullptr, &sConstants_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(6 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[7];
static PropertyInfo sNativeProperties_propertyInfos[7];

static const NativePropertiesN<2> sNativeProperties = {
  true,  0 /* sStaticMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  true,  1 /* sConstants */,
  -1,
  7,
  sNativeProperties_sortedPropertyIndices,
  {
    { sStaticMethods, &sNativeProperties_propertyInfos[0] },
    { sConstants, &sNativeProperties_propertyInfos[1] }
  }
};
static_assert(7 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::_ID_Count,
  constructors::id::L10nOverlays,
  &DefaultXrayExpandoObjectClass
};

static const DOMIfaceAndProtoJSClass sNamespaceObjectClass = {
  {
    "L10nOverlays",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS,
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eNamespace,
  prototypes::id::_ID_Count,
  0,
  &sNativePropertyHooks,
  // This isn't strictly following the spec (see
  // https://console.spec.whatwg.org/#ref-for-dfn-namespace-object),
  // but should be ok for Xrays.
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return nsContentUtils::ThreadsafeIsSystemCaller(aCx);
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Rooted<JSObject*> constructorProto(aCx, JS::GetRealmObjectPrototype(aCx));
  if (!constructorProto) {
    return;
  }

  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::L10nOverlays);
  dom::CreateNamespaceObject(aCx, aGlobal, constructorProto,
                             sNamespaceObjectClass,
                             interfaceCache,
                             sNativeProperties.Upcast(),
                             nullptr,
                             "L10nOverlays",
                             ShouldExpose<L10nOverlays_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal));
}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::L10nOverlays,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace L10nOverlays_Binding



} // namespace mozilla::dom
