// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanNetwerkDnsMetrics_h
#define mozilla_GleanNetwerkDnsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace dns {
  /**
   * generated from dns.blocklist_count
   * The number of unusable addresses reported for each record
   * This metric was generated to correspond to the Legacy Telemetry linear histogram DNS_BLACKLIST_COUNT.
   */
  constexpr impl::CustomDistributionMetric blocklist_count(4267);

  /**
   * generated from dns.by_type_cleanup_age
   * DNS Cache Entry Age for by-type queries at Removal Time (minutes)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_BY_TYPE_CLEANUP_AGE.
   */
  constexpr impl::TimingDistributionMetric by_type_cleanup_age(4268);

  /**
   * generated from dns.by_type_failed_lookup_time
   * Time for a completed by-type resolution that has a negative answer (msec).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_BY_TYPE_FAILED_LOOKUP_TIME.
   */
  constexpr impl::TimingDistributionMetric by_type_failed_lookup_time(4269);

  /**
   * generated from dns.by_type_premature_eviction
   * DNS Cache Entry Age for by-type queries at Removal Time of non-expired entries (minutes)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_BY_TYPE_PREMATURE_EVICTION.
   */
  constexpr impl::TimingDistributionMetric by_type_premature_eviction(4270);

  /**
   * generated from dns.by_type_succeeded_lookup_time
   * Time for a completed by-type resolution that succeeded (msec).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_BY_TYPE_SUCCEEDED_LOOKUP_TIME.
   */
  constexpr impl::TimingDistributionMetric by_type_succeeded_lookup_time(4271);

  /**
   * generated from dns.cleanup_age
   * DNS Cache Entry Age at Removal Time (minutes)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_CLEANUP_AGE.
   */
  constexpr impl::TimingDistributionMetric cleanup_age(4272);

  /**
   * generated from dns.lookup_algorithm
   */
  enum class LookupAlgorithmLabel: uint16_t {
    eNativeonly = 0,
    eTrrrace = 1,
    eTrrfirst = 2,
    eTrronly = 3,
    eTrrshadow = 4,
    e__Other__,
  };
  /**
   * DNS: lookup algorithm
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram DNS_LOOKUP_ALGORITHM.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, LookupAlgorithmLabel> lookup_algorithm(4273);

  /**
   * generated from dns.lookup_disposition
   * DNS: lookup algorithm; Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram DNS_LOOKUP_DISPOSITION3.
   */
  constexpr impl::DualLabeledCounterMetric lookup_disposition(4274);

  /**
   * generated from dns.lookup_method
   * DNS Lookup Type (hit, renewal, negative-hit, literal, overflow, network-first, network-shared)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram DNS_LOOKUP_METHOD2.
   */
  constexpr impl::CustomDistributionMetric lookup_method(4275);

  /**
   * generated from dns.native_lookup_time
   * Time for a completed native name resolution (msec)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_NATIVE_LOOKUP_TIME.
   */
  constexpr impl::TimingDistributionMetric native_lookup_time(4276);

  /**
   * generated from dns.native_queuing
   * Time in resolve queue waiting to getaddrinfo (msec)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_NATIVE_QUEUING.
   */
  constexpr impl::TimingDistributionMetric native_queuing(4277);

  /**
   * generated from dns.premature_eviction
   * DNS Cache Entry Age at Removal Time of non-expired entries (minutes)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_PREMATURE_EVICTION.
   */
  constexpr impl::TimingDistributionMetric premature_eviction(4278);

  /**
   * generated from dns.trr_attempt_count
   * Number of times we attempted TRR for a successful lookup in TRR-first mode. Keyed by provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_ATTEMPT_COUNT.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_attempt_count(4279);

  /**
   * generated from dns.trr_blacklisted
   * DNS check for TRR was blocked by blacklist; Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram DNS_TRR_BLACKLISTED3.
   */
  constexpr impl::DualLabeledCounterMetric trr_blacklisted(4280);

  /**
   * generated from dns.trr_disabled
   * Resolve success rate when in TRR-first and called TRR-disabled (fall-back mode); Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram DNS_TRR_DISABLED3.
   */
  constexpr impl::DualLabeledCounterMetric trr_disabled(4281);

  /**
   * generated from dns.trr_first
   * TRR-first mode distribution. 0=Worked, 1=fell back fine after TRR fail, 2=native worked, 3=both failed; Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram DNS_TRR_FIRST4.
   */
  constexpr impl::DualLabeledCounterMetric trr_first(4282);

  /**
   * generated from dns.trr_http_version
   * HTTP version used by DoH endpoint
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram DNS_TRR_HTTP_VERSION2.
   */
  constexpr impl::DualLabeledCounterMetric trr_http_version(4283);

  /**
   * generated from dns.trr_lookup_time
   * Time for a completed TRR resolution (msec); Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_TRR_LOOKUP_TIME3.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> trr_lookup_time(4284);

  /**
   * generated from dns.trr_ns_verfified
   * TRR managed to verify NS entry; Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram DNS_TRR_NS_VERFIFIED3.
   */
  constexpr impl::DualLabeledCounterMetric trr_ns_verfified(4285);

  /**
   * generated from dns.trr_processing_time
   * Time from the last received byte of the response until we have notified the consumer with a DNS record (msec)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_TRR_PROCESSING_TIME.
   */
  constexpr impl::TimingDistributionMetric trr_processing_time(4286);

  /**
   * generated from dns.trr_relevant_skip_reason_native_failed
   * When in TRR-first mode, if TRR was skipped and native failed, it lists the reason we may have skipped TRR, keyed by the provider. Does not include requests that intentionally skip TRR.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_RELEVANT_SKIP_REASON_NATIVE_FAILED.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_relevant_skip_reason_native_failed(4287);

  /**
   * generated from dns.trr_relevant_skip_reason_native_success
   * When in TRR-first mode, if TRR was skipped and native succeeded, it lists the reason we may have skipped TRR, keyed by the provider. Does not include requests that intentionally skip TRR.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_RELEVANT_SKIP_REASON_NATIVE_SUCCESS.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_relevant_skip_reason_native_success(4288);

  /**
   * generated from dns.trr_relevant_skip_reason_trr_first
   * When in TRR-first mode, it lists the reason we may have skipped TRR, keyed by the provider. Does not include requests that intentionally skip TRR.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_RELEVANT_SKIP_REASON_TRR_FIRST.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_relevant_skip_reason_trr_first(4289);

  /**
   * generated from dns.trr_relevant_skip_reason_trr_first_type_rec
   * When in TRR-first mode, it lists the reason we may have skipped TRR for HTTPS RR, keyed by the provider. Does not include requests that intentionally skip TRR.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_RELEVANT_SKIP_REASON_TRR_FIRST_TYPE_REC.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_relevant_skip_reason_trr_first_type_rec(4290);

  /**
   * generated from dns.trr_skip_reason_native_failed
   * When in TRR-first mode, if TRR was skipped and native failed, it lists the reason we may have skipped TRR, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_NATIVE_FAILED.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_native_failed(4291);

  /**
   * generated from dns.trr_skip_reason_native_success
   * When in TRR-first mode, if TRR was skipped and native succeeded, it lists the reason we may have skipped TRR, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_NATIVE_SUCCESS.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_native_success(4292);

  /**
   * generated from dns.trr_skip_reason_retry_failed
   * When in TRR-first mode, if TRR failed once and retried unsuccessfully, it lists the reason for the first failure, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_RETRY_FAILED.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_retry_failed(4293);

  /**
   * generated from dns.trr_skip_reason_retry_success
   * When in TRR-first mode, if TRR failed once and was successfully retried, it lists the reason for the first failure, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_RETRY_SUCCESS.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_retry_success(4294);

  /**
   * generated from dns.trr_skip_reason_strict_mode
   * When in TRR-first mode, it lists the reason we may have skipped TRR. The key is like `<provider>|<skip reason of first attempt>` or just `<provider>` used when there was no second attempt.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_STRICT_MODE.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_strict_mode(4295);

  /**
   * generated from dns.trr_skip_reason_trr_first
   * When in TRR-first mode, it lists the reason we may have skipped TRR, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_TRR_FIRST2.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_trr_first(4296);

  /**
   * generated from dns.trr_success
   * How often TRR (Trusted Recursive Resolver) requests are fine, time-out or error. Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram DNS_TRR_SUCCESS3.
   */
  constexpr impl::DualLabeledCounterMetric trr_success(4297);
}

} // namespace mozilla::glean

#endif // mozilla_GleanNetwerkDnsMetrics_h
