// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanImageDecodersMetrics_h
#define mozilla_GleanImageDecodersMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace avif {
  /**
   * generated from avif.a1lx
   */
  enum class A1lxLabel: uint16_t {
    ePresent = 0,
    eAbsent = 1,
    e__Other__,
  };
  /**
   * AV1LayeredImageIndexingProperty (a1lx). (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, A1lxLabel> a1lx(4058);

  /**
   * generated from avif.a1op
   */
  enum class A1opLabel: uint16_t {
    ePresent = 0,
    eAbsent = 1,
    e__Other__,
  };
  /**
   * AVIF OperatingPointSelectorProperty (a1op). (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, A1opLabel> a1op(4059);

  /**
   * generated from avif.alpha
   */
  enum class AlphaLabel: uint16_t {
    eAbsent = 0,
    ePresent = 1,
    e__Other__,
  };
  /**
   * AVIF alpha plane. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, AlphaLabel> alpha(4060);

  /**
   * generated from avif.aom_decode_error
   */
  enum class AomDecodeErrorLabel: uint16_t {
    eError = 0,
    eMemError = 1,
    eAbiMismatch = 2,
    eIncapable = 3,
    eUnsupBitstream = 4,
    eUnsupFeature = 5,
    eCorruptFrame = 6,
    eInvalidParam = 7,
    e__Other__,
  };
  /**
   * Image-decode Error from AOM decoder (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, AomDecodeErrorLabel> aom_decode_error(4061);

  /**
   * generated from avif.bit_depth
   */
  enum class BitDepthLabel: uint16_t {
    eColor8 = 0,
    eColor10 = 1,
    eColor12 = 2,
    eColor16 = 3,
    eUnknown = 4,
    e__Other__,
  };
  /**
   * Bits per pixel of AVIF image. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, BitDepthLabel> bit_depth(4062);

  /**
   * generated from avif.cicp_cp
   */
  enum class CicpCpLabel: uint16_t {
    eReserved = 0,
    eBt709 = 1,
    eUnspecified = 2,
    eReserved3 = 3,
    eBt470m = 4,
    eBt470bg = 5,
    eBt601 = 6,
    eSmpte240 = 7,
    eGenericFilm = 8,
    eBt2020 = 9,
    eXyz = 10,
    eSmpte431 = 11,
    eSmpte432 = 12,
    eReserved13 = 13,
    eReserved14 = 14,
    eReserved15 = 15,
    eReserved16 = 16,
    eReserved17 = 17,
    eReserved18 = 18,
    eReserved19 = 19,
    eReserved20 = 20,
    eReserved21 = 21,
    eEbu3213 = 22,
    eReservedRest = 23,
    e__Other__,
  };
  /**
   * AVIF CICP colour primaries. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CicpCpLabel> cicp_cp(4063);

  /**
   * generated from avif.cicp_mc
   */
  enum class CicpMcLabel: uint16_t {
    eIdentity = 0,
    eBt709 = 1,
    eUnspecified = 2,
    eReserved = 3,
    eFcc = 4,
    eBt470bg = 5,
    eBt601 = 6,
    eSmpte240 = 7,
    eYcgco = 8,
    eBt2020Ncl = 9,
    eBt2020Cl = 10,
    eSmpte2085 = 11,
    eChromatNcl = 12,
    eChromatCl = 13,
    eIctcp = 14,
    eReservedRest = 15,
    e__Other__,
  };
  /**
   * AVIF CICP transfer characteristics. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CicpMcLabel> cicp_mc(4064);

  /**
   * generated from avif.cicp_tc
   */
  enum class CicpTcLabel: uint16_t {
    eReserved = 0,
    eBt709 = 1,
    eUnspecified = 2,
    eReserved3 = 3,
    eBt470m = 4,
    eBt470bg = 5,
    eBt601 = 6,
    eSmpte240 = 7,
    eLinear = 8,
    eLog100 = 9,
    eLog100Sqrt10 = 10,
    eIec61966 = 11,
    eBt1361 = 12,
    eSrgb = 13,
    eBt202010bit = 14,
    eBt202012bit = 15,
    eSmpte2084 = 16,
    eSmpte428 = 17,
    eHlg = 18,
    eReservedRest = 19,
    e__Other__,
  };
  /**
   * AVIF CICP transfer characteristics. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CicpTcLabel> cicp_tc(4065);

  /**
   * generated from avif.clap
   */
  enum class ClapLabel: uint16_t {
    ePresent = 0,
    eAbsent = 1,
    e__Other__,
  };
  /**
   * AVIF CleanApertureBox (clap). (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ClapLabel> clap(4066);

  /**
   * generated from avif.colr
   */
  enum class ColrLabel: uint16_t {
    eNclx = 0,
    eIcc = 1,
    eAbsent = 2,
    eBoth = 3,
    e__Other__,
  };
  /**
   * AVIF colour information type. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ColrLabel> colr(4067);

  /**
   * generated from avif.dav1d_get_picture_return_value
   */
  struct Dav1dGetPictureReturnValueExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Return value from dav1d_get_picture This event was generated to correspond to the Legacy Telemetry event avif.dav1d_get_picture#return_value.
   */
  constexpr impl::EventMetric<Dav1dGetPictureReturnValueExtra> dav1d_get_picture_return_value(4068);

  /**
   * generated from avif.decode_result
   */
  enum class DecodeResultLabel: uint16_t {
    eSuccess = 0,
    eParseError = 1,
    eNoPrimaryItem = 2,
    eDecodeError = 3,
    eSizeOverflow = 4,
    eOutOfMemory = 5,
    ePipeInitError = 6,
    eWriteBufferError = 7,
    eAlphaYSzMismatch = 8,
    eAlphaYBpcMismatch = 9,
    eIspeMismatch = 10,
    eRenderSizeMismatch = 11,
    eFrameSizeChanged = 12,
    eInvalidCicp = 13,
    eInvalidParseStatus = 14,
    eMissingBrand = 15,
    eFtypNotFirst = 16,
    eNoImage = 17,
    eMultipleMoov = 18,
    eNoMoov = 19,
    eLselNoEssential = 20,
    eA1opNoEssential = 21,
    eA1lxEssential = 22,
    eTxformNoEssential = 23,
    eImageItemType = 24,
    eItemTypeMissing = 25,
    eConstructionMethod = 26,
    eItemLocNotFound = 27,
    eNoItemDataBox = 28,
    eNoSamples = 29,
    eConvertycbcrFailure = 30,
    eUncategorized = 31,
    e__Other__,
  };
  /**
   * Decode result of AVIF image. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DecodeResultLabel> decode_result(4069);

  /**
   * generated from avif.decoder
   */
  enum class DecoderLabel: uint16_t {
    eDav1d = 0,
    eAom = 1,
    e__Other__,
  };
  /**
   * Decoder of AVIF image. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DecoderLabel> decoder(4070);

  /**
   * generated from avif.grid
   */
  enum class GridLabel: uint16_t {
    ePresent = 0,
    eAbsent = 1,
    e__Other__,
  };
  /**
   * AVIF AVIF grid-based image. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, GridLabel> grid(4071);

  /**
   * generated from avif.ipro
   */
  enum class IproLabel: uint16_t {
    ePresent = 0,
    eAbsent = 1,
    e__Other__,
  };
  /**
   * AVIF ItemProtectionBox (ipro). (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, IproLabel> ipro(4072);

  /**
   * generated from avif.ispe
   */
  enum class IspeLabel: uint16_t {
    eValid = 0,
    eAbsent = 1,
    eBitstreamMismatch = 2,
    e__Other__,
  };
  /**
   * AVIF spatial extents (image size). (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, IspeLabel> ispe(4073);

  /**
   * generated from avif.lsel
   */
  enum class LselLabel: uint16_t {
    ePresent = 0,
    eAbsent = 1,
    e__Other__,
  };
  /**
   * AVIF LayerSelectorProperty (lsel). (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, LselLabel> lsel(4074);

  /**
   * generated from avif.major_brand
   */
  enum class MajorBrandLabel: uint16_t {
    eAvif = 0,
    eAvis = 1,
    eOther = 2,
    e__Other__,
  };
  /**
   * AVIF major brand
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram AVIF_MAJOR_BRAND.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, MajorBrandLabel> major_brand(4075);

  /**
   * generated from avif.pasp
   */
  enum class PaspLabel: uint16_t {
    eAbsent = 0,
    eSquare = 1,
    eNonsquare = 2,
    eInvalid = 3,
    e__Other__,
  };
  /**
   * AVIF pixel aspect ratio. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, PaspLabel> pasp(4076);

  /**
   * generated from avif.pixi
   */
  enum class PixiLabel: uint16_t {
    eValid = 0,
    eAbsent = 1,
    eBitstreamMismatch = 2,
    e__Other__,
  };
  /**
   * AVIF pixel information (bits per channel). (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, PixiLabel> pixi(4077);

  /**
   * generated from avif.sequence
   */
  enum class SequenceLabel: uint16_t {
    ePresent = 0,
    eAbsent = 1,
    e__Other__,
  };
  /**
   * AVIF image sequence
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram AVIF_SEQUENCE.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SequenceLabel> sequence(4078);

  /**
   * generated from avif.yuv_color_space
   */
  enum class YuvColorSpaceLabel: uint16_t {
    eBt601 = 0,
    eBt709 = 1,
    eBt2020 = 2,
    eIdentity = 3,
    eUnknown = 4,
    e__Other__,
  };
  /**
   * YUV color space of AVIF image. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, YuvColorSpaceLabel> yuv_color_space(4079);
}

namespace image_decode {
  /**
   * generated from image_decode.chunks
   * Number of chunks per decode attempt
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram IMAGE_DECODE_CHUNKS.
   */
  constexpr impl::CustomDistributionMetric chunks(4080);

  /**
   * generated from image_decode.count
   * Decode count
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram IMAGE_DECODE_COUNT.
   */
  constexpr impl::CustomDistributionMetric count(4081);

  /**
   * generated from image_decode.on_draw_latency
   * Time from starting a decode to it showing up on the screen (us)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram IMAGE_DECODE_ON_DRAW_LATENCY.
   */
  constexpr impl::TimingDistributionMetric on_draw_latency(4082);

  /**
   * generated from image_decode.speed_avif
   * AVIF image decode speed (Kbytes/sec)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram IMAGE_DECODE_SPEED_AVIF.
   */
  constexpr impl::MemoryDistributionMetric speed_avif(4083);

  /**
   * generated from image_decode.speed_gif
   * GIF image decode speed (Kbytes/sec)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram IMAGE_DECODE_SPEED_GIF.
   */
  constexpr impl::MemoryDistributionMetric speed_gif(4084);

  /**
   * generated from image_decode.speed_jpeg
   * JPEG image decode speed (Kbytes/sec)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram IMAGE_DECODE_SPEED_JPEG.
   */
  constexpr impl::MemoryDistributionMetric speed_jpeg(4085);

  /**
   * generated from image_decode.speed_png
   * PNG image decode speed (Kbytes/sec)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram IMAGE_DECODE_SPEED_PNG.
   */
  constexpr impl::MemoryDistributionMetric speed_png(4086);

  /**
   * generated from image_decode.speed_webp
   * WebP image decode speed (Kbytes/sec)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram IMAGE_DECODE_SPEED_WEBP.
   */
  constexpr impl::MemoryDistributionMetric speed_webp(4087);

  /**
   * generated from image_decode.time
   * Time spent decoding an image (us)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram IMAGE_DECODE_TIME.
   */
  constexpr impl::TimingDistributionMetric time(4088);
}

} // namespace mozilla::glean

#endif // mozilla_GleanImageDecodersMetrics_h
