struct cs_svg_filter_common {
struct Samplers {
 sampler2D_impl sClipMask_impl;
 int sClipMask_slot;
 sampler2D_impl sColor0_impl;
 int sColor0_slot;
 sampler2D_impl sColor1_impl;
 int sColor1_slot;
 sampler2D_impl sGpuBufferF_impl;
 int sGpuBufferF_slot;
 isampler2D_impl sGpuBufferI_impl;
 int sGpuBufferI_slot;
 sampler2D_impl sPrimitiveHeadersF_impl;
 int sPrimitiveHeadersF_slot;
 isampler2D_impl sPrimitiveHeadersI_impl;
 int sPrimitiveHeadersI_slot;
 sampler2D_impl sRenderTasks_impl;
 int sRenderTasks_slot;
 sampler2D_impl sTransformPalette_impl;
 int sTransformPalette_slot;
 bool set_slot(int index, int value) {
  switch (index) {
  case 8:
   sClipMask_slot = value;
   return true;
  case 9:
   sColor0_slot = value;
   return true;
  case 10:
   sColor1_slot = value;
   return true;
  case 3:
   sGpuBufferF_slot = value;
   return true;
  case 4:
   sGpuBufferI_slot = value;
   return true;
  case 5:
   sPrimitiveHeadersF_slot = value;
   return true;
  case 6:
   sPrimitiveHeadersI_slot = value;
   return true;
  case 1:
   sRenderTasks_slot = value;
   return true;
  case 2:
   sTransformPalette_slot = value;
   return true;
  }
  return false;
 }
} samplers;
struct AttribLocations {
 int aPosition = NULL_ATTRIB;
 int aData = NULL_ATTRIB;
 int aFilterRenderTaskAddress = NULL_ATTRIB;
 int aFilterInput1TaskAddress = NULL_ATTRIB;
 int aFilterInput2TaskAddress = NULL_ATTRIB;
 int aFilterKind = NULL_ATTRIB;
 int aFilterInputCount = NULL_ATTRIB;
 int aFilterGenericInt = NULL_ATTRIB;
 int aFilterExtraDataAddress = NULL_ATTRIB;
 void bind_loc(const char* name, int index) {
  if (strcmp("aPosition", name) == 0) { aPosition = index; return; }
  if (strcmp("aData", name) == 0) { aData = index; return; }
  if (strcmp("aFilterRenderTaskAddress", name) == 0) { aFilterRenderTaskAddress = index; return; }
  if (strcmp("aFilterInput1TaskAddress", name) == 0) { aFilterInput1TaskAddress = index; return; }
  if (strcmp("aFilterInput2TaskAddress", name) == 0) { aFilterInput2TaskAddress = index; return; }
  if (strcmp("aFilterKind", name) == 0) { aFilterKind = index; return; }
  if (strcmp("aFilterInputCount", name) == 0) { aFilterInputCount = index; return; }
  if (strcmp("aFilterGenericInt", name) == 0) { aFilterGenericInt = index; return; }
  if (strcmp("aFilterExtraDataAddress", name) == 0) { aFilterExtraDataAddress = index; return; }
 }
 int get_loc(const char* name) const {
  if (strcmp("aPosition", name) == 0) { return aPosition != NULL_ATTRIB ? aPosition : -1; }
  if (strcmp("aData", name) == 0) { return aData != NULL_ATTRIB ? aData : -1; }
  if (strcmp("aFilterRenderTaskAddress", name) == 0) { return aFilterRenderTaskAddress != NULL_ATTRIB ? aFilterRenderTaskAddress : -1; }
  if (strcmp("aFilterInput1TaskAddress", name) == 0) { return aFilterInput1TaskAddress != NULL_ATTRIB ? aFilterInput1TaskAddress : -1; }
  if (strcmp("aFilterInput2TaskAddress", name) == 0) { return aFilterInput2TaskAddress != NULL_ATTRIB ? aFilterInput2TaskAddress : -1; }
  if (strcmp("aFilterKind", name) == 0) { return aFilterKind != NULL_ATTRIB ? aFilterKind : -1; }
  if (strcmp("aFilterInputCount", name) == 0) { return aFilterInputCount != NULL_ATTRIB ? aFilterInputCount : -1; }
  if (strcmp("aFilterGenericInt", name) == 0) { return aFilterGenericInt != NULL_ATTRIB ? aFilterGenericInt : -1; }
  if (strcmp("aFilterExtraDataAddress", name) == 0) { return aFilterExtraDataAddress != NULL_ATTRIB ? aFilterExtraDataAddress : -1; }
  return -1;
 }
} attrib_locations;
vec4_scalar vTransformBounds;
vec4_scalar vInput1UvRect;
vec4_scalar vInput2UvRect;
ivec4_scalar vData;
vec4_scalar vFilterData0;
vec4_scalar vFilterData1;
ivec2_scalar vFilterInputCountFilterKindVec;
vec2_scalar vFloat0;
mat4_scalar vColorMat;
ivec4_scalar vFuncs;
sampler2D sClipMask;
sampler2D sColor0;
sampler2D sColor1;
sampler2D sGpuBufferF;
isampler2D sGpuBufferI;
sampler2D sPrimitiveHeadersF;
isampler2D sPrimitiveHeadersI;
sampler2D sRenderTasks;
sampler2D sTransformPalette;
mat4_scalar uTransform;
void bind_textures() {
 sClipMask = lookup_sampler(&samplers.sClipMask_impl, samplers.sClipMask_slot);
 sColor0 = lookup_sampler(&samplers.sColor0_impl, samplers.sColor0_slot);
 sColor1 = lookup_sampler(&samplers.sColor1_impl, samplers.sColor1_slot);
 sGpuBufferF = lookup_sampler(&samplers.sGpuBufferF_impl, samplers.sGpuBufferF_slot);
 sGpuBufferI = lookup_isampler(&samplers.sGpuBufferI_impl, samplers.sGpuBufferI_slot);
 sPrimitiveHeadersF = lookup_sampler(&samplers.sPrimitiveHeadersF_impl, samplers.sPrimitiveHeadersF_slot);
 sPrimitiveHeadersI = lookup_isampler(&samplers.sPrimitiveHeadersI_impl, samplers.sPrimitiveHeadersI_slot);
 sRenderTasks = lookup_sampler(&samplers.sRenderTasks_impl, samplers.sRenderTasks_slot);
 sTransformPalette = lookup_sampler(&samplers.sTransformPalette_impl, samplers.sTransformPalette_slot);
}
};
struct cs_svg_filter_vert : VertexShaderImpl, cs_svg_filter_common {
private:
typedef cs_svg_filter_vert Self;
// mat4_scalar uTransform;
vec2 aPosition;
// sampler2D sColor0;
// sampler2D sColor1;
// sampler2D sColor2;
struct RectWithSize_scalar {
vec2_scalar p0;
vec2_scalar size;
RectWithSize_scalar() = default;
RectWithSize_scalar(vec2_scalar p0, vec2_scalar size) : p0(p0), size(size){}
};
struct RectWithSize {
vec2 p0;
vec2 size;
RectWithSize() = default;
RectWithSize(vec2 p0, vec2 size) : p0(p0), size(size){}
RectWithSize(vec2_scalar p0, vec2_scalar size):p0(p0),size(size){
}
IMPLICIT RectWithSize(RectWithSize_scalar s):p0(s.p0),size(s.size){
}
friend RectWithSize if_then_else(I32 c, RectWithSize t, RectWithSize e) { return RectWithSize(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.size, e.size));
}};
struct RectWithEndpoint_scalar {
vec2_scalar p0;
vec2_scalar p1;
RectWithEndpoint_scalar() = default;
RectWithEndpoint_scalar(vec2_scalar p0, vec2_scalar p1) : p0(p0), p1(p1){}
};
struct RectWithEndpoint {
vec2 p0;
vec2 p1;
RectWithEndpoint() = default;
RectWithEndpoint(vec2 p0, vec2 p1) : p0(p0), p1(p1){}
RectWithEndpoint(vec2_scalar p0, vec2_scalar p1):p0(p0),p1(p1){
}
IMPLICIT RectWithEndpoint(RectWithEndpoint_scalar s):p0(s.p0),p1(s.p1){
}
friend RectWithEndpoint if_then_else(I32 c, RectWithEndpoint t, RectWithEndpoint e) { return RectWithEndpoint(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.p1, e.p1));
}};
// sampler2D sRenderTasks;
struct RenderTaskData_scalar {
RectWithEndpoint_scalar task_rect;
vec4_scalar user_data;
RenderTaskData_scalar() = default;
RenderTaskData_scalar(RectWithEndpoint_scalar task_rect, vec4_scalar user_data) : task_rect(task_rect), user_data(user_data){}
};
struct RenderTaskData {
RectWithEndpoint task_rect;
vec4 user_data;
RenderTaskData() = default;
RenderTaskData(RectWithEndpoint task_rect, vec4 user_data) : task_rect(task_rect), user_data(user_data){}
RenderTaskData(RectWithEndpoint_scalar task_rect, vec4_scalar user_data):task_rect(task_rect),user_data(user_data){
}
IMPLICIT RenderTaskData(RenderTaskData_scalar s):task_rect(s.task_rect),user_data(s.user_data){
}
friend RenderTaskData if_then_else(I32 c, RenderTaskData t, RenderTaskData e) { return RenderTaskData(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.user_data, e.user_data));
}};
struct PictureTask_scalar {
RectWithEndpoint_scalar task_rect;
float device_pixel_scale;
vec2_scalar content_origin;
PictureTask_scalar() = default;
PictureTask_scalar(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar content_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), content_origin(content_origin){}
};
struct PictureTask {
RectWithEndpoint task_rect;
Float device_pixel_scale;
vec2 content_origin;
PictureTask() = default;
PictureTask(RectWithEndpoint task_rect, Float device_pixel_scale, vec2 content_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), content_origin(content_origin){}
PictureTask(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar content_origin):task_rect(task_rect),device_pixel_scale(device_pixel_scale),content_origin(content_origin){
}
IMPLICIT PictureTask(PictureTask_scalar s):task_rect(s.task_rect),device_pixel_scale(s.device_pixel_scale),content_origin(s.content_origin){
}
friend PictureTask if_then_else(I32 c, PictureTask t, PictureTask e) { return PictureTask(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.device_pixel_scale, e.device_pixel_scale), if_then_else(c, t.content_origin, e.content_origin));
}};
struct ClipArea_scalar {
RectWithEndpoint_scalar task_rect;
float device_pixel_scale;
vec2_scalar screen_origin;
ClipArea_scalar() = default;
ClipArea_scalar(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar screen_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), screen_origin(screen_origin){}
};
struct ClipArea {
RectWithEndpoint task_rect;
Float device_pixel_scale;
vec2 screen_origin;
ClipArea() = default;
ClipArea(RectWithEndpoint task_rect, Float device_pixel_scale, vec2 screen_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), screen_origin(screen_origin){}
ClipArea(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar screen_origin):task_rect(task_rect),device_pixel_scale(device_pixel_scale),screen_origin(screen_origin){
}
IMPLICIT ClipArea(ClipArea_scalar s):task_rect(s.task_rect),device_pixel_scale(s.device_pixel_scale),screen_origin(s.screen_origin){
}
friend ClipArea if_then_else(I32 c, ClipArea t, ClipArea e) { return ClipArea(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.device_pixel_scale, e.device_pixel_scale), if_then_else(c, t.screen_origin, e.screen_origin));
}};
// vec4_scalar vTransformBounds;
// sampler2D sTransformPalette;
struct Transform_scalar {
mat4_scalar m;
mat4_scalar inv_m;
bool is_axis_aligned;
Transform_scalar() = default;
Transform_scalar(mat4_scalar m, mat4_scalar inv_m, bool is_axis_aligned) : m(m), inv_m(inv_m), is_axis_aligned(is_axis_aligned){}
};
struct Transform {
mat4 m;
mat4 inv_m;
Bool is_axis_aligned;
Transform() = default;
Transform(mat4 m, mat4 inv_m, Bool is_axis_aligned) : m(m), inv_m(inv_m), is_axis_aligned(is_axis_aligned){}
Transform(mat4_scalar m, mat4_scalar inv_m, bool is_axis_aligned):m(m),inv_m(inv_m),is_axis_aligned(is_axis_aligned){
}
IMPLICIT Transform(Transform_scalar s):m(s.m),inv_m(s.inv_m),is_axis_aligned(s.is_axis_aligned){
}
friend Transform if_then_else(I32 c, Transform t, Transform e) { return Transform(
if_then_else(c, t.m, e.m), if_then_else(c, t.inv_m, e.inv_m), if_then_else(c, t.is_axis_aligned, e.is_axis_aligned));
}};
// sampler2D sGpuBufferF;
// isampler2D sGpuBufferI;
struct ImageSource_scalar {
RectWithEndpoint_scalar uv_rect;
vec4_scalar user_data;
ImageSource_scalar() = default;
ImageSource_scalar(RectWithEndpoint_scalar uv_rect, vec4_scalar user_data) : uv_rect(uv_rect), user_data(user_data){}
};
struct ImageSource {
RectWithEndpoint uv_rect;
vec4 user_data;
ImageSource() = default;
ImageSource(RectWithEndpoint uv_rect, vec4 user_data) : uv_rect(uv_rect), user_data(user_data){}
ImageSource(RectWithEndpoint_scalar uv_rect, vec4_scalar user_data):uv_rect(uv_rect),user_data(user_data){
}
IMPLICIT ImageSource(ImageSource_scalar s):uv_rect(s.uv_rect),user_data(s.user_data){
}
friend ImageSource if_then_else(I32 c, ImageSource t, ImageSource e) { return ImageSource(
if_then_else(c, t.uv_rect, e.uv_rect), if_then_else(c, t.user_data, e.user_data));
}};
struct ImageSourceExtra_scalar {
vec4_scalar st_tl;
vec4_scalar st_tr;
vec4_scalar st_bl;
vec4_scalar st_br;
ImageSourceExtra_scalar() = default;
ImageSourceExtra_scalar(vec4_scalar st_tl, vec4_scalar st_tr, vec4_scalar st_bl, vec4_scalar st_br) : st_tl(st_tl), st_tr(st_tr), st_bl(st_bl), st_br(st_br){}
};
struct ImageSourceExtra {
vec4 st_tl;
vec4 st_tr;
vec4 st_bl;
vec4 st_br;
ImageSourceExtra() = default;
ImageSourceExtra(vec4 st_tl, vec4 st_tr, vec4 st_bl, vec4 st_br) : st_tl(st_tl), st_tr(st_tr), st_bl(st_bl), st_br(st_br){}
ImageSourceExtra(vec4_scalar st_tl, vec4_scalar st_tr, vec4_scalar st_bl, vec4_scalar st_br):st_tl(st_tl),st_tr(st_tr),st_bl(st_bl),st_br(st_br){
}
IMPLICIT ImageSourceExtra(ImageSourceExtra_scalar s):st_tl(s.st_tl),st_tr(s.st_tr),st_bl(s.st_bl),st_br(s.st_br){
}
friend ImageSourceExtra if_then_else(I32 c, ImageSourceExtra t, ImageSourceExtra e) { return ImageSourceExtra(
if_then_else(c, t.st_tl, e.st_tl), if_then_else(c, t.st_tr, e.st_tr), if_then_else(c, t.st_bl, e.st_bl), if_then_else(c, t.st_br, e.st_br));
}};
// sampler2D sClipMask;
// sampler2D sPrimitiveHeadersF;
// isampler2D sPrimitiveHeadersI;
ivec4_scalar aData;
struct Instance_scalar {
int32_t prim_header_address;
int32_t clip_address;
int32_t segment_index;
int32_t flags;
int32_t resource_address;
int32_t brush_kind;
Instance_scalar() = default;
Instance_scalar(int32_t prim_header_address, int32_t clip_address, int32_t segment_index, int32_t flags, int32_t resource_address, int32_t brush_kind) : prim_header_address(prim_header_address), clip_address(clip_address), segment_index(segment_index), flags(flags), resource_address(resource_address), brush_kind(brush_kind){}
};
struct Instance {
I32 prim_header_address;
I32 clip_address;
I32 segment_index;
I32 flags;
I32 resource_address;
I32 brush_kind;
Instance() = default;
Instance(I32 prim_header_address, I32 clip_address, I32 segment_index, I32 flags, I32 resource_address, I32 brush_kind) : prim_header_address(prim_header_address), clip_address(clip_address), segment_index(segment_index), flags(flags), resource_address(resource_address), brush_kind(brush_kind){}
Instance(int32_t prim_header_address, int32_t clip_address, int32_t segment_index, int32_t flags, int32_t resource_address, int32_t brush_kind):prim_header_address(prim_header_address),clip_address(clip_address),segment_index(segment_index),flags(flags),resource_address(resource_address),brush_kind(brush_kind){
}
IMPLICIT Instance(Instance_scalar s):prim_header_address(s.prim_header_address),clip_address(s.clip_address),segment_index(s.segment_index),flags(s.flags),resource_address(s.resource_address),brush_kind(s.brush_kind){
}
friend Instance if_then_else(I32 c, Instance t, Instance e) { return Instance(
if_then_else(c, t.prim_header_address, e.prim_header_address), if_then_else(c, t.clip_address, e.clip_address), if_then_else(c, t.segment_index, e.segment_index), if_then_else(c, t.flags, e.flags), if_then_else(c, t.resource_address, e.resource_address), if_then_else(c, t.brush_kind, e.brush_kind));
}};
struct PrimitiveHeader_scalar {
RectWithEndpoint_scalar local_rect;
RectWithEndpoint_scalar local_clip_rect;
float z;
int32_t specific_prim_address;
int32_t transform_id;
int32_t picture_task_address;
ivec4_scalar user_data;
PrimitiveHeader_scalar() = default;
PrimitiveHeader_scalar(RectWithEndpoint_scalar local_rect, RectWithEndpoint_scalar local_clip_rect, float z, int32_t specific_prim_address, int32_t transform_id, int32_t picture_task_address, ivec4_scalar user_data) : local_rect(local_rect), local_clip_rect(local_clip_rect), z(z), specific_prim_address(specific_prim_address), transform_id(transform_id), picture_task_address(picture_task_address), user_data(user_data){}
};
struct PrimitiveHeader {
RectWithEndpoint local_rect;
RectWithEndpoint local_clip_rect;
Float z;
I32 specific_prim_address;
I32 transform_id;
I32 picture_task_address;
ivec4 user_data;
PrimitiveHeader() = default;
PrimitiveHeader(RectWithEndpoint local_rect, RectWithEndpoint local_clip_rect, Float z, I32 specific_prim_address, I32 transform_id, I32 picture_task_address, ivec4 user_data) : local_rect(local_rect), local_clip_rect(local_clip_rect), z(z), specific_prim_address(specific_prim_address), transform_id(transform_id), picture_task_address(picture_task_address), user_data(user_data){}
PrimitiveHeader(RectWithEndpoint_scalar local_rect, RectWithEndpoint_scalar local_clip_rect, float z, int32_t specific_prim_address, int32_t transform_id, int32_t picture_task_address, ivec4_scalar user_data):local_rect(local_rect),local_clip_rect(local_clip_rect),z(z),specific_prim_address(specific_prim_address),transform_id(transform_id),picture_task_address(picture_task_address),user_data(user_data){
}
IMPLICIT PrimitiveHeader(PrimitiveHeader_scalar s):local_rect(s.local_rect),local_clip_rect(s.local_clip_rect),z(s.z),specific_prim_address(s.specific_prim_address),transform_id(s.transform_id),picture_task_address(s.picture_task_address),user_data(s.user_data){
}
friend PrimitiveHeader if_then_else(I32 c, PrimitiveHeader t, PrimitiveHeader e) { return PrimitiveHeader(
if_then_else(c, t.local_rect, e.local_rect), if_then_else(c, t.local_clip_rect, e.local_clip_rect), if_then_else(c, t.z, e.z), if_then_else(c, t.specific_prim_address, e.specific_prim_address), if_then_else(c, t.transform_id, e.transform_id), if_then_else(c, t.picture_task_address, e.picture_task_address), if_then_else(c, t.user_data, e.user_data));
}};
struct VertexInfo_scalar {
vec2_scalar local_pos;
vec4_scalar world_pos;
VertexInfo_scalar() = default;
VertexInfo_scalar(vec2_scalar local_pos, vec4_scalar world_pos) : local_pos(local_pos), world_pos(world_pos){}
};
struct VertexInfo {
vec2 local_pos;
vec4 world_pos;
VertexInfo() = default;
VertexInfo(vec2 local_pos, vec4 world_pos) : local_pos(local_pos), world_pos(world_pos){}
VertexInfo(vec2_scalar local_pos, vec4_scalar world_pos):local_pos(local_pos),world_pos(world_pos){
}
IMPLICIT VertexInfo(VertexInfo_scalar s):local_pos(s.local_pos),world_pos(s.world_pos){
}
friend VertexInfo if_then_else(I32 c, VertexInfo t, VertexInfo e) { return VertexInfo(
if_then_else(c, t.local_pos, e.local_pos), if_then_else(c, t.world_pos, e.world_pos));
}};
vec2 vInput1Uv;
vec2 vInput2Uv;
// vec4_scalar vInput1UvRect;
// vec4_scalar vInput2UvRect;
// ivec4_scalar vData;
// vec4_scalar vFilterData0;
// vec4_scalar vFilterData1;
// ivec2_scalar vFilterInputCountFilterKindVec;
// vec2_scalar vFloat0;
// mat4_scalar vColorMat;
// ivec4_scalar vFuncs;
int32_t aFilterRenderTaskAddress;
int32_t aFilterInput1TaskAddress;
int32_t aFilterInput2TaskAddress;
int32_t aFilterKind;
int32_t aFilterInputCount;
int32_t aFilterGenericInt;
int32_t aFilterExtraDataAddress;
struct FilterTask_scalar {
RectWithEndpoint_scalar task_rect;
vec3_scalar user_data;
FilterTask_scalar() = default;
FilterTask_scalar(RectWithEndpoint_scalar task_rect, vec3_scalar user_data) : task_rect(task_rect), user_data(user_data){}
};
struct FilterTask {
RectWithEndpoint task_rect;
vec3 user_data;
FilterTask() = default;
FilterTask(RectWithEndpoint task_rect, vec3 user_data) : task_rect(task_rect), user_data(user_data){}
FilterTask(RectWithEndpoint_scalar task_rect, vec3_scalar user_data):task_rect(task_rect),user_data(user_data){
}
IMPLICIT FilterTask(FilterTask_scalar s):task_rect(s.task_rect),user_data(s.user_data){
}
friend FilterTask if_then_else(I32 c, FilterTask t, FilterTask e) { return FilterTask(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.user_data, e.user_data));
}};
RenderTaskData_scalar fetch_render_task_data(int32_t index) {
 ivec2_scalar uv = make_ivec2(make_int((2u)*((make_uint(index))%((1024u)/(2u)))), make_int((make_uint(index))/((1024u)/(2u))));
 auto sRenderTasks_uv_fetch = texelFetchPtr(sRenderTasks, uv, 0, 1, 0, 0);
 vec4_scalar texel0 = texelFetchUnchecked(sRenderTasks, sRenderTasks_uv_fetch, 0, 0);
 vec4_scalar texel1 = texelFetchUnchecked(sRenderTasks, sRenderTasks_uv_fetch, 1, 0);
 RectWithEndpoint_scalar task_rect = RectWithEndpoint_scalar((texel0).sel(X,Y), (texel0).sel(Z,W));
 RenderTaskData_scalar data = RenderTaskData_scalar(task_rect, texel1);
 return data;
}
FilterTask_scalar fetch_filter_task(int32_t address) {
 RenderTaskData_scalar task_data = fetch_render_task_data(address);
 FilterTask_scalar task = FilterTask_scalar((task_data).task_rect, ((task_data).user_data).sel(X,Y,Z));
 return task;
}
RectWithEndpoint_scalar fetch_render_task_rect(int32_t index) {
 ivec2_scalar uv = make_ivec2(make_int((2u)*((make_uint(index))%((1024u)/(2u)))), make_int((make_uint(index))/((1024u)/(2u))));
 auto sRenderTasks_uv_fetch = texelFetchPtr(sRenderTasks, uv, 0, 1, 0, 0);
 vec4_scalar texel0 = texelFetchUnchecked(sRenderTasks, sRenderTasks_uv_fetch, 0, 0);
 vec4_scalar texel1 = texelFetchUnchecked(sRenderTasks, sRenderTasks_uv_fetch, 1, 0);
 RectWithEndpoint_scalar task_rect = RectWithEndpoint_scalar((texel0).sel(X,Y), (texel0).sel(Z,W));
 return task_rect;
}
vec4_scalar compute_uv_rect(RectWithEndpoint_scalar task_rect, vec2_scalar texture_size) {
 vec4_scalar uvRect = make_vec4(((task_rect).p0)+(make_vec2(0.5f)), ((task_rect).p1)-(make_vec2(0.5f)));
 uvRect /= (texture_size).sel(X,Y,X,Y);
 return uvRect;
}
vec2 compute_uv(RectWithEndpoint_scalar task_rect, vec2_scalar texture_size) {
 vec2_scalar uv0 = ((task_rect).p0)/(texture_size);
 vec2_scalar uv1 = (floor((task_rect).p1))/(texture_size);
 return mix(uv0, uv1, (aPosition).sel(X,Y));
}
ivec2_scalar get_gpu_buffer_uv(int32_t address) {
 return make_ivec2((make_uint(address))%(1024u), (make_uint(address))/(1024u));
}
vec4_scalar fetch_from_gpu_buffer_1f(int32_t address) {
 ivec2_scalar uv = get_gpu_buffer_uv(address);
 return texelFetch(sGpuBufferF, uv, 0);
}
Array<vec4_scalar,4> fetch_from_gpu_buffer_4f_direct(ivec2_scalar uv) {
 auto sGpuBufferF_uv_fetch = texelFetchPtr(sGpuBufferF, uv, 0, 3, 0, 0);
 return Array<vec4_scalar,4>{{texelFetchUnchecked(sGpuBufferF, sGpuBufferF_uv_fetch, 0, 0), texelFetchUnchecked(sGpuBufferF, sGpuBufferF_uv_fetch, 1, 0), texelFetchUnchecked(sGpuBufferF, sGpuBufferF_uv_fetch, 2, 0), texelFetchUnchecked(sGpuBufferF, sGpuBufferF_uv_fetch, 3, 0)}};
}
vec4_scalar fetch_from_gpu_buffer_1f_direct(ivec2_scalar uv) {
 return texelFetch(sGpuBufferF, uv, 0);
}
ALWAYS_INLINE void main(void) {
 FilterTask_scalar filter_task = fetch_filter_task(aFilterRenderTaskAddress);
 RectWithEndpoint_scalar target_rect = (filter_task).task_rect;
 vec2 pos = mix((target_rect).p0, (target_rect).p1, (aPosition).sel(X,Y));
 RectWithEndpoint_scalar input_1_task;
 if ((aFilterInputCount)>(0)) {
  {
   vec2_scalar texture_size = make_vec2((textureSize(sColor0, 0)).sel(X,Y));
   input_1_task = fetch_render_task_rect(aFilterInput1TaskAddress);
   vInput1UvRect = compute_uv_rect(input_1_task, texture_size);
   vInput1Uv = compute_uv(input_1_task, texture_size);
  }
 }
 RectWithEndpoint_scalar input_2_task;
 if ((aFilterInputCount)>(1)) {
  {
   vec2_scalar texture_size = make_vec2((textureSize(sColor1, 0)).sel(X,Y));
   input_2_task = fetch_render_task_rect(aFilterInput2TaskAddress);
   vInput2UvRect = compute_uv_rect(input_2_task, texture_size);
   vInput2Uv = compute_uv(input_2_task, texture_size);
  }
 }
 (vFilterInputCountFilterKindVec).x = aFilterInputCount;
 (vFilterInputCountFilterKindVec).y = aFilterKind;
 (vFuncs).x = ((aFilterGenericInt)>>(12))&(15);
 (vFuncs).y = ((aFilterGenericInt)>>(8))&(15);
 (vFuncs).z = ((aFilterGenericInt)>>(4))&(15);
 (vFuncs).w = (aFilterGenericInt)&(15);
 switch (aFilterKind) {
  case 0:
   vData = make_ivec4(aFilterGenericInt, 0, 0, 0);
   break;
  case 1:
   vFilterData0 = fetch_from_gpu_buffer_1f(aFilterExtraDataAddress);
   break;
  case 4:
   (vFloat0).x = ((filter_task).user_data).x;
   break;
  case 5:
   {
    ivec2_scalar buffer_uv = get_gpu_buffer_uv(aFilterExtraDataAddress);
    Array<vec4_scalar,4> mat_data = fetch_from_gpu_buffer_4f_direct(buffer_uv);
    vColorMat = make_mat4(mat_data[0], mat_data[1], mat_data[2], mat_data[3]);
    vFilterData0 = fetch_from_gpu_buffer_1f_direct((buffer_uv)+(make_ivec2(4, 0)));
    break;
   }
  case 6:
   vFilterData0 = fetch_from_gpu_buffer_1f(aFilterExtraDataAddress);
   break;
  case 7:
   {
    vec2_scalar texture_size = make_vec2((textureSize(sColor0, 0)).sel(X,Y));
    vFilterData0 = make_vec4((-(((filter_task).user_data).sel(X,Y)))/(texture_size), make_vec2(0.f));
    RectWithEndpoint_scalar task_rect = input_1_task;
    vec4_scalar clipRect = make_vec4((task_rect).p0, (task_rect).p1);
    clipRect /= (texture_size).sel(X,Y,X,Y);
    vFilterData1 = clipRect;
    break;
    }
  case 8:
   {
    ivec2_scalar buffer_uv = get_gpu_buffer_uv(aFilterExtraDataAddress);
    vData = make_ivec4(buffer_uv, 0, 0);
    break;
   }
  case 10:
   vData = make_ivec4(aFilterGenericInt, 0, 0, 0);
   if ((aFilterGenericInt)==(6)) {
    {
     vFilterData0 = fetch_from_gpu_buffer_1f(aFilterExtraDataAddress);
    }
   }
   break;
  default:
   break;
 }
 gl_Position = (uTransform)*(make_vec4(pos, 0.f, 1.f));
}
static void set_uniform_1i(VertexShaderImpl* impl, int index, int value) {
 Self* self = (Self*)impl;
 if (self->samplers.set_slot(index, value)) return;
 switch (index) {
 case 8:
  assert(0); // sClipMask
  break;
 case 9:
  assert(0); // sColor0
  break;
 case 10:
  assert(0); // sColor1
  break;
 case 3:
  assert(0); // sGpuBufferF
  break;
 case 4:
  assert(0); // sGpuBufferI
  break;
 case 5:
  assert(0); // sPrimitiveHeadersF
  break;
 case 6:
  assert(0); // sPrimitiveHeadersI
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 2:
  assert(0); // sTransformPalette
  break;
 case 7:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 8:
  assert(0); // sClipMask
  break;
 case 9:
  assert(0); // sColor0
  break;
 case 10:
  assert(0); // sColor1
  break;
 case 3:
  assert(0); // sGpuBufferF
  break;
 case 4:
  assert(0); // sGpuBufferI
  break;
 case 5:
  assert(0); // sPrimitiveHeadersF
  break;
 case 6:
  assert(0); // sPrimitiveHeadersI
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 2:
  assert(0); // sTransformPalette
  break;
 case 7:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_matrix4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 8:
  assert(0); // sClipMask
  break;
 case 9:
  assert(0); // sColor0
  break;
 case 10:
  assert(0); // sColor1
  break;
 case 3:
  assert(0); // sGpuBufferF
  break;
 case 4:
  assert(0); // sGpuBufferI
  break;
 case 5:
  assert(0); // sPrimitiveHeadersF
  break;
 case 6:
  assert(0); // sPrimitiveHeadersI
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 2:
  assert(0); // sTransformPalette
  break;
 case 7:
  self->uTransform = mat4_scalar::load_from_ptr(value);
  break;
 }
}
static void load_attribs(VertexShaderImpl* impl, VertexAttrib *attribs, uint32_t start, int instance, int count) {Self* self = (Self*)impl;
 load_attrib(self->aPosition, attribs[self->attrib_locations.aPosition], start, instance, count);
 load_flat_attrib(self->aFilterRenderTaskAddress, attribs[self->attrib_locations.aFilterRenderTaskAddress], start, instance, count);
 load_flat_attrib(self->aFilterInput1TaskAddress, attribs[self->attrib_locations.aFilterInput1TaskAddress], start, instance, count);
 load_flat_attrib(self->aFilterInput2TaskAddress, attribs[self->attrib_locations.aFilterInput2TaskAddress], start, instance, count);
 load_flat_attrib(self->aFilterKind, attribs[self->attrib_locations.aFilterKind], start, instance, count);
 load_flat_attrib(self->aFilterInputCount, attribs[self->attrib_locations.aFilterInputCount], start, instance, count);
 load_flat_attrib(self->aFilterGenericInt, attribs[self->attrib_locations.aFilterGenericInt], start, instance, count);
 load_flat_attrib(self->aFilterExtraDataAddress, attribs[self->attrib_locations.aFilterExtraDataAddress], start, instance, count);
}
public:
struct InterpOutputs {
vec2_scalar vInput1Uv;
vec2_scalar vInput2Uv;
};
private:
ALWAYS_INLINE void store_interp_outputs(char* dest_ptr, size_t stride) {
  for(int n = 0; n < 4; n++) {
    auto* dest = reinterpret_cast<InterpOutputs*>(dest_ptr);
    dest->vInput1Uv = get_nth(vInput1Uv, n);
    dest->vInput2Uv = get_nth(vInput2Uv, n);
    dest_ptr += stride;
  }
}
static void run(VertexShaderImpl* impl, char* interps, size_t interp_stride) {
 Self* self = (Self*)impl;
 self->main();
 self->store_interp_outputs(interps, interp_stride);
}
static void init_batch(VertexShaderImpl* impl) {
 Self* self = (Self*)impl; self->bind_textures(); }
public:
cs_svg_filter_vert() {
 set_uniform_1i_func = &set_uniform_1i;
 set_uniform_4fv_func = &set_uniform_4fv;
 set_uniform_matrix4fv_func = &set_uniform_matrix4fv;
 init_batch_func = &init_batch;
 load_attribs_func = &load_attribs;
 run_primitive_func = &run;
}
};


struct cs_svg_filter_frag : FragmentShaderImpl, cs_svg_filter_vert {
private:
typedef cs_svg_filter_frag Self;
#define oFragColor gl_FragColor
// vec4 oFragColor;
// sampler2D sColor0;
// sampler2D sColor1;
// sampler2D sColor2;
struct RectWithSize_scalar {
vec2_scalar p0;
vec2_scalar size;
RectWithSize_scalar() = default;
RectWithSize_scalar(vec2_scalar p0, vec2_scalar size) : p0(p0), size(size){}
};
struct RectWithSize {
vec2 p0;
vec2 size;
RectWithSize() = default;
RectWithSize(vec2 p0, vec2 size) : p0(p0), size(size){}
RectWithSize(vec2_scalar p0, vec2_scalar size):p0(p0),size(size){
}
IMPLICIT RectWithSize(RectWithSize_scalar s):p0(s.p0),size(s.size){
}
friend RectWithSize if_then_else(I32 c, RectWithSize t, RectWithSize e) { return RectWithSize(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.size, e.size));
}};
struct RectWithEndpoint_scalar {
vec2_scalar p0;
vec2_scalar p1;
RectWithEndpoint_scalar() = default;
RectWithEndpoint_scalar(vec2_scalar p0, vec2_scalar p1) : p0(p0), p1(p1){}
};
struct RectWithEndpoint {
vec2 p0;
vec2 p1;
RectWithEndpoint() = default;
RectWithEndpoint(vec2 p0, vec2 p1) : p0(p0), p1(p1){}
RectWithEndpoint(vec2_scalar p0, vec2_scalar p1):p0(p0),p1(p1){
}
IMPLICIT RectWithEndpoint(RectWithEndpoint_scalar s):p0(s.p0),p1(s.p1){
}
friend RectWithEndpoint if_then_else(I32 c, RectWithEndpoint t, RectWithEndpoint e) { return RectWithEndpoint(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.p1, e.p1));
}};
// vec4_scalar vTransformBounds;
// sampler2D sGpuBufferF;
// isampler2D sGpuBufferI;
// sampler2D sClipMask;
struct Fragment_scalar {
vec4_scalar color;
Fragment_scalar() = default;
explicit Fragment_scalar(vec4_scalar color) : color(color){}
};
struct Fragment {
vec4 color;
Fragment() = default;
explicit Fragment(vec4 color) : color(color){}
explicit Fragment(vec4_scalar color):color(color){
}
IMPLICIT Fragment(Fragment_scalar s):color(s.color){
}
friend Fragment if_then_else(I32 c, Fragment t, Fragment e) { return Fragment(
if_then_else(c, t.color, e.color));
}};
vec2 vInput1Uv;
vec2 vInput2Uv;
// vec4_scalar vInput1UvRect;
// vec4_scalar vInput2UvRect;
// ivec4_scalar vData;
// vec4_scalar vFilterData0;
// vec4_scalar vFilterData1;
// ivec2_scalar vFilterInputCountFilterKindVec;
// vec2_scalar vFloat0;
// mat4_scalar vColorMat;
// ivec4_scalar vFuncs;
int32_t static constexpr BlendMode_Normal = 0;
int32_t static constexpr BlendMode_Multiply = 1;
int32_t static constexpr BlendMode_Screen = 2;
int32_t static constexpr BlendMode_Overlay = 3;
int32_t static constexpr BlendMode_Darken = 4;
int32_t static constexpr BlendMode_Lighten = 5;
int32_t static constexpr BlendMode_ColorDodge = 6;
int32_t static constexpr BlendMode_ColorBurn = 7;
int32_t static constexpr BlendMode_HardLight = 8;
int32_t static constexpr BlendMode_SoftLight = 9;
int32_t static constexpr BlendMode_Difference = 10;
int32_t static constexpr BlendMode_Exclusion = 11;
int32_t static constexpr BlendMode_Hue = 12;
int32_t static constexpr BlendMode_Saturation = 13;
int32_t static constexpr BlendMode_Color = 14;
int32_t static constexpr BlendMode_Luminosity = 15;
vec4 sampleInUvRect(sampler2D sampler, vec2 uv, vec4_scalar uvRect) {
 vec2 clamped = clamp((uv).sel(X,Y), (uvRect).sel(X,Y), (uvRect).sel(Z,W));
 return texture(sampler, clamped);
}
vec3 Multiply(vec3 Cb, vec3 Cs) {
 return (Cb)*(Cs);
}
vec3 Screen(vec3 Cb, vec3 Cs) {
 return ((Cb)+(Cs))-((Cb)*(Cs));
}
vec3 HardLight(vec3 Cb, vec3 Cs) {
 vec3 m = Multiply(Cb, (2.f)*(Cs));
 vec3 s = Screen(Cb, ((2.f)*(Cs))-(1.f));
 vec3_scalar edge = make_vec3(0.5f, 0.5f, 0.5f);
 return mix(m, s, step(edge, Cs));
}
Float ColorDodge(Float Cb, Float Cs) {
 I32 ret_mask = ~0;
 Float ret;
 auto _c8_ = (Cb)==(0.f);
 ret = 0.f;
 ret_mask = ~I32(_c8_);
 auto _c9_ = (Cs)==(1.f);
 auto _c10_ = (~(_c8_))&(_c9_);
 ret = if_then_else(ret_mask & I32(_c10_), 1.f, ret);
 ret_mask &= ~I32(_c10_);
 _c9_ = (~(_c8_))&(~(_c9_));
 ret = if_then_else(ret_mask & I32(_c9_), min(1.f, (Cb)/((1.f)-(Cs))), ret);
 ret_mask &= ~I32(_c9_);
 return ret;
}
Float ColorBurn(Float Cb, Float Cs) {
 I32 ret_mask = ~0;
 Float ret;
 auto _c14_ = (Cb)==(1.f);
 ret = 1.f;
 ret_mask = ~I32(_c14_);
 auto _c15_ = (Cs)==(0.f);
 auto _c16_ = (~(_c14_))&(_c15_);
 ret = if_then_else(ret_mask & I32(_c16_), 0.f, ret);
 ret_mask &= ~I32(_c16_);
 _c15_ = (~(_c14_))&(~(_c15_));
 ret = if_then_else(ret_mask & I32(_c15_), (1.f)-(min(1.f, ((1.f)-(Cb))/(Cs))), ret);
 ret_mask &= ~I32(_c15_);
 return ret;
}
Float SoftLight(Float Cb, Float Cs) {
 I32 ret_mask = ~0;
 Float ret;
 auto _c20_ = (Cs)<=(0.5f);
 {
  ret = (Cb)-((((1.f)-((2.f)*(Cs)))*(Cb))*((1.f)-(Cb)));
  ret_mask = ~I32(_c20_);
 }
 {
  Float D;
  auto _c21_ = (Cb)<=(0.25f);
  auto _c22_ = (~(_c20_))&(_c21_);
  D = if_then_else(_c22_,(((((16.f)*(Cb))-(12.f))*(Cb))+(4.f))*(Cb),D);
  _c21_ = (~(_c20_))&(~(_c21_));
  D = if_then_else(_c21_,sqrt(Cb),D);
  ret = if_then_else(ret_mask & I32(~(_c20_)), (Cb)+((((2.f)*(Cs))-(1.f))*((D)-(Cb))), ret);
  ret_mask &= ~I32(~(_c20_));
 }
 return ret;
}
vec3 Difference(vec3 Cb, vec3 Cs) {
 return abs((Cb)-(Cs));
}
vec3 Exclusion(vec3 Cb, vec3 Cs) {
 return ((Cb)+(Cs))-(((2.f)*(Cb))*(Cs));
}
Float Lum(vec3 c) {
 vec3_scalar f = make_vec3(0.3f, 0.59f, 0.11f);
 return dot(c, f);
}
vec3 ClipColor(vec3 C) {
 Float L = Lum(C);
 Float n = min((C).x, min((C).y, (C).z));
 Float x = max((C).x, max((C).y, (C).z));
 auto _c25_ = (n)<(0.f);
 C = if_then_else(_c25_,(L)+((((C)-(L))*(L))/((L)-(n))),C);
 auto _c26_ = (x)>(1.f);
 C = if_then_else(_c26_,(L)+((((C)-(L))*((1.f)-(L)))/((x)-(L))),C);
 return C;
}
vec3 SetLum(vec3 C, Float l) {
 Float d = (l)-(Lum(C));
 return ClipColor((C)+(d));
}
void SetSatInner(Float& Cmin, Float& Cmid, Float& Cmax, Float s, I32 _cond_mask_) {
 auto _c47_ = (Cmax)>(Cmin);
 auto _c48_ = (_cond_mask_)&(_c47_);
 {
  Cmid = if_then_else(_c48_,(((Cmid)-(Cmin))*(s))/((Cmax)-(Cmin)),Cmid);
  Cmax = if_then_else(_c48_,s,Cmax);
 }
 _c47_ = (_cond_mask_)&(~(_c47_));
 {
  Cmid = if_then_else(_c47_,0.f,Cmid);
  Cmax = if_then_else(_c47_,0.f,Cmax);
 }
 Cmin = if_then_else(_cond_mask_,0.f,Cmin);
}
vec3 SetSat(vec3 C, Float s) {
 auto _c36_ = ((C).x)<=((C).y);
 {
  auto _c37_ = ((C).y)<=((C).z);
  auto _c38_ = (_c36_)&(_c37_);
  {
   SetSatInner((C).x, (C).y, (C).z, s, _c38_);
  }
  _c37_ = (_c36_)&(~(_c37_));
  {
   auto _c39_ = ((C).x)<=((C).z);
   auto _c40_ = (_c37_)&(_c39_);
   {
    SetSatInner((C).x, (C).z, (C).y, s, _c40_);
   }
   _c39_ = (_c37_)&(~(_c39_));
   {
    SetSatInner((C).z, (C).x, (C).y, s, _c39_);
   }
  }
 }
 {
  auto _c41_ = ((C).x)<=((C).z);
  auto _c42_ = (~(_c36_))&(_c41_);
  {
   SetSatInner((C).y, (C).x, (C).z, s, _c42_);
  }
  _c41_ = (~(_c36_))&(~(_c41_));
  {
   auto _c43_ = ((C).y)<=((C).z);
   auto _c44_ = (_c41_)&(_c43_);
   {
    SetSatInner((C).y, (C).z, (C).x, s, _c44_);
   }
   _c43_ = (_c41_)&(~(_c43_));
   {
    SetSatInner((C).z, (C).y, (C).x, s, _c43_);
   }
  }
 }
 return C;
}
Float Sat(vec3 c) {
 return (max((c).x, max((c).y, (c).z)))-(min((c).x, min((c).y, (c).z)));
}
vec3 Hue(vec3 Cb, vec3 Cs) {
 return SetLum(SetSat(Cs, Sat(Cb)), Lum(Cb));
}
vec3 Saturation(vec3 Cb, vec3 Cs) {
 return SetLum(SetSat(Cb, Sat(Cs)), Lum(Cb));
}
vec3 Color(vec3 Cb, vec3 Cs) {
 return SetLum(Cs, Lum(Cb));
}
vec3 Luminosity(vec3 Cb, vec3 Cs) {
 return SetLum(Cb, Lum(Cs));
}
vec4 blend(vec4 Cs, vec4 Cb, int32_t mode) {
 vec4 result = make_vec4(1.f, 0.f, 0.f, 1.f);
 switch (mode) {
  case BlendMode_Normal:
   (result).lsel(R,G,B) = (Cs).sel(R,G,B);
   break;
  case BlendMode_Multiply:
   (result).lsel(R,G,B) = Multiply((Cb).sel(R,G,B), (Cs).sel(R,G,B));
   break;
  case BlendMode_Screen:
   (result).lsel(R,G,B) = Screen((Cb).sel(R,G,B), (Cs).sel(R,G,B));
   break;
  case BlendMode_Overlay:
   (result).lsel(R,G,B) = HardLight((Cs).sel(R,G,B), (Cb).sel(R,G,B));
   break;
  case BlendMode_Darken:
   (result).lsel(R,G,B) = min((Cs).sel(R,G,B), (Cb).sel(R,G,B));
   break;
  case BlendMode_Lighten:
   (result).lsel(R,G,B) = max((Cs).sel(R,G,B), (Cb).sel(R,G,B));
   break;
  case BlendMode_ColorDodge:
   (result).x = ColorDodge((Cb).x, (Cs).x);
   (result).y = ColorDodge((Cb).y, (Cs).y);
   (result).z = ColorDodge((Cb).z, (Cs).z);
   break;
  case BlendMode_ColorBurn:
   (result).x = ColorBurn((Cb).x, (Cs).x);
   (result).y = ColorBurn((Cb).y, (Cs).y);
   (result).z = ColorBurn((Cb).z, (Cs).z);
   break;
  case BlendMode_HardLight:
   (result).lsel(R,G,B) = HardLight((Cb).sel(R,G,B), (Cs).sel(R,G,B));
   break;
  case BlendMode_SoftLight:
   (result).x = SoftLight((Cb).x, (Cs).x);
   (result).y = SoftLight((Cb).y, (Cs).y);
   (result).z = SoftLight((Cb).z, (Cs).z);
   break;
  case BlendMode_Difference:
   (result).lsel(R,G,B) = Difference((Cb).sel(R,G,B), (Cs).sel(R,G,B));
   break;
  case BlendMode_Exclusion:
   (result).lsel(R,G,B) = Exclusion((Cb).sel(R,G,B), (Cs).sel(R,G,B));
   break;
  case BlendMode_Hue:
   (result).lsel(R,G,B) = Hue((Cb).sel(R,G,B), (Cs).sel(R,G,B));
   break;
  case BlendMode_Saturation:
   (result).lsel(R,G,B) = Saturation((Cb).sel(R,G,B), (Cs).sel(R,G,B));
   break;
  case BlendMode_Color:
   (result).lsel(R,G,B) = Color((Cb).sel(R,G,B), (Cs).sel(R,G,B));
   break;
  case BlendMode_Luminosity:
   (result).lsel(R,G,B) = Luminosity((Cb).sel(R,G,B), (Cs).sel(R,G,B));
   break;
  default:
   break;
 }
 vec3 rgb = (((1.f)-((Cb).w))*((Cs).sel(R,G,B)))+(((Cb).w)*((result).sel(R,G,B)));
 result = mix(make_vec4(((Cb).sel(R,G,B))*((Cb).w), (Cb).w), make_vec4(rgb, 1.f), (Cs).w);
 return result;
}
vec3 LinearToSrgb(vec3 color) {
 vec3 c1 = (color)*(12.92f);
 vec3 c2 = ((make_vec3(1.055f))*(pow(color, make_vec3((1.f)/(2.4f)))))-(make_vec3(0.055f));
 return mix(c2, c1, lessThanEqual(color, make_vec3(0.0031308f)));
}
vec3 SrgbToLinear(vec3 color) {
 vec3 c1 = (color)/(12.92f);
 vec3 c2 = pow(((color)/(1.055f))+(make_vec3((0.055f)/(1.055f))), make_vec3(2.4f));
 return mix(c2, c1, lessThanEqual(color, make_vec3(0.04045f)));
}
Float point_inside_rect(vec2 p, vec2_scalar p0, vec2_scalar p1) {
 vec2 s = (step(p0, p))-(step(p1, p));
 return ((s).x)*((s).y);
}
vec4 fetch_from_gpu_buffer_1f_direct(ivec2 uv) {
 return texelFetch(sGpuBufferF, uv, 0);
}
vec4_scalar fetch_from_gpu_buffer_1f_direct(ivec2_scalar uv) {
 return texelFetch(sGpuBufferF, uv, 0);
}
vec4 ComponentTransfer(vec4 colora) {
 int32_t offset = 0;
 vec4 texel;
 I32 k;
 Array<int32_t,4> funcs = Array<int32_t,4>{{(vFuncs).x, (vFuncs).y, (vFuncs).z, (vFuncs).w}};
 for ( int32_t i = 0;
(i)<(4); i++)  {
  switch (funcs[i]) {
   case 0:
    break;
   case 1:
   case 2:
    k = make_int(floor(((colora[i])*(255.f))+(0.5f)));
    texel = fetch_from_gpu_buffer_1f_direct(((vData).sel(X,Y))+(make_ivec2((offset)+((k)/(4)), 0)));
    colora[i] = clamp(texel[(k)%(4)], 0.f, 1.f);
    offset = (offset)+(64);
    break;
   case 3:
    texel = fetch_from_gpu_buffer_1f_direct(((vData).sel(X,Y))+(make_ivec2(offset, 0)));
    colora[i] = clamp(((texel[0])*(colora[i]))+(texel[1]), 0.f, 1.f);
    offset = (offset)+(1);
    break;
   case 4:
    texel = fetch_from_gpu_buffer_1f_direct(((vData).sel(X,Y))+(make_ivec2(offset, 0)));
    colora[i] = clamp(((texel[0])*(pow(colora[i], texel[1])))+(texel[2]), 0.f, 1.f);
    offset = (offset)+(1);
    break;
   default:
    break;
  }
 }
 return colora;
}
vec4 composite(vec4 Cs, vec4 Cb, int32_t mode) {
 vec4 Cr = make_vec4(0.f, 1.f, 0.f, 1.f);
 switch (mode) {
  case 0:
   (Cr).lsel(R,G,B) = (((Cs).w)*((Cs).sel(R,G,B)))+((((Cb).w)*((Cb).sel(R,G,B)))*((1.f)-((Cs).w)));
   (Cr).w = ((Cs).w)+(((Cb).w)*((1.f)-((Cs).w)));
   break;
  case 1:
   (Cr).lsel(R,G,B) = (((Cs).w)*((Cs).sel(R,G,B)))*((Cb).w);
   (Cr).w = ((Cs).w)*((Cb).w);
   break;
  case 2:
   (Cr).lsel(R,G,B) = (((Cs).w)*((Cs).sel(R,G,B)))*((1.f)-((Cb).w));
   (Cr).w = ((Cs).w)*((1.f)-((Cb).w));
   break;
  case 3:
   (Cr).lsel(R,G,B) = ((((Cs).w)*((Cs).sel(R,G,B)))*((Cb).w))+((((Cb).w)*((Cb).sel(R,G,B)))*((1.f)-((Cs).w)));
   (Cr).w = (((Cs).w)*((Cb).w))+(((Cb).w)*((1.f)-((Cs).w)));
   break;
  case 4:
   (Cr).lsel(R,G,B) = ((((Cs).w)*((Cs).sel(R,G,B)))*((1.f)-((Cb).w)))+((((Cb).w)*((Cb).sel(R,G,B)))*((1.f)-((Cs).w)));
   (Cr).w = (((Cs).w)*((1.f)-((Cb).w)))+(((Cb).w)*((1.f)-((Cs).w)));
   break;
  case 5:
   (Cr).lsel(R,G,B) = (((Cs).w)*((Cs).sel(R,G,B)))+(((Cb).w)*((Cb).sel(R,G,B)));
   (Cr).w = ((Cs).w)+((Cb).w);
   Cr = clamp(Cr, make_vec4(0.f), make_vec4(1.f));
   break;
  case 6:
   Cr = (((((make_vec4((vFilterData0).x))*(Cs))*(Cb))+((make_vec4((vFilterData0).y))*(Cs)))+((make_vec4((vFilterData0).z))*(Cb)))+(make_vec4((vFilterData0).w));
   Cr = clamp(Cr, make_vec4(0.f), make_vec4(1.f));
   break;
  default:
   break;
 }
 return Cr;
}
ALWAYS_INLINE void main(void) {
 vec4 Ca = make_vec4(0.f, 0.f, 0.f, 0.f);
 vec4 Cb = make_vec4(0.f, 0.f, 0.f, 0.f);
 if (((vFilterInputCountFilterKindVec).x)>(0)) {
  {
   Ca = sampleInUvRect(sColor0, vInput1Uv, vInput1UvRect);
   auto _c3_ = ((Ca).w)!=(0.f);
   {
    (Ca).lsel(R,G,B) = if_then_else(_c3_,(Ca).sel(R,G,B)/(Ca).w,(Ca).sel(R,G,B));
   }
  }
 }
 if (((vFilterInputCountFilterKindVec).x)>(1)) {
  {
   Cb = sampleInUvRect(sColor1, vInput2Uv, vInput2UvRect);
   auto _c4_ = ((Cb).w)!=(0.f);
   {
    (Cb).lsel(R,G,B) = if_then_else(_c4_,(Cb).sel(R,G,B)/(Cb).w,(Cb).sel(R,G,B));
   }
  }
 }
 vec4 result = make_vec4(1.f, 0.f, 0.f, 1.f);
 bool needsPremul = true;
 switch ((vFilterInputCountFilterKindVec).y) {
  case 0:
   result = blend(Ca, Cb, (vData).x);
   needsPremul = false;
   break;
  case 1:
   result = vFilterData0;
   needsPremul = false;
   break;
  case 2:
   (result).lsel(R,G,B) = LinearToSrgb((Ca).sel(R,G,B));
   (result).w = (Ca).w;
   break;
  case 3:
   (result).lsel(R,G,B) = SrgbToLinear((Ca).sel(R,G,B));
   (result).w = (Ca).w;
   break;
  case 4:
   (result).lsel(R,G,B) = (Ca).sel(R,G,B);
   (result).w = ((Ca).w)*((vFloat0).x);
   break;
  case 5:
   result = ((vColorMat)*(Ca))+(vFilterData0);
   result = clamp(result, make_vec4(0.f), make_vec4(1.f));
   break;
  case 6:
   {
    vec4 shadow = make_vec4((vFilterData0).sel(R,G,B), ((Cb).w)*((vFilterData0).w));
    result = blend(Ca, shadow, BlendMode_Normal);
    needsPremul = false;
    break;
    }
  case 7:
   {
    vec2 offsetUv = (vInput1Uv)+((vFilterData0).sel(X,Y));
    result = sampleInUvRect(sColor0, offsetUv, vInput1UvRect);
    result *= point_inside_rect(offsetUv, (vFilterData1).sel(X,Y), (vFilterData1).sel(Z,W));
    needsPremul = false;
    break;
    }
  case 8:
   result = ComponentTransfer(Ca);
   break;
  case 9:
   result = Ca;
   break;
  case 10:
   result = composite(Ca, Cb, (vData).x);
   needsPremul = false;
  default:
   break;
 }
 if (needsPremul) {
  {
   (result).lsel(R,G,B) *= (result).w;
  }
 }
 oFragColor = result;
}
typedef cs_svg_filter_vert::InterpOutputs InterpInputs;
InterpInputs interp_step;
struct InterpPerspective {
vec2 vInput1Uv;
vec2 vInput2Uv;
};
InterpPerspective interp_perspective;
static void read_interp_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  self->vInput1Uv = init_interp(init->vInput1Uv, step->vInput1Uv);
  self->interp_step.vInput1Uv = step->vInput1Uv * 4.0f;
  self->vInput2Uv = init_interp(init->vInput2Uv, step->vInput2Uv);
  self->interp_step.vInput2Uv = step->vInput2Uv * 4.0f;
}
static void read_perspective_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  Float w = 1.0f / self->gl_FragCoord.w;
  self->interp_perspective.vInput1Uv = init_interp(init->vInput1Uv, step->vInput1Uv);
  self->vInput1Uv = self->interp_perspective.vInput1Uv * w;
  self->interp_step.vInput1Uv = step->vInput1Uv * 4.0f;
  self->interp_perspective.vInput2Uv = init_interp(init->vInput2Uv, step->vInput2Uv);
  self->vInput2Uv = self->interp_perspective.vInput2Uv * w;
  self->interp_step.vInput2Uv = step->vInput2Uv * 4.0f;
}
ALWAYS_INLINE void step_interp_inputs(int steps = 4) {
  float chunks = steps * 0.25f;
  vInput1Uv += interp_step.vInput1Uv * chunks;
  vInput2Uv += interp_step.vInput2Uv * chunks;
}
ALWAYS_INLINE void step_perspective_inputs(int steps = 4) {
  step_perspective(steps);
  float chunks = steps * 0.25f;
  Float w = 1.0f / gl_FragCoord.w;
  interp_perspective.vInput1Uv += interp_step.vInput1Uv * chunks;
  vInput1Uv = w * interp_perspective.vInput1Uv;
  interp_perspective.vInput2Uv += interp_step.vInput2Uv * chunks;
  vInput2Uv = w * interp_perspective.vInput2Uv;
}
static void run(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_interp_inputs();
}
static void skip(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_interp_inputs(steps);
}
static void run_perspective(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_perspective_inputs();
}
static void skip_perspective(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_perspective_inputs(steps);
}
public:
cs_svg_filter_frag() {
 init_span_func = &read_interp_inputs;
 run_func = &run;
 skip_func = &skip;
 enable_perspective();
 init_span_w_func = &read_perspective_inputs;
 run_w_func = &run_perspective;
 skip_w_func = &skip_perspective;
}
};

struct cs_svg_filter_program : ProgramImpl, cs_svg_filter_frag {
int get_uniform(const char *name) const override {
 if (strcmp("sClipMask", name) == 0) { return 8; }
 if (strcmp("sColor0", name) == 0) { return 9; }
 if (strcmp("sColor1", name) == 0) { return 10; }
 if (strcmp("sGpuBufferF", name) == 0) { return 3; }
 if (strcmp("sGpuBufferI", name) == 0) { return 4; }
 if (strcmp("sPrimitiveHeadersF", name) == 0) { return 5; }
 if (strcmp("sPrimitiveHeadersI", name) == 0) { return 6; }
 if (strcmp("sRenderTasks", name) == 0) { return 1; }
 if (strcmp("sTransformPalette", name) == 0) { return 2; }
 if (strcmp("uTransform", name) == 0) { return 7; }
 return -1;
}
void bind_attrib(const char* name, int index) override {
 attrib_locations.bind_loc(name, index);
}
int get_attrib(const char* name) const override {
 return attrib_locations.get_loc(name);
}
size_t interpolants_size() const override { return sizeof(InterpOutputs); }
VertexShaderImpl* get_vertex_shader() override {
 return this;
}
FragmentShaderImpl* get_fragment_shader() override {
 return this;
}
const char* get_name() const override { return "cs_svg_filter"; }
static ProgramImpl* loader() { return new cs_svg_filter_program; }
};

int32_t constexpr cs_svg_filter_frag::BlendMode_Normal;
int32_t constexpr cs_svg_filter_frag::BlendMode_Multiply;
int32_t constexpr cs_svg_filter_frag::BlendMode_Screen;
int32_t constexpr cs_svg_filter_frag::BlendMode_Overlay;
int32_t constexpr cs_svg_filter_frag::BlendMode_Darken;
int32_t constexpr cs_svg_filter_frag::BlendMode_Lighten;
int32_t constexpr cs_svg_filter_frag::BlendMode_ColorDodge;
int32_t constexpr cs_svg_filter_frag::BlendMode_ColorBurn;
int32_t constexpr cs_svg_filter_frag::BlendMode_HardLight;
int32_t constexpr cs_svg_filter_frag::BlendMode_SoftLight;
int32_t constexpr cs_svg_filter_frag::BlendMode_Difference;
int32_t constexpr cs_svg_filter_frag::BlendMode_Exclusion;
int32_t constexpr cs_svg_filter_frag::BlendMode_Hue;
int32_t constexpr cs_svg_filter_frag::BlendMode_Saturation;
int32_t constexpr cs_svg_filter_frag::BlendMode_Color;
int32_t constexpr cs_svg_filter_frag::BlendMode_Luminosity;
