struct cs_blur_ALPHA_TARGET_common {
struct Samplers {
 sampler2D_impl sClipMask_impl;
 int sClipMask_slot;
 sampler2D_impl sColor0_impl;
 int sColor0_slot;
 sampler2D_impl sGpuBufferF_impl;
 int sGpuBufferF_slot;
 isampler2D_impl sGpuBufferI_impl;
 int sGpuBufferI_slot;
 sampler2D_impl sPrimitiveHeadersF_impl;
 int sPrimitiveHeadersF_slot;
 isampler2D_impl sPrimitiveHeadersI_impl;
 int sPrimitiveHeadersI_slot;
 sampler2D_impl sRenderTasks_impl;
 int sRenderTasks_slot;
 sampler2D_impl sTransformPalette_impl;
 int sTransformPalette_slot;
 bool set_slot(int index, int value) {
  switch (index) {
  case 8:
   sClipMask_slot = value;
   return true;
  case 9:
   sColor0_slot = value;
   return true;
  case 3:
   sGpuBufferF_slot = value;
   return true;
  case 4:
   sGpuBufferI_slot = value;
   return true;
  case 5:
   sPrimitiveHeadersF_slot = value;
   return true;
  case 6:
   sPrimitiveHeadersI_slot = value;
   return true;
  case 1:
   sRenderTasks_slot = value;
   return true;
  case 2:
   sTransformPalette_slot = value;
   return true;
  }
  return false;
 }
} samplers;
struct AttribLocations {
 int aPosition = NULL_ATTRIB;
 int aData = NULL_ATTRIB;
 int aBlurRenderTaskAddress = NULL_ATTRIB;
 int aBlurSourceTaskAddress = NULL_ATTRIB;
 int aBlurDirection = NULL_ATTRIB;
 int aBlurEdgeMode = NULL_ATTRIB;
 int aBlurParams = NULL_ATTRIB;
 void bind_loc(const char* name, int index) {
  if (strcmp("aPosition", name) == 0) { aPosition = index; return; }
  if (strcmp("aData", name) == 0) { aData = index; return; }
  if (strcmp("aBlurRenderTaskAddress", name) == 0) { aBlurRenderTaskAddress = index; return; }
  if (strcmp("aBlurSourceTaskAddress", name) == 0) { aBlurSourceTaskAddress = index; return; }
  if (strcmp("aBlurDirection", name) == 0) { aBlurDirection = index; return; }
  if (strcmp("aBlurEdgeMode", name) == 0) { aBlurEdgeMode = index; return; }
  if (strcmp("aBlurParams", name) == 0) { aBlurParams = index; return; }
 }
 int get_loc(const char* name) const {
  if (strcmp("aPosition", name) == 0) { return aPosition != NULL_ATTRIB ? aPosition : -1; }
  if (strcmp("aData", name) == 0) { return aData != NULL_ATTRIB ? aData : -1; }
  if (strcmp("aBlurRenderTaskAddress", name) == 0) { return aBlurRenderTaskAddress != NULL_ATTRIB ? aBlurRenderTaskAddress : -1; }
  if (strcmp("aBlurSourceTaskAddress", name) == 0) { return aBlurSourceTaskAddress != NULL_ATTRIB ? aBlurSourceTaskAddress : -1; }
  if (strcmp("aBlurDirection", name) == 0) { return aBlurDirection != NULL_ATTRIB ? aBlurDirection : -1; }
  if (strcmp("aBlurEdgeMode", name) == 0) { return aBlurEdgeMode != NULL_ATTRIB ? aBlurEdgeMode : -1; }
  if (strcmp("aBlurParams", name) == 0) { return aBlurParams != NULL_ATTRIB ? aBlurParams : -1; }
  return -1;
 }
} attrib_locations;
vec4_scalar vTransformBounds;
vec4_scalar vUvRect;
vec4_scalar vUvClampRect;
vec2_scalar vOffsetScale;
ivec2_scalar vSupport;
vec2_scalar vGaussCoefficients;
sampler2D sClipMask;
sampler2D sColor0;
sampler2D sGpuBufferF;
isampler2D sGpuBufferI;
sampler2D sPrimitiveHeadersF;
isampler2D sPrimitiveHeadersI;
sampler2D sRenderTasks;
sampler2D sTransformPalette;
mat4_scalar uTransform;
void bind_textures() {
 sClipMask = lookup_sampler(&samplers.sClipMask_impl, samplers.sClipMask_slot);
 sColor0 = lookup_sampler(&samplers.sColor0_impl, samplers.sColor0_slot);
 sGpuBufferF = lookup_sampler(&samplers.sGpuBufferF_impl, samplers.sGpuBufferF_slot);
 sGpuBufferI = lookup_isampler(&samplers.sGpuBufferI_impl, samplers.sGpuBufferI_slot);
 sPrimitiveHeadersF = lookup_sampler(&samplers.sPrimitiveHeadersF_impl, samplers.sPrimitiveHeadersF_slot);
 sPrimitiveHeadersI = lookup_isampler(&samplers.sPrimitiveHeadersI_impl, samplers.sPrimitiveHeadersI_slot);
 sRenderTasks = lookup_sampler(&samplers.sRenderTasks_impl, samplers.sRenderTasks_slot);
 sTransformPalette = lookup_sampler(&samplers.sTransformPalette_impl, samplers.sTransformPalette_slot);
}
};
struct cs_blur_ALPHA_TARGET_vert : VertexShaderImpl, cs_blur_ALPHA_TARGET_common {
private:
typedef cs_blur_ALPHA_TARGET_vert Self;
// mat4_scalar uTransform;
vec2 aPosition;
// sampler2D sColor0;
// sampler2D sColor1;
// sampler2D sColor2;
struct RectWithSize_scalar {
vec2_scalar p0;
vec2_scalar size;
RectWithSize_scalar() = default;
RectWithSize_scalar(vec2_scalar p0, vec2_scalar size) : p0(p0), size(size){}
};
struct RectWithSize {
vec2 p0;
vec2 size;
RectWithSize() = default;
RectWithSize(vec2 p0, vec2 size) : p0(p0), size(size){}
RectWithSize(vec2_scalar p0, vec2_scalar size):p0(p0),size(size){
}
IMPLICIT RectWithSize(RectWithSize_scalar s):p0(s.p0),size(s.size){
}
friend RectWithSize if_then_else(I32 c, RectWithSize t, RectWithSize e) { return RectWithSize(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.size, e.size));
}};
struct RectWithEndpoint_scalar {
vec2_scalar p0;
vec2_scalar p1;
RectWithEndpoint_scalar() = default;
RectWithEndpoint_scalar(vec2_scalar p0, vec2_scalar p1) : p0(p0), p1(p1){}
};
struct RectWithEndpoint {
vec2 p0;
vec2 p1;
RectWithEndpoint() = default;
RectWithEndpoint(vec2 p0, vec2 p1) : p0(p0), p1(p1){}
RectWithEndpoint(vec2_scalar p0, vec2_scalar p1):p0(p0),p1(p1){
}
IMPLICIT RectWithEndpoint(RectWithEndpoint_scalar s):p0(s.p0),p1(s.p1){
}
friend RectWithEndpoint if_then_else(I32 c, RectWithEndpoint t, RectWithEndpoint e) { return RectWithEndpoint(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.p1, e.p1));
}};
// sampler2D sRenderTasks;
struct RenderTaskData_scalar {
RectWithEndpoint_scalar task_rect;
vec4_scalar user_data;
RenderTaskData_scalar() = default;
RenderTaskData_scalar(RectWithEndpoint_scalar task_rect, vec4_scalar user_data) : task_rect(task_rect), user_data(user_data){}
};
struct RenderTaskData {
RectWithEndpoint task_rect;
vec4 user_data;
RenderTaskData() = default;
RenderTaskData(RectWithEndpoint task_rect, vec4 user_data) : task_rect(task_rect), user_data(user_data){}
RenderTaskData(RectWithEndpoint_scalar task_rect, vec4_scalar user_data):task_rect(task_rect),user_data(user_data){
}
IMPLICIT RenderTaskData(RenderTaskData_scalar s):task_rect(s.task_rect),user_data(s.user_data){
}
friend RenderTaskData if_then_else(I32 c, RenderTaskData t, RenderTaskData e) { return RenderTaskData(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.user_data, e.user_data));
}};
struct PictureTask_scalar {
RectWithEndpoint_scalar task_rect;
float device_pixel_scale;
vec2_scalar content_origin;
PictureTask_scalar() = default;
PictureTask_scalar(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar content_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), content_origin(content_origin){}
};
struct PictureTask {
RectWithEndpoint task_rect;
Float device_pixel_scale;
vec2 content_origin;
PictureTask() = default;
PictureTask(RectWithEndpoint task_rect, Float device_pixel_scale, vec2 content_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), content_origin(content_origin){}
PictureTask(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar content_origin):task_rect(task_rect),device_pixel_scale(device_pixel_scale),content_origin(content_origin){
}
IMPLICIT PictureTask(PictureTask_scalar s):task_rect(s.task_rect),device_pixel_scale(s.device_pixel_scale),content_origin(s.content_origin){
}
friend PictureTask if_then_else(I32 c, PictureTask t, PictureTask e) { return PictureTask(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.device_pixel_scale, e.device_pixel_scale), if_then_else(c, t.content_origin, e.content_origin));
}};
struct ClipArea_scalar {
RectWithEndpoint_scalar task_rect;
float device_pixel_scale;
vec2_scalar screen_origin;
ClipArea_scalar() = default;
ClipArea_scalar(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar screen_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), screen_origin(screen_origin){}
};
struct ClipArea {
RectWithEndpoint task_rect;
Float device_pixel_scale;
vec2 screen_origin;
ClipArea() = default;
ClipArea(RectWithEndpoint task_rect, Float device_pixel_scale, vec2 screen_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), screen_origin(screen_origin){}
ClipArea(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar screen_origin):task_rect(task_rect),device_pixel_scale(device_pixel_scale),screen_origin(screen_origin){
}
IMPLICIT ClipArea(ClipArea_scalar s):task_rect(s.task_rect),device_pixel_scale(s.device_pixel_scale),screen_origin(s.screen_origin){
}
friend ClipArea if_then_else(I32 c, ClipArea t, ClipArea e) { return ClipArea(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.device_pixel_scale, e.device_pixel_scale), if_then_else(c, t.screen_origin, e.screen_origin));
}};
// vec4_scalar vTransformBounds;
// sampler2D sTransformPalette;
struct Transform_scalar {
mat4_scalar m;
mat4_scalar inv_m;
bool is_axis_aligned;
Transform_scalar() = default;
Transform_scalar(mat4_scalar m, mat4_scalar inv_m, bool is_axis_aligned) : m(m), inv_m(inv_m), is_axis_aligned(is_axis_aligned){}
};
struct Transform {
mat4 m;
mat4 inv_m;
Bool is_axis_aligned;
Transform() = default;
Transform(mat4 m, mat4 inv_m, Bool is_axis_aligned) : m(m), inv_m(inv_m), is_axis_aligned(is_axis_aligned){}
Transform(mat4_scalar m, mat4_scalar inv_m, bool is_axis_aligned):m(m),inv_m(inv_m),is_axis_aligned(is_axis_aligned){
}
IMPLICIT Transform(Transform_scalar s):m(s.m),inv_m(s.inv_m),is_axis_aligned(s.is_axis_aligned){
}
friend Transform if_then_else(I32 c, Transform t, Transform e) { return Transform(
if_then_else(c, t.m, e.m), if_then_else(c, t.inv_m, e.inv_m), if_then_else(c, t.is_axis_aligned, e.is_axis_aligned));
}};
// sampler2D sGpuBufferF;
// isampler2D sGpuBufferI;
struct ImageSource_scalar {
RectWithEndpoint_scalar uv_rect;
vec4_scalar user_data;
ImageSource_scalar() = default;
ImageSource_scalar(RectWithEndpoint_scalar uv_rect, vec4_scalar user_data) : uv_rect(uv_rect), user_data(user_data){}
};
struct ImageSource {
RectWithEndpoint uv_rect;
vec4 user_data;
ImageSource() = default;
ImageSource(RectWithEndpoint uv_rect, vec4 user_data) : uv_rect(uv_rect), user_data(user_data){}
ImageSource(RectWithEndpoint_scalar uv_rect, vec4_scalar user_data):uv_rect(uv_rect),user_data(user_data){
}
IMPLICIT ImageSource(ImageSource_scalar s):uv_rect(s.uv_rect),user_data(s.user_data){
}
friend ImageSource if_then_else(I32 c, ImageSource t, ImageSource e) { return ImageSource(
if_then_else(c, t.uv_rect, e.uv_rect), if_then_else(c, t.user_data, e.user_data));
}};
struct ImageSourceExtra_scalar {
vec4_scalar st_tl;
vec4_scalar st_tr;
vec4_scalar st_bl;
vec4_scalar st_br;
ImageSourceExtra_scalar() = default;
ImageSourceExtra_scalar(vec4_scalar st_tl, vec4_scalar st_tr, vec4_scalar st_bl, vec4_scalar st_br) : st_tl(st_tl), st_tr(st_tr), st_bl(st_bl), st_br(st_br){}
};
struct ImageSourceExtra {
vec4 st_tl;
vec4 st_tr;
vec4 st_bl;
vec4 st_br;
ImageSourceExtra() = default;
ImageSourceExtra(vec4 st_tl, vec4 st_tr, vec4 st_bl, vec4 st_br) : st_tl(st_tl), st_tr(st_tr), st_bl(st_bl), st_br(st_br){}
ImageSourceExtra(vec4_scalar st_tl, vec4_scalar st_tr, vec4_scalar st_bl, vec4_scalar st_br):st_tl(st_tl),st_tr(st_tr),st_bl(st_bl),st_br(st_br){
}
IMPLICIT ImageSourceExtra(ImageSourceExtra_scalar s):st_tl(s.st_tl),st_tr(s.st_tr),st_bl(s.st_bl),st_br(s.st_br){
}
friend ImageSourceExtra if_then_else(I32 c, ImageSourceExtra t, ImageSourceExtra e) { return ImageSourceExtra(
if_then_else(c, t.st_tl, e.st_tl), if_then_else(c, t.st_tr, e.st_tr), if_then_else(c, t.st_bl, e.st_bl), if_then_else(c, t.st_br, e.st_br));
}};
// sampler2D sClipMask;
// sampler2D sPrimitiveHeadersF;
// isampler2D sPrimitiveHeadersI;
ivec4_scalar aData;
struct Instance_scalar {
int32_t prim_header_address;
int32_t clip_address;
int32_t segment_index;
int32_t flags;
int32_t resource_address;
int32_t brush_kind;
Instance_scalar() = default;
Instance_scalar(int32_t prim_header_address, int32_t clip_address, int32_t segment_index, int32_t flags, int32_t resource_address, int32_t brush_kind) : prim_header_address(prim_header_address), clip_address(clip_address), segment_index(segment_index), flags(flags), resource_address(resource_address), brush_kind(brush_kind){}
};
struct Instance {
I32 prim_header_address;
I32 clip_address;
I32 segment_index;
I32 flags;
I32 resource_address;
I32 brush_kind;
Instance() = default;
Instance(I32 prim_header_address, I32 clip_address, I32 segment_index, I32 flags, I32 resource_address, I32 brush_kind) : prim_header_address(prim_header_address), clip_address(clip_address), segment_index(segment_index), flags(flags), resource_address(resource_address), brush_kind(brush_kind){}
Instance(int32_t prim_header_address, int32_t clip_address, int32_t segment_index, int32_t flags, int32_t resource_address, int32_t brush_kind):prim_header_address(prim_header_address),clip_address(clip_address),segment_index(segment_index),flags(flags),resource_address(resource_address),brush_kind(brush_kind){
}
IMPLICIT Instance(Instance_scalar s):prim_header_address(s.prim_header_address),clip_address(s.clip_address),segment_index(s.segment_index),flags(s.flags),resource_address(s.resource_address),brush_kind(s.brush_kind){
}
friend Instance if_then_else(I32 c, Instance t, Instance e) { return Instance(
if_then_else(c, t.prim_header_address, e.prim_header_address), if_then_else(c, t.clip_address, e.clip_address), if_then_else(c, t.segment_index, e.segment_index), if_then_else(c, t.flags, e.flags), if_then_else(c, t.resource_address, e.resource_address), if_then_else(c, t.brush_kind, e.brush_kind));
}};
struct PrimitiveHeader_scalar {
RectWithEndpoint_scalar local_rect;
RectWithEndpoint_scalar local_clip_rect;
float z;
int32_t specific_prim_address;
int32_t transform_id;
int32_t picture_task_address;
ivec4_scalar user_data;
PrimitiveHeader_scalar() = default;
PrimitiveHeader_scalar(RectWithEndpoint_scalar local_rect, RectWithEndpoint_scalar local_clip_rect, float z, int32_t specific_prim_address, int32_t transform_id, int32_t picture_task_address, ivec4_scalar user_data) : local_rect(local_rect), local_clip_rect(local_clip_rect), z(z), specific_prim_address(specific_prim_address), transform_id(transform_id), picture_task_address(picture_task_address), user_data(user_data){}
};
struct PrimitiveHeader {
RectWithEndpoint local_rect;
RectWithEndpoint local_clip_rect;
Float z;
I32 specific_prim_address;
I32 transform_id;
I32 picture_task_address;
ivec4 user_data;
PrimitiveHeader() = default;
PrimitiveHeader(RectWithEndpoint local_rect, RectWithEndpoint local_clip_rect, Float z, I32 specific_prim_address, I32 transform_id, I32 picture_task_address, ivec4 user_data) : local_rect(local_rect), local_clip_rect(local_clip_rect), z(z), specific_prim_address(specific_prim_address), transform_id(transform_id), picture_task_address(picture_task_address), user_data(user_data){}
PrimitiveHeader(RectWithEndpoint_scalar local_rect, RectWithEndpoint_scalar local_clip_rect, float z, int32_t specific_prim_address, int32_t transform_id, int32_t picture_task_address, ivec4_scalar user_data):local_rect(local_rect),local_clip_rect(local_clip_rect),z(z),specific_prim_address(specific_prim_address),transform_id(transform_id),picture_task_address(picture_task_address),user_data(user_data){
}
IMPLICIT PrimitiveHeader(PrimitiveHeader_scalar s):local_rect(s.local_rect),local_clip_rect(s.local_clip_rect),z(s.z),specific_prim_address(s.specific_prim_address),transform_id(s.transform_id),picture_task_address(s.picture_task_address),user_data(s.user_data){
}
friend PrimitiveHeader if_then_else(I32 c, PrimitiveHeader t, PrimitiveHeader e) { return PrimitiveHeader(
if_then_else(c, t.local_rect, e.local_rect), if_then_else(c, t.local_clip_rect, e.local_clip_rect), if_then_else(c, t.z, e.z), if_then_else(c, t.specific_prim_address, e.specific_prim_address), if_then_else(c, t.transform_id, e.transform_id), if_then_else(c, t.picture_task_address, e.picture_task_address), if_then_else(c, t.user_data, e.user_data));
}};
struct VertexInfo_scalar {
vec2_scalar local_pos;
vec4_scalar world_pos;
VertexInfo_scalar() = default;
VertexInfo_scalar(vec2_scalar local_pos, vec4_scalar world_pos) : local_pos(local_pos), world_pos(world_pos){}
};
struct VertexInfo {
vec2 local_pos;
vec4 world_pos;
VertexInfo() = default;
VertexInfo(vec2 local_pos, vec4 world_pos) : local_pos(local_pos), world_pos(world_pos){}
VertexInfo(vec2_scalar local_pos, vec4_scalar world_pos):local_pos(local_pos),world_pos(world_pos){
}
IMPLICIT VertexInfo(VertexInfo_scalar s):local_pos(s.local_pos),world_pos(s.world_pos){
}
friend VertexInfo if_then_else(I32 c, VertexInfo t, VertexInfo e) { return VertexInfo(
if_then_else(c, t.local_pos, e.local_pos), if_then_else(c, t.world_pos, e.world_pos));
}};
vec2 vUv;
// vec4_scalar vUvRect;
// vec4_scalar vUvClampRect;
// vec2_scalar vOffsetScale;
// ivec2_scalar vSupport;
// vec2_scalar vGaussCoefficients;
int32_t aBlurRenderTaskAddress;
int32_t aBlurSourceTaskAddress;
int32_t aBlurDirection;
int32_t aBlurEdgeMode;
vec3_scalar aBlurParams;
struct BlurTask_scalar {
RectWithEndpoint_scalar task_rect;
float blur_radius;
vec2_scalar blur_region;
BlurTask_scalar() = default;
BlurTask_scalar(RectWithEndpoint_scalar task_rect, float blur_radius, vec2_scalar blur_region) : task_rect(task_rect), blur_radius(blur_radius), blur_region(blur_region){}
};
struct BlurTask {
RectWithEndpoint task_rect;
Float blur_radius;
vec2 blur_region;
BlurTask() = default;
BlurTask(RectWithEndpoint task_rect, Float blur_radius, vec2 blur_region) : task_rect(task_rect), blur_radius(blur_radius), blur_region(blur_region){}
BlurTask(RectWithEndpoint_scalar task_rect, float blur_radius, vec2_scalar blur_region):task_rect(task_rect),blur_radius(blur_radius),blur_region(blur_region){
}
IMPLICIT BlurTask(BlurTask_scalar s):task_rect(s.task_rect),blur_radius(s.blur_radius),blur_region(s.blur_region){
}
friend BlurTask if_then_else(I32 c, BlurTask t, BlurTask e) { return BlurTask(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.blur_radius, e.blur_radius), if_then_else(c, t.blur_region, e.blur_region));
}};
RectWithEndpoint_scalar fetch_render_task_rect(int32_t index) {
 ivec2_scalar uv = make_ivec2(make_int((2u)*((make_uint(index))%((1024u)/(2u)))), make_int((make_uint(index))/((1024u)/(2u))));
 auto sRenderTasks_uv_fetch = texelFetchPtr(sRenderTasks, uv, 0, 1, 0, 0);
 vec4_scalar texel0 = texelFetchUnchecked(sRenderTasks, sRenderTasks_uv_fetch, 0, 0);
 vec4_scalar texel1 = texelFetchUnchecked(sRenderTasks, sRenderTasks_uv_fetch, 1, 0);
 RectWithEndpoint_scalar task_rect = RectWithEndpoint_scalar((texel0).sel(X,Y), (texel0).sel(Z,W));
 return task_rect;
}
BlurTask_scalar fetch_blur_task(int32_t address) {
 RectWithEndpoint_scalar task_rect = fetch_render_task_rect(address);
 BlurTask_scalar task = BlurTask_scalar(task_rect, (aBlurParams).x, (aBlurParams).sel(Y,Z));
 return task;
}
void calculate_gauss_coefficients(float sigma) {
 vGaussCoefficients = make_vec2((1.f)/((sqrt((2.f)*(3.1415927f)))*(sigma)), exp((-(0.5f))/((sigma)*(sigma))));
 vec3_scalar gauss_coefficient = make_vec3(vGaussCoefficients, ((vGaussCoefficients).y)*((vGaussCoefficients).y));
 float gauss_coefficient_total = (gauss_coefficient).x;
 for ( int32_t i = 1;
(i)<=((vSupport).x); i += 2)  {
  (gauss_coefficient).lsel(X,Y) *= (gauss_coefficient).sel(Y,Z);
  float gauss_coefficient_subtotal = (gauss_coefficient).x;
  (gauss_coefficient).lsel(X,Y) *= (gauss_coefficient).sel(Y,Z);
  gauss_coefficient_subtotal += (gauss_coefficient).x;
  gauss_coefficient_total += (2.f)*(gauss_coefficient_subtotal);
 }
 (vGaussCoefficients).x /= gauss_coefficient_total;
}
ALWAYS_INLINE void main(void) {
 BlurTask_scalar blur_task = fetch_blur_task(aBlurRenderTaskAddress);
 RectWithEndpoint_scalar src_rect = fetch_render_task_rect(aBlurSourceTaskAddress);
 RectWithEndpoint_scalar target_rect = (blur_task).task_rect;
 vec2_scalar texture_size = make_vec2((textureSize(sColor0, 0)).sel(X,Y));
 (vSupport).x = (make_int(ceil((1.5f)*((blur_task).blur_radius))))*(2);
 (vSupport).y = aBlurEdgeMode;
 if (((vSupport).x)>(0)) {
  {
   calculate_gauss_coefficients((blur_task).blur_radius);
  }
 } else  {
  vGaussCoefficients = make_vec2(1.f, 1.f);
 }
 switch (aBlurDirection) {
  case 0:
   vOffsetScale = make_vec2((1.f)/((((src_rect).p1).x)-(((src_rect).p0).x)), 0.f);
   break;
  case 1:
   vOffsetScale = make_vec2(0.f, (1.f)/((((src_rect).p1).y)-(((src_rect).p0).y)));
   break;
  default:
   vOffsetScale = make_vec2(0.f);
 }
 vUvRect = make_vec4((src_rect).p0, (src_rect).p1);
 vUvRect /= (texture_size).sel(X,Y,X,Y);
 vUvClampRect = make_vec4(((src_rect).p0)+(make_vec2(0.5f)), (((src_rect).p0)+((blur_task).blur_region))-(make_vec2(0.5f)));
 vUvClampRect /= (texture_size).sel(X,Y,X,Y);
 vec2 pos = mix((target_rect).p0, (target_rect).p1, (aPosition).sel(X,Y));
 vUv = (aPosition).sel(X,Y);
 gl_Position = (uTransform)*(make_vec4(pos, 0.f, 1.f));
}
static void set_uniform_1i(VertexShaderImpl* impl, int index, int value) {
 Self* self = (Self*)impl;
 if (self->samplers.set_slot(index, value)) return;
 switch (index) {
 case 8:
  assert(0); // sClipMask
  break;
 case 9:
  assert(0); // sColor0
  break;
 case 3:
  assert(0); // sGpuBufferF
  break;
 case 4:
  assert(0); // sGpuBufferI
  break;
 case 5:
  assert(0); // sPrimitiveHeadersF
  break;
 case 6:
  assert(0); // sPrimitiveHeadersI
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 2:
  assert(0); // sTransformPalette
  break;
 case 7:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 8:
  assert(0); // sClipMask
  break;
 case 9:
  assert(0); // sColor0
  break;
 case 3:
  assert(0); // sGpuBufferF
  break;
 case 4:
  assert(0); // sGpuBufferI
  break;
 case 5:
  assert(0); // sPrimitiveHeadersF
  break;
 case 6:
  assert(0); // sPrimitiveHeadersI
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 2:
  assert(0); // sTransformPalette
  break;
 case 7:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_matrix4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 8:
  assert(0); // sClipMask
  break;
 case 9:
  assert(0); // sColor0
  break;
 case 3:
  assert(0); // sGpuBufferF
  break;
 case 4:
  assert(0); // sGpuBufferI
  break;
 case 5:
  assert(0); // sPrimitiveHeadersF
  break;
 case 6:
  assert(0); // sPrimitiveHeadersI
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 2:
  assert(0); // sTransformPalette
  break;
 case 7:
  self->uTransform = mat4_scalar::load_from_ptr(value);
  break;
 }
}
static void load_attribs(VertexShaderImpl* impl, VertexAttrib *attribs, uint32_t start, int instance, int count) {Self* self = (Self*)impl;
 load_attrib(self->aPosition, attribs[self->attrib_locations.aPosition], start, instance, count);
 load_flat_attrib(self->aBlurRenderTaskAddress, attribs[self->attrib_locations.aBlurRenderTaskAddress], start, instance, count);
 load_flat_attrib(self->aBlurSourceTaskAddress, attribs[self->attrib_locations.aBlurSourceTaskAddress], start, instance, count);
 load_flat_attrib(self->aBlurDirection, attribs[self->attrib_locations.aBlurDirection], start, instance, count);
 load_flat_attrib(self->aBlurEdgeMode, attribs[self->attrib_locations.aBlurEdgeMode], start, instance, count);
 load_flat_attrib(self->aBlurParams, attribs[self->attrib_locations.aBlurParams], start, instance, count);
}
public:
struct InterpOutputs {
vec2_scalar vUv;
};
private:
ALWAYS_INLINE void store_interp_outputs(char* dest_ptr, size_t stride) {
  for(int n = 0; n < 4; n++) {
    auto* dest = reinterpret_cast<InterpOutputs*>(dest_ptr);
    dest->vUv = get_nth(vUv, n);
    dest_ptr += stride;
  }
}
static void run(VertexShaderImpl* impl, char* interps, size_t interp_stride) {
 Self* self = (Self*)impl;
 self->main();
 self->store_interp_outputs(interps, interp_stride);
}
static void init_batch(VertexShaderImpl* impl) {
 Self* self = (Self*)impl; self->bind_textures(); }
public:
cs_blur_ALPHA_TARGET_vert() {
 set_uniform_1i_func = &set_uniform_1i;
 set_uniform_4fv_func = &set_uniform_4fv;
 set_uniform_matrix4fv_func = &set_uniform_matrix4fv;
 init_batch_func = &init_batch;
 load_attribs_func = &load_attribs;
 run_primitive_func = &run;
}
};


struct cs_blur_ALPHA_TARGET_frag : FragmentShaderImpl, cs_blur_ALPHA_TARGET_vert {
private:
typedef cs_blur_ALPHA_TARGET_frag Self;
#define oFragColor gl_FragColor
// vec4 oFragColor;
// sampler2D sColor0;
// sampler2D sColor1;
// sampler2D sColor2;
struct RectWithSize_scalar {
vec2_scalar p0;
vec2_scalar size;
RectWithSize_scalar() = default;
RectWithSize_scalar(vec2_scalar p0, vec2_scalar size) : p0(p0), size(size){}
};
struct RectWithSize {
vec2 p0;
vec2 size;
RectWithSize() = default;
RectWithSize(vec2 p0, vec2 size) : p0(p0), size(size){}
RectWithSize(vec2_scalar p0, vec2_scalar size):p0(p0),size(size){
}
IMPLICIT RectWithSize(RectWithSize_scalar s):p0(s.p0),size(s.size){
}
friend RectWithSize if_then_else(I32 c, RectWithSize t, RectWithSize e) { return RectWithSize(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.size, e.size));
}};
struct RectWithEndpoint_scalar {
vec2_scalar p0;
vec2_scalar p1;
RectWithEndpoint_scalar() = default;
RectWithEndpoint_scalar(vec2_scalar p0, vec2_scalar p1) : p0(p0), p1(p1){}
};
struct RectWithEndpoint {
vec2 p0;
vec2 p1;
RectWithEndpoint() = default;
RectWithEndpoint(vec2 p0, vec2 p1) : p0(p0), p1(p1){}
RectWithEndpoint(vec2_scalar p0, vec2_scalar p1):p0(p0),p1(p1){
}
IMPLICIT RectWithEndpoint(RectWithEndpoint_scalar s):p0(s.p0),p1(s.p1){
}
friend RectWithEndpoint if_then_else(I32 c, RectWithEndpoint t, RectWithEndpoint e) { return RectWithEndpoint(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.p1, e.p1));
}};
// vec4_scalar vTransformBounds;
// sampler2D sGpuBufferF;
// isampler2D sGpuBufferI;
// sampler2D sClipMask;
struct Fragment_scalar {
vec4_scalar color;
Fragment_scalar() = default;
explicit Fragment_scalar(vec4_scalar color) : color(color){}
};
struct Fragment {
vec4 color;
Fragment() = default;
explicit Fragment(vec4 color) : color(color){}
explicit Fragment(vec4_scalar color):color(color){
}
IMPLICIT Fragment(Fragment_scalar s):color(s.color){
}
friend Fragment if_then_else(I32 c, Fragment t, Fragment e) { return Fragment(
if_then_else(c, t.color, e.color));
}};
vec2 vUv;
// vec4_scalar vUvRect;
// vec4_scalar vUvClampRect;
// vec2_scalar vOffsetScale;
// ivec2_scalar vSupport;
// vec2_scalar vGaussCoefficients;
vec2 mirrored_repeat(vec2 uv) {
 vec2 abs_uv = abs(uv);
 vec2 uv_int = floor(abs_uv);
 vec2 uv_frac = (abs_uv)-(uv_int);
 vec2 f = mod(uv_int, make_vec2(2.f));
 return mix(uv_frac, (make_vec2(1.f))-(uv_frac), f);
}
ALWAYS_INLINE void main(void) {
 vec2 uv = mix((vUvRect).sel(X,Y), (vUvRect).sel(Z,W), vUv);
 Float original_color = (texture(sColor0, uv)).x;
 vec3_scalar gauss_coefficient = make_vec3(vGaussCoefficients, ((vGaussCoefficients).y)*((vGaussCoefficients).y));
 Float avg_color = (original_color)*((gauss_coefficient).x);
 int32_t support = min((vSupport).x, 300);
 for ( int32_t i = 1;
(i)<=(support); i += 2)  {
  (gauss_coefficient).lsel(X,Y) *= (gauss_coefficient).sel(Y,Z);
  float gauss_coefficient_subtotal = (gauss_coefficient).x;
  (gauss_coefficient).lsel(X,Y) *= (gauss_coefficient).sel(Y,Z);
  gauss_coefficient_subtotal += (gauss_coefficient).x;
  float gauss_ratio = ((gauss_coefficient).x)/(gauss_coefficient_subtotal);
  vec2_scalar offset = (vOffsetScale)*((make_float(i))+(gauss_ratio));
  vec2 uv0 = (vUv)-(offset);
  vec2 uv1 = (vUv)+(offset);
  if (((vSupport).y)==(1)) {
   {
    uv0 = mirrored_repeat(uv0);
    uv1 = mirrored_repeat(uv1);
   }
  }
  uv0 = mix((vUvRect).sel(X,Y), (vUvRect).sel(Z,W), uv0);
  uv1 = mix((vUvRect).sel(X,Y), (vUvRect).sel(Z,W), uv1);
  uv0 = max(uv0, (vUvClampRect).sel(X,Y));
  uv1 = min(uv1, (vUvClampRect).sel(Z,W));
  avg_color += (((texture(sColor0, uv0)).x)+((texture(sColor0, uv1)).x))*(gauss_coefficient_subtotal);
 }
 oFragColor = make_vec4(avg_color);
}
void swgl_drawSpanR8() {
 vec2 uv = mix((vUvRect).sel(X,Y), (vUvRect).sel(Z,W), vUv);
 swgl_commitGaussianBlurR8(sColor0, uv, vUvClampRect, ((vOffsetScale).x)!=(0.f), (vSupport).x, vGaussCoefficients);
}
typedef cs_blur_ALPHA_TARGET_vert::InterpOutputs InterpInputs;
InterpInputs interp_step;
struct InterpPerspective {
vec2 vUv;
};
InterpPerspective interp_perspective;
static void read_interp_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  self->vUv = init_interp(init->vUv, step->vUv);
  self->interp_step.vUv = step->vUv * 4.0f;
}
static void read_perspective_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  Float w = 1.0f / self->gl_FragCoord.w;
  self->interp_perspective.vUv = init_interp(init->vUv, step->vUv);
  self->vUv = self->interp_perspective.vUv * w;
  self->interp_step.vUv = step->vUv * 4.0f;
}
ALWAYS_INLINE void step_interp_inputs(int steps = 4) {
  float chunks = steps * 0.25f;
  vUv += interp_step.vUv * chunks;
}
ALWAYS_INLINE void step_perspective_inputs(int steps = 4) {
  step_perspective(steps);
  float chunks = steps * 0.25f;
  Float w = 1.0f / gl_FragCoord.w;
  interp_perspective.vUv += interp_step.vUv * chunks;
  vUv = w * interp_perspective.vUv;
}
static void run(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_interp_inputs();
}
static void skip(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_interp_inputs(steps);
}
static void run_perspective(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_perspective_inputs();
}
static void skip_perspective(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_perspective_inputs(steps);
}
static int draw_span_R8(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl; DISPATCH_DRAW_SPAN(self, R8); }
public:
cs_blur_ALPHA_TARGET_frag() {
 init_span_func = &read_interp_inputs;
 run_func = &run;
 skip_func = &skip;
 draw_span_R8_func = &draw_span_R8;
 enable_perspective();
 init_span_w_func = &read_perspective_inputs;
 run_w_func = &run_perspective;
 skip_w_func = &skip_perspective;
}
};

struct cs_blur_ALPHA_TARGET_program : ProgramImpl, cs_blur_ALPHA_TARGET_frag {
int get_uniform(const char *name) const override {
 if (strcmp("sClipMask", name) == 0) { return 8; }
 if (strcmp("sColor0", name) == 0) { return 9; }
 if (strcmp("sGpuBufferF", name) == 0) { return 3; }
 if (strcmp("sGpuBufferI", name) == 0) { return 4; }
 if (strcmp("sPrimitiveHeadersF", name) == 0) { return 5; }
 if (strcmp("sPrimitiveHeadersI", name) == 0) { return 6; }
 if (strcmp("sRenderTasks", name) == 0) { return 1; }
 if (strcmp("sTransformPalette", name) == 0) { return 2; }
 if (strcmp("uTransform", name) == 0) { return 7; }
 return -1;
}
void bind_attrib(const char* name, int index) override {
 attrib_locations.bind_loc(name, index);
}
int get_attrib(const char* name) const override {
 return attrib_locations.get_loc(name);
}
size_t interpolants_size() const override { return sizeof(InterpOutputs); }
VertexShaderImpl* get_vertex_shader() override {
 return this;
}
FragmentShaderImpl* get_fragment_shader() override {
 return this;
}
const char* get_name() const override { return "cs_blur_ALPHA_TARGET"; }
static ProgramImpl* loader() { return new cs_blur_ALPHA_TARGET_program; }
};

