
#include "buildid_section.h"

#if defined(XP_DARWIN) || defined(XP_WIN)
#define SECTION_NAME_ATTRIBUTE __attribute__((section(MOZ_BUILDID_SECTION_NAME)))
#else
#define SECTION_NAME_ATTRIBUTE
#endif

extern const char gToolkitBuildID[] SECTION_NAME_ATTRIBUTE  = "20251121064229";

#include <elf.h>

#define note_name "mzbldid"
#define note_desc "20251121064229"

// This is not defined on Android?
// Android also hardcodes "1"
// https://android.googlesource.com/platform/ndk/+/refs/tags/ndk-r26c/sources/crt/crtbrand.S#35
#ifndef NT_VERSION
#define NT_VERSION 1
#endif

#if defined(__clang__)
#define NO_SANITIZE_ADDRESS __attribute__((no_sanitize("address")))
#else
// gcc doesn't sanitize address of const variable
#define NO_SANITIZE_ADDRESS
#endif

struct note {
    Elf32_Nhdr header; // Elf32 or Elf64 doesn't matter, they're the same size
    char name[(sizeof(note_name) + 3) / 4 * 4];
    char desc[(sizeof(note_desc) + 3) / 4 * 4];
};

extern const struct note gNoteToolkitBuildID NO_SANITIZE_ADDRESS __attribute__((section(MOZ_BUILDID_SECTION_NAME), aligned(4), used)) = {
    { sizeof(note_name), sizeof(note_desc), NT_VERSION },
    note_name,
    note_desc
};

