// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanJSMetricsLookup_h
#define mozilla_GleanJSMetricsLookup_h

#include <cstdint>

#include "mozilla/AlreadyAddRefed.h"
#include "mozilla/Maybe.h"
#include "mozilla/glean/bindings/GleanMetric.h"
#include "nsStringFwd.h"

class nsISupports;

namespace mozilla::glean {

enum MetricTypeId {
  BOOLEAN = 1,
  COUNTER = 2,
  CUSTOM_DISTRIBUTION = 3,
  DATETIME = 4,
  DENOMINATOR = 5,
  DUAL_LABELED_COUNTER = 6,
  EVENT = 7,
  LABELED_BOOLEAN = 8,
  LABELED_COUNTER = 9,
  LABELED_CUSTOM_DISTRIBUTION = 10,
  LABELED_MEMORY_DISTRIBUTION = 11,
  LABELED_QUANTITY = 12,
  LABELED_STRING = 13,
  LABELED_TIMING_DISTRIBUTION = 14,
  MEMORY_DISTRIBUTION = 15,
  NUMERATOR = 16,
  OBJECT = 17,
  QUANTITY = 18,
  RATE = 19,
  STRING = 20,
  STRING_LIST = 21,
  TEXT = 22,
  TIMESPAN = 23,
  TIMING_DISTRIBUTION = 24,
  URL = 25,
  UUID = 26,
};

// The category lookup table's entry type
using category_entry_t = uint32_t;
// The metric lookup table's entry type
// This is a bitpacked type with 32 bits available to index into
// the string table, 5 bits available to signify the metric type,
// and the remaining 27 bits devoted to 2 "signal"
// bits to signify important characteristics (metric's a labeled metric's
// submetric, metric's been registered at runtime) and 25 bits
// for built-in metric ids.
// Gives room for 33554432 of each combination of
// characteristics (which hopefully will prove to be enough).
using metric_entry_t = uint64_t;

already_AddRefed<GleanMetric> NewMetricFromId(uint32_t id, nsISupports* aParent);

/**
 * Create a submetric instance for a labeled metric of the provided type and id for the given label.
 * Assigns or retrieves an id for the submetric from the SDK.
 *
 * @param aParentTypeId - The type of the parent labeled metric identified as a number generated during codegen.
 *                        Only used to identify which X of LabeledX you are so that X can be created here.
 * @param aParentMetricId - The metric id for the parent labeled metric.
 * @param aLabel - The label for the submetric. Might not adhere to the SDK label format.
 * @param aSubmetricId - an outparam which is assigned the submetric's SDK-generated submetric id.
 *                       Used only by GIFFT.
 */
already_AddRefed<GleanMetric> NewSubMetricFromIds(uint32_t aParentTypeId, uint32_t aParentMetricId, const nsACString& aLabel, uint32_t* aSubmetricId, nsISupports* aParent);

/**
 * Get a category's name from the string table.
 */
const char* GetCategoryName(category_entry_t entry);

/**
 * Get a metric's identifier from the string table.
 */
const char* GetMetricIdentifier(metric_entry_t entry);

/**
 * Get a metric's id given its name.
 */
Maybe<uint32_t> MetricByNameLookup(const nsACString&);

/**
 * Get a category's id given its name.
 */
Maybe<uint32_t> CategoryByNameLookup(const nsACString&);

extern const category_entry_t sCategoryByNameLookupEntries[407];
extern const metric_entry_t sMetricByNameLookupEntries[6118];

} // namespace mozilla::glean
#endif // mozilla_GleanJSMetricsLookup_h
