// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanResistfingerprintingMetrics_h
#define mozilla_GleanResistfingerprintingMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace characteristics {
  /**
   * generated from characteristics.any_pointer_type
   * Union of pointers available. We apply union to determine if the user have both coarse and fine pointer.
   */
  constexpr impl::QuantityMetric any_pointer_type(5355);

  /**
   * generated from characteristics.audio_channels
   * Audio sampling rate
   */
  constexpr impl::QuantityMetric audio_channels(5356);

  /**
   * generated from characteristics.audio_fingerprint
   * Audio fingerprint of the user. A float number multiplied by 10e7.
   */
  constexpr impl::QuantityMetric audio_fingerprint(5357);

  /**
   * generated from characteristics.audio_frames
   * Audio frames
   */
  constexpr impl::QuantityMetric audio_frames(5358);

  /**
   * generated from characteristics.audio_rate
   * Audio sampling rate
   */
  constexpr impl::QuantityMetric audio_rate(5359);

  /**
   * generated from characteristics.avail_height
   * Available height property
   */
  constexpr impl::QuantityMetric avail_height(5360);

  /**
   * generated from characteristics.avail_width
   * Available width property
   */
  constexpr impl::QuantityMetric avail_width(5361);

  /**
   * generated from characteristics.build_date
   * Firefox build's build date in unix time
   */
  constexpr impl::QuantityMetric build_date(5362);

  /**
   * generated from characteristics.camera_count
   * Number of cameras available on the device.
   */
  constexpr impl::QuantityMetric camera_count(5363);

  /**
   * generated from characteristics.canvas_dpr
   * The device pixel ratio of the canvas rendering context
   */
  constexpr impl::StringMetric canvas_dpr(5364);

  /**
   * generated from characteristics.canvas_feature_status
   * Status of and failure id (if failed) of ACCELERATED_CANVAS2D feature
   */
  constexpr impl::StringMetric canvas_feature_status(5365);

  /**
   * generated from characteristics.canvasdata1
   * The sha1 hash of an image rendered on a canvas. The image is a simple organge box and used as a control image
   */
  constexpr impl::StringMetric canvasdata1(5366);

  /**
   * generated from characteristics.canvasdata10
   * The sha1 hash of an image rendered on a canvas. The image is a font shipped with Firefox rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata10(5367);

  /**
   * generated from characteristics.canvasdata10software
   * The sha1 hash of an image rendered on a canvas. The image is a font shipped with Firefox rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata10software(5368);

  /**
   * generated from characteristics.canvasdata11_webgl
   * The sha1 hash of an image rendered on a WebGL canvas (instead of Canvas2D). IT is a RGB gradient cube.
   */
  constexpr impl::StringMetric canvasdata11_webgl(5369);

  /**
   * generated from characteristics.canvasdata11_webglsoftware
   * The sha1 hash of an image rendered on a WebGL canvas (instead of Canvas2D). IT is a RGB gradient cube.
   */
  constexpr impl::StringMetric canvasdata11_webglsoftware(5370);

  /**
   * generated from characteristics.canvasdata12_fingerprintjs1
   * The sha1 hash of an image rendered on a canvas, it is a copy of fingerprintjs' text canvas
   */
  constexpr impl::StringMetric canvasdata12_fingerprintjs1(5371);

  /**
   * generated from characteristics.canvasdata12_fingerprintjs1software
   * The sha1 hash of an image rendered on a canvas, it is a copy of fingerprintjs' text canvas
   */
  constexpr impl::StringMetric canvasdata12_fingerprintjs1software(5372);

  /**
   * generated from characteristics.canvasdata13_fingerprintjs2
   * The sha1 hash of an image rendered on a canvas, it is a copy of fingerprintjs' geometry canvas
   */
  constexpr impl::StringMetric canvasdata13_fingerprintjs2(5373);

  /**
   * generated from characteristics.canvasdata13_fingerprintjs2software
   * The sha1 hash of an image rendered on a canvas, it is a copy of fingerprintjs' geometry canvas
   */
  constexpr impl::StringMetric canvasdata13_fingerprintjs2software(5374);

  /**
   * generated from characteristics.canvasdata1software
   * The sha1 hash of an image rendered on a canvas. The image is a simple organge box and used as a control image
   */
  constexpr impl::StringMetric canvasdata1software(5375);

  /**
   * generated from characteristics.canvasdata2
   * The sha1 hash of an image rendered on a canvas. The image is a bordered triage, and used to test point interpolation
   */
  constexpr impl::StringMetric canvasdata2(5376);

  /**
   * generated from characteristics.canvasdata2software
   * The sha1 hash of an image rendered on a canvas. The image is a bordered triage, and used to test point interpolation
   */
  constexpr impl::StringMetric canvasdata2software(5377);

  /**
   * generated from characteristics.canvasdata3
   * The sha1 hash of an image rendered on a canvas. The image is a stretched photographic image, used to test image operations.
   */
  constexpr impl::StringMetric canvasdata3(5378);

  /**
   * generated from characteristics.canvasdata3software
   * The sha1 hash of an image rendered on a canvas. The image is a stretched photographic image, used to test image operations.
   */
  constexpr impl::StringMetric canvasdata3software(5379);

  /**
   * generated from characteristics.canvasdata4
   * The sha1 hash of an image rendered on a canvas. The image is two rotated, semi-transparenct overlapping squares, used to test transparency and point interpolation.
   */
  constexpr impl::StringMetric canvasdata4(5380);

  /**
   * generated from characteristics.canvasdata4software
   * The sha1 hash of an image rendered on a canvas. The image is two rotated, semi-transparenct overlapping squares, used to test transparency and point interpolation.
   */
  constexpr impl::StringMetric canvasdata4software(5381);

  /**
   * generated from characteristics.canvasdata5
   * The sha1 hash of an image rendered on a canvas. The image is a local font rendered normally.
   */
  constexpr impl::StringMetric canvasdata5(5382);

  /**
   * generated from characteristics.canvasdata5software
   * The sha1 hash of an image rendered on a canvas. The image is a local font rendered normally.
   */
  constexpr impl::StringMetric canvasdata5software(5383);

  /**
   * generated from characteristics.canvasdata6
   * The sha1 hash of an image rendered on a canvas. The image is a local font rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata6(5384);

  /**
   * generated from characteristics.canvasdata6software
   * The sha1 hash of an image rendered on a canvas. The image is a local font rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata6software(5385);

  /**
   * generated from characteristics.canvasdata7
   * The sha1 hash of an image rendered on a canvas. The image is a system-ui font rendered normally.
   */
  constexpr impl::StringMetric canvasdata7(5386);

  /**
   * generated from characteristics.canvasdata7software
   * The sha1 hash of an image rendered on a canvas. The image is a system-ui font rendered normally.
   */
  constexpr impl::StringMetric canvasdata7software(5387);

  /**
   * generated from characteristics.canvasdata8
   * The sha1 hash of an image rendered on a canvas. The image is a system-ui font rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata8(5388);

  /**
   * generated from characteristics.canvasdata8software
   * The sha1 hash of an image rendered on a canvas. The image is a system-ui font rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata8software(5389);

  /**
   * generated from characteristics.canvasdata9
   * The sha1 hash of an image rendered on a canvas. The image is a font shipped with Firefox rendered normally.
   */
  constexpr impl::StringMetric canvasdata9(5390);

  /**
   * generated from characteristics.canvasdata9software
   * The sha1 hash of an image rendered on a canvas. The image is a font shipped with Firefox rendered normally.
   */
  constexpr impl::StringMetric canvasdata9software(5391);

  /**
   * generated from characteristics.changed_media_prefs
   * Changed media prefs and their values.
   */
  constexpr impl::StringMetric changed_media_prefs(5392);

  /**
   * generated from characteristics.channel
   * Firefox build channel
   */
  constexpr impl::StringMetric channel(5393);

  /**
   * generated from characteristics.client_identifier
   * A unique identifier for a user, not the same as the normal Telemetry client_id, but needed so we can deduplicate reports and only take the most recent one per user.
   */
  constexpr impl::UuidMetric client_identifier(5394);

  /**
   * generated from characteristics.color_accentcolor
   * The CSS system-color Accentcolor.
   */
  constexpr impl::QuantityMetric color_accentcolor(5395);

  /**
   * generated from characteristics.color_accentcolortext
   * The CSS system-color Accentcolortext.
   */
  constexpr impl::QuantityMetric color_accentcolortext(5396);

  /**
   * generated from characteristics.color_canvas
   * The CSS system-color Canvas.
   */
  constexpr impl::QuantityMetric color_canvas(5397);

  /**
   * generated from characteristics.color_canvastext
   * The CSS system-color Canvastext.
   */
  constexpr impl::QuantityMetric color_canvastext(5398);

  /**
   * generated from characteristics.color_highlight
   * The CSS system-color Highlight.
   */
  constexpr impl::QuantityMetric color_highlight(5399);

  /**
   * generated from characteristics.color_highlighttext
   * The CSS system-color Highlighttext.
   */
  constexpr impl::QuantityMetric color_highlighttext(5400);

  /**
   * generated from characteristics.color_scheme
   * The Color Scheme used for Content, from ContentPrefs() Preference Sheet.
   */
  constexpr impl::QuantityMetric color_scheme(5401);

  /**
   * generated from characteristics.color_selecteditem
   * The CSS system-color Selecteditem.
   */
  constexpr impl::QuantityMetric color_selecteditem(5402);

  /**
   * generated from characteristics.color_selecteditemtext
   * The CSS system-color Selecteditemtext.
   */
  constexpr impl::QuantityMetric color_selecteditemtext(5403);

  /**
   * generated from characteristics.cpu_arch
   * Arch of the user's device
   */
  constexpr impl::StringMetric cpu_arch(5404);

  /**
   * generated from characteristics.cpu_model
   * CPU model of the user's device
   */
  constexpr impl::StringMetric cpu_model(5405);

  /**
   * generated from characteristics.errors
   * Errors occured on C++ side of data collection
   */
  constexpr impl::TextMetric errors(5406);

  /**
   * generated from characteristics.font_default_default_group
   * The value of the font.default.<default language group> pref
   */
  constexpr impl::StringMetric font_default_default_group(5407);

  /**
   * generated from characteristics.font_default_modified
   * The number of other modified font.default prefs.
   */
  constexpr impl::QuantityMetric font_default_modified(5408);

  /**
   * generated from characteristics.font_default_western
   * The value of the font.default.x-western pref
   */
  constexpr impl::StringMetric font_default_western(5409);

  /**
   * generated from characteristics.font_minimum_size_default_group
   * The value of the font.minimum-size.<default language group> pref
   */
  constexpr impl::StringMetric font_minimum_size_default_group(5410);

  /**
   * generated from characteristics.font_minimum_size_modified
   * The number of other modified font.minimum-size prefs.
   */
  constexpr impl::QuantityMetric font_minimum_size_modified(5411);

  /**
   * generated from characteristics.font_minimum_size_western
   * The value of the font.minimum-size.x-western pref
   */
  constexpr impl::StringMetric font_minimum_size_western(5412);

  /**
   * generated from characteristics.font_name_list_cursive_modified
   * The number of modified font.name-list.cursive. prefs.
   */
  constexpr impl::QuantityMetric font_name_list_cursive_modified(5413);

  /**
   * generated from characteristics.font_name_list_emoji_modified
   * Whether the pref font.name-list.emoji was modified.
   */
  constexpr impl::BooleanMetric font_name_list_emoji_modified(5414);

  /**
   * generated from characteristics.font_name_list_monospace_modified
   * The number of modified font.name-list.monospace. prefs.
   */
  constexpr impl::QuantityMetric font_name_list_monospace_modified(5415);

  /**
   * generated from characteristics.font_name_list_sans_serif_modified
   * The number of modified font.name-list.sans-serif. prefs.
   */
  constexpr impl::QuantityMetric font_name_list_sans_serif_modified(5416);

  /**
   * generated from characteristics.font_name_list_serif_modified
   * The number of modified font.name-list.serif. prefs.
   */
  constexpr impl::QuantityMetric font_name_list_serif_modified(5417);

  /**
   * generated from characteristics.font_name_monospace_default_group
   * The value of the font.name.monospace.<default language group> pref
   */
  constexpr impl::StringMetric font_name_monospace_default_group(5418);

  /**
   * generated from characteristics.font_name_monospace_modified
   * The number of other modified font.name.monospace prefs.
   */
  constexpr impl::QuantityMetric font_name_monospace_modified(5419);

  /**
   * generated from characteristics.font_name_monospace_western
   * The value of the font.name.monospace.x-western pref
   */
  constexpr impl::StringMetric font_name_monospace_western(5420);

  /**
   * generated from characteristics.font_name_sans_serif_default_group
   * The value of the font.name.sans-serif.<default language group> pref
   */
  constexpr impl::StringMetric font_name_sans_serif_default_group(5421);

  /**
   * generated from characteristics.font_name_sans_serif_modified
   * The number of other modified font.name.sans-serif prefs.
   */
  constexpr impl::QuantityMetric font_name_sans_serif_modified(5422);

  /**
   * generated from characteristics.font_name_sans_serif_western
   * The value of the font.name.sans-serif.x-western pref
   */
  constexpr impl::StringMetric font_name_sans_serif_western(5423);

  /**
   * generated from characteristics.font_name_serif_default_group
   * The value of the font.name.serif.<default language group> pref
   */
  constexpr impl::StringMetric font_name_serif_default_group(5424);

  /**
   * generated from characteristics.font_name_serif_modified
   * The number of other modified font.name.serif prefs.
   */
  constexpr impl::QuantityMetric font_name_serif_modified(5425);

  /**
   * generated from characteristics.font_name_serif_western
   * The value of the font.name.serif.x-western pref
   */
  constexpr impl::StringMetric font_name_serif_western(5426);

  /**
   * generated from characteristics.font_size_monospace_default_group
   * The value of the font.size.monospace.<default language group> pref
   */
  constexpr impl::StringMetric font_size_monospace_default_group(5427);

  /**
   * generated from characteristics.font_size_monospace_modified
   * The number of other modified font.size.monospace prefs.
   */
  constexpr impl::QuantityMetric font_size_monospace_modified(5428);

  /**
   * generated from characteristics.font_size_monospace_western
   * The value of the font.size.monospace.x-western pref
   */
  constexpr impl::StringMetric font_size_monospace_western(5429);

  /**
   * generated from characteristics.font_size_variable_default_group
   * The value of the font.size.variable.<default language group> pref
   */
  constexpr impl::StringMetric font_size_variable_default_group(5430);

  /**
   * generated from characteristics.font_size_variable_modified
   * The number of other modified font.size.variable prefs.
   */
  constexpr impl::QuantityMetric font_size_variable_modified(5431);

  /**
   * generated from characteristics.font_size_variable_western
   * The value of the font.size.variable.x-western pref
   */
  constexpr impl::StringMetric font_size_variable_western(5432);

  /**
   * generated from characteristics.fonts_fpjs_allowlisted
   * SHA256 of allowlisted fonts queried by FPJS
   */
  constexpr impl::StringMetric fonts_fpjs_allowlisted(5433);

  /**
   * generated from characteristics.fonts_fpjs_nonallowlisted
   * SHA256 of non-allowlisted fonts queried by FPJS
   */
  constexpr impl::StringMetric fonts_fpjs_nonallowlisted(5434);

  /**
   * generated from characteristics.fonts_variant_a_allowlisted
   * SHA256 of allowlisted fonts queried of variant A
   */
  constexpr impl::StringMetric fonts_variant_a_allowlisted(5435);

  /**
   * generated from characteristics.fonts_variant_a_nonallowlisted
   * SHA256 of non-allowlisted fonts queried of variant A
   */
  constexpr impl::StringMetric fonts_variant_a_nonallowlisted(5436);

  /**
   * generated from characteristics.fonts_variant_b_allowlisted
   * SHA256 of allowlisted fonts queried of variant B
   */
  constexpr impl::StringMetric fonts_variant_b_allowlisted(5437);

  /**
   * generated from characteristics.fonts_variant_b_nonallowlisted
   * SHA256 of non-allowlisted fonts queried of variant B
   */
  constexpr impl::StringMetric fonts_variant_b_nonallowlisted(5438);

  /**
   * generated from characteristics.gamepads
   * The information of the gamepads inserted on the user device. Each string represents one gamepad. We use a JSON array to describe a gamepad, every value represents one property of the gamepad. Following are the details:
   *   index 0: The ID of the game pad
   *   index 1: Which hand for the gamepad.
   *   index 2: Number of buttons
   *   index 3: Number of axes
   *   index 4: Number of haptics
   *   index 5: Number of lights
   *   index 6: Number of touches
   */
  constexpr impl::StringListMetric gamepads(5439);

  /**
   * generated from characteristics.gl2_context_type
   * The type of the GL context (EGL, GLX, WGL, etc).
   */
  constexpr impl::StringMetric gl2_context_type(5440);

  /**
   * generated from characteristics.gl2_context_type_software
   * The type of the GL context (EGL, GLX, WGL, etc).
   */
  constexpr impl::StringMetric gl2_context_type_software(5441);

  /**
   * generated from characteristics.gl2_extensions
   * The list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl2_extensions(5442);

  /**
   * generated from characteristics.gl2_extensions_raw
   * The raw list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl2_extensions_raw(5443);

  /**
   * generated from characteristics.gl2_extensions_raw_software
   * The raw list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl2_extensions_raw_software(5444);

  /**
   * generated from characteristics.gl2_extensions_software
   * The list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl2_extensions_software(5445);

  /**
   * generated from characteristics.gl2_fragment_shader
   * Hash of the transformed source of the fragment shader.
   */
  constexpr impl::StringMetric gl2_fragment_shader(5446);

  /**
   * generated from characteristics.gl2_fragment_shader_software
   * Hash of the transformed source of the fragment shader.
   */
  constexpr impl::StringMetric gl2_fragment_shader_software(5447);

  /**
   * generated from characteristics.gl2_minimal_source
   * Transformed source of the minimal shader.
   */
  constexpr impl::TextMetric gl2_minimal_source(5448);

  /**
   * generated from characteristics.gl2_minimal_source_software
   * Transformed source of the minimal shader.
   */
  constexpr impl::TextMetric gl2_minimal_source_software(5449);

  /**
   * generated from characteristics.gl2_params
   * The list of GL parameters of GL2.
   */
  constexpr impl::TextMetric gl2_params(5450);

  /**
   * generated from characteristics.gl2_params_extensions
   * The list of GL parameters of the extensions.
   */
  constexpr impl::TextMetric gl2_params_extensions(5451);

  /**
   * generated from characteristics.gl2_params_extensions_software
   * The list of GL parameters of the extensions.
   */
  constexpr impl::TextMetric gl2_params_extensions_software(5452);

  /**
   * generated from characteristics.gl2_params_software
   * The list of GL parameters of GL2.
   */
  constexpr impl::TextMetric gl2_params_software(5453);

  /**
   * generated from characteristics.gl2_precision_fragment
   * Precisions of the fragment shader.
   */
  constexpr impl::TextMetric gl2_precision_fragment(5454);

  /**
   * generated from characteristics.gl2_precision_fragment_software
   * Precisions of the fragment shader.
   */
  constexpr impl::TextMetric gl2_precision_fragment_software(5455);

  /**
   * generated from characteristics.gl2_precision_vertex
   * Precisions of the vertex shader.
   */
  constexpr impl::TextMetric gl2_precision_vertex(5456);

  /**
   * generated from characteristics.gl2_precision_vertex_software
   * Precisions of the vertex shader.
   */
  constexpr impl::TextMetric gl2_precision_vertex_software(5457);

  /**
   * generated from characteristics.gl2_renderer
   * The OpenGL renderer string.
   */
  constexpr impl::StringMetric gl2_renderer(5458);

  /**
   * generated from characteristics.gl2_renderer_raw
   * The raw OpenGL renderer string.
   */
  constexpr impl::StringMetric gl2_renderer_raw(5459);

  /**
   * generated from characteristics.gl2_renderer_raw_software
   * The raw OpenGL renderer string.
   */
  constexpr impl::StringMetric gl2_renderer_raw_software(5460);

  /**
   * generated from characteristics.gl2_renderer_software
   * The OpenGL renderer string.
   */
  constexpr impl::StringMetric gl2_renderer_software(5461);

  /**
   * generated from characteristics.gl2_vendor
   * The OpenGL vendor string.
   */
  constexpr impl::StringMetric gl2_vendor(5462);

  /**
   * generated from characteristics.gl2_vendor_raw
   * The raw OpenGL vendor string.
   */
  constexpr impl::StringMetric gl2_vendor_raw(5463);

  /**
   * generated from characteristics.gl2_vendor_raw_software
   * The raw OpenGL vendor string.
   */
  constexpr impl::StringMetric gl2_vendor_raw_software(5464);

  /**
   * generated from characteristics.gl2_vendor_software
   * The OpenGL vendor string.
   */
  constexpr impl::StringMetric gl2_vendor_software(5465);

  /**
   * generated from characteristics.gl2_version_raw
   * The raw OpenGL version string.
   */
  constexpr impl::StringMetric gl2_version_raw(5466);

  /**
   * generated from characteristics.gl2_version_raw_software
   * The raw OpenGL version string.
   */
  constexpr impl::StringMetric gl2_version_raw_software(5467);

  /**
   * generated from characteristics.gl2_vertex_shader
   * Hash of the transformed source of the vertex shader.
   */
  constexpr impl::StringMetric gl2_vertex_shader(5468);

  /**
   * generated from characteristics.gl2_vertex_shader_software
   * Hash of the transformed source of the vertex shader.
   */
  constexpr impl::StringMetric gl2_vertex_shader_software(5469);

  /**
   * generated from characteristics.gl_context_type
   * The type of the GL context (EGL, GLX, WGL, etc).
   */
  constexpr impl::StringMetric gl_context_type(5470);

  /**
   * generated from characteristics.gl_context_type_software
   * The type of the GL context (EGL, GLX, WGL, etc).
   */
  constexpr impl::StringMetric gl_context_type_software(5471);

  /**
   * generated from characteristics.gl_extensions
   * The list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl_extensions(5472);

  /**
   * generated from characteristics.gl_extensions_raw
   * The raw list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl_extensions_raw(5473);

  /**
   * generated from characteristics.gl_extensions_raw_software
   * The raw list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl_extensions_raw_software(5474);

  /**
   * generated from characteristics.gl_extensions_software
   * The list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl_extensions_software(5475);

  /**
   * generated from characteristics.gl_fragment_shader
   * Hash of the transformed source of the fragment shader.
   */
  constexpr impl::StringMetric gl_fragment_shader(5476);

  /**
   * generated from characteristics.gl_fragment_shader_software
   * Hash of the transformed source of the fragment shader.
   */
  constexpr impl::StringMetric gl_fragment_shader_software(5477);

  /**
   * generated from characteristics.gl_minimal_source
   * Transformed source of the minimal shader.
   */
  constexpr impl::TextMetric gl_minimal_source(5478);

  /**
   * generated from characteristics.gl_minimal_source_software
   * Transformed source of the minimal shader.
   */
  constexpr impl::TextMetric gl_minimal_source_software(5479);

  /**
   * generated from characteristics.gl_params
   * The list of GL parameters of GL1.
   */
  constexpr impl::TextMetric gl_params(5480);

  /**
   * generated from characteristics.gl_params_extensions
   * The list of GL parameters of the extensions.
   */
  constexpr impl::TextMetric gl_params_extensions(5481);

  /**
   * generated from characteristics.gl_params_extensions_software
   * The list of GL parameters of the extensions.
   */
  constexpr impl::TextMetric gl_params_extensions_software(5482);

  /**
   * generated from characteristics.gl_params_software
   * The list of GL parameters of GL1.
   */
  constexpr impl::TextMetric gl_params_software(5483);

  /**
   * generated from characteristics.gl_precision_fragment
   * Precisions of the fragment shader.
   */
  constexpr impl::TextMetric gl_precision_fragment(5484);

  /**
   * generated from characteristics.gl_precision_fragment_software
   * Precisions of the fragment shader.
   */
  constexpr impl::TextMetric gl_precision_fragment_software(5485);

  /**
   * generated from characteristics.gl_precision_vertex
   * Precisions of the vertex shader.
   */
  constexpr impl::TextMetric gl_precision_vertex(5486);

  /**
   * generated from characteristics.gl_precision_vertex_software
   * Precisions of the vertex shader.
   */
  constexpr impl::TextMetric gl_precision_vertex_software(5487);

  /**
   * generated from characteristics.gl_renderer
   * The OpenGL renderer string.
   */
  constexpr impl::StringMetric gl_renderer(5488);

  /**
   * generated from characteristics.gl_renderer_raw
   * The raw OpenGL renderer string.
   */
  constexpr impl::StringMetric gl_renderer_raw(5489);

  /**
   * generated from characteristics.gl_renderer_raw_software
   * The raw OpenGL renderer string.
   */
  constexpr impl::StringMetric gl_renderer_raw_software(5490);

  /**
   * generated from characteristics.gl_renderer_software
   * The OpenGL renderer string.
   */
  constexpr impl::StringMetric gl_renderer_software(5491);

  /**
   * generated from characteristics.gl_vendor
   * The OpenGL vendor string.
   */
  constexpr impl::StringMetric gl_vendor(5492);

  /**
   * generated from characteristics.gl_vendor_raw
   * The raw OpenGL vendor string.
   */
  constexpr impl::StringMetric gl_vendor_raw(5493);

  /**
   * generated from characteristics.gl_vendor_raw_software
   * The raw OpenGL vendor string.
   */
  constexpr impl::StringMetric gl_vendor_raw_software(5494);

  /**
   * generated from characteristics.gl_vendor_software
   * The OpenGL vendor string.
   */
  constexpr impl::StringMetric gl_vendor_software(5495);

  /**
   * generated from characteristics.gl_version_raw
   * The raw OpenGL version string.
   */
  constexpr impl::StringMetric gl_version_raw(5496);

  /**
   * generated from characteristics.gl_version_raw_software
   * The raw OpenGL version string.
   */
  constexpr impl::StringMetric gl_version_raw_software(5497);

  /**
   * generated from characteristics.gl_vertex_shader
   * Hash of the transformed source of the vertex shader.
   */
  constexpr impl::StringMetric gl_vertex_shader(5498);

  /**
   * generated from characteristics.gl_vertex_shader_software
   * Hash of the transformed source of the vertex shader.
   */
  constexpr impl::StringMetric gl_vertex_shader_software(5499);

  /**
   * generated from characteristics.group_count
   * Number of device groups reported by the device.
   */
  constexpr impl::QuantityMetric group_count(5500);

  /**
   * generated from characteristics.group_count_wo_speakers
   * Number of device groups without speakers reported by the device.
   */
  constexpr impl::QuantityMetric group_count_wo_speakers(5501);

  /**
   * generated from characteristics.ice_order
   * Unique ICE foundations occurrence count
   */
  constexpr impl::QuantityMetric ice_order(5502);

  /**
   * generated from characteristics.ice_sd
   * ICE foundation discovery latency standard deviation sum multiplied by 1000
   */
  constexpr impl::QuantityMetric ice_sd(5503);

  /**
   * generated from characteristics.inner_height
   * Inner height of user's browser.
   */
  constexpr impl::QuantityMetric inner_height(5504);

  /**
   * generated from characteristics.inner_width
   * Inner width of user's browser.
   */
  constexpr impl::QuantityMetric inner_width(5505);

  /**
   * generated from characteristics.intl_locale
   * Locale information provided by Intl
   */
  constexpr impl::StringMetric intl_locale(5506);

  /**
   * generated from characteristics.inverted_colors
   * What LookAndFeel(InvertedColors) reports.
   */
  constexpr impl::BooleanMetric inverted_colors(5507);

  /**
   * generated from characteristics.js_errors
   * Errors occured on JavaScript side of data collection
   */
  constexpr impl::TextMetric js_errors(5508);

  /**
   * generated from characteristics.keyboard_layout
   * Name of the current keyboard layout.
   */
  constexpr impl::StringMetric keyboard_layout(5509);

  /**
   * generated from characteristics.languages
   * Languages the user set. Returns intl.accept_languages pref, if it is empty, returns the first matched OS's language or the default language.
   */
  constexpr impl::StringMetric languages(5510);

  /**
   * generated from characteristics.machine_model_name
   * Machine model name
   */
  constexpr impl::StringMetric machine_model_name(5511);

  /**
   * generated from characteristics.math_ops
   * Result of fingerprintable math operations
   */
  constexpr impl::TextMetric math_ops(5512);

  /**
   * generated from characteristics.math_ops_fdlibm
   * Windows only fdlibm math operation results
   */
  constexpr impl::TextMetric math_ops_fdlibm(5513);

  /**
   * generated from characteristics.mathml1
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml1(5514);

  /**
   * generated from characteristics.mathml10
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml10(5515);

  /**
   * generated from characteristics.mathml2
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml2(5516);

  /**
   * generated from characteristics.mathml3
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml3(5517);

  /**
   * generated from characteristics.mathml4
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml4(5518);

  /**
   * generated from characteristics.mathml5
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml5(5519);

  /**
   * generated from characteristics.mathml6
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml6(5520);

  /**
   * generated from characteristics.mathml7
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml7(5521);

  /**
   * generated from characteristics.mathml8
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml8(5522);

  /**
   * generated from characteristics.mathml9
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml9(5523);

  /**
   * generated from characteristics.max_touch_points
   * The number of touch points we will report to the web. On Android, this is based on Android's FEATURE_TOUCHSCREEN* constants - Mozilla caps this at 5 as Android stops distinguishing between numbers greater than 5.  On Windows this comes from the SM_MAXIMUMTOUCHES System Metric.
   */
  constexpr impl::QuantityMetric max_touch_points(5524);

  /**
   * generated from characteristics.media_capabilities_h264
   * Levels of support for H264 codec.
   */
  constexpr impl::TextMetric media_capabilities_h264(5525);

  /**
   * generated from characteristics.media_capabilities_not_efficient
   * Which, if any, media types are not power efficient.
   */
  constexpr impl::TextMetric media_capabilities_not_efficient(5526);

  /**
   * generated from characteristics.media_capabilities_not_smooth
   * Which, if any, media types are not smooth.
   */
  constexpr impl::TextMetric media_capabilities_not_smooth(5527);

  /**
   * generated from characteristics.media_capabilities_unsupported
   * Which, if any, media types are not supported.
   */
  constexpr impl::TextMetric media_capabilities_unsupported(5528);

  /**
   * generated from characteristics.microphone_count
   * Number of microphones available on the device.
   */
  constexpr impl::QuantityMetric microphone_count(5529);

  /**
   * generated from characteristics.missing_fonts
   * If a Font List is available for the user's platform, this string_list contains the fonts that are missing from the user's computer.
   */
  constexpr impl::TextMetric missing_fonts(5530);

  /**
   * generated from characteristics.monochrome
   * Whether the user's device is monochrome
   */
  constexpr impl::BooleanMetric monochrome(5531);

  /**
   * generated from characteristics.motion_decimals
   * devicemotion event's decimal places count
   */
  constexpr impl::QuantityMetric motion_decimals(5532);

  /**
   * generated from characteristics.motion_freq
   * devicemotion event's frequency
   */
  constexpr impl::QuantityMetric motion_freq(5533);

  /**
   * generated from characteristics.orientation_decimals
   * deviceorientation event's decimal places count
   */
  constexpr impl::QuantityMetric orientation_decimals(5534);

  /**
   * generated from characteristics.orientation_freq
   * deviceorientation event's frequency
   */
  constexpr impl::QuantityMetric orientation_freq(5535);

  /**
   * generated from characteristics.orientationabs_decimals
   * deviceorientationabsolute event's decimal places count
   */
  constexpr impl::QuantityMetric orientationabs_decimals(5536);

  /**
   * generated from characteristics.orientationabs_freq
   * deviceorientationabsolute event's frequency
   */
  constexpr impl::QuantityMetric orientationabs_freq(5537);

  /**
   * generated from characteristics.os_name
   * User's OS name
   */
  constexpr impl::StringMetric os_name(5538);

  /**
   * generated from characteristics.os_version
   * User's OS version
   */
  constexpr impl::StringMetric os_version(5539);

  /**
   * generated from characteristics.oscpu
   * User's OS CPU reported by the navigator
   */
  constexpr impl::StringMetric oscpu(5540);

  /**
   * generated from characteristics.outer_height
   * Outer height of user's browser.
   */
  constexpr impl::QuantityMetric outer_height(5541);

  /**
   * generated from characteristics.outer_width
   * Outer width of user's browser.
   */
  constexpr impl::QuantityMetric outer_width(5542);

  /**
   * generated from characteristics.pdf_viewer
   * PDF viewer support reported by the navigator
   */
  constexpr impl::BooleanMetric pdf_viewer(5543);

  /**
   * generated from characteristics.pixel_ratio
   * The value of window.devicePixelRatio
   */
  constexpr impl::StringMetric pixel_ratio(5544);

  /**
   * generated from characteristics.platform
   * Platform reported by the navigator
   */
  constexpr impl::StringMetric platform(5545);

  /**
   * generated from characteristics.pointer_height
   * Height of user's pointer
   */
  constexpr impl::QuantityMetric pointer_height(5546);

  /**
   * generated from characteristics.pointer_pressure
   * Pressure of user's pointer
   */
  constexpr impl::StringMetric pointer_pressure(5547);

  /**
   * generated from characteristics.pointer_tangentinal_pressure
   * Tangential Pressure of user's pointer
   */
  constexpr impl::StringMetric pointer_tangentinal_pressure(5548);

  /**
   * generated from characteristics.pointer_tiltx
   * TiltX of user's pointer
   */
  constexpr impl::QuantityMetric pointer_tiltx(5549);

  /**
   * generated from characteristics.pointer_tilty
   * TiltY of user's pointer
   */
  constexpr impl::QuantityMetric pointer_tilty(5550);

  /**
   * generated from characteristics.pointer_twist
   * Twist of user's pointer
   */
  constexpr impl::QuantityMetric pointer_twist(5551);

  /**
   * generated from characteristics.pointer_type
   * Pointer type of the user's primary pointer device.
   */
  constexpr impl::QuantityMetric pointer_type(5552);

  /**
   * generated from characteristics.pointer_width
   * Width of user's pointer
   */
  constexpr impl::QuantityMetric pointer_width(5553);

  /**
   * generated from characteristics.prefers_contrast
   * What Gecko_MediaFeatures_PrefersContrast reports for a ContentDocument
   */
  constexpr impl::QuantityMetric prefers_contrast(5554);

  /**
   * generated from characteristics.prefers_reduced_motion
   * What LookAndFeel(PrefersReducedMotion) reports.
   */
  constexpr impl::BooleanMetric prefers_reduced_motion(5555);

  /**
   * generated from characteristics.prefers_reduced_transparency
   * What LookAndFeel(PrefersReducedTransparency) reports.
   */
  constexpr impl::BooleanMetric prefers_reduced_transparency(5556);

  /**
   * generated from characteristics.prefs_block_popups
   * Block pop-up windows (The dom.disable_open_during_load pref)
   */
  constexpr impl::BooleanMetric prefs_block_popups(5557);

  /**
   * generated from characteristics.prefs_browser_display_use_document_fonts
   * Allow pages to choose their own fonts.
   */
  constexpr impl::BooleanMetric prefs_browser_display_use_document_fonts(5558);

  /**
   * generated from characteristics.prefs_general_autoscroll
   * Use autoscrolling
   */
  constexpr impl::BooleanMetric prefs_general_autoscroll(5559);

  /**
   * generated from characteristics.prefs_general_smoothscroll
   * Use smooth scrolling
   */
  constexpr impl::BooleanMetric prefs_general_smoothscroll(5560);

  /**
   * generated from characteristics.prefs_intl_accept_languages
   * Value of the intl.accept_languages pref.
   */
  constexpr impl::StringMetric prefs_intl_accept_languages(5561);

  /**
   * generated from characteristics.prefs_media_eme_enabled
   * Value of the media.eme.enabled pref.
   */
  constexpr impl::BooleanMetric prefs_media_eme_enabled(5562);

  /**
   * generated from characteristics.prefs_network_cookie_cookiebehavior
   * Value of the network.cookie.cookieBehavior pref.
   */
  constexpr impl::QuantityMetric prefs_network_cookie_cookiebehavior(5563);

  /**
   * generated from characteristics.prefs_overlay_scrollbars
   * Use overlay scrollbars (or otherwise "Always show scrollbars")
   */
  constexpr impl::BooleanMetric prefs_overlay_scrollbars(5564);

  /**
   * generated from characteristics.prefs_privacy_donottrackheader_enabled
   * Sending "do not track" HTTP header
   */
  constexpr impl::BooleanMetric prefs_privacy_donottrackheader_enabled(5565);

  /**
   * generated from characteristics.prefs_privacy_globalprivacycontrol_enabled
   * Sending "global privacy control" HTTP header
   */
  constexpr impl::BooleanMetric prefs_privacy_globalprivacycontrol_enabled(5566);

  /**
   * generated from characteristics.prefs_zoom_text_only
   * Text-only zoom enabled (vs. full-zoom)
   */
  constexpr impl::BooleanMetric prefs_zoom_text_only(5567);

  /**
   * generated from characteristics.processor_count
   * Number of processors.
   */
  constexpr impl::QuantityMetric processor_count(5568);

  /**
   * generated from characteristics.screen_height
   * Screen height from a window.
   */
  constexpr impl::QuantityMetric screen_height(5569);

  /**
   * generated from characteristics.screen_width
   * Screen width from a window.
   */
  constexpr impl::QuantityMetric screen_width(5570);

  /**
   * generated from characteristics.screens
   * JSON string of screen properties
   */
  constexpr impl::TextMetric screens(5571);

  /**
   * generated from characteristics.size_mode
   * Whether window is maximized, minimized, normal or fullscreen
   */
  constexpr impl::QuantityMetric size_mode(5572);

  /**
   * generated from characteristics.speaker_count
   * Number of speakers available on the device.
   */
  constexpr impl::QuantityMetric speaker_count(5573);

  /**
   * generated from characteristics.submission_schema
   * An incrementing constant that represents the current schema/source of the data present in a ping. By referring to this value in a ping, one can know for certain the provenance of other data present in the ping, and what data may or may not be present.
   */
  constexpr impl::QuantityMetric submission_schema(5574);

  /**
   * generated from characteristics.system_locale
   * The locale used by the host OS for localization.
   */
  constexpr impl::StringMetric system_locale(5575);

  /**
   * generated from characteristics.target_frame_rate
   * The target frame rate in frames-per-second.
   */
  constexpr impl::QuantityMetric target_frame_rate(5576);

  /**
   * generated from characteristics.text_anti_aliasing
   * Font anti aliasing level
   */
  constexpr impl::StringMetric text_anti_aliasing(5577);

  /**
   * generated from characteristics.timezone
   * The the current timezone of the system
   */
  constexpr impl::StringMetric timezone(5578);

  /**
   * generated from characteristics.touch_rotation_angle
   * Rotation angle of user's touch
   */
  constexpr impl::StringMetric touch_rotation_angle(5579);

  /**
   * generated from characteristics.use_document_colors
   * This is the derived PreferenceSheet::Prefs::mUseDocumentColors value.
   */
  constexpr impl::BooleanMetric use_document_colors(5580);

  /**
   * generated from characteristics.user_agent
   * User agent string
   */
  constexpr impl::TextMetric user_agent(5581);

  /**
   * generated from characteristics.using_accelerated_canvas
   * Whether the user's device is using accelerated canvas
   */
  constexpr impl::BooleanMetric using_accelerated_canvas(5582);

  /**
   * generated from characteristics.version
   * Firefox build version
   */
  constexpr impl::StringMetric version(5583);

  /**
   * generated from characteristics.voices_all_ssdeep
   * ssdeep hash of all speechSynthesis voices.
   */
  constexpr impl::StringMetric voices_all_ssdeep(5584);

  /**
   * generated from characteristics.voices_count
   * Number of speechSynthesis voices available to the user.
   */
  constexpr impl::QuantityMetric voices_count(5585);

  /**
   * generated from characteristics.voices_default
   * The default speechSynthesis voice.
   */
  constexpr impl::StringMetric voices_default(5586);

  /**
   * generated from characteristics.voices_local_count
   * Number of local speechSynthesis voices available to the user.
   */
  constexpr impl::QuantityMetric voices_local_count(5587);

  /**
   * generated from characteristics.voices_local_ssdeep
   * ssdeep hash of local speechSynthesis voices.
   */
  constexpr impl::StringMetric voices_local_ssdeep(5588);

  /**
   * generated from characteristics.voices_nonlocal_ssdeep
   * ssdeep hash of non-local speechSynthesis voices.
   */
  constexpr impl::StringMetric voices_nonlocal_ssdeep(5589);

  /**
   * generated from characteristics.voices_sample
   * Names of 5 sample speechSynthesis voices.
   */
  constexpr impl::TextMetric voices_sample(5590);

  /**
   * generated from characteristics.voices_sha1
   * SHA1 hash of all the voices.
   */
  constexpr impl::TextMetric voices_sha1(5591);

  /**
   * generated from characteristics.wgpu_maxbindgroups
   * WebGPU limit maxBindGroups
   */
  constexpr impl::QuantityMetric wgpu_maxbindgroups(5592);

  /**
   * generated from characteristics.wgpu_maxbindgroupsplusvertexbuffers
   * WebGPU limit maxBindGroupsPlusVertexBuffers
   */
  constexpr impl::QuantityMetric wgpu_maxbindgroupsplusvertexbuffers(5593);

  /**
   * generated from characteristics.wgpu_maxbindingsperbindgroup
   * WebGPU limit maxBindingsPerBindGroup
   */
  constexpr impl::QuantityMetric wgpu_maxbindingsperbindgroup(5594);

  /**
   * generated from characteristics.wgpu_maxbuffersize
   * WebGPU limit maxBufferSize
   */
  constexpr impl::QuantityMetric wgpu_maxbuffersize(5595);

  /**
   * generated from characteristics.wgpu_maxcolorattachmentbytespersample
   * WebGPU limit maxColorAttachmentBytesPerSample
   */
  constexpr impl::QuantityMetric wgpu_maxcolorattachmentbytespersample(5596);

  /**
   * generated from characteristics.wgpu_maxcolorattachments
   * WebGPU limit maxColorAttachments
   */
  constexpr impl::QuantityMetric wgpu_maxcolorattachments(5597);

  /**
   * generated from characteristics.wgpu_maxcomputeinvocationsperworkgroup
   * WebGPU limit maxComputeInvocationsPerWorkgroup
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeinvocationsperworkgroup(5598);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupsizex
   * WebGPU limit maxComputeWorkgroupSizeX
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupsizex(5599);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupsizey
   * WebGPU limit maxComputeWorkgroupSizeY
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupsizey(5600);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupsizez
   * WebGPU limit maxComputeWorkgroupSizeZ
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupsizez(5601);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupsperdimension
   * WebGPU limit maxComputeWorkgroupsPerDimension
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupsperdimension(5602);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupstoragesize
   * WebGPU limit maxComputeWorkgroupStorageSize
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupstoragesize(5603);

  /**
   * generated from characteristics.wgpu_maxdynamicstoragebuffersperpipelinelayout
   * WebGPU limit maxDynamicStorageBuffersPerPipelineLayout
   */
  constexpr impl::QuantityMetric wgpu_maxdynamicstoragebuffersperpipelinelayout(5604);

  /**
   * generated from characteristics.wgpu_maxdynamicuniformbuffersperpipelinelayout
   * WebGPU limit maxDynamicUniformBuffersPerPipelineLayout
   */
  constexpr impl::QuantityMetric wgpu_maxdynamicuniformbuffersperpipelinelayout(5605);

  /**
   * generated from characteristics.wgpu_maxinterstageshadervariables
   * WebGPU limit maxInterStageShaderVariables
   */
  constexpr impl::QuantityMetric wgpu_maxinterstageshadervariables(5606);

  /**
   * generated from characteristics.wgpu_maxsampledtexturespershaderstage
   * WebGPU limit maxSampledTexturesPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxsampledtexturespershaderstage(5607);

  /**
   * generated from characteristics.wgpu_maxsamplerspershaderstage
   * WebGPU limit maxSamplersPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxsamplerspershaderstage(5608);

  /**
   * generated from characteristics.wgpu_maxstoragebufferbindingsize
   * WebGPU limit maxStorageBufferBindingSize
   */
  constexpr impl::QuantityMetric wgpu_maxstoragebufferbindingsize(5609);

  /**
   * generated from characteristics.wgpu_maxstoragebufferspershaderstage
   * WebGPU limit maxStorageBuffersPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxstoragebufferspershaderstage(5610);

  /**
   * generated from characteristics.wgpu_maxstoragetexturespershaderstage
   * WebGPU limit maxStorageTexturesPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxstoragetexturespershaderstage(5611);

  /**
   * generated from characteristics.wgpu_maxtexturearraylayers
   * WebGPU limit maxTextureArrayLayers
   */
  constexpr impl::QuantityMetric wgpu_maxtexturearraylayers(5612);

  /**
   * generated from characteristics.wgpu_maxtexturedimension1d
   * WebGPU limit maxTextureDimension1D
   */
  constexpr impl::QuantityMetric wgpu_maxtexturedimension1d(5613);

  /**
   * generated from characteristics.wgpu_maxtexturedimension2d
   * WebGPU limit maxTextureDimension2D
   */
  constexpr impl::QuantityMetric wgpu_maxtexturedimension2d(5614);

  /**
   * generated from characteristics.wgpu_maxtexturedimension3d
   * WebGPU limit maxTextureDimension3D
   */
  constexpr impl::QuantityMetric wgpu_maxtexturedimension3d(5615);

  /**
   * generated from characteristics.wgpu_maxuniformbufferbindingsize
   * WebGPU limit maxUniformBufferBindingSize
   */
  constexpr impl::QuantityMetric wgpu_maxuniformbufferbindingsize(5616);

  /**
   * generated from characteristics.wgpu_maxuniformbufferspershaderstage
   * WebGPU limit maxUniformBuffersPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxuniformbufferspershaderstage(5617);

  /**
   * generated from characteristics.wgpu_maxvertexattributes
   * WebGPU limit maxVertexAttributes
   */
  constexpr impl::QuantityMetric wgpu_maxvertexattributes(5618);

  /**
   * generated from characteristics.wgpu_maxvertexbufferarraystride
   * WebGPU limit maxVertexBufferArrayStride
   */
  constexpr impl::QuantityMetric wgpu_maxvertexbufferarraystride(5619);

  /**
   * generated from characteristics.wgpu_maxvertexbuffers
   * WebGPU limit maxVertexBuffers
   */
  constexpr impl::QuantityMetric wgpu_maxvertexbuffers(5620);

  /**
   * generated from characteristics.wgpu_minstoragebufferoffsetalignment
   * WebGPU limit minStorageBufferOffsetAlignment
   */
  constexpr impl::QuantityMetric wgpu_minstoragebufferoffsetalignment(5621);

  /**
   * generated from characteristics.wgpu_minuniformbufferoffsetalignment
   * WebGPU limit minUniformBufferOffsetAlignment
   */
  constexpr impl::QuantityMetric wgpu_minuniformbufferoffsetalignment(5622);

  /**
   * generated from characteristics.wgpu_missing_features
   * Missing features of WebGPU as a bitset
   */
  constexpr impl::StringMetric wgpu_missing_features(5623);

  /**
   * generated from characteristics.zoom_count
   * Number of domains the users has a non-default zoom level.
   */
  constexpr impl::QuantityMetric zoom_count(5624);
}

namespace fingerprinting_protection {
  /**
   * generated from fingerprinting.protection.canvas_noise_calculate_time_2
   * Counts how long to generate canvas random noises.
   */
  constexpr impl::TimingDistributionMetric canvas_noise_calculate_time_2(5625);
}

} // namespace mozilla::glean

#endif // mozilla_GleanResistfingerprintingMetrics_h
