// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanContentanalysisMetrics_h
#define mozilla_GleanContentanalysisMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace content_analysis {
  /**
   * generated from content_analysis.agent_name
   * The name of the DLP agent that Firefox is connected to. This is set via enterprise policy.
   */
  constexpr impl::StringMetric agent_name(4617);

  /**
   * generated from content_analysis.allow_url_regex_list_set
   * Whether the allow_url_regex_list pref is set to a non-default value.
   */
  constexpr impl::BooleanMetric allow_url_regex_list_set(4618);

  /**
   * generated from content_analysis.bypass_for_same_tab_operations
   * The bypass_for_same_tab_operations pref that is set via enterprise policy.
   */
  constexpr impl::BooleanMetric bypass_for_same_tab_operations(4619);

  /**
   * generated from content_analysis.client_signature
   * The client_signature pref that is set via enterprise policy.
   */
  constexpr impl::StringMetric client_signature(4620);

  /**
   * generated from content_analysis.connection_attempt
   * Recorded when Firefox attempts to connect to the DLP agent.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> connection_attempt(4621);

  /**
   * generated from content_analysis.connection_attempt_retry
   * Recorded when Firefox attempts to retry connecting to the DLP agent (because a previous attempt to communicate with the agent failed).
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> connection_attempt_retry(4622);

  /**
   * generated from content_analysis.connection_failure
   * Recorded when Firefox fails to connect to the DLP agent. The label is the nsresult that was returned by the connection attempt.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> connection_failure(4623);

  /**
   * generated from content_analysis.default_result
   * The default_result pref that is set via enterprise policy.
   */
  constexpr impl::QuantityMetric default_result(4624);

  /**
   * generated from content_analysis.deny_url_regex_list_set
   * Whether the deny_url_regex_list pref is set to a non-default value.
   */
  constexpr impl::BooleanMetric deny_url_regex_list_set(4625);

  /**
   * generated from content_analysis.interception_points_turned_off
   * The interception points that are turned off via enterprise policy.
   */
  constexpr impl::StringListMetric interception_points_turned_off(4626);

  /**
   * generated from content_analysis.request_allowed_by_allow_url
   * Recorded when a request is allowed by the allow_url_regex_list.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> request_allowed_by_allow_url(4627);

  /**
   * generated from content_analysis.request_blocked_by_deny_url
   * Recorded when a request is blocked by the deny_url_regex_list.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> request_blocked_by_deny_url(4628);

  /**
   * generated from content_analysis.request_sent_by_analysis_type
   * Recorded when a request is sent to the DLP agent. The label is the analysisType of the request, which corresponds to a value in the AnalysisConnector enum in analysis.proto. (e.g. "FILE_DOWNLOADED", "FILE_ATTACHED", "BULK_DATA_ENTRY", etc.)
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> request_sent_by_analysis_type(4629);

  /**
   * generated from content_analysis.request_sent_by_reason
   * Recorded when a request is sent to the DLP agent. The label is the reason of the request, which corresponds to a value in the ContentAnalysisRequest::Reason enum in analysis.proto. (e.g. "CLIPBOARD_PASTE", "DRAG_AND_DROP", etc.)
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> request_sent_by_reason(4630);

  /**
   * generated from content_analysis.response_action
   * Recorded when a response is received from the DLP agent. The label is the action of the response, converted to a string (so "1"). The values correspond to nsIContentAnalysisResponse::Action.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> response_action(4631);

  /**
   * generated from content_analysis.response_duration_by_analysis_type
   * The time between sending a request to the DLP agent and receiving a response from the agent. The label is the analysisType of the request.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> response_duration_by_analysis_type(4632);

  /**
   * generated from content_analysis.show_blocked_result
   * The show_blocked_result pref that is set via enterprise policy.
   */
  constexpr impl::BooleanMetric show_blocked_result(4633);

  /**
   * generated from content_analysis.timeout_result
   * The timeout_result pref that is set via enterprise policy.
   */
  constexpr impl::QuantityMetric timeout_result(4634);
}

} // namespace mozilla::glean

#endif // mozilla_GleanContentanalysisMetrics_h
