/* THIS FILE IS AUTOGENERATED FROM Notification.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_NOTIFICATIONBINDING_H_
#define DOM_NOTIFICATIONBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

struct GetNotificationOptionsAtoms;
struct NativePropertyHooks;
class Notification;
struct NotificationAction;
struct NotificationActionAtoms;
struct NotificationOptionsAtoms;
class NotificationPermissionCallback;
class OwningUnsignedLongOrUnsignedLongSequence;
class ProtoAndIfaceCache;
class UnsignedLongOrUnsignedLongSequence;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class NotificationPermission : uint8_t {
  Default,
  Denied,
  Granted,
};

namespace binding_detail {
template <> struct EnumStrings<NotificationPermission> {
  static constexpr nsLiteralCString Values[3] {
    "default"_ns,
    "denied"_ns,
    "granted"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, NotificationPermission aArgument, JS::MutableHandle<JS::Value> aValue);


enum class NotificationDirection : uint8_t {
  Auto,
  Ltr,
  Rtl,
};

namespace binding_detail {
template <> struct EnumStrings<NotificationDirection> {
  static constexpr nsLiteralCString Values[3] {
    "auto"_ns,
    "ltr"_ns,
    "rtl"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, NotificationDirection aArgument, JS::MutableHandle<JS::Value> aValue);


struct GetNotificationOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mTag;

  GetNotificationOptions();

  explicit inline GetNotificationOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GetNotificationOptions(GetNotificationOptions&& aOther) = default;

  explicit inline GetNotificationOptions(const GetNotificationOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GetNotificationOptions&
  operator=(const GetNotificationOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, GetNotificationOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastGetNotificationOptions : public GetNotificationOptions
{
  inline FastGetNotificationOptions()
    : GetNotificationOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct NotificationAction : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mAction;
  MOZ_INIT_OUTSIDE_CTOR nsString mTitle;

  NotificationAction();

  explicit inline NotificationAction(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  NotificationAction(NotificationAction&& aOther) = default;

  explicit inline NotificationAction(const NotificationAction& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  NotificationAction&
  operator=(const NotificationAction& aOther);

private:
  static bool
  InitIds(JSContext* cx, NotificationActionAtoms* atomsCache);
};

namespace binding_detail {
struct FastNotificationAction : public NotificationAction
{
  inline FastNotificationAction()
    : NotificationAction(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class NotificationPermissionCallback : public CallbackFunction
{
public:
  explicit inline NotificationPermissionCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NotificationPermissionCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NotificationPermissionCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NotificationPermissionCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, NotificationPermission permission, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "NotificationPermissionCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, permission, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(NotificationPermission permission, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "NotificationPermissionCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, permission, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, NotificationPermission permission, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, permission, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(NotificationPermission permission, const char* aExecutionReason = nullptr)
  {
    return Call(permission, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const NotificationPermissionCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, NotificationPermission permission, ErrorResult& aRv);
};


namespace binding_detail {
class FastNotificationPermissionCallback : public NotificationPermissionCallback
{
public:
  explicit inline FastNotificationPermissionCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : NotificationPermissionCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    NotificationPermissionCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    NotificationPermissionCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class UnsignedLongOrUnsignedLongSequence : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnsignedLong,
    eUnsignedLongSequence
  };
public:
  enum class Type
  {
    eUnsignedLong = TypeOrUninit::eUnsignedLong,
    eUnsignedLongSequence = TypeOrUninit::eUnsignedLongSequence
  };

private:
  union Value
  {
    UnionMember<uint32_t > mUnsignedLong;
    UnionMember<binding_detail::AutoSequence<uint32_t> > mUnsignedLongSequence;

  };

  TypeOrUninit mType;
  Value mValue;

  UnsignedLongOrUnsignedLongSequence(const UnsignedLongOrUnsignedLongSequence&) = delete;
  UnsignedLongOrUnsignedLongSequence& operator=(const UnsignedLongOrUnsignedLongSequence&) = delete;
public:
  explicit inline UnsignedLongOrUnsignedLongSequence()
    : mType(eUninitialized)
  {
  }

  inline ~UnsignedLongOrUnsignedLongSequence()
  {
    Uninit();
  }

  [[nodiscard]] inline uint32_t&
  RawSetAsUnsignedLong()
  {
    if (mType == eUnsignedLong) {
      return mValue.mUnsignedLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnsignedLong;
    return mValue.mUnsignedLong.SetValue();
  }

  [[nodiscard]] inline uint32_t&
  SetAsUnsignedLong()
  {
    if (mType == eUnsignedLong) {
      return mValue.mUnsignedLong.Value();
    }
    Uninit();
    mType = eUnsignedLong;
    return mValue.mUnsignedLong.SetValue();
  }

  inline bool
  IsUnsignedLong() const
  {
    return mType == eUnsignedLong;
  }

  inline uint32_t&
  GetAsUnsignedLong()
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLong(), "Wrong type!");
    return mValue.mUnsignedLong.Value();
  }

  inline uint32_t
  GetAsUnsignedLong() const
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLong(), "Wrong type!");
    return mValue.mUnsignedLong.Value();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<uint32_t>&
  RawSetAsUnsignedLongSequence()
  {
    if (mType == eUnsignedLongSequence) {
      return mValue.mUnsignedLongSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnsignedLongSequence;
    return mValue.mUnsignedLongSequence.SetValue();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<uint32_t>&
  SetAsUnsignedLongSequence()
  {
    if (mType == eUnsignedLongSequence) {
      return mValue.mUnsignedLongSequence.Value();
    }
    Uninit();
    mType = eUnsignedLongSequence;
    return mValue.mUnsignedLongSequence.SetValue();
  }

  inline bool
  IsUnsignedLongSequence() const
  {
    return mType == eUnsignedLongSequence;
  }

  inline binding_detail::AutoSequence<uint32_t>&
  GetAsUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  inline const Sequence<uint32_t>&
  GetAsUnsignedLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnsignedLong: {
        DestroyUnsignedLong();
        break;
      }
      case eUnsignedLongSequence: {
        DestroyUnsignedLongSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUnsignedLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUnsignedLong()
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLong(), "Wrong type!");
    mValue.mUnsignedLong.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    mValue.mUnsignedLongSequence.Destroy();
    mType = eUninitialized;
  }
};


class OwningUnsignedLongOrUnsignedLongSequence : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnsignedLong,
    eUnsignedLongSequence
  };
public:
  enum class Type
  {
    eUnsignedLong = TypeOrUninit::eUnsignedLong,
    eUnsignedLongSequence = TypeOrUninit::eUnsignedLongSequence
  };

private:
  union Value
  {
    UnionMember<uint32_t > mUnsignedLong;
    UnionMember<Sequence<uint32_t> > mUnsignedLongSequence;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUnsignedLongOrUnsignedLongSequence()
    : mType(eUninitialized)
  {
  }

  OwningUnsignedLongOrUnsignedLongSequence(OwningUnsignedLongOrUnsignedLongSequence&& aOther);

  explicit inline OwningUnsignedLongOrUnsignedLongSequence(const OwningUnsignedLongOrUnsignedLongSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnsignedLongOrUnsignedLongSequence()
  {
    Uninit();
  }

  [[nodiscard]] uint32_t&
  RawSetAsUnsignedLong();

  [[nodiscard]] uint32_t&
  SetAsUnsignedLong();

  inline bool
  IsUnsignedLong() const
  {
    return mType == eUnsignedLong;
  }

  inline uint32_t&
  GetAsUnsignedLong()
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLong(), "Wrong type!");
    return mValue.mUnsignedLong.Value();
  }

  inline uint32_t const &
  GetAsUnsignedLong() const
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLong(), "Wrong type!");
    return mValue.mUnsignedLong.Value();
  }

  [[nodiscard]] Sequence<uint32_t>&
  RawSetAsUnsignedLongSequence();

  [[nodiscard]] Sequence<uint32_t>&
  SetAsUnsignedLongSequence();

  inline bool
  IsUnsignedLongSequence() const
  {
    return mType == eUnsignedLongSequence;
  }

  inline Sequence<uint32_t>&
  GetAsUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  inline Sequence<uint32_t> const &
  GetAsUnsignedLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUnsignedLongOrUnsignedLongSequence&
  operator=(OwningUnsignedLongOrUnsignedLongSequence&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUnsignedLongOrUnsignedLongSequence&
  operator=(const OwningUnsignedLongOrUnsignedLongSequence& aOther);

private:
  bool
  TrySetToUnsignedLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUnsignedLong();

  bool
  TrySetToUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUnsignedLongSequence();
};


struct NotificationOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<NotificationAction> mActions;
  MOZ_INIT_OUTSIDE_CTOR nsString mBody;
  MOZ_INIT_OUTSIDE_CTOR JS::Value mData;
  MOZ_INIT_OUTSIDE_CTOR NotificationDirection mDir;
  MOZ_INIT_OUTSIDE_CTOR nsCString mIcon;
  MOZ_INIT_OUTSIDE_CTOR nsString mLang;
  MOZ_INIT_OUTSIDE_CTOR bool mRequireInteraction;
  MOZ_INIT_OUTSIDE_CTOR bool mSilent;
  MOZ_INIT_OUTSIDE_CTOR nsString mTag;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningUnsignedLongOrUnsignedLongSequence> mVibrate;

  NotificationOptions();

  explicit inline NotificationOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  NotificationOptions(NotificationOptions&& aOther) = default;

private:
  NotificationOptions(const NotificationOptions&) = delete;
  NotificationOptions& operator=(const NotificationOptions&) = delete;

  static bool
  InitIds(JSContext* cx, NotificationOptionsAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastNotificationOptions : public NotificationOptions
{
  inline FastNotificationOptions()
    : NotificationOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Notification_Binding {

  typedef mozilla::dom::Notification NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::Notification* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedVibrateValue(mozilla::dom::Notification* aObject);

  void
  ClearCachedActionsValue(mozilla::dom::Notification* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Notification,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Notification_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::NotificationPermission>
{
  static constexpr dom::NotificationPermission value = dom::NotificationPermission::Granted;

  static_assert(static_cast<uint8_t>(dom::NotificationPermission::Default) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::NotificationPermission>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::NotificationDirection>
{
  static constexpr dom::NotificationDirection value = dom::NotificationDirection::Rtl;

  static_assert(static_cast<uint8_t>(dom::NotificationDirection::Auto) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::NotificationDirection>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_NOTIFICATIONBINDING_H_
