#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomMediaRule = 975,
  CSSCustomPropertyRegisteredEvent = 994,
  CSSFontFaceRule = 1027,
  CSSFontFeatureValuesRule = 1043,
  CSSFontPaletteValuesRule = 1068,
  CSSGroupingRule = 1093,
  CSSHSL = 1109,
  CSSHWB = 1116,
  CSSImageValue = 1123,
  CSSImportRule = 1137,
  CSSKeyframeRule = 1151,
  CSSKeyframesRule = 1167,
  CSSKeywordValue = 1184,
  CSSLCH = 1200,
  CSSLab = 1207,
  CSSLayerBlockRule = 1214,
  CSSLayerStatementRule = 1232,
  CSSMarginRule = 1254,
  CSSMathClamp = 1268,
  CSSMathInvert = 1281,
  CSSMathMax = 1295,
  CSSMathMin = 1306,
  CSSMathNegate = 1317,
  CSSMathProduct = 1331,
  CSSMathSum = 1346,
  CSSMathValue = 1357,
  CSSMatrixComponent = 1370,
  CSSMediaRule = 1389,
  CSSMozDocumentRule = 1402,
  CSSNamespaceRule = 1421,
  CSSNestedDeclarations = 1438,
  CSSNumericArray = 1460,
  CSSNumericValue = 1476,
  CSSOKLCH = 1492,
  CSSOKLab = 1501,
  CSSPageDescriptors = 1510,
  CSSPageRule = 1529,
  CSSPerspective = 1541,
  CSSPositionTryDescriptors = 1556,
  CSSPositionTryRule = 1582,
  CSSPropertyRule = 1601,
  CSSPseudoElement = 1617,
  CSSRGB = 1634,
  CSSRotate = 1641,
  CSSRule = 1651,
  CSSRuleList = 1659,
  CSSScale = 1671,
  CSSScopeRule = 1680,
  CSSSkew = 1693,
  CSSSkewX = 1701,
  CSSSkewY = 1710,
  CSSStartingStyleRule = 1719,
  CSSStyleDeclaration = 1740,
  CSSStyleProperties = 1760,
  CSSStyleRule = 1779,
  CSSStyleSheet = 1792,
  CSSStyleValue = 1806,
  CSSSupportsRule = 1820,
  CSSTransformComponent = 1836,
  CSSTransformValue = 1858,
  CSSTransition = 1876,
  CSSTranslate = 1890,
  CSSUnitValue = 1903,
  CSSUnparsedValue = 1916,
  CSSVariableReferenceValue = 1933,
  Cache = 1959,
  CacheStorage = 1965,
  CallbackDebuggerNotification = 1978,
  CanonicalBrowsingContext = 2007,
  CanvasCaptureMediaStream = 2032,
  CanvasGradient = 2057,
  CanvasPattern = 2072,
  CanvasRenderingContext2D = 2086,
  CaretPosition = 2111,
  CaretStateChangedEvent = 2125,
  ChannelMergerNode = 2148,
  ChannelSplitterNode = 2166,
  ChannelWrapper = 2186,
  CharacterData = 2201,
  CheckerboardReportService = 2215,
  ChildProcessMessageManager = 2241,
  ChildSHistory = 2268,
  ChromeMessageBroadcaster = 2282,
  ChromeMessageSender = 2307,
  ChromeNodeList = 2327,
  ChromeUtils = 2342,
  ChromeWorker = 2354,
  Client = 2367,
  Clients = 2374,
  Clipboard = 2382,
  ClipboardEvent = 2392,
  ClipboardItem = 2407,
  ClonedErrorHolder = 2421,
  CloseEvent = 2439,
  CloseWatcher = 2450,
  CommandEvent = 2463,
  Comment = 2476,
  CompositionEvent = 2484,
  CompressionStream = 2501,
  ConsoleInstance = 2519,
  ConstantSourceNode = 2535,
  ContentFrameMessageManager = 2554,
  ContentProcessMessageManager = 2581,
  ContentVisibilityAutoStateChangeEvent = 2610,
  ConvolverNode = 2648,
  CookieChangeEvent = 2662,
  CookieStore = 2680,
  CookieStoreManager = 2692,
  CountQueuingStrategy = 2711,
  CreateOfferRequest = 2732,
  Credential = 2751,
  CredentialsContainer = 2762,
  Crypto = 2783,
  CryptoKey = 2790,
  CustomElementRegistry = 2800,
  CustomEvent = 2822,
  CustomStateSet = 2834,
  DOMException = 2849,
  DOMImplementation = 2862,
  DOMLocalization = 2880,
  DOMMatrix = 2896,
  DOMMatrixReadOnly = 2906,
  DOMParser = 2924,
  DOMPoint = 2934,
  DOMPointReadOnly = 2943,
  DOMQuad = 2960,
  DOMRect = 2968,
  DOMRectList = 2976,
  DOMRectReadOnly = 2988,
  DOMStringList = 3004,
  DOMStringMap = 3018,
  DOMTokenList = 3031,
  DataTransfer = 3044,
  DataTransferItem = 3057,
  DataTransferItemList = 3074,
  DebuggerNotification = 3095,
  DebuggerNotificationObserver = 3116,
  DecompressionStream = 3145,
  DedicatedWorkerGlobalScope = 3165,
  DelayNode = 3192,
  DeprecationReportBody = 3202,
  DeviceAcceleration = 3224,
  DeviceLightEvent = 3243,
  DeviceMotionEvent = 3260,
  DeviceOrientationEvent = 3278,
  DeviceRotationRate = 3301,
  Directory = 3320,
  Document = 3330,
  DocumentFragment = 3339,
  DocumentL10n = 3356,
  DocumentTimeline = 3369,
  DocumentType = 3386,
  DominatorTree = 3399,
  DragEvent = 3413,
  DynamicsCompressorNode = 3423,
  EXT_blend_minmax = 3446,
  EXT_color_buffer_float = 3463,
  EXT_color_buffer_half_float = 3486,
  EXT_depth_clamp = 3514,
  EXT_disjoint_timer_query = 3530,
  EXT_float_blend = 3555,
  EXT_frag_depth = 3571,
  EXT_sRGB = 3586,
  EXT_shader_texture_lod = 3595,
  EXT_texture_compression_bptc = 3618,
  EXT_texture_compression_rgtc = 3647,
  EXT_texture_filter_anisotropic = 3676,
  EXT_texture_norm16 = 3707,
  Element = 3726,
  ElementInternals = 3734,
  EncodedAudioChunk = 3751,
  EncodedVideoChunk = 3769,
  ErrorEvent = 3787,
  Event = 3798,
  EventCallbackDebuggerNotification = 3804,
  EventCounts = 3838,
  EventSource = 3850,
  EventTarget = 3862,
  Exception = 3874,
  ExtendableCookieChangeEvent = 3884,
  ExtendableEvent = 3912,
  ExtendableMessageEvent = 3928,
  ExtensionAlarms = 3951,
  ExtensionBrowser = 3967,
  ExtensionBrowserSettings = 3984,
  ExtensionBrowserSettingsColorManagement = 4009,
  ExtensionDns = 4049,
  ExtensionEventManager = 4062,
  ExtensionMockAPI = 4084,
  ExtensionPort = 4101,
  ExtensionProxy = 4115,
  ExtensionRuntime = 4130,
  ExtensionScripting = 4147,
  ExtensionSetting = 4166,
  ExtensionTest = 4183,
  External = 4197,
  FeaturePolicy = 4206,
  FeaturePolicyViolationReportBody = 4220,
  FetchEvent = 4253,
  FetchObserver = 4264,
  File = 4278,
  FileList = 4283,
  FileReader = 4292,
  FileReaderSync = 4303,
  FileSystem = 4318,
  FileSystemDirectoryEntry = 4329,
  FileSystemDirectoryHandle = 4354,
  FileSystemDirectoryHandle_AsyncIterator = 4380,
  FileSystemDirectoryIterator = 4420,
  FileSystemDirectoryReader = 4448,
  FileSystemEntry = 4474,
  FileSystemFileEntry = 4490,
  FileSystemFileHandle = 4510,
  FileSystemHandle = 4531,
  FileSystemSyncAccessHandle = 4548,
  FileSystemWritableFileStream = 4575,
  Flex = 4604,
  FlexItemValues = 4609,
  FlexLineValues = 4624,
  FluentBundle = 4639,
  FluentBundleAsyncIterator = 4652,
  FluentBundleIterator = 4678,
  FluentPattern = 4699,
  FluentResource = 4713,
  FocusEvent = 4728,
  FontFace = 4739,
  FontFaceSet = 4748,
  FontFaceSetIterator = 4760,
  FontFaceSetLoadEvent = 4780,
  FormData = 4801,
  FormData_Iterator = 4810,
  FormDataEvent = 4828,
  FragmentDirective = 4842,
  FrameCrashedEvent = 4860,
  FrameLoader = 4878,
  GPU = 4890,
  GPUAdapter = 4894,
  GPUAdapterInfo = 4905,
  GPUBindGroup = 4920,
  GPUBindGroupLayout = 4933,
  GPUBuffer = 4952,
  GPUBufferUsage = 4962,
  GPUCanvasContext = 4977,
  GPUColorWrite = 4994,
  GPUCommandBuffer = 5008,
  GPUCommandEncoder = 5025,
  GPUCompilationInfo = 5043,
  GPUCompilationMessage = 5062,
  GPUComputePassEncoder = 5084,
  GPUComputePipeline = 5106,
  GPUDevice = 5125,
  GPUDeviceLostInfo = 5135,
  GPUError = 5153,
  GPUExternalTexture = 5162,
  GPUInternalError = 5181,
  GPUMapMode = 5198,
  GPUOutOfMemoryError = 5209,
  GPUPipelineError = 5229,
  GPUPipelineLayout = 5246,
  GPUQuerySet = 5264,
  GPUQueue = 5276,
  GPURenderBundle = 5285,
  GPURenderBundleEncoder = 5301,
  GPURenderPassEncoder = 5324,
  GPURenderPipeline = 5345,
  GPUSampler = 5363,
  GPUShaderModule = 5374,
  GPUShaderStage = 5390,
  GPUSupportedFeatures = 5405,
  GPUSupportedLimits = 5426,
  GPUTexture = 5445,
  GPUTextureUsage = 5456,
  GPUTextureView = 5472,
  GPUUncapturedErrorEvent = 5487,
  GPUValidationError = 5511,
  GainNode = 5530,
  Gamepad = 5539,
  GamepadAxisMoveEvent = 5547,
  GamepadButton = 5568,
  GamepadButtonEvent = 5582,
  GamepadEvent = 5601,
  GamepadHapticActuator = 5614,
  GamepadLightIndicator = 5636,
  GamepadPose = 5658,
  GamepadServiceTest = 5670,
  GamepadTouch = 5689,
  Geolocation = 5702,
  GeolocationCoordinates = 5714,
  GeolocationPosition = 5737,
  GeolocationPositionError = 5757,
  GetUserMediaRequest = 5782,
  GleanBoolean = 5802,
  GleanCategory = 5815,
  GleanCounter = 5829,
  GleanCustomDistribution = 5842,
  GleanDatetime = 5866,
  GleanDenominator = 5880,
  GleanDualLabeledCounter = 5897,
  GleanEvent = 5921,
  GleanImpl = 5932,
  GleanLabeled = 5942,
  GleanMemoryDistribution = 5955,
  GleanMetric = 5979,
  GleanNumerator = 5991,
  GleanObject = 6006,
  GleanPingsImpl = 6018,
  GleanQuantity = 6033,
  GleanRate = 6047,
  GleanString = 6057,
  GleanStringList = 6069,
  GleanText = 6085,
  GleanTimespan = 6095,
  GleanTimingDistribution = 6109,
  GleanUrl = 6133,
  GleanUuid = 6142,
  Grid = 6152,
  GridArea = 6157,
  GridDimension = 6166,
  GridLine = 6180,
  GridLines = 6189,
  GridTrack = 6199,
  GridTracks = 6209,
  HTMLAllCollection = 6220,
  HTMLAnchorElement = 6238,
  HTMLAreaElement = 6256,
  HTMLAudioElement = 6272,
  HTMLBRElement = 6289,
  HTMLBaseElement = 6303,
  HTMLBodyElement = 6319,
  HTMLButtonElement = 6335,
  HTMLCanvasElement = 6353,
  HTMLCollection = 6371,
  HTMLDListElement = 6386,
  HTMLDataElement = 6403,
  HTMLDataListElement = 6419,
  HTMLDetailsElement = 6439,
  HTMLDialogElement = 6458,
  HTMLDirectoryElement = 6476,
  HTMLDivElement = 6497,
  HTMLDocument = 6512,
  HTMLElement = 6525,
  HTMLEmbedElement = 6537,
  HTMLFieldSetElement = 6554,
  HTMLFontElement = 6574,
  HTMLFormControlsCollection = 6590,
  HTMLFormElement = 6617,
  HTMLFrameElement = 6633,
  HTMLFrameSetElement = 6650,
  HTMLHRElement = 6670,
  HTMLHeadElement = 6684,
  HTMLHeadingElement = 6700,
  HTMLHtmlElement = 6719,
  HTMLIFrameElement = 6735,
  HTMLImageElement = 6753,
  HTMLInputElement = 6770,
  HTMLLIElement = 6787,
  HTMLLabelElement = 6801,
  HTMLLegendElement = 6818,
  HTMLLinkElement = 6836,
  HTMLMapElement = 6852,
  HTMLMarqueeElement = 6867,
  HTMLMediaElement = 6886,
  HTMLMenuElement = 6903,
  HTMLMetaElement = 6919,
  HTMLMeterElement = 6935,
  HTMLModElement = 6952,
  HTMLOListElement = 6967,
  HTMLObjectElement = 6984,
  HTMLOptGroupElement = 7002,
  HTMLOptionElement = 7022,
  HTMLOptionsCollection = 7040,
  HTMLOutputElement = 7062,
  HTMLParagraphElement = 7080,
  HTMLParamElement = 7101,
  HTMLPictureElement = 7118,
  HTMLPreElement = 7137,
  HTMLProgressElement = 7152,
  HTMLQuoteElement = 7172,
  HTMLScriptElement = 7189,
  HTMLSelectElement = 7207,
  HTMLSlotElement = 7225,
  HTMLSourceElement = 7241,
  HTMLSpanElement = 7259,
  HTMLStyleElement = 7275,
  HTMLTableCaptionElement = 7292,
  HTMLTableCellElement = 7316,
  HTMLTableColElement = 7337,
  HTMLTableElement = 7357,
  HTMLTableRowElement = 7374,
  HTMLTableSectionElement = 7394,
  HTMLTemplateElement = 7418,
  HTMLTextAreaElement = 7438,
  HTMLTimeElement = 7458,
  HTMLTitleElement = 7474,
  HTMLTrackElement = 7491,
  HTMLUListElement = 7508,
  HTMLUnknownElement = 7525,
  HTMLVideoElement = 7544,
  HashChangeEvent = 7561,
  Headers = 7577,
  Headers_Iterator = 7585,
  HeapSnapshot = 7602,
  Highlight = 7615,
  HighlightRegistry = 7625,
  History = 7643,
  IDBCursor = 7651,
  IDBCursorWithValue = 7661,
  IDBDatabase = 7680,
  IDBFactory = 7692,
  IDBIndex = 7703,
  IDBKeyRange = 7712,
  IDBObjectStore = 7724,
  IDBOpenDBRequest = 7739,
  IDBRequest = 7756,
  IDBTransaction = 7767,
  IDBVersionChangeEvent = 7782,
  IIRFilterNode = 7804,
  IOUtils = 7818,
  IdentityCredential = 7826,
  IdentityProvider = 7845,
  IdleDeadline = 7862,
  Image = 7875,
  ImageBitmap = 7881,
  ImageBitmapRenderingContext = 7893,
  ImageCapture = 7921,
  ImageCaptureError = 7934,
  ImageCaptureErrorEvent = 7952,
  ImageData = 7975,
  ImageDecoder = 7985,
  ImageDocument = 7998,
  ImageTrack = 8012,
  ImageTrackList = 8023,
  InferenceSession = 8038,
  InputEvent = 8055,
  InspectorCSSParser = 8066,
  InspectorFontFace = 8085,
  InspectorUtils = 8103,
  IntersectionObserver = 8118,
  IntersectionObserverEntry = 8139,
  IntlUtils = 8165,
  JSActorTypeUtils = 8175,
  JSProcessActorChild = 8192,
  JSProcessActorParent = 8212,
  JSWindowActorChild = 8233,
  JSWindowActorParent = 8252,
  KeyEvent = 8272,
  KeyboardEvent = 8281,
  KeyframeEffect = 8295,
  L10nFileSource = 8310,
  L10nOverlays = 8325,
  L10nRegistry = 8338,
  LargestContentfulPaint = 8351,
  LegacyMozTCPSocket = 8374,
  LlamaRunner = 8393,
  Localization = 8405,
  Location = 8418,
  Lock = 8427,
  LockManager = 8432,
  MIDIAccess = 8444,
  MIDIConnectionEvent = 8455,
  MIDIInput = 8475,
  MIDIInputMap = 8485,
  MIDIMessageEvent = 8498,
  MIDIOutput = 8515,
  MIDIOutputMap = 8526,
  MIDIPort = 8540,
  MLS = 8549,
  MLSGroupView = 8553,
  MOZ_debug = 8566,
  MatchGlob = 8576,
  MatchPattern = 8586,
  MatchPatternSet = 8599,
  MathMLElement = 8615,
  MediaCapabilities = 8629,
  MediaControlService = 8647,
  MediaController = 8667,
  MediaDeviceInfo = 8683,
  MediaDevices = 8699,
  MediaElementAudioSourceNode = 8712,
  MediaEncryptedEvent = 8740,
  MediaError = 8760,
  MediaKeyError = 8771,
  MediaKeyMessageEvent = 8785,
  MediaKeySession = 8806,
  MediaKeyStatusMap = 8822,
  MediaKeyStatusMap_Iterator = 8840,
  MediaKeySystemAccess = 8867,
  MediaKeys = 8888,
  MediaList = 8898,
  MediaMetadata = 8908,
  MediaQueryList = 8922,
  MediaQueryListEvent = 8937,
  MediaRecorder = 8957,
  MediaRecorderErrorEvent = 8971,
  MediaSession = 8995,
  MediaSource = 9008,
  MediaStream = 9020,
  MediaStreamAudioDestinationNode = 9032,
  MediaStreamAudioSourceNode = 9064,
  MediaStreamError = 9091,
  MediaStreamEvent = 9108,
  MediaStreamTrack = 9125,
  MediaStreamTrackAudioSourceNode = 9142,
  MediaStreamTrackEvent = 9174,
  MerchantValidationEvent = 9196,
  MessageBroadcaster = 9220,
  MessageChannel = 9239,
  MessageEvent = 9254,
  MessageListenerManager = 9267,
  MessagePort = 9290,
  MessageSender = 9302,
  MimeType = 9316,
  MimeTypeArray = 9325,
  MouseEvent = 9339,
  MouseScrollEvent = 9350,
  MozCanvasPrintState = 9367,
  MozDocumentMatcher = 9387,
  MozDocumentObserver = 9406,
  MozQueryInterface = 9426,
  MozSharedMap = 9444,
  MozSharedMap_Iterator = 9457,
  MozSharedMapChangeEvent = 9479,
  MozStorageAsyncStatementParams = 9503,
  MozStorageStatementParams = 9534,
  MozStorageStatementRow = 9560,
  MozWritableSharedMap = 9583,
  MutationObserver = 9604,
  MutationRecord = 9621,
  NamedNodeMap = 9636,
  NavigateEvent = 9649,
  Navigation = 9663,
  NavigationActivation = 9674,
  NavigationCurrentEntryChangeEvent = 9695,
  NavigationDestination = 9729,
  NavigationHistoryEntry = 9751,
  NavigationPrecommitController = 9774,
  NavigationPreloadManager = 9804,
  NavigationTransition = 9829,
  Navigator = 9850,
  NavigatorLogin = 9860,
  NetworkInformation = 9875,
  Node = 9894,
  NodeFilter = 9899,
  NodeIterator = 9910,
  NodeList = 9923,
  Notification = 9932,
  NotificationEvent = 9945,
  NotifyPaintEvent = 9963,
  OES_draw_buffers_indexed = 9980,
  OES_element_index_uint = 10005,
  OES_fbo_render_mipmap = 10028,
  OES_standard_derivatives = 10050,
  OES_texture_float = 10075,
  OES_texture_float_linear = 10093,
  OES_texture_half_float = 10118,
  OES_texture_half_float_linear = 10141,
  OES_vertex_array_object = 10171,
  OVR_multiview2 = 10195,
  OfflineAudioCompletionEvent = 10210,
  OfflineAudioContext = 10238,
  OffscreenCanvas = 10258,
  OffscreenCanvasRenderingContext2D = 10274,
  Option = 10308,
  OscillatorNode = 10315,
  PageTransitionEvent = 10330,
  PaintRequest = 10350,
  PaintRequestList = 10363,
  PaintWorkletGlobalScope = 10380,
  PannerNode = 10404,
  ParentProcessMessageManager = 10415,
  Path2D = 10443,
  PathUtils = 10450,
  PaymentAddress = 10460,
  PaymentMethodChangeEvent = 10475,
  PaymentRequest = 10500,
  PaymentRequestUpdateEvent = 10515,
  PaymentResponse = 10541,
  PeerConnectionImpl = 10557,
  PeerConnectionObserver = 10576,
  Performance = 10599,
  PerformanceEntry = 10611,
  PerformanceEntryEvent = 10628,
  PerformanceEventTiming = 10650,
  PerformanceMark = 10673,
  PerformanceMeasure = 10689,
  PerformanceNavigation = 10708,
  PerformanceNavigationTiming = 10730,
  PerformanceObserver = 10758,
  PerformanceObserverEntryList = 10778,
  PerformancePaintTiming = 10807,
  PerformanceResourceTiming = 10830,
  PerformanceServerTiming = 10856,
  PerformanceTiming = 10880,
  PeriodicWave = 10898,
  PermissionStatus = 10911,
  Permissions = 10928,
  PlacesBookmark = 10940,
  PlacesBookmarkAddition = 10955,
  PlacesBookmarkChanged = 10978,
  PlacesBookmarkGuid = 11000,
  PlacesBookmarkKeyword = 11019,
  PlacesBookmarkMoved = 11041,
  PlacesBookmarkRemoved = 11061,
  PlacesBookmarkTags = 11083,
  PlacesBookmarkTime = 11102,
  PlacesBookmarkTitle = 11121,
  PlacesBookmarkUrl = 11141,
  PlacesEvent = 11159,
  PlacesEventCounts = 11171,
  PlacesFavicon = 11189,
  PlacesHistoryCleared = 11203,
  PlacesObservers = 11224,
  PlacesPurgeCaches = 11240,
  PlacesRanking = 11258,
  PlacesVisit = 11272,
  PlacesVisitRemoved = 11284,
  PlacesVisitTitle = 11303,
  PlacesWeakCallbackWrapper = 11320,
  Plugin = 11346,
  PluginArray = 11353,
  PluginCrashedEvent = 11365,
  PointerEvent = 11384,
  PopStateEvent = 11397,
  PopupBlockedEvent = 11411,
  PopupPositionedEvent = 11429,
  PositionStateEvent = 11450,
  PrecompiledScript = 11469,
  PrivateAttribution = 11487,
  ProcessMessageManager = 11506,
  ProcessingInstruction = 11528,
  ProgressEvent = 11550,
  PromiseDebugging = 11564,
  PromiseNativeHandler = 11581,
  PromiseRejectionEvent = 11602,
  PublicKeyCredential = 11624,
  PushEvent = 11644,
  PushManager = 11654,
  PushManagerImpl = 11666,
  PushMessageData = 11682,
  PushSubscription = 11698,
  PushSubscriptionChangeEvent = 11715,
  PushSubscriptionOptions = 11743,
  RTCCertificate = 11767,
  RTCDTMFSender = 11782,
  RTCDTMFToneChangeEvent = 11796,
  RTCDataChannel = 11819,
  RTCDataChannelEvent = 11834,
  RTCDtlsTransport = 11854,
  RTCEncodedAudioFrame = 11871,
  RTCEncodedVideoFrame = 11892,
  RTCIceCandidate = 11913,
  RTCIceTransport = 11929,
  RTCIdentityProviderRegistrar = 11945,
  RTCPeerConnection = 11974,
  RTCPeerConnectionIceEvent = 11992,
  RTCPeerConnectionStatic = 12018,
  RTCRtpReceiver = 12042,
  RTCRtpScriptTransform = 12057,
  RTCRtpScriptTransformer = 12079,
  RTCRtpSender = 12103,
  RTCRtpTransceiver = 12116,
  RTCSctpTransport = 12134,
  RTCSessionDescription = 12151,
  RTCStatsReport = 12173,
  RTCTrackEvent = 12188,
  RTCTransformEvent = 12202,
  RadioNodeList = 12220,
  Range = 12234,
  ReadableByteStreamController = 12240,
  ReadableStream = 12269,
  ReadableStream_AsyncIterator = 12284,
  ReadableStreamBYOBReader = 12313,
  ReadableStreamBYOBRequest = 12338,
  ReadableStreamDefaultController = 12364,
  ReadableStreamDefaultReader = 12396,
  RedirectBlockedEvent = 12424,
  Report = 12445,
  ReportBody = 12452,
  ReportingObserver = 12463,
  Request = 12481,
  ResizeObserver = 12489,
  ResizeObserverEntry = 12504,
  ResizeObserverSize = 12524,
  Response = 12543,
  SVGAElement = 12552,
  SVGAngle = 12564,
  SVGAnimateElement = 12573,
  SVGAnimateMotionElement = 12591,
  SVGAnimateTransformElement = 12615,
  SVGAnimatedAngle = 12642,
  SVGAnimatedBoolean = 12659,
  SVGAnimatedEnumeration = 12678,
  SVGAnimatedInteger = 12701,
  SVGAnimatedLength = 12720,
  SVGAnimatedLengthList = 12738,
  SVGAnimatedNumber = 12760,
  SVGAnimatedNumberList = 12778,
  SVGAnimatedPreserveAspectRatio = 12800,
  SVGAnimatedRect = 12831,
  SVGAnimatedString = 12847,
  SVGAnimatedTransformList = 12865,
  SVGAnimationElement = 12890,
  SVGCircleElement = 12910,
  SVGClipPathElement = 12927,
  SVGComponentTransferFunctionElement = 12946,
  SVGDefsElement = 12982,
  SVGDescElement = 12997,
  SVGElement = 13012,
  SVGEllipseElement = 13023,
  SVGFEBlendElement = 13041,
  SVGFEColorMatrixElement = 13059,
  SVGFEComponentTransferElement = 13083,
  SVGFECompositeElement = 13113,
  SVGFEConvolveMatrixElement = 13135,
  SVGFEDiffuseLightingElement = 13162,
  SVGFEDisplacementMapElement = 13190,
  SVGFEDistantLightElement = 13218,
  SVGFEDropShadowElement = 13243,
  SVGFEFloodElement = 13266,
  SVGFEFuncAElement = 13284,
  SVGFEFuncBElement = 13302,
  SVGFEFuncGElement = 13320,
  SVGFEFuncRElement = 13338,
  SVGFEGaussianBlurElement = 13356,
  SVGFEImageElement = 13381,
  SVGFEMergeElement = 13399,
  SVGFEMergeNodeElement = 13417,
  SVGFEMorphologyElement = 13439,
  SVGFEOffsetElement = 13462,
  SVGFEPointLightElement = 13481,
  SVGFESpecularLightingElement = 13504,
  SVGFESpotLightElement = 13533,
  SVGFETileElement = 13555,
  SVGFETurbulenceElement = 13572,
  SVGFilterElement = 13595,
  SVGForeignObjectElement = 13612,
  SVGGElement = 13636,
  SVGGeometryElement = 13648,
  SVGGradientElement = 13667,
  SVGGraphicsElement = 13686,
  SVGImageElement = 13705,
  SVGLength = 13721,
  SVGLengthList = 13731,
  SVGLineElement = 13745,
  SVGLinearGradientElement = 13760,
  SVGMPathElement = 13785,
  SVGMarkerElement = 13801,
  SVGMaskElement = 13818,
  SVGMatrix = 13833,
  SVGMetadataElement = 13843,
  SVGNumber = 13862,
  SVGNumberList = 13872,
  SVGPathElement = 13886,
  SVGPathSegment = 13901,
  SVGPatternElement = 13916,
  SVGPoint = 13934,
  SVGPointList = 13943,
  SVGPolygonElement = 13956,
  SVGPolylineElement = 13974,
  SVGPreserveAspectRatio = 13993,
  SVGRadialGradientElement = 14016,
  SVGRect = 14041,
  SVGRectElement = 14049,
  SVGSVGElement = 14064,
  SVGScriptElement = 14078,
  SVGSetElement = 14095,
  SVGStopElement = 14109,
  SVGStringList = 14124,
  SVGStyleElement = 14138,
  SVGSwitchElement = 14154,
  SVGSymbolElement = 14171,
  SVGTSpanElement = 14188,
  SVGTextContentElement = 14204,
  SVGTextElement = 14226,
  SVGTextPathElement = 14241,
  SVGTextPositioningElement = 14260,
  SVGTitleElement = 14286,
  SVGTransform = 14302,
  SVGTransformList = 14315,
  SVGUnitTypes = 14332,
  SVGUseElement = 14345,
  SVGViewElement = 14359,
  Sanitizer = 14374,
  Scheduler = 14384,
  Screen = 14394,
  ScreenLuminance = 14401,
  ScreenOrientation = 14417,
  ScriptProcessorNode = 14435,
  ScrollAreaEvent = 14455,
  SecurityPolicyViolationEvent = 14471,
  Selection = 14500,
  ServiceWorker = 14510,
  ServiceWorkerContainer = 14524,
  ServiceWorkerGlobalScope = 14547,
  ServiceWorkerRegistration = 14572,
  SessionStoreFormData = 14598,
  SessionStoreScrollData = 14619,
  SessionStoreUtils = 14642,
  ShadowRealmGlobalScope = 14660,
  ShadowRoot = 14683,
  SharedWorker = 14694,
  SharedWorkerGlobalScope = 14707,
  SimpleGestureEvent = 14731,
  SourceBuffer = 14750,
  SourceBufferList = 14763,
  SpeechGrammar = 14780,
  SpeechGrammarList = 14794,
  SpeechRecognition = 14812,
  SpeechRecognitionAlternative = 14830,
  SpeechRecognitionError = 14859,
  SpeechRecognitionEvent = 14882,
  SpeechRecognitionResult = 14905,
  SpeechRecognitionResultList = 14929,
  SpeechSynthesis = 14957,
  SpeechSynthesisErrorEvent = 14973,
  SpeechSynthesisEvent = 14999,
  SpeechSynthesisUtterance = 15020,
  SpeechSynthesisVoice = 15045,
  StaticRange = 15066,
  StereoPannerNode = 15078,
  Storage = 15095,
  StorageEvent = 15103,
  StorageManager = 15116,
  StreamFilter = 15131,
  StreamFilterDataEvent = 15144,
  StructuredCloneHolder = 15166,
  StructuredCloneTester = 15188,
  StylePropertyMap = 15210,
  StylePropertyMapReadOnly = 15227,
  StylePropertyMapReadOnly_Iterator = 15252,
  StyleSheet = 15286,
  StyleSheetApplicableStateChangeEvent = 15297,
  StyleSheetList = 15334,
  StyleSheetRemovedEvent = 15349,
  SubmitEvent = 15372,
  SubtleCrypto = 15384,
  SyncMessageSender = 15397,
  SyncReadFile = 15415,
  TCPServerSocket = 15428,
  TCPServerSocketEvent = 15444,
  TCPSocket = 15465,
  TCPSocketErrorEvent = 15475,
  TCPSocketEvent = 15495,
  TaskController = 15510,
  TaskPriorityChangeEvent = 15525,
  TaskSignal = 15549,
  Tensor = 15560,
  TestUtils = 15567,
  TestingDeprecatedInterface = 15577,
  Text = 15604,
  TextClause = 15609,
  TextDecoder = 15620,
  TextDecoderStream = 15632,
  TextEncoder = 15650,
  TextEncoderStream = 15662,
  TextEvent = 15680,
  TextMetrics = 15690,
  TextTrack = 15702,
  TextTrackCue = 15712,
  TextTrackCueList = 15725,
  TextTrackList = 15742,
  TimeEvent = 15756,
  TimeRanges = 15766,
  ToggleEvent = 15777,
  Touch = 15789,
  TouchEvent = 15795,
  TouchList = 15806,
  TrackEvent = 15816,
  TransformStream = 15827,
  TransformStreamDefaultController = 15843,
  TransitionEvent = 15876,
  TreeColumn = 15892,
  TreeColumns = 15903,
  TreeContentView = 15915,
  TreeWalker = 15931,
  TrustedHTML = 15942,
  TrustedScript = 15954,
  TrustedScriptURL = 15968,
  TrustedTypePolicy = 15985,
  TrustedTypePolicyFactory = 16003,
  UDPMessageEvent = 16028,
  UDPSocket = 16044,
  UIEvent = 16054,
  URL = 16062,
  URLPattern = 16066,
  URLSearchParams = 16077,
  URLSearchParams_Iterator = 16093,
  UniFFIPointer = 16118,
  UniFFIScaffolding = 16132,
  UserActivation = 16150,
  UserInteraction = 16165,
  UserProximityEvent = 16181,
  VRDisplay = 16200,
  VRDisplayCapabilities = 16210,
  VRDisplayEvent = 16232,
  VREyeParameters = 16247,
  VRFieldOfView = 16263,
  VRFrameData = 16277,
  VRMockController = 16289,
  VRMockDisplay = 16306,
  VRPose = 16320,
  VRServiceTest = 16327,
  VRStageParameters = 16341,
  VTTCue = 16359,
  VTTRegion = 16366,
  ValidityState = 16376,
  VideoColorSpace = 16390,
  VideoDecoder = 16406,
  VideoEncoder = 16419,
  VideoFrame = 16432,
  VideoPlaybackQuality = 16443,
  VideoTrack = 16464,
  VideoTrackList = 16475,
  ViewTransition = 16490,
  VisualViewport = 16505,
  WEBGL_color_buffer_float = 16520,
  WEBGL_compressed_texture_astc = 16545,
  WEBGL_compressed_texture_etc = 16575,
  WEBGL_compressed_texture_etc1 = 16604,
  WEBGL_compressed_texture_pvrtc = 16634,
  WEBGL_compressed_texture_s3tc = 16665,
  WEBGL_compressed_texture_s3tc_srgb = 16695,
  WEBGL_debug_renderer_info = 16730,
  WEBGL_debug_shaders = 16756,
  WEBGL_depth_texture = 16776,
  WEBGL_draw_buffers = 16796,
  WEBGL_explicit_present = 16815,
  WEBGL_lose_context = 16838,
  WEBGL_provoking_vertex = 16857,
  WGSLLanguageFeatures = 16880,
  WakeLock = 16901,
  WakeLockSentinel = 16910,
  WaveShaperNode = 16927,
  WebExtensionContentScript = 16942,
  WebExtensionPolicy = 16968,
  WebGL2RenderingContext = 16987,
  WebGLActiveInfo = 17010,
  WebGLBuffer = 17026,
  WebGLContextEvent = 17038,
  WebGLFramebuffer = 17056,
  WebGLProgram = 17073,
  WebGLQuery = 17086,
  WebGLRenderbuffer = 17097,
  WebGLRenderingContext = 17115,
  WebGLSampler = 17137,
  WebGLShader = 17150,
  WebGLShaderPrecisionFormat = 17162,
  WebGLSync = 17189,
  WebGLTexture = 17199,
  WebGLTransformFeedback = 17212,
  WebGLUniformLocation = 17235,
  WebGLVertexArrayObject = 17256,
  WebKitCSSMatrix = 17279,
  WebSocket = 17295,
  WebTransport = 17305,
  WebTransportBidirectionalStream = 17318,
  WebTransportDatagramDuplexStream = 17350,
  WebTransportError = 17383,
  WebTransportReceiveStream = 17401,
  WebTransportSendStream = 17427,
  WebrtcGlobalInformation = 17450,
  WheelEvent = 17474,
  Window = 17485,
  WindowClient = 17492,
  WindowContext = 17505,
  WindowGlobalChild = 17519,
  WindowGlobalParent = 17537,
  WindowRoot = 17556,
  Worker = 17567,
  WorkerDebuggerGlobalScope = 17574,
  WorkerGlobalScope = 17600,
  WorkerLocation = 17618,
  WorkerNavigator = 17633,
  WorkerTestUtils = 17649,
  Worklet = 17665,
  WorkletGlobalScope = 17673,
  WritableStream = 17692,
  WritableStreamDefaultController = 17707,
  WritableStreamDefaultWriter = 17739,
  XMLDocument = 17767,
  XMLHttpRequest = 17779,
  XMLHttpRequestEventTarget = 17794,
  XMLHttpRequestUpload = 17820,
  XMLSerializer = 17841,
  XPathEvaluator = 17855,
  XPathExpression = 17870,
  XPathResult = 17886,
  XRBoundedReferenceSpace = 17898,
  XRFrame = 17922,
  XRInputSource = 17930,
  XRInputSourceArray = 17944,
  XRInputSourceEvent = 17963,
  XRInputSourcesChangeEvent = 17982,
  XRPose = 18008,
  XRReferenceSpace = 18015,
  XRReferenceSpaceEvent = 18032,
  XRRenderState = 18054,
  XRRigidTransform = 18068,
  XRSession = 18085,
  XRSessionEvent = 18095,
  XRSpace = 18110,
  XRSystem = 18118,
  XRView = 18127,
  XRViewerPose = 18134,
  XRViewport = 18147,
  XRWebGLLayer = 18158,
  XSLTProcessor = 18171,
  XULCommandEvent = 18185,
  XULElement = 18201,
  XULFrameElement = 18212,
  XULMenuElement = 18228,
  XULPopupElement = 18243,
  XULResizerElement = 18259,
  XULTextElement = 18277,
  XULTreeElement = 18292,
  console = 18307,
  webkitSpeechGrammar = 18315,
  webkitSpeechGrammarList = 18335,
  webkitSpeechRecognition = 18359,
  webkitURL = 18383,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
