/* THIS FILE IS AUTOGENERATED FROM CSSStyleProperties.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "CSSStyleDeclarationBinding.h"
#include "CSSStylePropertiesBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/BasePrincipal.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CustomElementRegistry.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMJSProxyHandler.h"
#include "mozilla/dom/DocGroup.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/ProxyHandlerUtils.h"
#include "mozilla/dom/WebIDLPrefs.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsCSSProps.h"
#include "nsContentUtils.h"
#include "nsDOMCSSDeclaration.h"
#include "nsJSPrincipals.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace CSSStyleProperties_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<CSSStyleDeclaration_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
GetPropertyValue(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args, NonCustomCSSPropertyId id)
{
  const char* attrName = nsCSSProps::PropertyIDLName(id);
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSStyleProperties", attrName, DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsDOMCSSDeclaration*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetPropertyValue(id, result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetPropertyValue(id, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
SetPropertyValue(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args, NonCustomCSSPropertyId id)
{
  const char* attrName = nsCSSProps::PropertyIDLName(id);
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSStyleProperties", attrName, DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsDOMCSSDeclaration*>(void_self);
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eEmpty, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  nsIPrincipal* subjectPrincipal;
  {
    JS::Realm* realm = js::GetContextRealm(cx);
    MOZ_ASSERT(realm);
    JSPrincipals* principals = JS::GetRealmPrincipals(realm);
    nsIPrincipal* principal = nsJSPrincipals::get(principals);
    if (principal->IsSystemPrincipal()) {
    principal = nullptr;
  }

    subjectPrincipal = principal;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetPropertyValue(id, Constify(arg0), MOZ_KnownLive(subjectPrincipal), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetPropertyValue(id, Constify(arg0), MOZ_KnownLive(subjectPrincipal), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, ErrorDescriptionFor<ErrorFor::setter>{ "CSSStyleProperties", attrName }))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
get_alignItems(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_align_items);
}

MOZ_CAN_RUN_SCRIPT static bool
set_alignItems(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_align_items);
}

static const JSJitInfo alignItems_getterinfo = {
  { get_alignItems },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo alignItems_setterinfo = {
  { (JSJitGetterOp)set_alignItems },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_aspectRatio(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_aspect_ratio);
}

MOZ_CAN_RUN_SCRIPT static bool
set_aspectRatio(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_aspect_ratio);
}

static const JSJitInfo aspectRatio_getterinfo = {
  { get_aspectRatio },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo aspectRatio_setterinfo = {
  { (JSJitGetterOp)set_aspectRatio },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_backfaceVisibility(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_backface_visibility);
}

MOZ_CAN_RUN_SCRIPT static bool
set_backfaceVisibility(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_backface_visibility);
}

static const JSJitInfo backfaceVisibility_getterinfo = {
  { get_backfaceVisibility },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo backfaceVisibility_setterinfo = {
  { (JSJitGetterOp)set_backfaceVisibility },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_baselineSource(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_baseline_source);
}

MOZ_CAN_RUN_SCRIPT static bool
set_baselineSource(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_baseline_source);
}

static const JSJitInfo baselineSource_getterinfo = {
  { get_baselineSource },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo baselineSource_setterinfo = {
  { (JSJitGetterOp)set_baselineSource },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderCollapse(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_collapse);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderCollapse(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_collapse);
}

static const JSJitInfo borderCollapse_getterinfo = {
  { get_borderCollapse },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderCollapse_setterinfo = {
  { (JSJitGetterOp)set_borderCollapse },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderImageRepeat(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_image_repeat);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderImageRepeat(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_image_repeat);
}

static const JSJitInfo borderImageRepeat_getterinfo = {
  { get_borderImageRepeat },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderImageRepeat_setterinfo = {
  { (JSJitGetterOp)set_borderImageRepeat },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_boxDecorationBreak(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_box_decoration_break);
}

MOZ_CAN_RUN_SCRIPT static bool
set_boxDecorationBreak(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_box_decoration_break);
}

static const JSJitInfo boxDecorationBreak_getterinfo = {
  { get_boxDecorationBreak },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo boxDecorationBreak_setterinfo = {
  { (JSJitGetterOp)set_boxDecorationBreak },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_boxSizing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_box_sizing);
}

MOZ_CAN_RUN_SCRIPT static bool
set_boxSizing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_box_sizing);
}

static const JSJitInfo boxSizing_getterinfo = {
  { get_boxSizing },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo boxSizing_setterinfo = {
  { (JSJitGetterOp)set_boxSizing },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_breakInside(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_break_inside);
}

MOZ_CAN_RUN_SCRIPT static bool
set_breakInside(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_break_inside);
}

static const JSJitInfo breakInside_getterinfo = {
  { get_breakInside },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo breakInside_setterinfo = {
  { (JSJitGetterOp)set_breakInside },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_captionSide(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_caption_side);
}

MOZ_CAN_RUN_SCRIPT static bool
set_captionSide(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_caption_side);
}

static const JSJitInfo captionSide_getterinfo = {
  { get_captionSide },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo captionSide_setterinfo = {
  { (JSJitGetterOp)set_captionSide },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_clear(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_clear);
}

MOZ_CAN_RUN_SCRIPT static bool
set_clear(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_clear);
}

static const JSJitInfo clear_getterinfo = {
  { get_clear },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo clear_setterinfo = {
  { (JSJitGetterOp)set_clear },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_colorInterpolation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_color_interpolation);
}

MOZ_CAN_RUN_SCRIPT static bool
set_colorInterpolation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_color_interpolation);
}

static const JSJitInfo colorInterpolation_getterinfo = {
  { get_colorInterpolation },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo colorInterpolation_setterinfo = {
  { (JSJitGetterOp)set_colorInterpolation },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_colorInterpolationFilters(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_color_interpolation_filters);
}

MOZ_CAN_RUN_SCRIPT static bool
set_colorInterpolationFilters(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_color_interpolation_filters);
}

static const JSJitInfo colorInterpolationFilters_getterinfo = {
  { get_colorInterpolationFilters },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo colorInterpolationFilters_setterinfo = {
  { (JSJitGetterOp)set_colorInterpolationFilters },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_columnCount(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_count);
}

MOZ_CAN_RUN_SCRIPT static bool
set_columnCount(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_count);
}

static const JSJitInfo columnCount_getterinfo = {
  { get_columnCount },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo columnCount_setterinfo = {
  { (JSJitGetterOp)set_columnCount },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_columnFill(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_fill);
}

MOZ_CAN_RUN_SCRIPT static bool
set_columnFill(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_fill);
}

static const JSJitInfo columnFill_getterinfo = {
  { get_columnFill },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo columnFill_setterinfo = {
  { (JSJitGetterOp)set_columnFill },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_columnSpan(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_span);
}

MOZ_CAN_RUN_SCRIPT static bool
set_columnSpan(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_span);
}

static const JSJitInfo columnSpan_getterinfo = {
  { get_columnSpan },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo columnSpan_setterinfo = {
  { (JSJitGetterOp)set_columnSpan },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_contain(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_contain);
}

MOZ_CAN_RUN_SCRIPT static bool
set_contain(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_contain);
}

static const JSJitInfo contain_getterinfo = {
  { get_contain },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo contain_setterinfo = {
  { (JSJitGetterOp)set_contain },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_containerType(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_container_type);
}

MOZ_CAN_RUN_SCRIPT static bool
set_containerType(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_container_type);
}

static const JSJitInfo containerType_getterinfo = {
  { get_containerType },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo containerType_setterinfo = {
  { (JSJitGetterOp)set_containerType },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_contentVisibility(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_content_visibility);
}

MOZ_CAN_RUN_SCRIPT static bool
set_contentVisibility(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_content_visibility);
}

static const JSJitInfo contentVisibility_getterinfo = {
  { get_contentVisibility },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo contentVisibility_setterinfo = {
  { (JSJitGetterOp)set_contentVisibility },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_direction(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_direction);
}

MOZ_CAN_RUN_SCRIPT static bool
set_direction(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_direction);
}

static const JSJitInfo direction_getterinfo = {
  { get_direction },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo direction_setterinfo = {
  { (JSJitGetterOp)set_direction },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_display(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_display);
}

MOZ_CAN_RUN_SCRIPT static bool
set_display(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_display);
}

static const JSJitInfo display_getterinfo = {
  { get_display },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo display_setterinfo = {
  { (JSJitGetterOp)set_display },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_dominantBaseline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_dominant_baseline);
}

MOZ_CAN_RUN_SCRIPT static bool
set_dominantBaseline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_dominant_baseline);
}

static const JSJitInfo dominantBaseline_getterinfo = {
  { get_dominantBaseline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo dominantBaseline_setterinfo = {
  { (JSJitGetterOp)set_dominantBaseline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_emptyCells(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_empty_cells);
}

MOZ_CAN_RUN_SCRIPT static bool
set_emptyCells(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_empty_cells);
}

static const JSJitInfo emptyCells_getterinfo = {
  { get_emptyCells },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo emptyCells_setterinfo = {
  { (JSJitGetterOp)set_emptyCells },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fieldSizing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_field_sizing);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fieldSizing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_field_sizing);
}

static const JSJitInfo fieldSizing_getterinfo = {
  { get_fieldSizing },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fieldSizing_setterinfo = {
  { (JSJitGetterOp)set_fieldSizing },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_flexDirection(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_flex_direction);
}

MOZ_CAN_RUN_SCRIPT static bool
set_flexDirection(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_flex_direction);
}

static const JSJitInfo flexDirection_getterinfo = {
  { get_flexDirection },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo flexDirection_setterinfo = {
  { (JSJitGetterOp)set_flexDirection },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_flexWrap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_flex_wrap);
}

MOZ_CAN_RUN_SCRIPT static bool
set_flexWrap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_flex_wrap);
}

static const JSJitInfo flexWrap_getterinfo = {
  { get_flexWrap },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo flexWrap_setterinfo = {
  { (JSJitGetterOp)set_flexWrap },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_cssFloat(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_float);
}

MOZ_CAN_RUN_SCRIPT static bool
set_cssFloat(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_float);
}

static const JSJitInfo cssFloat_getterinfo = {
  { get_cssFloat },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo cssFloat_setterinfo = {
  { (JSJitGetterOp)set_cssFloat },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontKerning(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_kerning);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontKerning(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_kerning);
}

static const JSJitInfo fontKerning_getterinfo = {
  { get_fontKerning },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontKerning_setterinfo = {
  { (JSJitGetterOp)set_fontKerning },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontLanguageOverride(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_language_override);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontLanguageOverride(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_language_override);
}

static const JSJitInfo fontLanguageOverride_getterinfo = {
  { get_fontLanguageOverride },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontLanguageOverride_setterinfo = {
  { (JSJitGetterOp)set_fontLanguageOverride },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontOpticalSizing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_optical_sizing);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontOpticalSizing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_optical_sizing);
}

static const JSJitInfo fontOpticalSizing_getterinfo = {
  { get_fontOpticalSizing },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontOpticalSizing_setterinfo = {
  { (JSJitGetterOp)set_fontOpticalSizing },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontSizeAdjust(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_size_adjust);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontSizeAdjust(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_size_adjust);
}

static const JSJitInfo fontSizeAdjust_getterinfo = {
  { get_fontSizeAdjust },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontSizeAdjust_setterinfo = {
  { (JSJitGetterOp)set_fontSizeAdjust },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontStretch(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_stretch);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontStretch(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_stretch);
}

static const JSJitInfo fontStretch_getterinfo = {
  { get_fontStretch },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontStretch_setterinfo = {
  { (JSJitGetterOp)set_fontStretch },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_style);
}

static const JSJitInfo fontStyle_getterinfo = {
  { get_fontStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontStyle_setterinfo = {
  { (JSJitGetterOp)set_fontStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontSynthesisStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_synthesis_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontSynthesisStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_synthesis_style);
}

static const JSJitInfo fontSynthesisStyle_getterinfo = {
  { get_fontSynthesisStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontSynthesisStyle_setterinfo = {
  { (JSJitGetterOp)set_fontSynthesisStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontVariantCaps(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant_caps);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontVariantCaps(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant_caps);
}

static const JSJitInfo fontVariantCaps_getterinfo = {
  { get_fontVariantCaps },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontVariantCaps_setterinfo = {
  { (JSJitGetterOp)set_fontVariantCaps },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontVariantEastAsian(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant_east_asian);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontVariantEastAsian(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant_east_asian);
}

static const JSJitInfo fontVariantEastAsian_getterinfo = {
  { get_fontVariantEastAsian },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontVariantEastAsian_setterinfo = {
  { (JSJitGetterOp)set_fontVariantEastAsian },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontVariantEmoji(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant_emoji);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontVariantEmoji(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant_emoji);
}

static const JSJitInfo fontVariantEmoji_getterinfo = {
  { get_fontVariantEmoji },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontVariantEmoji_setterinfo = {
  { (JSJitGetterOp)set_fontVariantEmoji },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontVariantLigatures(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant_ligatures);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontVariantLigatures(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant_ligatures);
}

static const JSJitInfo fontVariantLigatures_getterinfo = {
  { get_fontVariantLigatures },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontVariantLigatures_setterinfo = {
  { (JSJitGetterOp)set_fontVariantLigatures },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontVariantNumeric(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant_numeric);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontVariantNumeric(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant_numeric);
}

static const JSJitInfo fontVariantNumeric_getterinfo = {
  { get_fontVariantNumeric },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontVariantNumeric_setterinfo = {
  { (JSJitGetterOp)set_fontVariantNumeric },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontVariantPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant_position);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontVariantPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant_position);
}

static const JSJitInfo fontVariantPosition_getterinfo = {
  { get_fontVariantPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontVariantPosition_setterinfo = {
  { (JSJitGetterOp)set_fontVariantPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontWeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_weight);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontWeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_weight);
}

static const JSJitInfo fontWeight_getterinfo = {
  { get_fontWeight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontWeight_setterinfo = {
  { (JSJitGetterOp)set_fontWeight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_forcedColorAdjust(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_forced_color_adjust);
}

MOZ_CAN_RUN_SCRIPT static bool
set_forcedColorAdjust(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_forced_color_adjust);
}

static const JSJitInfo forcedColorAdjust_getterinfo = {
  { get_forcedColorAdjust },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo forcedColorAdjust_setterinfo = {
  { (JSJitGetterOp)set_forcedColorAdjust },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gridAutoFlow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_auto_flow);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gridAutoFlow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_auto_flow);
}

static const JSJitInfo gridAutoFlow_getterinfo = {
  { get_gridAutoFlow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gridAutoFlow_setterinfo = {
  { (JSJitGetterOp)set_gridAutoFlow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_hyphens(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_hyphens);
}

MOZ_CAN_RUN_SCRIPT static bool
set_hyphens(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_hyphens);
}

static const JSJitInfo hyphens_getterinfo = {
  { get_hyphens },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo hyphens_setterinfo = {
  { (JSJitGetterOp)set_hyphens },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_imageOrientation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_image_orientation);
}

MOZ_CAN_RUN_SCRIPT static bool
set_imageOrientation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_image_orientation);
}

static const JSJitInfo imageOrientation_getterinfo = {
  { get_imageOrientation },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo imageOrientation_setterinfo = {
  { (JSJitGetterOp)set_imageOrientation },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_imageRendering(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_image_rendering);
}

MOZ_CAN_RUN_SCRIPT static bool
set_imageRendering(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_image_rendering);
}

static const JSJitInfo imageRendering_getterinfo = {
  { get_imageRendering },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo imageRendering_setterinfo = {
  { (JSJitGetterOp)set_imageRendering },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_imeMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_ime_mode);
}

MOZ_CAN_RUN_SCRIPT static bool
set_imeMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_ime_mode);
}

static const JSJitInfo imeMode_getterinfo = {
  { get_imeMode },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo imeMode_setterinfo = {
  { (JSJitGetterOp)set_imeMode },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_initialLetter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_initial_letter);
}

MOZ_CAN_RUN_SCRIPT static bool
set_initialLetter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_initial_letter);
}

static const JSJitInfo initialLetter_getterinfo = {
  { get_initialLetter },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo initialLetter_setterinfo = {
  { (JSJitGetterOp)set_initialLetter },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_isolation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_isolation);
}

MOZ_CAN_RUN_SCRIPT static bool
set_isolation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_isolation);
}

static const JSJitInfo isolation_getterinfo = {
  { get_isolation },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo isolation_setterinfo = {
  { (JSJitGetterOp)set_isolation },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_justifyItems(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_justify_items);
}

MOZ_CAN_RUN_SCRIPT static bool
set_justifyItems(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_justify_items);
}

static const JSJitInfo justifyItems_getterinfo = {
  { get_justifyItems },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo justifyItems_setterinfo = {
  { (JSJitGetterOp)set_justifyItems },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_lineBreak(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_line_break);
}

MOZ_CAN_RUN_SCRIPT static bool
set_lineBreak(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_line_break);
}

static const JSJitInfo lineBreak_getterinfo = {
  { get_lineBreak },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo lineBreak_setterinfo = {
  { (JSJitGetterOp)set_lineBreak },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_listStylePosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_list_style_position);
}

MOZ_CAN_RUN_SCRIPT static bool
set_listStylePosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_list_style_position);
}

static const JSJitInfo listStylePosition_getterinfo = {
  { get_listStylePosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo listStylePosition_setterinfo = {
  { (JSJitGetterOp)set_listStylePosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maskType(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_type);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maskType(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_type);
}

static const JSJitInfo maskType_getterinfo = {
  { get_maskType },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maskType_setterinfo = {
  { (JSJitGetterOp)set_maskType },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_masonryAutoFlow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_masonry_auto_flow);
}

MOZ_CAN_RUN_SCRIPT static bool
set_masonryAutoFlow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_masonry_auto_flow);
}

static const JSJitInfo masonryAutoFlow_getterinfo = {
  { get_masonryAutoFlow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo masonryAutoFlow_setterinfo = {
  { (JSJitGetterOp)set_masonryAutoFlow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_mathDepth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_math_depth);
}

MOZ_CAN_RUN_SCRIPT static bool
set_mathDepth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_math_depth);
}

static const JSJitInfo mathDepth_getterinfo = {
  { get_mathDepth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo mathDepth_setterinfo = {
  { (JSJitGetterOp)set_mathDepth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_mathShift(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_math_shift);
}

MOZ_CAN_RUN_SCRIPT static bool
set_mathShift(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_math_shift);
}

static const JSJitInfo mathShift_getterinfo = {
  { get_mathShift },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo mathShift_setterinfo = {
  { (JSJitGetterOp)set_mathShift },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_mathStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_math_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_mathStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_math_style);
}

static const JSJitInfo mathStyle_getterinfo = {
  { get_mathStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo mathStyle_setterinfo = {
  { (JSJitGetterOp)set_mathStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_mixBlendMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_mix_blend_mode);
}

MOZ_CAN_RUN_SCRIPT static bool
set_mixBlendMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_mix_blend_mode);
}

static const JSJitInfo mixBlendMode_getterinfo = {
  { get_mixBlendMode },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo mixBlendMode_setterinfo = {
  { (JSJitGetterOp)set_mixBlendMode },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozBoxAlign(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_box_align);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozBoxAlign(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_box_align);
}

static const JSJitInfo MozBoxAlign_getterinfo = {
  { get_MozBoxAlign },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozBoxAlign_setterinfo = {
  { (JSJitGetterOp)set_MozBoxAlign },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozBoxCollapse(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_box_collapse);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozBoxCollapse(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_box_collapse);
}

static const JSJitInfo MozBoxCollapse_getterinfo = {
  { get_MozBoxCollapse },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozBoxCollapse_setterinfo = {
  { (JSJitGetterOp)set_MozBoxCollapse },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozBoxDirection(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_box_direction);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozBoxDirection(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_box_direction);
}

static const JSJitInfo MozBoxDirection_getterinfo = {
  { get_MozBoxDirection },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozBoxDirection_setterinfo = {
  { (JSJitGetterOp)set_MozBoxDirection },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozBoxOrient(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_box_orient);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozBoxOrient(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_box_orient);
}

static const JSJitInfo MozBoxOrient_getterinfo = {
  { get_MozBoxOrient },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozBoxOrient_setterinfo = {
  { (JSJitGetterOp)set_MozBoxOrient },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozBoxPack(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_box_pack);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozBoxPack(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_box_pack);
}

static const JSJitInfo MozBoxPack_getterinfo = {
  { get_MozBoxPack },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozBoxPack_setterinfo = {
  { (JSJitGetterOp)set_MozBoxPack },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozControlCharacterVisibility(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_control_character_visibility);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozControlCharacterVisibility(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_control_character_visibility);
}

static const JSJitInfo MozControlCharacterVisibility_getterinfo = {
  { get_MozControlCharacterVisibility },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozControlCharacterVisibility_setterinfo = {
  { (JSJitGetterOp)set_MozControlCharacterVisibility },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozFloatEdge(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_float_edge);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozFloatEdge(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_float_edge);
}

static const JSJitInfo MozFloatEdge_getterinfo = {
  { get_MozFloatEdge },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozFloatEdge_setterinfo = {
  { (JSJitGetterOp)set_MozFloatEdge },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozOrient(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_orient);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozOrient(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_orient);
}

static const JSJitInfo MozOrient_getterinfo = {
  { get_MozOrient },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozOrient_setterinfo = {
  { (JSJitGetterOp)set_MozOrient },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozOsxFontSmoothing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_osx_font_smoothing);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozOsxFontSmoothing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_osx_font_smoothing);
}

static const JSJitInfo MozOsxFontSmoothing_getterinfo = {
  { get_MozOsxFontSmoothing },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozOsxFontSmoothing_setterinfo = {
  { (JSJitGetterOp)set_MozOsxFontSmoothing },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozTextSizeAdjust(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_text_size_adjust);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozTextSizeAdjust(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_text_size_adjust);
}

static const JSJitInfo MozTextSizeAdjust_getterinfo = {
  { get_MozTextSizeAdjust },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozTextSizeAdjust_setterinfo = {
  { (JSJitGetterOp)set_MozTextSizeAdjust },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozTheme(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_theme);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozTheme(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_theme);
}

static const JSJitInfo MozTheme_getterinfo = {
  { get_MozTheme },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozTheme_setterinfo = {
  { (JSJitGetterOp)set_MozTheme },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozUserFocus(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_user_focus);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozUserFocus(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_user_focus);
}

static const JSJitInfo MozUserFocus_getterinfo = {
  { get_MozUserFocus },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozUserFocus_setterinfo = {
  { (JSJitGetterOp)set_MozUserFocus },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozWindowDragging(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_window_dragging);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozWindowDragging(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_window_dragging);
}

static const JSJitInfo MozWindowDragging_getterinfo = {
  { get_MozWindowDragging },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozWindowDragging_setterinfo = {
  { (JSJitGetterOp)set_MozWindowDragging },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozWindowShadow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_window_shadow);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozWindowShadow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_window_shadow);
}

static const JSJitInfo MozWindowShadow_getterinfo = {
  { get_MozWindowShadow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozWindowShadow_setterinfo = {
  { (JSJitGetterOp)set_MozWindowShadow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_objectFit(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_object_fit);
}

MOZ_CAN_RUN_SCRIPT static bool
set_objectFit(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_object_fit);
}

static const JSJitInfo objectFit_getterinfo = {
  { get_objectFit },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo objectFit_setterinfo = {
  { (JSJitGetterOp)set_objectFit },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_offsetRotate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_offset_rotate);
}

MOZ_CAN_RUN_SCRIPT static bool
set_offsetRotate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_offset_rotate);
}

static const JSJitInfo offsetRotate_getterinfo = {
  { get_offsetRotate },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo offsetRotate_setterinfo = {
  { (JSJitGetterOp)set_offsetRotate },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_outlineStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_outline_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_outlineStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_outline_style);
}

static const JSJitInfo outlineStyle_getterinfo = {
  { get_outlineStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo outlineStyle_setterinfo = {
  { (JSJitGetterOp)set_outlineStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_overflowAnchor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow_anchor);
}

MOZ_CAN_RUN_SCRIPT static bool
set_overflowAnchor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow_anchor);
}

static const JSJitInfo overflowAnchor_getterinfo = {
  { get_overflowAnchor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo overflowAnchor_setterinfo = {
  { (JSJitGetterOp)set_overflowAnchor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_overflowWrap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow_wrap);
}

MOZ_CAN_RUN_SCRIPT static bool
set_overflowWrap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow_wrap);
}

static const JSJitInfo overflowWrap_getterinfo = {
  { get_overflowWrap },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo overflowWrap_setterinfo = {
  { (JSJitGetterOp)set_overflowWrap },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_paintOrder(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_paint_order);
}

MOZ_CAN_RUN_SCRIPT static bool
set_paintOrder(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_paint_order);
}

static const JSJitInfo paintOrder_getterinfo = {
  { get_paintOrder },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo paintOrder_setterinfo = {
  { (JSJitGetterOp)set_paintOrder },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_pointerEvents(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_pointer_events);
}

MOZ_CAN_RUN_SCRIPT static bool
set_pointerEvents(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_pointer_events);
}

static const JSJitInfo pointerEvents_getterinfo = {
  { get_pointerEvents },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo pointerEvents_setterinfo = {
  { (JSJitGetterOp)set_pointerEvents },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_position(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_position);
}

MOZ_CAN_RUN_SCRIPT static bool
set_position(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_position);
}

static const JSJitInfo position_getterinfo = {
  { get_position },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo position_setterinfo = {
  { (JSJitGetterOp)set_position },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_positionArea(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_position_area);
}

MOZ_CAN_RUN_SCRIPT static bool
set_positionArea(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_position_area);
}

static const JSJitInfo positionArea_getterinfo = {
  { get_positionArea },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo positionArea_setterinfo = {
  { (JSJitGetterOp)set_positionArea },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_positionTryOrder(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_position_try_order);
}

MOZ_CAN_RUN_SCRIPT static bool
set_positionTryOrder(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_position_try_order);
}

static const JSJitInfo positionTryOrder_getterinfo = {
  { get_positionTryOrder },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo positionTryOrder_setterinfo = {
  { (JSJitGetterOp)set_positionTryOrder },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_positionVisibility(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_position_visibility);
}

MOZ_CAN_RUN_SCRIPT static bool
set_positionVisibility(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_position_visibility);
}

static const JSJitInfo positionVisibility_getterinfo = {
  { get_positionVisibility },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo positionVisibility_setterinfo = {
  { (JSJitGetterOp)set_positionVisibility },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_printColorAdjust(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_print_color_adjust);
}

MOZ_CAN_RUN_SCRIPT static bool
set_printColorAdjust(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_print_color_adjust);
}

static const JSJitInfo printColorAdjust_getterinfo = {
  { get_printColorAdjust },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo printColorAdjust_setterinfo = {
  { (JSJitGetterOp)set_printColorAdjust },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_resize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_resize);
}

MOZ_CAN_RUN_SCRIPT static bool
set_resize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_resize);
}

static const JSJitInfo resize_getterinfo = {
  { get_resize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo resize_setterinfo = {
  { (JSJitGetterOp)set_resize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_rubyAlign(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_ruby_align);
}

MOZ_CAN_RUN_SCRIPT static bool
set_rubyAlign(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_ruby_align);
}

static const JSJitInfo rubyAlign_getterinfo = {
  { get_rubyAlign },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo rubyAlign_setterinfo = {
  { (JSJitGetterOp)set_rubyAlign },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_rubyPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_ruby_position);
}

MOZ_CAN_RUN_SCRIPT static bool
set_rubyPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_ruby_position);
}

static const JSJitInfo rubyPosition_getterinfo = {
  { get_rubyPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo rubyPosition_setterinfo = {
  { (JSJitGetterOp)set_rubyPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollBehavior(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_behavior);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollBehavior(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_behavior);
}

static const JSJitInfo scrollBehavior_getterinfo = {
  { get_scrollBehavior },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollBehavior_setterinfo = {
  { (JSJitGetterOp)set_scrollBehavior },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollSnapAlign(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_snap_align);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollSnapAlign(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_snap_align);
}

static const JSJitInfo scrollSnapAlign_getterinfo = {
  { get_scrollSnapAlign },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollSnapAlign_setterinfo = {
  { (JSJitGetterOp)set_scrollSnapAlign },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollSnapStop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_snap_stop);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollSnapStop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_snap_stop);
}

static const JSJitInfo scrollSnapStop_getterinfo = {
  { get_scrollSnapStop },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollSnapStop_setterinfo = {
  { (JSJitGetterOp)set_scrollSnapStop },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollSnapType(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_snap_type);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollSnapType(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_snap_type);
}

static const JSJitInfo scrollSnapType_getterinfo = {
  { get_scrollSnapType },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollSnapType_setterinfo = {
  { (JSJitGetterOp)set_scrollSnapType },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollbarGutter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scrollbar_gutter);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollbarGutter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scrollbar_gutter);
}

static const JSJitInfo scrollbarGutter_getterinfo = {
  { get_scrollbarGutter },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollbarGutter_setterinfo = {
  { (JSJitGetterOp)set_scrollbarGutter },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollbarWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scrollbar_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollbarWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scrollbar_width);
}

static const JSJitInfo scrollbarWidth_getterinfo = {
  { get_scrollbarWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollbarWidth_setterinfo = {
  { (JSJitGetterOp)set_scrollbarWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_shapeRendering(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_shape_rendering);
}

MOZ_CAN_RUN_SCRIPT static bool
set_shapeRendering(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_shape_rendering);
}

static const JSJitInfo shapeRendering_getterinfo = {
  { get_shapeRendering },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo shapeRendering_setterinfo = {
  { (JSJitGetterOp)set_shapeRendering },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_strokeLinecap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke_linecap);
}

MOZ_CAN_RUN_SCRIPT static bool
set_strokeLinecap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke_linecap);
}

static const JSJitInfo strokeLinecap_getterinfo = {
  { get_strokeLinecap },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo strokeLinecap_setterinfo = {
  { (JSJitGetterOp)set_strokeLinecap },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_strokeLinejoin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke_linejoin);
}

MOZ_CAN_RUN_SCRIPT static bool
set_strokeLinejoin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke_linejoin);
}

static const JSJitInfo strokeLinejoin_getterinfo = {
  { get_strokeLinejoin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo strokeLinejoin_setterinfo = {
  { (JSJitGetterOp)set_strokeLinejoin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_tableLayout(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_table_layout);
}

MOZ_CAN_RUN_SCRIPT static bool
set_tableLayout(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_table_layout);
}

static const JSJitInfo tableLayout_getterinfo = {
  { get_tableLayout },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo tableLayout_setterinfo = {
  { (JSJitGetterOp)set_tableLayout },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textAlign(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_align);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textAlign(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_align);
}

static const JSJitInfo textAlign_getterinfo = {
  { get_textAlign },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textAlign_setterinfo = {
  { (JSJitGetterOp)set_textAlign },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textAlignLast(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_align_last);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textAlignLast(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_align_last);
}

static const JSJitInfo textAlignLast_getterinfo = {
  { get_textAlignLast },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textAlignLast_setterinfo = {
  { (JSJitGetterOp)set_textAlignLast },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textAnchor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_anchor);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textAnchor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_anchor);
}

static const JSJitInfo textAnchor_getterinfo = {
  { get_textAnchor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textAnchor_setterinfo = {
  { (JSJitGetterOp)set_textAnchor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textAutospace(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_autospace);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textAutospace(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_autospace);
}

static const JSJitInfo textAutospace_getterinfo = {
  { get_textAutospace },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textAutospace_setterinfo = {
  { (JSJitGetterOp)set_textAutospace },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textCombineUpright(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_combine_upright);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textCombineUpright(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_combine_upright);
}

static const JSJitInfo textCombineUpright_getterinfo = {
  { get_textCombineUpright },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textCombineUpright_setterinfo = {
  { (JSJitGetterOp)set_textCombineUpright },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textDecorationLine(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_decoration_line);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textDecorationLine(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_decoration_line);
}

static const JSJitInfo textDecorationLine_getterinfo = {
  { get_textDecorationLine },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textDecorationLine_setterinfo = {
  { (JSJitGetterOp)set_textDecorationLine },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textDecorationSkipInk(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_decoration_skip_ink);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textDecorationSkipInk(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_decoration_skip_ink);
}

static const JSJitInfo textDecorationSkipInk_getterinfo = {
  { get_textDecorationSkipInk },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textDecorationSkipInk_setterinfo = {
  { (JSJitGetterOp)set_textDecorationSkipInk },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textDecorationStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_decoration_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textDecorationStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_decoration_style);
}

static const JSJitInfo textDecorationStyle_getterinfo = {
  { get_textDecorationStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textDecorationStyle_setterinfo = {
  { (JSJitGetterOp)set_textDecorationStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textEmphasisPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_emphasis_position);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textEmphasisPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_emphasis_position);
}

static const JSJitInfo textEmphasisPosition_getterinfo = {
  { get_textEmphasisPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textEmphasisPosition_setterinfo = {
  { (JSJitGetterOp)set_textEmphasisPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textJustify(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_justify);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textJustify(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_justify);
}

static const JSJitInfo textJustify_getterinfo = {
  { get_textJustify },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textJustify_setterinfo = {
  { (JSJitGetterOp)set_textJustify },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textOrientation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_orientation);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textOrientation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_orientation);
}

static const JSJitInfo textOrientation_getterinfo = {
  { get_textOrientation },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textOrientation_setterinfo = {
  { (JSJitGetterOp)set_textOrientation },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textRendering(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_rendering);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textRendering(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_rendering);
}

static const JSJitInfo textRendering_getterinfo = {
  { get_textRendering },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textRendering_setterinfo = {
  { (JSJitGetterOp)set_textRendering },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textTransform(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_transform);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textTransform(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_transform);
}

static const JSJitInfo textTransform_getterinfo = {
  { get_textTransform },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textTransform_setterinfo = {
  { (JSJitGetterOp)set_textTransform },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textUnderlinePosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_underline_position);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textUnderlinePosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_underline_position);
}

static const JSJitInfo textUnderlinePosition_getterinfo = {
  { get_textUnderlinePosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textUnderlinePosition_setterinfo = {
  { (JSJitGetterOp)set_textUnderlinePosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textWrapMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_wrap_mode);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textWrapMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_wrap_mode);
}

static const JSJitInfo textWrapMode_getterinfo = {
  { get_textWrapMode },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textWrapMode_setterinfo = {
  { (JSJitGetterOp)set_textWrapMode },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textWrapStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_wrap_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textWrapStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_wrap_style);
}

static const JSJitInfo textWrapStyle_getterinfo = {
  { get_textWrapStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textWrapStyle_setterinfo = {
  { (JSJitGetterOp)set_textWrapStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_touchAction(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_touch_action);
}

MOZ_CAN_RUN_SCRIPT static bool
set_touchAction(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_touch_action);
}

static const JSJitInfo touchAction_getterinfo = {
  { get_touchAction },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo touchAction_setterinfo = {
  { (JSJitGetterOp)set_touchAction },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_transformBox(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_transform_box);
}

MOZ_CAN_RUN_SCRIPT static bool
set_transformBox(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_transform_box);
}

static const JSJitInfo transformBox_getterinfo = {
  { get_transformBox },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo transformBox_setterinfo = {
  { (JSJitGetterOp)set_transformBox },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_transformStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_transform_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_transformStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_transform_style);
}

static const JSJitInfo transformStyle_getterinfo = {
  { get_transformStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo transformStyle_setterinfo = {
  { (JSJitGetterOp)set_transformStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_unicodeBidi(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_unicode_bidi);
}

MOZ_CAN_RUN_SCRIPT static bool
set_unicodeBidi(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_unicode_bidi);
}

static const JSJitInfo unicodeBidi_getterinfo = {
  { get_unicodeBidi },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo unicodeBidi_setterinfo = {
  { (JSJitGetterOp)set_unicodeBidi },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_userSelect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_user_select);
}

MOZ_CAN_RUN_SCRIPT static bool
set_userSelect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_user_select);
}

static const JSJitInfo userSelect_getterinfo = {
  { get_userSelect },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo userSelect_setterinfo = {
  { (JSJitGetterOp)set_userSelect },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_vectorEffect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_vector_effect);
}

MOZ_CAN_RUN_SCRIPT static bool
set_vectorEffect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_vector_effect);
}

static const JSJitInfo vectorEffect_getterinfo = {
  { get_vectorEffect },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo vectorEffect_setterinfo = {
  { (JSJitGetterOp)set_vectorEffect },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_visibility(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_visibility);
}

MOZ_CAN_RUN_SCRIPT static bool
set_visibility(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_visibility);
}

static const JSJitInfo visibility_getterinfo = {
  { get_visibility },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo visibility_setterinfo = {
  { (JSJitGetterOp)set_visibility },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_webkitLineClamp(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__webkit_line_clamp);
}

MOZ_CAN_RUN_SCRIPT static bool
set_webkitLineClamp(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__webkit_line_clamp);
}

static const JSJitInfo webkitLineClamp_getterinfo = {
  { get_webkitLineClamp },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo webkitLineClamp_setterinfo = {
  { (JSJitGetterOp)set_webkitLineClamp },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_webkitTextSecurity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__webkit_text_security);
}

MOZ_CAN_RUN_SCRIPT static bool
set_webkitTextSecurity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__webkit_text_security);
}

static const JSJitInfo webkitTextSecurity_getterinfo = {
  { get_webkitTextSecurity },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo webkitTextSecurity_setterinfo = {
  { (JSJitGetterOp)set_webkitTextSecurity },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_whiteSpaceCollapse(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_white_space_collapse);
}

MOZ_CAN_RUN_SCRIPT static bool
set_whiteSpaceCollapse(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_white_space_collapse);
}

static const JSJitInfo whiteSpaceCollapse_getterinfo = {
  { get_whiteSpaceCollapse },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo whiteSpaceCollapse_setterinfo = {
  { (JSJitGetterOp)set_whiteSpaceCollapse },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_wordBreak(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_word_break);
}

MOZ_CAN_RUN_SCRIPT static bool
set_wordBreak(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_word_break);
}

static const JSJitInfo wordBreak_getterinfo = {
  { get_wordBreak },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo wordBreak_setterinfo = {
  { (JSJitGetterOp)set_wordBreak },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_writingMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_writing_mode);
}

MOZ_CAN_RUN_SCRIPT static bool
set_writingMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_writing_mode);
}

static const JSJitInfo writingMode_getterinfo = {
  { get_writingMode },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo writingMode_setterinfo = {
  { (JSJitGetterOp)set_writingMode },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_zIndex(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_z_index);
}

MOZ_CAN_RUN_SCRIPT static bool
set_zIndex(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_z_index);
}

static const JSJitInfo zIndex_getterinfo = {
  { get_zIndex },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo zIndex_setterinfo = {
  { (JSJitGetterOp)set_zIndex },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_zoom(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_zoom);
}

MOZ_CAN_RUN_SCRIPT static bool
set_zoom(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_zoom);
}

static const JSJitInfo zoom_getterinfo = {
  { get_zoom },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo zoom_setterinfo = {
  { (JSJitGetterOp)set_zoom },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_appearance(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_appearance);
}

MOZ_CAN_RUN_SCRIPT static bool
set_appearance(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_appearance);
}

static const JSJitInfo appearance_getterinfo = {
  { get_appearance },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo appearance_setterinfo = {
  { (JSJitGetterOp)set_appearance },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozDefaultAppearance(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_default_appearance);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozDefaultAppearance(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_default_appearance);
}

static const JSJitInfo MozDefaultAppearance_getterinfo = {
  { get_MozDefaultAppearance },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozDefaultAppearance_setterinfo = {
  { (JSJitGetterOp)set_MozDefaultAppearance },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozForceBrokenImageIcon(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_force_broken_image_icon);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozForceBrokenImageIcon(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_force_broken_image_icon);
}

static const JSJitInfo MozForceBrokenImageIcon_getterinfo = {
  { get_MozForceBrokenImageIcon },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozForceBrokenImageIcon_setterinfo = {
  { (JSJitGetterOp)set_MozForceBrokenImageIcon },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozSubtreeHiddenOnlyVisually(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_subtree_hidden_only_visually);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozSubtreeHiddenOnlyVisually(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_subtree_hidden_only_visually);
}

static const JSJitInfo MozSubtreeHiddenOnlyVisually_getterinfo = {
  { get_MozSubtreeHiddenOnlyVisually },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozSubtreeHiddenOnlyVisually_setterinfo = {
  { (JSJitGetterOp)set_MozSubtreeHiddenOnlyVisually },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_breakAfter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_break_after);
}

MOZ_CAN_RUN_SCRIPT static bool
set_breakAfter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_break_after);
}

static const JSJitInfo breakAfter_getterinfo = {
  { get_breakAfter },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo breakAfter_setterinfo = {
  { (JSJitGetterOp)set_breakAfter },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_breakBefore(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_break_before);
}

MOZ_CAN_RUN_SCRIPT static bool
set_breakBefore(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_break_before);
}

static const JSJitInfo breakBefore_getterinfo = {
  { get_breakBefore },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo breakBefore_setterinfo = {
  { (JSJitGetterOp)set_breakBefore },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_alignContent(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_align_content);
}

MOZ_CAN_RUN_SCRIPT static bool
set_alignContent(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_align_content);
}

static const JSJitInfo alignContent_getterinfo = {
  { get_alignContent },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo alignContent_setterinfo = {
  { (JSJitGetterOp)set_alignContent },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_justifyContent(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_justify_content);
}

MOZ_CAN_RUN_SCRIPT static bool
set_justifyContent(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_justify_content);
}

static const JSJitInfo justifyContent_getterinfo = {
  { get_justifyContent },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo justifyContent_setterinfo = {
  { (JSJitGetterOp)set_justifyContent },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_clipRule(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_clip_rule);
}

MOZ_CAN_RUN_SCRIPT static bool
set_clipRule(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_clip_rule);
}

static const JSJitInfo clipRule_getterinfo = {
  { get_clipRule },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo clipRule_setterinfo = {
  { (JSJitGetterOp)set_clipRule },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fillRule(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_fill_rule);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fillRule(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_fill_rule);
}

static const JSJitInfo fillRule_getterinfo = {
  { get_fillRule },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fillRule_setterinfo = {
  { (JSJitGetterOp)set_fillRule },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fillOpacity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_fill_opacity);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fillOpacity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_fill_opacity);
}

static const JSJitInfo fillOpacity_getterinfo = {
  { get_fillOpacity },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fillOpacity_setterinfo = {
  { (JSJitGetterOp)set_fillOpacity },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_strokeOpacity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke_opacity);
}

MOZ_CAN_RUN_SCRIPT static bool
set_strokeOpacity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke_opacity);
}

static const JSJitInfo strokeOpacity_getterinfo = {
  { get_strokeOpacity },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo strokeOpacity_setterinfo = {
  { (JSJitGetterOp)set_strokeOpacity },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_alignSelf(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_align_self);
}

MOZ_CAN_RUN_SCRIPT static bool
set_alignSelf(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_align_self);
}

static const JSJitInfo alignSelf_getterinfo = {
  { get_alignSelf },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo alignSelf_setterinfo = {
  { (JSJitGetterOp)set_alignSelf },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_justifySelf(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_justify_self);
}

MOZ_CAN_RUN_SCRIPT static bool
set_justifySelf(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_justify_self);
}

static const JSJitInfo justifySelf_getterinfo = {
  { get_justifySelf },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo justifySelf_setterinfo = {
  { (JSJitGetterOp)set_justifySelf },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontSynthesisPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_synthesis_position);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontSynthesisPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_synthesis_position);
}

static const JSJitInfo fontSynthesisPosition_getterinfo = {
  { get_fontSynthesisPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontSynthesisPosition_setterinfo = {
  { (JSJitGetterOp)set_fontSynthesisPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontSynthesisSmallCaps(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_synthesis_small_caps);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontSynthesisSmallCaps(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_synthesis_small_caps);
}

static const JSJitInfo fontSynthesisSmallCaps_getterinfo = {
  { get_fontSynthesisSmallCaps },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontSynthesisSmallCaps_setterinfo = {
  { (JSJitGetterOp)set_fontSynthesisSmallCaps },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontSynthesisWeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_synthesis_weight);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontSynthesisWeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_synthesis_weight);
}

static const JSJitInfo fontSynthesisWeight_getterinfo = {
  { get_fontSynthesisWeight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontSynthesisWeight_setterinfo = {
  { (JSJitGetterOp)set_fontSynthesisWeight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozBoxOrdinalGroup(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_box_ordinal_group);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozBoxOrdinalGroup(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_box_ordinal_group);
}

static const JSJitInfo MozBoxOrdinalGroup_getterinfo = {
  { get_MozBoxOrdinalGroup },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozBoxOrdinalGroup_setterinfo = {
  { (JSJitGetterOp)set_MozBoxOrdinalGroup },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_order(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_order);
}

MOZ_CAN_RUN_SCRIPT static bool
set_order(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_order);
}

static const JSJitInfo order_getterinfo = {
  { get_order },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo order_setterinfo = {
  { (JSJitGetterOp)set_order },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_flexGrow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_flex_grow);
}

MOZ_CAN_RUN_SCRIPT static bool
set_flexGrow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_flex_grow);
}

static const JSJitInfo flexGrow_getterinfo = {
  { get_flexGrow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo flexGrow_setterinfo = {
  { (JSJitGetterOp)set_flexGrow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_flexShrink(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_flex_shrink);
}

MOZ_CAN_RUN_SCRIPT static bool
set_flexShrink(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_flex_shrink);
}

static const JSJitInfo flexShrink_getterinfo = {
  { get_flexShrink },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo flexShrink_setterinfo = {
  { (JSJitGetterOp)set_flexShrink },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozBoxFlex(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_box_flex);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozBoxFlex(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_box_flex);
}

static const JSJitInfo MozBoxFlex_getterinfo = {
  { get_MozBoxFlex },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozBoxFlex_setterinfo = {
  { (JSJitGetterOp)set_MozBoxFlex },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_strokeMiterlimit(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke_miterlimit);
}

MOZ_CAN_RUN_SCRIPT static bool
set_strokeMiterlimit(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke_miterlimit);
}

static const JSJitInfo strokeMiterlimit_getterinfo = {
  { get_strokeMiterlimit },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo strokeMiterlimit_setterinfo = {
  { (JSJitGetterOp)set_strokeMiterlimit },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_overflowBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow_block);
}

MOZ_CAN_RUN_SCRIPT static bool
set_overflowBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow_block);
}

static const JSJitInfo overflowBlock_getterinfo = {
  { get_overflowBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo overflowBlock_setterinfo = {
  { (JSJitGetterOp)set_overflowBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_overflowInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow_inline);
}

MOZ_CAN_RUN_SCRIPT static bool
set_overflowInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow_inline);
}

static const JSJitInfo overflowInline_getterinfo = {
  { get_overflowInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo overflowInline_setterinfo = {
  { (JSJitGetterOp)set_overflowInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_overflowX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow_x);
}

MOZ_CAN_RUN_SCRIPT static bool
set_overflowX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow_x);
}

static const JSJitInfo overflowX_getterinfo = {
  { get_overflowX },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo overflowX_setterinfo = {
  { (JSJitGetterOp)set_overflowX },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_overflowY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow_y);
}

MOZ_CAN_RUN_SCRIPT static bool
set_overflowY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow_y);
}

static const JSJitInfo overflowY_getterinfo = {
  { get_overflowY },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo overflowY_setterinfo = {
  { (JSJitGetterOp)set_overflowY },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_overscrollBehaviorBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_overscroll_behavior_block);
}

MOZ_CAN_RUN_SCRIPT static bool
set_overscrollBehaviorBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_overscroll_behavior_block);
}

static const JSJitInfo overscrollBehaviorBlock_getterinfo = {
  { get_overscrollBehaviorBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo overscrollBehaviorBlock_setterinfo = {
  { (JSJitGetterOp)set_overscrollBehaviorBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_overscrollBehaviorInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_overscroll_behavior_inline);
}

MOZ_CAN_RUN_SCRIPT static bool
set_overscrollBehaviorInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_overscroll_behavior_inline);
}

static const JSJitInfo overscrollBehaviorInline_getterinfo = {
  { get_overscrollBehaviorInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo overscrollBehaviorInline_setterinfo = {
  { (JSJitGetterOp)set_overscrollBehaviorInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_overscrollBehaviorX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_overscroll_behavior_x);
}

MOZ_CAN_RUN_SCRIPT static bool
set_overscrollBehaviorX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_overscroll_behavior_x);
}

static const JSJitInfo overscrollBehaviorX_getterinfo = {
  { get_overscrollBehaviorX },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo overscrollBehaviorX_setterinfo = {
  { (JSJitGetterOp)set_overscrollBehaviorX },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_overscrollBehaviorY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_overscroll_behavior_y);
}

MOZ_CAN_RUN_SCRIPT static bool
set_overscrollBehaviorY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_overscroll_behavior_y);
}

static const JSJitInfo overscrollBehaviorY_getterinfo = {
  { get_overscrollBehaviorY },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo overscrollBehaviorY_setterinfo = {
  { (JSJitGetterOp)set_overscrollBehaviorY },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_floodOpacity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_flood_opacity);
}

MOZ_CAN_RUN_SCRIPT static bool
set_floodOpacity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_flood_opacity);
}

static const JSJitInfo floodOpacity_getterinfo = {
  { get_floodOpacity },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo floodOpacity_setterinfo = {
  { (JSJitGetterOp)set_floodOpacity },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozWindowOpacity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_window_opacity);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozWindowOpacity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_window_opacity);
}

static const JSJitInfo MozWindowOpacity_getterinfo = {
  { get_MozWindowOpacity },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozWindowOpacity_setterinfo = {
  { (JSJitGetterOp)set_MozWindowOpacity },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_opacity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_opacity);
}

MOZ_CAN_RUN_SCRIPT static bool
set_opacity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_opacity);
}

static const JSJitInfo opacity_getterinfo = {
  { get_opacity },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo opacity_setterinfo = {
  { (JSJitGetterOp)set_opacity },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_shapeImageThreshold(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_shape_image_threshold);
}

MOZ_CAN_RUN_SCRIPT static bool
set_shapeImageThreshold(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_shape_image_threshold);
}

static const JSJitInfo shapeImageThreshold_getterinfo = {
  { get_shapeImageThreshold },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo shapeImageThreshold_setterinfo = {
  { (JSJitGetterOp)set_shapeImageThreshold },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_stopOpacity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_stop_opacity);
}

MOZ_CAN_RUN_SCRIPT static bool
set_stopOpacity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_stop_opacity);
}

static const JSJitInfo stopOpacity_getterinfo = {
  { get_stopOpacity },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo stopOpacity_setterinfo = {
  { (JSJitGetterOp)set_stopOpacity },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBlockEndStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_end_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBlockEndStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_end_style);
}

static const JSJitInfo borderBlockEndStyle_getterinfo = {
  { get_borderBlockEndStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBlockEndStyle_setterinfo = {
  { (JSJitGetterOp)set_borderBlockEndStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBlockStartStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_start_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBlockStartStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_start_style);
}

static const JSJitInfo borderBlockStartStyle_getterinfo = {
  { get_borderBlockStartStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBlockStartStyle_setterinfo = {
  { (JSJitGetterOp)set_borderBlockStartStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBottomStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_bottom_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBottomStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_bottom_style);
}

static const JSJitInfo borderBottomStyle_getterinfo = {
  { get_borderBottomStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBottomStyle_setterinfo = {
  { (JSJitGetterOp)set_borderBottomStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderInlineEndStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_end_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderInlineEndStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_end_style);
}

static const JSJitInfo borderInlineEndStyle_getterinfo = {
  { get_borderInlineEndStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderInlineEndStyle_setterinfo = {
  { (JSJitGetterOp)set_borderInlineEndStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderInlineStartStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_start_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderInlineStartStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_start_style);
}

static const JSJitInfo borderInlineStartStyle_getterinfo = {
  { get_borderInlineStartStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderInlineStartStyle_setterinfo = {
  { (JSJitGetterOp)set_borderInlineStartStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderLeftStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_left_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderLeftStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_left_style);
}

static const JSJitInfo borderLeftStyle_getterinfo = {
  { get_borderLeftStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderLeftStyle_setterinfo = {
  { (JSJitGetterOp)set_borderLeftStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderRightStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_right_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderRightStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_right_style);
}

static const JSJitInfo borderRightStyle_getterinfo = {
  { get_borderRightStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderRightStyle_setterinfo = {
  { (JSJitGetterOp)set_borderRightStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderTopStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_top_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderTopStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_top_style);
}

static const JSJitInfo borderTopStyle_getterinfo = {
  { get_borderTopStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderTopStyle_setterinfo = {
  { (JSJitGetterOp)set_borderTopStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_columnRuleStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_rule_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_columnRuleStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_rule_style);
}

static const JSJitInfo columnRuleStyle_getterinfo = {
  { get_columnRuleStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo columnRuleStyle_setterinfo = {
  { (JSJitGetterOp)set_columnRuleStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_accentColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_accent_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_accentColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_accent_color);
}

static const JSJitInfo accentColor_getterinfo = {
  { get_accentColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo accentColor_setterinfo = {
  { (JSJitGetterOp)set_accentColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_anchorName(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_anchor_name);
}

MOZ_CAN_RUN_SCRIPT static bool
set_anchorName(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_anchor_name);
}

static const JSJitInfo anchorName_getterinfo = {
  { get_anchorName },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo anchorName_setterinfo = {
  { (JSJitGetterOp)set_anchorName },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_anchorScope(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_anchor_scope);
}

MOZ_CAN_RUN_SCRIPT static bool
set_anchorScope(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_anchor_scope);
}

static const JSJitInfo anchorScope_getterinfo = {
  { get_anchorScope },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo anchorScope_setterinfo = {
  { (JSJitGetterOp)set_anchorScope },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_animationComposition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_composition);
}

MOZ_CAN_RUN_SCRIPT static bool
set_animationComposition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_composition);
}

static const JSJitInfo animationComposition_getterinfo = {
  { get_animationComposition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo animationComposition_setterinfo = {
  { (JSJitGetterOp)set_animationComposition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_animationDelay(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_delay);
}

MOZ_CAN_RUN_SCRIPT static bool
set_animationDelay(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_delay);
}

static const JSJitInfo animationDelay_getterinfo = {
  { get_animationDelay },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo animationDelay_setterinfo = {
  { (JSJitGetterOp)set_animationDelay },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_animationDirection(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_direction);
}

MOZ_CAN_RUN_SCRIPT static bool
set_animationDirection(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_direction);
}

static const JSJitInfo animationDirection_getterinfo = {
  { get_animationDirection },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo animationDirection_setterinfo = {
  { (JSJitGetterOp)set_animationDirection },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_animationDuration(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_duration);
}

MOZ_CAN_RUN_SCRIPT static bool
set_animationDuration(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_duration);
}

static const JSJitInfo animationDuration_getterinfo = {
  { get_animationDuration },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo animationDuration_setterinfo = {
  { (JSJitGetterOp)set_animationDuration },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_animationFillMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_fill_mode);
}

MOZ_CAN_RUN_SCRIPT static bool
set_animationFillMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_fill_mode);
}

static const JSJitInfo animationFillMode_getterinfo = {
  { get_animationFillMode },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo animationFillMode_setterinfo = {
  { (JSJitGetterOp)set_animationFillMode },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_animationIterationCount(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_iteration_count);
}

MOZ_CAN_RUN_SCRIPT static bool
set_animationIterationCount(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_iteration_count);
}

static const JSJitInfo animationIterationCount_getterinfo = {
  { get_animationIterationCount },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo animationIterationCount_setterinfo = {
  { (JSJitGetterOp)set_animationIterationCount },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_animationName(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_name);
}

MOZ_CAN_RUN_SCRIPT static bool
set_animationName(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_name);
}

static const JSJitInfo animationName_getterinfo = {
  { get_animationName },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo animationName_setterinfo = {
  { (JSJitGetterOp)set_animationName },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_animationPlayState(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_play_state);
}

MOZ_CAN_RUN_SCRIPT static bool
set_animationPlayState(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_play_state);
}

static const JSJitInfo animationPlayState_getterinfo = {
  { get_animationPlayState },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo animationPlayState_setterinfo = {
  { (JSJitGetterOp)set_animationPlayState },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_animationTimeline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_timeline);
}

MOZ_CAN_RUN_SCRIPT static bool
set_animationTimeline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_timeline);
}

static const JSJitInfo animationTimeline_getterinfo = {
  { get_animationTimeline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo animationTimeline_setterinfo = {
  { (JSJitGetterOp)set_animationTimeline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_animationTimingFunction(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_timing_function);
}

MOZ_CAN_RUN_SCRIPT static bool
set_animationTimingFunction(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation_timing_function);
}

static const JSJitInfo animationTimingFunction_getterinfo = {
  { get_animationTimingFunction },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo animationTimingFunction_setterinfo = {
  { (JSJitGetterOp)set_animationTimingFunction },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_backdropFilter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_backdrop_filter);
}

MOZ_CAN_RUN_SCRIPT static bool
set_backdropFilter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_backdrop_filter);
}

static const JSJitInfo backdropFilter_getterinfo = {
  { get_backdropFilter },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo backdropFilter_setterinfo = {
  { (JSJitGetterOp)set_backdropFilter },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_backgroundAttachment(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_attachment);
}

MOZ_CAN_RUN_SCRIPT static bool
set_backgroundAttachment(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_attachment);
}

static const JSJitInfo backgroundAttachment_getterinfo = {
  { get_backgroundAttachment },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo backgroundAttachment_setterinfo = {
  { (JSJitGetterOp)set_backgroundAttachment },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_backgroundBlendMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_blend_mode);
}

MOZ_CAN_RUN_SCRIPT static bool
set_backgroundBlendMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_blend_mode);
}

static const JSJitInfo backgroundBlendMode_getterinfo = {
  { get_backgroundBlendMode },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo backgroundBlendMode_setterinfo = {
  { (JSJitGetterOp)set_backgroundBlendMode },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_backgroundClip(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_clip);
}

MOZ_CAN_RUN_SCRIPT static bool
set_backgroundClip(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_clip);
}

static const JSJitInfo backgroundClip_getterinfo = {
  { get_backgroundClip },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo backgroundClip_setterinfo = {
  { (JSJitGetterOp)set_backgroundClip },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_backgroundImage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_image);
}

MOZ_CAN_RUN_SCRIPT static bool
set_backgroundImage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_image);
}

static const JSJitInfo backgroundImage_getterinfo = {
  { get_backgroundImage },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo backgroundImage_setterinfo = {
  { (JSJitGetterOp)set_backgroundImage },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_backgroundOrigin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_origin);
}

MOZ_CAN_RUN_SCRIPT static bool
set_backgroundOrigin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_origin);
}

static const JSJitInfo backgroundOrigin_getterinfo = {
  { get_backgroundOrigin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo backgroundOrigin_setterinfo = {
  { (JSJitGetterOp)set_backgroundOrigin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_backgroundPositionX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_position_x);
}

MOZ_CAN_RUN_SCRIPT static bool
set_backgroundPositionX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_position_x);
}

static const JSJitInfo backgroundPositionX_getterinfo = {
  { get_backgroundPositionX },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo backgroundPositionX_setterinfo = {
  { (JSJitGetterOp)set_backgroundPositionX },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_backgroundPositionY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_position_y);
}

MOZ_CAN_RUN_SCRIPT static bool
set_backgroundPositionY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_position_y);
}

static const JSJitInfo backgroundPositionY_getterinfo = {
  { get_backgroundPositionY },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo backgroundPositionY_setterinfo = {
  { (JSJitGetterOp)set_backgroundPositionY },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_backgroundRepeat(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_repeat);
}

MOZ_CAN_RUN_SCRIPT static bool
set_backgroundRepeat(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_repeat);
}

static const JSJitInfo backgroundRepeat_getterinfo = {
  { get_backgroundRepeat },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo backgroundRepeat_setterinfo = {
  { (JSJitGetterOp)set_backgroundRepeat },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_backgroundSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_size);
}

MOZ_CAN_RUN_SCRIPT static bool
set_backgroundSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_size);
}

static const JSJitInfo backgroundSize_getterinfo = {
  { get_backgroundSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo backgroundSize_setterinfo = {
  { (JSJitGetterOp)set_backgroundSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderImageOutset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_image_outset);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderImageOutset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_image_outset);
}

static const JSJitInfo borderImageOutset_getterinfo = {
  { get_borderImageOutset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderImageOutset_setterinfo = {
  { (JSJitGetterOp)set_borderImageOutset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderImageSlice(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_image_slice);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderImageSlice(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_image_slice);
}

static const JSJitInfo borderImageSlice_getterinfo = {
  { get_borderImageSlice },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderImageSlice_setterinfo = {
  { (JSJitGetterOp)set_borderImageSlice },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderImageWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_image_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderImageWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_image_width);
}

static const JSJitInfo borderImageWidth_getterinfo = {
  { get_borderImageWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderImageWidth_setterinfo = {
  { (JSJitGetterOp)set_borderImageWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderSpacing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_spacing);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderSpacing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_spacing);
}

static const JSJitInfo borderSpacing_getterinfo = {
  { get_borderSpacing },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderSpacing_setterinfo = {
  { (JSJitGetterOp)set_borderSpacing },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_boxShadow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_box_shadow);
}

MOZ_CAN_RUN_SCRIPT static bool
set_boxShadow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_box_shadow);
}

static const JSJitInfo boxShadow_getterinfo = {
  { get_boxShadow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo boxShadow_setterinfo = {
  { (JSJitGetterOp)set_boxShadow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_caretColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_caret_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_caretColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_caret_color);
}

static const JSJitInfo caretColor_getterinfo = {
  { get_caretColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo caretColor_setterinfo = {
  { (JSJitGetterOp)set_caretColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_clip(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_clip);
}

MOZ_CAN_RUN_SCRIPT static bool
set_clip(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_clip);
}

static const JSJitInfo clip_getterinfo = {
  { get_clip },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo clip_setterinfo = {
  { (JSJitGetterOp)set_clip },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_clipPath(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_clip_path);
}

MOZ_CAN_RUN_SCRIPT static bool
set_clipPath(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_clip_path);
}

static const JSJitInfo clipPath_getterinfo = {
  { get_clipPath },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo clipPath_setterinfo = {
  { (JSJitGetterOp)set_clipPath },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_color(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_color(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_color);
}

static const JSJitInfo color_getterinfo = {
  { get_color },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo color_setterinfo = {
  { (JSJitGetterOp)set_color },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_colorScheme(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_color_scheme);
}

MOZ_CAN_RUN_SCRIPT static bool
set_colorScheme(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_color_scheme);
}

static const JSJitInfo colorScheme_getterinfo = {
  { get_colorScheme },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo colorScheme_setterinfo = {
  { (JSJitGetterOp)set_colorScheme },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_columnWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_columnWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_width);
}

static const JSJitInfo columnWidth_getterinfo = {
  { get_columnWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo columnWidth_setterinfo = {
  { (JSJitGetterOp)set_columnWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_containerName(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_container_name);
}

MOZ_CAN_RUN_SCRIPT static bool
set_containerName(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_container_name);
}

static const JSJitInfo containerName_getterinfo = {
  { get_containerName },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo containerName_setterinfo = {
  { (JSJitGetterOp)set_containerName },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_content(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_content);
}

MOZ_CAN_RUN_SCRIPT static bool
set_content(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_content);
}

static const JSJitInfo content_getterinfo = {
  { get_content },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo content_setterinfo = {
  { (JSJitGetterOp)set_content },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_counterIncrement(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_counter_increment);
}

MOZ_CAN_RUN_SCRIPT static bool
set_counterIncrement(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_counter_increment);
}

static const JSJitInfo counterIncrement_getterinfo = {
  { get_counterIncrement },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo counterIncrement_setterinfo = {
  { (JSJitGetterOp)set_counterIncrement },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_counterReset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_counter_reset);
}

MOZ_CAN_RUN_SCRIPT static bool
set_counterReset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_counter_reset);
}

static const JSJitInfo counterReset_getterinfo = {
  { get_counterReset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo counterReset_setterinfo = {
  { (JSJitGetterOp)set_counterReset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_counterSet(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_counter_set);
}

MOZ_CAN_RUN_SCRIPT static bool
set_counterSet(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_counter_set);
}

static const JSJitInfo counterSet_getterinfo = {
  { get_counterSet },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo counterSet_setterinfo = {
  { (JSJitGetterOp)set_counterSet },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_cursor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_cursor);
}

MOZ_CAN_RUN_SCRIPT static bool
set_cursor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_cursor);
}

static const JSJitInfo cursor_getterinfo = {
  { get_cursor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo cursor_setterinfo = {
  { (JSJitGetterOp)set_cursor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_d(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_d);
}

MOZ_CAN_RUN_SCRIPT static bool
set_d(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_d);
}

static const JSJitInfo d_getterinfo = {
  { get_d },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo d_setterinfo = {
  { (JSJitGetterOp)set_d },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_filter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_filter);
}

MOZ_CAN_RUN_SCRIPT static bool
set_filter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_filter);
}

static const JSJitInfo filter_getterinfo = {
  { get_filter },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo filter_setterinfo = {
  { (JSJitGetterOp)set_filter },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_flexBasis(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_flex_basis);
}

MOZ_CAN_RUN_SCRIPT static bool
set_flexBasis(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_flex_basis);
}

static const JSJitInfo flexBasis_getterinfo = {
  { get_flexBasis },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo flexBasis_setterinfo = {
  { (JSJitGetterOp)set_flexBasis },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontFamily(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_family);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontFamily(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_family);
}

static const JSJitInfo fontFamily_getterinfo = {
  { get_fontFamily },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontFamily_setterinfo = {
  { (JSJitGetterOp)set_fontFamily },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontFeatureSettings(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_feature_settings);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontFeatureSettings(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_feature_settings);
}

static const JSJitInfo fontFeatureSettings_getterinfo = {
  { get_fontFeatureSettings },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontFeatureSettings_setterinfo = {
  { (JSJitGetterOp)set_fontFeatureSettings },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontPalette(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_palette);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontPalette(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_palette);
}

static const JSJitInfo fontPalette_getterinfo = {
  { get_fontPalette },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontPalette_setterinfo = {
  { (JSJitGetterOp)set_fontPalette },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_size);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_size);
}

static const JSJitInfo fontSize_getterinfo = {
  { get_fontSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontSize_setterinfo = {
  { (JSJitGetterOp)set_fontSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontVariantAlternates(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant_alternates);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontVariantAlternates(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant_alternates);
}

static const JSJitInfo fontVariantAlternates_getterinfo = {
  { get_fontVariantAlternates },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontVariantAlternates_setterinfo = {
  { (JSJitGetterOp)set_fontVariantAlternates },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontVariationSettings(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variation_settings);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontVariationSettings(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variation_settings);
}

static const JSJitInfo fontVariationSettings_getterinfo = {
  { get_fontVariationSettings },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontVariationSettings_setterinfo = {
  { (JSJitGetterOp)set_fontVariationSettings },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gridTemplateAreas(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_template_areas);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gridTemplateAreas(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_template_areas);
}

static const JSJitInfo gridTemplateAreas_getterinfo = {
  { get_gridTemplateAreas },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gridTemplateAreas_setterinfo = {
  { (JSJitGetterOp)set_gridTemplateAreas },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_hyphenateCharacter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_hyphenate_character);
}

MOZ_CAN_RUN_SCRIPT static bool
set_hyphenateCharacter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_hyphenate_character);
}

static const JSJitInfo hyphenateCharacter_getterinfo = {
  { get_hyphenateCharacter },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo hyphenateCharacter_setterinfo = {
  { (JSJitGetterOp)set_hyphenateCharacter },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_hyphenateLimitChars(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_hyphenate_limit_chars);
}

MOZ_CAN_RUN_SCRIPT static bool
set_hyphenateLimitChars(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_hyphenate_limit_chars);
}

static const JSJitInfo hyphenateLimitChars_getterinfo = {
  { get_hyphenateLimitChars },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo hyphenateLimitChars_setterinfo = {
  { (JSJitGetterOp)set_hyphenateLimitChars },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_letterSpacing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_letter_spacing);
}

MOZ_CAN_RUN_SCRIPT static bool
set_letterSpacing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_letter_spacing);
}

static const JSJitInfo letterSpacing_getterinfo = {
  { get_letterSpacing },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo letterSpacing_setterinfo = {
  { (JSJitGetterOp)set_letterSpacing },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_lineHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_line_height);
}

MOZ_CAN_RUN_SCRIPT static bool
set_lineHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_line_height);
}

static const JSJitInfo lineHeight_getterinfo = {
  { get_lineHeight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo lineHeight_setterinfo = {
  { (JSJitGetterOp)set_lineHeight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_listStyleType(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_list_style_type);
}

MOZ_CAN_RUN_SCRIPT static bool
set_listStyleType(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_list_style_type);
}

static const JSJitInfo listStyleType_getterinfo = {
  { get_listStyleType },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo listStyleType_setterinfo = {
  { (JSJitGetterOp)set_listStyleType },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maskClip(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_clip);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maskClip(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_clip);
}

static const JSJitInfo maskClip_getterinfo = {
  { get_maskClip },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maskClip_setterinfo = {
  { (JSJitGetterOp)set_maskClip },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maskComposite(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_composite);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maskComposite(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_composite);
}

static const JSJitInfo maskComposite_getterinfo = {
  { get_maskComposite },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maskComposite_setterinfo = {
  { (JSJitGetterOp)set_maskComposite },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maskImage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_image);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maskImage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_image);
}

static const JSJitInfo maskImage_getterinfo = {
  { get_maskImage },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maskImage_setterinfo = {
  { (JSJitGetterOp)set_maskImage },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maskMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_mode);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maskMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_mode);
}

static const JSJitInfo maskMode_getterinfo = {
  { get_maskMode },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maskMode_setterinfo = {
  { (JSJitGetterOp)set_maskMode },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maskOrigin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_origin);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maskOrigin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_origin);
}

static const JSJitInfo maskOrigin_getterinfo = {
  { get_maskOrigin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maskOrigin_setterinfo = {
  { (JSJitGetterOp)set_maskOrigin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maskPositionX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_position_x);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maskPositionX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_position_x);
}

static const JSJitInfo maskPositionX_getterinfo = {
  { get_maskPositionX },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maskPositionX_setterinfo = {
  { (JSJitGetterOp)set_maskPositionX },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maskPositionY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_position_y);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maskPositionY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_position_y);
}

static const JSJitInfo maskPositionY_getterinfo = {
  { get_maskPositionY },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maskPositionY_setterinfo = {
  { (JSJitGetterOp)set_maskPositionY },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maskRepeat(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_repeat);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maskRepeat(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_repeat);
}

static const JSJitInfo maskRepeat_getterinfo = {
  { get_maskRepeat },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maskRepeat_setterinfo = {
  { (JSJitGetterOp)set_maskRepeat },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maskSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_size);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maskSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_size);
}

static const JSJitInfo maskSize_getterinfo = {
  { get_maskSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maskSize_setterinfo = {
  { (JSJitGetterOp)set_maskSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozContextProperties(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_context_properties);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozContextProperties(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_context_properties);
}

static const JSJitInfo MozContextProperties_getterinfo = {
  { get_MozContextProperties },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozContextProperties_setterinfo = {
  { (JSJitGetterOp)set_MozContextProperties },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_offsetAnchor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_offset_anchor);
}

MOZ_CAN_RUN_SCRIPT static bool
set_offsetAnchor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_offset_anchor);
}

static const JSJitInfo offsetAnchor_getterinfo = {
  { get_offsetAnchor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo offsetAnchor_setterinfo = {
  { (JSJitGetterOp)set_offsetAnchor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_offsetPath(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_offset_path);
}

MOZ_CAN_RUN_SCRIPT static bool
set_offsetPath(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_offset_path);
}

static const JSJitInfo offsetPath_getterinfo = {
  { get_offsetPath },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo offsetPath_setterinfo = {
  { (JSJitGetterOp)set_offsetPath },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_offsetPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_offset_position);
}

MOZ_CAN_RUN_SCRIPT static bool
set_offsetPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_offset_position);
}

static const JSJitInfo offsetPosition_getterinfo = {
  { get_offsetPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo offsetPosition_setterinfo = {
  { (JSJitGetterOp)set_offsetPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_outlineOffset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_outline_offset);
}

MOZ_CAN_RUN_SCRIPT static bool
set_outlineOffset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_outline_offset);
}

static const JSJitInfo outlineOffset_getterinfo = {
  { get_outlineOffset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo outlineOffset_setterinfo = {
  { (JSJitGetterOp)set_outlineOffset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_page(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_page);
}

MOZ_CAN_RUN_SCRIPT static bool
set_page(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_page);
}

static const JSJitInfo page_getterinfo = {
  { get_page },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo page_setterinfo = {
  { (JSJitGetterOp)set_page },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_perspective(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_perspective);
}

MOZ_CAN_RUN_SCRIPT static bool
set_perspective(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_perspective);
}

static const JSJitInfo perspective_getterinfo = {
  { get_perspective },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo perspective_setterinfo = {
  { (JSJitGetterOp)set_perspective },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_positionAnchor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_position_anchor);
}

MOZ_CAN_RUN_SCRIPT static bool
set_positionAnchor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_position_anchor);
}

static const JSJitInfo positionAnchor_getterinfo = {
  { get_positionAnchor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo positionAnchor_setterinfo = {
  { (JSJitGetterOp)set_positionAnchor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_positionTryFallbacks(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_position_try_fallbacks);
}

MOZ_CAN_RUN_SCRIPT static bool
set_positionTryFallbacks(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_position_try_fallbacks);
}

static const JSJitInfo positionTryFallbacks_getterinfo = {
  { get_positionTryFallbacks },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo positionTryFallbacks_setterinfo = {
  { (JSJitGetterOp)set_positionTryFallbacks },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_quotes(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_quotes);
}

MOZ_CAN_RUN_SCRIPT static bool
set_quotes(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_quotes);
}

static const JSJitInfo quotes_getterinfo = {
  { get_quotes },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo quotes_setterinfo = {
  { (JSJitGetterOp)set_quotes },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_rotate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_rotate);
}

MOZ_CAN_RUN_SCRIPT static bool
set_rotate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_rotate);
}

static const JSJitInfo rotate_getterinfo = {
  { get_rotate },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo rotate_setterinfo = {
  { (JSJitGetterOp)set_rotate },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scale(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scale);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scale(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scale);
}

static const JSJitInfo scale_getterinfo = {
  { get_scale },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scale_setterinfo = {
  { (JSJitGetterOp)set_scale },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollTimelineAxis(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_timeline_axis);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollTimelineAxis(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_timeline_axis);
}

static const JSJitInfo scrollTimelineAxis_getterinfo = {
  { get_scrollTimelineAxis },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollTimelineAxis_setterinfo = {
  { (JSJitGetterOp)set_scrollTimelineAxis },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollTimelineName(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_timeline_name);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollTimelineName(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_timeline_name);
}

static const JSJitInfo scrollTimelineName_getterinfo = {
  { get_scrollTimelineName },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollTimelineName_setterinfo = {
  { (JSJitGetterOp)set_scrollTimelineName },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollbarColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scrollbar_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollbarColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scrollbar_color);
}

static const JSJitInfo scrollbarColor_getterinfo = {
  { get_scrollbarColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollbarColor_setterinfo = {
  { (JSJitGetterOp)set_scrollbarColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_shapeOutside(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_shape_outside);
}

MOZ_CAN_RUN_SCRIPT static bool
set_shapeOutside(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_shape_outside);
}

static const JSJitInfo shapeOutside_getterinfo = {
  { get_shapeOutside },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo shapeOutside_setterinfo = {
  { (JSJitGetterOp)set_shapeOutside },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_strokeDasharray(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke_dasharray);
}

MOZ_CAN_RUN_SCRIPT static bool
set_strokeDasharray(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke_dasharray);
}

static const JSJitInfo strokeDasharray_getterinfo = {
  { get_strokeDasharray },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo strokeDasharray_setterinfo = {
  { (JSJitGetterOp)set_strokeDasharray },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_strokeDashoffset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke_dashoffset);
}

MOZ_CAN_RUN_SCRIPT static bool
set_strokeDashoffset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke_dashoffset);
}

static const JSJitInfo strokeDashoffset_getterinfo = {
  { get_strokeDashoffset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo strokeDashoffset_setterinfo = {
  { (JSJitGetterOp)set_strokeDashoffset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_strokeWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_strokeWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke_width);
}

static const JSJitInfo strokeWidth_getterinfo = {
  { get_strokeWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo strokeWidth_setterinfo = {
  { (JSJitGetterOp)set_strokeWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_tabSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_tab_size);
}

MOZ_CAN_RUN_SCRIPT static bool
set_tabSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_tab_size);
}

static const JSJitInfo tabSize_getterinfo = {
  { get_tabSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo tabSize_setterinfo = {
  { (JSJitGetterOp)set_tabSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textDecorationInset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_decoration_inset);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textDecorationInset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_decoration_inset);
}

static const JSJitInfo textDecorationInset_getterinfo = {
  { get_textDecorationInset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textDecorationInset_setterinfo = {
  { (JSJitGetterOp)set_textDecorationInset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textDecorationThickness(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_decoration_thickness);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textDecorationThickness(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_decoration_thickness);
}

static const JSJitInfo textDecorationThickness_getterinfo = {
  { get_textDecorationThickness },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textDecorationThickness_setterinfo = {
  { (JSJitGetterOp)set_textDecorationThickness },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textEmphasisStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_emphasis_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textEmphasisStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_emphasis_style);
}

static const JSJitInfo textEmphasisStyle_getterinfo = {
  { get_textEmphasisStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textEmphasisStyle_setterinfo = {
  { (JSJitGetterOp)set_textEmphasisStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textIndent(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_indent);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textIndent(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_indent);
}

static const JSJitInfo textIndent_getterinfo = {
  { get_textIndent },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textIndent_setterinfo = {
  { (JSJitGetterOp)set_textIndent },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textOverflow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_overflow);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textOverflow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_overflow);
}

static const JSJitInfo textOverflow_getterinfo = {
  { get_textOverflow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textOverflow_setterinfo = {
  { (JSJitGetterOp)set_textOverflow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textShadow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_shadow);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textShadow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_shadow);
}

static const JSJitInfo textShadow_getterinfo = {
  { get_textShadow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textShadow_setterinfo = {
  { (JSJitGetterOp)set_textShadow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textUnderlineOffset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_underline_offset);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textUnderlineOffset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_underline_offset);
}

static const JSJitInfo textUnderlineOffset_getterinfo = {
  { get_textUnderlineOffset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textUnderlineOffset_setterinfo = {
  { (JSJitGetterOp)set_textUnderlineOffset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_transformOrigin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_transform_origin);
}

MOZ_CAN_RUN_SCRIPT static bool
set_transformOrigin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_transform_origin);
}

static const JSJitInfo transformOrigin_getterinfo = {
  { get_transformOrigin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo transformOrigin_setterinfo = {
  { (JSJitGetterOp)set_transformOrigin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_transitionBehavior(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_transition_behavior);
}

MOZ_CAN_RUN_SCRIPT static bool
set_transitionBehavior(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_transition_behavior);
}

static const JSJitInfo transitionBehavior_getterinfo = {
  { get_transitionBehavior },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo transitionBehavior_setterinfo = {
  { (JSJitGetterOp)set_transitionBehavior },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_transitionDelay(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_transition_delay);
}

MOZ_CAN_RUN_SCRIPT static bool
set_transitionDelay(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_transition_delay);
}

static const JSJitInfo transitionDelay_getterinfo = {
  { get_transitionDelay },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo transitionDelay_setterinfo = {
  { (JSJitGetterOp)set_transitionDelay },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_transitionDuration(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_transition_duration);
}

MOZ_CAN_RUN_SCRIPT static bool
set_transitionDuration(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_transition_duration);
}

static const JSJitInfo transitionDuration_getterinfo = {
  { get_transitionDuration },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo transitionDuration_setterinfo = {
  { (JSJitGetterOp)set_transitionDuration },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_transitionProperty(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_transition_property);
}

MOZ_CAN_RUN_SCRIPT static bool
set_transitionProperty(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_transition_property);
}

static const JSJitInfo transitionProperty_getterinfo = {
  { get_transitionProperty },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo transitionProperty_setterinfo = {
  { (JSJitGetterOp)set_transitionProperty },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_transitionTimingFunction(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_transition_timing_function);
}

MOZ_CAN_RUN_SCRIPT static bool
set_transitionTimingFunction(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_transition_timing_function);
}

static const JSJitInfo transitionTimingFunction_getterinfo = {
  { get_transitionTimingFunction },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo transitionTimingFunction_setterinfo = {
  { (JSJitGetterOp)set_transitionTimingFunction },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_translate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_translate);
}

MOZ_CAN_RUN_SCRIPT static bool
set_translate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_translate);
}

static const JSJitInfo translate_getterinfo = {
  { get_translate },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo translate_setterinfo = {
  { (JSJitGetterOp)set_translate },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_verticalAlign(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_vertical_align);
}

MOZ_CAN_RUN_SCRIPT static bool
set_verticalAlign(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_vertical_align);
}

static const JSJitInfo verticalAlign_getterinfo = {
  { get_verticalAlign },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo verticalAlign_setterinfo = {
  { (JSJitGetterOp)set_verticalAlign },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_viewTimelineAxis(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_view_timeline_axis);
}

MOZ_CAN_RUN_SCRIPT static bool
set_viewTimelineAxis(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_view_timeline_axis);
}

static const JSJitInfo viewTimelineAxis_getterinfo = {
  { get_viewTimelineAxis },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo viewTimelineAxis_setterinfo = {
  { (JSJitGetterOp)set_viewTimelineAxis },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_viewTimelineInset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_view_timeline_inset);
}

MOZ_CAN_RUN_SCRIPT static bool
set_viewTimelineInset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_view_timeline_inset);
}

static const JSJitInfo viewTimelineInset_getterinfo = {
  { get_viewTimelineInset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo viewTimelineInset_setterinfo = {
  { (JSJitGetterOp)set_viewTimelineInset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_viewTimelineName(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_view_timeline_name);
}

MOZ_CAN_RUN_SCRIPT static bool
set_viewTimelineName(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_view_timeline_name);
}

static const JSJitInfo viewTimelineName_getterinfo = {
  { get_viewTimelineName },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo viewTimelineName_setterinfo = {
  { (JSJitGetterOp)set_viewTimelineName },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_viewTransitionClass(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_view_transition_class);
}

MOZ_CAN_RUN_SCRIPT static bool
set_viewTransitionClass(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_view_transition_class);
}

static const JSJitInfo viewTransitionClass_getterinfo = {
  { get_viewTransitionClass },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo viewTransitionClass_setterinfo = {
  { (JSJitGetterOp)set_viewTransitionClass },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_viewTransitionName(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_view_transition_name);
}

MOZ_CAN_RUN_SCRIPT static bool
set_viewTransitionName(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_view_transition_name);
}

static const JSJitInfo viewTransitionName_getterinfo = {
  { get_viewTransitionName },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo viewTransitionName_setterinfo = {
  { (JSJitGetterOp)set_viewTransitionName },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_webkitTextStrokeWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__webkit_text_stroke_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_webkitTextStrokeWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__webkit_text_stroke_width);
}

static const JSJitInfo webkitTextStrokeWidth_getterinfo = {
  { get_webkitTextStrokeWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo webkitTextStrokeWidth_setterinfo = {
  { (JSJitGetterOp)set_webkitTextStrokeWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_willChange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_will_change);
}

MOZ_CAN_RUN_SCRIPT static bool
set_willChange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_will_change);
}

static const JSJitInfo willChange_getterinfo = {
  { get_willChange },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo willChange_setterinfo = {
  { (JSJitGetterOp)set_willChange },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_wordSpacing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_word_spacing);
}

MOZ_CAN_RUN_SCRIPT static bool
set_wordSpacing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_word_spacing);
}

static const JSJitInfo wordSpacing_getterinfo = {
  { get_wordSpacing },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo wordSpacing_setterinfo = {
  { (JSJitGetterOp)set_wordSpacing },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_objectPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_object_position);
}

MOZ_CAN_RUN_SCRIPT static bool
set_objectPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_object_position);
}

static const JSJitInfo objectPosition_getterinfo = {
  { get_objectPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo objectPosition_setterinfo = {
  { (JSJitGetterOp)set_objectPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_perspectiveOrigin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_perspective_origin);
}

MOZ_CAN_RUN_SCRIPT static bool
set_perspectiveOrigin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_perspective_origin);
}

static const JSJitInfo perspectiveOrigin_getterinfo = {
  { get_perspectiveOrigin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo perspectiveOrigin_setterinfo = {
  { (JSJitGetterOp)set_perspectiveOrigin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fill(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_fill);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fill(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_fill);
}

static const JSJitInfo fill_getterinfo = {
  { get_fill },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fill_setterinfo = {
  { (JSJitGetterOp)set_fill },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_stroke(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke);
}

MOZ_CAN_RUN_SCRIPT static bool
set_stroke(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_stroke);
}

static const JSJitInfo stroke_getterinfo = {
  { get_stroke },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo stroke_setterinfo = {
  { (JSJitGetterOp)set_stroke },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gridTemplateColumns(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_template_columns);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gridTemplateColumns(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_template_columns);
}

static const JSJitInfo gridTemplateColumns_getterinfo = {
  { get_gridTemplateColumns },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gridTemplateColumns_setterinfo = {
  { (JSJitGetterOp)set_gridTemplateColumns },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gridTemplateRows(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_template_rows);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gridTemplateRows(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_template_rows);
}

static const JSJitInfo gridTemplateRows_getterinfo = {
  { get_gridTemplateRows },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gridTemplateRows_setterinfo = {
  { (JSJitGetterOp)set_gridTemplateRows },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderImageSource(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_image_source);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderImageSource(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_image_source);
}

static const JSJitInfo borderImageSource_getterinfo = {
  { get_borderImageSource },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderImageSource_setterinfo = {
  { (JSJitGetterOp)set_borderImageSource },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_listStyleImage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_list_style_image);
}

MOZ_CAN_RUN_SCRIPT static bool
set_listStyleImage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_list_style_image);
}

static const JSJitInfo listStyleImage_getterinfo = {
  { get_listStyleImage },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo listStyleImage_setterinfo = {
  { (JSJitGetterOp)set_listStyleImage },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gridAutoColumns(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_auto_columns);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gridAutoColumns(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_auto_columns);
}

static const JSJitInfo gridAutoColumns_getterinfo = {
  { get_gridAutoColumns },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gridAutoColumns_setterinfo = {
  { (JSJitGetterOp)set_gridAutoColumns },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gridAutoRows(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_auto_rows);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gridAutoRows(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_auto_rows);
}

static const JSJitInfo gridAutoRows_getterinfo = {
  { get_gridAutoRows },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gridAutoRows_setterinfo = {
  { (JSJitGetterOp)set_gridAutoRows },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozWindowTransform(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_window_transform);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozWindowTransform(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_window_transform);
}

static const JSJitInfo MozWindowTransform_getterinfo = {
  { get_MozWindowTransform },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozWindowTransform_setterinfo = {
  { (JSJitGetterOp)set_MozWindowTransform },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_transform(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_transform);
}

MOZ_CAN_RUN_SCRIPT static bool
set_transform(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_transform);
}

static const JSJitInfo transform_getterinfo = {
  { get_transform },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo transform_setterinfo = {
  { (JSJitGetterOp)set_transform },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_columnGap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_gap);
}

MOZ_CAN_RUN_SCRIPT static bool
set_columnGap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_gap);
}

static const JSJitInfo columnGap_getterinfo = {
  { get_columnGap },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo columnGap_setterinfo = {
  { (JSJitGetterOp)set_columnGap },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_rowGap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_row_gap);
}

MOZ_CAN_RUN_SCRIPT static bool
set_rowGap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_row_gap);
}

static const JSJitInfo rowGap_getterinfo = {
  { get_rowGap },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo rowGap_setterinfo = {
  { (JSJitGetterOp)set_rowGap },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_markerEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_marker_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_markerEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_marker_end);
}

static const JSJitInfo markerEnd_getterinfo = {
  { get_markerEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo markerEnd_setterinfo = {
  { (JSJitGetterOp)set_markerEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_markerMid(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_marker_mid);
}

MOZ_CAN_RUN_SCRIPT static bool
set_markerMid(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_marker_mid);
}

static const JSJitInfo markerMid_getterinfo = {
  { get_markerMid },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo markerMid_setterinfo = {
  { (JSJitGetterOp)set_markerMid },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_markerStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_marker_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_markerStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_marker_start);
}

static const JSJitInfo markerStart_getterinfo = {
  { get_markerStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo markerStart_setterinfo = {
  { (JSJitGetterOp)set_markerStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_containIntrinsicBlockSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_contain_intrinsic_block_size);
}

MOZ_CAN_RUN_SCRIPT static bool
set_containIntrinsicBlockSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_contain_intrinsic_block_size);
}

static const JSJitInfo containIntrinsicBlockSize_getterinfo = {
  { get_containIntrinsicBlockSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo containIntrinsicBlockSize_setterinfo = {
  { (JSJitGetterOp)set_containIntrinsicBlockSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_containIntrinsicHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_contain_intrinsic_height);
}

MOZ_CAN_RUN_SCRIPT static bool
set_containIntrinsicHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_contain_intrinsic_height);
}

static const JSJitInfo containIntrinsicHeight_getterinfo = {
  { get_containIntrinsicHeight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo containIntrinsicHeight_setterinfo = {
  { (JSJitGetterOp)set_containIntrinsicHeight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_containIntrinsicInlineSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_contain_intrinsic_inline_size);
}

MOZ_CAN_RUN_SCRIPT static bool
set_containIntrinsicInlineSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_contain_intrinsic_inline_size);
}

static const JSJitInfo containIntrinsicInlineSize_getterinfo = {
  { get_containIntrinsicInlineSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo containIntrinsicInlineSize_setterinfo = {
  { (JSJitGetterOp)set_containIntrinsicInlineSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_containIntrinsicWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_contain_intrinsic_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_containIntrinsicWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_contain_intrinsic_width);
}

static const JSJitInfo containIntrinsicWidth_getterinfo = {
  { get_containIntrinsicWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo containIntrinsicWidth_setterinfo = {
  { (JSJitGetterOp)set_containIntrinsicWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gridColumnEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_column_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gridColumnEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_column_end);
}

static const JSJitInfo gridColumnEnd_getterinfo = {
  { get_gridColumnEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gridColumnEnd_setterinfo = {
  { (JSJitGetterOp)set_gridColumnEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gridColumnStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_column_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gridColumnStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_column_start);
}

static const JSJitInfo gridColumnStart_getterinfo = {
  { get_gridColumnStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gridColumnStart_setterinfo = {
  { (JSJitGetterOp)set_gridColumnStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gridRowEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_row_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gridRowEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_row_end);
}

static const JSJitInfo gridRowEnd_getterinfo = {
  { get_gridRowEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gridRowEnd_setterinfo = {
  { (JSJitGetterOp)set_gridRowEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gridRowStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_row_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gridRowStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_row_start);
}

static const JSJitInfo gridRowStart_getterinfo = {
  { get_gridRowStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gridRowStart_setterinfo = {
  { (JSJitGetterOp)set_gridRowStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maxBlockSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_max_block_size);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maxBlockSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_max_block_size);
}

static const JSJitInfo maxBlockSize_getterinfo = {
  { get_maxBlockSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maxBlockSize_setterinfo = {
  { (JSJitGetterOp)set_maxBlockSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maxHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_max_height);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maxHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_max_height);
}

static const JSJitInfo maxHeight_getterinfo = {
  { get_maxHeight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maxHeight_setterinfo = {
  { (JSJitGetterOp)set_maxHeight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maxInlineSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_max_inline_size);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maxInlineSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_max_inline_size);
}

static const JSJitInfo maxInlineSize_getterinfo = {
  { get_maxInlineSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maxInlineSize_setterinfo = {
  { (JSJitGetterOp)set_maxInlineSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maxWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_max_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maxWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_max_width);
}

static const JSJitInfo maxWidth_getterinfo = {
  { get_maxWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maxWidth_setterinfo = {
  { (JSJitGetterOp)set_maxWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_cx(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_cx);
}

MOZ_CAN_RUN_SCRIPT static bool
set_cx(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_cx);
}

static const JSJitInfo cx_getterinfo = {
  { get_cx },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo cx_setterinfo = {
  { (JSJitGetterOp)set_cx },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_cy(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_cy);
}

MOZ_CAN_RUN_SCRIPT static bool
set_cy(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_cy);
}

static const JSJitInfo cy_getterinfo = {
  { get_cy },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo cy_setterinfo = {
  { (JSJitGetterOp)set_cy },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_offsetDistance(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_offset_distance);
}

MOZ_CAN_RUN_SCRIPT static bool
set_offsetDistance(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_offset_distance);
}

static const JSJitInfo offsetDistance_getterinfo = {
  { get_offsetDistance },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo offsetDistance_setterinfo = {
  { (JSJitGetterOp)set_offsetDistance },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_x(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_x);
}

MOZ_CAN_RUN_SCRIPT static bool
set_x(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_x);
}

static const JSJitInfo x_getterinfo = {
  { get_x },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo x_setterinfo = {
  { (JSJitGetterOp)set_x },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_y(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_y);
}

MOZ_CAN_RUN_SCRIPT static bool
set_y(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_y);
}

static const JSJitInfo y_getterinfo = {
  { get_y },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo y_setterinfo = {
  { (JSJitGetterOp)set_y },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBottomLeftRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_bottom_left_radius);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBottomLeftRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_bottom_left_radius);
}

static const JSJitInfo borderBottomLeftRadius_getterinfo = {
  { get_borderBottomLeftRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBottomLeftRadius_setterinfo = {
  { (JSJitGetterOp)set_borderBottomLeftRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBottomRightRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_bottom_right_radius);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBottomRightRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_bottom_right_radius);
}

static const JSJitInfo borderBottomRightRadius_getterinfo = {
  { get_borderBottomRightRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBottomRightRadius_setterinfo = {
  { (JSJitGetterOp)set_borderBottomRightRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderEndEndRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_end_end_radius);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderEndEndRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_end_end_radius);
}

static const JSJitInfo borderEndEndRadius_getterinfo = {
  { get_borderEndEndRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderEndEndRadius_setterinfo = {
  { (JSJitGetterOp)set_borderEndEndRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderEndStartRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_end_start_radius);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderEndStartRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_end_start_radius);
}

static const JSJitInfo borderEndStartRadius_getterinfo = {
  { get_borderEndStartRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderEndStartRadius_setterinfo = {
  { (JSJitGetterOp)set_borderEndStartRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderStartEndRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_start_end_radius);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderStartEndRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_start_end_radius);
}

static const JSJitInfo borderStartEndRadius_getterinfo = {
  { get_borderStartEndRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderStartEndRadius_setterinfo = {
  { (JSJitGetterOp)set_borderStartEndRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderStartStartRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_start_start_radius);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderStartStartRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_start_start_radius);
}

static const JSJitInfo borderStartStartRadius_getterinfo = {
  { get_borderStartStartRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderStartStartRadius_setterinfo = {
  { (JSJitGetterOp)set_borderStartStartRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderTopLeftRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_top_left_radius);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderTopLeftRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_top_left_radius);
}

static const JSJitInfo borderTopLeftRadius_getterinfo = {
  { get_borderTopLeftRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderTopLeftRadius_setterinfo = {
  { (JSJitGetterOp)set_borderTopLeftRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderTopRightRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_top_right_radius);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderTopRightRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_top_right_radius);
}

static const JSJitInfo borderTopRightRadius_getterinfo = {
  { get_borderTopRightRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderTopRightRadius_setterinfo = {
  { (JSJitGetterOp)set_borderTopRightRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_bottom(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_bottom);
}

MOZ_CAN_RUN_SCRIPT static bool
set_bottom(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_bottom);
}

static const JSJitInfo bottom_getterinfo = {
  { get_bottom },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo bottom_setterinfo = {
  { (JSJitGetterOp)set_bottom },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_insetBlockEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_inset_block_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_insetBlockEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_inset_block_end);
}

static const JSJitInfo insetBlockEnd_getterinfo = {
  { get_insetBlockEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo insetBlockEnd_setterinfo = {
  { (JSJitGetterOp)set_insetBlockEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_insetBlockStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_inset_block_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_insetBlockStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_inset_block_start);
}

static const JSJitInfo insetBlockStart_getterinfo = {
  { get_insetBlockStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo insetBlockStart_setterinfo = {
  { (JSJitGetterOp)set_insetBlockStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_insetInlineEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_inset_inline_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_insetInlineEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_inset_inline_end);
}

static const JSJitInfo insetInlineEnd_getterinfo = {
  { get_insetInlineEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo insetInlineEnd_setterinfo = {
  { (JSJitGetterOp)set_insetInlineEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_insetInlineStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_inset_inline_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_insetInlineStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_inset_inline_start);
}

static const JSJitInfo insetInlineStart_getterinfo = {
  { get_insetInlineStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo insetInlineStart_setterinfo = {
  { (JSJitGetterOp)set_insetInlineStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_left(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_left);
}

MOZ_CAN_RUN_SCRIPT static bool
set_left(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_left);
}

static const JSJitInfo left_getterinfo = {
  { get_left },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo left_setterinfo = {
  { (JSJitGetterOp)set_left },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_right(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_right);
}

MOZ_CAN_RUN_SCRIPT static bool
set_right(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_right);
}

static const JSJitInfo right_getterinfo = {
  { get_right },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo right_setterinfo = {
  { (JSJitGetterOp)set_right },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_top(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_top);
}

MOZ_CAN_RUN_SCRIPT static bool
set_top(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_top);
}

static const JSJitInfo top_getterinfo = {
  { get_top },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo top_setterinfo = {
  { (JSJitGetterOp)set_top },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_marginBlockEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_block_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_marginBlockEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_block_end);
}

static const JSJitInfo marginBlockEnd_getterinfo = {
  { get_marginBlockEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo marginBlockEnd_setterinfo = {
  { (JSJitGetterOp)set_marginBlockEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_marginBlockStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_block_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_marginBlockStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_block_start);
}

static const JSJitInfo marginBlockStart_getterinfo = {
  { get_marginBlockStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo marginBlockStart_setterinfo = {
  { (JSJitGetterOp)set_marginBlockStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_marginBottom(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_bottom);
}

MOZ_CAN_RUN_SCRIPT static bool
set_marginBottom(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_bottom);
}

static const JSJitInfo marginBottom_getterinfo = {
  { get_marginBottom },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo marginBottom_setterinfo = {
  { (JSJitGetterOp)set_marginBottom },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_marginInlineEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_inline_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_marginInlineEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_inline_end);
}

static const JSJitInfo marginInlineEnd_getterinfo = {
  { get_marginInlineEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo marginInlineEnd_setterinfo = {
  { (JSJitGetterOp)set_marginInlineEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_marginInlineStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_inline_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_marginInlineStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_inline_start);
}

static const JSJitInfo marginInlineStart_getterinfo = {
  { get_marginInlineStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo marginInlineStart_setterinfo = {
  { (JSJitGetterOp)set_marginInlineStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_marginLeft(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_left);
}

MOZ_CAN_RUN_SCRIPT static bool
set_marginLeft(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_left);
}

static const JSJitInfo marginLeft_getterinfo = {
  { get_marginLeft },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo marginLeft_setterinfo = {
  { (JSJitGetterOp)set_marginLeft },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_marginRight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_right);
}

MOZ_CAN_RUN_SCRIPT static bool
set_marginRight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_right);
}

static const JSJitInfo marginRight_getterinfo = {
  { get_marginRight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo marginRight_setterinfo = {
  { (JSJitGetterOp)set_marginRight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_marginTop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_top);
}

MOZ_CAN_RUN_SCRIPT static bool
set_marginTop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_top);
}

static const JSJitInfo marginTop_getterinfo = {
  { get_marginTop },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo marginTop_setterinfo = {
  { (JSJitGetterOp)set_marginTop },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_blockSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_block_size);
}

MOZ_CAN_RUN_SCRIPT static bool
set_blockSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_block_size);
}

static const JSJitInfo blockSize_getterinfo = {
  { get_blockSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo blockSize_setterinfo = {
  { (JSJitGetterOp)set_blockSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_height(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_height);
}

MOZ_CAN_RUN_SCRIPT static bool
set_height(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_height);
}

static const JSJitInfo height_getterinfo = {
  { get_height },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo height_setterinfo = {
  { (JSJitGetterOp)set_height },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_inlineSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_inline_size);
}

MOZ_CAN_RUN_SCRIPT static bool
set_inlineSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_inline_size);
}

static const JSJitInfo inlineSize_getterinfo = {
  { get_inlineSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo inlineSize_setterinfo = {
  { (JSJitGetterOp)set_inlineSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_minBlockSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_min_block_size);
}

MOZ_CAN_RUN_SCRIPT static bool
set_minBlockSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_min_block_size);
}

static const JSJitInfo minBlockSize_getterinfo = {
  { get_minBlockSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo minBlockSize_setterinfo = {
  { (JSJitGetterOp)set_minBlockSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_minHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_min_height);
}

MOZ_CAN_RUN_SCRIPT static bool
set_minHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_min_height);
}

static const JSJitInfo minHeight_getterinfo = {
  { get_minHeight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo minHeight_setterinfo = {
  { (JSJitGetterOp)set_minHeight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_minInlineSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_min_inline_size);
}

MOZ_CAN_RUN_SCRIPT static bool
set_minInlineSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_min_inline_size);
}

static const JSJitInfo minInlineSize_getterinfo = {
  { get_minInlineSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo minInlineSize_setterinfo = {
  { (JSJitGetterOp)set_minInlineSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_minWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_min_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_minWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_min_width);
}

static const JSJitInfo minWidth_getterinfo = {
  { get_minWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo minWidth_setterinfo = {
  { (JSJitGetterOp)set_minWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_width(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_width(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_width);
}

static const JSJitInfo width_getterinfo = {
  { get_width },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo width_setterinfo = {
  { (JSJitGetterOp)set_width },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBlockEndWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_end_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBlockEndWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_end_width);
}

static const JSJitInfo borderBlockEndWidth_getterinfo = {
  { get_borderBlockEndWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBlockEndWidth_setterinfo = {
  { (JSJitGetterOp)set_borderBlockEndWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBlockStartWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_start_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBlockStartWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_start_width);
}

static const JSJitInfo borderBlockStartWidth_getterinfo = {
  { get_borderBlockStartWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBlockStartWidth_setterinfo = {
  { (JSJitGetterOp)set_borderBlockStartWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBottomWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_bottom_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBottomWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_bottom_width);
}

static const JSJitInfo borderBottomWidth_getterinfo = {
  { get_borderBottomWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBottomWidth_setterinfo = {
  { (JSJitGetterOp)set_borderBottomWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderInlineEndWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_end_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderInlineEndWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_end_width);
}

static const JSJitInfo borderInlineEndWidth_getterinfo = {
  { get_borderInlineEndWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderInlineEndWidth_setterinfo = {
  { (JSJitGetterOp)set_borderInlineEndWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderInlineStartWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_start_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderInlineStartWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_start_width);
}

static const JSJitInfo borderInlineStartWidth_getterinfo = {
  { get_borderInlineStartWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderInlineStartWidth_setterinfo = {
  { (JSJitGetterOp)set_borderInlineStartWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderLeftWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_left_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderLeftWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_left_width);
}

static const JSJitInfo borderLeftWidth_getterinfo = {
  { get_borderLeftWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderLeftWidth_setterinfo = {
  { (JSJitGetterOp)set_borderLeftWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderRightWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_right_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderRightWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_right_width);
}

static const JSJitInfo borderRightWidth_getterinfo = {
  { get_borderRightWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderRightWidth_setterinfo = {
  { (JSJitGetterOp)set_borderRightWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderTopWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_top_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderTopWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_top_width);
}

static const JSJitInfo borderTopWidth_getterinfo = {
  { get_borderTopWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderTopWidth_setterinfo = {
  { (JSJitGetterOp)set_borderTopWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_columnRuleWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_rule_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_columnRuleWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_rule_width);
}

static const JSJitInfo columnRuleWidth_getterinfo = {
  { get_columnRuleWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo columnRuleWidth_setterinfo = {
  { (JSJitGetterOp)set_columnRuleWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_outlineWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_outline_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_outlineWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_outline_width);
}

static const JSJitInfo outlineWidth_getterinfo = {
  { get_outlineWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo outlineWidth_setterinfo = {
  { (JSJitGetterOp)set_outlineWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozWindowInputRegionMargin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_window_input_region_margin);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozWindowInputRegionMargin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__moz_window_input_region_margin);
}

static const JSJitInfo MozWindowInputRegionMargin_getterinfo = {
  { get_MozWindowInputRegionMargin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozWindowInputRegionMargin_setterinfo = {
  { (JSJitGetterOp)set_MozWindowInputRegionMargin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_overflowClipMargin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow_clip_margin);
}

MOZ_CAN_RUN_SCRIPT static bool
set_overflowClipMargin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow_clip_margin);
}

static const JSJitInfo overflowClipMargin_getterinfo = {
  { get_overflowClipMargin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo overflowClipMargin_setterinfo = {
  { (JSJitGetterOp)set_overflowClipMargin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMarginBlockEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_block_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollMarginBlockEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_block_end);
}

static const JSJitInfo scrollMarginBlockEnd_getterinfo = {
  { get_scrollMarginBlockEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollMarginBlockEnd_setterinfo = {
  { (JSJitGetterOp)set_scrollMarginBlockEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMarginBlockStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_block_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollMarginBlockStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_block_start);
}

static const JSJitInfo scrollMarginBlockStart_getterinfo = {
  { get_scrollMarginBlockStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollMarginBlockStart_setterinfo = {
  { (JSJitGetterOp)set_scrollMarginBlockStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMarginBottom(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_bottom);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollMarginBottom(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_bottom);
}

static const JSJitInfo scrollMarginBottom_getterinfo = {
  { get_scrollMarginBottom },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollMarginBottom_setterinfo = {
  { (JSJitGetterOp)set_scrollMarginBottom },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMarginInlineEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_inline_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollMarginInlineEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_inline_end);
}

static const JSJitInfo scrollMarginInlineEnd_getterinfo = {
  { get_scrollMarginInlineEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollMarginInlineEnd_setterinfo = {
  { (JSJitGetterOp)set_scrollMarginInlineEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMarginInlineStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_inline_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollMarginInlineStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_inline_start);
}

static const JSJitInfo scrollMarginInlineStart_getterinfo = {
  { get_scrollMarginInlineStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollMarginInlineStart_setterinfo = {
  { (JSJitGetterOp)set_scrollMarginInlineStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMarginLeft(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_left);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollMarginLeft(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_left);
}

static const JSJitInfo scrollMarginLeft_getterinfo = {
  { get_scrollMarginLeft },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollMarginLeft_setterinfo = {
  { (JSJitGetterOp)set_scrollMarginLeft },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMarginRight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_right);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollMarginRight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_right);
}

static const JSJitInfo scrollMarginRight_getterinfo = {
  { get_scrollMarginRight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollMarginRight_setterinfo = {
  { (JSJitGetterOp)set_scrollMarginRight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMarginTop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_top);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollMarginTop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_top);
}

static const JSJitInfo scrollMarginTop_getterinfo = {
  { get_scrollMarginTop },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollMarginTop_setterinfo = {
  { (JSJitGetterOp)set_scrollMarginTop },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_paddingBlockEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_block_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_paddingBlockEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_block_end);
}

static const JSJitInfo paddingBlockEnd_getterinfo = {
  { get_paddingBlockEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo paddingBlockEnd_setterinfo = {
  { (JSJitGetterOp)set_paddingBlockEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_paddingBlockStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_block_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_paddingBlockStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_block_start);
}

static const JSJitInfo paddingBlockStart_getterinfo = {
  { get_paddingBlockStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo paddingBlockStart_setterinfo = {
  { (JSJitGetterOp)set_paddingBlockStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_paddingBottom(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_bottom);
}

MOZ_CAN_RUN_SCRIPT static bool
set_paddingBottom(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_bottom);
}

static const JSJitInfo paddingBottom_getterinfo = {
  { get_paddingBottom },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo paddingBottom_setterinfo = {
  { (JSJitGetterOp)set_paddingBottom },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_paddingInlineEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_inline_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_paddingInlineEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_inline_end);
}

static const JSJitInfo paddingInlineEnd_getterinfo = {
  { get_paddingInlineEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo paddingInlineEnd_setterinfo = {
  { (JSJitGetterOp)set_paddingInlineEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_paddingInlineStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_inline_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_paddingInlineStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_inline_start);
}

static const JSJitInfo paddingInlineStart_getterinfo = {
  { get_paddingInlineStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo paddingInlineStart_setterinfo = {
  { (JSJitGetterOp)set_paddingInlineStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_paddingLeft(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_left);
}

MOZ_CAN_RUN_SCRIPT static bool
set_paddingLeft(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_left);
}

static const JSJitInfo paddingLeft_getterinfo = {
  { get_paddingLeft },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo paddingLeft_setterinfo = {
  { (JSJitGetterOp)set_paddingLeft },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_paddingRight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_right);
}

MOZ_CAN_RUN_SCRIPT static bool
set_paddingRight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_right);
}

static const JSJitInfo paddingRight_getterinfo = {
  { get_paddingRight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo paddingRight_setterinfo = {
  { (JSJitGetterOp)set_paddingRight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_paddingTop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_top);
}

MOZ_CAN_RUN_SCRIPT static bool
set_paddingTop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_top);
}

static const JSJitInfo paddingTop_getterinfo = {
  { get_paddingTop },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo paddingTop_setterinfo = {
  { (JSJitGetterOp)set_paddingTop },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_r(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_r);
}

MOZ_CAN_RUN_SCRIPT static bool
set_r(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_r);
}

static const JSJitInfo r_getterinfo = {
  { get_r },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo r_setterinfo = {
  { (JSJitGetterOp)set_r },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_shapeMargin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_shape_margin);
}

MOZ_CAN_RUN_SCRIPT static bool
set_shapeMargin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_shape_margin);
}

static const JSJitInfo shapeMargin_getterinfo = {
  { get_shapeMargin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo shapeMargin_setterinfo = {
  { (JSJitGetterOp)set_shapeMargin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_rx(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_rx);
}

MOZ_CAN_RUN_SCRIPT static bool
set_rx(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_rx);
}

static const JSJitInfo rx_getterinfo = {
  { get_rx },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo rx_setterinfo = {
  { (JSJitGetterOp)set_rx },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ry(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_ry);
}

MOZ_CAN_RUN_SCRIPT static bool
set_ry(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_ry);
}

static const JSJitInfo ry_getterinfo = {
  { get_ry },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ry_setterinfo = {
  { (JSJitGetterOp)set_ry },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollPaddingBlockEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_block_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollPaddingBlockEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_block_end);
}

static const JSJitInfo scrollPaddingBlockEnd_getterinfo = {
  { get_scrollPaddingBlockEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollPaddingBlockEnd_setterinfo = {
  { (JSJitGetterOp)set_scrollPaddingBlockEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollPaddingBlockStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_block_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollPaddingBlockStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_block_start);
}

static const JSJitInfo scrollPaddingBlockStart_getterinfo = {
  { get_scrollPaddingBlockStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollPaddingBlockStart_setterinfo = {
  { (JSJitGetterOp)set_scrollPaddingBlockStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollPaddingBottom(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_bottom);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollPaddingBottom(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_bottom);
}

static const JSJitInfo scrollPaddingBottom_getterinfo = {
  { get_scrollPaddingBottom },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollPaddingBottom_setterinfo = {
  { (JSJitGetterOp)set_scrollPaddingBottom },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollPaddingInlineEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_inline_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollPaddingInlineEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_inline_end);
}

static const JSJitInfo scrollPaddingInlineEnd_getterinfo = {
  { get_scrollPaddingInlineEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollPaddingInlineEnd_setterinfo = {
  { (JSJitGetterOp)set_scrollPaddingInlineEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollPaddingInlineStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_inline_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollPaddingInlineStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_inline_start);
}

static const JSJitInfo scrollPaddingInlineStart_getterinfo = {
  { get_scrollPaddingInlineStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollPaddingInlineStart_setterinfo = {
  { (JSJitGetterOp)set_scrollPaddingInlineStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollPaddingLeft(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_left);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollPaddingLeft(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_left);
}

static const JSJitInfo scrollPaddingLeft_getterinfo = {
  { get_scrollPaddingLeft },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollPaddingLeft_setterinfo = {
  { (JSJitGetterOp)set_scrollPaddingLeft },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollPaddingRight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_right);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollPaddingRight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_right);
}

static const JSJitInfo scrollPaddingRight_getterinfo = {
  { get_scrollPaddingRight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollPaddingRight_setterinfo = {
  { (JSJitGetterOp)set_scrollPaddingRight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollPaddingTop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_top);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollPaddingTop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_top);
}

static const JSJitInfo scrollPaddingTop_getterinfo = {
  { get_scrollPaddingTop },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollPaddingTop_setterinfo = {
  { (JSJitGetterOp)set_scrollPaddingTop },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_backgroundColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_backgroundColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_color);
}

static const JSJitInfo backgroundColor_getterinfo = {
  { get_backgroundColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo backgroundColor_setterinfo = {
  { (JSJitGetterOp)set_backgroundColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBlockEndColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_end_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBlockEndColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_end_color);
}

static const JSJitInfo borderBlockEndColor_getterinfo = {
  { get_borderBlockEndColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBlockEndColor_setterinfo = {
  { (JSJitGetterOp)set_borderBlockEndColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBlockStartColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_start_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBlockStartColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_start_color);
}

static const JSJitInfo borderBlockStartColor_getterinfo = {
  { get_borderBlockStartColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBlockStartColor_setterinfo = {
  { (JSJitGetterOp)set_borderBlockStartColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBottomColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_bottom_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBottomColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_bottom_color);
}

static const JSJitInfo borderBottomColor_getterinfo = {
  { get_borderBottomColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBottomColor_setterinfo = {
  { (JSJitGetterOp)set_borderBottomColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderInlineEndColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_end_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderInlineEndColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_end_color);
}

static const JSJitInfo borderInlineEndColor_getterinfo = {
  { get_borderInlineEndColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderInlineEndColor_setterinfo = {
  { (JSJitGetterOp)set_borderInlineEndColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderInlineStartColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_start_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderInlineStartColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_start_color);
}

static const JSJitInfo borderInlineStartColor_getterinfo = {
  { get_borderInlineStartColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderInlineStartColor_setterinfo = {
  { (JSJitGetterOp)set_borderInlineStartColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderLeftColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_left_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderLeftColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_left_color);
}

static const JSJitInfo borderLeftColor_getterinfo = {
  { get_borderLeftColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderLeftColor_setterinfo = {
  { (JSJitGetterOp)set_borderLeftColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderRightColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_right_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderRightColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_right_color);
}

static const JSJitInfo borderRightColor_getterinfo = {
  { get_borderRightColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderRightColor_setterinfo = {
  { (JSJitGetterOp)set_borderRightColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderTopColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_top_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderTopColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_top_color);
}

static const JSJitInfo borderTopColor_getterinfo = {
  { get_borderTopColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderTopColor_setterinfo = {
  { (JSJitGetterOp)set_borderTopColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_columnRuleColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_rule_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_columnRuleColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_rule_color);
}

static const JSJitInfo columnRuleColor_getterinfo = {
  { get_columnRuleColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo columnRuleColor_setterinfo = {
  { (JSJitGetterOp)set_columnRuleColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_floodColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_flood_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_floodColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_flood_color);
}

static const JSJitInfo floodColor_getterinfo = {
  { get_floodColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo floodColor_setterinfo = {
  { (JSJitGetterOp)set_floodColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_lightingColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_lighting_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_lightingColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_lighting_color);
}

static const JSJitInfo lightingColor_getterinfo = {
  { get_lightingColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo lightingColor_setterinfo = {
  { (JSJitGetterOp)set_lightingColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_outlineColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_outline_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_outlineColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_outline_color);
}

static const JSJitInfo outlineColor_getterinfo = {
  { get_outlineColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo outlineColor_setterinfo = {
  { (JSJitGetterOp)set_outlineColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_stopColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_stop_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_stopColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_stop_color);
}

static const JSJitInfo stopColor_getterinfo = {
  { get_stopColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo stopColor_setterinfo = {
  { (JSJitGetterOp)set_stopColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textDecorationColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_decoration_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textDecorationColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_decoration_color);
}

static const JSJitInfo textDecorationColor_getterinfo = {
  { get_textDecorationColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textDecorationColor_setterinfo = {
  { (JSJitGetterOp)set_textDecorationColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textEmphasisColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_emphasis_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textEmphasisColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_emphasis_color);
}

static const JSJitInfo textEmphasisColor_getterinfo = {
  { get_textEmphasisColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textEmphasisColor_setterinfo = {
  { (JSJitGetterOp)set_textEmphasisColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_webkitTextFillColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__webkit_text_fill_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_webkitTextFillColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__webkit_text_fill_color);
}

static const JSJitInfo webkitTextFillColor_getterinfo = {
  { get_webkitTextFillColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo webkitTextFillColor_setterinfo = {
  { (JSJitGetterOp)set_webkitTextFillColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_webkitTextStrokeColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__webkit_text_stroke_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_webkitTextStrokeColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__webkit_text_stroke_color);
}

static const JSJitInfo webkitTextStrokeColor_getterinfo = {
  { get_webkitTextStrokeColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo webkitTextStrokeColor_setterinfo = {
  { (JSJitGetterOp)set_webkitTextStrokeColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_background(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_background);
}

MOZ_CAN_RUN_SCRIPT static bool
set_background(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_background);
}

static const JSJitInfo background_getterinfo = {
  { get_background },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo background_setterinfo = {
  { (JSJitGetterOp)set_background },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_backgroundPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_position);
}

MOZ_CAN_RUN_SCRIPT static bool
set_backgroundPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_background_position);
}

static const JSJitInfo backgroundPosition_getterinfo = {
  { get_backgroundPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo backgroundPosition_setterinfo = {
  { (JSJitGetterOp)set_backgroundPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_color);
}

static const JSJitInfo borderColor_getterinfo = {
  { get_borderColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderColor_setterinfo = {
  { (JSJitGetterOp)set_borderColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_style);
}

static const JSJitInfo borderStyle_getterinfo = {
  { get_borderStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderStyle_setterinfo = {
  { (JSJitGetterOp)set_borderStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_width);
}

static const JSJitInfo borderWidth_getterinfo = {
  { get_borderWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderWidth_setterinfo = {
  { (JSJitGetterOp)set_borderWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderTop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_top);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderTop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_top);
}

static const JSJitInfo borderTop_getterinfo = {
  { get_borderTop },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderTop_setterinfo = {
  { (JSJitGetterOp)set_borderTop },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderRight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_right);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderRight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_right);
}

static const JSJitInfo borderRight_getterinfo = {
  { get_borderRight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderRight_setterinfo = {
  { (JSJitGetterOp)set_borderRight },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBottom(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_bottom);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBottom(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_bottom);
}

static const JSJitInfo borderBottom_getterinfo = {
  { get_borderBottom },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBottom_setterinfo = {
  { (JSJitGetterOp)set_borderBottom },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderLeft(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_left);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderLeft(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_left);
}

static const JSJitInfo borderLeft_getterinfo = {
  { get_borderLeft },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderLeft_setterinfo = {
  { (JSJitGetterOp)set_borderLeft },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBlockStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBlockStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_start);
}

static const JSJitInfo borderBlockStart_getterinfo = {
  { get_borderBlockStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBlockStart_setterinfo = {
  { (JSJitGetterOp)set_borderBlockStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBlockEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBlockEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_end);
}

static const JSJitInfo borderBlockEnd_getterinfo = {
  { get_borderBlockEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBlockEnd_setterinfo = {
  { (JSJitGetterOp)set_borderBlockEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderInlineStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_start);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderInlineStart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_start);
}

static const JSJitInfo borderInlineStart_getterinfo = {
  { get_borderInlineStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderInlineStart_setterinfo = {
  { (JSJitGetterOp)set_borderInlineStart },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderInlineEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_end);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderInlineEnd(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_end);
}

static const JSJitInfo borderInlineEnd_getterinfo = {
  { get_borderInlineEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderInlineEnd_setterinfo = {
  { (JSJitGetterOp)set_borderInlineEnd },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_border(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border);
}

MOZ_CAN_RUN_SCRIPT static bool
set_border(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border);
}

static const JSJitInfo border_getterinfo = {
  { get_border },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo border_setterinfo = {
  { (JSJitGetterOp)set_border },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_radius);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderRadius(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_radius);
}

static const JSJitInfo borderRadius_getterinfo = {
  { get_borderRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderRadius_setterinfo = {
  { (JSJitGetterOp)set_borderRadius },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderImage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_image);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderImage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_image);
}

static const JSJitInfo borderImage_getterinfo = {
  { get_borderImage },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderImage_setterinfo = {
  { (JSJitGetterOp)set_borderImage },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBlockWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBlockWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_width);
}

static const JSJitInfo borderBlockWidth_getterinfo = {
  { get_borderBlockWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBlockWidth_setterinfo = {
  { (JSJitGetterOp)set_borderBlockWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBlockStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBlockStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_style);
}

static const JSJitInfo borderBlockStyle_getterinfo = {
  { get_borderBlockStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBlockStyle_setterinfo = {
  { (JSJitGetterOp)set_borderBlockStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBlockColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBlockColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block_color);
}

static const JSJitInfo borderBlockColor_getterinfo = {
  { get_borderBlockColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBlockColor_setterinfo = {
  { (JSJitGetterOp)set_borderBlockColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderInlineWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_width);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderInlineWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_width);
}

static const JSJitInfo borderInlineWidth_getterinfo = {
  { get_borderInlineWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderInlineWidth_setterinfo = {
  { (JSJitGetterOp)set_borderInlineWidth },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderInlineStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderInlineStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_style);
}

static const JSJitInfo borderInlineStyle_getterinfo = {
  { get_borderInlineStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderInlineStyle_setterinfo = {
  { (JSJitGetterOp)set_borderInlineStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderInlineColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_color);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderInlineColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline_color);
}

static const JSJitInfo borderInlineColor_getterinfo = {
  { get_borderInlineColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderInlineColor_setterinfo = {
  { (JSJitGetterOp)set_borderInlineColor },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_block);
}

static const JSJitInfo borderBlock_getterinfo = {
  { get_borderBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderBlock_setterinfo = {
  { (JSJitGetterOp)set_borderBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_borderInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline);
}

MOZ_CAN_RUN_SCRIPT static bool
set_borderInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_border_inline);
}

static const JSJitInfo borderInline_getterinfo = {
  { get_borderInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo borderInline_setterinfo = {
  { (JSJitGetterOp)set_borderInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_overflow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow);
}

MOZ_CAN_RUN_SCRIPT static bool
set_overflow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_overflow);
}

static const JSJitInfo overflow_getterinfo = {
  { get_overflow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo overflow_setterinfo = {
  { (JSJitGetterOp)set_overflow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_overscrollBehavior(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_overscroll_behavior);
}

MOZ_CAN_RUN_SCRIPT static bool
set_overscrollBehavior(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_overscroll_behavior);
}

static const JSJitInfo overscrollBehavior_getterinfo = {
  { get_overscrollBehavior },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo overscrollBehavior_setterinfo = {
  { (JSJitGetterOp)set_overscrollBehavior },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_container(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_container);
}

MOZ_CAN_RUN_SCRIPT static bool
set_container(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_container);
}

static const JSJitInfo container_getterinfo = {
  { get_container },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo container_setterinfo = {
  { (JSJitGetterOp)set_container },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_pageBreakBefore(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_page_break_before);
}

MOZ_CAN_RUN_SCRIPT static bool
set_pageBreakBefore(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_page_break_before);
}

static const JSJitInfo pageBreakBefore_getterinfo = {
  { get_pageBreakBefore },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo pageBreakBefore_setterinfo = {
  { (JSJitGetterOp)set_pageBreakBefore },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_pageBreakAfter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_page_break_after);
}

MOZ_CAN_RUN_SCRIPT static bool
set_pageBreakAfter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_page_break_after);
}

static const JSJitInfo pageBreakAfter_getterinfo = {
  { get_pageBreakAfter },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo pageBreakAfter_setterinfo = {
  { (JSJitGetterOp)set_pageBreakAfter },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_pageBreakInside(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_page_break_inside);
}

MOZ_CAN_RUN_SCRIPT static bool
set_pageBreakInside(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_page_break_inside);
}

static const JSJitInfo pageBreakInside_getterinfo = {
  { get_pageBreakInside },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo pageBreakInside_setterinfo = {
  { (JSJitGetterOp)set_pageBreakInside },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_offset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_offset);
}

MOZ_CAN_RUN_SCRIPT static bool
set_offset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_offset);
}

static const JSJitInfo offset_getterinfo = {
  { get_offset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo offset_setterinfo = {
  { (JSJitGetterOp)set_offset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_columns(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_columns);
}

MOZ_CAN_RUN_SCRIPT static bool
set_columns(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_columns);
}

static const JSJitInfo columns_getterinfo = {
  { get_columns },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo columns_setterinfo = {
  { (JSJitGetterOp)set_columns },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_columnRule(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_rule);
}

MOZ_CAN_RUN_SCRIPT static bool
set_columnRule(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_column_rule);
}

static const JSJitInfo columnRule_getterinfo = {
  { get_columnRule },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo columnRule_setterinfo = {
  { (JSJitGetterOp)set_columnRule },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_font(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font);
}

MOZ_CAN_RUN_SCRIPT static bool
set_font(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font);
}

static const JSJitInfo font_getterinfo = {
  { get_font },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo font_setterinfo = {
  { (JSJitGetterOp)set_font },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontVariant(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontVariant(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_variant);
}

static const JSJitInfo fontVariant_getterinfo = {
  { get_fontVariant },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontVariant_setterinfo = {
  { (JSJitGetterOp)set_fontVariant },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontSynthesis(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_synthesis);
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontSynthesis(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_font_synthesis);
}

static const JSJitInfo fontSynthesis_getterinfo = {
  { get_fontSynthesis },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontSynthesis_setterinfo = {
  { (JSJitGetterOp)set_fontSynthesis },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_marker(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_marker);
}

MOZ_CAN_RUN_SCRIPT static bool
set_marker(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_marker);
}

static const JSJitInfo marker_getterinfo = {
  { get_marker },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo marker_setterinfo = {
  { (JSJitGetterOp)set_marker },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textEmphasis(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_emphasis);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textEmphasis(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_emphasis);
}

static const JSJitInfo textEmphasis_getterinfo = {
  { get_textEmphasis },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textEmphasis_setterinfo = {
  { (JSJitGetterOp)set_textEmphasis },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textWrap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_wrap);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textWrap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_wrap);
}

static const JSJitInfo textWrap_getterinfo = {
  { get_textWrap },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textWrap_setterinfo = {
  { (JSJitGetterOp)set_textWrap },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_whiteSpace(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_white_space);
}

MOZ_CAN_RUN_SCRIPT static bool
set_whiteSpace(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_white_space);
}

static const JSJitInfo whiteSpace_getterinfo = {
  { get_whiteSpace },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo whiteSpace_setterinfo = {
  { (JSJitGetterOp)set_whiteSpace },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_webkitTextStroke(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty__webkit_text_stroke);
}

MOZ_CAN_RUN_SCRIPT static bool
set_webkitTextStroke(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty__webkit_text_stroke);
}

static const JSJitInfo webkitTextStroke_getterinfo = {
  { get_webkitTextStroke },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo webkitTextStroke_setterinfo = {
  { (JSJitGetterOp)set_webkitTextStroke },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_listStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_list_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_listStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_list_style);
}

static const JSJitInfo listStyle_getterinfo = {
  { get_listStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo listStyle_setterinfo = {
  { (JSJitGetterOp)set_listStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_margin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin);
}

MOZ_CAN_RUN_SCRIPT static bool
set_margin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin);
}

static const JSJitInfo margin_getterinfo = {
  { get_margin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo margin_setterinfo = {
  { (JSJitGetterOp)set_margin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_marginBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_block);
}

MOZ_CAN_RUN_SCRIPT static bool
set_marginBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_block);
}

static const JSJitInfo marginBlock_getterinfo = {
  { get_marginBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo marginBlock_setterinfo = {
  { (JSJitGetterOp)set_marginBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_marginInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_inline);
}

MOZ_CAN_RUN_SCRIPT static bool
set_marginInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_margin_inline);
}

static const JSJitInfo marginInline_getterinfo = {
  { get_marginInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo marginInline_setterinfo = {
  { (JSJitGetterOp)set_marginInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMargin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollMargin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin);
}

static const JSJitInfo scrollMargin_getterinfo = {
  { get_scrollMargin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollMargin_setterinfo = {
  { (JSJitGetterOp)set_scrollMargin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMarginBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_block);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollMarginBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_block);
}

static const JSJitInfo scrollMarginBlock_getterinfo = {
  { get_scrollMarginBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollMarginBlock_setterinfo = {
  { (JSJitGetterOp)set_scrollMarginBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMarginInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_inline);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollMarginInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_margin_inline);
}

static const JSJitInfo scrollMarginInline_getterinfo = {
  { get_scrollMarginInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollMarginInline_setterinfo = {
  { (JSJitGetterOp)set_scrollMarginInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_outline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_outline);
}

MOZ_CAN_RUN_SCRIPT static bool
set_outline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_outline);
}

static const JSJitInfo outline_getterinfo = {
  { get_outline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo outline_setterinfo = {
  { (JSJitGetterOp)set_outline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_padding(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding);
}

MOZ_CAN_RUN_SCRIPT static bool
set_padding(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding);
}

static const JSJitInfo padding_getterinfo = {
  { get_padding },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo padding_setterinfo = {
  { (JSJitGetterOp)set_padding },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_paddingBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_block);
}

MOZ_CAN_RUN_SCRIPT static bool
set_paddingBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_block);
}

static const JSJitInfo paddingBlock_getterinfo = {
  { get_paddingBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo paddingBlock_setterinfo = {
  { (JSJitGetterOp)set_paddingBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_paddingInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_inline);
}

MOZ_CAN_RUN_SCRIPT static bool
set_paddingInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_padding_inline);
}

static const JSJitInfo paddingInline_getterinfo = {
  { get_paddingInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo paddingInline_setterinfo = {
  { (JSJitGetterOp)set_paddingInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollPadding(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollPadding(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding);
}

static const JSJitInfo scrollPadding_getterinfo = {
  { get_scrollPadding },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollPadding_setterinfo = {
  { (JSJitGetterOp)set_scrollPadding },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollPaddingBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_block);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollPaddingBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_block);
}

static const JSJitInfo scrollPaddingBlock_getterinfo = {
  { get_scrollPaddingBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollPaddingBlock_setterinfo = {
  { (JSJitGetterOp)set_scrollPaddingBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollPaddingInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_inline);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollPaddingInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_padding_inline);
}

static const JSJitInfo scrollPaddingInline_getterinfo = {
  { get_scrollPaddingInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollPaddingInline_setterinfo = {
  { (JSJitGetterOp)set_scrollPaddingInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_flexFlow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_flex_flow);
}

MOZ_CAN_RUN_SCRIPT static bool
set_flexFlow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_flex_flow);
}

static const JSJitInfo flexFlow_getterinfo = {
  { get_flexFlow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo flexFlow_setterinfo = {
  { (JSJitGetterOp)set_flexFlow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_flex(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_flex);
}

MOZ_CAN_RUN_SCRIPT static bool
set_flex(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_flex);
}

static const JSJitInfo flex_getterinfo = {
  { get_flex },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo flex_setterinfo = {
  { (JSJitGetterOp)set_flex },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_gap);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_gap);
}

static const JSJitInfo gap_getterinfo = {
  { get_gap },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gap_setterinfo = {
  { (JSJitGetterOp)set_gap },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gridRow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_row);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gridRow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_row);
}

static const JSJitInfo gridRow_getterinfo = {
  { get_gridRow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gridRow_setterinfo = {
  { (JSJitGetterOp)set_gridRow },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gridColumn(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_column);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gridColumn(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_column);
}

static const JSJitInfo gridColumn_getterinfo = {
  { get_gridColumn },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gridColumn_setterinfo = {
  { (JSJitGetterOp)set_gridColumn },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gridArea(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_area);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gridArea(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_area);
}

static const JSJitInfo gridArea_getterinfo = {
  { get_gridArea },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gridArea_setterinfo = {
  { (JSJitGetterOp)set_gridArea },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_gridTemplate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_template);
}

MOZ_CAN_RUN_SCRIPT static bool
set_gridTemplate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid_template);
}

static const JSJitInfo gridTemplate_getterinfo = {
  { get_gridTemplate },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo gridTemplate_setterinfo = {
  { (JSJitGetterOp)set_gridTemplate },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_grid(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid);
}

MOZ_CAN_RUN_SCRIPT static bool
set_grid(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_grid);
}

static const JSJitInfo grid_getterinfo = {
  { get_grid },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo grid_setterinfo = {
  { (JSJitGetterOp)set_grid },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_placeContent(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_place_content);
}

MOZ_CAN_RUN_SCRIPT static bool
set_placeContent(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_place_content);
}

static const JSJitInfo placeContent_getterinfo = {
  { get_placeContent },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo placeContent_setterinfo = {
  { (JSJitGetterOp)set_placeContent },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_placeSelf(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_place_self);
}

MOZ_CAN_RUN_SCRIPT static bool
set_placeSelf(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_place_self);
}

static const JSJitInfo placeSelf_getterinfo = {
  { get_placeSelf },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo placeSelf_setterinfo = {
  { (JSJitGetterOp)set_placeSelf },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_placeItems(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_place_items);
}

MOZ_CAN_RUN_SCRIPT static bool
set_placeItems(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_place_items);
}

static const JSJitInfo placeItems_getterinfo = {
  { get_placeItems },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo placeItems_setterinfo = {
  { (JSJitGetterOp)set_placeItems },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_positionTry(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_position_try);
}

MOZ_CAN_RUN_SCRIPT static bool
set_positionTry(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_position_try);
}

static const JSJitInfo positionTry_getterinfo = {
  { get_positionTry },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo positionTry_setterinfo = {
  { (JSJitGetterOp)set_positionTry },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_inset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_inset);
}

MOZ_CAN_RUN_SCRIPT static bool
set_inset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_inset);
}

static const JSJitInfo inset_getterinfo = {
  { get_inset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo inset_setterinfo = {
  { (JSJitGetterOp)set_inset },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_insetBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_inset_block);
}

MOZ_CAN_RUN_SCRIPT static bool
set_insetBlock(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_inset_block);
}

static const JSJitInfo insetBlock_getterinfo = {
  { get_insetBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo insetBlock_setterinfo = {
  { (JSJitGetterOp)set_insetBlock },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_insetInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_inset_inline);
}

MOZ_CAN_RUN_SCRIPT static bool
set_insetInline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_inset_inline);
}

static const JSJitInfo insetInline_getterinfo = {
  { get_insetInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo insetInline_setterinfo = {
  { (JSJitGetterOp)set_insetInline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_containIntrinsicSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_contain_intrinsic_size);
}

MOZ_CAN_RUN_SCRIPT static bool
set_containIntrinsicSize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_contain_intrinsic_size);
}

static const JSJitInfo containIntrinsicSize_getterinfo = {
  { get_containIntrinsicSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo containIntrinsicSize_setterinfo = {
  { (JSJitGetterOp)set_containIntrinsicSize },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_mask(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask);
}

MOZ_CAN_RUN_SCRIPT static bool
set_mask(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask);
}

static const JSJitInfo mask_getterinfo = {
  { get_mask },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo mask_setterinfo = {
  { (JSJitGetterOp)set_mask },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_maskPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_position);
}

MOZ_CAN_RUN_SCRIPT static bool
set_maskPosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_mask_position);
}

static const JSJitInfo maskPosition_getterinfo = {
  { get_maskPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo maskPosition_setterinfo = {
  { (JSJitGetterOp)set_maskPosition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textDecoration(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_decoration);
}

MOZ_CAN_RUN_SCRIPT static bool
set_textDecoration(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_text_decoration);
}

static const JSJitInfo textDecoration_getterinfo = {
  { get_textDecoration },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textDecoration_setterinfo = {
  { (JSJitGetterOp)set_textDecoration },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_transition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_transition);
}

MOZ_CAN_RUN_SCRIPT static bool
set_transition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_transition);
}

static const JSJitInfo transition_getterinfo = {
  { get_transition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo transition_setterinfo = {
  { (JSJitGetterOp)set_transition },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_animation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation);
}

MOZ_CAN_RUN_SCRIPT static bool
set_animation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_animation);
}

static const JSJitInfo animation_getterinfo = {
  { get_animation },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo animation_setterinfo = {
  { (JSJitGetterOp)set_animation },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollTimeline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_timeline);
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollTimeline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_scroll_timeline);
}

static const JSJitInfo scrollTimeline_getterinfo = {
  { get_scrollTimeline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollTimeline_setterinfo = {
  { (JSJitGetterOp)set_scrollTimeline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_viewTimeline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_view_timeline);
}

MOZ_CAN_RUN_SCRIPT static bool
set_viewTimeline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_view_timeline);
}

static const JSJitInfo viewTimeline_getterinfo = {
  { get_viewTimeline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo viewTimeline_setterinfo = {
  { (JSJitGetterOp)set_viewTimeline },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_all(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_all);
}

MOZ_CAN_RUN_SCRIPT static bool
set_all(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_all);
}

static const JSJitInfo all_getterinfo = {
  { get_all },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo all_setterinfo = {
  { (JSJitGetterOp)set_all },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozTransform(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_transform);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozTransform(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_transform);
}

static const JSJitInfo MozTransform_getterinfo = {
  { get_MozTransform },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozTransform_setterinfo = {
  { (JSJitGetterOp)set_MozTransform },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozPerspective(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_perspective);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozPerspective(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_perspective);
}

static const JSJitInfo MozPerspective_getterinfo = {
  { get_MozPerspective },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozPerspective_setterinfo = {
  { (JSJitGetterOp)set_MozPerspective },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozPerspectiveOrigin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_perspective_origin);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozPerspectiveOrigin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_perspective_origin);
}

static const JSJitInfo MozPerspectiveOrigin_getterinfo = {
  { get_MozPerspectiveOrigin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozPerspectiveOrigin_setterinfo = {
  { (JSJitGetterOp)set_MozPerspectiveOrigin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozBackfaceVisibility(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_backface_visibility);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozBackfaceVisibility(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_backface_visibility);
}

static const JSJitInfo MozBackfaceVisibility_getterinfo = {
  { get_MozBackfaceVisibility },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozBackfaceVisibility_setterinfo = {
  { (JSJitGetterOp)set_MozBackfaceVisibility },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozTransformStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_transform_style);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozTransformStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_transform_style);
}

static const JSJitInfo MozTransformStyle_getterinfo = {
  { get_MozTransformStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozTransformStyle_setterinfo = {
  { (JSJitGetterOp)set_MozTransformStyle },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_MozTransformOrigin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  return CSSStyleProperties_Binding::GetPropertyValue(cx, obj, void_self, args, eCSSProperty_transform_origin);
}

MOZ_CAN_RUN_SCRIPT static bool
set_MozTransformOrigin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  return CSSStyleProperties_Binding::SetPropertyValue(cx, obj, void_self, args, eCSSProperty_transform_origin);
}

static const JSJitInfo MozTransformOrigin_getterinfo = {
  { get_MozTransformOrigin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo MozTransformOrigin_setterinfo = {
  { (JSJitGetterOp)set_MozTransformOrigin },
  { prototypes::id::CSSStyleProperties },
  { PrototypeTraits<prototypes::id::CSSStyleProperties>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* is