// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanPlacesMetrics_h
#define mozilla_GleanPlacesMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace bookmarks_sidebar {
  /**
   * generated from bookmarks_sidebar.cumulative_searches
   * Cumulative no. bookmark of searches performed before selecting a link.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram PLACES_BOOKMARKS_SEARCHBAR_CUMULATIVE_SEARCHES.
   */
  constexpr impl::CustomDistributionMetric cumulative_searches(652);
}

namespace bookmarks_toolbar {
  /**
   * generated from bookmarks_toolbar.init
   * Firefox: Time to initialize the bookmarks toolbar view (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_BOOKMARKS_TOOLBAR_INIT_MS.
   */
  constexpr impl::TimingDistributionMetric init(653);
}

namespace history_sidebar {
  /**
   * generated from history_sidebar.cumulative_filter_count
   * Cumulative no. of search filters applied performed before selecting a link.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram PLACES_SEARCHBAR_CUMULATIVE_FILTER_COUNT.
   */
  constexpr impl::CustomDistributionMetric cumulative_filter_count(654);

  /**
   * generated from history_sidebar.cumulative_searches
   * Cumulative no. of searches performed before selecting a link.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram PLACES_SEARCHBAR_CUMULATIVE_SEARCHES.
   */
  constexpr impl::CustomDistributionMetric cumulative_searches(655);

  /**
   * generated from history_sidebar.filter_type
   */
  enum class FilterTypeLabel: uint16_t {
    eVisited = 0,
    eLastvisited = 1,
    eDayandsite = 2,
    eSite = 3,
    eDay = 4,
    e__Other__,
  };
  /**
   * The type of search filters used for the sidebar search.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram PLACES_SEARCHBAR_FILTER_TYPE.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, FilterTypeLabel> filter_type(656);

  /**
   * generated from history_sidebar.lastvisited_tree_query_time
   * PLACES: Time to load the sidebar history tree sorted by last visit (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HISTORY_LASTVISITED_TREE_QUERY_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric lastvisited_tree_query_time(657);
}

namespace library {
  /**
   * generated from library.cumulative_bookmark_searches
   * Cumulative no. of Bookmark-specific searches performed before selecting a bookmark link in Library.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram PLACES_LIBRARY_CUMULATIVE_BOOKMARK_SEARCHES.
   */
  constexpr impl::CustomDistributionMetric cumulative_bookmark_searches(658);

  /**
   * generated from library.cumulative_history_searches
   * Cumulative no. of History-specific searches performed before selecting a History link in Library.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram PLACES_LIBRARY_CUMULATIVE_HISTORY_SEARCHES.
   */
  constexpr impl::CustomDistributionMetric cumulative_history_searches(659);

  /**
   * generated from library.history_search_time
   * PLACES: Time to search the history library (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_HISTORY_LIBRARY_SEARCH_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric history_search_time(660);

  /**
   * generated from library.link
   * The number of history or bookmark items opened from the Library window This metric was generated to correspond to the Legacy Telemetry scalar library.link.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> link(661);

  /**
   * generated from library.opened
   * The number of times the Library window was opened, keyed by 'history' or 'bookmarks' This metric was generated to correspond to the Legacy Telemetry scalar library.opened.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> opened(662);

  /**
   * generated from library.search
   * The number of history-specific or bookmark-specific searches made from the Library window This metric was generated to correspond to the Legacy Telemetry scalar library.search.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> search(663);
}

namespace page_icon {
  /**
   * generated from page_icon.fit_icon_count
   * Number of times the page-icon protocol serves an icon equal to or larger than requested.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fit_icon_count(5227);

  /**
   * generated from page_icon.small_icon_count
   * Number of times the page-icon protocol serves an icon smaller than requested.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> small_icon_count(5228);
}

namespace places {
  /**
   * generated from places.annos_pages_count
   * PLACES: Number of pages annotations
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_ANNOS_PAGES_COUNT.
   */
  constexpr impl::CustomDistributionMetric annos_pages_count(5229);

  /**
   * generated from places.backups_bookmarkstree
   * PLACES: Time to build the bookmarks tree
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_BACKUPS_BOOKMARKSTREE_MS.
   */
  constexpr impl::TimingDistributionMetric backups_bookmarkstree(5230);

  /**
   * generated from places.backups_daysfromlast
   * PLACES: Days from last backup
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram PLACES_BACKUPS_DAYSFROMLAST.
   */
  constexpr impl::TimingDistributionMetric backups_daysfromlast(5231);

  /**
   * generated from places.backups_tojson
   * PLACES: Time to convert and write the backup
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_BACKUPS_TOJSON_MS.
   */
  constexpr impl::TimingDistributionMetric backups_tojson(5232);

  /**
   * generated from places.bookmarks_count
   * PLACES: Number of bookmarks
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_BOOKMARKS_COUNT.
   */
  constexpr impl::CustomDistributionMetric bookmarks_count(5233);

  /**
   * generated from places.database_favicons_filesize
   * PLACES: Favicons database filesize (MB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_DATABASE_FAVICONS_FILESIZE_MB.
   */
  constexpr impl::MemoryDistributionMetric database_favicons_filesize(5234);

  /**
   * generated from places.database_filesize
   * PLACES: Database filesize (MB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_DATABASE_FILESIZE_MB.
   */
  constexpr impl::MemoryDistributionMetric database_filesize(5235);

  /**
   * generated from places.database_semantic_history_defragment_time
   * PLACES: Time to defragment the semantic database (ms)
   */
  constexpr impl::TimingDistributionMetric database_semantic_history_defragment_time(5236);

  /**
   * generated from places.database_semantic_history_filesize
   * PLACES: Semantic History database filesize (MB)
   */
  constexpr impl::MemoryDistributionMetric database_semantic_history_filesize(5237);

  /**
   * generated from places.database_semantic_history_wasted_percentage
   * PLACES: Semantic History database wasted space in percentage (0-100)
   */
  constexpr impl::QuantityMetric database_semantic_history_wasted_percentage(5238);

  /**
   * generated from places.expiration_steps_to_clean
   * PLACES: Expiration steps to cleanup the database
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram PLACES_EXPIRATION_STEPS_TO_CLEAN2.
   */
  constexpr impl::CustomDistributionMetric expiration_steps_to_clean(5239);

  /**
   * generated from places.export_tohtml
   * PLACES: Time to convert and write bookmarks.html
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_EXPORT_TOHTML_MS.
   */
  constexpr impl::TimingDistributionMetric export_tohtml(5240);

  /**
   * generated from places.frecency_recalc_chunk_time
   * PLACES: Time to recalculate frecency for a chunk of pages (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_FRECENCY_RECALC_CHUNK_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric frecency_recalc_chunk_time(5241);

  /**
   * generated from places.idle_frecency_decay_time
   * PLACES: Time to decay all frecencies values on idle (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_IDLE_FRECENCY_DECAY_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric idle_frecency_decay_time(5242);

  /**
   * generated from places.idle_maintenance_time
   * PLACES: Time to execute maintenance tasks on idle (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_IDLE_MAINTENANCE_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric idle_maintenance_time(5243);

  /**
   * generated from places.keywords_count
   * PLACES: Number of keywords
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_KEYWORDS_COUNT.
   */
  constexpr impl::CustomDistributionMetric keywords_count(5244);

  /**
   * generated from places.maintenance_daysfromlast
   * PLACES: Days from last maintenance
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_MAINTENANCE_DAYSFROMLAST.
   */
  constexpr impl::TimingDistributionMetric maintenance_daysfromlast(5245);

  /**
   * generated from places.most_recent_expired_visit
   * PLACES: the most recent expired visit in days
   * This metric was generated to correspond to the Legacy Telemetry linear histogram PLACES_MOST_RECENT_EXPIRED_VISIT_DAYS.
   */
  constexpr impl::TimingDistributionMetric most_recent_expired_visit(5246);

  /**
   * generated from places.pages_count
   * PLACES: Number of unique pages
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_PAGES_COUNT.
   */
  constexpr impl::CustomDistributionMetric pages_count(5247);

  /**
   * generated from places.pages_need_frecency_recalculation
   * Number of pages that need a frecency recalculation. This metric was generated to correspond to the Legacy Telemetry scalar places.pages_need_frecency_recalculation.
   */
  constexpr impl::QuantityMetric pages_need_frecency_recalculation(5248);

  /**
   * generated from places.places_database_corruption_handling_stage
   * PLACES - stage reached when trying to fix a database corruption, see Places::Database::eCorruptDBReplaceStage.
   */
  constexpr impl::Labeled<impl::StringMetric, DynamicLabel> places_database_corruption_handling_stage(5249);

  /**
   * generated from places.previousday_visits
   * Number of history entries for the previous day. This metric was generated to correspond to the Legacy Telemetry scalar places.previousday_visits.
   */
  constexpr impl::QuantityMetric previousday_visits(5250);

  /**
   * generated from places.semantic_history_chunk_calculate_time
   * Time to calculate a chunk of embeddings.
   */
  constexpr impl::TimingDistributionMetric semantic_history_chunk_calculate_time(5251);

  /**
   * generated from places.semantic_history_find_chunks_time
   * Time to find URLs to calculate embeddings for.
   */
  constexpr impl::TimingDistributionMetric semantic_history_find_chunks_time(5252);

  /**
   * generated from places.semantic_history_max_chunks_count
   * Max number of chunks of embeddings to calculate.
   */
  constexpr impl::QuantityMetric semantic_history_max_chunks_count(5253);

  /**
   * generated from places.sorted_bookmarks_perc
   * PLACES: Percentage of bookmarks organized in folders
   * This metric was generated to correspond to the Legacy Telemetry linear histogram PLACES_SORTED_BOOKMARKS_PERC.
   */
  constexpr impl::CustomDistributionMetric sorted_bookmarks_perc(5254);

  /**
   * generated from places.sponsored_visit_no_triggering_url
   * Number of sponsored visits that could not find their triggering URL in history. We expect this to be a small number just due to the navigation layer manipulating URLs. A large or growing value may be a concern. This metric was generated to correspond to the Legacy Telemetry scalar places.sponsored_visit_no_triggering_url.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> sponsored_visit_no_triggering_url(5255);

  /**
   * generated from places.tagged_bookmarks_perc
   * PLACES: Percentage of tagged bookmarks
   * This metric was generated to correspond to the Legacy Telemetry linear histogram PLACES_TAGGED_BOOKMARKS_PERC.
   */
  constexpr impl::CustomDistributionMetric tagged_bookmarks_perc(5256);

  /**
   * generated from places.tags_count
   * PLACES: Number of tags
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_TAGS_COUNT.
   */
  constexpr impl::CustomDistributionMetric tags_count(5257);
}

} // namespace mozilla::glean

#endif // mozilla_GleanPlacesMetrics_h
