// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomIndexedDBMetrics_h
#define mozilla_GleanDomIndexedDBMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace idb_maintenance {
  /**
   * generated from idb.maintenance.fallback_fullrestore_metadata
   * Tracks the number of times we need to fallback to restore metadata object by reading metadata-v2 file on disk when performing idle-maintenance on IDB database.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fallback_fullrestore_metadata(3662);

  /**
   * generated from idb.maintenance.metadata_restored
   * Counts the number of times we failed to load metadata object and had to restore it
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> metadata_restored(3663);

  /**
   * generated from idb.maintenance.unknown_metadata
   * Increments upon encountering an unknown metadata object when performing idle-maintenance on IDB database. During idle-maintenance, we iterate over idb directories/files and construct a metadata object by calling QuotaManager::GetOriginMetadata or LoadFullOriginMetadataWithRestore. It seems that in some cases, the metadata object we get here can be invalid and this metric is used to track those instances.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> unknown_metadata(3664);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomIndexedDBMetrics_h
