// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanNimbusMetrics_h
#define mozilla_GleanNimbusMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace heartbeat {
  /**
   * generated from heartbeat.closed
   * When the Heartbeat notification bar was closed.
   */
  constexpr impl::DatetimeMetric closed(4964);

  /**
   * generated from heartbeat.engaged
   * When the user clicked on the survey-provided button
   * (alternative to voting feature).
   */
  constexpr impl::DatetimeMetric engaged(4965);

  /**
   * generated from heartbeat.expired
   * When the survey expired, after 2 hours of no interaction.
   * (threshold regulated by `browser.uitour.surveyDuration` pref.)
   */
  constexpr impl::DatetimeMetric expired(4966);

  /**
   * generated from heartbeat.flow_id
   * An identifier for the rating flow, generated on the client.
   */
  constexpr impl::UuidMetric flow_id(4967);

  /**
   * generated from heartbeat.learn_more
   * When the user clicked on the "Learn More" link.
   */
  constexpr impl::DatetimeMetric learn_more(4968);

  /**
   * generated from heartbeat.offered
   * When the survey was shown to the user.
   */
  constexpr impl::DatetimeMetric offered(4969);

  /**
   * generated from heartbeat.score
   * The user's rating.
   */
  constexpr impl::QuantityMetric score(4970);

  /**
   * generated from heartbeat.survey_id
   * Identifies the specific survey.
   * May contain a `::` followed by the Normandy client id if the Heartbeat
   * recipe asks for it to be included.
   * e.g. "hb-out-of-date-en" or "new-user-survey-en-us::<the Normandy client id>"
   */
  constexpr impl::StringMetric survey_id(4971);

  /**
   * generated from heartbeat.voted
   * When the user voted.
   */
  constexpr impl::DatetimeMetric voted(4972);

  /**
   * generated from heartbeat.window_closed
   * When the user closed the Firefox window containing the survey,
   * or when the whole browser is shut down during the survey,
   * thus ending it.
   */
  constexpr impl::DatetimeMetric window_closed(4973);
}

namespace nimbus_events {
  /**
   * generated from nimbus_events.database_write
   */
  struct DatabaseWriteExtra {
    mozilla::Maybe<bool> success;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (success) {
        extraKeys.AppendElement()->AssignASCII("success");
        extraValues.AppendElement()->AssignASCII(success.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Emitted when writing to the NimbusEnrollments database table.
   */
  constexpr impl::EventMetric<DatabaseWriteExtra> database_write(4974);

  /**
   * generated from nimbus_events.enroll_failed
   */
  struct EnrollFailedExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> experiment;
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (experiment) {
        extraKeys.AppendElement()->AssignASCII("experiment");
        extraValues.EmplaceBack(experiment.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when an enrollment fails, including the reason for the failure.
   */
  constexpr impl::EventMetric<EnrollFailedExtra> enroll_failed(4975);

  /**
   * generated from nimbus_events.enrollment
   */
  struct EnrollmentExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> experiment;
    mozilla::Maybe<nsCString> experimentType;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (experiment) {
        extraKeys.AppendElement()->AssignASCII("experiment");
        extraValues.EmplaceBack(experiment.value());
      }
      if (experimentType) {
        extraKeys.AppendElement()->AssignASCII("experiment_type");
        extraValues.EmplaceBack(experimentType.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user has met the conditions and is first bucketed into an experiment (i.e. targeting matched and they were randomized into a bucket and branch of the experiment). Expected a maximum of once per experiment per user.
   */
  constexpr impl::EventMetric<EnrollmentExtra> enrollment(4976);

  /**
   * generated from nimbus_events.enrollment_status
   */
  struct EnrollmentStatusExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> conflictSlug;
    mozilla::Maybe<nsCString> errorString;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> slug;
    mozilla::Maybe<nsCString> status;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (conflictSlug) {
        extraKeys.AppendElement()->AssignASCII("conflict_slug");
        extraValues.EmplaceBack(conflictSlug.value());
      }
      if (errorString) {
        extraKeys.AppendElement()->AssignASCII("error_string");
        extraValues.EmplaceBack(errorString.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (slug) {
        extraKeys.AppendElement()->AssignASCII("slug");
        extraValues.EmplaceBack(slug.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded for each enrollment status each time the SDK completes application of pending experiments.
   */
  constexpr impl::EventMetric<EnrollmentStatusExtra> enrollment_status(4977);

  /**
   * generated from nimbus_events.exposure
   */
  struct ExposureExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> experiment;
    mozilla::Maybe<nsCString> featureId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (experiment) {
        extraKeys.AppendElement()->AssignASCII("experiment");
        extraValues.EmplaceBack(experiment.value());
      }
      if (featureId) {
        extraKeys.AppendElement()->AssignASCII("feature_id");
        extraValues.EmplaceBack(featureId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user actually observes an experimental treatment, or would have observed an experimental treatment if they had been in a branch that would have shown one.
   */
  constexpr impl::EventMetric<ExposureExtra> exposure(4978);

  /**
   * generated from nimbus_events.is_ready
   */
  /**
   * An event sent when Nimbus is ready — sent upon completion of each update of the recipes.
   */
  constexpr impl::EventMetric<NoExtraKeys> is_ready(4979);

  /**
   * generated from nimbus_events.migration
   */
  struct MigrationExtra {
    mozilla::Maybe<nsCString> enrollments;
    mozilla::Maybe<nsCString> errorReason;
    mozilla::Maybe<nsCString> migrationId;
    mozilla::Maybe<bool> success;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (enrollments) {
        extraKeys.AppendElement()->AssignASCII("enrollments");
        extraValues.EmplaceBack(enrollments.value());
      }
      if (errorReason) {
        extraKeys.AppendElement()->AssignASCII("error_reason");
        extraValues.EmplaceBack(errorReason.value());
      }
      if (migrationId) {
        extraKeys.AppendElement()->AssignASCII("migration_id");
        extraValues.EmplaceBack(migrationId.value());
      }
      if (success) {
        extraKeys.AppendElement()->AssignASCII("success");
        extraValues.AppendElement()->AssignASCII(success.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggered whenever a Nimbus migration is attempted, whether or not it succeeds.
   */
  constexpr impl::EventMetric<MigrationExtra> migration(4980);

  /**
   * generated from nimbus_events.remote_settings_sync_error
   */
  struct RemoteSettingsSyncErrorExtra {
    mozilla::Maybe<nsCString> collection;
    mozilla::Maybe<bool> forceSync;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> trigger;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (collection) {
        extraKeys.AppendElement()->AssignASCII("collection");
        extraValues.EmplaceBack(collection.value());
      }
      if (forceSync) {
        extraKeys.AppendElement()->AssignASCII("force_sync");
        extraValues.AppendElement()->AssignASCII(forceSync.value() ? "true" : "false");
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (trigger) {
        extraKeys.AppendElement()->AssignASCII("trigger");
        extraValues.EmplaceBack(trigger.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggered when Nimbus fails to get recipes from remote settings collections.
   */
  constexpr impl::EventMetric<RemoteSettingsSyncErrorExtra> remote_settings_sync_error(4981);

  /**
   * generated from nimbus_events.startup_database_consistency
   */
  struct StartupDatabaseConsistencyExtra {
    mozilla::Maybe<uint32_t> dbActiveCount;
    mozilla::Maybe<nsCString> primary;
    mozilla::Maybe<uint32_t> storeActiveCount;
    mozilla::Maybe<uint32_t> totalDbCount;
    mozilla::Maybe<uint32_t> totalStoreCount;
    mozilla::Maybe<nsCString> trigger;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (dbActiveCount) {
        extraKeys.AppendElement()->AssignASCII("db_active_count");
        extraValues.AppendElement()->AppendInt(dbActiveCount.value());
      }
      if (primary) {
        extraKeys.AppendElement()->AssignASCII("primary");
        extraValues.EmplaceBack(primary.value());
      }
      if (storeActiveCount) {
        extraKeys.AppendElement()->AssignASCII("store_active_count");
        extraValues.AppendElement()->AppendInt(storeActiveCount.value());
      }
      if (totalDbCount) {
        extraKeys.AppendElement()->AssignASCII("total_db_count");
        extraValues.AppendElement()->AppendInt(totalDbCount.value());
      }
      if (totalStoreCount) {
        extraKeys.AppendElement()->AssignASCII("total_store_count");
        extraValues.AppendElement()->AppendInt(totalStoreCount.value());
      }
      if (trigger) {
        extraKeys.AppendElement()->AssignASCII("trigger");
        extraValues.EmplaceBack(trigger.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Emitted during ExperimentManager startup with details about the ExperimentDataStore compared to the NimbusEnrollments database table.
   */
  constexpr impl::EventMetric<StartupDatabaseConsistencyExtra> startup_database_consistency(4982);

  /**
   * generated from nimbus_events.unenroll_failed
   */
  struct UnenrollFailedExtra {
    mozilla::Maybe<nsCString> experiment;
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (experiment) {
        extraKeys.AppendElement()->AssignASCII("experiment");
        extraValues.EmplaceBack(experiment.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when an unenrollment fails, including the reason for the failure.
   */
  constexpr impl::EventMetric<UnenrollFailedExtra> unenroll_failed(4983);

  /**
   * generated from nimbus_events.unenrollment
   */
  struct UnenrollmentExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> changedPref;
    mozilla::Maybe<nsCString> conflictingSlug;
    mozilla::Maybe<nsCString> experiment;
    mozilla::Maybe<nsCString> locale;
    mozilla::Maybe<nsCString> prefName;
    mozilla::Maybe<nsCString> prefType;
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (changedPref) {
        extraKeys.AppendElement()->AssignASCII("changed_pref");
        extraValues.EmplaceBack(changedPref.value());
      }
      if (conflictingSlug) {
        extraKeys.AppendElement()->AssignASCII("conflicting_slug");
        extraValues.EmplaceBack(conflictingSlug.value());
      }
      if (experiment) {
        extraKeys.AppendElement()->AssignASCII("experiment");
        extraValues.EmplaceBack(experiment.value());
      }
      if (locale) {
        extraKeys.AppendElement()->AssignASCII("locale");
        extraValues.EmplaceBack(locale.value());
      }
      if (prefName) {
        extraKeys.AppendElement()->AssignASCII("pref_name");
        extraValues.EmplaceBack(prefName.value());
      }
      if (prefType) {
        extraKeys.AppendElement()->AssignASCII("pref_type");
        extraValues.EmplaceBack(prefType.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when either telemetry is disabled, or the experiment has run for its designed duration (i.e. it is no longer present in the Nimbus Remote Settings collection)
   */
  constexpr impl::EventMetric<UnenrollmentExtra> unenrollment(4984);

  /**
   * generated from nimbus_events.validation_failed
   */
  struct ValidationFailedExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> experiment;
    mozilla::Maybe<nsCString> l10nIds;
    mozilla::Maybe<nsCString> locale;
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (experiment) {
        extraKeys.AppendElement()->AssignASCII("experiment");
        extraValues.EmplaceBack(experiment.value());
      }
      if (l10nIds) {
        extraKeys.AppendElement()->AssignASCII("l10n_ids");
        extraValues.EmplaceBack(l10nIds.value());
      }
      if (locale) {
        extraKeys.AppendElement()->AssignASCII("locale");
        extraValues.EmplaceBack(locale.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This records when validation of a recipe fails.
   */
  constexpr impl::EventMetric<ValidationFailedExtra> validation_failed(4985);
}

namespace nimbus_targeting_context {
  /**
   * generated from nimbus_targeting_context.active_experiments
   */
  using ActiveExperimentsObject = nsTArray<nsCString>;
  /**
   * The slugs of the actively enrolled experiments
   */
  constexpr impl::ObjectMetric<ActiveExperimentsObject, struct ActiveExperimentsObjectTag> active_experiments(4986);

  /**
   * generated from nimbus_targeting_context.active_rollouts
   */
  using ActiveRolloutsObject = nsTArray<nsCString>;
  /**
   * The slugs of the actively enrolled rollouts
   */
  constexpr impl::ObjectMetric<ActiveRolloutsObject, struct ActiveRolloutsObjectTag> active_rollouts(4987);

  /**
   * generated from nimbus_targeting_context.addons_info
   */
  using AddonsInfoObjectAddons = nsTArray<nsCString>;


  struct AddonsInfoObject {
    Maybe<AddonsInfoObjectAddons> addons;
    Maybe<bool> hasInstalledAddons;
  };
  /**
   * Information about installed addons.
   */
  constexpr impl::ObjectMetric<AddonsInfoObject, struct AddonsInfoObjectTag> addons_info(4988);

  /**
   * generated from nimbus_targeting_context.addresses_saved
   * The number of addresses the user has saved.
   */
  constexpr impl::QuantityMetric addresses_saved(4989);

  /**
   * generated from nimbus_targeting_context.arch_bits
   * The architecture of the user's CPU (32-bit or 64-bit)
   */
  constexpr impl::QuantityMetric arch_bits(4990);

  /**
   * generated from nimbus_targeting_context.attribution_data
   */

  struct AttributionDataObject {
    Maybe<nsCString> medium;
    Maybe<nsCString> source;
    Maybe<nsCString> ua;
  };
  /**
   * Attribution data.
   */
  constexpr impl::ObjectMetric<AttributionDataObject, struct AttributionDataObjectTag> attribution_data(4991);

  /**
   * generated from nimbus_targeting_context.browser_settings
   */

  struct BrowserSettingsObjectUpdate {
    Maybe<nsCString> channel;
  };


  struct BrowserSettingsObject {
    Maybe<BrowserSettingsObjectUpdate> update;
  };
  /**
   * Information about the browser's update channel.
   */
  constexpr impl::ObjectMetric<BrowserSettingsObject, struct BrowserSettingsObjectTag> browser_settings(4992);

  /**
   * generated from nimbus_targeting_context.build_id
   * The Build ID.
   */
  constexpr impl::QuantityMetric build_id(4993);

  /**
   * generated from nimbus_targeting_context.current_date
   * The current date, as an ISO-8601 string.
   */
  constexpr impl::StringMetric current_date(4994);

  /**
   * generated from nimbus_targeting_context.default_pdf_handler
   */

  struct DefaultPdfHandlerObject {
    Maybe<bool> knownBrowser;
    Maybe<bool> registered;
  };
  /**
   * Information about the system's default PDF handler.
   */
  constexpr impl::ObjectMetric<DefaultPdfHandlerObject, struct DefaultPdfHandlerObjectTag> default_pdf_handler(4995);

  /**
   * generated from nimbus_targeting_context.distribution_id
   * The installation's distribution ID.
   */
  constexpr impl::StringMetric distribution_id(4996);

  /**
   * generated from nimbus_targeting_context.does_app_need_pin
   * Does the app need pinning (i.e., is the app not pinned).
   */
  constexpr impl::BooleanMetric does_app_need_pin(4997);

  /**
   * generated from nimbus_targeting_context.enrollments_map
   */

  struct EnrollmentsMapObjectItem {
    Maybe<nsCString> experimentSlug;
    Maybe<nsCString> branchSlug;
  };

  using EnrollmentsMapObject = nsTArray<EnrollmentsMapObjectItem>;
  /**
   * Information about historic enrollments, including the branches enrolled.
   */
  constexpr impl::ObjectMetric<EnrollmentsMapObject, struct EnrollmentsMapObjectTag> enrollments_map(4998);

  /**
   * generated from nimbus_targeting_context.firefox_version
   * The Firefox major version number.
   */
  constexpr impl::QuantityMetric firefox_version(4999);

  /**
   * generated from nimbus_targeting_context.has_active_enterprise_policies
   * Whether the profile has any active enterprise policies.
   */
  constexpr impl::BooleanMetric has_active_enterprise_policies(5000);

  /**
   * generated from nimbus_targeting_context.has_pinned_tabs
   * Whether the profile has any pinned tabs in any open window.
   */
  constexpr impl::BooleanMetric has_pinned_tabs(5001);

  /**
   * generated from nimbus_targeting_context.home_page_settings
   */

  struct HomePageSettingsObject {
    Maybe<bool> isCustomUrl;
    Maybe<bool> isDefault;
    Maybe<bool> isLocked;
    Maybe<bool> isWebExt;
  };
  /**
   * Information about the user's home page settings.
   */
  constexpr impl::ObjectMetric<HomePageSettingsObject, struct HomePageSettingsObjectTag> home_page_settings(5002);

  /**
   * generated from nimbus_targeting_context.is_default_browser
   * Whether the current browser is the default browser.
   */
  constexpr impl::BooleanMetric is_default_browser(5003);

  /**
   * generated from nimbus_targeting_context.is_default_handler
   */

  struct IsDefaultHandlerObject {
    Maybe<bool> html;
    Maybe<bool> pdf;
  };
  /**
   * Whether the current browser is registered as the default handler for various filetypes.
   */
  constexpr impl::ObjectMetric<IsDefaultHandlerObject, struct IsDefaultHandlerObjectTag> is_default_handler(5004);

  /**
   * generated from nimbus_targeting_context.is_first_startup
   * Is this the first startup of the browser on this install? (NB: Must have been explicitly launched with the --first-startup commandline flag.)
   */
  constexpr impl::BooleanMetric is_first_startup(5005);

  /**
   * generated from nimbus_targeting_context.is_fx_a_enabled
   * Whether Firefox Accounts and Sync are enabled.
   */
  constexpr impl::BooleanMetric is_fx_a_enabled(5006);

  /**
   * generated from nimbus_targeting_context.is_fx_a_signed_in
   * Whether the user is logged in to Firefox Accounts.
   */
  constexpr impl::BooleanMetric is_fx_a_signed_in(5007);

  /**
   * generated from nimbus_targeting_context.is_msix
   * Is this copy of Firefox installed from an MSIX installer?
   */
  constexpr impl::BooleanMetric is_msix(5008);

  /**
   * generated from nimbus_targeting_context.locale
   * What is the active locale of the browser?
   */
  constexpr impl::StringMetric locale(5009);

  /**
   * generated from nimbus_targeting_context.memory_mb
   * The amount of system memory, in mebibytes (MiB).
   */
  constexpr impl::QuantityMetric memory_mb(5010);

  /**
   * generated from nimbus_targeting_context.os
   */

  struct OsObject {
    Maybe<bool> isLinux;
    Maybe<bool> isMac;
    Maybe<bool> isWindows;
    Maybe<int64_t> windowsBuildNumber;
    Maybe<int64_t> windowsVersion;
  };
  /**
   * Information about the operating system.
   */
  constexpr impl::ObjectMetric<OsObject, struct OsObjectTag> os(5011);

  /**
   * generated from nimbus_targeting_context.primary_resolution
   */

  struct PrimaryResolutionObject {
    Maybe<int64_t> height;
    Maybe<int64_t> width;
  };
  /**
   * The resolution of the primary display.
   */
  constexpr impl::ObjectMetric<PrimaryResolutionObject, struct PrimaryResolutionObjectTag> primary_resolution(5012);

  /**
   * generated from nimbus_targeting_context.profile_age_created
   * The UNIX timestamp of when the profile was created.
   */
  constexpr impl::QuantityMetric profile_age_created(5013);

  /**
   * generated from nimbus_targeting_context.profile_group_profile_count
   * The number of profiles in the current profile group or zero if either the feature is not enabled or the user has not created any profiles.
   */
  constexpr impl::QuantityMetric profile_group_profile_count(5014);

  /**
   * generated from nimbus_targeting_context.region
   * What region is the browser located in?
   */
  constexpr impl::StringMetric region(5015);

  /**
   * generated from nimbus_targeting_context.total_bookmarks_count
   * The number of bookmarks.
   */
  constexpr impl::QuantityMetric total_bookmarks_count(5016);

  /**
   * generated from nimbus_targeting_context.user_monthly_activity
   */

  struct UserMonthlyActivityObjectItem {
    Maybe<int64_t> numberOfURLsVisited;
    Maybe<nsCString> date;
  };

  using UserMonthlyActivityObject = nsTArray<UserMonthlyActivityObjectItem>;
  /**
   * Information about the user's activity over the last 28 days.
   */
  constexpr impl::ObjectMetric<UserMonthlyActivityObject, struct UserMonthlyActivityObjectTag> user_monthly_activity(5017);

  /**
   * generated from nimbus_targeting_context.user_prefers_reduced_motion
   * Whether the user prefers reduced motion.
   */
  constexpr impl::BooleanMetric user_prefers_reduced_motion(5018);

  /**
   * generated from nimbus_targeting_context.uses_firefox_sync
   * Whether the user uses Firefox Sync.
   */
  constexpr impl::BooleanMetric uses_firefox_sync(5019);

  /**
   * generated from nimbus_targeting_context.version
   * The full Firefox version string.
   */
  constexpr impl::StringMetric version(5020);
}

template <>
inline void impl::ObjectMetric<nimbus_targeting_context::ActiveExperimentsObject, nimbus_targeting_context::ActiveExperimentsObjectTag>::Set(const nimbus_targeting_context::ActiveExperimentsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StringElement(aobjItem);

    }
  }
  writer.EndArray();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<nimbus_targeting_context::ActiveRolloutsObject, nimbus_targeting_context::ActiveRolloutsObjectTag>::Set(const nimbus_targeting_context::ActiveRolloutsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StringElement(aobjItem);

    }
  }
  writer.EndArray();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<nimbus_targeting_context::AddonsInfoObject, nimbus_targeting_context::AddonsInfoObjectTag>::Set(const nimbus_targeting_context::AddonsInfoObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.addons.isSome()) {
      writer.StartArrayProperty("addons");
      for (const auto& aobjAddonsItem: *aObj.addons) {
        writer.StringElement(aobjAddonsItem);

      }
      writer.EndArray();
    }
    if (aObj.hasInstalledAddons.isSome()) {
      writer.BoolProperty("hasInstalledAddons", *(aObj.hasInstalledAddons));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<nimbus_targeting_context::AttributionDataObject, nimbus_targeting_context::AttributionDataObjectTag>::Set(const nimbus_targeting_context::AttributionDataObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.medium.isSome()) {
      writer.StringProperty("medium", *(aObj.medium));
    }
    if (aObj.source.isSome()) {
      writer.StringProperty("source", *(aObj.source));
    }
    if (aObj.ua.isSome()) {
      writer.StringProperty("ua", *(aObj.ua));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<nimbus_targeting_context::BrowserSettingsObject, nimbus_targeting_context::BrowserSettingsObjectTag>::Set(const nimbus_targeting_context::BrowserSettingsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.update.isSome()) {
      writer.StartObjectProperty("update");
      if (aObj.update->channel.isSome()) {
        writer.StringProperty("channel", *(aObj.update->channel));
      }
      writer.EndObject();
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<nimbus_targeting_context::DefaultPdfHandlerObject, nimbus_targeting_context::DefaultPdfHandlerObjectTag>::Set(const nimbus_targeting_context::DefaultPdfHandlerObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.knownBrowser.isSome()) {
      writer.BoolProperty("knownBrowser", *(aObj.knownBrowser));
    }
    if (aObj.registered.isSome()) {
      writer.BoolProperty("registered", *(aObj.registered));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<nimbus_targeting_context::EnrollmentsMapObject, nimbus_targeting_context::EnrollmentsMapObjectTag>::Set(const nimbus_targeting_context::EnrollmentsMapObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.experimentSlug.isSome()) {
          writer.StringProperty("experimentSlug", *(aobjItem.experimentSlug));
        }
        if (aobjItem.branchSlug.isSome()) {
          writer.StringProperty("branchSlug", *(aobjItem.branchSlug));
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<nimbus_targeting_context::HomePageSettingsObject, nimbus_targeting_context::HomePageSettingsObjectTag>::Set(const nimbus_targeting_context::HomePageSettingsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.isCustomUrl.isSome()) {
      writer.BoolProperty("isCustomUrl", *(aObj.isCustomUrl));
    }
    if (aObj.isDefault.isSome()) {
      writer.BoolProperty("isDefault", *(aObj.isDefault));
    }
    if (aObj.isLocked.isSome()) {
      writer.BoolProperty("isLocked", *(aObj.isLocked));
    }
    if (aObj.isWebExt.isSome()) {
      writer.BoolProperty("isWebExt", *(aObj.isWebExt));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<nimbus_targeting_context::IsDefaultHandlerObject, nimbus_targeting_context::IsDefaultHandlerObjectTag>::Set(const nimbus_targeting_context::IsDefaultHandlerObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.html.isSome()) {
      writer.BoolProperty("html", *(aObj.html));
    }
    if (aObj.pdf.isSome()) {
      writer.BoolProperty("pdf", *(aObj.pdf));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<nimbus_targeting_context::OsObject, nimbus_targeting_context::OsObjectTag>::Set(const nimbus_targeting_context::OsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.isLinux.isSome()) {
      writer.BoolProperty("isLinux", *(aObj.isLinux));
    }
    if (aObj.isMac.isSome()) {
      writer.BoolProperty("isMac", *(aObj.isMac));
    }
    if (aObj.isWindows.isSome()) {
      writer.BoolProperty("isWindows", *(aObj.isWindows));
    }
    if (aObj.windowsBuildNumber.isSome()) {
      writer.IntProperty("windowsBuildNumber", *(aObj.windowsBuildNumber));
    }
    if (aObj.windowsVersion.isSome()) {
      writer.IntProperty("windowsVersion", *(aObj.windowsVersion));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<nimbus_targeting_context::PrimaryResolutionObject, nimbus_targeting_context::PrimaryResolutionObjectTag>::Set(const nimbus_targeting_context::PrimaryResolutionObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.height.isSome()) {
      writer.IntProperty("height", *(aObj.height));
    }
    if (aObj.width.isSome()) {
      writer.IntProperty("width", *(aObj.width));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<nimbus_targeting_context::UserMonthlyActivityObject, nimbus_targeting_context::UserMonthlyActivityObjectTag>::Set(const nimbus_targeting_context::UserMonthlyActivityObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.numberOfURLsVisited.isSome()) {
          writer.IntProperty("numberOfURLsVisited", *(aobjItem.numberOfURLsVisited));
        }
        if (aobjItem.date.isSome()) {
          writer.StringProperty("date", *(aobjItem.date));
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

namespace nimbus_targeting_environment {
  /**
   * generated from nimbus_targeting_environment.attr_eval_errors
   */
  enum class AttrEvalErrorsLabel: uint16_t {
    eActiveexperiments = 0,
    eActiverollouts = 1,
    eAddonsinfo = 2,
    eAddressessaved = 3,
    eArchbits = 4,
    eAttributiondata = 5,
    eBrowsersettings = 6,
    eBuildid = 7,
    eCurrentdate = 8,
    eDefaultpdfhandler = 9,
    eDistributionid = 10,
    eDoesappneedpin = 11,
    eEnrollmentsmap = 12,
    eFirefoxversion = 13,
    eHasactiveenterprisepolicies = 14,
    eHaspinnedtabs = 15,
    eHomepagesettings = 16,
    eIsdefaultbrowser = 17,
    eIsdefaulthandler = 18,
    eIsfirststartup = 19,
    eIsfxaenabled = 20,
    eIsfxasignedin = 21,
    eIsmsix = 22,
    eLocale = 23,
    eMemorymb = 24,
    eOs = 25,
    ePrimaryresolution = 26,
    eProfileagecreated = 27,
    eProfilegroupprofilecount = 28,
    eRegion = 29,
    eTotalbookmarkscount = 30,
    eUsermonthlyactivity = 31,
    eUserprefersreducedmotion = 32,
    eUsesfirefoxsync = 33,
    eVersion = 34,
    e__Other__,
  };
  /**
   * When a metric in `nimbus_targeting_context` cannot be recorded because an exception was thrown during evaluation of the targeting context attribute the name of the attribute is recorded in this metric.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, AttrEvalErrorsLabel> attr_eval_errors(5021);

  /**
   * generated from nimbus_targeting_environment.pref_type_errors
   */
  enum class PrefTypeErrorsLabel: uint16_t {
    eBrowserNewtabpageActivityStreamAsrouterUserprefsCfrAddons = 0,
    eBrowserNewtabpageActivityStreamAsrouterUserprefsCfrFeatures = 1,
    eBrowserNewtabpageActivityStreamFeedsSectionHighlights = 2,
    eBrowserNewtabpageActivityStreamFeedsSectionTopstories = 3,
    eBrowserNewtabpageActivityStreamFeedsTopsites = 4,
    eBrowserNewtabpageActivityStreamShowsearch = 5,
    eBrowserNewtabpageActivityStreamShowsponsoredtopsites = 6,
    eBrowserNewtabpageEnabled = 7,
    eBrowserProfilesCreated = 8,
    eBrowserStartupPage = 9,
    eBrowserToolbarsBookmarksVisibility = 10,
    eBrowserUrlbarLasturlbarsearchseconds = 11,
    eBrowserUrlbarQuicksuggestDatacollectionEnabled = 12,
    eBrowserUrlbarShowsearchsuggestionsfirst = 13,
    eBrowserUrlbarSuggestQuicksuggestSponsored = 14,
    eMediaVideocontrolsPictureInPictureEnabled = 15,
    eMediaVideocontrolsPictureInPictureVideoToggleEnabled = 16,
    eMediaVideocontrolsPictureInPictureVideoToggleHasUsed = 17,
    eMessagingSystemActionTestday = 18,
    eNetworkTrrMode = 19,
    eNimbusQaPref1 = 20,
    eNimbusQaPref2 = 21,
    eSecuritySandboxContentLevel = 22,
    eTermsofuseAccepteddate = 23,
    eTrailheadFirstrunDidseeaboutwelcome = 24,
    e__Other__,
  };
  /**
   * When a pref in `nimbus_targeting_environment.pref_values` cannot be recorded because the type in the metric does not match the type of the pref, it is recorded in this metric.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, PrefTypeErrorsLabel> pref_type_errors(5022);

  /**
   * generated from nimbus_targeting_environment.pref_values
   */

  struct PrefValuesObject {
    Maybe<bool> browser__newtabpage__activity_stream__asrouter__userprefs__cfr__addons;
    Maybe<bool> browser__newtabpage__activity_stream__asrouter__userprefs__cfr__features;
    Maybe<bool> browser__newtabpage__activity_stream__feeds__section__highlights;
    Maybe<bool> browser__newtabpage__activity_stream__feeds__section__topstories;
    Maybe<bool> browser__newtabpage__activity_stream__feeds__topsites;
    Maybe<bool> browser__newtabpage__activity_stream__showSearch;
    Maybe<bool> browser__newtabpage__activity_stream__showSponsoredTopSites;
    Maybe<bool> browser__newtabpage__enabled;
    Maybe<bool> browser__profiles__created;
    Maybe<int64_t> browser__startup__page;
    Maybe<nsCString> browser__toolbars__bookmarks__visibility;
    Maybe<int64_t> browser__urlbar__lastUrlbarSearchSeconds;
    Maybe<bool> browser__urlbar__quicksuggest__dataCollection__enabled;
    Maybe<bool> browser__urlbar__showSearchSuggestionsFirst;
    Maybe<bool> browser__urlbar__suggest__quicksuggest__sponsored;
    Maybe<bool> media__videocontrols__picture_in_picture__enabled;
    Maybe<bool> media__videocontrols__picture_in_picture__video_toggle__enabled;
    Maybe<bool> media__videocontrols__picture_in_picture__video_toggle__has_used;
    Maybe<nsCString> messaging_system_action__testday;
    Maybe<int64_t> network__trr__mode;
    Maybe<int64_t> security__sandbox__content__level;
    Maybe<nsCString> termsofuse__acceptedDate;
    Maybe<bool> trailhead__firstrun__didSeeAboutWelcome;
    Maybe<nsCString> nimbus__qa__pref_1;
    Maybe<nsCString> nimbus__qa__pref_2;
  };
  /**
   * Values of specific preferences we want to target on.
   */
  constexpr impl::ObjectMetric<PrefValuesObject, struct PrefValuesObjectTag> pref_values(5023);

  /**
   * generated from nimbus_targeting_environment.targeting_context_value
   * The entirety of the Nimbus targeting context as a stringified JSON object.
   * This is disabled by default and only intended to be enabled via server knobs to debug recording failures in individual nimbus_targeting_context metric values.
   */
  constexpr impl::TextMetric targeting_context_value(5024);

  /**
   * generated from nimbus_targeting_environment.user_set_prefs
   */
  using UserSetPrefsObject = nsTArray<nsCString>;
  /**
   * An array of preferences that are user set.
   */
  constexpr impl::ObjectMetric<UserSetPrefsObject, struct UserSetPrefsObjectTag> user_set_prefs(5025);
}

template <>
inline void impl::ObjectMetric<nimbus_targeting_environment::PrefValuesObject, nimbus_targeting_environment::PrefValuesObjectTag>::Set(const nimbus_targeting_environment::PrefValuesObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.browser__newtabpage__activity_stream__asrouter__userprefs__cfr__addons.isSome()) {
      writer.BoolProperty("browser__newtabpage__activity_stream__asrouter__userprefs__cfr__addons", *(aObj.browser__newtabpage__activity_stream__asrouter__userprefs__cfr__addons));
    }
    if (aObj.browser__newtabpage__activity_stream__asrouter__userprefs__cfr__features.isSome()) {
      writer.BoolProperty("browser__newtabpage__activity_stream__asrouter__userprefs__cfr__features", *(aObj.browser__newtabpage__activity_stream__asrouter__userprefs__cfr__features));
    }
    if (aObj.browser__newtabpage__activity_stream__feeds__section__highlights.isSome()) {
      writer.BoolProperty("browser__newtabpage__activity_stream__feeds__section__highlights", *(aObj.browser__newtabpage__activity_stream__feeds__section__highlights));
    }
    if (aObj.browser__newtabpage__activity_stream__feeds__section__topstories.isSome()) {
      writer.BoolProperty("browser__newtabpage__activity_stream__feeds__section__topstories", *(aObj.browser__newtabpage__activity_stream__feeds__section__topstories));
    }
    if (aObj.browser__newtabpage__activity_stream__feeds__topsites.isSome()) {
      writer.BoolProperty("browser__newtabpage__activity_stream__feeds__topsites", *(aObj.browser__newtabpage__activity_stream__feeds__topsites));
    }
    if (aObj.browser__newtabpage__activity_stream__showSearch.isSome()) {
      writer.BoolProperty("browser__newtabpage__activity_stream__showSearch", *(aObj.browser__newtabpage__activity_stream__showSearch));
    }
    if (aObj.browser__newtabpage__activity_stream__showSponsoredTopSites.isSome()) {
      writer.BoolProperty("browser__newtabpage__activity_stream__showSponsoredTopSites", *(aObj.browser__newtabpage__activity_stream__showSponsoredTopSites));
    }
    if (aObj.browser__newtabpage__enabled.isSome()) {
      writer.BoolProperty("browser__newtabpage__enabled", *(aObj.browser__newtabpage__enabled));
    }
    if (aObj.browser__profiles__created.isSome()) {
      writer.BoolProperty("browser__profiles__created", *(aObj.browser__profiles__created));
    }
    if (aObj.browser__startup__page.isSome()) {
      writer.IntProperty("browser__startup__page", *(aObj.browser__startup__page));
    }
    if (aObj.browser__toolbars__bookmarks__visibility.isSome()) {
      writer.StringProperty("browser__toolbars__bookmarks__visibility", *(aObj.browser__toolbars__bookmarks__visibility));
    }
    if (aObj.browser__urlbar__lastUrlbarSearchSeconds.isSome()) {
      writer.IntProperty("browser__urlbar__lastUrlbarSearchSeconds", *(aObj.browser__urlbar__lastUrlbarSearchSeconds));
    }
    if (aObj.browser__urlbar__quicksuggest__dataCollection__enabled.isSome()) {
      writer.BoolProperty("browser__urlbar__quicksuggest__dataCollection__enabled", *(aObj.browser__urlbar__quicksuggest__dataCollection__enabled));
    }
    if (aObj.browser__urlbar__showSearchSuggestionsFirst.isSome()) {
      writer.BoolProperty("browser__urlbar__showSearchSuggestionsFirst", *(aObj.browser__urlbar__showSearchSuggestionsFirst));
    }
    if (aObj.browser__urlbar__suggest__quicksuggest__sponsored.isSome()) {
      writer.BoolProperty("browser__urlbar__suggest__quicksuggest__sponsored", *(aObj.browser__urlbar__suggest__quicksuggest__sponsored));
    }
    if (aObj.media__videocontrols__picture_in_picture__enabled.isSome()) {
      writer.BoolProperty("media__videocontrols__picture_in_picture__enabled", *(aObj.media__videocontrols__picture_in_picture__enabled));
    }
    if (aObj.media__videocontrols__picture_in_picture__video_toggle__enabled.isSome()) {
      writer.BoolProperty("media__videocontrols__picture_in_picture__video_toggle__enabled", *(aObj.media__videocontrols__picture_in_picture__video_toggle__enabled));
    }
    if (aObj.media__videocontrols__picture_in_picture__video_toggle__has_used.isSome()) {
      writer.BoolProperty("media__videocontrols__picture_in_picture__video_toggle__has_used", *(aObj.media__videocontrols__picture_in_picture__video_toggle__has_used));
    }
    if (aObj.messaging_system_action__testday.isSome()) {
      writer.StringProperty("messaging_system_action__testday", *(aObj.messaging_system_action__testday));
    }
    if (aObj.network__trr__mode.isSome()) {
      writer.IntProperty("network__trr__mode", *(aObj.network__trr__mode));
    }
    if (aObj.security__sandbox__content__level.isSome()) {
      writer.IntProperty("security__sandbox__content__level", *(aObj.security__sandbox__content__level));
    }
    if (aObj.termsofuse__acceptedDate.isSome()) {
      writer.StringProperty("termsofuse__acceptedDate", *(aObj.termsofuse__acceptedDate));
    }
    if (aObj.trailhead__firstrun__didSeeAboutWelcome.isSome()) {
      writer.BoolProperty("trailhead__firstrun__didSeeAboutWelcome", *(aObj.trailhead__firstrun__didSeeAboutWelcome));
    }
    if (aObj.nimbus__qa__pref_1.isSome()) {
      writer.StringProperty("nimbus__qa__pref_1", *(aObj.nimbus__qa__pref_1));
    }
    if (aObj.nimbus__qa__pref_2.isSome()) {
      writer.StringProperty("nimbus__qa__pref_2", *(aObj.nimbus__qa__pref_2));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<nimbus_targeting_environment::UserSetPrefsObject, nimbus_targeting_environment::UserSetPrefsObjectTag>::Set(const nimbus_targeting_environment::UserSetPrefsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StringElement(aobjItem);

    }
  }
  writer.EndArray();


  SetStr(json);
}

namespace normandy {
  /**
   * generated from normandy.expose_nimbus_experiment
   */
  struct ExposeNimbusExperimentExtra {
    mozilla::Maybe<nsCString> branchslug;
    mozilla::Maybe<nsCString> featureid;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branchslug) {
        extraKeys.AppendElement()->AssignASCII("branchSlug");
        extraValues.EmplaceBack(branchslug.value());
      }
      if (featureid) {
        extraKeys.AppendElement()->AssignASCII("featureId");
        extraValues.EmplaceBack(featureid.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This records an event at the moment the user is exposed to an experiment treatment. The event is triggered either by the code checking that a certain experiment feature is enabled or when that feature value is used. This is different from enrollment or experiment activation because it registers when a user actually gets exposed to the experiment feature. This event was generated to correspond to the Legacy Telemetry event normandy.expose#nimbus_experiment.
   */
  constexpr impl::EventMetric<ExposeNimbusExperimentExtra> expose_nimbus_experiment(5026);
}

} // namespace mozilla::glean

#endif // mozilla_GleanNimbusMetrics_h
