/* THIS FILE IS AUTOGENERATED FROM WorkerTestUtils.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "MainThreadUtils.h"
#include "WorkerTestUtilsBinding.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_dom.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/WorkerTestUtils.h"
#include "nsThreadUtils.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


MOZ_CAN_RUN_SCRIPT void
WorkerTestCallback::Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, ErrorResult& aRv)
{
  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, aThisVal, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}



namespace WorkerTestUtils_Binding {

MOZ_CAN_RUN_SCRIPT static bool
currentTimerNestingLevel(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WorkerTestUtils", "currentTimerNestingLevel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  FastErrorResult rv;
  uint32_t result(mozilla::dom::WorkerTestUtils::CurrentTimerNestingLevel(global, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WorkerTestUtils.currentTimerNestingLevel"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
IsRunningInBackground(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WorkerTestUtils", "IsRunningInBackground", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  FastErrorResult rv;
  bool result(mozilla::dom::WorkerTestUtils::IsRunningInBackground(global, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WorkerTestUtils.IsRunningInBackground"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
holdStrongWorkerRefUntilMainThreadObserverNotified(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WorkerTestUtils", "holdStrongWorkerRefUntilMainThreadObserverNotified", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "WorkerTestUtils.holdStrongWorkerRefUntilMainThreadObserverNotified", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::WorkerTestUtils::HoldStrongWorkerRefUntilMainThreadObserverNotified(global, Constify(arg0), rv))>, "Should be returning void here");
  mozilla::dom::WorkerTestUtils::HoldStrongWorkerRefUntilMainThreadObserverNotified(global, Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WorkerTestUtils.holdStrongWorkerRefUntilMainThreadObserverNotified"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
blockUntilMainThreadObserverNotified(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "WorkerTestUtils.blockUntilMainThreadObserverNotified");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WorkerTestUtils", "blockUntilMainThreadObserverNotified", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "WorkerTestUtils.blockUntilMainThreadObserverNotified", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  RootedCallback<OwningNonNull<binding_detail::FastWorkerTestCallback>> arg1(cx);
  if (args[1].isObject()) {
    if (JS::IsCallable(&args[1].toObject())) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg1 = new binding_detail::FastWorkerTestCallback(&args[1].toObject(), JS::CurrentGlobalOrNull(cx));
    }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 2");
      return false;
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::WorkerTestUtils::BlockUntilMainThreadObserverNotified(global, Constify(arg0), MOZ_KnownLive(NonNullHelper(arg1)), rv))>, "Should be returning void here");
  mozilla::dom::WorkerTestUtils::BlockUntilMainThreadObserverNotified(global, Constify(arg0), MOZ_KnownLive(NonNullHelper(arg1)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WorkerTestUtils.blockUntilMainThreadObserverNotified"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
notifyObserverOnMainThread(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WorkerTestUtils", "notifyObserverOnMainThread", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "WorkerTestUtils.notifyObserverOnMainThread", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::WorkerTestUtils::NotifyObserverOnMainThread(global, Constify(arg0), rv))>, "Should be returning void here");
  mozilla::dom::WorkerTestUtils::NotifyObserverOnMainThread(global, Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WorkerTestUtils.notifyObserverOnMainThread"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_GLOBINIT static const JSFunctionSpec sStaticMethods_specs[] = {
  JS_FNSPEC("currentTimerNestingLevel", currentTimerNestingLevel, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("IsRunningInBackground", IsRunningInBackground, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("holdStrongWorkerRefUntilMainThreadObserverNotified", holdStrongWorkerRefUntilMainThreadObserverNotified, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("blockUntilMainThreadObserverNotified", blockUntilMainThreadObserverNotified, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("notifyObserverOnMainThread", notifyObserverOnMainThread, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sStaticMethods[] = {
  { nullptr, &sStaticMethods_specs[0] },
  { nullptr, nullptr }
};


static const NativePropertiesN<1> sNativeProperties = {
  true,  0 /* sStaticMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  0,
  nullptr,
  {
    { sStaticMethods, nullptr }
  }
};

static const DOMIfaceAndProtoJSClass sNamespaceObjectClass = {
  {
    "WorkerTestUtils",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS,
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eNamespace,
  prototypes::id::_ID_Count,
  0,
  &sEmptyNativePropertyHooks,
  // This isn't strictly following the spec (see
  // https://console.spec.whatwg.org/#ref-for-dfn-namespace-object),
  // but should be ok for Xrays.
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  MOZ_ASSERT(!NS_IsMainThread(), "Why did we even get called?");

  return StaticPrefs::dom_workers_testing_enabled();
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Rooted<JSObject*> constructorProto(aCx, JS::GetRealmObjectPrototype(aCx));
  if (!constructorProto) {
    return;
  }

  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::WorkerTestUtils);
  dom::CreateNamespaceObject(aCx, aGlobal, constructorProto,
                             sNamespaceObjectClass,
                             interfaceCache,
                             sNativeProperties.Upcast(),
                             nullptr,
                             "WorkerTestUtils",
                             ShouldExpose<WorkerTestUtils_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal));
}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::WorkerTestUtils,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace WorkerTestUtils_Binding



} // namespace mozilla::dom
