// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanSecurityManagerSslMetrics_h
#define mozilla_GleanSecurityManagerSslMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace networking {
  /**
   * generated from networking.loading_certs_task
   * The time in milliseconds to load any external certificates. This occurs off of the main-thread, but can block main-thread operations. This metric was generated to correspond to the Legacy Telemetry scalar networking.loading_certs_task.
   */
  constexpr impl::QuantityMetric loading_certs_task(190);

  /**
   * generated from networking.nss_initialization
   * The time in milliseconds to initialize the NSS component in the parent process. This metric was generated to correspond to the Legacy Telemetry scalar networking.nss_initialization.
   */
  constexpr impl::QuantityMetric nss_initialization(191);
}

namespace security {
  /**
   * generated from security.addon_signature_verification_status
   * Records the result of App Signature Verification. See the comments in OpenSignedAppFile.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram ADDON_SIGNATURE_VERIFICATION_STATUS.
   */
  constexpr impl::CustomDistributionMetric addon_signature_verification_status(445);

  /**
   * generated from security.client_auth_cert_usage
   * Measures how many servers have requested a client authentication certificate (key: "requested") and how many times the user has opted to send one in response (key: "sent"). This metric was generated to correspond to the Legacy Telemetry scalar security.client_auth_cert_usage.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> client_auth_cert_usage(446);

  /**
   * generated from security.content_signature_verification_errors
   * Result of the content signature verification keyed by application (certificate fingerprint).
   */
  constexpr impl::DualLabeledCounterMetric content_signature_verification_errors(447);

  /**
   * generated from security.content_signature_verification_status
   * What was the result of the content signature verification? 0=valid, 1=invalid, 2=noCertChain, 3=createContextFailedWithOtherError, 4=expiredCert, 5=certNotValidYet, 6=buildCertChainFailed, 7=eeCertForWrongHost, 8=extractKeyError, 9=vfyContextError
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram CONTENT_SIGNATURE_VERIFICATION_STATUS.
   */
  constexpr impl::CustomDistributionMetric content_signature_verification_status(448);

  /**
   * generated from security.ntlm_module_used
   * The module used for the NTLM protocol (Windows_API, Kerberos, Samba_auth or Generic) and whether or not the authentication was used to connect to a proxy server. This data is collected only once per session (at first NTLM authentification) ; fixed version.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram NTLM_MODULE_USED_2.
   */
  constexpr impl::CustomDistributionMetric ntlm_module_used(449);
}

namespace cert {
  /**
   * generated from cert.chain_key_size_status
   * Does enforcing a larger minimum RSA key size cause verification failures? 1 = no, 2 = yes, 3 = another error prevented finding a verified chain
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram CERT_CHAIN_KEY_SIZE_STATUS.
   */
  constexpr impl::CustomDistributionMetric chain_key_size_status(4342);

  /**
   * generated from cert.ev_status
   * EV status of a certificate, recorded on each TLS connection. 0=invalid, 1=DV, 2=EV
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram CERT_EV_STATUS.
   */
  constexpr impl::CustomDistributionMetric ev_status(4343);

  /**
   * generated from cert.validation_http_request_result
   * HTTP result of OCSP, etc.. (0=canceled, 1=OK, 2=FAILED, 3=internal-error)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram CERT_VALIDATION_HTTP_REQUEST_RESULT.
   */
  constexpr impl::CustomDistributionMetric validation_http_request_result(4344);

  /**
   * generated from cert.validation_success_by_ca_2
   * Successful SSL server cert validations by CA (see KnownRootHashes.txt for names of CAs).
   */
  constexpr impl::CustomDistributionMetric validation_success_by_ca_2(4345);
}

namespace cert_compression {
  /**
   * generated from cert_compression.failures
   */
  enum class FailuresLabel: uint16_t {
    eZlib = 0,
    eBrotli = 1,
    eZstd = 2,
    e__Other__,
  };
  /**
   * The number of times each certificate compression algorithm returned an error.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, FailuresLabel> failures(4346);
}

namespace cert_pinning {
  /**
   * generated from cert_pinning.failures_by_ca_2
   * Pinning failures by CA (see KnownRootHashes.txt for names of CAs).
   */
  constexpr impl::CustomDistributionMetric failures_by_ca_2(4347);

  /**
   * generated from cert_pinning.moz_results_by_host
   * Certificate pinning results by host for Mozilla operational sites
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram CERT_PINNING_MOZ_RESULTS_BY_HOST.
   */
  constexpr impl::CustomDistributionMetric moz_results_by_host(4348);

  /**
   * generated from cert_pinning.moz_test_results_by_host
   * Certificate pinning test results by host for Mozilla operational sites
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram CERT_PINNING_MOZ_TEST_RESULTS_BY_HOST.
   */
  constexpr impl::CustomDistributionMetric moz_test_results_by_host(4349);

  /**
   * generated from cert_pinning.results
   */
  enum class ResultsLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Certificate pinning results (0 = failure, 1 = success)
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CERT_PINNING_RESULTS.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ResultsLabel> results(4350);

  /**
   * generated from cert_pinning.test_results
   */
  enum class TestResultsLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Certificate pinning test results (0 = failure, 1 = success)
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CERT_PINNING_TEST_RESULTS.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, TestResultsLabel> test_results(4351);
}

namespace cert_storage {
  /**
   * generated from cert_storage.memory
   * Heap memory used by cert_storage.
   */
  constexpr impl::MemoryDistributionMetric memory(4352);
}

namespace cert_verification_time {
  /**
   * generated from cert_verification_time.failure
   * The time it takes to fail to verify a certificate in a TLS handshake.
   */
  constexpr impl::TimingDistributionMetric failure(4353);

  /**
   * generated from cert_verification_time.success
   * The time it takes to successfully verify a certificate in a TLS handshake.
   */
  constexpr impl::TimingDistributionMetric success(4354);
}

namespace data_storage {
  /**
   * generated from data_storage.alternate_services
   * The number of entries stored in the AlternateServices nsIDataStorage
   */
  constexpr impl::QuantityMetric alternate_services(4355);

  /**
   * generated from data_storage.client_auth_remember_list
   * The number of entries stored in the ClientAuthRememberList nsIDataStorage
   */
  constexpr impl::QuantityMetric client_auth_remember_list(4356);

  /**
   * generated from data_storage.site_security_service_state
   * The number of entries stored in the SiteSecurityServiceState nsIDataStorage
   */
  constexpr impl::QuantityMetric site_security_service_state(4357);
}

namespace ocsp_request_time {
  /**
   * generated from ocsp_request_time.cancel
   * The time it takes to make an OCSP request that was cancelled.
   */
  constexpr impl::TimingDistributionMetric cancel(4358);

  /**
   * generated from ocsp_request_time.failure
   * The time it takes to make an OCSP request that failed.
   */
  constexpr impl::TimingDistributionMetric failure(4359);

  /**
   * generated from ocsp_request_time.success
   * The time it takes to make an OCSP request that succeeded.
   */
  constexpr impl::TimingDistributionMetric success(4360);
}

namespace oskeystore {
  /**
   * generated from oskeystore.return_codes
   */
  struct ReturnCodesExtra {
    mozilla::Maybe<nsCString> function;
    mozilla::Maybe<nsCString> result;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (function) {
        extraKeys.AppendElement()->AssignASCII("function");
        extraValues.EmplaceBack(function.value());
      }
      if (result) {
        extraKeys.AppendElement()->AssignASCII("result");
        extraValues.EmplaceBack(result.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collects return codes from the different implementations of the key store API. These are sometimes poorly documented and collection is the only way to discover them.
   */
  constexpr impl::EventMetric<ReturnCodesExtra> return_codes(4361);
}

namespace pkcs11 {
  /**
   * generated from pkcs11.external_trust_anchor_module_loaded
   * Whether or not an external trust anchor module was loaded.
   */
  constexpr impl::BooleanMetric external_trust_anchor_module_loaded(4362);

  /**
   * generated from pkcs11.third_party_module_profile_entries
   * A list of PKCS#11 module filenames (leaf names only) that are in the profile at launch time.
   */
  constexpr impl::StringListMetric third_party_module_profile_entries(4363);

  /**
   * generated from pkcs11.third_party_module_signature_type
   */
  struct ThirdPartyModuleSignatureTypeExtra {
    mozilla::Maybe<nsCString> filename;
    mozilla::Maybe<nsCString> signature;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (filename) {
        extraKeys.AppendElement()->AssignASCII("filename");
        extraValues.EmplaceBack(filename.value());
      }
      if (signature) {
        extraKeys.AppendElement()->AssignASCII("signature");
        extraValues.EmplaceBack(signature.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The filename (leaf name only) and macOS code signature type of a third-party PKCS#11 module collected when the module is first loaded and added to the profile. Only collected on macOS.
   */
  constexpr impl::EventMetric<ThirdPartyModuleSignatureTypeExtra> third_party_module_signature_type(4364);

  /**
   * generated from pkcs11.third_party_modules_loaded
   * The number of third-party PKCS#11 modules loaded.
   */
  constexpr impl::QuantityMetric third_party_modules_loaded(4365);
}

namespace ssl {
  /**
   * generated from ssl.auth_algorithm_full
   * SSL Authentication Algorithm (null=0, rsa(KEA)=1, ecdsa=4, rsa(sign)=7) in full handshake
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_AUTH_ALGORITHM_FULL.
   */
  constexpr impl::CustomDistributionMetric auth_algorithm_full(4366);

  /**
   * generated from ssl.auth_ecdsa_curve_full
   * ECDSA signature curve for TLS_*_ECDSA_* in full handshake (23=P-256, 24=P-384, 25=P-521)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_AUTH_ECDSA_CURVE_FULL.
   */
  constexpr impl::CustomDistributionMetric auth_ecdsa_curve_full(4367);

  /**
   * generated from ssl.auth_rsa_key_size_full
   * RSA signature key size for TLS_*_RSA_* in full handshake
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_AUTH_RSA_KEY_SIZE_FULL.
   */
  constexpr impl::CustomDistributionMetric auth_rsa_key_size_full(4368);

  /**
   * generated from ssl.bytes_before_cert_callback
   * plaintext bytes read before a server certificate authenticated
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SSL_BYTES_BEFORE_CERT_CALLBACK.
   */
  constexpr impl::MemoryDistributionMetric bytes_before_cert_callback(4369);

  /**
   * generated from ssl.cert_error_overrides
   * Was a certificate error overridden on this handshake? What was it? (0=unknown error (indicating bug), 1=no, >1=a specific error)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_CERT_ERROR_OVERRIDES.
   */
  constexpr impl::CustomDistributionMetric cert_error_overrides(4370);

  /**
   * generated from ssl.cert_verification_errors
   * If certificate verification failed in a TLS handshake, what was the error? (see MapCertErrorToProbeValue in security/manager/ssl/SSLServerCertVerification.cpp and the values in security/pkix/include/pkix/Result.h)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_CERT_VERIFICATION_ERRORS.
   */
  constexpr impl::CustomDistributionMetric cert_verification_errors(4371);

  /**
   * generated from ssl.ct_policy_non_compliant_connections_by_ca_2
   * Number of successfully established TLS connections NOT compliant with the Certificate Transparency Policy, by CA. See KnownRootHashes.txt for names of CAs. range_min: 0
   */
  constexpr impl::CustomDistributionMetric ct_policy_non_compliant_connections_by_ca_2(4372);

  /**
   * generated from ssl.kea_dhe_key_size_full
   * DHE KEA (TLS_DHE_*) key size in full handshake
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_KEA_DHE_KEY_SIZE_FULL.
   */
  constexpr impl::CustomDistributionMetric kea_dhe_key_size_full(4373);

  /**
   * generated from ssl.kea_ecdhe_curve_full
   * ECDHE KEA (TLS_ECDHE_*) curve (23=P-256, 24=P-384, 25=P-521, 29=Curve25519) in full handshake
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_KEA_ECDHE_CURVE_FULL.
   */
  constexpr impl::CustomDistributionMetric kea_ecdhe_curve_full(4374);

  /**
   * generated from ssl.kea_rsa_key_size_full
   * RSA KEA (TLS_RSA_*) key size in full handshake
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_KEA_RSA_KEY_SIZE_FULL.
   */
  constexpr impl::CustomDistributionMetric kea_rsa_key_size_full(4375);

  /**
   * generated from ssl.key_exchange_algorithm_full
   * SSL Handshake Key Exchange Algorithm for full handshake (null=0, rsa=1, dh=2, fortezza=3, ecdh=4)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_KEY_EXCHANGE_ALGORITHM_FULL.
   */
  constexpr impl::CustomDistributionMetric key_exchange_algorithm_full(4376);

  /**
   * generated from ssl.key_exchange_algorithm_resumed
   * SSL Handshake Key Exchange Algorithm for resumed handshake (null=0, rsa=1, dh=2, fortezza=3, ecdh=4)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_KEY_EXCHANGE_ALGORITHM_RESUMED.
   */
  constexpr impl::CustomDistributionMetric key_exchange_algorithm_resumed(4377);

  /**
   * generated from ssl.npn_type
   * NPN Results (0=none, 1=negotiated, 2=no-overlap, 3=selected(alpn))
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_NPN_TYPE.
   */
  constexpr impl::CustomDistributionMetric npn_type(4378);

  /**
   * generated from ssl.ocsp_stapling
   * Status of OCSP stapling on this handshake (1=present, good; 2=none; 3=present, expired; 4=present, other error)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_OCSP_STAPLING.
   */
  constexpr impl::CustomDistributionMetric ocsp_stapling(4379);

  /**
   * generated from ssl.permanent_cert_error_overrides
   * How many permanent certificate overrides a user has stored.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SSL_PERMANENT_CERT_ERROR_OVERRIDES.
   */
  constexpr impl::CustomDistributionMetric permanent_cert_error_overrides(4380);

  /**
   * generated from ssl.reasons_for_not_false_starting
   * Bitmask of reasons we did not false start when libssl would have let us (see key in nsNSSCallbacks.cpp)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_REASONS_FOR_NOT_FALSE_STARTING.
   */
  constexpr impl::CustomDistributionMetric reasons_for_not_false_starting(4381);

  /**
   * generated from ssl.resumed_session
   */
  enum class ResumedSessionLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * complete TLS connect that used TLS Session Resumption (collected at same time as SSL_TIME_UNTIL_HANDSHAKE_FINISHED)
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram SSL_RESUMED_SESSION.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ResumedSessionLabel> resumed_session(4382);

  /**
   * generated from ssl.scts_from_tiled_logs_per_connection
   * Histogram of the number of Signed Certificate Timestamps from tiled logs per TLS connection from all sources (embedded / OCSP Stapling / TLS handshake). Bucket 0 counts the cases when no SCTs from tiled logs were received, or none were extracted due to parsing errors.
   */
  constexpr impl::CustomDistributionMetric scts_from_tiled_logs_per_connection(4383);

  /**
   * generated from ssl.scts_origin
   * Origin of Signed Certificate Timestamps received (1=Embedded, 2=TLS handshake extension, 3=Stapled OCSP response)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_SCTS_ORIGIN.
   */
  constexpr impl::CustomDistributionMetric scts_origin(4384);

  /**
   * generated from ssl.scts_per_connection
   * Histogram of Signed Certificate Timestamps per SSL connection, from all sources (embedded / OCSP Stapling / TLS handshake). Bucket 0 counts the cases when no SCTs were received, or none were extracted due to parsing errors.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_SCTS_PER_CONNECTION.
   */
  constexpr impl::CustomDistributionMetric scts_per_connection(4385);

  /**
   * generated from ssl.scts_verification_status
   * Verification status of Signed Certificate Timestamps received (0=Decoding error, 1=Valid SCT, 2=SCT from unknown log, 3=Invalid SCT signature, 4=SCT timestamp is in the future, 5=Valid SCT from a disqualified log 6=SCT timestamp is after the root's distrustAfter time).
   */
  constexpr impl::CustomDistributionMetric scts_verification_status(4386);

  /**
   * generated from ssl.time_until_handshake_finished_keyed_by_ka
   * ms of SSL wait time for full handshake including TCP and proxy tunneling, keyed by the key exchange algorithm used
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SSL_TIME_UNTIL_HANDSHAKE_FINISHED_KEYED_BY_KA.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> time_until_handshake_finished_keyed_by_ka(4387);

  /**
   * generated from ssl.time_until_ready
   * ms of SSL wait time including TCP and proxy tunneling
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SSL_TIME_UNTIL_READY.
   */
  constexpr impl::TimingDistributionMetric time_until_ready(4388);

  /**
   * generated from ssl.time_until_ready_conservative
   * ms of SSL wait time including TCP and proxy tunneling for conservative-mode connections
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SSL_TIME_UNTIL_READY_CONSERVATIVE.
   */
  constexpr impl::TimingDistributionMetric time_until_ready_conservative(4389);

  /**
   * generated from ssl.time_until_ready_ech
   * ms of SSL wait time including TCP and proxy tunneling for connections using ECH 'Real'
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SSL_TIME_UNTIL_READY_ECH.
   */
  constexpr impl::TimingDistributionMetric time_until_ready_ech(4390);

  /**
   * generated from ssl.time_until_ready_ech_grease
   * ms of SSL wait time including TCP and proxy tunneling for connections using ECH GREASE
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SSL_TIME_UNTIL_READY_ECH_GREASE.
   */
  constexpr impl::TimingDistributionMetric time_until_ready_ech_grease(4391);

  /**
   * generated from ssl.time_until_ready_first_try
   * ms of SSL wait time including TCP and proxy tunneling for first-try connections
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SSL_TIME_UNTIL_READY_FIRST_TRY.
   */
  constexpr impl::TimingDistributionMetric time_until_ready_first_try(4392);

  /**
   * generated from ssl.tls10_intolerance_reason_post
   * Potential TLS 1.0 intolerance, after considering historical info (see tlsIntoleranceTelemetryBucket() in nsNSSIOLayer.cpp).
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_TLS10_INTOLERANCE_REASON_POST.
   */
  constexpr impl::CustomDistributionMetric tls10_intolerance_reason_post(4393);

  /**
   * generated from ssl.tls10_intolerance_reason_pre
   * Potential TLS 1.0 intolerance, before considering historical info (see tlsIntoleranceTelemetryBucket() in nsNSSIOLayer.cpp).
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_TLS10_INTOLERANCE_REASON_PRE.
   */
  constexpr impl::CustomDistributionMetric tls10_intolerance_reason_pre(4394);

  /**
   * generated from ssl.tls11_intolerance_reason_post
   * Potential TLS 1.1 intolerance, after considering historical info (see tlsIntoleranceTelemetryBucket() in nsNSSIOLayer.cpp).
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_TLS11_INTOLERANCE_REASON_POST.
   */
  constexpr impl::CustomDistributionMetric tls11_intolerance_reason_post(4395);

  /**
   * generated from ssl.tls11_intolerance_reason_pre
   * Potential TLS 1.1 intolerance, before considering historical info (see tlsIntoleranceTelemetryBucket() in nsNSSIOLayer.cpp).
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_TLS11_INTOLERANCE_REASON_PRE.
   */
  constexpr impl::CustomDistributionMetric tls11_intolerance_reason_pre(4396);

  /**
   * generated from ssl.tls12_intolerance_reason_post
   * Potential TLS 1.2 intolerance, after considering historical info (see tlsIntoleranceTelemetryBucket() in nsNSSIOLayer.cpp).
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_TLS12_INTOLERANCE_REASON_POST.
   */
  constexpr impl::CustomDistributionMetric tls12_intolerance_reason_post(4397);

  /**
   * generated from ssl.tls12_intolerance_reason_pre
   * Potential TLS 1.2 intolerance, before considering historical info (see tlsIntoleranceTelemetryBucket() in nsNSSIOLayer.cpp).
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_TLS12_INTOLERANCE_REASON_PRE.
   */
  constexpr impl::CustomDistributionMetric tls12_intolerance_reason_pre(4398);

  /**
   * generated from ssl.tls13_intolerance_reason_post
   * Potential TLS 1.3 intolerance, after considering historical info (see tlsIntoleranceTelemetryBucket() in nsNSSIOLayer.cpp).
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_TLS13_INTOLERANCE_REASON_POST.
   */
  constexpr impl::CustomDistributionMetric tls13_intolerance_reason_post(4399);

  /**
   * generated from ssl.tls13_intolerance_reason_pre
   * Potential TLS 1.3 intolerance, before considering historical info (see tlsIntoleranceTelemetryBucket() in nsNSSIOLayer.cpp).
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_TLS13_INTOLERANCE_REASON_PRE.
   */
  constexpr impl::CustomDistributionMetric tls13_intolerance_reason_pre(4400);

  /**
   * generated from ssl.version_fallback_inappropriate
   * TLS/SSL version intolerance was falsely detected, server rejected handshake (see tlsIntoleranceTelemetryBucket() in nsNSSIOLayer.cpp).
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_VERSION_FALLBACK_INAPPROPRIATE.
   */
  constexpr impl::CustomDistributionMetric version_fallback_inappropriate(4401);
}

namespace ssl_handshake {
  /**
   * generated from ssl_handshake.completed
   * Type of handshake (1=resumption, 2=false started, 3=chose not to false start, 4=not allowed to false start)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_HANDSHAKE_TYPE.
   */
  constexpr impl::CustomDistributionMetric completed(4402);

  /**
   * generated from ssl_handshake.privacy
   * 0th bit - TLS13 used? 1th bit - Revocation Privacy, 2nd bit - DNS Privacy, 3rd bit - ECH Privacy
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_HANDSHAKE_PRIVACY.
   */
  constexpr impl::CustomDistributionMetric privacy(4403);

  /**
   * generated from ssl_handshake.result
   * SSL handshake result, 0=success, 1-255=NSS error offset, 256-511=SEC error offset + 256, 512-639=NSPR error offset + 512, 640-670=PKIX error, 671=unknown err
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_HANDSHAKE_RESULT.
   */
  constexpr impl::CustomDistributionMetric result(4404);

  /**
   * generated from ssl_handshake.result_conservative
   * SSL handshake result for conservative mode connections, 0=success, 1-255=NSS error offset, 256-511=SEC error offset + 256, 512-639=NSPR error offset + 512, 640-670=PKIX error, 671=unknown err
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_HANDSHAKE_RESULT_CONSERVATIVE.
   */
  constexpr impl::CustomDistributionMetric result_conservative(4405);

  /**
   * generated from ssl_handshake.result_ech
   * SSL handshake result for connections which used ECH 'Real', 0=success, 1-255=NSS error offset, 256-511=SEC error offset + 256, 512-639=NSPR error offset + 512, 640-670=PKIX error, 671=unknown err
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_HANDSHAKE_RESULT_ECH.
   */
  constexpr impl::CustomDistributionMetric result_ech(4406);

  /**
   * generated from ssl_handshake.result_ech_grease
   * SSL handshake result for connections which used ECH GREASE, 0=success, 1-255=NSS error offset, 256-511=SEC error offset + 256, 512-639=NSPR error offset + 512, 640-670=PKIX error, 671=unknown err
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_HANDSHAKE_RESULT_ECH_GREASE.
   */
  constexpr impl::CustomDistributionMetric result_ech_grease(4407);

  /**
   * generated from ssl_handshake.result_first_try
   * SSL handshake result for first-try connections, 0=success, 1-255=NSS error offset, 256-511=SEC error offset + 256, 512-639=NSPR error offset + 512, 640-670=PKIX error, 671=unknown err
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_HANDSHAKE_RESULT_FIRST_TRY.
   */
  constexpr impl::CustomDistributionMetric result_first_try(4408);

  /**
   * generated from ssl_handshake.version
   * Negotiated SSL Version (1=tls1, 2=tls1.1, 3=tls1.2, 4=tls1.3)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SSL_HANDSHAKE_VERSION.
   */
  constexpr impl::CustomDistributionMetric version(4409);
}

namespace tls {
  /**
   * generated from tls.certificate_verifications
   * The total number of successful TLS server certificate verifications.
   */
  constexpr impl::DenominatorMetric certificate_verifications(4410);

  /**
   * generated from tls.cipher_suite
   * Negotiated cipher suite in TLS handshake (see key in AccumulateCipherSuite in nsNSSCallbacks.cpp)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TLS_CIPHER_SUITE.
   */
  constexpr impl::CustomDistributionMetric cipher_suite(4411);

  /**
   * generated from tls.xyber_intolerance_reason
   */
  enum class XyberIntoleranceReasonLabel: uint16_t {
    ePrConnectResetError = 0,
    ePrEndOfFileError = 1,
    eSslErrorBadHandshakeHashValue = 2,
    eSslErrorBadMacAlert = 3,
    eSslErrorBadMacRead = 4,
    eSslErrorDecodeErrorAlert = 5,
    eSslErrorHandshakeFailed = 6,
    eSslErrorHandshakeFailureAlert = 7,
    eSslErrorHandshakeUnexpectedAlert = 8,
    eSslErrorIllegalParameterAlert = 9,
    eSslErrorInternalErrorAlert = 10,
    eSslErrorKeyExchangeFailure = 11,
    eSslErrorNoCypherOverlap = 12,
    eSslErrorProtocolVersionAlert = 13,
    eSslErrorRxUnexpectedRecordType = 14,
    eSslErrorRxMalformedHybridKeyShare = 15,
    eSslErrorUnsupportedVersion = 16,
    e__Other__,
  };
  /**
   * The error that was returned from a failed TLS 1.3 handshake in which the client sent a mlkem768x25519 key share (see tlsIntoleranceTelemetryBucket() in nsNSSIOLayer.cpp).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, XyberIntoleranceReasonLabel> xyber_intolerance_reason(4412);
}

namespace verification_used_cert_from {
  /**
   * generated from verification_used_cert_from.built_in_roots_module
   * How many successfully-built certificate chains used a certificate from the built-in roots module.
   */
  constexpr impl::NumeratorMetric built_in_roots_module(4413);

  /**
   * generated from verification_used_cert_from.nss_cert_db
   * How many successfully-built certificate chains used a certificate from the NSS cert DB.
   */
  constexpr impl::NumeratorMetric nss_cert_db(4414);

  /**
   * generated from verification_used_cert_from.preloaded_intermediates
   * How many successfully-built certificate chains used a certificate from preloaded intermediates.
   */
  constexpr impl::NumeratorMetric preloaded_intermediates(4415);

  /**
   * generated from verification_used_cert_from.third_party_certificates
   * How many successfully-built certificate chains used a third-party certificate from the OS.
   */
  constexpr impl::NumeratorMetric third_party_certificates(4416);

  /**
   * generated from verification_used_cert_from.tls_handshake
   * How many successfully-built certificate chains used a certificate from the TLS handshake.
   */
  constexpr impl::NumeratorMetric tls_handshake(4417);
}

} // namespace mozilla::glean

#endif // mozilla_GleanSecurityManagerSslMetrics_h
