// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanLayoutMetrics_h
#define mozilla_GleanLayoutMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace layout {
  /**
   * generated from layout.input_event_queued_click
   * Time (ms) for the mouse up/down event to dispatch, but before handlers executing.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram INPUT_EVENT_QUEUED_CLICK_MS.
   */
  constexpr impl::TimingDistributionMetric input_event_queued_click(4083);

  /**
   * generated from layout.input_event_queued_keyboard
   * Time (ms) for the keyboard event to dispatch, but before handlers executing.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram INPUT_EVENT_QUEUED_KEYBOARD_MS.
   */
  constexpr impl::TimingDistributionMetric input_event_queued_keyboard(4084);

  /**
   * generated from layout.input_event_response
   * Time (ms) from the Input event being created to the end of it being handled
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram INPUT_EVENT_RESPONSE_MS.
   */
  constexpr impl::TimingDistributionMetric input_event_response(4085);

  /**
   * generated from layout.input_event_response_coalesced
   * Time (ms) from the Input event being created to the end of it being handled, but with overlapping events coalesced.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram INPUT_EVENT_RESPONSE_COALESCED_MS.
   */
  constexpr impl::TimingDistributionMetric input_event_response_coalesced(4086);

  /**
   * generated from layout.load_input_event_response
   * Time (ms) from the Input event being created to the end of it being handled for events handling during page load only
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram LOAD_INPUT_EVENT_RESPONSE_MS.
   */
  constexpr impl::TimingDistributionMetric load_input_event_response(4087);

  /**
   * generated from layout.long_reflow_interruptible
   */
  enum class LongReflowInterruptibleLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Long running reflow, interruptible or not
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram LONG_REFLOW_INTERRUPTIBLE.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, LongReflowInterruptibleLabel> long_reflow_interruptible(4088);

  /**
   * generated from layout.paint_rasterize_time
   * Time spent rasterizing each frame in milliseconds
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PAINT_RASTERIZE_TIME.
   */
  constexpr impl::TimingDistributionMetric paint_rasterize_time(4089);

  /**
   * generated from layout.refresh_driver_chrome_frame_delay
   * Delay in ms between the target and the actual handling time of the frame at refresh driver in the chrome process.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_REFRESH_DRIVER_CHROME_FRAME_DELAY_MS.
   */
  constexpr impl::TimingDistributionMetric refresh_driver_chrome_frame_delay(4090);

  /**
   * generated from layout.refresh_driver_content_frame_delay
   * Delay in ms between the target and the actual handling time of the frame at refresh driver in the content process.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_REFRESH_DRIVER_CONTENT_FRAME_DELAY_MS.
   */
  constexpr impl::TimingDistributionMetric refresh_driver_content_frame_delay(4091);

  /**
   * generated from layout.refresh_driver_tick
   * Total time spent ticking the refresh driver in milliseconds
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram REFRESH_DRIVER_TICK.
   */
  constexpr impl::TimingDistributionMetric refresh_driver_tick(4092);

  /**
   * generated from layout.time_to_first_interaction
   * Time in milliseconds from the first non-blank paint to the creation time of the next click, key, mouse or scroll event per top-level content browsing context.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TIME_TO_FIRST_INTERACTION_MS.
   */
  constexpr impl::TimingDistributionMetric time_to_first_interaction(4093);
}

} // namespace mozilla::glean

#endif // mozilla_GleanLayoutMetrics_h
