// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomGeolocationMetrics_h
#define mozilla_GleanDomGeolocationMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace geolocation {
  /**
   * generated from geolocation.accuracy
   * Accuracy returned by the Geolocation API
   */
  constexpr impl::CustomDistributionMetric accuracy(3642);

  /**
   * generated from geolocation.fallback
   */
  enum class FallbackLabel: uint16_t {
    eNone = 0,
    eOnError = 1,
    eOnTimeout = 2,
    e__Other__,
  };
  /**
   * Whether the default provider falled back to NetworkGeolocationProvider.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, FallbackLabel> fallback(3643);

  /**
   * generated from geolocation.linux_provider
   */
  enum class LinuxProviderLabel: uint16_t {
    eNone = 0,
    ePortal = 1,
    eGeoclue = 2,
    e__Other__,
  };
  /**
   * Which system provider are we using on Linux
   */
  constexpr impl::Labeled<impl::BooleanMetric, LinuxProviderLabel> linux_provider(3644);

  /**
   * generated from geolocation.request_result
   */
  enum class RequestResultLabel: uint16_t {
    eSuccess = 0,
    ePermissionDenied = 1,
    ePositionUnavailable = 2,
    eTimeout = 3,
    e__Other__,
  };
  /**
   * The result for each geolocation request. Success label will only happen once for each request, even if it's a watch request.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, RequestResultLabel> request_result(3645);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomGeolocationMetrics_h
