#pragma once

#include "enum.h"
#include "tag-version.h"

/*
 * This file is auto-generated. See util/mon-gen.py and dat/mons.
 *
 * !!! DO NOT EDIT! !!!
 *
 * (It'll just be blown away on the next compile.)
 */

static monsterentry mondata[] =
{

// Use this to replace removed monsters, to retain save compatibility.
// Please put it in #if TAG_MAJOR_VERSION == X, so they will go away
// after save compat is broken.
#define AXED_MON(id, name) \
{ \
    id, 'X', LIGHTRED, "removed " name, \
    M_NO_EXP_GAIN | M_CANT_SPAWN | M_UNFINISHED, \
    MR_NO_FLAGS, \
    10, false, MONS_PROGRAM_BUG, MONS_PROGRAM_BUG, MH_NONLIVING, 0, \
    { }, \
    0, 0, \
    0, 0, MST_NO_SPELLS, true, S_SILENT, \
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY, \
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_MISC, GOD_NO_GOD, \
    {TILEP_MONS_PROGRAM_BUG}, TILE_ERROR \
},

// Axed monsters.
// AXED_MON(MONS_AXE_MURDERER, "Jason")
#if TAG_MAJOR_VERSION == 34
    AXED_MON(MONS_BUMBLEBEE, "bumblebee")
    AXED_MON(MONS_WOOD_GOLEM, "wood golem")
    AXED_MON(MONS_ANT_LARVA, "ant larva")
    AXED_MON(MONS_LABORATORY_RAT, "laboratory rat")
    AXED_MON(MONS_WAR_DOG, "war dog")
    AXED_MON(MONS_SPIRIT, "spirit")
    AXED_MON(MONS_PALADIN, "paladin")
    AXED_MON(MONS_DEEP_ELF_SOLDIER, "deep elf soldier")
    AXED_MON(MONS_PAN, "pan")
    AXED_MON(MONS_LAMIA, "lamia")
    AXED_MON(MONS_DEEP_DWARF_SCION, "deep dwarf scion")
    AXED_MON(MONS_DEEP_DWARF_ARTIFICER, "deep dwarf artificer")
    AXED_MON(MONS_DEEP_DWARF_NECROMANCER, "deep dwarf necromancer")
    AXED_MON(MONS_CHAOS_BUTTERFLY, "chaos butterfly")
    AXED_MON(MONS_POLYMOTH, "polymoth")
    AXED_MON(MONS_MOTH_OF_SUPPRESSION, "moth of suppression")
    AXED_MON(MONS_ROCK_WORM, "rock worm")
    AXED_MON(MONS_FORMICID_DRONE, "formicid drone")
    AXED_MON(MONS_SPIRIT_WOLF, "spirit wolf")
    AXED_MON(MONS_LAVA_FISH, "lava fish")
    AXED_MON(MONS_JELLYFISH, "jellyfish")
    AXED_MON(MONS_GREY_RAT, "grey rat")
    AXED_MON(MONS_SPINY_WORM, "spiny worm")
    AXED_MON(MONS_ROCK_TROLL, "rock troll")
    AXED_MON(MONS_MONSTROUS_ITEM_MIMIC, "monstrous item mimic")
    AXED_MON(MONS_GIANT_AMOEBA, "giant amoeba")
    AXED_MON(MONS_DEEP_DWARF_BERSERKER, "deep dwarf berserker")
    AXED_MON(MONS_AGATE_SNAIL, "agate snail")
    AXED_MON(MONS_GIANT_CENTIPEDE, "giant centipede")
    AXED_MON(MONS_ANCIENT_BEAR, "ancient bear")
    AXED_MON(MONS_ROTTING_DEVIL, "rotting devil")
    AXED_MON(MONS_IGNIS, "ignis")
    AXED_MON(MONS_RAKSHASA_FAKE, "rakshasa fake")
    AXED_MON(MONS_MARA_FAKE, "mara fake")
    // GNOME_NO_MORE
    AXED_MON(MONS_GNOME, "gnome")
    // GOLEM_NO_MORE
    AXED_MON(MONS_CLAY_GOLEM, "clay golem")
    AXED_MON(MONS_STONE_GOLEM, "stone golem")
    AXED_MON(MONS_FORMICID_VENOM_MAGE, "formicid venom mage")
    AXED_MON(MONS_SPRIGGAN_ASSASSIN, "spriggan assassin")
    AXED_MON(MONS_VAPOUR, "vapour")
    AXED_MON(MONS_THORN_LOTUS, "thorn lotus")
    AXED_MON(MONS_GIANT_GOLDFISH, "giant goldfish")
    AXED_MON(MONS_SILVER_STAR, "silver star")
    AXED_MON(MONS_FLAMING_CORPSE, "flaming corpse")
    AXED_MON(MONS_GRIZZLY_BEAR, "grizzly bear")
    AXED_MON(MONS_SPRIGGAN_ENCHANTER, "spriggan enchanter")
    AXED_MON(MONS_PHOENIX, "phoenix")
    AXED_MON(MONS_SHEDU, "shedu")
    AXED_MON(MONS_PLAGUE_SHAMBLER, "plague shambler")
    AXED_MON(MONS_GIANT_SLUG, "giant slug")
    AXED_MON(MONS_FIREFLY, "firefly")
    AXED_MON(MONS_BROWN_OOZE, "brown ooze")
    AXED_MON(MONS_PULSATING_LUMP, "pulsating lump")
    AXED_MON(MONS_BIG_FISH, "big fish")
    AXED_MON(MONS_LAVA_WORM, "lava worm")
    AXED_MON(MONS_SHARK, "shark")
    AXED_MON(MONS_INEPT_ITEM_MIMIC, "inept item mimic")
    AXED_MON(MONS_ITEM_MIMIC, "item mimic")
    AXED_MON(MONS_RAVENOUS_ITEM_MIMIC, "ravenous item mimic")
    AXED_MON(MONS_INEPT_FEATURE_MIMIC, "inept feature mimic")
    AXED_MON(MONS_FEATURE_MIMIC, "feature mimic")
    AXED_MON(MONS_RAVENOUS_FEATURE_MIMIC, "ravenous feature mimic")
    AXED_MON(MONS_MNOLEG_TENTACLE, "mnoleg tentacle")
    AXED_MON(MONS_MNOLEG_TENTACLE_SEGMENT, "mnoleg tentacle segment")
    AXED_MON(MONS_UNBORN, "unborn")
    AXED_MON(MONS_GIANT_MITE, "giant mite")
    AXED_MON(MONS_BABY_ALLIGATOR, "baby alligator")
    AXED_MON(MONS_BORING_BEETLE, "boring beetle")
    AXED_MON(MONS_CHIMERA, "chimera")
    AXED_MON(MONS_SINGULARITY, "singularity")
    AXED_MON(MONS_GRAND_AVATAR, "grand avatar")
    AXED_MON(MONS_SALAMANDER_FIREBRAND, "salamander firebrand")
    AXED_MON(MONS_OCTOPODE_CRUSHER, "octopode crusher")
    AXED_MON(MONS_BLUE_DEVIL, "blue devil")
    AXED_MON(MONS_DEEP_ELF_SUMMONER, "deep elf summoner")
    AXED_MON(MONS_DEEP_ELF_CONJURER, "deep elf conjurer")
    AXED_MON(MONS_DEEP_ELF_PRIEST, "deep elf priest")
    AXED_MON(MONS_DEEP_ELF_FIGHTER, "deep elf fighter")
    AXED_MON(MONS_TRAPDOOR_SPIDER, "trapdoor spider")
    AXED_MON(MONS_SALAMANDER_STORMCALLER, "salamander stormcaller")
    AXED_MON(MONS_MAUD, "maud")
    AXED_MON(MONS_SHEEP, "sheep")
    AXED_MON(MONS_ANUBIS_GUARD, "anubis guard")
    AXED_MON(MONS_GRIFFON, "griffon")
    AXED_MON(MONS_BEETLE, "beetle")
    AXED_MON(MONS_PUTRID_DEMONSPAWN, "putrid demonspawn")
    AXED_MON(MONS_CHAOS_CHAMPION, "chaos champion")
    AXED_MON(MONS_WASP, "wasp")
    AXED_MON(MONS_MOTTLED_DRACONIAN, "mottled draconian")
    AXED_MON(MONS_DRACONIAN_ZEALOT, "draconian zealot")
    AXED_MON(MONS_HILL_GIANT, "hill giant")
    AXED_MON(MONS_BULTUNGIN, "bultungin")
    AXED_MON(MONS_HYPERACTIVE_BALLISTOMYCETE, "hyperactive ballistomycete")
    AXED_MON(MONS_HOMUNCULUS, "homunculus")
    AXED_MON(MONS_SOUPLING, "soupling")
    AXED_MON(MONS_BLESSED_TOE, "blessed toe")
    AXED_MON(MONS_LAVA_ORC, "lava orc")
    AXED_MON(MONS_MONSTROUS_FEATURE_MIMIC, "monstrous feature mimic")
    AXED_MON(MONS_SLAVE, "slave")
    AXED_MON(MONS_HUNGRY_GHOST, "hungry ghost")
    AXED_MON(MONS_PORCUPINE, "porcupine")
    AXED_MON(MONS_CRAWLING_CORPSE, "crawling corpse")
    AXED_MON(MONS_MACABRE_MASS, "macabre mass")
    AXED_MON(MONS_EYE_OF_DRAINING, "eye of draining")
    AXED_MON(MONS_DEATH_OOZE, "death ooze")
    AXED_MON(MONS_LEOPARD_GECKO, "leopard gecko")
    AXED_MON(MONS_WORKER_ANT, "worker ant")
    AXED_MON(MONS_QUEEN_ANT, "queen ant")
    AXED_MON(MONS_SOLDIER_ANT, "soldier ant")
    AXED_MON(MONS_MONSTROUS_DEMONSPAWN, "monstrous demonspawn")
    AXED_MON(MONS_GELID_DEMONSPAWN, "gelid demonspawn")
    AXED_MON(MONS_INFERNAL_DEMONSPAWN, "infernal demonspawn")
    AXED_MON(MONS_TORTUROUS_DEMONSPAWN, "torturous demonspawn")
    AXED_MON(MONS_LOROCYPROCA, "lorocyproca")
    AXED_MON(MONS_ELECTROFERRIC_VORTEX, "electroferric vortex")
    AXED_MON(MONS_DEEP_DWARF, "deep dwarf")
    AXED_MON(MONS_ZOMBIE_SMALL, "small zombie")
    AXED_MON(MONS_ZOMBIE_LARGE, "large zombie")
    AXED_MON(MONS_SKELETON_SMALL, "small skeleton")
    AXED_MON(MONS_SKELETON_LARGE, "large skeleton")
    AXED_MON(MONS_SIMULACRUM_SMALL, "small simulacrum")
    AXED_MON(MONS_SIMULACRUM_LARGE, "large simulacrum")
    AXED_MON(MONS_MERGED_SLIME_CREATURE, "merged slime creature")
    AXED_MON(MONS_PSYCHE, "psyche")
    AXED_MON(MONS_GIANT_COCKROACH, "giant cockroach")
    AXED_MON(MONS_INSUBSTANTIAL_WISP, "insubstantial wisp")
#endif

// Real monsters begin here {dlb}:
{
    MONS_TEST_BLOB, 'J', WHITE, "test blob",
    M_FAST_REGEN | M_NO_POLY_TO | M_NO_THREAT,
    MR_NO_FLAGS,
    15, false, MONS_TEST_STATUE, MONS_TEST_STATUE, MH_NONLIVING, 20,
    {  },
    1000, 10000000,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_JELLY }, TILE_ERROR
},
{
    MONS_TEST_SPAWNER, 'X', WHITE, "test spawner",
    M_STATIONARY | M_INSUBSTANTIAL | M_FAST_REGEN | M_NO_POLY_TO,
    mrd(MR_RES_ELEC, 4) | mrd(MR_RES_FIRE, 4) | mrd(MR_RES_COLD, 4) | mrd(MR_RES_MIASMA, 4) | mrd(MR_RES_CORR, 4),
    15, false, MONS_TEST_SPAWNER, MONS_TEST_SPAWNER, MH_NONLIVING, WILL_INVULN,
    {  },
    1000, 10000000,
    127, 127, MST_TEST_SPAWNER, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 14, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_TEST_SPAWNER }, TILE_ERROR
},
{
    MONS_TEST_STATUE, 'X', WHITE, "test statue",
    M_STATIONARY | M_FAST_REGEN | M_NO_POLY_TO | M_NO_THREAT,
    MR_NO_FLAGS,
    15, false, MONS_TEST_STATUE, MONS_TEST_STATUE, MH_NONLIVING, 20,
    {  },
    1000, 10000000,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 14, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_TEST_SPAWNER }, TILE_ERROR
},
{
    MONS_ABOMINATION_LARGE, 'X', LIGHTRED, "large abomination",
    M_NO_FLAGS,
    MR_NO_FLAGS,
    710, false, MONS_ABOMINATION_SMALL, MONS_ABOMINATION_LARGE, MH_UNDEAD, 100,
    { {AT_HIT, AF_PLAIN, 32} },
    11, 495,
    11, 6, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_ABOMINATION_LARGE, TVARY_MOD }, TILE_ERROR
},
{
    MONS_ABOMINATION_SMALL, 'x', LIGHTRED, "small abomination",
    M_NO_FLAGS,
    MR_NO_FLAGS,
    163, false, MONS_ABOMINATION_SMALL, MONS_ABOMINATION_SMALL, MH_UNDEAD, 40,
    { {AT_HIT, AF_PLAIN, 17} },
    6, 270,
    6, 9, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_ABOMINATION_SMALL, TVARY_MOD }, TILE_ERROR
},
{
    MONS_ACID_BLOB, 'J', LIGHTCYAN, "acid blob",
    M_EAT_DOORS | M_SEE_INVIS | M_UNBLINDABLE | M_AMORPHOUS | M_ACID_SPLASH | M_NO_SKELETON,
    MR_RES_POISON | mrd(MR_RES_CORR, 3),
    1585, false, MONS_JELLY, MONS_ACID_BLOB, MH_NATURAL, 160,
    { {AT_HIT, AF_ACID, 42} },
    18, 990,
    1, 3, MST_ACID_SPIT, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_BLOB, GOD_NO_GOD,
    { TILEP_MONS_ACID_BLOB }, TILE_ERROR
},
{
    MONS_ACID_DRAGON, 'D', GREEN, "acid dragon",
    M_FLIES | M_WARM_BLOOD,
    MR_RES_POISON | MR_RES_CORR,
    155, false, MONS_DRAGON, MONS_ACID_DRAGON, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 15}, {AT_CLAW, AF_PLAIN, 6} },
    5, 275,
    5, 10, MST_ACID_DRAGON, true, S_ROAR,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_ACID_DRAGON }, TILE_CORPSE_ACID_DRAGON
},
{
    MONS_ADDER, 'S', LIGHTGREEN, "adder",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    13, false, MONS_SNAKE, MONS_ADDER, MH_NATURAL, 10,
    { {AT_BITE, AF_POISON, 4} },
    2, 110,
    1, 15, MST_NO_SPELLS, true, S_HISS,
    I_ANIMAL, HT_AMPHIBIOUS, 13, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_ADDER }, TILE_CORPSE_ADDER
},
{
    MONS_AGNES, 'i', LIGHTCYAN, "Agnes",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    1441, false, MONS_SPRIGGAN, MONS_SPRIGGAN, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 30} },
    11, 990,
    0, 20, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 18, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LITTLE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_AGNES }, TILE_ERROR
},
{
    MONS_AIR_ELEMENTAL, 'E', ETC_AIR, "air elemental",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    mrd(MR_RES_ELEC, 3),
    219, false, MONS_ELEMENTAL, MONS_AIR_ELEMENTAL, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 15} },
    6, 330,
    2, 18, MST_AIR_ELEMENTAL, false, S_SILENT,
    I_ANIMAL, HT_LAND, 25, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_AIR_ELEMENTAL }, TILE_ERROR
},
{
    MONS_AIZUL, 'S', LIGHTMAGENTA, "Aizul",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_RES_POISON,
    1374, false, MONS_GUARDIAN_SERPENT, MONS_GUARDIAN_SERPENT, MH_NATURAL, 120,
    { {AT_HIT, AF_PLAIN, 25} },
    14, 1400,
    8, 18, MST_AIZUL, true, S_SHOUT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_LARGE, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_AIZUL }, TILE_ERROR
},
{
    MONS_ALDERKING, 'f', CYAN, "alderking",
    M_SPEAKS,
    MR_RES_POISON | mrd(MR_RES_FIRE, -1),
    1978, false, MONS_ALDERKING, MONS_ALDERKING, MH_PLANT, 100,
    { {AT_HIT, AF_PLAIN, 50}, {AT_HIT, AF_PLAIN, 40} },
    17, 1250,
    16, 12, MST_ALDERKING, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_PLANT, GOD_NO_GOD,
    { TILEP_MONS_ALDERKING, TVARY_RANDOM }, TILE_ERROR
},
{
    MONS_ALLIGATOR_SNAPPING_TURTLE, 't', LIGHTGREEN, "alligator snapping turtle",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    834, false, MONS_SNAPPING_TURTLE, MONS_ALLIGATOR_SNAPPING_TURTLE, MH_NATURAL, 60,
    { {AT_BITE, AF_REACH, 50} },
    16, 1440,
    19, 1, MST_NO_SPELLS, true, S_HISS,
    I_ANIMAL, HT_AMPHIBIOUS, 8, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED_TAILLESS, GOD_NO_GOD,
    { TILEP_MONS_ALLIGATOR_SNAPPING_TURTLE }, TILE_CORPSE_ALLIGATOR_SNAPPING_TURTLE
},
{
    MONS_ALLIGATOR, 'l', LIGHTBLUE, "alligator",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    842, false, MONS_GIANT_LIZARD, MONS_ALLIGATOR, MH_NATURAL, 40,
    { {AT_TAIL_SLAP, AF_PLAIN, 14}, {AT_BITE, AF_DRAG, 27} },
    12, 620,
    4, 9, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS, 12, {10, 8, 10, 10, 10},
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_ALLIGATOR }, TILE_CORPSE_ALLIGATOR
},
{
    MONS_AMAEMON, '6', GREEN, "Amaemon",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    767, false, MONS_DEMONSPAWN, MONS_DEMONSPAWN, MH_NATURAL | MH_DEMONIC, 60,
    { {AT_HIT, AF_PLAIN, 12}, {AT_CLAW, AF_PLAIN, 12}, {AT_TAIL_SLAP, AF_POISON, 8} },
    7, 875,
    3, 12, MST_AMAEMON, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_AMAEMON }, TILE_ERROR
},
{
    MONS_ANACONDA, 'S', LIGHTGRAY, "anaconda",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    838, false, MONS_SNAKE, MONS_ANACONDA, MH_NATURAL, 40,
    { {AT_CONSTRICT, AF_CRUSH, 6}, {AT_BITE, AF_PLAIN, 20} },
    11, 605,
    4, 16, MST_NO_SPELLS, true, S_HISS,
    I_ANIMAL, HT_AMPHIBIOUS, 18, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_ANACONDA }, TILE_CORPSE_ANACONDA
},
{
    MONS_ANCESTOR_BATTLEMAGE, 'R', LIGHTCYAN, "battlemage",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL | M_FAST_REGEN | M_NO_POLY_TO | M_ANCESTOR | M_NO_GEN_DERIVED,
    MR_RES_FIRE | MR_RES_COLD,
    1, false, MONS_ANCESTOR, MONS_ANCESTOR_BATTLEMAGE, MH_NONLIVING, -5,
    { {AT_HIT, AF_PLAIN, 27} },
    1, 1,
    5, 10, MST_NO_SPELLS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ANCESTOR_BATTLEMAGE }, TILE_ERROR
},
{
    MONS_ANCESTOR_HEXER, 'R', LIGHTCYAN, "hexer",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL | M_FAST_REGEN | M_NO_POLY_TO | M_ANCESTOR | M_NO_GEN_DERIVED,
    MR_RES_FIRE | MR_RES_COLD,
    1, false, MONS_ANCESTOR, MONS_ANCESTOR_HEXER, MH_NONLIVING, -5,
    { {AT_HIT, AF_PLAIN, 27} },
    1, 1,
    5, 10, MST_NO_SPELLS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {10, 10, 5, 10, 10},
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ANCESTOR_HEXER }, TILE_ERROR
},
{
    MONS_ANCESTOR_KNIGHT, 'R', LIGHTCYAN, "knight",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL | M_FAST_REGEN | M_NO_POLY_TO | M_ANCESTOR | M_NO_GEN_DERIVED,
    MR_RES_FIRE | MR_RES_COLD,
    1, false, MONS_ANCESTOR, MONS_ANCESTOR_KNIGHT, MH_NONLIVING, -5,
    { {AT_HIT, AF_PLAIN, 27} },
    1, 1,
    5, 10, MST_NO_SPELLS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {10, 10, 15, 10, 10},
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ANCESTOR_KNIGHT }, TILE_ERROR
},
{
    MONS_ANCESTOR, 'R', LIGHTCYAN, "ancestor",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL | M_FAST_REGEN | M_NO_POLY_TO | M_ANCESTOR | M_NO_GEN_DERIVED,
    MR_RES_FIRE | MR_RES_COLD,
    1, false, MONS_ANCESTOR, MONS_ANCESTOR, MH_NONLIVING, -5,
    { {AT_HIT, AF_PLAIN, 27} },
    1, 1,
    5, 10, MST_NO_SPELLS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ANCESTOR }, TILE_ERROR
},
{
    MONS_ANCIENT_CHAMPION, 'z', LIGHTCYAN, "ancient champion",
    M_FIGHTER,
    MR_RES_COLD,
    1518, false, MONS_ANCIENT_CHAMPION, MONS_ANCIENT_CHAMPION, MH_UNDEAD, 120,
    { {AT_HIT, AF_PLAIN, 32} },
    14, 700,
    15, 10, MST_ANCIENT_CHAMPION, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ANCIENT_CHAMPION }, TILE_ERROR
},
{
    MONS_ANCIENT_LICH, 'L', WHITE, "ancient lich",
    M_SEE_INVIS | M_SPEAKS,
    MR_RES_ELEC | MR_RES_FIRE | mrd(MR_RES_COLD, 2),
    4693, false, MONS_LICH, MONS_LICH, MH_UNDEAD, WILL_INVULN,
    { {AT_TOUCH, AF_DRAIN, 20} },
    27, 1080,
    20, 10, MST_ANCIENT_LICH, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ANCIENT_LICH }, TILE_ERROR
},
{
    MONS_ANCIENT_ZYME, 'x', GREEN, "ancient zyme",
    M_FLIES,
    MR_NO_FLAGS,
    324, false, MONS_ANCIENT_ZYME, MONS_ANCIENT_ZYME, MH_NONLIVING, 60,
    { {AT_HIT, AF_PLAIN, 16}, {AT_HIT, AF_PLAIN, 16} },
    8, 520,
    6, 6, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_ANCIENT_ZYME }, TILE_ERROR
},
{
    MONS_ANGEL, 'A', WHITE, "angel",
    M_FLIES | M_FIGHTER | M_SPEAKS,
    MR_RES_ELEC | MR_RES_POISON,
    1155, false, MONS_ANGEL, MONS_ANGEL, MH_HOLY, 120,
    { {AT_HIT, AF_PLAIN, 25}, {AT_HIT, AF_PLAIN, 10} },
    12, 1020,
    10, 20, MST_ANGEL, false, S_SHOUT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_WINGED, GOD_SHINING_ONE,
    { TILEP_MONS_ANGEL }, TILE_ERROR
},
{
    MONS_ANIMATED_TREE, '7', ETC_TREE, "animated tree",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_ANIMATED_TREE, MONS_ANIMATED_TREE, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_TREANT }, TILE_ERROR
},
{
    MONS_ANTAEUS, 'C', WHITE, "Antaeus",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE | M_TALL_TILE,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 2),
    8877, false, MONS_GIANT, MONS_TITAN, MH_DEMONIC, WILL_INVULN,
    { {AT_HIT, AF_COLD, 75}, {AT_HIT, AF_COLD, 30} },
    22, 6820,
    28, 4, MST_ANTAEUS, false, S_DEMON_TAUNT,
    I_HUMAN, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ANTAEUS }, TILE_ERROR
},
{
    MONS_ANTIQUE_CHAMPION, 'z', BLUE, "antique champion",
    M_FIGHTER | M_SEE_INVIS,
    MR_RES_COLD,
    1518, false, MONS_ANCIENT_CHAMPION, MONS_ANCIENT_CHAMPION, MH_UNDEAD, 120,
    { {AT_HIT, AF_PLAIN, 30} },
    20, 820,
    18, 14, MST_ANTIQUE_CHAMPION, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ANTIQUE_CHAMPION }, TILE_ERROR
},
{
    MONS_APIS, 'Y', WHITE, "apis",
    M_WARM_BLOOD | M_HAS_AURA,
    MR_NO_FLAGS,
    1042, false, MONS_APIS, MONS_APIS, MH_HOLY, 100,
    { {AT_GORE, AF_HOLY, 44} },
    16, 960,
    9, 5, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED, GOD_ELYVILON,
    { TILEP_MONS_APIS }, TILE_CORPSE_APIS
},
{
    MONS_APOCALYPSE_CRAB, 't', WHITE, "apocalypse crab",
    M_SEE_INVIS | M_NO_SKELETON,
    mrd(MR_RES_POISON, -1) | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, 2),
    454, false, MONS_CRAB, MONS_APOCALYPSE_CRAB, MH_DEMONIC, 60,
    { {AT_BITE, AF_CHAOTIC, 14}, {AT_CLAW, AF_CHAOTIC, 14} },
    8, 480,
    11, 5, MST_APOCALYPSE_CRAB, true, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_APOCALYPSE_CRAB }, TILE_CORPSE_APOCALYPSE_CRAB
},
{
    MONS_ARACHNE, 'H', LIGHTCYAN, "Arachne",
    M_SEE_INVIS | M_SPEAKS | M_WEB_IMMUNE | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    3900, false, MONS_SPIDER, MONS_ARACHNE, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 30} },
    23, 2040,
    9, 12, MST_ARACHNE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_ARACHNID, GOD_NO_GOD,
    { TILEP_MONS_ARACHNE }, TILE_CORPSE_ARACHNE
},
{
    MONS_ARCANIST, 'p', LIGHTRED, "arcanist",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    695, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 6} },
    11, 460,
    0, 15, MST_ARCANIST, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ARCANIST }, TILE_ERROR
},
{
    MONS_ARMATAUR, 'H', YELLOW, "armataur",
    M_SPEAKS | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    400, false, MONS_ARMATAUR, MONS_ARMATAUR, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 18}, {AT_TAIL_SLAP, AF_PLAIN, 12} },
    8, 450,
    15, 5, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ARMATAUR }, TILE_CORPSE_ARMATAUR
},
{
    MONS_ARMOUR_ECHO, '[', GREEN, "armour echo",
    M_FLIES | M_UNBLINDABLE,
    MR_NO_FLAGS,
    800, false, MONS_ARMOUR_ECHO, MONS_ARMOUR_ECHO, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 1}, {AT_HIT, AF_PLAIN, 1} },
    15, 350,
    8, 5, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, {30, 30, 10, 10, 10},
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ARMOUR_ECHO }, TILE_ERROR
},
{
    MONS_ASMODEUS, '&', LIGHTRED, "Asmodeus",
    M_FLIES | M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_MALE | M_TALL_TILE | M_FIRE_RING,
    MR_RES_ELEC | MR_RES_POISON | mrd(MR_RES_FIRE, 3) | MR_RES_DAMNATION,
    8018, false, MONS_HELL_LORD, MONS_ASMODEUS, MH_DEMONIC, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 40} },
    17, 4505,
    30, 7, MST_ASMODEUS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ASMODEUS }, TILE_ERROR
},
{
    MONS_ASPIRING_FLESH, '*', ETC_RANDOM, "aspiring flesh",
    M_STATIONARY | M_FAST_REGEN | M_NO_SKELETON | M_NO_EXP_GAIN | M_NO_POLY_TO | M_NO_ZOMBIE | M_NO_GEN_DERIVED,
    MR_RES_POISON,
    0, false, MONS_ASPIRING_FLESH, MONS_ASPIRING_FLESH, MH_NATURAL, WILL_INVULN,
    {  },
    12, 1330,
    2, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_ASPIRING_FLESH }, TILE_ERROR
},
{
    MONS_ASTERION, 'H', LIGHTBLUE, "Asterion",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    1701, false, MONS_MINOTAUR, MONS_MINOTAUR, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 35}, {AT_GORE, AF_PLAIN, 20} },
    15, 1275,
    4, 4, MST_ASTERION, true, S_BELLOW,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_MAKHLEB,
    { TILEP_MONS_ASTERION }, TILE_ERROR
},
{
    MONS_AZRAEL, 'R', LIGHTRED, "Azrael",
    M_FLIES | M_SPEAKS | M_UNIQUE | M_MALE,
    MR_RES_POISON | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1) | MR_RES_DAMNATION,
    988, false, MONS_EFREET, MONS_EFREET, MH_DEMONIC, 40,
    { {AT_HIT, AF_PLAIN, 17} },
    11, 880,
    10, 5, MST_AZRAEL, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_AZRAEL }, TILE_ERROR
},
{
    MONS_AZURE_JELLY, 'J', LIGHTBLUE, "azure jelly",
    M_EAT_DOORS | M_SEE_INVIS | M_UNBLINDABLE | M_AMORPHOUS | M_NO_SKELETON,
    MR_RES_POISON | mrd(MR_RES_FIRE, -1) | MR_RES_COLD | mrd(MR_RES_CORR, 3),
    1317, false, MONS_JELLY, MONS_AZURE_JELLY, MH_NATURAL, 80,
    { {AT_HIT, AF_COLD, 12}, {AT_HIT, AF_COLD, 12}, {AT_HIT, AF_PLAIN, 12}, {AT_HIT, AF_PLAIN, 12} },
    15, 825,
    5, 10, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_BLOB, GOD_NO_GOD,
    { TILEP_MONS_AZURE_JELLY }, TILE_ERROR
},
{
    MONS_BAI_SUZHEN_DRAGON, 'D', ETC_ELECTRICITY, "Bai Suzhen",
    M_FLIES | M_SEE_INVIS | M_SPEAKS | M_COLD_BLOOD | M_UNIQUE | M_FEMALE | M_THUNDER_RING,
    mrd(MR_RES_ELEC, 3) | MR_RES_POISON | MR_RES_COLD,
    3094, false, MONS_DRAGON, MONS_STORM_DRAGON, MH_NATURAL, 100,
    { {AT_BITE, AF_PLAIN, 30}, {AT_CLAW, AF_PLAIN, 16}, {AT_TRAMPLE, AF_TRAMPLE, 16} },
    20, 2050,
    22, 4, MST_BAI_SUZHEN_DRAGON, false, S_LOUD_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_GIANT, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_BAI_SUZHEN_DRAGON }, TILE_ERROR
},
{
    MONS_BAI_SUZHEN, 'd', LIGHTBLUE, "Bai Suzhen",
    M_SEE_INVIS | M_SPEAKS | M_COLD_BLOOD | M_UNIQUE | M_FEMALE,
    mrd(MR_RES_ELEC, 3) | MR_RES_POISON | MR_RES_COLD,
    3094, false, MONS_DRAGON, MONS_STORM_DRAGON, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 24}, {AT_TAIL_SLAP, AF_PLAIN, 14} },
    20, 2050,
    14, 8, MST_BAI_SUZHEN, false, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_BAI_SUZHEN }, TILE_ERROR
},
{
    MONS_BALL_LIGHTNING, '*', LIGHTCYAN, "ball lightning",
    M_FLIES | M_INSUBSTANTIAL | M_NO_EXP_GAIN | M_PERIPHERAL | M_UNSTABLE,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, 3),
    20, false, MONS_BALL_LIGHTNING, MONS_BALL_LIGHTNING, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 5} },
    1, 10,
    0, 10, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 20, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_BALL_LIGHTNING }, TILE_ERROR
},
{
    MONS_BALL_PYTHON, 'S', GREEN, "ball python",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    1, false, MONS_SNAKE, MONS_BALL_PYTHON, MH_NATURAL, 0,
    { {AT_BITE, AF_PLAIN, 2}, {AT_CONSTRICT, AF_CRUSH, 1} },
    1, 35,
    0, 9, MST_NO_SPELLS, true, S_HISS,
    I_ANIMAL, HT_AMPHIBIOUS, 12, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_BALL_PYTHON }, TILE_CORPSE_BALL_PYTHON
},
{
    MONS_BALLISTOMYCETE_SPORE, '*', GREEN, "ballistomycete spore",
    M_FLIES | M_NO_EXP_GAIN | M_UNSTABLE | M_PERIPHERAL,
    MR_RES_POISON,
    10, false, MONS_FUNGUS, MONS_BALLISTOMYCETE_SPORE, MH_PLANT, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 1} },
    1, 10,
    0, 10, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_BALLISTOMYCETE_SPORE }, TILE_ERROR
},
{
    MONS_BALLISTOMYCETE, 'P', MAGENTA, "ballistomycete",
    M_STATIONARY,
    MR_RES_POISON,
    10, false, MONS_FUNGUS, MONS_BALLISTOMYCETE, MH_PLANT, WILL_INVULN,
    {  },
    4, 260,
    1, 0, MST_BALLISTOMYCETE, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_FUNGUS, GOD_NO_GOD,
    { TILEP_MONS_BALLISTOMYCETE }, TILE_ERROR
},
{
    MONS_BALRUG, '2', RED, "balrug",
    M_FLIES | M_FIGHTER | M_SEE_INVIS,
    MR_RES_POISON | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1),
    1202, false, MONS_BALRUG, MONS_BALRUG, MH_DEMONIC, 160,
    { {AT_HIT, AF_FIRE, 25} },
    14, 770,
    5, 12, MST_BALRUG, false, S_SHOUT,
    I_HUMAN, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_HUMANOID_WINGED, GOD_NO_GOD,
    { TILEP_MONS_BALRUG }, TILE_ERROR
},
{
    MONS_BARACHI, 'F', LIGHTCYAN, "barachi",
    M_SPEAKS | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    39, false, MONS_FROG, MONS_BARACHI, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 6} },
    3, 180,
    0, 10, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, {12, 12, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_BARACHI }, TILE_CORPSE_BARACHI
},
{
    MONS_BASILISK, 'l', MAGENTA, "basilisk",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    192, false, MONS_GIANT_LIZARD, MONS_BASILISK, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 20} },
    6, 360,
    3, 12, MST_BASILISK, true, S_HISS,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_BASILISK }, TILE_CORPSE_BASILISK
},
{
    MONS_BAT, 'b', LIGHTGRAY, "bat",
    M_FLIES | M_SEE_INVIS | M_UNBLINDABLE | M_BATTY | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1, false, MONS_BAT, MONS_BAT, MH_NATURAL, 0,
    { {AT_HIT, AF_PLAIN, 1} },
    1, 35,
    1, 14, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_LAND, 30, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_BAT, GOD_NO_GOD,
    { TILEP_MONS_BAT }, TILE_CORPSE_BAT
},
{
    MONS_BATTLESPHERE, '*', ETC_MAGIC, "battlesphere",
    M_FLIES | M_SEE_INVIS | M_UNBLINDABLE | M_INSUBSTANTIAL | M_NO_POLY_TO | M_MAINTAIN_RANGE | M_AVATAR,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, 2) | MR_RES_CORR,
    140, false, MONS_BATTLESPHERE, MONS_BATTLESPHERE, MH_NONLIVING, WILL_INVULN,
    {  },
    5, 150,
    0, 5, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 30, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_BATTLESPHERE }, TILE_ERROR
},
{
    MONS_BEAR, 'h', LIGHTGRAY, "bear",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_BEAR, MONS_BEAR, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, true, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_BLACK_BEAR }, TILE_ERROR
},
{
    MONS_BENNU, 'b', YELLOW, "bennu",
    M_FLIES | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_NO_POLY_TO,
    MR_RES_POISON | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_NEG, 3) | MR_RES_MIASMA,
    1011, false, MONS_BENNU, MONS_BENNU, MH_NATURAL, 140,
    { {AT_PECK, AF_HOLY, 46}, {AT_CLAW, AF_PLAIN, 36} },
    14, 770,
    6, 16, MST_NO_SPELLS, false, S_SCREECH,
    I_HUMAN, HT_LAND, 16, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_BIRD, GOD_NO_GOD,
    { TILEP_MONS_BENNU }, TILE_ERROR
},
{
    MONS_BES_KEMWAR, 'W', GREEN, "bes kemwar",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    MR_NO_FLAGS,
    65, false, MONS_BES_KEMWAR, MONS_BES_KEMWAR, MH_UNDEAD, 10,
    { {AT_BITE, AF_PLAIN, 7} },
    4, 240,
    5, 10, MST_BES_KEMWAR, false, S_SILENT,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_BES_KEMWAR }, TILE_ERROR
},
{
    MONS_BLACK_BEAR, 'h', BLUE, "black bear",
    M_WARM_BLOOD,
    MR_NO_FLAGS,
    128, false, MONS_BEAR, MONS_BLACK_BEAR, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 9}, {AT_CLAW, AF_PLAIN, 5}, {AT_CLAW, AF_PLAIN, 5} },
    6, 270,
    2, 8, MST_BEAR, true, S_GROWL,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_QUADRUPED_TAILLESS, GOD_NO_GOD,
    { TILEP_MONS_BLACK_BEAR }, TILE_CORPSE_BLACK_BEAR
},
{
    MONS_BLACK_DRACONIAN, 'd', BLUE, "black draconian",
    M_FLIES | M_SPEAKS | M_COLD_BLOOD,
    mrd(MR_RES_ELEC, 3),
    1019, false, MONS_DRACONIAN, MONS_BLACK_DRACONIAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 20} },
    14, 980,
    9, 10, MST_NO_SPELLS, true, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_WINGED_TAILED, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_CORPSE_BLACK_DRACONIAN
},
{
    MONS_BLACK_MAMBA, 'S', BLUE, "black mamba",
    M_COLD_BLOOD,
    MR_RES_POISON,
    456, false, MONS_SNAKE, MONS_BLACK_MAMBA, MH_NATURAL, 20,
    { {AT_BITE, AF_POISON, 20} },
    7, 385,
    4, 15, MST_NO_SPELLS, true, S_HISS,
    I_ANIMAL, HT_LAND, 18, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_BLACK_MAMBA }, TILE_CORPSE_BLACK_MAMBA
},
{
    MONS_BLAZEHEART_CORE, '*', LIGHTRED, "blazeheart core",
    M_INSUBSTANTIAL | M_STATIONARY | M_NO_EXP_GAIN | M_UNSTABLE | M_PERIPHERAL,
    mrd(MR_RES_FIRE, 3),
    60, false, MONS_BLAZEHEART_CORE, MONS_BLAZEHEART_CORE, MH_NONLIVING, 10,
    {  },
    15, 50000,
    0, 99, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_BLAZEHEART_CORE }, TILE_ERROR
},
{
    MONS_BLAZEHEART_GOLEM, '9', MAGENTA, "blazeheart golem",
    M_FIGHTER,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 2) | MR_RES_COLD,
    140, false, MONS_GOLEM, MONS_BLAZEHEART_GOLEM, MH_NONLIVING, WILL_INVULN,
    { {AT_PUNCH, AF_PLAIN, 27} },
    6, 400,
    9, 2, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, {10, 10, 20, 10, 10},
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_BLAZEHEART_GOLEM }, TILE_ERROR
},
{
    MONS_BLINK_FROG, 'F', LIGHTGREEN, "blink frog",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    264, false, MONS_FROG, MONS_BLINK_FROG, MH_NATURAL, 40,
    { {AT_HIT, AF_BLINK, 20} },
    6, 330,
    0, 16, MST_BLINKER, true, S_CROAK,
    I_ANIMAL, HT_AMPHIBIOUS, 14, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_QUADRUPED_TAILLESS, GOD_NO_GOD,
    { TILEP_MONS_BLINK_FROG }, TILE_CORPSE_BLINK_FROG
},
{
    MONS_BLIZZARD_DEMON, '2', LIGHTBLUE, "blizzard demon",
    M_FLIES | M_INSUBSTANTIAL | M_SEE_INVIS,
    mrd(MR_RES_ELEC, 3) | MR_RES_POISON | mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 2),
    935, false, MONS_BLIZZARD_DEMON, MONS_BLIZZARD_DEMON, MH_DEMONIC, 140,
    { {AT_HIT, AF_PLAIN, 20}, {AT_HIT, AF_PLAIN, 20} },
    12, 660,
    10, 10, MST_BLIZZARD_DEMON, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_BLIZZARD_DEMON }, TILE_ERROR
},
{
    MONS_BLOATED_HUSK, 'n', YELLOW, "bloated husk",
    M_NO_ZOMBIE,
    MR_RES_COLD,
    299, false, MONS_GHOUL, MONS_BLOATED_HUSK, MH_UNDEAD, 40,
    { {AT_HIT, AF_PLAIN, 1} },
    8, 250,
    5, 5, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_AMPHIBIOUS, 14, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_BLOATED_HUSK }, TILE_ERROR
},
{
    MONS_BLOCK_OF_ICE, 'I', ETC_ICE, "block of ice",
    M_STATIONARY | M_NO_EXP_GAIN | M_REMNANT | M_NO_THREAT,
    mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 3),
    10, false, MONS_BLOCK_OF_ICE, MONS_BLOCK_OF_ICE, MH_NONLIVING, WILL_INVULN,
    {  },
    3, 285,
    15, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_BLOCK_OF_ICE, TVARY_MOD }, TILE_ERROR
},
{
    MONS_BLORKULA_THE_ORCULA, 'o', BROWN, "Blorkula the orcula",
    M_SPEAKS | M_SEE_INVIS | M_WARM_BLOOD | M_UNIQUE | M_MALE | M_NO_ZOMBIE,
    MR_RES_COLD,
    224, false, MONS_ORC, MONS_ORC, MH_UNDEAD, 20,
    { {AT_HIT, AF_PLAIN, 8}, {AT_BITE, AF_VAMPIRIC, 6} },
    5, 315,
    0, 9, MST_BLORKULA, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_BLORKULA_THE_ORCULA }, TILE_ERROR
},
{
    MONS_BOG_BODY, 'n', GREEN, "bog body",
    M_NO_ZOMBIE,
    MR_RES_FIRE | MR_RES_COLD,
    684, false, MONS_GHOUL, MONS_BOG_BODY, MH_UNDEAD, 40,
    { {AT_TOUCH, AF_COLD, 20} },
    10, 390,
    1, 9, MST_BOG_BODY, true, S_SILENT,
    I_HUMAN, HT_AMPHIBIOUS, 10, {10, 14, 10, 10, 10},
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_BOG_BODY }, TILE_CORPSE_BOG_BODY
},
{
    MONS_BOGGART, 'g', MAGENTA, "boggart",
    M_SEE_INVIS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    117, false, MONS_BOGGART, MONS_BOGGART, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 5} },
    4, 200,
    0, 12, MST_BOGGART, false, S_SHOUT,
    I_HUMAN, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LITTLE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_BOGGART }, TILE_ERROR
},
{
    MONS_BOMBARDIER_BEETLE, 'B', LIGHTBLUE, "bombardier beetle",
    M_NO_SKELETON,
    mrd(MR_RES_POISON, -1),
    46, false, MONS_BOMBARDIER_BEETLE, MONS_BOMBARDIER_BEETLE, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 5} },
    2, 170,
    4, 7, MST_BOMBARDIER_BEETLE, true, S_SILENT,
    I_ANIMAL, HT_LAND, 6, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_INSECT, GOD_NO_GOD,
    { TILEP_MONS_BOMBARDIER_BEETLE }, TILE_CORPSE_BOMBARDIER_BEETLE
},
{
    MONS_BOMBLET, '*', LIGHTRED, "bomblet",
    M_FLIES | M_PERIPHERAL,
    mrd(MR_RES_FIRE, 3),
    40, false, MONS_BOMBLET, MONS_BOMBLET, MH_NONLIVING, WILL_INVULN,
    {  },
    10, 150,
    5, 17, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_BOMBLET }, TILE_ERROR
},
{
    MONS_BONE_DRAGON, 'D', LIGHTGRAY, "bone dragon",
    M_FLIES | M_SEE_INVIS,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    2215, false, MONS_DRAGON, MONS_BONE_DRAGON, MH_UNDEAD, 100,
    { {AT_BITE, AF_PLAIN, 30}, {AT_CLAW, AF_PLAIN, 20}, {AT_TRAMPLE, AF_TRAMPLE, 20} },
    20, 1540,
    18, 2, MST_BONE_DRAGON, false, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_BONE_DRAGON }, TILE_ERROR
},
{
    MONS_BORIS, 'L', RED, "Boris",
    M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_MALE,
    MR_RES_ELEC | mrd(MR_RES_COLD, 2),
    1696, false, MONS_LICH, MONS_LICH, MH_UNDEAD, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 25}, {AT_TOUCH, AF_DRAIN, 15} },
    22, 1540,
    12, 10, MST_BORIS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_BORIS }, TILE_ERROR
},
{
    MONS_BOULDER_BEETLE, 'B', LIGHTGRAY, "boulder beetle",
    M_WEB_IMMUNE | M_NO_SKELETON,
    mrd(MR_RES_POISON, -1),
    828, false, MONS_BOULDER_BEETLE, MONS_BOULDER_BEETLE, MH_NATURAL, 40,
    { {AT_BITE, AF_PLAIN, 27} },
    12, 765,
    20, 2, MST_BOULDER_BEETLE, true, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_INSECT, GOD_NO_GOD,
    { TILEP_MONS_BOULDER_BEETLE }, TILE_CORPSE_BOULDER_BEETLE
},
{
    MONS_BOULDER, '*', BROWN, "boulder",
    M_NO_EXP_GAIN | M_NO_POLY_TO | M_PERIPHERAL | M_UNSTABLE,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD | MR_RES_PETRIFY,
    0, false, MONS_BOULDER, MONS_BOULDER, MH_NONLIVING, WILL_INVULN,
    {  },
    10, 270,
    10, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 20, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_BOULDER, TVARY_CYCLE }, TILE_ERROR
},
{
    MONS_BOUND_SOUL, 'Z', LIGHTRED, "bound soul",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL | M_FAST_REGEN,
    MR_RES_COLD,
    10, false, MONS_WRAITH, MONS_SPECTRAL_THING, MH_UNDEAD, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 20} },
    8, 440,
    8, 5, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 7, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_SPECTRAL_LARGE }, TILE_ERROR
},
{
    MONS_BOUNDLESS_TESSERACT, 'I', ETC_ORB_GLOW, "boundless tesseract",
    M_SEE_INVIS | M_SPEAKS | M_STATIONARY | M_INSUBSTANTIAL | M_FAST_REGEN,
    MR_NO_FLAGS,
    1000, false, MONS_BOUNDLESS_TESSERACT, MONS_BOUNDLESS_TESSERACT, MH_NONLIVING, WILL_INVULN,
    {  },
    30, 2100,
    10, 1, MST_BOUNDLESS_TESSERACT, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_BOUNDLESS_TESSERACT, TVARY_CYCLE }, TILE_ERROR
},
{
    MONS_BRAIN_WORM, 'w', LIGHTMAGENTA, "brain worm",
    M_FAST_REGEN | M_NO_SKELETON,
    MR_NO_FLAGS,
    92, false, MONS_RIBBON_WORM, MONS_BRAIN_WORM, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 6} },
    5, 200,
    1, 5, MST_BRAIN_WORM, true, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_BRAIN_WORM }, TILE_CORPSE_BRAIN_WORM
},
{
    MONS_BRIAR_PATCH, 'P', YELLOW, "briar patch",
    M_STATIONARY | M_NO_EXP_GAIN | M_SPINY | M_NO_THREAT,
    MR_RES_POISON | mrd(MR_RES_FIRE, -1),
    10, false, MONS_PLANT, MONS_BRIAR_PATCH, MH_PLANT, WILL_INVULN,
    {  },
    10, 150,
    10, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_PLANT, GOD_NO_GOD,
    { TILEP_MONS_BRIAR_PATCH }, TILE_ERROR
},
{
    MONS_BRIMSTONE_FIEND, '1', LIGHTRED, "Brimstone Fiend",
    M_FLIES | M_SEE_INVIS,
    MR_RES_POISON | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1) | MR_RES_DAMNATION,
    2027, false, MONS_BRIMSTONE_FIEND, MONS_BRIMSTONE_FIEND, MH_DEMONIC, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 25}, {AT_HIT, AF_PLAIN, 15}, {AT_HIT, AF_PLAIN, 15} },
    18, 990,
    15, 6, MST_BRIMSTONE_FIEND, false, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID_WINGED, GOD_NO_GOD,
    { TILEP_MONS_BRIMSTONE_FIEND }, TILE_ERROR
},
{
    MONS_BROODMOTHER, 's', LIGHTCYAN, "broodmother",
    M_WEB_IMMUNE | M_NO_SKELETON,
    MR_NO_FLAGS,
    1104, false, MONS_SPIDER, MONS_BROODMOTHER, MH_NATURAL, 60,
    { {AT_BITE, AF_SPIDER, 40} },
    12, 1400,
    2, 4, MST_BROODMOTHER, true, S_SKITTER,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_ARACHNID, GOD_NO_GOD,
    { TILEP_MONS_BROODMOTHER }, TILE_CORPSE_BROODMOTHER
},
{
    MONS_BULLFROG, 'F', GREEN, "bullfrog",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    90, false, MONS_FROG, MONS_BULLFROG, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 9} },
    4, 220,
    0, 12, MST_NO_SPELLS, true, S_CROAK,
    I_ANIMAL, HT_AMPHIBIOUS, 15, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_QUADRUPED_TAILLESS, GOD_NO_GOD,
    { TILEP_MONS_BULLFROG }, TILE_CORPSE_BULLFROG
},
{
    MONS_BUNYIP, 'x', YELLOW, "bunyip",
    M_WARM_BLOOD,
    MR_RES_POISON,
    992, false, MONS_BUNYIP, MONS_BUNYIP, MH_NATURAL, 60,
    { {AT_CLAW, AF_PLAIN, 40}, {AT_CLAW, AF_PLAIN, 40}, {AT_CLAW, AF_PLAIN, 40} },
    12, 800,
    6, 10, MST_BUNYIP, true, S_SCREAM,
    I_ANIMAL, HT_AMPHIBIOUS, 15, {10, 10, 45, 10, 10},
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_BUNYIP }, TILE_CORPSE_BUNYIP
},
{
    MONS_BURIAL_ACOLYTE, 'p', LIGHTCYAN, "burial acolyte",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    72, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 4} },
    4, 190,
    0, 13, MST_BURIAL_ACOLYTE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_KIKUBAAQUDGHA,
    { TILEP_MONS_BURIAL_ACOLYTE }, TILE_ERROR
},
{
    MONS_BUSH, 'P', BROWN, "bush",
    M_STATIONARY | M_NO_EXP_GAIN | M_NO_THREAT,
    MR_RES_POISON | mrd(MR_RES_FIRE, -1),
    10, false, MONS_PLANT, MONS_BUSH, MH_PLANT, WILL_INVULN,
    {  },
    20, 1100,
    15, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_PLANT, GOD_NO_GOD,
    { TILEP_MONS_BUSH, TVARY_MOD }, TILE_ERROR
},
{
    MONS_BUTTERFLY, 'b', ETC_JEWEL, "butterfly",
    M_FLIES | M_CONFUSED | M_NO_SKELETON | M_NO_EXP_GAIN | M_NO_THREAT,
    mrd(MR_RES_POISON, -1),
    10, false, MONS_BUTTERFLY, MONS_BUTTERFLY, MH_NATURAL, 0,
    {  },
    1, 10,
    0, 20, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 25, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_INSECT_WINGED, GOD_NO_GOD,
    { TILEP_MONS_BUTTERFLY, TVARY_MOD }, TILE_ERROR
},
{
    MONS_CACODEMON, '2', YELLOW, "cacodemon",
    M_FLIES | M_SEE_INVIS,
    MR_RES_ELEC | MR_RES_POISON,
    1139, false, MONS_CACODEMON, MONS_CACODEMON, MH_DEMONIC, 160,
    { {AT_HIT, AF_VULN, 22}, {AT_HIT, AF_VULN, 22} },
    13, 975,
    11, 10, MST_CACODEMON, false, S_LAUGH,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_CACODEMON }, TILE_ERROR
},
{
    MONS_CACTUS_GIANT, 'C', GREEN, "cactus giant",
    M_SPINY | M_NO_POLY_TO,
    MR_RES_POISON,
    600, false, MONS_GIANT, MONS_CACTUS_GIANT, MH_PLANT, 60,
    { {AT_HIT, AF_PLAIN, 10} },
    9, 495,
    1, 2, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, {10, 10, 30, 10, 10},
    MONUSE_STARTING_EQUIPMENT, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_CACTUS_GIANT }, TILE_ERROR
},
{
    MONS_CANE_TOAD, 'F', YELLOW, "cane toad",
    M_COLD_BLOOD,
    MR_RES_POISON,
    407, false, MONS_FROG, MONS_CANE_TOAD, MH_NATURAL, 20,
    { {AT_STING, AF_POISON, 26} },
    7, 385,
    6, 9, MST_NO_SPELLS, true, S_CROAK,
    I_ANIMAL, HT_AMPHIBIOUS, 12, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_QUADRUPED_TAILLESS, GOD_NO_GOD,
    { TILEP_MONS_CANE_TOAD }, TILE_CORPSE_CANE_TOAD
},
{
    MONS_CASSANDRA, '@', LIGHTMAGENTA, "Cassandra",
    M_SPEAKS | M_SEE_INVIS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE | M_PRIEST,
    MR_NO_FLAGS,
    350, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 8} },
    7, 430,
    0, 11, MST_CASSANDRA, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_ASHENZARI,
    { TILEP_MONS_CASSANDRA }, TILE_ERROR
},
{
    MONS_CATOBLEPAS, 'Y', MAGENTA, "catoblepas",
    M_WARM_BLOOD,
    MR_RES_PETRIFY,
    843, false, MONS_YAK, MONS_CATOBLEPAS, MH_NATURAL, 100,
    { {AT_GORE, AF_PLAIN, 36} },
    14, 770,
    10, 2, MST_CATOBLEPAS, true, S_BELLOW,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_CATOBLEPAS }, TILE_CORPSE_CATOBLEPAS
},
{
    MONS_CAUSTIC_SHRIKE, 'b', LIGHTGREEN, "caustic shrike",
    M_FLIES | M_WARM_BLOOD,
    MR_RES_FIRE | MR_RES_COLD,
    2676, false, MONS_CAUSTIC_SHRIKE, MONS_CAUSTIC_SHRIKE, MH_NATURAL, 80,
    { {AT_CLAW, AF_ACID, 36} },
    18, 1080,
    8, 18, MST_NO_SPELLS, true, S_SCREECH,
    I_ANIMAL, HT_LAND, 20, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_BIRD, GOD_NO_GOD,
    { TILEP_MONS_CAUSTIC_SHRIKE }, TILE_CORPSE_CAUSTIC_SHRIKE
},
{
    MONS_CENTAUR_WARRIOR, 'c', YELLOW, "centaur warrior",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD | M_ARCHER,
    MR_NO_FLAGS,
    836, false, MONS_CENTAUR, MONS_CENTAUR, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 16}, {AT_KICK, AF_PLAIN, 5} },
    10, 550,
    4, 8, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_CENTAUR, GOD_NO_GOD,
    { TILEP_MONS_CENTAUR_WARRIOR }, TILE_ERROR
},
{
    MONS_CENTAUR, 'c', BROWN, "centaur",
    M_SPEAKS | M_WARM_BLOOD | M_ARCHER,
    MR_NO_FLAGS,
    112, false, MONS_CENTAUR, MONS_CENTAUR, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 7}, {AT_KICK, AF_PLAIN, 3} },
    4, 220,
    3, 7, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_CENTAUR, GOD_NO_GOD,
    { TILEP_MONS_CENTAUR }, TILE_CORPSE_CENTAUR
},
{
    MONS_CEREBOV, '&', RED, "Cerebov",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_TALL_TILE | M_GENDER_NEUTRAL,
    MR_RES_POISON | mrd(MR_RES_FIRE, 3) | MR_RES_DAMNATION,
    9999, false, MONS_PANDEMONIUM_LORD, MONS_CEREBOV, MH_DEMONIC, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 60} },
    21, 6510,
    30, 8, MST_CEREBOV, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_CEREBOV }, TILE_ERROR
},
{
    MONS_CERULEAN_IMP, '5', LIGHTBLUE, "cerulean imp",
    M_FLIES | M_SPEAKS,
    MR_RES_ELEC | MR_RES_POISON,
    13, false, MONS_CERULEAN_IMP, MONS_CERULEAN_IMP, MH_DEMONIC, 40,
    { {AT_HIT, AF_PLAIN, 1} },
    3, 135,
    3, 14, MST_NO_SPELLS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {7, 7, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LITTLE, MON_SHAPE_HUMANOID_WINGED, GOD_NO_GOD,
    { TILEP_MONS_CERULEAN_IMP }, TILE_ERROR
},
{
    MONS_CHAOS_SPAWN, '4', ETC_RANDOM, "chaos spawn",
    M_NO_FLAGS,
    MR_NO_FLAGS,
    172, false, MONS_CHAOS_SPAWN, MONS_CHAOS_SPAWN, MH_DEMONIC, 60,
    { {AT_RANDOM, AF_CHAOTIC, 19} },
    6, 300,
    4, 12, MST_NO_SPELLS, false, S_RANDOM,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_CHAOS_SPAWN, TVARY_RANDOM }, TILE_ERROR
},
{
    MONS_CHERUB, 'A', LIGHTBLUE, "cherub",
    M_FLIES | M_FIGHTER | M_SPEAKS | M_ARCHER,
    MR_RES_ELEC | MR_RES_POISON | MR_RES_FIRE,
    742, false, MONS_ANGEL, MONS_CHERUB, MH_HOLY, 100,
    { {AT_HIT, AF_PLAIN, 15}, {AT_CHERUB, AF_PLAIN, 8} },
    9, 765,
    10, 20, MST_BATTLECRY, false, S_CHERUB,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_WINGED, GOD_NO_GOD,
    { TILEP_MONS_CHERUB }, TILE_ERROR
},
{
    MONS_CHONCHON, 'x', LIGHTGREEN, "chonchon",
    M_FLIES | M_BATTY | M_WARM_BLOOD | M_NO_POLY_TO,
    MR_NO_FLAGS,
    1250, false, MONS_CHONCHON, MONS_CHONCHON, MH_NATURAL, 60,
    { {AT_HEADBUTT, AF_CHAOTIC, 32}, {AT_BITE, AF_VAMPIRIC, 28} },
    14, 630,
    6, 16, MST_CHONCHON, true, S_SCREECH,
    I_HUMAN, HT_LAND, 20, {10, 10, 10, 10, 20},
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_CHONCHON, TVARY_RANDOM }, TILE_CORPSE_CHONCHON
},
{
    MONS_CHUCK, 'C', WHITE, "Chuck",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    1460, false, MONS_GIANT, MONS_STONE_GIANT, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 45} },
    18, 1170,
    14, 2, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_CHUCK }, TILE_ERROR
},
{
    MONS_CLOCKROACH, 'B', BROWN, "clockroach",
    M_WARDED | M_NO_SKELETON,
    mrd(MR_RES_POISON, -1),
    37, false, MONS_CLOCKROACH, MONS_CLOCKROACH, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 4} },
    1, 110,
    3, 10, MST_CLOCKROACH, true, S_SILENT,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_INSECT, GOD_NO_GOD,
    { TILEP_MONS_CLOCKROACH }, TILE_CORPSE_CLOCKROACH
},
{
    MONS_CLOCKWORK_BEE_INACTIVE, '*', CYAN, "dormant clockwork bee",
    M_STATIONARY,
    MR_RES_FIRE | MR_RES_ELEC,
    10, false, MONS_KILLER_BEE, MONS_CLOCKWORK_BEE_INACTIVE, MH_NONLIVING, WILL_INVULN,
    {  },
    5, 260,
    13, 0, MST_NO_SPELLS, false, S_BUZZ,
    I_BRAINLESS, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_INSECT_WINGED, GOD_NO_GOD,
    { TILEP_MONS_CLOCKWORK_BEE_INACTIVE }, TILE_ERROR
},
{
    MONS_CLOCKWORK_BEE, 'y', LIGHTCYAN, "clockwork bee",
    M_FLIES,
    MR_RES_FIRE | MR_RES_ELEC,
    80, false, MONS_KILLER_BEE, MONS_CLOCKWORK_BEE, MH_NONLIVING, WILL_INVULN,
    { {AT_STING, AF_PLAIN, 13} },
    5, 280,
    6, 16, MST_NO_SPELLS, false, S_BUZZ,
    I_BRAINLESS, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_INSECT_WINGED, GOD_NO_GOD,
    { TILEP_MONS_CLOCKWORK_BEE }, TILE_ERROR
},
{
    MONS_CLOUD_MAGE, '@', ETC_SILVER, "Cloud Mage",
    M_FLIES | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1937, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 6} },
    20, 1500,
    0, 13, MST_CLOUD_MAGE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_CLOUD_MAGE }, TILE_ERROR
},
{
    MONS_COGNITOGAUNT, 'n', MAGENTA, "cognitogaunt",
    M_SEE_INVIS | M_NO_ZOMBIE | M_SPEAKS,
    MR_RES_COLD,
    963, false, MONS_COGNITOGAUNT, MONS_COGNITOGAUNT, MH_UNDEAD, 80,
    { {AT_CLAW, AF_CONFUSE, 28}, {AT_TOUCH, AF_PAIN, 22} },
    14, 780,
    6, 16, MST_COGNITOGAUNT, true, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_COGNITOGAUNT }, TILE_CORPSE_COGNITOGAUNT
},
{
    MONS_CRAB, 't', LIGHTGRAY, "crab",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_CRAB, MONS_CRAB, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, true, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_FIRE_CRAB }, TILE_ERROR
},
{
    MONS_CRAWLING_FLESH_CAGE, 'x', LIGHTBLUE, "crawling flesh cage",
    M_WARM_BLOOD | M_HERD | M_NO_POLY_TO | M_NO_SKELETON | M_NO_ZOMBIE | M_NO_GEN_DERIVED,
    MR_RES_ELEC | MR_RES_POISON | MR_RES_FIRE | MR_RES_COLD | MR_RES_CORR,
    755, false, MONS_CRAWLING_FLESH_CAGE, MONS_CRAWLING_FLESH_CAGE, MH_NATURAL, 60,
    { {AT_TENTACLE_SLAP, AF_REACH_CLEAVE_UGLY, 24} },
    15, 900,
    16, 4, MST_NO_SPELLS, false, S_GURGLE,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_CRAWLING_FLESH_CAGE, TVARY_MOD }, TILE_ERROR
},
{
    MONS_CRAZY_YIUF, 'j', COLOUR_UNDEF, "Crazy Yiuf",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    41, false, MONS_GNOLL, MONS_GNOLL, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 9} },
    3, 195,
    2, 9, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_XOM,
    { TILEP_MONS_CRAZY_YIUF }, TILE_ERROR
},
{
    MONS_CREEPING_INFERNO, '*', LIGHTRED, "creeping inferno",
    M_FLIES | M_INSUBSTANTIAL | M_PERIPHERAL,
    mrd(MR_RES_FIRE, 3),
    3, false, MONS_CREEPING_INFERNO, MONS_CREEPING_INFERNO, MH_NONLIVING, 60,
    { {AT_HIT, AF_PLAIN, 1} },
    15, 1110,
    0, 10, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_CREEPING_INFERNO, TVARY_CYCLE }, TILE_ERROR
},
{
    MONS_CRIMSON_IMP, '5', RED, "crimson imp",
    M_FLIES | M_SPEAKS | M_FAST_REGEN,
    MR_RES_POISON | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1),
    49, false, MONS_CRIMSON_IMP, MONS_CRIMSON_IMP, MH_DEMONIC, 40,
    { {AT_HIT, AF_PLAIN, 4} },
    3, 135,
    3, 14, MST_BLINKER, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LITTLE, MON_SHAPE_HUMANOID_WINGED, GOD_NO_GOD,
    { TILEP_MONS_CRIMSON_IMP }, TILE_ERROR
},
{
    MONS_CROCODILE, 'l', BROWN, "crocodile",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    120, false, MONS_CROCODILE, MONS_CROCODILE, MH_NATURAL, 20,
    { {AT_BITE, AF_DRAG, 15} },
    6, 360,
    4, 12, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS, 10, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_CROCODILE }, TILE_CORPSE_CROCODILE
},
{
    MONS_CRYSTAL_ECHIDNA, 'r', GREEN, "crystal echidna",
    M_NO_FLAGS,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, 3),
    773, false, MONS_CRYSTAL_ECHIDNA, MONS_CRYSTAL_ECHIDNA, MH_NONLIVING, WILL_INVULN,
    { {AT_BITE, AF_PLAIN, 20} },
    12, 640,
    10, 10, MST_CRYSTAL_ECHIDNA, false, S_SILENT,
    I_ANIMAL, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_CRYSTAL_ECHIDNA }, TILE_ERROR
},
{
    MONS_CRYSTAL_GUARDIAN, '9', GREEN, "crystal guardian",
    M_SEE_INVIS | M_SPEAKS,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, 3),
    918, false, MONS_GOLEM, MONS_CRYSTAL_GUARDIAN, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 42} },
    16, 600,
    20, 0, MST_CRYSTAL_GUARDIAN, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_CRYSTAL_GUARDIAN }, TILE_ERROR
},
{
    MONS_CRYSTAL_TOME, ';', CYAN, "walking crystal tome",
    M_NO_FLAGS,
    MR_NO_FLAGS,
    1809, false, MONS_WALKING_TOME, MONS_EARTHEN_TOME, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 40} },
    15, 1000,
    15, 5, MST_WALKING_TOME, false, S_RUSTLE,
    I_BRAINLESS, HT_LAND, 10, {10, 10, 20, 10, 10},
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_CRYSTAL_TOME }, TILE_ERROR
},
{
    MONS_CULICIVORA, 's', BROWN, "culicivora",
    M_WEB_IMMUNE | M_NO_SKELETON,
    mrd(MR_RES_POISON, -1),
    223, false, MONS_SPIDER, MONS_CULICIVORA, MH_NATURAL, 20,
    { {AT_BITE, AF_VAMPIRIC, 27} },
    8, 390,
    2, 16, MST_CULICIVORA, true, S_FAINT_SKITTER,
    I_ANIMAL, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_ARACHNID, GOD_NO_GOD,
    { TILEP_MONS_CULICIVORA }, TILE_CORPSE_CULICIVORA
},
{
    MONS_CURSE_SKULL, 'z', LIGHTMAGENTA, "curse skull",
    M_FLIES | M_SEE_INVIS | M_SPEAKS,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, 2),
    1166, false, MONS_CURSE_SKULL, MONS_CURSE_SKULL, MH_UNDEAD, WILL_INVULN,
    {  },
    13, 520,
    35, 3, MST_CURSE_SKULL, false, S_MOAN,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_CURSE_SKULL }, TILE_ERROR
},
{
    MONS_CURSE_TOE, 'z', LIGHTGREEN, "curse toe",
    M_FLIES | M_SEE_INVIS | M_SPEAKS,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 3) | MR_RES_COLD,
    2722, false, MONS_CURSE_TOE, MONS_CURSE_TOE, MH_UNDEAD, WILL_INVULN,
    {  },
    14, 980,
    25, 1, MST_CURSE_TOE, false, S_MOAN,
    I_HUMAN, HT_LAND, 10, {14, 14, 10, 10, 10},
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_CURSE_TOE }, TILE_ERROR
},
{
    MONS_CYCLOPS, 'C', YELLOW, "cyclops",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    547, false, MONS_GIANT, MONS_CYCLOPS, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 35} },
    9, 495,
    5, 3, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 7, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_CYCLOPS }, TILE_CORPSE_CYCLOPS
},
{
    MONS_DAEVA, 'A', YELLOW, "daeva",
    M_FLIES | M_FIGHTER | M_SPEAKS,
    MR_RES_POISON,
    1321, false, MONS_ANGEL, MONS_DAEVA, MH_HOLY, 140,
    { {AT_HIT, AF_PLAIN, 25}, {AT_HIT, AF_PLAIN, 10} },
    14, 1190,
    10, 13, MST_DAEVA, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_WINGED, GOD_SHINING_ONE,
    { TILEP_MONS_DAEVA }, TILE_ERROR
},
{
    MONS_DANCING_WEAPON, '(', COLOUR_UNDEF, "dancing weapon",
    M_FLIES | M_FIGHTER | M_UNBLINDABLE | M_GHOST_DEMON | M_PREFER_RANGED,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, 2),
    20, true, MONS_DANCING_WEAPON, MONS_DANCING_WEAPON, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 30} },
    15, 150,
    10, 20, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILE_UNSEEN_WEAPON }, TILE_ERROR
},
{
    MONS_DART_SLUG, 'w', CYAN, "dart slug",
    M_NO_SKELETON,
    mrd(MR_RES_POISON, -1),
    4, false, MONS_ELEPHANT_SLUG, MONS_DART_SLUG, MH_NATURAL, 0,
    { {AT_BITE, AF_PLAIN, 3} },
    1, 100,
    1, 1, MST_DART_SLUG, true, S_SILENT,
    I_ANIMAL, HT_LAND, 7, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_SNAIL, GOD_NO_GOD,
    { TILEP_MONS_DART_SLUG }, TILE_CORPSE_DART_SLUG
},
{
    MONS_DEATH_COB, 'z', YELLOW, "death cob",
    M_SPEAKS,
    MR_RES_COLD,
    1513, false, MONS_DEATH_COB, MONS_DEATH_COB, MH_UNDEAD, 40,
    { {AT_HIT, AF_DRAIN_SPEED, 35} },
    14, 910,
    10, 15, MST_NO_SPELLS, false, S_MOAN,
    I_HUMAN, HT_LAND, 25, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_TINY, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEATH_COB }, TILE_ERROR
},
{
    MONS_DEATH_DRAKE, 'k', LIGHTGRAY, "death drake",
    M_FLIES | M_COLD_BLOOD,
    MR_RES_POISON | MR_RES_MIASMA,
    737, false, MONS_DRAKE, MONS_DEATH_DRAKE, MH_NATURAL, 40,
    { {AT_BITE, AF_PLAIN, 12} },
    9, 765,
    6, 14, MST_DEATH_DRAKE, true, S_HISS,
    I_ANIMAL, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_DEATH_DRAKE }, TILE_CORPSE_DEATH_DRAKE
},
{
    MONS_DEATH_KNIGHT, 'p', GREEN, "death knight",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1020, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 32} },
    14, 840,
    6, 14, MST_DEATH_KNIGHT, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_YREDELEMNUL,
    { TILEP_MONS_DEATH_KNIGHT }, TILE_ERROR
},
{
    MONS_DEATH_SCARAB, 'B', BLUE, "death scarab",
    M_BATTY | M_WEB_IMMUNE | M_NO_SKELETON | M_NO_ZOMBIE,
    MR_NO_FLAGS,
    812, false, MONS_DEATH_SCARAB, MONS_DEATH_SCARAB, MH_UNDEAD, 60,
    { {AT_BITE, AF_SCARAB, 33} },
    8, 320,
    7, 14, MST_NO_SPELLS, true, S_FAINT_SKITTER,
    I_ANIMAL, HT_LAND, 30, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_INSECT, GOD_NO_GOD,
    { TILEP_MONS_DEATH_SCARAB }, TILE_CORPSE_DEATH_SCARAB
},
{
    MONS_DEATH_YAK, 'Y', YELLOW, "death yak",
    M_WARM_BLOOD | M_HERD,
    MR_NO_FLAGS,
    811, false, MONS_YAK, MONS_DEATH_YAK, MH_NATURAL, 100,
    { {AT_GORE, AF_PLAIN, 30} },
    14, 770,
    9, 5, MST_NO_SPELLS, true, S_BELLOW,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_DEATH_YAK }, TILE_CORPSE_DEATH_YAK
},
{
    MONS_DEATHCAP, 'f', LIGHTMAGENTA, "deathcap",
    M_NO_FLAGS,
    MR_RES_COLD,
    6, false, MONS_FUNGUS, MONS_WANDERING_MUSHROOM, MH_UNDEAD, 80,
    { {AT_SPORE, AF_CONFUSE, 33} },
    13, 520,
    5, 0, MST_DEATHCAP, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_FUNGUS, GOD_NO_GOD,
    { TILEP_MONS_DEATHCAP }, TILE_ERROR
},
{
    MONS_DEEP_ELF_AIR_MAGE, 'e', CYAN, "deep elf zephyrmancer",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    599, false, MONS_ELF, MONS_ELF, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 5} },
    9, 405,
    0, 13, MST_DEEP_ELF_AIR_MAGE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_ELF_AIR_MAGE }, TILE_ERROR
},
{
    MONS_DEEP_ELF_ANNIHILATOR, 'e', LIGHTBLUE, "deep elf annihilator",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1004, false, MONS_ELF, MONS_ELF, MH_NATURAL, 120,
    { {AT_HIT, AF_PLAIN, 12} },
    15, 675,
    0, 13, MST_ANNIHILATOR, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_ELF_ANNIHILATOR }, TILE_ERROR
},
{
    MONS_DEEP_ELF_ARCHER, 'e', BROWN, "deep elf archer",
    M_SPEAKS | M_WARM_BLOOD | M_ARCHER,
    MR_NO_FLAGS,
    746, false, MONS_ELF, MONS_ELF, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 21} },
    10, 500,
    0, 15, MST_DEEP_ELF_ARCHER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_ELF_ARCHER }, TILE_ERROR
},
{
    MONS_DEEP_ELF_BLADEMASTER, 'e', LIGHTCYAN, "deep elf blademaster",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD | M_TWO_WEAPONS,
    MR_NO_FLAGS,
    1664, false, MONS_ELF, MONS_ELF, MH_NATURAL, 120,
    { {AT_HIT, AF_PLAIN, 25}, {AT_HIT, AF_PLAIN, 25} },
    16, 1040,
    0, 25, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_ELF_BLADEMASTER }, TILE_ERROR
},
{
    MONS_DEEP_ELF_DEATH_MAGE, 'e', WHITE, "deep elf death mage",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1027, false, MONS_ELF, MONS_ELF, MH_NATURAL, 120,
    { {AT_HIT, AF_PLAIN, 12} },
    17, 775,
    0, 13, MST_DEEP_ELF_DEATH_MAGE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_ELF_DEATH_MAGE }, TILE_ERROR
},
{
    MONS_DEEP_ELF_DEMONOLOGIST, 'e', YELLOW, "deep elf demonologist",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1031, false, MONS_ELF, MONS_ELF, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 12} },
    12, 540,
    0, 13, MST_DEEP_ELF_DEMONOLOGIST, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_ELF_DEMONOLOGIST }, TILE_ERROR
},
{
    MONS_DEEP_ELF_ELEMENTALIST, 'e', LIGHTRED, "deep elf elementalist",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1187, false, MONS_ELF, MONS_ELF, MH_NATURAL, 120,
    { {AT_HIT, AF_PLAIN, 12} },
    14, 630,
    0, 13, MST_DEEP_ELF_ELEMENTALIST, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_ELF_ELEMENTALIST, TVARY_CYCLE }, TILE_ERROR
},
{
    MONS_DEEP_ELF_FIRE_MAGE, 'e', RED, "deep elf pyromancer",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    600, false, MONS_ELF, MONS_ELF, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 5} },
    9, 405,
    0, 13, MST_DEEP_ELF_FIRE_MAGE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_ELF_FIRE_MAGE }, TILE_ERROR
},
{
    MONS_DEEP_ELF_HIGH_PRIEST, 'e', LIGHTGREEN, "deep elf high priest",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    896, false, MONS_ELF, MONS_ELF, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 14} },
    11, 495,
    3, 13, MST_DEEP_ELF_HIGH_PRIEST, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_ELF_HIGH_PRIEST }, TILE_ERROR
},
{
    MONS_DEEP_ELF_KNIGHT, 'e', BLUE, "deep elf knight",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    777, false, MONS_ELF, MONS_ELF, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 21} },
    11, 495,
    0, 17, MST_DEEP_ELF_KNIGHT, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_ELF_KNIGHT }, TILE_ERROR
},
{
    MONS_DEEP_ELF_MASTER_ARCHER, 'e', LIGHTGRAY, "deep elf master archer",
    M_SPEAKS | M_WARM_BLOOD | M_ARCHER | M_PREFER_RANGED,
    MR_NO_FLAGS,
    1640, false, MONS_ELF, MONS_ELF, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 25} },
    15, 750,
    0, 15, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {10, 10, 10, 5, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_ELF_MASTER_ARCHER }, TILE_ERROR
},
{
    MONS_DEEP_ELF_SORCERER, 'e', LIGHTMAGENTA, "deep elf sorcerer",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1237, false, MONS_ELF, MONS_ELF, MH_NATURAL, 120,
    { {AT_HIT, AF_PLAIN, 12} },
    14, 630,
    0, 13, MST_DEEP_ELF_SORCERER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_ELF_SORCERER }, TILE_ERROR
},
{
    MONS_DEEP_TROLL_EARTH_MAGE, 'T', MAGENTA, "deep troll earth mage",
    M_SEE_INVIS | M_UNBLINDABLE | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    805, false, MONS_TROLL, MONS_DEEP_TROLL, MH_NATURAL, 40,
    { {AT_BITE, AF_PLAIN, 27}, {AT_CLAW, AF_PLAIN, 20}, {AT_CLAW, AF_PLAIN, 20} },
    12, 480,
    12, 10, MST_DEEP_TROLL_EARTH_MAGE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_TROLL_EARTH_MAGE }, TILE_ERROR
},
{
    MONS_DEEP_TROLL_SHAMAN, 'T', WHITE, "deep troll shaman",
    M_SEE_INVIS | M_UNBLINDABLE | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    814, false, MONS_TROLL, MONS_DEEP_TROLL, MH_NATURAL, 40,
    { {AT_BITE, AF_PLAIN, 27}, {AT_CLAW, AF_PLAIN, 20}, {AT_CLAW, AF_PLAIN, 20} },
    12, 480,
    6, 10, MST_DEEP_TROLL_SHAMAN, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_TROLL_SHAMAN }, TILE_ERROR
},
{
    MONS_DEEP_TROLL, 'T', YELLOW, "deep troll",
    M_SEE_INVIS | M_UNBLINDABLE | M_SPEAKS | M_WARM_BLOOD | M_FAST_REGEN,
    MR_NO_FLAGS,
    733, false, MONS_TROLL, MONS_DEEP_TROLL, MH_NATURAL, 40,
    { {AT_BITE, AF_PLAIN, 27}, {AT_CLAW, AF_PLAIN, 20}, {AT_CLAW, AF_PLAIN, 20} },
    10, 550,
    6, 10, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEEP_TROLL }, TILE_CORPSE_DEEP_TROLL
},
{
    MONS_DEMIGOD, 'p', YELLOW, "demigod",
    M_SPEAKS | M_WARM_BLOOD | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    154, false, MONS_HUMAN, MONS_DEMIGOD, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 10} },
    5, 375,
    2, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEMIGOD }, TILE_CORPSE_DEMIGOD
},
{
    MONS_DEMONIC_CRAWLER, 's', LIGHTGREEN, "demonic crawler",
    M_SEE_INVIS | M_WEB_IMMUNE | M_FAST_REGEN | M_NO_SKELETON,
    MR_RES_POISON,
    800, false, MONS_DEMONIC_CRAWLER, MONS_DEMONIC_CRAWLER, MH_DEMONIC, 60,
    { {AT_HIT, AF_PLAIN, 20}, {AT_HIT, AF_PLAIN, 20}, {AT_HIT, AF_PLAIN, 20} },
    9, 585,
    10, 6, MST_NO_SPELLS, true, S_SCREAM,
    I_ANIMAL, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_CENTIPEDE, GOD_NO_GOD,
    { TILEP_MONS_DEMONIC_CRAWLER }, TILE_CORPSE_DEMONIC_CRAWLER
},
{
    MONS_DEMONIC_PLANT, 'P', ETC_RANDOM, "demonic plant",
    M_FRAGILE | M_STATIONARY | M_NO_EXP_GAIN | M_NO_THREAT,
    MR_RES_POISON,
    10, false, MONS_PLANT, MONS_DEMONIC_PLANT, MH_PLANT, WILL_INVULN,
    {  },
    10, 2000,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_PLANT, GOD_NO_GOD,
    { TILEP_MONS_DEMONIC_PLANT }, TILE_ERROR
},
{
    MONS_DEMONSPAWN_BLOOD_SAINT, '6', LIGHTBLUE, "demonspawn blood saint",
    M_SPEAKS | M_WARM_BLOOD,
    mrd(MR_RES_FIRE, 3),
    1104, false, MONS_DEMONSPAWN, MONS_DEMONSPAWN, MH_NATURAL | MH_DEMONIC, 60,
    { {AT_HIT, AF_FIRE, 20} },
    15, 925,
    6, 12, MST_DEMONSPAWN_BLOOD_SAINT, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_MAKHLEB,
    { TILEP_MONS_DEMONSPAWN_BLOOD_SAINT }, TILE_ERROR
},
{
    MONS_DEMONSPAWN_CORRUPTER, '6', LIGHTGREEN, "demonspawn corrupter",
    M_SPEAKS | M_WARM_BLOOD,
    mrd(MR_RES_NEG, 3),
    1120, false, MONS_DEMONSPAWN, MONS_DEMONSPAWN, MH_NATURAL | MH_DEMONIC, 60,
    { {AT_HIT, AF_PLAIN, 25}, {AT_KICK, AF_PLAIN, 20} },
    15, 925,
    3, 15, MST_DEMONSPAWN_CORRUPTER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_LUGONU,
    { TILEP_MONS_DEMONSPAWN_CORRUPTER }, TILE_ERROR
},
{
    MONS_DEMONSPAWN_SOUL_SCHOLAR, '6', LIGHTMAGENTA, "demonspawn soul scholar",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    mrd(MR_RES_COLD, 3),
    1031, false, MONS_DEMONSPAWN, MONS_DEMONSPAWN, MH_NATURAL | MH_DEMONIC, 60,
    { {AT_HIT, AF_PLAIN, 25} },
    15, 925,
    9, 12, MST_DEMONSPAWN_SOUL_SCHOLAR, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_KIKUBAAQUDGHA,
    { TILEP_MONS_DEMONSPAWN_SOUL_SCHOLAR }, TILE_ERROR
},
{
    MONS_DEMONSPAWN_WARMONGER, '6', LIGHTCYAN, "demonspawn warmonger",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1313, false, MONS_DEMONSPAWN, MONS_DEMONSPAWN, MH_NATURAL | MH_DEMONIC, 60,
    { {AT_HIT, AF_PLAIN, 40}, {AT_CLAW, AF_PLAIN, 20}, {AT_GORE, AF_PLAIN, 20} },
    15, 1250,
    3, 12, MST_DEMONSPAWN_WARMONGER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEMONSPAWN_WARMONGER }, TILE_ERROR
},
{
    MONS_DEMONSPAWN, '6', BROWN, "demonspawn",
    M_SPEAKS | M_WARM_BLOOD | M_NO_POLY_TO,
    MR_NO_FLAGS,
    849, false, MONS_DEMONSPAWN, MONS_DEMONSPAWN, MH_NATURAL | MH_DEMONIC, 40,
    { {AT_HIT, AF_PLAIN, 20}, {AT_CLAW, AF_PLAIN, 20}, {AT_GORE, AF_PLAIN, 20} },
    10, 925,
    3, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DEMONSPAWN }, TILE_CORPSE_DEMONSPAWN
},
{
    MONS_DIAMOND_OBELISK, 'I', WHITE, "diamond obelisk",
    M_STATIONARY | M_NO_EXP_GAIN | M_NO_POLY_TO | M_NO_THREAT,
    MR_RES_PETRIFY,
    10, false, MONS_DIAMOND_OBELISK, MONS_DIAMOND_OBELISK, MH_NONLIVING, WILL_INVULN,
    {  },
    8, 96000,
    12, 1, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_DIAMOND_OBELISK }, TILE_ERROR
},
{
    MONS_DIAMOND_SAWBLADE, 'I', ETC_IRON, "diamond sawblade",
    M_STATIONARY | M_NO_POLY_TO | M_PERIPHERAL,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, 2) | MR_RES_PETRIFY,
    850, false, MONS_DIAMOND_SAWBLADE, MONS_DIAMOND_SAWBLADE, MH_NONLIVING, WILL_INVULN,
    {  },
    10, 700,
    15, 0, MST_SAWBLADE, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_DIAMOND_SAWBLADE }, TILE_ERROR
},
{
    MONS_DIRE_ELEPHANT, 'Y', BLUE, "dire elephant",
    M_WARM_BLOOD,
    MR_NO_FLAGS,
    996, false, MONS_ELEPHANT, MONS_DIRE_ELEPHANT, MH_NATURAL, 100,
    { {AT_TRAMPLE, AF_TRAMPLE, 40}, {AT_TRUNK_SLAP, AF_PLAIN, 15} },
    15, 1125,
    13, 2, MST_NO_SPELLS, true, S_TRUMPET,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_DIRE_ELEPHANT }, TILE_CORPSE_DIRE_ELEPHANT
},
{
    MONS_DISPATER, '&', MAGENTA, "Dispater",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_TALL_TILE | M_GENDER_NEUTRAL,
    mrd(MR_RES_ELEC, 3) | MR_RES_POISON | MR_RES_FIRE | MR_RES_COLD | mrd(MR_RES_CORR, 3) | MR_RES_DAMNATION,
    5159, false, MONS_HELL_LORD, MONS_DISPATER, MH_DEMONIC, WILL_INVULN,
    { {AT_HIT, AF_CORRODE, 50} },
    16, 4480,
    35, 3, MST_DISPATER, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DISPATER }, TILE_ERROR
},
{
    MONS_DISSOLUTION, 'J', LIGHTMAGENTA, "Dissolution",
    M_EAT_DOORS | M_SEE_INVIS | M_UNBLINDABLE | M_AMORPHOUS | M_SPEAKS | M_BURROWS | M_UNIQUE | M_ACID_SPLASH | M_FAST_REGEN | M_NO_SKELETON | M_GENDER_NEUTRAL,
    MR_RES_POISON | mrd(MR_RES_CORR, 3),
    7370, false, MONS_JELLY, MONS_JELLY, MH_NATURAL, 120,
    { {AT_HIT, AF_ACID, 50}, {AT_HIT, AF_ACID, 30} },
    16, 1760,
    10, 1, MST_DISSOLUTION, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_BLOB, GOD_JIYVA,
    { TILEP_MONS_DISSOLUTION }, TILE_ERROR
},
{
    MONS_DIVINE_TOME, ';', LIGHTGREEN, "walking divine tome",
    M_NO_FLAGS,
    MR_NO_FLAGS,
    1643, false, MONS_WALKING_TOME, MONS_EARTHEN_TOME, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 20} },
    20, 1000,
    10, 5, MST_WALKING_TOME, false, S_RUSTLE,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_DIVINE_TOME }, TILE_ERROR
},
{
    MONS_DJINNI, 'R', MAGENTA, "djinni",
    M_FLIES | M_SPEAKS,
    mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, -1),
    363, false, MONS_DJINNI, MONS_DJINNI, MH_NONLIVING, 30,
    { {AT_HIT, AF_PLAIN, 10} },
    8, 400,
    5, 5, MST_NO_SPELLS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_EFREET }, TILE_ERROR
},
{
    MONS_DONALD, '@', BLUE, "Donald",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    1374, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 26} },
    14, 840,
    3, 10, MST_DONALD, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DONALD }, TILE_ERROR
},
{
    MONS_DOWAN, 'e', RED, "Dowan",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    69, false, MONS_ELF, MONS_ELF, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 5} },
    3, 240,
    0, 13, MST_DOWAN, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DOWAN }, TILE_ERROR
},
{
    MONS_DRACONIAN_ANNIHILATOR, 'q', YELLOW, "draconian annihilator",
    M_SPEAKS | M_COLD_BLOOD,
    MR_NO_FLAGS,
    1119, false, MONS_DRACONIAN, MONS_DRACONIAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 15} },
    16, 800,
    -1, 0, MST_ANNIHILATOR, true, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_DRACONIAN_ANNIHILATOR }, TILE_ERROR
},
{
    MONS_DRACONIAN_KNIGHT, 'q', LIGHTBLUE, "draconian knight",
    M_FIGHTER | M_SPEAKS | M_COLD_BLOOD,
    MR_NO_FLAGS,
    1280, false, MONS_DRACONIAN, MONS_DRACONIAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 27} },
    16, 1120,
    9, 2, MST_DRACONIAN_KNIGHT, true, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_DRACONIAN_KNIGHT }, TILE_ERROR
},
{
    MONS_DRACONIAN_MONK, 'q', LIGHTGREEN, "draconian monk",
    M_FIGHTER | M_SPEAKS | M_COLD_BLOOD,
    MR_NO_FLAGS,
    1304, false, MONS_DRACONIAN, MONS_DRACONIAN, MH_NATURAL, 40,
    { {AT_PUNCH, AF_FLANK, 35}, {AT_KICK, AF_PLAIN, 20}, {AT_TAIL_SLAP, AF_PLAIN, 15} },
    16, 1120,
    -3, 10, MST_NO_SPELLS, true, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_DRACONIAN_MONK }, TILE_ERROR
},
{
    MONS_DRACONIAN_SCORCHER, 'q', LIGHTRED, "draconian scorcher",
    M_SPEAKS | M_COLD_BLOOD,
    MR_NO_FLAGS,
    1212, false, MONS_DRACONIAN, MONS_DRACONIAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 15} },
    16, 800,
    -1, 2, MST_DRACONIAN_SCORCHER, true, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_DRACONIAN_SCORCHER }, TILE_ERROR
},
{
    MONS_DRACONIAN_SHIFTER, 'q', LIGHTMAGENTA, "draconian shifter",
    M_SPEAKS | M_COLD_BLOOD,
    MR_NO_FLAGS,
    1237, false, MONS_DRACONIAN, MONS_DRACONIAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 15} },
    16, 960,
    -1, 6, MST_DRACONIAN_SHIFTER, true, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_DRACONIAN_SHIFTER }, TILE_ERROR
},
{
    MONS_DRACONIAN_STORMCALLER, 'q', WHITE, "draconian stormcaller",
    M_SPEAKS | M_COLD_BLOOD,
    MR_NO_FLAGS,
    1145, false, MONS_DRACONIAN, MONS_DRACONIAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 20} },
    16, 880,
    0, 0, MST_DRACONIAN_STORMCALLER, true, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_QAZLAL,
    { TILEP_MONS_DRACONIAN_STORMCALLER }, TILE_ERROR
},
{
    MONS_DRACONIAN, 'd', BROWN, "draconian",
    M_SPEAKS | M_COLD_BLOOD | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    530, false, MONS_DRACONIAN, MONS_DRACONIAN, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 15} },
    8, 640,
    10, 11, MST_NO_SPELLS, true, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_DRACO_BASE }, TILE_CORPSE_BROWN_DRACONIAN
},
{
    MONS_DRAGON, 'D', GREEN, "dragon",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_DRAGON, MONS_DRAGON, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, true, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_FIRE_DRAGON }, TILE_ERROR
},
{
    MONS_DRAKE, 'k', LIGHTGRAY, "drake",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_DRAKE, MONS_DRAKE, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, true, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_SWAMP_DRAKE }, TILE_ERROR
},
{
    MONS_DRAUGR, 'Z', LIGHTGRAY, "draugr",
    M_NO_REGEN,
    mrd(MR_RES_COLD, 2),
    9, false, MONS_DRAUGR, MONS_DRAUGR, MH_UNDEAD, -5,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 5, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_SMALL, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_DRAUGR_SMALL }, TILE_ERROR
},
{
    MONS_DREAD_LICH, 'L', LIGHTMAGENTA, "dread lich",
    M_SEE_INVIS | M_SPEAKS,
    MR_RES_ELEC | MR_RES_FIRE | mrd(MR_RES_COLD, 2),
    5099, false, MONS_LICH, MONS_LICH, MH_UNDEAD, WILL_INVULN,
    { {AT_TOUCH, AF_DRAIN, 20} },
    27, 1080,
    20, 10, MST_DREAD_LICH, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DREAD_LICH }, TILE_ERROR
},
{
    MONS_DREAM_SHEEP, 'Y', CYAN, "dream sheep",
    M_WARM_BLOOD | M_HERD,
    MR_NO_FLAGS,
    255, false, MONS_DREAM_SHEEP, MONS_DREAM_SHEEP, MH_NATURAL, 30,
    { {AT_HEADBUTT, AF_PLAIN, 13} },
    9, 220,
    2, 10, MST_DREAM_SHEEP, true, S_BLEAT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_QUADRUPED_TAILLESS, GOD_NO_GOD,
    { TILEP_MONS_DREAM_SHEEP }, TILE_CORPSE_DREAM_SHEEP
},
{
    MONS_DROWNED_SOUL, 'W', LIGHTCYAN, "drowned soul",
    M_FLIES | M_SEE_INVIS | M_SPEAKS | M_INSUBSTANTIAL,
    mrd(MR_RES_COLD, 3),
    8, false, MONS_PHANTOM, MONS_DROWNED_SOUL, MH_UNDEAD, 60,
    { {AT_TOUCH, AF_DROWN, 0} },
    13, 195,
    0, 13, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DROWNED_SOUL }, TILE_ERROR
},
{
    MONS_DRUDE, '5', LIGHTMAGENTA, "drude",
    M_SPEAKS,
    MR_RES_POISON | MR_RES_FIRE,
    38, false, MONS_DRUDE, MONS_DRUDE, MH_DEMONIC, 40,
    { {AT_HIT, AF_DOOM, 8}, {AT_HIT, AF_DOOM, 8} },
    4, 210,
    4, 17, MST_NO_SPELLS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LITTLE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DRUDE }, TILE_ERROR
},
{
    MONS_DRYAD, 'R', LIGHTGREEN, "dryad",
    M_SPEAKS | M_WARM_BLOOD | M_CAUTIOUS | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    mrd(MR_RES_FIRE, -1),
    344, false, MONS_DRYAD, MONS_DRYAD, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 10} },
    8, 520,
    6, 12, MST_DRYAD, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DRYAD }, TILE_CORPSE_DRYAD
},
{
    MONS_DUVESSA, 'e', BLUE, "Duvessa",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    146, false, MONS_ELF, MONS_ELF, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 10} },
    4, 360,
    2, 9, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DUVESSA }, TILE_ERROR
},
{
    MONS_DWARF, 'g', LIGHTGREEN, "dwarf",
    M_SPEAKS | M_WARM_BLOOD | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    131, false, MONS_DWARF, MONS_DWARF, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 10} },
    5, 275,
    2, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_DWARF }, TILE_CORPSE_DWARF
},
{
    MONS_EARTH_ELEMENTAL, 'E', ETC_EARTH, "earth elemental",
    M_NO_FLAGS,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, 3) | MR_RES_PETRIFY,
    84, false, MONS_ELEMENTAL, MONS_EARTH_ELEMENTAL, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 36} },
    6, 450,
    14, 4, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_WALL, 8, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_EARTH_ELEMENTAL }, TILE_ERROR
},
{
    MONS_EARTHEN_TOME, ';', MAGENTA, "walking earthen tome",
    M_NO_FLAGS,
    MR_NO_FLAGS,
    1737, false, MONS_WALKING_TOME, MONS_EARTHEN_TOME, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 50} },
    27, 1000,
    20, 5, MST_WALKING_TOME, false, S_RUSTLE,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_EARTHEN_TOME }, TILE_ERROR
},
{
    MONS_EDMUND, '@', RED, "Edmund",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    165, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 6} },
    4, 440,
    0, 10, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_EDMUND }, TILE_ERROR
},
{
    MONS_EFREET, 'R', RED, "efreet",
    M_FLIES | M_SPEAKS,
    MR_RES_POISON | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1),
    359, false, MONS_EFREET, MONS_EFREET, MH_DEMONIC, 20,
    { {AT_HIT, AF_PLAIN, 17} },
    7, 385,
    10, 5, MST_EFREET, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_EFREET }, TILE_ERROR
},
{
    MONS_EIDOLON, 'W', BROWN, "eidolon",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    MR_RES_COLD,
    944, false, MONS_WRAITH, MONS_EIDOLON, MH_UNDEAD, 140,
    { {AT_HIT, AF_DRAIN_SPEED, 27}, {AT_HIT, AF_PLAIN, 17} },
    13, 715,
    12, 10, MST_EIDOLON, false, S_MOAN,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_EIDOLON }, TILE_ERROR
},
{
    MONS_ELDRITCH_TENTACLE_SEGMENT, '*', COLOUR_UNDEF, "eldritch tentacle segment",
    M_FLIES | M_SEE_INVIS | M_STATIONARY | M_NO_EXP_GAIN | M_NO_POLY_TO | M_NO_THREAT | M_PERIPHERAL,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, 3) | mrd(MR_RES_CORR, 3),
    10, false, MONS_ELDRITCH_TENTACLE, MONS_ELDRITCH_TENTACLE_SEGMENT, MH_NONLIVING, WILL_INVULN,
    {  },
    16, 1200,
    13, 0, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_ELDRITCH_TENTACLE, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_ERROR
},
{
    MONS_ELDRITCH_TENTACLE, 'w', COLOUR_UNDEF, "eldritch tentacle",
    M_FLIES | M_SEE_INVIS | M_STATIONARY | M_NO_POLY_TO,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, 3) | mrd(MR_RES_CORR, 3),
    1530, false, MONS_ELDRITCH_TENTACLE, MONS_ELDRITCH_TENTACLE, MH_NONLIVING, WILL_INVULN,
    { {AT_TENTACLE_SLAP, AF_CHAOTIC, 30}, {AT_CLAW, AF_CHAOTIC, 40} },
    16, 1200,
    13, 0, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_ELDRITCH_TENTACLE, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_ERROR
},
{
    MONS_ELECTRIC_EEL, 'S', LIGHTCYAN, "electric eel",
    M_COLD_BLOOD | M_NO_GEN_DERIVED,
    mrd(MR_RES_ELEC, 3),
    54, false, MONS_ELECTRIC_EEL, MONS_ELECTRIC_EEL, MH_NATURAL, 10,
    {  },
    3, 165,
    1, 15, MST_ZAPPER, true, S_SILENT,
    I_ANIMAL, HT_WATER, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_ELECTRIC_EEL }, TILE_CORPSE_ELECTRIC_EEL
},
{
    MONS_ELECTRIC_GOLEM, '9', LIGHTBLUE, "electric golem",
    M_SEE_INVIS | M_SPEAKS | M_INSUBSTANTIAL,
    mrd(MR_RES_ELEC, 3) | MR_RES_FIRE | MR_RES_COLD,
    2013, false, MONS_GOLEM, MONS_ELECTRIC_GOLEM, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_ELEC, 15}, {AT_HIT, AF_ELEC, 15}, {AT_HIT, AF_PLAIN, 15}, {AT_HIT, AF_PLAIN, 15} },
    15, 1350,
    5, 20, MST_ELECTRIC_GOLEM, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 16, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ELECTRIC_GOLEM }, TILE_ERROR
},
{
    MONS_ELEIONOMA, 'R', GREEN, "eleionoma",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1028, false, MONS_ELEIONOMA, MONS_ELEIONOMA, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 25} },
    16, 800,
    2, 10, MST_ELEIONOMA, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ELEIONOMA }, TILE_CORPSE_ELEIONOMA
},
{
    MONS_ELEMENTAL_WELLSPRING, 'E', LIGHTCYAN, "elemental wellspring",
    M_AMORPHOUS,
    MR_RES_ELEC,
    1039, false, MONS_ELEMENTAL, MONS_ELEMENTAL_WELLSPRING, MH_NONLIVING, WILL_INVULN,
    {  },
    18, 620,
    8, 8, MST_ELEMENTAL_WELLSPRING, false, S_SILENT,
    I_ANIMAL, HT_WATER, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_ELEMENTAL_WELLSPRING }, TILE_ERROR
},
{
    MONS_ELEMENTAL, 'E', LIGHTGRAY, "elemental",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_ELEMENTAL, MONS_ELEMENTAL, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_WATER_ELEMENTAL }, TILE_ERROR
},
{
    MONS_ELEPHANT_SLUG, 'w', WHITE, "elephant slug",
    M_NO_SKELETON | M_CANT_SPAWN,
    mrd(MR_RES_POISON, -1),
    2, false, MONS_ELEPHANT_SLUG, MONS_ELEPHANT_SLUG, MH_NATURAL, 80,
    { {AT_BITE, AF_PLAIN, 40} },
    20, 1300,
    2, 1, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_LAND, 4, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_SNAIL, GOD_NO_GOD,
    { TILEP_MONS_DART_SLUG }, TILE_CORPSE_ELEPHANT_SLUG
},
{
    MONS_ELEPHANT, 'Y', GREEN, "elephant",
    M_WARM_BLOOD,
    MR_NO_FLAGS,
    480, false, MONS_ELEPHANT, MONS_ELEPHANT, MH_NATURAL, 60,
    { {AT_TRAMPLE, AF_TRAMPLE, 20}, {AT_TRUNK_SLAP, AF_PLAIN, 5} },
    9, 675,
    8, 2, MST_NO_SPELLS, true, S_TRUMPET,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_ELEPHANT }, TILE_CORPSE_ELEPHANT
},
{
    MONS_ELF, 'e', LIGHTRED, "elf",
    M_SPEAKS | M_WARM_BLOOD | M_NO_POLY_TO,
    MR_NO_FLAGS,
    194, false, MONS_ELF, MONS_ELF, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 10} },
    8, 290,
    1, 16, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ELF }, TILE_CORPSE_ELF
},
{
    MONS_EMPEROR_SCORPION, 's', LIGHTGRAY, "emperor scorpion",
    M_WEB_IMMUNE | M_NO_SKELETON,
    MR_RES_POISON,
    1235, false, MONS_SCORPION, MONS_EMPEROR_SCORPION, MH_NATURAL, 60,
    { {AT_STING, AF_POISON, 30}, {AT_CLAW, AF_PLAIN, 10}, {AT_CLAW, AF_PLAIN, 10} },
    14, 1090,
    18, 7, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_ARACHNID, GOD_NO_GOD,
    { TILEP_MONS_EMPEROR_SCORPION }, TILE_CORPSE_EMPEROR_SCORPION
},
{
    MONS_ENCHANTRESS, 'i', LIGHTMAGENTA, "Enchantress",
    M_NAME_THE | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    2328, false, MONS_SPRIGGAN, MONS_SPRIGGAN, MH_NATURAL, 160,
    { {AT_HIT, AF_PLAIN, 26} },
    15, 975,
    1, 30, MST_ENCHANTRESS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {6, 6, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LITTLE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ENCHANTRESS }, TILE_ERROR
},
{
    MONS_ENDOPLASM, 'J', LIGHTGRAY, "endoplasm",
    M_SEE_INVIS | M_UNBLINDABLE | M_AMORPHOUS | M_NO_SKELETON,
    mrd(MR_RES_CORR, 3),
    2, false, MONS_JELLY, MONS_ENDOPLASM, MH_NATURAL, 0,
    { {AT_HIT, AF_PLAIN, 3} },
    1, 60,
    1, 3, MST_ENDOPLASM, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_BLOB, GOD_NO_GOD,
    { TILEP_MONS_ENDOPLASM }, TILE_ERROR
},
{
    MONS_ENTROPY_WEAVER, 'B', LIGHTCYAN, "entropy weaver",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WEB_IMMUNE | M_WARM_BLOOD | M_NO_SKELETON,
    MR_NO_FLAGS,
    898, false, MONS_ENTROPY_WEAVER, MONS_ENTROPY_WEAVER, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 17}, {AT_HIT, AF_PLAIN, 17}, {AT_HIT, AF_PLAIN, 17}, {AT_HIT, AF_PLAIN, 17} },
    7, 715,
    7, 13, MST_ENTROPY_WEAVER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ENTROPY_WEAVER }, TILE_CORPSE_ENTROPY_WEAVER
},
{
    MONS_ERESHKIGAL, '&', WHITE, "Ereshkigal",
    M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_FEMALE | M_TALL_TILE,
    MR_RES_ELEC | MR_RES_POISON | MR_RES_COLD,
    6976, false, MONS_HELL_LORD, MONS_ERESHKIGAL, MH_DEMONIC, WILL_INVULN,
    { {AT_HIT, AF_DRAIN, 40} },
    18, 3510,
    10, 30, MST_ERESHKIGAL, false, S_SHOUT,
    I_HUMAN, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ERESHKIGAL }, TILE_ERROR
},
{
    MONS_ERICA, 'x', LIGHTMAGENTA, "Erica",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE | M_NO_SKELETON,
    MR_NO_FLAGS,
    839, false, MONS_OCTOPODE, MONS_OCTOPODE, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 11}, {AT_CONSTRICT, AF_CRUSH, 3} },
    9, 630,
    0, 13, MST_ERICA, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_ERICA }, TILE_ERROR
},
{
    MONS_EROLCHA, 'O', LIGHTBLUE, "Erolcha",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    867, false, MONS_OGRE, MONS_OGRE, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 30} },
    6, 540,
    3, 7, MST_EROLCHA, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {10, 10, 15, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_EROLCHA }, TILE_ERROR
},
{
    MONS_ETTIN, 'C', BROWN, "ettin",
    M_SPEAKS | M_WARM_BLOOD | M_TWO_WEAPONS,
    MR_NO_FLAGS,
    929, false, MONS_GIANT, MONS_ETTIN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 40}, {AT_HIT, AF_PLAIN, 40} },
    12, 660,
    9, 4, MST_NO_SPELLS, true, S_SHOUT2,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ETTIN }, TILE_CORPSE_ETTIN
},
{
    MONS_EUSTACHIO, '@', BLUE, "Eustachio",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    200, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 6} },
    4, 400,
    0, 13, MST_EUSTACHIO, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_EUSTACHIO }, TILE_ERROR
},
{
    MONS_EXECUTIONER, '1', LIGHTGRAY, "Executioner",
    M_FIGHTER | M_SEE_INVIS,
    MR_RES_ELEC | MR_RES_POISON | MR_RES_FIRE | MR_RES_COLD,
    1531, false, MONS_EXECUTIONER, MONS_EXECUTIONER, MH_DEMONIC, 140,
    { {AT_HIT, AF_PLAIN, 30}, {AT_HIT, AF_PLAIN, 10}, {AT_HIT, AF_PLAIN, 10} },
    12, 660,
    10, 15, MST_EXECUTIONER, false, S_SCREAM,
    I_HUMAN, HT_LAND, 20, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_EXECUTIONER }, TILE_ERROR
},
{
    MONS_EYE_OF_DEVASTATION, 'G', YELLOW, "eye of devastation",
    M_FLIES | M_SEE_INVIS | M_NO_SKELETON,
    MR_NO_FLAGS,
    434, false, MONS_FLOATING_EYE, MONS_EYE_OF_DEVASTATION, MH_NATURAL, 100,
    {  },
    10, 550,
    12, 1, MST_EYE_OF_DEVASTATION, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 7, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_EYE_OF_DEVASTATION }, TILE_ERROR
},
{
    MONS_FANNAR, 'e', LIGHTBLUE, "Fannar",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_GENDER_NEUTRAL,
    MR_NO_FLAGS,
    882, false, MONS_ELF, MONS_ELF, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 8} },
    10, 800,
    4, 15, MST_FANNAR, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_FANNAR }, TILE_ERROR
},
{
    MONS_FAUN, 'c', GREEN, "faun",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    538, false, MONS_FAUN, MONS_FAUN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 23} },
    10, 500,
    2, 10, MST_FAUN, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_FAUN }, TILE_CORPSE_FAUN
},
{
    MONS_FELID, 'h', MAGENTA, "felid",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    106, false, MONS_FELID, MONS_FELID, MH_NATURAL, 40,
    { {AT_CLAW, AF_PLAIN, 10} },
    5, 175,
    2, 18, MST_NO_SPELLS, true, S_HISS,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_LITTLE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_FELID }, TILE_CORPSE_FELID
},
{
    MONS_FENSTRIDER_WITCH, 'H', LIGHTMAGENTA, "fenstrider witch",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_RES_POISON | MR_RES_NEG,
    1315, false, MONS_FENSTRIDER_WITCH, MONS_FENSTRIDER_WITCH, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 25}, {AT_KICK, AF_PLAIN, 25} },
    16, 666,
    3, 15, MST_FENSTRIDER_WITCH, true, S_SHOUT,
    I_HUMAN, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_FENSTRIDER_WITCH }, TILE_CORPSE_FENSTRIDER_WITCH
},
{
    MONS_FIRE_BAT, 'b', LIGHTRED, "fire bat",
    M_FLIES | M_SEE_INVIS | M_UNBLINDABLE | M_BATTY | M_WARM_BLOOD,
    mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1),
    196, false, MONS_BAT, MONS_FIRE_BAT, MH_NATURAL, 10,
    { {AT_BITE, AF_FIRE, 6} },
    5, 225,
    1, 14, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 30, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_BAT, GOD_NO_GOD,
    { TILEP_MONS_FIRE_BAT }, TILE_ERROR
},
{
    MONS_FIRE_CRAB, 't', LIGHTRED, "fire crab",
    M_NO_SKELETON,
    mrd(MR_RES_POISON, -1) | mrd(MR_RES_FIRE, 3),
    764, false, MONS_CRAB, MONS_FIRE_CRAB, MH_NATURAL, 40,
    { {AT_BITE, AF_FIRE, 15}, {AT_CLAW, AF_FIRE, 15} },
    8, 520,
    9, 6, MST_FIRE_CRAB, true, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS_LAVA, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_FIRE_CRAB }, TILE_CORPSE_FIRE_CRAB
},
{
    MONS_FIRE_DRAGON, 'D', LIGHTRED, "fire dragon",
    M_FLIES | M_WARM_BLOOD,
    MR_RES_POISON | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, -1),
    910, false, MONS_DRAGON, MONS_FIRE_DRAGON, MH_NATURAL, 60,
    { {AT_BITE, AF_PLAIN, 20}, {AT_CLAW, AF_PLAIN, 13}, {AT_TRAMPLE, AF_TRAMPLE, 13} },
    12, 900,
    10, 8, MST_FIRE_DRAGON_BREATH, true, S_LOUD_ROAR,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_FIRE_DRAGON }, TILE_CORPSE_FIRE_DRAGON
},
{
    MONS_FIRE_ELEMENTAL, 'E', ETC_FIRE, "fire elemental",
    M_INSUBSTANTIAL,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1),
    196, false, MONS_ELEMENTAL, MONS_FIRE_ELEMENTAL, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PURE_FIRE, 0} },
    6, 330,
    4, 12, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS_LAVA, 13, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_FIRE_ELEMENTAL }, TILE_ERROR
},
{
    MONS_FIRE_GIANT, 'C', RED, "fire giant",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    mrd(MR_RES_FIRE, 2),
    1281, false, MONS_GIANT, MONS_FIRE_GIANT, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 30} },
    16, 960,
    8, 4, MST_FIRE_GIANT, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_FIRE_GIANT }, TILE_CORPSE_FIRE_GIANT
},
{
    MONS_FIRE_VORTEX, 'v', RED, "fire vortex",
    M_FLIES | M_CONFUSED | M_INSUBSTANTIAL | M_NO_EXP_GAIN | M_PERIPHERAL,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1),
    5, false, MONS_FIRE_VORTEX, MONS_FIRE_VORTEX, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PURE_FIRE, 0} },
    10, 300,
    0, 5, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_FIRE_VORTEX, TVARY_CYCLE }, TILE_ERROR
},
{
    MONS_FLAYED_GHOST, 'W', RED, "flayed ghost",
    M_FLIES | M_SPEAKS | M_INSUBSTANTIAL,
    MR_NO_FLAGS,
    715, false, MONS_PHANTOM, MONS_FLAYED_GHOST, MH_UNDEAD, 60,
    { {AT_HIT, AF_PLAIN, 30} },
    11, 605,
    0, 14, MST_FLAYED_GHOST, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_FLAYED_GHOST }, TILE_ERROR
},
{
    MONS_FLOATING_EYE, 'G', WHITE, "floating eye",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_FLOATING_EYE, MONS_FLOATING_EYE, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, true, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_GLASS_EYE }, TILE_ERROR
},
{
    MONS_FORMICID, 'B', GREEN, "formicid",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_NO_SKELETON | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    229, false, MONS_FORMICID, MONS_FORMICID, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 15} },
    6, 420,
    3, 10, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_FORMICID }, TILE_CORPSE_FORMICID
},
{
    MONS_FORMLESS_JELLYFISH, 'J', WHITE, "formless jellyfish",
    M_UNBLINDABLE | M_AMORPHOUS | M_NO_SKELETON,
    MR_RES_POISON,
    1091, false, MONS_JELLY, MONS_FORMLESS_JELLYFISH, MH_NATURAL, 60,
    { {AT_STING, AF_MINIPARA, 37}, {AT_CONSTRICT, AF_CRUSH, 5} },
    15, 1200,
    0, 3, MST_BLINK_CLOSE, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_BLOB, GOD_NO_GOD,
    { TILEP_MONS_FORMLESS_JELLYFISH }, TILE_ERROR
},
{
    MONS_FOXFIRE, 'v', LIGHTRED, "foxfire",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL | M_NO_EXP_GAIN | M_NO_POLY_TO | M_PERIPHERAL | M_NO_THREAT,
    mrd(MR_RES_FIRE, 3),
    0, false, MONS_FOXFIRE, MONS_FOXFIRE, MH_NONLIVING, WILL_INVULN,
    {  },
    1, 10,
    0, 10, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 50, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_FOXFIRE }, TILE_ERROR
},
{
    MONS_FRANCES, '@', YELLOW, "Frances",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    1518, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 29} },
    14, 1330,
    0, 10, MST_FRANCES, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_FRANCES }, TILE_ERROR
},
{
    MONS_FRAVASHI, 'A', GREEN, "fravashi",
    M_FLIES | M_FIGHTER | M_SPEAKS,
    MR_RES_POISON,
    912, false, MONS_FRAVASHI, MONS_FRAVASHI, MH_HOLY, 120,
    { {AT_HIT, AF_PLAIN, 25} },
    13, 860,
    11, 13, MST_FRAVASHI, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID_WINGED, GOD_SHINING_ONE,
    { TILEP_MONS_FRAVASHI }, TILE_ERROR
},
{
    MONS_FREDERICK, '@', GREEN, "Frederick",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    5151, false, MONS_DEMIGOD, MONS_DEMIGOD, MH_NATURAL, 140,
    { {AT_HIT, AF_PLAIN, 44} },
    23, 1975,
    0, 16, MST_FREDERICK, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_FREDERICK }, TILE_ERROR
},
{
    MONS_FREEZING_WRAITH, 'W', LIGHTBLUE, "freezing wraith",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 3),
    354, false, MONS_WRAITH, MONS_FREEZING_WRAITH, MH_UNDEAD, 40,
    { {AT_HIT, AF_COLD, 16}, {AT_HIT, AF_DRAIN_SPEED, 15} },
    8, 440,
    12, 10, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_FREEZING_WRAITH }, TILE_ERROR
},
{
    MONS_FRILLED_LIZARD, 'l', GREEN, "frilled lizard",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    1, false, MONS_GIANT_LIZARD, MONS_FRILLED_LIZARD, MH_NATURAL, 0,
    { {AT_BITE, AF_PLAIN, 3} },
    1, 20,
    0, 15, MST_NO_SPELLS, true, S_HISS,
    I_ANIMAL, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_FRILLED_LIZARD }, TILE_CORPSE_FRILLED_LIZARD
},
{
    MONS_FROG, 'F', LIGHTGREEN, "giant frog",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_FROG, MONS_FROG, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, true, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_BULLFROG }, TILE_ERROR
},
{
    MONS_FROST_GIANT, 'C', LIGHTBLUE, "frost giant",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    mrd(MR_RES_COLD, 2),
    1249, false, MONS_GIANT, MONS_FROST_GIANT, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 35} },
    16, 1040,
    9, 3, MST_FROST_GIANT, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_FROST_GIANT }, TILE_CORPSE_FROST_GIANT
},
{
    MONS_FROSTBOUND_TOME, ';', YELLOW, "walking frostbound tome",
    M_NO_FLAGS,
    mrd(MR_RES_FIRE, -1) | MR_RES_COLD,
    1641, false, MONS_WALKING_TOME, MONS_EARTHEN_TOME, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_COLD, 20} },
    20, 1000,
    10, 10, MST_WALKING_TOME, false, S_RUSTLE,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_FROSTBOUND_TOME }, TILE_ERROR
},
{
    MONS_FULMINANT_PRISM, '*', ETC_MAGIC, "fulminant prism",
    M_FLIES | M_STATIONARY | M_NO_EXP_GAIN | M_NO_POLY_TO | M_PERIPHERAL | M_UNSTABLE,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    0, false, MONS_FULMINANT_PRISM, MONS_FULMINANT_PRISM, MH_NONLIVING, WILL_INVULN,
    {  },
    5, 150,
    3, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_FULMINANT_PRISM, TVARY_RANDOM }, TILE_ERROR
},
{
    MONS_FUNGUS, 'P', LIGHTGRAY, "fungus",
    M_FRAGILE | M_STATIONARY | M_NO_EXP_GAIN | M_NO_THREAT,
    MR_RES_POISON,
    10, false, MONS_FUNGUS, MONS_FUNGUS, MH_PLANT, WILL_INVULN,
    {  },
    8, 2000,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_FUNGUS, GOD_NO_GOD,
    { TILEP_MONS_FUNGUS, TVARY_MOD }, TILE_ERROR
},
{
    MONS_GARGOYLE, '9', LIGHTGRAY, "gargoyle",
    M_FLIES,
    MR_RES_ELEC | MR_RES_PETRIFY,
    414, false, MONS_GOLEM, MONS_GARGOYLE, MH_NONLIVING, 40,
    { {AT_HIT, AF_PLAIN, 20} },
    6, 270,
    18, 6, MST_GARGOYLE, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID_WINGED_TAILED, GOD_NO_GOD,
    { TILEP_MONS_GARGOYLE }, TILE_ERROR
},
{
    MONS_GASTRONOK, 'w', MAGENTA, "Gastronok",
    M_NO_WAND | M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    1506, false, MONS_ELEPHANT_SLUG, MONS_ELEPHANT_SLUG, MH_NATURAL, 80,
    { {AT_BITE, AF_PLAIN, 40} },
    20, 1500,
    2, 1, MST_GASTRONOK, true, S_GURGLE,
    I_HUMAN, HT_AMPHIBIOUS, 5, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_GIANT, MON_SHAPE_SNAIL, GOD_NO_GOD,
    { TILEP_MONS_GASTRONOK, TVARY_MOD }, TILE_ERROR
},
{
    MONS_GERYON, '&', GREEN, "Geryon",
    M_FLIES | M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_MALE | M_TALL_TILE,
    MR_NO_FLAGS,
    2622, false, MONS_HELL_LORD, MONS_GERYON, MH_DEMONIC, 120,
    { {AT_TAIL_SLAP, AF_REACH, 35} },
    15, 3000,
    15, 6, MST_GERYON, false, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_GIANT, MON_SHAPE_HUMANOID_WINGED, GOD_NO_GOD,
    { TILEP_MONS_GERYON }, TILE_ERROR
},
{
    MONS_GHOST_CRAB, 't', LIGHTGRAY, "ghost crab",
    M_NO_SKELETON | M_NO_ZOMBIE,
    MR_NO_FLAGS,
    849, false, MONS_CRAB, MONS_GHOST_CRAB, MH_UNDEAD, 40,
    { {AT_BITE, AF_DRAIN, 20}, {AT_CLAW, AF_DRAIN, 15} },
    9, 585,
    9, 6, MST_GHOST_CRAB, true, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_GHOST_CRAB }, TILE_CORPSE_GHOST_CRAB
},
{
    MONS_GHOST_MOTH, 'y', MAGENTA, "ghost moth",
    M_FLIES | M_INVIS | M_WEB_IMMUNE | M_NO_SKELETON,
    MR_RES_POISON | MR_RES_COLD,
    1196, false, MONS_MOTH, MONS_GHOST_MOTH, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 24}, {AT_HIT, AF_PLAIN, 18}, {AT_STING, AF_PLAIN, 18} },
    13, 715,
    8, 10, MST_GHOST_MOTH, true, S_SILENT,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_INSECT_WINGED, GOD_NO_GOD,
    { TILEP_MONS_GHOST_MOTH }, TILE_CORPSE_GHOST_MOTH
},
{
    MONS_GHOST, 'W', WHITE, "ghost",
    M_FLIES | M_INSUBSTANTIAL | M_NO_POLY_TO,
    MR_NO_FLAGS,
    0, false, MONS_GHOST, MONS_GHOST, MH_UNDEAD, 0,
    {  },
    1, 10,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_GHOST }, TILE_ERROR
},
{
    MONS_GHOUL, 'n', RED, "ghoul",
    M_NO_ZOMBIE,
    MR_RES_COLD,
    1148, false, MONS_GHOUL, MONS_GHOUL, MH_UNDEAD, 80,
    { {AT_CLAW, AF_PLAIN, 30}, {AT_CLAW, AF_PLAIN, 30} },
    14, 1470,
    4, 10, MST_NO_SPELLS, true, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_GHOUL }, TILE_CORPSE_GHOUL
},
{
    MONS_GIANT_LIZARD, 'l', LIGHTGRAY, "giant lizard",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_GIANT_LIZARD, MONS_GIANT_LIZARD, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, true, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_IGUANA }, TILE_ERROR
},
{
    MONS_GIANT, 'C', LIGHTGRAY, "giant",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_GIANT, MONS_GIANT, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, true, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_STONE_GIANT }, TILE_ERROR
},
{
    MONS_GLASS_EYE, 'G', WHITE, "glass eye",
    M_FLIES | M_SEE_INVIS | M_NO_SKELETON | M_CAUTIOUS,
    MR_NO_FLAGS,
    261, false, MONS_FLOATING_EYE, MONS_GLASS_EYE, MH_NATURAL, 60,
    {  },
    9, 490,
    2, 12, MST_GLASS_EYE, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_GLASS_EYE }, TILE_ERROR
},
{
    MONS_GLOBE_OF_ANNIHILATION, '*', LIGHTRED, "globe of annihilation",
    M_FLIES | M_INSUBSTANTIAL | M_NO_EXP_GAIN | M_NO_POLY_TO | M_NO_THREAT | M_PROJECTILE,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, 3) | mrd(MR_RES_CORR, 3) | MR_RES_DAMNATION,
    0, false, MONS_GLOBE_OF_ANNIHILATION, MONS_GLOBE_OF_ANNIHILATION, MH_NONLIVING, WILL_INVULN,
    {  },
    5, 50000,
    0, 10, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_GLOBE_OF_ANNIHILATION_GEH }, TILE_ERROR
},
{
    MONS_GLOORX_VLOQ, '&', LIGHTGRAY, "Gloorx Vloq",
    M_FLIES | M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_TALL_TILE | M_GENDER_NEUTRAL,
    MR_RES_ELEC | MR_RES_POISON | MR_RES_COLD,
    6736, false, MONS_PANDEMONIUM_LORD, MONS_GLOORX_VLOQ, MH_DEMONIC, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 45} },
    16, 3520,
    10, 10, MST_GLOORX_VLOQ, false, S_MOAN,
    I_HUMAN, HT_LAND, 20, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_GLOORX_VLOQ }, TILE_ERROR
},
{
    MONS_GLOWING_ORANGE_BRAIN, 'G', LIGHTRED, "glowing orange brain",
    M_FLIES | M_SEE_INVIS | M_UNBLINDABLE | M_WARM_BLOOD | M_NO_SKELETON | M_CAUTIOUS | M_HAS_AURA,
    MR_NO_FLAGS,
    714, false, MONS_GLOWING_ORANGE_BRAIN, MONS_GLOWING_ORANGE_BRAIN, MH_NATURAL, 100,
    {  },
    10, 550,
    2, 4, MST_GLOWING_ORANGE_BRAIN, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_GLOWING_ORANGE_BRAIN }, TILE_ERROR
},
{
    MONS_GLOWING_SHAPESHIFTER, 'p', LIGHTRED, "glowing shapeshifter",
    M_NO_FLAGS,
    MR_NO_FLAGS,
    507, false, MONS_SHAPESHIFTER, MONS_GLOWING_SHAPESHIFTER, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 15} },
    10, 550,
    0, 10, MST_NO_SPELLS, true, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_GLOWING_SHAPESHIFTER }, TILE_CORPSE_GLOWING_SHAPESHIFTER
},
{
    MONS_GNOLL_BOUDA, 'j', WHITE, "gnoll bouda",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    40, false, MONS_GNOLL, MONS_GNOLL, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 10} },
    3, 195,
    2, 9, MST_BOUDA, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_GNOLL_BOUDA }, TILE_ERROR
},
{
    MONS_GNOLL_SERGEANT, 'j', CYAN, "gnoll sergeant",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    86, false, MONS_GNOLL, MONS_GNOLL, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 11} },
    4, 260,
    2, 9, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_GNOLL_SERGEANT }, TILE_ERROR
},
{
    MONS_GNOLL, 'j', YELLOW, "gnoll",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    14, false, MONS_GNOLL, MONS_GNOLL, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 6} },
    2, 130,
    2, 9, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_GNOLL }, TILE_CORPSE_GNOLL
},
{
    MONS_GOBLIN_RIDER, 'g', GREEN, "goblin rider",
    M_FLIES | M_FIGHTER | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    308, false, MONS_GOBLIN, MONS_GOBLIN, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 20} },
    5, 295,
    4, 10, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 15, {10, 10, 15, 10, 10},
    MONUSE_STARTING_EQUIPMENT, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_GOBLIN_RIDER }, TILE_ERROR
},
{
    MONS_GOBLIN, 'g', LIGHTGRAY, "goblin",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1, false, MONS_GOBLIN, MONS_GOBLIN, MH_NATURAL, 0,
    { {AT_HIT, AF_PLAIN, 1} },
    1, 40,
    0, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_GOBLIN }, TILE_CORPSE_GOBLIN
},
{
    MONS_GOD_WRATH_AVATAR, 'X', WHITE, "god wrath avatar",
    M_STATIONARY | M_FAST_REGEN | M_NO_POLY_TO | M_NO_THREAT,
    MR_NO_FLAGS,
    15, false, MONS_GOD_WRATH_AVATAR, MONS_GOD_WRATH_AVATAR, MH_HOLY, 20,
    {  },
    1000, 10000000,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_ERROR
},
{
    MONS_GOLDEN_DRAGON, 'D', YELLOW, "golden dragon",
    M_FLIES | M_SEE_INVIS | M_WARM_BLOOD,
    MR_RES_ELEC | MR_RES_POISON | MR_RES_FIRE | MR_RES_COLD,
    2457, false, MONS_DRAGON, MONS_GOLDEN_DRAGON, MH_NATURAL, 180,
    { {AT_BITE, AF_PLAIN, 40}, {AT_CLAW, AF_PLAIN, 20}, {AT_TRAMPLE, AF_TRAMPLE, 20} },
    18, 1080,
    15, 7, MST_GOLDEN_DRAGON, true, S_LOUD_ROAR,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_GOLDEN_DRAGON }, TILE_CORPSE_GOLDEN_DRAGON
},
{
    MONS_GOLDEN_EYE, 'G', ETC_GOLD, "golden eye",
    M_FLIES | M_SEE_INVIS | M_BATTY | M_NO_SKELETON,
    MR_NO_FLAGS,
    190, false, MONS_FLOATING_EYE, MONS_GOLDEN_EYE, MH_NATURAL, 60,
    {  },
    6, 120,
    0, 20, MST_GOLDEN_EYE, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_GOLDEN_EYE }, TILE_ERROR
},
{
    MONS_GOLEM, '9', LIGHTGRAY, "golem",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_GOLEM, MONS_GOLEM, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_IRON_GOLEM }, TILE_ERROR
},
{
    MONS_GOLIATH_FROG, 'F', LIGHTGRAY, "goliath frog",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    749, false, MONS_FROG, MONS_GOLIATH_FROG, MH_NATURAL, 60,
    { {AT_HIT, AF_REACH_TONGUE, 27} },
    12, 420,
    3, 16, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS, 12, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_QUADRUPED_TAILLESS, GOD_NO_GOD,
    { TILEP_MONS_GOLIATH_FROG }, TILE_CORPSE_GOLIATH_FROG
},
{
    MONS_GREAT_ORB_OF_EYES, 'G', LIGHTGREEN, "great orb of eyes",
    M_FLIES | M_SEE_INVIS | M_NO_SKELETON,
    MR_NO_FLAGS,
    878, false, MONS_FLOATING_EYE, MONS_GREAT_ORB_OF_EYES, MH_NATURAL, 120,
    { {AT_BITE, AF_PLAIN, 20} },
    13, 660,
    10, 3, MST_GREAT_ORB_OF_EYES, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_GREAT_ORB_OF_EYES }, TILE_ERROR
},
{
    MONS_GREEN_DEATH, '2', GREEN, "green death",
    M_SEE_INVIS,
    MR_RES_POISON,
    928, false, MONS_GREEN_DEATH, MONS_GREEN_DEATH, MH_DEMONIC, 160,
    { {AT_HIT, AF_PLAIN, 32} },
    13, 715,
    5, 7, MST_GREEN_DEATH, false, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_GREEN_DEATH }, TILE_ERROR
},
{
    MONS_GREEN_DRACONIAN, 'd', GREEN, "green draconian",
    M_SPEAKS | M_COLD_BLOOD,
    MR_RES_POISON,
    1045, false, MONS_DRACONIAN, MONS_GREEN_DRACONIAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 20}, {AT_STING, AF_POISON, 15} },
    14, 980,
    9, 10, MST_NO_SPELLS, true, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_CORPSE_GREEN_DRACONIAN
},
{
    MONS_GREY_DRACONIAN, 'd', LIGHTGRAY, "grey draconian",
    M_SPEAKS | M_COLD_BLOOD | M_NO_POLY_TO,
    MR_NO_FLAGS,
    1054, false, MONS_DRACONIAN, MONS_GREY_DRACONIAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 25}, {AT_TAIL_SLAP, AF_PLAIN, 15} },
    14, 980,
    16, 10, MST_NO_SPELLS, true, S_ROAR,
    I_HUMAN, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_CORPSE_GREY_DRACONIAN
},
{
    MONS_GRINDER, '5', BLUE, "Grinder",
    M_NO_HT_WAND | M_SPEAKS | M_UNIQUE | M_FEMALE,
    MR_RES_POISON | mrd(MR_RES_COLD, 2),
    279, false, MONS_SHADOW_IMP, MONS_SHADOW_IMP, MH_DEMONIC, 20,
    { {AT_HIT, AF_PAIN, 5} },
    6, 390,
    3, 11, MST_GRINDER, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_LITTLE, MON_SHAPE_HUMANOID, GOD_MAKHLEB,
    { TILEP_MONS_GRINDER }, TILE_ERROR
},
{
    MONS_GRUM, 'j', LIGHTRED, "Grum",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    191, false, MONS_GNOLL, MONS_GNOLL, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 20} },
    4, 400,
    2, 9, MST_NO_SPELLS, true, S_GROWL,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_GRUM }, TILE_ERROR
},
{
    MONS_GRUNN, 'j', LIGHTGREEN, "Grunn",
    M_SPEAKS | M_UNIQUE | M_MALE | M_NO_ZOMBIE,
    MR_NO_FLAGS,
    1718, false, MONS_GNOLL, MONS_GNOLL, MH_UNDEAD, 100,
    { {AT_HIT, AF_PLAIN, 50} },
    16, 2000,
    6, 6, MST_NO_SPELLS, false, S_GROWL,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_GRUNN }, TILE_ERROR
},
{
    MONS_GUARDIAN_MUMMY, 'M', YELLOW, "guardian mummy",
    M_FIGHTER,
    MR_RES_COLD,
    328, false, MONS_MUMMY, MONS_MUMMY, MH_UNDEAD, 40,
    { {AT_HIT, AF_PLAIN, 30} },
    7, 455,
    6, 9, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 8, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_GUARDIAN_MUMMY }, TILE_ERROR
},
{
    MONS_GUARDIAN_SERPENT, 'S', WHITE, "guardian serpent",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_RES_POISON,
    456, false, MONS_GUARDIAN_SERPENT, MONS_GUARDIAN_SERPENT, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 26} },
    8, 440,
    6, 14, MST_GUARDIAN_SERPENT, true, S_SHOUT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_GUARDIAN_SERPENT }, TILE_CORPSE_GUARDIAN_SERPENT
},
{
    MONS_GUARDIAN_SPHINX, 'H', LIGHTGRAY, "guardian sphinx",
    M_FLIES | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1729, false, MONS_SPHINX, MONS_GUARDIAN_SPHINX, MH_NATURAL, 80,
    { {AT_BITE, AF_PLAIN, 30}, {AT_CLAW, AF_PLAIN, 15}, {AT_CLAW, AF_PLAIN, 15} },
    18, 1080,
    10, 6, MST_GUARDIAN_SPHINX, true, S_SHOUT,
    I_HUMAN, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_GUARDIAN_SPHINX }, TILE_CORPSE_GUARDIAN_SPHINX
},
{
    MONS_HALAZID_WARLOCK, 'L', GREEN, "halazid warlock",
    M_SEE_INVIS | M_SPEAKS,
    mrd(MR_RES_COLD, 2),
    998, false, MONS_LICH, MONS_LICH, MH_UNDEAD, 100,
    { {AT_TOUCH, AF_PAIN, 20} },
    18, 750,
    8, 12, MST_HALAZID_WARLOCK, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_HALAZID_WARLOCK }, TILE_ERROR
},
{
    MONS_HALFLING, 'p', LIGHTGRAY, "halfling",
    M_SPEAKS | M_WARM_BLOOD | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    30, false, MONS_HALFLING, MONS_HALFLING, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 6} },
    3, 105,
    2, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_HALFLING }, TILE_CORPSE_HALFLING
},
{
    MONS_HAROLD, '@', LIGHTGREEN, "Harold",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    875, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 20} },
    9, 765,
    0, 8, MST_HAROLD, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_HAROLD }, TILE_ERROR
},
{
    MONS_HARPY, 'H', GREEN, "harpy",
    M_FLIES | M_BATTY | M_WARM_BLOOD,
    MR_RES_POISON,
    622, false, MONS_HARPY, MONS_HARPY, MH_NATURAL, 20,
    { {AT_CLAW, AF_PLAIN, 19}, {AT_CLAW, AF_PLAIN, 14} },
    7, 385,
    2, 10, MST_NO_SPELLS, true, S_SCREECH,
    I_HUMAN, HT_LAND, 25, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_HUMANOID_WINGED, GOD_NO_GOD,
    { TILEP_MONS_HARPY }, TILE_CORPSE_HARPY
},
{
    MONS_HAUNTED_ARMOUR, '[', LIGHTGREEN, "haunted armour",
    M_FLIES | M_UNBLINDABLE | M_FIGHTER,
    MR_RES_COLD,
    10, false, MONS_HAUNTED_ARMOUR, MONS_HAUNTED_ARMOUR, MH_UNDEAD, WILL_INVULN,
    { {AT_HIT, AF_TRICKSTER, 1} },
    10, 320,
    13, 10, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, {5, 5, 10, 10, 10},
    MONUSE_STARTING_EQUIPMENT, SIZE_TINY, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILE_UNSEEN_ARMOUR }, TILE_ERROR
},
{
    MONS_HEADMASTER, '@', ETC_IRON, "Head Instructor",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_TWO_WEAPONS,
    MR_NO_FLAGS,
    3034, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 30}, {AT_HIT, AF_PLAIN, 30} },
    20, 1500,
    0, 18, MST_HEADMASTER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_HEADMASTER }, TILE_ERROR
},
{
    MONS_HELL_HOG, 'h', LIGHTRED, "hell hog",
    M_NO_FLAGS,
    mrd(MR_RES_FIRE, 3),
    804, false, MONS_HOG, MONS_HELL_HOG, MH_DEMONIC, 40,
    { {AT_BITE, AF_PLAIN, 20} },
    11, 595,
    2, 9, MST_HELL_HOG, true, S_SQUEAL,
    I_ANIMAL, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_HELL_HOG }, TILE_CORPSE_HELL_HOG
},
{
    MONS_HELL_HOUND, 'h', CYAN, "hell hound",
    M_SEE_INVIS | M_UNBLINDABLE,
    mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1),
    146, false, MONS_HOUND, MONS_HELL_HOUND, MH_DEMONIC, 20,
    { {AT_BITE, AF_PLAIN, 13} },
    5, 275,
    6, 13, MST_HELL_HOUND, true, S_BARK,
    I_ANIMAL, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_HELL_HOUND }, TILE_CORPSE_HELL_HOUND
},
{
    MONS_HELL_KNIGHT, 'p', RED, "hell knight",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD,
    mrd(MR_RES_FIRE, 3),
    781, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 26} },
    10, 650,
    0, 10, MST_HELL_KNIGHT, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_MAKHLEB,
    { TILEP_MONS_HELL_KNIGHT }, TILE_ERROR
},
{
    MONS_HELL_LORD, '&', COLOUR_UNDEF, "hell lord",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_HELL_LORD, MONS_HELL_LORD, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_ERROR
},
{
    MONS_HELL_RAT, 'r', LIGHTRED, "hell rat",
    M_WARM_BLOOD,
    MR_NO_FLAGS,
    34, false, MONS_RAT, MONS_HELL_RAT, MH_DEMONIC, 20,
    { {AT_BITE, AF_DRAIN, 20} },
    3, 165,
    7, 10, MST_NO_SPELLS, true, S_LOUD_ROAR,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_HELL_RAT }, TILE_CORPSE_HELL_RAT
},
{
    MONS_HELL_SENTINEL, '1', BROWN, "Hell Sentinel",
    M_SEE_INVIS,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_POISON, 3) | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, 3) | MR_RES_DAMNATION,
    1822, false, MONS_HELL_SENTINEL, MONS_HELL_SENTINEL, MH_DEMONIC, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 40}, {AT_HIT, AF_PLAIN, 25} },
    19, 1425,
    25, 3, MST_HELL_SENTINEL, false, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_HELL_SENTINEL }, TILE_ERROR
},
{
    MONS_HELLBINDER, '@', ETC_FIRE, "Hellbinder",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    2274, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 6} },
    20, 1500,
    0, 13, MST_HELLBINDER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_HELLBINDER }, TILE_ERROR
},
{
    MONS_HELLEPHANT, 'Y', LIGHTRED, "hellephant",
    M_WARM_BLOOD,
    MR_NO_FLAGS,
    1931, false, MONS_ELEPHANT, MONS_HELLEPHANT, MH_DEMONIC, 140,
    { {AT_TRAMPLE, AF_TRAMPLE, 45}, {AT_BITE, AF_PLAIN, 20}, {AT_GORE, AF_PLAIN, 15} },
    20, 1700,
    13, 10, MST_HELLEPHANT, true, S_TRUMPET,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_HELLEPHANT }, TILE_CORPSE_HELLEPHANT
},
{
    MONS_HELLFIRE_MORTAR, 'I', LIGHTRED, "hellfire mortar",
    M_SPEAKS | M_SEE_INVIS | M_STATIONARY | M_PERIPHERAL | M_NO_REGEN | M_UNSTABLE,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 3) | MR_RES_COLD | MR_RES_PETRIFY,
    1650, false, MONS_HELLFIRE_MORTAR, MONS_HELLFIRE_MORTAR, MH_NONLIVING, WILL_INVULN,
    {  },
    10, 1000,
    20, 0, MST_HELLFIRE_MORTAR, false, S_SILENT,
    I_BRAINLESS, HT_LAVA, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_HELLFIRE_MORTAR }, TILE_ERROR
},
{
    MONS_HELLION, '2', LIGHTRED, "hellion",
    M_NO_FLAGS,
    MR_RES_POISON | MR_RES_DAMNATION,
    384, false, MONS_HELLION, MONS_HELLION, MH_DEMONIC, 60,
    { {AT_HIT, AF_PLAIN, 10} },
    7, 385,
    5, 10, MST_HELLION, false, S_SCREAM,
    I_HUMAN, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_HELLION }, TILE_ERROR
},
{
    MONS_HELLWING, '4', LIGHTGRAY, "hellwing",
    M_FLIES,
    MR_RES_POISON,
    294, false, MONS_HELLWING, MONS_HELLWING, MH_DEMONIC, 60,
    { {AT_HIT, AF_SWOOP, 17}, {AT_HIT, AF_PLAIN, 10} },
    7, 455,
    16, 10, MST_NO_SPELLS, false, S_MOAN,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID_WINGED, GOD_NO_GOD,
    { TILEP_MONS_HELLWING }, TILE_ERROR
},
{
    MONS_HIPPOGRIFF, 'H', YELLOW, "hippogriff",
    M_FLIES | M_WARM_BLOOD,
    MR_NO_FLAGS,
    263, false, MONS_HIPPOGRIFF, MONS_HIPPOGRIFF, MH_NATURAL, 20,
    { {AT_PECK, AF_PLAIN, 12}, {AT_CLAW, AF_PLAIN, 9}, {AT_CLAW, AF_PLAIN, 9} },
    7, 425,
    2, 7, MST_HIPPOGRIFF, true, S_SCREECH,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_HIPPOGRIFF }, TILE_CORPSE_HIPPOGRIFF
},
{
    MONS_HOARFROST_CANNON, 'I', CYAN, "hoarfrost cannon",
    M_SPEAKS | M_SEE_INVIS | M_STATIONARY | M_NO_REGEN,
    MR_RES_ELEC | mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 3) | MR_RES_PETRIFY,
    515, false, MONS_HOARFROST_CANNON, MONS_HOARFROST_CANNON, MH_NONLIVING, WILL_INVULN,
    {  },
    8, 340,
    9, 0, MST_HOARFROST_CANNON, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 5, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_HOARFROST_CANNON }, TILE_ERROR
},
{
    MONS_HOBGOBLIN, 'g', BROWN, "hobgoblin",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    2, false, MONS_GOBLIN, MONS_HOBGOBLIN, MH_NATURAL, 0,
    { {AT_HIT, AF_PLAIN, 5} },
    1, 55,
    2, 10, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_HOBGOBLIN }, TILE_CORPSE_HOBGOBLIN
},
{
    MONS_HOG, 'h', LIGHTMAGENTA, "hog",
    M_WARM_BLOOD,
    MR_NO_FLAGS,
    196, false, MONS_HOG, MONS_HOG, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 14} },
    6, 330,
    2, 9, MST_NO_SPELLS, true, S_SQUEAL,
    I_ANIMAL, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_HOG }, TILE_CORPSE_HOG
},
{
    MONS_HOLY_SWINE, 'h', YELLOW, "holy swine",
    M_FLIES,
    MR_NO_FLAGS,
    792, false, MONS_HOG, MONS_HOLY_SWINE, MH_HOLY, 40,
    { {AT_BITE, AF_HOLY, 20} },
    11, 605,
    2, 9, MST_NO_SPELLS, false, S_SQUEAL,
    I_ANIMAL, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_HOLY_SWINE }, TILE_ERROR
},
{
    MONS_HORNET, 'y', YELLOW, "hornet",
    M_FLIES | M_NO_SKELETON,
    mrd(MR_RES_POISON, -1),
    282, false, MONS_HORNET, MONS_HORNET, MH_NATURAL, 30,
    { {AT_STING, AF_POISON_PARALYSE, 18} },
    6, 330,
    6, 14, MST_NO_SPELLS, true, S_BUZZ,
    I_ANIMAL, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_INSECT_WINGED, GOD_NO_GOD,
    { TILEP_MONS_HORNET }, TILE_CORPSE_HORNET
},
{
    MONS_HOUND, 'h', YELLOW, "hound",
    M_SEE_INVIS | M_UNBLINDABLE | M_WARM_BLOOD,
    MR_NO_FLAGS,
    42, false, MONS_HOUND, MONS_HOUND, MH_NATURAL, 10,
    { {AT_BITE, AF_PLAIN, 6} },
    3, 165,
    2, 13, MST_NO_SPELLS, true, S_BARK,
    I_ANIMAL, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_HOUND }, TILE_CORPSE_HOUND
},
{
    MONS_HOWLER_MONKEY, 'h', LIGHTGREEN, "howler monkey",
    M_WARM_BLOOD,
    MR_NO_FLAGS,
    54, false, MONS_HOWLER_MONKEY, MONS_HOWLER_MONKEY, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 8} },
    3, 185,
    1, 11, MST_HOWLER_MONKEY, true, S_HOWL,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_SMALL, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_HOWLER_MONKEY }, TILE_CORPSE_HOWLER_MONKEY
},
{
    MONS_HUMAN, 'p', LIGHTGRAY, "human",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    197, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 10} },
    6, 330,
    3, 13, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_HUMAN, TVARY_MOD }, TILE_CORPSE_HUMAN
},
{
    MONS_HYDRA, 'D', LIGHTGREEN, "hydra",
    M_COLD_BLOOD | M_FAST_REGEN,
    MR_RES_POISON,
    862, false, MONS_HYDRA, MONS_HYDRA, MH_NATURAL, 60,
    { {AT_BITE, AF_PLAIN, 18} },
    13, 715,
    0, 5, MST_NO_SPELLS, true, S_ROAR,
    I_ANIMAL, HT_AMPHIBIOUS, 10, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_HYDRA }, TILE_CORPSE_HYDRA
},
{
    MONS_ICE_BEAST, 'Y', LIGHTBLUE, "ice beast",
    M_NO_SKELETON,
    MR_RES_POISON | mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 3),
    130, false, MONS_ICE_BEAST, MONS_ICE_BEAST, MH_NATURAL, 20,
    { {AT_HIT, AF_COLD, 5} },
    5, 275,
    5, 10, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_ICE_BEAST }, TILE_ERROR
},
{
    MONS_ICE_DEVIL, '4', WHITE, "ice devil",
    M_NO_FLAGS,
    MR_RES_POISON | mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 3),
    341, false, MONS_ICE_DEVIL, MONS_ICE_DEVIL, MH_DEMONIC, 80,
    { {AT_HIT, AF_COLD, 16} },
    8, 440,
    12, 10, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ICE_DEVIL }, TILE_ERROR
},
{
    MONS_ICE_DRAGON, 'D', WHITE, "ice dragon",
    M_FLIES | M_COLD_BLOOD,
    MR_RES_POISON | mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 2),
    867, false, MONS_DRAGON, MONS_ICE_DRAGON, MH_NATURAL, 40,
    { {AT_BITE, AF_PLAIN, 17}, {AT_CLAW, AF_PLAIN, 17}, {AT_TRAMPLE, AF_TRAMPLE, 17} },
    12, 900,
    10, 8, MST_ICE_DRAGON_BREATH, true, S_LOUD_ROAR,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_ICE_DRAGON }, TILE_CORPSE_ICE_DRAGON
},
{
    MONS_ICE_FIEND, '1', WHITE, "Ice Fiend",
    M_FLIES | M_SEE_INVIS,
    MR_RES_POISON | mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 3),
    1816, false, MONS_ICE_FIEND, MONS_ICE_FIEND, MH_DEMONIC, WILL_INVULN,
    { {AT_CLAW, AF_COLD, 25}, {AT_CLAW, AF_COLD, 25} },
    18, 990,
    15, 6, MST_ICE_FIEND, false, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID_WINGED, GOD_NO_GOD,
    { TILEP_MONS_ICE_FIEND }, TILE_ERROR
},
{
    MONS_ICE_STATUE, 'I', LIGHTBLUE, "ice statue",
    M_SPEAKS | M_STATIONARY,
    MR_RES_ELEC | mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 3) | MR_RES_PETRIFY,
    452, false, MONS_STATUE, MONS_ICE_STATUE, MH_NONLIVING, WILL_INVULN,
    {  },
    8, 720,
    12, 1, MST_ICE_STATUE, false, S_SILENT,
    I_HUMAN, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ICE_STATUE }, TILE_ERROR
},
{
    MONS_IGNACIO, '1', LIGHTMAGENTA, "Ignacio",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_MALE,
    MR_RES_ELEC | MR_RES_POISON | MR_RES_FIRE | MR_RES_COLD,
    6807, false, MONS_EXECUTIONER, MONS_EXECUTIONER, MH_DEMONIC, 160,
    { {AT_HIT, AF_PLAIN, 20}, {AT_HIT, AF_PLAIN, 10}, {AT_HIT, AF_PLAIN, 10}, {AT_HIT, AF_PLAIN, 5} },
    18, 2520,
    10, 15, MST_IGNACIO, false, S_SHOUT,
    I_HUMAN, HT_LAND, 20, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_MAKHLEB,
    { TILEP_MONS_IGNACIO }, TILE_ERROR
},
{
    MONS_IGUANA, 'l', BLUE, "iguana",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    37, false, MONS_GIANT_LIZARD, MONS_IGUANA, MH_NATURAL, 10,
    { {AT_BITE, AF_PLAIN, 15} },
    3, 165,
    5, 9, MST_NO_SPELLS, true, S_HISS,
    I_ANIMAL, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_IGUANA }, TILE_CORPSE_IGUANA
},
{
    MONS_IJYB, 'g', BLUE, "Ijyb",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE | M_ALWAYS_WAND,
    MR_NO_FLAGS,
    36, false, MONS_GOBLIN, MONS_GOBLIN, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 4} },
    3, 240,
    2, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_IJYB }, TILE_ERROR
},
{
    MONS_ILSUIW, 'm', LIGHTGREEN, "Ilsuiw",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    1338, false, MONS_MERFOLK, MONS_MERFOLK, MH_NATURAL, 140,
    { {AT_HIT, AF_PLAIN, 10} },
    16, 1520,
    5, 18, MST_ILSUIW, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, {10, 6, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ILSUIW, TVARY_WATER }, TILE_ERROR
},
{
    MONS_IMPERIAL_MYRMIDON, 'a', LIGHTCYAN, "imperial myrmidon",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1223, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 60,
    { {AT_HIT, AF_VULN, 30} },
    16, 750,
    1, 22, MST_IMPERIAL_MYRMIDON, true, S_SHOUT,
    I_HUMAN, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_IMPERIAL_MYRMIDON }, TILE_ERROR
},
{
    MONS_INUGAMI, 'h', RED, "inugami",
    M_SEE_INVIS | M_UNBLINDABLE | M_WARM_BLOOD | M_GHOST_DEMON | M_NO_POLY_TO | M_NO_ZOMBIE | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    34, false, MONS_HOUND, MONS_INUGAMI, MH_NATURAL, 40,
    { {AT_BITE, AF_PLAIN, 14} },
    4, 55,
    5, 13, MST_NO_SPELLS, false, S_BARK,
    I_ANIMAL, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_INUGAMI }, TILE_ERROR
},
{
    MONS_IRON_DRAGON, 'D', CYAN, "iron dragon",
    M_SEE_INVIS | M_WARM_BLOOD,
    MR_RES_POISON | MR_RES_FIRE | MR_RES_COLD,
    1231, false, MONS_DRAGON, MONS_IRON_DRAGON, MH_NATURAL, 160,
    { {AT_BITE, AF_PLAIN, 25}, {AT_CLAW, AF_PLAIN, 25}, {AT_TRAMPLE, AF_TRAMPLE, 25} },
    18, 1170,
    20, 6, MST_IRON_DRAGON, true, S_LOUD_ROAR,
    I_ANIMAL, HT_LAND, 8, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_IRON_DRAGON }, TILE_CORPSE_IRON_DRAGON
},
{
    MONS_IRON_ELEMENTAL, 'E', ETC_IRON, "iron elemental",
    M_NO_FLAGS,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, 3),
    822, false, MONS_ELEMENTAL, MONS_IRON_ELEMENTAL, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 40} },
    12, 1080,
    20, 2, MST_IRON_ELEMENTAL, false, S_SILENT,
    I_ANIMAL, HT_LAND, 6, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_IRON_ELEMENTAL }, TILE_ERROR
},
{
    MONS_IRON_GIANT, 'C', CYAN, "iron giant",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_RES_POISON | MR_RES_FIRE | MR_RES_COLD,
    1993, false, MONS_GIANT, MONS_IRON_GIANT, MH_NATURAL, 120,
    { {AT_HIT, AF_PLAIN, 65} },
    18, 1800,
    18, 2, MST_IRON_GIANT, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_IRON_GIANT }, TILE_CORPSE_IRON_GIANT
},
{
    MONS_IRON_GOLEM, '9', CYAN, "iron golem",
    M_NO_FLAGS,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, 3),
    940, false, MONS_GOLEM, MONS_IRON_GOLEM, MH_NONLIVING, WILL_INVULN,
    { {AT_PUNCH, AF_PLAIN, 50}, {AT_PUNCH, AF_PLAIN, 50} },
    15, 2700,
    24, 2, MST_NO_SPELLS, false, S_SQUEAK,
    I_BRAINLESS, HT_LAND, 7, {10, 10, 7, 10, 10},
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_IRON_GOLEM }, TILE_ERROR
},
{
    MONS_IRON_IMP, '5', CYAN, "iron imp",
    M_SPEAKS,
    MR_RES_ELEC | MR_RES_POISON | mrd(MR_RES_FIRE, 3) | MR_RES_COLD,
    40, false, MONS_IRON_IMP, MONS_IRON_IMP, MH_DEMONIC, 10,
    { {AT_HIT, AF_PLAIN, 12} },
    3, 165,
    6, 8, MST_NO_SPELLS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 8, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_IRON_IMP }, TILE_ERROR
},
{
    MONS_IRON_TROLL, 'T', CYAN, "iron troll",
    M_SPEAKS | M_WARM_BLOOD | M_FAST_REGEN,
    MR_RES_FIRE | MR_RES_COLD,
    762, false, MONS_TROLL, MONS_IRON_TROLL, MH_NATURAL, 100,
    { {AT_BITE, AF_PLAIN, 35}, {AT_CLAW, AF_PLAIN, 25}, {AT_CLAW, AF_PLAIN, 25} },
    16, 880,
    20, 4, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 7, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_IRON_TROLL }, TILE_CORPSE_IRON_TROLL
},
{
    MONS_IRONBOUND_BEASTMASTER, 'p', BROWN, "ironbound beastmaster",
    M_SPEAKS | M_WARM_BLOOD | M_HAS_AURA,
    MR_NO_FLAGS,
    948, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 45} },
    13, 660,
    0, 14, MST_IRONBOUND_BEASTMASTER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_IRONBOUND_BEASTMASTER }, TILE_ERROR
},
{
    MONS_IRONBOUND_CONVOKER, 'p', YELLOW, "ironbound convoker",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    644, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 20} },
    9, 495,
    0, 10, MST_IRONBOUND_CONVOKER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_IRONBOUND_CONVOKER }, TILE_ERROR
},
{
    MONS_IRONBOUND_FROSTHEART, 'p', BLUE, "ironbound frostheart",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_RES_COLD,
    808, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 40,
    { {AT_TOUCH, AF_COLD, 25} },
    11, 600,
    0, 10, MST_IRONBOUND_FROSTHEART, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_IRONBOUND_FROSTHEART }, TILE_ERROR
},
{
    MONS_IRONBOUND_MECHANIST, 'g', CYAN, "ironbound mechanist",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD | M_TWO_WEAPONS,
    MR_NO_FLAGS,
    1000, false, MONS_GOBLIN, MONS_GOBLIN, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 22}, {AT_HIT, AF_PLAIN, 22} },
    13, 645,
    1, 13, MST_IRONBOUND_MECHANIST, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_IRONBOUND_MECHANIST }, TILE_ERROR
},
{
    MONS_IRONBOUND_PRESERVER, 'p', LIGHTGREEN, "ironbound preserver",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1118, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 25} },
    14, 1120,
    0, 6, MST_IRONBOUND_PRESERVER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_IRONBOUND_PRESERVER }, TILE_ERROR
},
{
    MONS_IRONBOUND_THUNDERHULK, 'O', LIGHTCYAN, "ironbound thunderhulk",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1070, false, MONS_OGRE, MONS_OGRE, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 30} },
    18, 880,
    1, 8, MST_IRONBOUND_THUNDERHULK, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {10, 10, 15, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_IRONBOUND_THUNDERHULK }, TILE_ERROR
},
{
    MONS_JACKAL, 'h', BROWN, "jackal",
    M_WARM_BLOOD,
    MR_NO_FLAGS,
    2, false, MONS_HOUND, MONS_JACKAL, MH_NATURAL, 0,
    { {AT_BITE, AF_PLAIN, 3} },
    1, 55,
    2, 12, MST_NO_SPELLS, true, S_BARK,
    I_ANIMAL, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_JACKAL }, TILE_CORPSE_JACKAL
},
{
    MONS_JELLY, 'J', LIGHTRED, "jelly",
    M_EAT_DOORS | M_SEE_INVIS | M_UNBLINDABLE | M_SPLITS | M_AMORPHOUS | M_ACID_SPLASH | M_NO_SKELETON,
    MR_RES_POISON | mrd(MR_RES_CORR, 3),
    42, false, MONS_JELLY, MONS_JELLY, MH_NATURAL, 10,
    { {AT_HIT, AF_ACID, 3} },
    3, 165,
    0, 2, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_BLOB, GOD_NO_GOD,
    { TILEP_MONS_JELLY }, TILE_ERROR
},
{
    MONS_JEREMIAH, 'F', MAGENTA, "Jeremiah",
    M_SPEAKS | M_UNIQUE | M_GENDER_NEUTRAL,
    MR_NO_FLAGS,
    386, false, MONS_FROG, MONS_BARACHI, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 6} },
    8, 450,
    2, 12, MST_JEREMIAH, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, {12, 12, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_JEREMIAH }, TILE_ERROR
},
{
    MONS_JESSICA, '@', LIGHTGRAY, "Jessica",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    37, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 5} },
    1, 95,
    0, 10, MST_JESSICA, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_JESSICA }, TILE_ERROR
},
{
    MONS_JIANGSHI, 'V', YELLOW, "jiangshi",
    M_FIGHTER,
    MR_RES_COLD,
    909, false, MONS_JIANGSHI, MONS_VAMPIRE, MH_UNDEAD, 80,
    { {AT_CLAW, AF_VAMPIRIC, 27}, {AT_CLAW, AF_VAMPIRIC, 27} },
    10, 650,
    10, 10, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 18, {6, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_JIANGSHI }, TILE_ERROR
},
{
    MONS_JORGRUN, 'g', LIGHTMAGENTA, "Jorgrun",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    1873, false, MONS_DWARF, MONS_DWARF, MH_NATURAL, 120,
    { {AT_HIT, AF_PLAIN, 20} },
    15, 1200,
    2, 15, MST_JORGRUN, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_JORGRUN }, TILE_ERROR
},
{
    MONS_JOROGUMO, 'H', BLUE, "jorogumo",
    M_SEE_INVIS | M_SPEAKS | M_WEB_IMMUNE | M_WARM_BLOOD,
    MR_NO_FLAGS,
    847, false, MONS_JOROGUMO, MONS_JOROGUMO, MH_NATURAL, 60,
    { {AT_HIT, AF_POISON_PARALYSE, 28} },
    12, 850,
    4, 14, MST_JOROGUMO, true, S_SHOUT,
    I_HUMAN, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_ARACHNID, GOD_NO_GOD,
    { TILEP_MONS_JOROGUMO }, TILE_CORPSE_JOROGUMO
},
{
    MONS_JORY, 'V', LIGHTRED, "Jory",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_RES_COLD,
    2381, false, MONS_VAMPIRE, MONS_VAMPIRE, MH_UNDEAD, 160,
    { {AT_HIT, AF_PLAIN, 40}, {AT_BITE, AF_VAMPIRIC, 15} },
    18, 1800,
    10, 15, MST_JORY, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_JORY }, TILE_ERROR
},
{
    MONS_JOSEPH, '@', CYAN, "Joseph",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_ARCHER | M_MALE,
    MR_NO_FLAGS,
    461, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 15} },
    6, 660,
    0, 10, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_JOSEPH }, TILE_ERROR
},
{
    MONS_JOSEPHINA, 'L', LIGHTBLUE, "Josephina",
    M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_FEMALE,
    mrd(MR_RES_COLD, 3),
    3438, false, MONS_LICH, MONS_LICH, MH_UNDEAD, WILL_INVULN,
    { {AT_HIT, AF_COLD, 27}, {AT_TOUCH, AF_DRAIN, 15} },
    21, 1500,
    10, 21, MST_JOSEPHINA, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_JOSEPHINA }, TILE_ERROR
},
{
    MONS_JOSEPHINE, '@', WHITE, "Josephine",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    mrd(MR_RES_NEG, 3),
    912, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 11} },
    10, 700,
    0, 10, MST_JOSEPHINE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_JOSEPHINE }, TILE_ERROR
},
{
    MONS_JUGGERNAUT, 'C', LIGHTGREEN, "juggernaut",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    3979, false, MONS_GIANT, MONS_JUGGERNAUT, MH_NATURAL, 120,
    { {AT_HIT, AF_PLAIN, 80}, {AT_HIT, AF_PLAIN, 40} },
    20, 1700,
    20, 5, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 15, {10, 10, 45, 10, 10},
    MONUSE_OPEN_DOORS, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_JUGGERNAUT }, TILE_CORPSE_JUGGERNAUT
},
{
    MONS_JUMPING_SPIDER, 's', LIGHTBLUE, "jumping spider",
    M_WEB_IMMUNE | M_NO_SKELETON,
    mrd(MR_RES_POISON, -1),
    272, false, MONS_SPIDER, MONS_JUMPING_SPIDER, MH_NATURAL, 20,
    { {AT_POUNCE, AF_ENSNARE, 20}, {AT_BITE, AF_PLAIN, 8} },
    8, 320,
    6, 12, MST_JUMPING_SPIDER, true, S_FAINT_SKITTER,
    I_ANIMAL, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_ARACHNID, GOD_NO_GOD,
    { TILEP_MONS_JUMPING_SPIDER }, TILE_CORPSE_JUMPING_SPIDER
},
{
    MONS_KHUFU, 'M', LIGHTRED, "Khufu",
    M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_MALE,
    MR_RES_ELEC | MR_RES_COLD,
    4893, false, MONS_MUMMY, MONS_MUMMY, MH_UNDEAD, 160,
    { {AT_HIT, AF_PLAIN, 35} },
    18, 2430,
    10, 6, MST_KHUFU, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_KHUFU }, TILE_ERROR
},
{
    MONS_KILLER_BEE, 'y', BROWN, "killer bee",
    M_FLIES | M_NO_SKELETON,
    mrd(MR_RES_POISON, -1),
    62, false, MONS_KILLER_BEE, MONS_KILLER_BEE, MH_NATURAL, 10,
    { {AT_STING, AF_POISON, 10} },
    3, 165,
    2, 18, MST_NO_SPELLS, true, S_BUZZ,
    I_ANIMAL, HT_LAND, 20, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_INSECT_WINGED, GOD_NO_GOD,
    { TILEP_MONS_KILLER_BEE }, TILE_CORPSE_KILLER_BEE
},
{
    MONS_KILLER_KLOWN, 'p', ETC_RANDOM, "Killer Klown",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    3010, false, MONS_HUMAN, MONS_KILLER_KLOWN, MH_NATURAL, 160,
    { {AT_HIT, AF_PLAIN, 30} },
    20, 1500,
    10, 15, MST_KILLER_KLOWN, true, S_SHOUT,
    I_HUMAN, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_KILLER_KLOWN, TVARY_RANDOM }, TILE_CORPSE_KILLER_KLOWN
},
{
    MONS_KIRKE, '@', LIGHTBLUE, "Kirke",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    1439, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 18} },
    16, 1120,
    0, 10, MST_KIRKE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_KIRKE }, TILE_ERROR
},
{
    MONS_KOBOLD_BLASTMINER, 'K', CYAN, "kobold blastminer",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    466, false, MONS_KOBOLD, MONS_KOBOLD, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 12} },
    8, 390,
    4, 14, MST_KOBOLD_BLASTMINER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {10, 10, 10, 10, 15},
    MONUSE_WEAPONS_ARMOUR, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_KOBOLD_BLASTMINER }, TILE_ERROR
},
{
    MONS_KOBOLD_BRIGAND, 'K', YELLOW, "kobold brigand",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    98, false, MONS_KOBOLD, MONS_KOBOLD, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 7} },
    5, 275,
    3, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_KOBOLD_BRIGAND }, TILE_ERROR
},
{
    MONS_KOBOLD_DEMONOLOGIST, 'K', MAGENTA, "kobold demonologist",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    370, false, MONS_KOBOLD, MONS_KOBOLD, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 4} },
    6, 390,
    2, 13, MST_KOBOLD_DEMONOLOGIST, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_KOBOLD_DEMONOLOGIST }, TILE_ERROR
},
{
    MONS_KOBOLD_FLESHCRAFTER, 'K', LIGHTMAGENTA, "kobold fleshcrafter",
    M_SPEAKS | M_WARM_BLOOD | M_FAST_REGEN,
    MR_RES_POISON,
    955, false, MONS_KOBOLD, MONS_KOBOLD, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 24}, {AT_TENTACLE_SLAP, AF_POISON, 16} },
    13, 660,
    8, 16, MST_KOBOLD_FLESHCRAFTER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_KOBOLD_FLESHCRAFTER }, TILE_ERROR
},
{
    MONS_KOBOLD_GEOMANCER, 'K', GREEN, "kobold geomancer",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    135, false, MONS_KOBOLD, MONS_KOBOLD, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 4} },
    3, 290,
    2, 13, MST_KOBOLD_GEOMANCER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_KOBOLD_GEOMANCER, TVARY_CYCLE }, TILE_ERROR
},
{
    MONS_KOBOLD, 'K', BROWN, "kobold",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1, false, MONS_KOBOLD, MONS_KOBOLD, MH_NATURAL, 0,
    { {AT_HIT, AF_PLAIN, 1} },
    1, 35,
    2, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_KOBOLD }, TILE_CORPSE_KOBOLD
},
{
    MONS_KOMODO_DRAGON, 'l', LIGHTRED, "komodo dragon",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    361, false, MONS_GIANT_LIZARD, MONS_KOMODO_DRAGON, MH_NATURAL, 40,
    { {AT_BITE, AF_PLAIN, 34} },
    8, 440,
    7, 8, MST_NO_SPELLS, true, S_HISS,
    I_ANIMAL, HT_AMPHIBIOUS, 10, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_KOMODO_DRAGON }, TILE_CORPSE_KOMODO_DRAGON
},
{
    MONS_KRAKEN_TENTACLE_SEGMENT, '*', LIGHTMAGENTA, "tentacle segment",
    M_FLIES | M_STATIONARY | M_COLD_BLOOD | M_NO_EXP_GAIN | M_NO_POLY_TO | M_NO_THREAT | M_PERIPHERAL,
    MR_NO_FLAGS,
    10, false, MONS_KRAKEN, MONS_KRAKEN_TENTACLE_SEGMENT, MH_NATURAL, WILL_INVULN,
    {  },
    12, 480,
    5, 7, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS, 18, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_ERROR
},
{
    MONS_KRAKEN_TENTACLE, 'w', LIGHTMAGENTA, "tentacle",
    M_FLIES | M_STATIONARY | M_COLD_BLOOD | M_NO_EXP_GAIN | M_NO_POLY_TO | M_PERIPHERAL,
    MR_NO_FLAGS,
    10, false, MONS_KRAKEN, MONS_KRAKEN_TENTACLE, MH_NATURAL, WILL_INVULN,
    { {AT_TENTACLE_SLAP, AF_PLAIN, 29} },
    12, 480,
    5, 7, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS, 17, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_ERROR
},
{
    MONS_KRAKEN, 'X', LIGHTMAGENTA, "kraken",
    M_COLD_BLOOD | M_NO_SKELETON,
    MR_NO_FLAGS,
    1525, false, MONS_KRAKEN, MONS_KRAKEN, MH_NATURAL, 60,
    { {AT_BITE, AF_PLAIN, 50} },
    16, 2080,
    20, 0, MST_KRAKEN, true, S_SILENT,
    I_ANIMAL, HT_DEEP_WATER, 14, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_KRAKEN }, TILE_CORPSE_KRAKEN
},
{
    MONS_LAUGHING_SKULL, 'z', LIGHTRED, "laughing skull",
    M_FLIES,
    mrd(MR_RES_FIRE, 2),
    125, false, MONS_LAUGHING_SKULL, MONS_LAUGHING_SKULL, MH_UNDEAD, 20,
    { {AT_HEADBUTT, AF_PLAIN, 16} },
    5, 240,
    4, 18, MST_LAUGHING_SKULL, false, S_SCREAM,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_LAUGHING_SKULL }, TILE_ERROR
},
{
    MONS_LAVA_SNAKE, 'S', YELLOW, "lava snake",
    M_WARM_BLOOD,
    mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1),
    48, false, MONS_SNAKE, MONS_LAVA_SNAKE, MH_NATURAL, 10,
    { {AT_BITE, AF_FIRE, 7} },
    3, 165,
    2, 17, MST_LAVA_SNAKE, true, S_HISS,
    I_ANIMAL, HT_LAVA, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_LAVA_SNAKE }, TILE_CORPSE_LAVA_SNAKE
},
{
    MONS_LEMURE, '5', YELLOW, "lemure",
    M_SPEAKS,
    MR_NO_FLAGS,
    106, false, MONS_LEMURE, MONS_LEMURE, MH_DEMONIC, 20,
    { {AT_HIT, AF_PLAIN, 10} },
    5, 275,
    4, 12, MST_NO_SPELLS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_LEMURE }, TILE_ERROR
},
{
    MONS_LERNAEAN_HYDRA, 'D', YELLOW, "Lernaean hydra",
    M_NAME_THE | M_COLD_BLOOD | M_UNIQUE | M_FAST_REGEN | M_TALL_TILE,
    MR_RES_POISON,
    3031, false, MONS_HYDRA, MONS_HYDRA, MH_NATURAL, 120,
    { {AT_BITE, AF_PLAIN, 18} },
    30, 1500,
    0, 5, MST_NO_SPELLS, true, S_LOUD_ROAR,
    I_ANIMAL, HT_AMPHIBIOUS, 10, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_LERNAEAN_HYDRA }, TILE_ERROR
},
{
    MONS_LICH, 'L', LIGHTGRAY, "lich",
    M_SEE_INVIS | M_SPEAKS,
    mrd(MR_RES_COLD, 2),
    1745, false, MONS_LICH, MONS_LICH, MH_UNDEAD, WILL_INVULN,
    { {AT_TOUCH, AF_DRAIN, 15} },
    20, 800,
    10, 10, MST_LICH, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_LICH }, TILE_ERROR
},
{
    MONS_LIGHTNING_SPIRE, 'I', ETC_ELECTRICITY, "lightning spire",
    M_STATIONARY | M_NO_POLY_TO,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, 2) | MR_RES_PETRIFY,
    613, false, MONS_LIGHTNING_SPIRE, MONS_LIGHTNING_SPIRE, MH_NONLIVING, WILL_INVULN,
    {  },
    10, 700,
    13, 3, MST_ZAPPER, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_LIGHTNING_SPIRE }, TILE_ERROR
},
{
    MONS_LINDWURM, 'k', LIGHTRED, "lindwurm",
    M_WARM_BLOOD,
    MR_NO_FLAGS,
    644, false, MONS_DRAKE, MONS_LINDWURM, MH_NATURAL, 40,
    { {AT_BITE, AF_PLAIN, 20}, {AT_CLAW, AF_PLAIN, 10}, {AT_CLAW, AF_PLAIN, 10} },
    9, 495,
    8, 6, MST_LINDWURM, true, S_ROAR,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_LINDWURM }, TILE_CORPSE_LINDWURM
},
{
    MONS_LIVING_SPELL, '*', LIGHTBLUE, "living spell",
    M_FLIES | M_INSUBSTANTIAL | M_NO_EXP_GAIN,
    MR_NO_FLAGS,
    10, false, MONS_LIVING_SPELL, MONS_LIVING_SPELL, MH_NONLIVING, WILL_INVULN,
    {  },
    1, 3,
    0, 5, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_LIVING_SPELL }, TILE_ERROR
},
{
    MONS_LODUL, 'O', CYAN, "Lodul",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    754, false, MONS_OGRE, MONS_OGRE, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 30} },
    6, 700,
    3, 7, MST_LODUL, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {10, 10, 15, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_LODUL }, TILE_ERROR
},
{
    MONS_LOM_LOBON, '&', LIGHTBLUE, "Lom Lobon",
    M_FLIES | M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_TALL_TILE | M_GENDER_NEUTRAL,
    mrd(MR_RES_ELEC, 3) | MR_RES_POISON | MR_RES_FIRE | mrd(MR_RES_COLD, 3),
    6087, false, MONS_PANDEMONIUM_LORD, MONS_LOM_LOBON, MH_DEMONIC, WILL_INVULN,
    { {AT_HIT, AF_ANTIMAGIC, 40} },
    19, 3895,
    10, 20, MST_LOM_LOBON, false, S_SCREAM,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_LOM_LOBON }, TILE_ERROR
},
{
    MONS_LOST_SOUL, '*', LIGHTGREEN, "lost soul",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL | M_NO_EXP_GAIN | M_MAINTAIN_RANGE,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    2, false, MONS_LOST_SOUL, MONS_LOST_SOUL, MH_UNDEAD, WILL_INVULN,
    {  },
    10, 250,
    0, 10, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_LOST_SOUL }, TILE_ERROR
},
{
    MONS_LOUISE, '@', LIGHTMAGENTA, "Louise",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    1207, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 17} },
    13, 1040,
    0, 10, MST_LOUISE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_LOUISE }, TILE_ERROR
},
{
    MONS_LURKING_HORROR, '*', BLUE, "lurking horror",
    M_FLIES | M_INSUBSTANTIAL | M_NO_EXP_GAIN,
    MR_NO_FLAGS,
    10, false, MONS_LURKING_HORROR, MONS_LURKING_HORROR, MH_NONLIVING, 10,
    { {AT_HIT, AF_PLAIN, 1} },
    1, 10,
    0, 10, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_LURKING_HORROR }, TILE_ERROR
},
{
    MONS_MAGGIE, '@', LIGHTRED, "Maggie",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    399, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 10} },
    5, 600,
    0, 10, MST_MAGGIE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MAGGIE }, TILE_ERROR
},
{
    MONS_MALARIOUS_MERFOLK_AVATAR, 'm', LIGHTBLUE, "malarious merfolk avatar",
    M_SPEAKS | M_WARM_BLOOD | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    31, false, MONS_MERFOLK, MONS_MERFOLK, MH_NATURAL, 120,
    {  },
    3, 195,
    4, 12, MST_MERFOLK_AVATAR, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, {10, 6, 10, 10, 10},
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MERFOLK_AVATAR, TVARY_WATER }, TILE_ERROR
},
{
    MONS_MANA_VIPER, 'S', MAGENTA, "mana viper",
    M_SEE_INVIS | M_COLD_BLOOD,
    MR_RES_POISON,
    718, false, MONS_SNAKE, MONS_MANA_VIPER, MH_NATURAL, 100,
    { {AT_BITE, AF_ANTIMAGIC, 23} },
    10, 495,
    3, 14, MST_NO_SPELLS, false, S_HISS,
    I_ANIMAL, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_MANA_VIPER }, TILE_ERROR
},
{
    MONS_MANTICORE, 'H', RED, "manticore",
    M_FLIES | M_WARM_BLOOD,
    MR_NO_FLAGS,
    529, false, MONS_MANTICORE, MONS_MANTICORE, MH_NATURAL, 40,
    { {AT_BITE, AF_PLAIN, 26}, {AT_CLAW, AF_PLAIN, 14}, {AT_CLAW, AF_PLAIN, 14} },
    9, 495,
    5, 7, MST_MANTICORE, true, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_MANTICORE }, TILE_CORPSE_MANTICORE
},
{
    MONS_MARA, 'R', LIGHTMAGENTA, "Mara",
    M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_MALE | M_TWO_WEAPONS,
    MR_RES_POISON | mrd(MR_RES_FIRE, 2),
    4630, false, MONS_RAKSHASA, MONS_RAKSHASA, MH_DEMONIC, 140,
    { {AT_HIT, AF_PLAIN, 27}, {AT_HIT, AF_PLAIN, 27} },
    18, 1440,
    10, 14, MST_MARA, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MARA }, TILE_ERROR
},
{
    MONS_MARGERY, '@', LIGHTRED, "Margery",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    2809, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 140,
    { {AT_HIT, AF_PLAIN, 30} },
    22, 1650,
    0, 10, MST_MARGERY, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MARGERY }, TILE_ERROR
},
{
    MONS_MARROWCUDA, 'F', LIGHTBLUE, "marrowcuda",
    M_FLIES,
    MR_RES_COLD,
    73, false, MONS_MARROWCUDA, MONS_MARROWCUDA, MH_UNDEAD, 10,
    { {AT_BITE, AF_SWARM, 8} },
    4, 235,
    4, 11, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_FISH, GOD_NO_GOD,
    { TILEP_MONS_MARROWCUDA }, TILE_ERROR
},
{
    MONS_MARTYRED_SHADE, 'W', YELLOW, "martyred shade",
    M_FLIES | M_SPEAKS | M_INSUBSTANTIAL | M_FAST_REGEN | M_HAS_AURA,
    MR_NO_FLAGS,
    307, false, MONS_PHANTOM, MONS_MARTYRED_SHADE, MH_UNDEAD, 60,
    {  },
    11, 605,
    0, 14, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 7, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MARTYRED_SHADE }, TILE_ERROR
},
{
    MONS_MAURICE, 'f', LIGHTGREEN, "Maurice",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FAST_REGEN | M_MALE | M_NO_SKELETON | M_ALWAYS_WAND,
    MR_NO_FLAGS,
    526, false, MONS_VINE_STALKER, MONS_VINE_STALKER, MH_NATURAL, 40,
    { {AT_HIT, AF_STEAL, 9}, {AT_BITE, AF_ANTIMAGIC, 9} },
    5, 600,
    1, 13, MST_MAURICE, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MAURICE }, TILE_ERROR
},
{
    MONS_MELIAI, 'y', GREEN, "meliai",
    M_FLIES | M_WEB_IMMUNE | M_NO_SKELETON,
    mrd(MR_RES_POISON, -1),
    484, false, MONS_KILLER_BEE, MONS_MELIAI, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 14}, {AT_STING, AF_POISON, 12} },
    7, 245,
    2, 14, MST_MELIAI, true, S_BUZZ,
    I_HUMAN, HT_LAND, 20, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_SMALL, MON_SHAPE_INSECT_WINGED, GOD_NO_GOD,
    { TILEP_MONS_MELIAI }, TILE_CORPSE_MELIAI
},
{
    MONS_MENKAURE, 'M', MAGENTA, "Menkaure",
    M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_MALE,
    mrd(MR_RES_FIRE, -1) | MR_RES_COLD,
    171, false, MONS_MUMMY, MONS_MUMMY, MH_UNDEAD, 20,
    { {AT_HIT, AF_PLAIN, 25} },
    3, 240,
    3, 6, MST_MENKAURE, false, S_SHOUT,
    I_HUMAN, HT_LAND, 8, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MENKAURE }, TILE_ERROR
},
{
    MONS_MENNAS, 'A', LIGHTCYAN, "Mennas",
    M_FLIES | M_FIGHTER | M_SPEAKS | M_UNIQUE | M_MALE,
    MR_RES_ELEC | MR_RES_POISON,
    4370, false, MONS_ANGEL, MONS_ANGEL, MH_HOLY, 160,
    { {AT_HIT, AF_PLAIN, 30}, {AT_HIT, AF_PLAIN, 20} },
    19, 1520,
    15, 28, MST_MENNAS, false, S_SILENT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_WINGED, GOD_ZIN,
    { TILEP_MONS_MENNAS }, TILE_ERROR
},
{
    MONS_MERFOLK_AQUAMANCER, 'm', GREEN, "merfolk aquamancer",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    829, false, MONS_MERFOLK, MONS_MERFOLK, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 15} },
    14, 630,
    0, 12, MST_MERFOLK_AQUAMANCER, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, {10, 6, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MERFOLK_AQUAMANCER, TVARY_WATER }, TILE_ERROR
},
{
    MONS_MERFOLK_AVATAR, 'm', LIGHTCYAN, "merfolk avatar",
    M_SPEAKS | M_WARM_BLOOD | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    842, false, MONS_MERFOLK, MONS_MERFOLK, MH_NATURAL, 120,
    {  },
    13, 845,
    4, 12, MST_MERFOLK_AVATAR, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, {10, 6, 10, 10, 10},
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MERFOLK_AVATAR, TVARY_WATER }, TILE_ERROR
},
{
    MONS_MERFOLK_IMPALER, 'm', YELLOW, "merfolk impaler",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    915, false, MONS_MERFOLK, MONS_MERFOLK, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 22} },
    12, 780,
    0, 18, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, {10, 6, 6, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MERFOLK_IMPALER, TVARY_WATER }, TILE_ERROR
},
{
    MONS_MERFOLK_JAVELINEER, 'm', WHITE, "merfolk javelineer",
    M_SPEAKS | M_WARM_BLOOD | M_ARCHER | M_PREFER_RANGED,
    MR_NO_FLAGS,
    920, false, MONS_MERFOLK, MONS_MERFOLK, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 12} },
    13, 730,
    0, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, {10, 6, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MERFOLK_JAVELINEER, TVARY_WATER }, TILE_ERROR
},
{
    MONS_MERFOLK_SIREN, 'm', CYAN, "merfolk siren",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    469, false, MONS_MERFOLK, MONS_MERFOLK, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 19} },
    9, 405,
    4, 12, MST_MERFOLK_SIREN, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, {10, 6, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MERFOLK_SIREN, TVARY_WATER }, TILE_ERROR
},
{
    MONS_MERFOLK, 'm', LIGHTRED, "merfolk",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    301, false, MONS_MERFOLK, MONS_MERFOLK, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 22} },
    10, 550,
    4, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, {10, 6, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MERFOLK, TVARY_WATER }, TILE_CORPSE_MERFOLK
},
{
    MONS_METEORAN, 'p', YELLOW, "meteoran",
    M_SPEAKS | M_WARM_BLOOD | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    156, false, MONS_METEORAN, MONS_METEORAN, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 10} },
    5, 375,
    2, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_METEORAN }, TILE_CORPSE_METEORAN
},
{
    MONS_MINOTAUR, 'H', LIGHTRED, "minotaur",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    989, false, MONS_MINOTAUR, MONS_MINOTAUR, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 35}, {AT_GORE, AF_PLAIN, 20} },
    14, 780,
    6, 9, MST_NO_SPELLS, true, S_BELLOW,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MINOTAUR }, TILE_CORPSE_MINOTAUR
},
{
    MONS_MLIOGLOTL, 'X', BROWN, "Mlioglotl",
    M_SPEAKS | M_UNIQUE | M_MALE,
    MR_RES_ELEC | MR_RES_POISON | MR_RES_COLD,
    1805, false, MONS_THRASHING_HORROR, MONS_MLIOGLOTL, MH_DEMONIC, 120,
    { {AT_HIT, AF_PLAIN, 20}, {AT_TRAMPLE, AF_TRAMPLE, 25} },
    15, 1400,
    10, 5, MST_MLIOGLOTL, false, S_SHOUT,
    I_HUMAN, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_MISC, GOD_LUGONU,
    { TILEP_MONS_MLIOGLOTL }, TILE_ERROR
},
{
    MONS_MNOLEG, '&', LIGHTGREEN, "Mnoleg",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_TALL_TILE | M_GENDER_NEUTRAL,
    MR_RES_ELEC | MR_RES_POISON | MR_RES_FIRE,
    6890, false, MONS_PANDEMONIUM_LORD, MONS_MNOLEG, MH_DEMONIC, WILL_INVULN,
    { {AT_RANDOM, AF_CHAOTIC, 47}, {AT_RANDOM, AF_PLAIN, 41}, {AT_RANDOM, AF_BLINK, 37} },
    17, 4210,
    11, 29, MST_MNOLEG, false, S_BUZZ,
    I_HUMAN, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MNOLEG }, TILE_ERROR
},
{
    MONS_MOLTEN_GARGOYLE, '9', LIGHTRED, "molten gargoyle",
    M_FLIES,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 3) | MR_RES_PETRIFY,
    431, false, MONS_GOLEM, MONS_MOLTEN_GARGOYLE, MH_NONLIVING, 60,
    { {AT_HIT, AF_FIRE, 20} },
    7, 315,
    14, 7, MST_MOLTEN_GARGOYLE, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID_WINGED_TAILED, GOD_NO_GOD,
    { TILEP_MONS_MOLTEN_GARGOYLE }, TILE_ERROR
},
{
    MONS_MONARCH_BOMB, 'E', LIGHTRED, "monarch bomb",
    M_FLIES,
    mrd(MR_RES_FIRE, 3),
    800, false, MONS_MONARCH_BOMB, MONS_MONARCH_BOMB, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_BOMBLET, 24} },
    14, 440,
    14, 9, MST_MONARCH_BOMB, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_MONARCH_BOMB }, TILE_ERROR
},
{
    MONS_MOON_TROLL, 'T', LIGHTCYAN, "moon troll",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_FAST_REGEN | M_NO_POLY_TO | M_NO_GEN_DERIVED | M_WARDED,
    MR_RES_POISON | MR_RES_FIRE | MR_RES_COLD,
    1763, false, MONS_TROLL, MONS_MOON_TROLL, MH_NATURAL, 140,
    { {AT_BITE, AF_PLAIN, 35}, {AT_CLAW, AF_PLAIN, 25}, {AT_CLAW, AF_PLAIN, 25} },
    17, 1170,
    20, 4, MST_MOON_TROLL, false, S_SHOUT,
    I_HUMAN, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MOON_TROLL }, TILE_ERROR
},
{
    MONS_MOTH_OF_WRATH, 'y', LIGHTRED, "moth of wrath",
    M_FLIES | M_WEB_IMMUNE | M_NO_SKELETON,
    MR_NO_FLAGS,
    501, false, MONS_MOTH, MONS_MOTH_OF_WRATH, MH_NATURAL, 40,
    { {AT_BITE, AF_RAGE, 25} },
    9, 495,
    0, 10, MST_MOTH_OF_WRATH, true, S_SILENT,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_INSECT_WINGED, GOD_NO_GOD,
    { TILEP_MONS_MOTH_OF_WRATH }, TILE_CORPSE_MOTH_OF_WRATH
},
{
    MONS_MOTH, 'y', WHITE, "moth",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_MOTH, MONS_MOTH, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, true, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_MOTH_OF_WRATH }, TILE_ERROR
},
{
    MONS_MOUNTAINSHELL, 't', YELLOW, "mountainshell",
    M_COLD_BLOOD | M_WARDED,
    MR_NO_FLAGS,
    940, false, MONS_MOUNTAINSHELL, MONS_MOUNTAINSHELL, MH_NATURAL, 80,
    { {AT_HEADBUTT, AF_PLAIN, 24} },
    12, 610,
    7, 2, MST_MOUNTAINSHELL, true, S_GROWL,
    I_ANIMAL, HT_LAND, 7, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED_TAILLESS, GOD_NO_GOD,
    { TILEP_MONS_MOUNTAINSHELL }, TILE_CORPSE_MOUNTAINSHELL
},
{
    MONS_MUMMY_PRIEST, 'M', RED, "mummy priest",
    M_SPEAKS,
    MR_RES_ELEC | MR_RES_COLD,
    920, false, MONS_MUMMY, MONS_MUMMY, MH_UNDEAD, 120,
    { {AT_HIT, AF_PLAIN, 30} },
    10, 650,
    8, 7, MST_MUMMY_PRIEST, false, S_SILENT,
    I_HUMAN, HT_LAND, 8, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MUMMY_PRIEST }, TILE_ERROR
},
{
    MONS_MUMMY, 'M', LIGHTGRAY, "mummy",
    M_NO_FLAGS,
    mrd(MR_RES_FIRE, -1) | MR_RES_COLD,
    18, false, MONS_MUMMY, MONS_MUMMY, MH_UNDEAD, 20,
    { {AT_HIT, AF_PLAIN, 20} },
    3, 195,
    3, 6, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 6, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MUMMY }, TILE_ERROR
},
{
    MONS_MURRAY, 'z', LIGHTRED, "Murray",
    M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_MALE,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, 2),
    1586, false, MONS_CURSE_SKULL, MONS_CURSE_SKULL, MH_UNDEAD, WILL_INVULN,
    { {AT_BITE, AF_PLAIN, 20}, {AT_BITE, AF_PLAIN, 20} },
    14, 1610,
    30, 10, MST_MURRAY, false, S_MOAN,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_MURRAY }, TILE_ERROR
},
{
    MONS_MUTANT_BEAST, 'H', MAGENTA, "mutant beast",
    M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    25, true, MONS_MUTANT_BEAST, MONS_MUTANT_BEAST, MH_NATURAL, -3,
    { {AT_HIT, AF_PLAIN, 27} },
    15, 825,
    8, 5, MST_NO_SPELLS, true, S_RANDOM,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MUTANT_BEAST_BASE }, TILE_CORPSE_MUTANT_BEAST
},
{
    MONS_NAGA_MAGE, 'N', MAGENTA, "naga mage",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_RES_POISON,
    443, false, MONS_NAGA, MONS_NAGA, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 14}, {AT_CONSTRICT, AF_CRUSH, 4} },
    7, 385,
    6, 10, MST_NAGA_MAGE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {14, 14, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_NAGA, GOD_NO_GOD,
    { TILEP_MONS_NAGA_MAGE }, TILE_ERROR
},
{
    MONS_NAGA_RITUALIST, 'N', BROWN, "naga ritualist",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_RES_POISON,
    686, false, MONS_NAGA, MONS_NAGA, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 14}, {AT_CONSTRICT, AF_CRUSH, 4} },
    8, 600,
    6, 10, MST_NAGA_RITUALIST, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {14, 14, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_NAGA, GOD_NO_GOD,
    { TILEP_MONS_NAGA_RITUALIST }, TILE_ERROR
},
{
    MONS_NAGA_SHARPSHOOTER, 'N', LIGHTGRAY, "naga sharpshooter",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_ARCHER | M_PREFER_RANGED,
    MR_RES_POISON,
    790, false, MONS_NAGA, MONS_NAGA, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 17}, {AT_CONSTRICT, AF_CRUSH, 5} },
    9, 720,
    6, 10, MST_NAGA_SHARPSHOOTER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {14, 14, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_NAGA, GOD_NO_GOD,
    { TILEP_MONS_NAGA_SHARPSHOOTER }, TILE_ERROR
},
{
    MONS_NAGA_WARRIOR, 'N', BLUE, "naga warrior",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_RES_POISON,
    791, false, MONS_NAGA, MONS_NAGA, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 24}, {AT_CONSTRICT, AF_CRUSH, 5} },
    10, 750,
    6, 10, MST_NAGA_WARRIOR, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {14, 14, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_NAGA, GOD_NO_GOD,
    { TILEP_MONS_NAGA_WARRIOR }, TILE_ERROR
},
{
    MONS_NAGA, 'N', GREEN, "naga",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_RES_POISON,
    161, false, MONS_NAGA, MONS_NAGA, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 22}, {AT_CONSTRICT, AF_CRUSH, 4} },
    5, 275,
    6, 10, MST_NAGA, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {14, 14, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_NAGA, GOD_NO_GOD,
    { TILEP_MONS_NAGA }, TILE_CORPSE_NAGA
},
{
    MONS_NAGARAJA, 'N', LIGHTMAGENTA, "nagaraja",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_RES_POISON,
    1323, false, MONS_NAGA, MONS_NAGA, MH_NATURAL, 140,
    { {AT_HIT, AF_PLAIN, 27}, {AT_CONSTRICT, AF_CRUSH, 7} },
    15, 825,
    6, 10, MST_NAGARAJA, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {14, 14, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_NAGA, GOD_NO_GOD,
    { TILEP_MONS_NAGARAJA }, TILE_ERROR
},
{
    MONS_NAMELESS, 'X', CYAN, "nameless horror",
    M_SEE_INVIS | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    11, false, MONS_NAMELESS, MONS_NAMELESS, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_ANTIMAGIC, 30} },
    15, 600,
    8, 2, MST_NAMELESS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_NAMELESS_HORROR }, TILE_ERROR
},
{
    MONS_NARGUN, '9', BLUE, "nargun",
    M_FIGHTER | M_SEE_INVIS,
    MR_RES_ELEC | mrd(MR_RES_COLD, 3) | MR_RES_PETRIFY,
    1284, false, MONS_GOLEM, MONS_NARGUN, MH_NONLIVING, 100,
    { {AT_HIT, AF_VULN, 40}, {AT_BITE, AF_COLD, 30} },
    22, 540,
    25, 4, MST_NARGUN, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_BLOB, GOD_NO_GOD,
    { TILEP_MONS_NARGUN }, TILE_ERROR
},
{
    MONS_NATASHA, 'h', MAGENTA, "Natasha",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    35, false, MONS_FELID, MONS_FELID, MH_NATURAL, 20,
    { {AT_CLAW, AF_PLAIN, 10} },
    3, 150,
    2, 12, MST_NATASHA, true, S_HISS,
    I_HUMAN, HT_LAND, 10, {8, 8, 10, 10, 10},
    MONUSE_STARTING_EQUIPMENT, SIZE_LITTLE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_NATASHA }, TILE_ERROR
},
{
    MONS_NECROMANCER, 'p', WHITE, "necromancer",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    612, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 6} },
    10, 400,
    0, 13, MST_NECROMANCER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_NECROMANCER }, TILE_ERROR
},
{
    MONS_NECROPHAGE, 'n', LIGHTGRAY, "necrophage",
    M_NO_ZOMBIE,
    MR_RES_COLD,
    76, false, MONS_GHOUL, MONS_NECROPHAGE, MH_UNDEAD, 40,
    { {AT_HIT, AF_DRAIN, 6} },
    5, 220,
    2, 10, MST_NO_SPELLS, true, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_NECROPHAGE }, TILE_CORPSE_NECROPHAGE
},
{
    MONS_NEKOMATA, 'R', WHITE, "nekomata",
    M_FLIES | M_FIGHTER | M_ARCHER | M_SEE_INVIS | M_SPEAKS,
    MR_RES_FIRE | MR_RES_POISON,
    2054, false, MONS_NEKOMATA, MONS_NEKOMATA, MH_DEMONIC, 120,
    { {AT_HIT, AF_PLAIN, 32}, {AT_CLAW, AF_PLAIN, 16} },
    15, 880,
    7, 23, MST_NEKOMATA, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_NEKOMATA }, TILE_ERROR
},
{
    MONS_NELLIE, 'Y', LIGHTMAGENTA, "Nellie",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    2087, false, MONS_ELEPHANT, MONS_HELLEPHANT, MH_DEMONIC, 140,
    { {AT_TRAMPLE, AF_TRAMPLE, 45}, {AT_BITE, AF_PLAIN, 20}, {AT_GORE, AF_PLAIN, 15} },
    20, 2400,
    13, 10, MST_HELLEPHANT, true, S_TRUMPET,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_NELLIE }, TILE_ERROR
},
{
    MONS_NEQOXEC, '3', LIGHTMAGENTA, "neqoxec",
    M_FLIES,
    MR_RES_POISON,
    182, false, MONS_NEQOXEC, MONS_NEQOXEC, MH_DEMONIC, 40,
    { {AT_HIT, AF_PLAIN, 15} },
    6, 330,
    4, 12, MST_NEQOXEC, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_NEQOXEC }, TILE_ERROR
},
{
    MONS_NERGALLE, 'o', WHITE, "Nergalle",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    779, false, MONS_ORC, MONS_ORC, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 6} },
    10, 600,
    9, 11, MST_NERGALLE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_NERGALLE }, TILE_ERROR
},
{
    MONS_NESSOS, 'c', MAGENTA, "Nessos",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_ARCHER | M_GENDER_NEUTRAL,
    MR_NO_FLAGS,
    1043, false, MONS_CENTAUR, MONS_CENTAUR, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 13}, {AT_KICK, AF_PLAIN, 5} },
    9, 720,
    4, 8, MST_NESSOS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_CENTAUR, GOD_NO_GOD,
    { TILEP_MONS_NESSOS }, TILE_ERROR
},
{
    MONS_NIKOLA, '@', LIGHTCYAN, "Nikola",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    2438, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 120,
    { {AT_HIT, AF_PLAIN, 20} },
    18, 1890,
    1, 9, MST_NIKOLA, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_NIKOLA }, TILE_ERROR
},
{
    MONS_NAMELESS_REVENANT, 'z', WHITE, "Nobody",
    M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_GENDER_NEUTRAL,
    mrd(MR_RES_COLD, 2),
    2725, false, MONS_NAMELESS_REVENANT, MONS_NAMELESS_REVENANT, MH_UNDEAD, WILL_INVULN,
    { {AT_CLAW, AF_PLAIN, 34} },
    18, 930,
    20, 10, MST_NAMELESS_REVENANT, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_NAMELESS_REVENANT, TVARY_CYCLE }, TILE_ERROR
},
{
    MONS_NORRIS, '@', BROWN, "Norris",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    2329, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 140,
    { {AT_HIT, AF_CONFUSE, 36} },
    20, 2100,
    1, 9, MST_NORRIS, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_NORRIS }, TILE_ERROR
},
{
    MONS_OBLIVION_HOUND, 'h', GREEN, "oblivion hound",
    M_SEE_INVIS | M_UNBLINDABLE,
    MR_NO_FLAGS,
    2059, false, MONS_HOUND, MONS_OBLIVION_HOUND, MH_DEMONIC, 20,
    { {AT_BITE, AF_PLAIN, 45}, {AT_CLAW, AF_PLAIN, 30} },
    20, 1100,
    6, 13, MST_OBLIVION_HOUND, true, S_BARK,
    I_ANIMAL, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_OBLIVION_HOUND }, TILE_CORPSE_OBLIVION_HOUND
},
{
    MONS_OBSIDIAN_BAT, 'b', LIGHTMAGENTA, "obsidian bat",
    M_FLIES | M_SEE_INVIS | M_UNBLINDABLE | M_BATTY | M_SPEAKS,
    mrd(MR_RES_FIRE, 2),
    747, false, MONS_BAT, MONS_OBSIDIAN_BAT, MH_NONLIVING, 20,
    { {AT_BITE, AF_HELL_HUNT, 21} },
    9, 425,
    13, 13, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 30, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_BAT, GOD_NO_GOD,
    { TILEP_MONS_OBSIDIAN_BAT }, TILE_ERROR
},
{
    MONS_OBSIDIAN_STATUE, 'I', MAGENTA, "obsidian statue",
    M_SEE_INVIS | M_SPEAKS | M_STATIONARY,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, 2) | MR_RES_PETRIFY,
    679, false, MONS_STATUE, MONS_OBSIDIAN_STATUE, MH_NONLIVING, WILL_INVULN,
    {  },
    10, 700,
    12, 1, MST_OBSIDIAN_STATUE, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_OBSIDIAN_STATUE }, TILE_ERROR
},
{
    MONS_OCCULTIST, 'p', MAGENTA, "occultist",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    794, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 8} },
    13, 540,
    0, 15, MST_OCCULTIST, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_OCCULTIST }, TILE_ERROR
},
{
    MONS_OCTOPODE, 'x', LIGHTCYAN, "octopode",
    M_SPEAKS | M_NO_SKELETON | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    479, false, MONS_OCTOPODE, MONS_OCTOPODE, MH_NATURAL, 10,
    { {AT_TENTACLE_SLAP, AF_PLAIN, 24}, {AT_CONSTRICT, AF_CRUSH, 5} },
    8, 560,
    1, 5, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_OCTOPODE }, TILE_CORPSE_OCTOPODE
},
{
    MONS_OGRE_MAGE, 'O', MAGENTA, "ogre mage",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    848, false, MONS_OGRE, MONS_OGRE, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 16} },
    10, 550,
    1, 7, MST_OGRE_MAGE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {10, 10, 15, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_OGRE_MAGE }, TILE_ERROR
},
{
    MONS_OGRE, 'O', BROWN, "ogre",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    119, false, MONS_OGRE, MONS_OGRE, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 20} },
    5, 275,
    1, 6, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {10, 10, 15, 10, 10},
    MONUSE_STARTING_EQUIPMENT, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_OGRE }, TILE_CORPSE_OGRE
},
{
    MONS_OKLOB_PLANT, 'P', LIGHTGREEN, "oklob plant",
    M_STATIONARY,
    MR_RES_POISON | mrd(MR_RES_CORR, 3),
    564, false, MONS_PLANT, MONS_OKLOB_PLANT, MH_PLANT, 40,
    {  },
    10, 550,
    10, 0, MST_ACID_SPIT, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_PLANT, GOD_NO_GOD,
    { TILEP_MONS_OKLOB_PLANT }, TILE_ERROR
},
{
    MONS_OKLOB_SAPLING, 'P', LIGHTCYAN, "oklob sapling",
    M_STATIONARY,
    MR_RES_POISON | mrd(MR_RES_CORR, 3),
    60, false, MONS_PLANT, MONS_OKLOB_PLANT, MH_PLANT, 20,
    {  },
    4, 220,
    10, 0, MST_OKLOB_SAPLING, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_PLANT, GOD_NO_GOD,
    { TILEP_MONS_OKLOB_SAPLING }, TILE_ERROR
},
{
    MONS_ONI_INCARCERATOR, 'O', LIGHTMAGENTA, "oni incarcerator",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    2712, false, MONS_ONI, MONS_ONI, MH_NATURAL, 100,
    { {AT_HIT, AF_DRAG, 58}, {AT_HEADBUTT, AF_PLAIN, 24} },
    19, 1500,
    6, 8, MST_ONI_INCARCERATOR, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ONI_INCARCERATOR }, TILE_ERROR
},
{
    MONS_ONI, 'O', LIGHTBLUE, "oni",
    M_SPEAKS | M_WARM_BLOOD | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    119, false, MONS_ONI, MONS_ONI, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 20} },
    5, 275,
    1, 6, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {10, 10, 15, 10, 10},
    MONUSE_STARTING_EQUIPMENT, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ONI }, TILE_CORPSE_ONI
},
{
    MONS_OPHAN, 'G', RED, "ophan",
    M_FLIES | M_SEE_INVIS | M_HAS_AURA,
    MR_NO_FLAGS,
    1082, false, MONS_ANGEL, MONS_OPHAN, MH_HOLY, 140,
    {  },
    15, 975,
    10, 10, MST_OPHAN, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_OPHAN }, TILE_ERROR
},
{
    MONS_ORANGE_DEMON, '4', LIGHTRED, "orange demon",
    M_NO_FLAGS,
    MR_NO_FLAGS,
    421, false, MONS_ORANGE_DEMON, MONS_ORANGE_DEMON, MH_DEMONIC, 60,
    { {AT_STING, AF_REACH_STING, 15}, {AT_HIT, AF_WEAKNESS, 8} },
    8, 520,
    3, 7, MST_NO_SPELLS, false, S_SCREECH,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_ORANGE_DEMON }, TILE_ERROR
},
{
    MONS_ORANGE_STATUE, 'I', LIGHTRED, "orange crystal statue",
    M_SEE_INVIS | M_SPEAKS | M_STATIONARY,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, 2) | MR_RES_PETRIFY,
    679, false, MONS_STATUE, MONS_ORANGE_STATUE, MH_NONLIVING, WILL_INVULN,
    {  },
    10, 700,
    12, 1, MST_ORANGE_CRYSTAL_STATUE, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ORANGE_STATUE }, TILE_ERROR
},
{
    MONS_ORB_GUARDIAN, 'X', MAGENTA, "Orb Guardian",
    M_FIGHTER | M_SEE_INVIS | M_NO_POLY_TO,
    MR_NO_FLAGS,
    1752, false, MONS_ORB_GUARDIAN, MONS_ORB_GUARDIAN, MH_NATURAL, 120,
    { {AT_HIT, AF_PLAIN, 45} },
    15, 825,
    13, 13, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_GIANT, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_ORB_GUARDIAN }, TILE_ERROR
},
{
    MONS_ORB_OF_DESTRUCTION, '*', WHITE, "orb of destruction",
    M_FLIES | M_INSUBSTANTIAL | M_NO_EXP_GAIN | M_NO_POLY_TO | M_PROJECTILE | M_NO_THREAT,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, 3) | mrd(MR_RES_CORR, 3) | MR_RES_DAMNATION,
    0, false, MONS_ORB_OF_DESTRUCTION, MONS_ORB_OF_DESTRUCTION, MH_NONLIVING, WILL_INVULN,
    {  },
    5, 50000,
    0, 10, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 30, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_ORB_OF_DESTRUCTION, TVARY_RANDOM }, TILE_ERROR
},
{
    MONS_ORB_OF_ENTROPY, '*', ETC_UNHOLY, "orb of entropy",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    mrd(MR_RES_ELEC, 3) | MR_RES_FIRE | MR_RES_COLD | mrd(MR_RES_CORR, 3),
    4638, false, MONS_ORB_OF_ENTROPY, MONS_ORB_OF_ENTROPY, MH_NONLIVING, WILL_INVULN,
    {  },
    30, 1500,
    20, 20, MST_ORB_OF_ENTROPY, false, S_SILENT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_ORB_OF_ENTROPY }, TILE_ERROR
},
{
    MONS_ORB_OF_FIRE, '*', RED, "orb of fire",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 3) | MR_RES_COLD,
    4638, false, MONS_ORB_OF_FIRE, MONS_ORB_OF_FIRE, MH_NONLIVING, WILL_INVULN,
    {  },
    30, 1500,
    20, 20, MST_ORB_OF_FIRE, false, S_SILENT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_ORB_OF_FIRE }, TILE_ERROR
},
{
    MONS_ORB_OF_WINTER, '*', LIGHTBLUE, "orb of winter",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    mrd(MR_RES_ELEC, 3) | MR_RES_FIRE | mrd(MR_RES_COLD, 3),
    4638, false, MONS_ORB_OF_WINTER, MONS_ORB_OF_WINTER, MH_NONLIVING, WILL_INVULN,
    {  },
    30, 1500,
    20, 20, MST_ORB_OF_WINTER, false, S_SILENT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_ORB_OF_WINTER }, TILE_ERROR
},
{
    MONS_ORB_SPIDER, 's', MAGENTA, "orb spider",
    M_WEB_IMMUNE | M_NO_SKELETON | M_MAINTAIN_RANGE,
    mrd(MR_RES_POISON, -1),
    708, false, MONS_SPIDER, MONS_ORB_SPIDER, MH_NATURAL, 40,
    { {AT_BITE, AF_PLAIN, 15} },
    10, 420,
    3, 10, MST_ORB_SPIDER, true, S_FAINT_SKITTER,
    I_ANIMAL, HT_LAND, 12, {10, 10, 10, 10, 20},
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_ARACHNID, GOD_NO_GOD,
    { TILEP_MONS_ORB_SPIDER }, TILE_CORPSE_ORB_SPIDER
},
{
    MONS_ORC_APOSTLE, 'o', WHITE, "orc apostle",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD | M_GHOST_DEMON | M_NO_POLY_TO | M_NO_ZOMBIE | M_NO_GEN_DERIVED | M_FAST_REGEN,
    MR_NO_FLAGS,
    35, true, MONS_ORC, MONS_ORC, MH_NATURAL, -4,
    { {AT_HIT, AF_PLAIN, 20} },
    9, 675,
    2, 13, MST_GHOST, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_BEOGH,
    { TILEP_MONS_ORC_APOSTLE, TVARY_MOD }, TILE_ERROR
},
{
    MONS_ORC_HIGH_PRIEST, 'o', LIGHTGREEN, "orc high priest",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    795, false, MONS_ORC, MONS_ORC, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 7} },
    11, 550,
    1, 12, MST_ORC_HIGH_PRIEST, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_BEOGH,
    { TILEP_MONS_ORC_HIGH_PRIEST }, TILE_ERROR
},
{
    MONS_ORC_KNIGHT, 'o', CYAN, "orc knight",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    617, false, MONS_ORC, MONS_ORC, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 20} },
    9, 675,
    2, 13, MST_ORC_KNIGHT, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ORC_KNIGHT }, TILE_ERROR
},
{
    MONS_ORC_PRIEST, 'o', GREEN, "orc priest",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    42, false, MONS_ORC, MONS_ORC, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 3} },
    3, 150,
    1, 10, MST_ORC_PRIEST, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_BEOGH,
    { TILEP_MONS_ORC_PRIEST }, TILE_ERROR
},
{
    MONS_ORC_SORCERER, 'o', LIGHTMAGENTA, "orc sorcerer",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    559, false, MONS_ORC, MONS_ORC, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 7} },
    9, 315,
    5, 12, MST_ORC_SORCERER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ORC_SORCERER }, TILE_ERROR
},
{
    MONS_ORC_WARLORD, 'o', LIGHTCYAN, "orc warlord",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1144, false, MONS_ORC, MONS_ORC, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 27} },
    15, 1125,
    3, 10, MST_BATTLECRY, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ORC_WARLORD }, TILE_ERROR
},
{
    MONS_ORC_WARRIOR, 'o', YELLOW, "orc warrior",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    133, false, MONS_ORC, MONS_ORC, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 12} },
    4, 280,
    0, 13, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ORC_WARRIOR }, TILE_ERROR
},
{
    MONS_ORC_WIZARD, 'o', MAGENTA, "orc wizard",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    35, false, MONS_ORC, MONS_ORC, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 2} },
    3, 150,
    1, 12, MST_ORC_WIZARD, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ORC_WIZARD }, TILE_ERROR
},
{
    MONS_ORC, 'o', LIGHTRED, "orc",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    3, false, MONS_ORC, MONS_ORC, MH_NATURAL, 0,
    { {AT_HIT, AF_PLAIN, 2} },
    1, 70,
    0, 10, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ORC }, TILE_CORPSE_ORC
},
{
    MONS_PALE_DRACONIAN, 'd', CYAN, "pale draconian",
    M_SPEAKS | M_COLD_BLOOD | M_NO_POLY_TO,
    MR_RES_STEAM,
    997, false, MONS_DRACONIAN, MONS_PALE_DRACONIAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 20} },
    14, 980,
    9, 14, MST_NO_SPELLS, true, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_CORPSE_PALE_DRACONIAN
},
{
    MONS_PANDEMONIUM_LORD, '&', COLOUR_UNDEF, "pandemonium lord",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_GHOST_DEMON | M_TALL_TILE,
    MR_RES_POISON,
    80, true, MONS_PANDEMONIUM_LORD, MONS_PANDEMONIUM_LORD, MH_DEMONIC, -5,
    { {AT_HIT, AF_PLAIN, 5} },
    19, 1710,
    1, 2, MST_GHOST, false, S_DEMON_TAUNT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_PANDEMONIUM_LORD }, TILE_ERROR
},
{
    MONS_PARGHIT, 'T', GREEN, "Parghit",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FAST_REGEN | M_MALE,
    MR_NO_FLAGS,
    3146, false, MONS_TROLL, MONS_TROLL, MH_NATURAL, 140,
    { {AT_BITE, AF_PLAIN, 50}, {AT_CLAW, AF_PLAIN, 40}, {AT_CLAW, AF_PLAIN, 40} },
    27, 1200,
    1, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_PARGHIT }, TILE_ERROR
},
{
    MONS_PARGI, 'T', GREEN, "Pargi",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FAST_REGEN | M_MALE,
    MR_NO_FLAGS,
    135, false, MONS_TROLL, MONS_TROLL, MH_NATURAL, 10,
    { {AT_BITE, AF_PLAIN, 9}, {AT_CLAW, AF_PLAIN, 4}, {AT_CLAW, AF_PLAIN, 4} },
    5, 350,
    1, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_PARGI }, TILE_ERROR
},
{
    MONS_PEACEKEEPER, '9', YELLOW, "peacekeeper",
    M_SEE_INVIS,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    859, false, MONS_GOLEM, MONS_PEACEKEEPER, MH_NONLIVING, WILL_INVULN,
    { {AT_BITE, AF_PLAIN, 25}, {AT_CLAW, AF_PLAIN, 15} },
    12, 450,
    20, 3, MST_PEACEKEEPER, false, S_ROAR,
    I_BRAINLESS, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_QUADRUPED_TAILLESS, GOD_NO_GOD,
    { TILEP_MONS_PEACEKEEPER }, TILE_ERROR
},
{
    MONS_PEARL_DRAGON, 'D', ETC_HOLY, "pearl dragon",
    M_FLIES | M_SEE_INVIS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    2256, false, MONS_DRAGON, MONS_PEARL_DRAGON, MH_HOLY, 160,
    { {AT_BITE, AF_HOLY, 35}, {AT_CLAW, AF_HOLY, 20} },
    18, 1170,
    10, 15, MST_PEARL_DRAGON, true, S_LOUD_ROAR,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_PEARL_DRAGON }, TILE_CORPSE_PEARL_DRAGON
},
{
    MONS_PETRIFIED_FLOWER, 'P', ETC_SILVER, "petrified flower",
    M_STATIONARY | M_NO_EXP_GAIN | M_NO_THREAT,
    MR_RES_FIRE | MR_RES_COLD | MR_RES_ELEC,
    10, false, MONS_PETRIFIED_FLOWER, MONS_PETRIFIED_FLOWER, MH_NONLIVING | MH_PLANT, WILL_INVULN,
    {  },
    12, 840,
    12, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_PETRIFIED_FLOWER, TVARY_MOD }, TILE_ERROR
},
{
    MONS_PHALANX_BEETLE, 'B', CYAN, "phalanx beetle",
    M_HAS_AURA,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    500, false, MONS_PHALANX_BEETLE, MONS_PHALANX_BEETLE, MH_NONLIVING, WILL_INVULN,
    { {AT_BITE, AF_PLAIN, 21} },
    11, 580,
    12, 12, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, {5, 5, 10, 10, 10},
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_INSECT, GOD_NO_GOD,
    { TILEP_MONS_PHALANX_BEETLE }, TILE_ERROR
},
{
    MONS_PHANTASMAL_WARRIOR, 'W', LIGHTGREEN, "phantasmal warrior",
    M_FLIES | M_FIGHTER | M_SEE_INVIS | M_INSUBSTANTIAL,
    MR_RES_COLD,
    638, false, MONS_WRAITH, MONS_PHANTASMAL_WARRIOR, MH_UNDEAD, 80,
    { {AT_HIT, AF_VULN, 39} },
    9, 495,
    12, 10, MST_BLINK_CLOSE, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_PHANTASMAL_WARRIOR }, TILE_ERROR
},
{
    MONS_PHANTOM, 'W', BLUE, "phantom",
    M_FLIES | M_INSUBSTANTIAL,
    mrd(MR_RES_COLD, 2),
    105, false, MONS_PHANTOM, MONS_PHANTOM, MH_UNDEAD, 40,
    { {AT_HIT, AF_BLINK_WITH, 8} },
    6, 270,
    3, 13, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_PHANTOM }, TILE_ERROR
},
{
    MONS_PHARAOH_ANT, 'B', YELLOW, "pharaoh ant",
    M_WEB_IMMUNE | M_NO_SKELETON,
    MR_NO_FLAGS,
    758, false, MONS_PHARAOH_ANT, MONS_PHARAOH_ANT, MH_UNDEAD, 60,
    { {AT_BITE, AF_DRAIN, 43} },
    10, 360,
    4, 8, MST_NO_SPELLS, false, S_MOAN,
    I_ANIMAL, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_INSECT, GOD_NO_GOD,
    { TILEP_MONS_PHARAOH_ANT }, TILE_ERROR
},
{
    MONS_PIKEL, 'K', BLUE, "Pikel",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    647, false, MONS_KOBOLD, MONS_KOBOLD, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 9} },
    6, 390,
    4, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_PIKEL }, TILE_ERROR
},
{
    MONS_PILE_OF_DEBRIS, 'I', BROWN, "pile of debris",
    M_FRAGILE | M_STATIONARY | M_NO_EXP_GAIN | M_NO_THREAT,
    MR_RES_FIRE | MR_RES_COLD | MR_RES_ELEC,
    10, false, MONS_PILE_OF_DEBRIS, MONS_PILE_OF_DEBRIS, MH_NONLIVING, WILL_INVULN,
    {  },
    8, 800,
    8, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_PILE_OF_DEBRIS, TVARY_MOD }, TILE_ERROR
},
{
    MONS_PILE_OF_FLESH, 'I', MAGENTA, "pile of flesh",
    M_STATIONARY | M_NO_EXP_GAIN | M_NO_THREAT | M_NO_POLY_TO | M_NO_SKELETON | M_NO_ZOMBIE | M_NO_GEN_DERIVED,
    MR_RES_POISON,
    10, false, MONS_PILE_OF_FLESH, MONS_PILE_OF_FLESH, MH_NATURAL, WILL_INVULN,
    {  },
    6, 660,
    2, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_PILE_OF_FLESH, TVARY_MOD }, TILE_ERROR
},
{
    MONS_PILLAR_OF_RIME, 'I', ETC_ICE, "pillar of rime",
    M_STATIONARY | M_NO_EXP_GAIN | M_REMNANT | M_NO_THREAT,
    mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 3),
    10, false, MONS_PILLAR_OF_RIME, MONS_PILLAR_OF_RIME, MH_NONLIVING, WILL_INVULN,
    {  },
    3, 375,
    15, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_PILLAR_OF_RIME }, TILE_ERROR
},
{
    MONS_PILLAR_OF_SALT, 'I', WHITE, "pillar of salt",
    M_STATIONARY | M_NO_EXP_GAIN | M_REMNANT | M_NO_THREAT,
    MR_NO_FLAGS,
    10, false, MONS_PILLAR_OF_SALT, MONS_PILLAR_OF_SALT, MH_NONLIVING, WILL_INVULN,
    {  },
    1, 10,
    1, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_PILLAR_OF_SALT }, TILE_ERROR
},
{
    MONS_PLANT, 'P', GREEN, "plant",
    M_FRAGILE | M_STATIONARY | M_NO_EXP_GAIN | M_NO_THREAT,
    MR_RES_POISON,
    10, false, MONS_PLANT, MONS_PLANT, MH_PLANT, WILL_INVULN,
    {  },
    10, 2000,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_PLANT, GOD_NO_GOD,
    { TILEP_MONS_PLANT, TVARY_MOD }, TILE_ERROR
},
{
    MONS_PLATINUM_PARAGON, '9', WHITE, "platinum paragon",
    M_SEE_INVIS | M_GHOST_DEMON,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    2700, false, MONS_GOLEM, MONS_PLATINUM_PARAGON, MH_NONLIVING, WILL_INVULN,
    {  },
    15, 1000,
    20, 20, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_PLATINUM_PARAGON }, TILE_ERROR
},
{
    MONS_PLAYER_GHOST, 'W', WHITE, "player ghost",
    M_FLIES | M_FIGHTER | M_SPEAKS | M_GHOST_DEMON | M_INSUBSTANTIAL | M_NO_POLY_TO,
    MR_NO_FLAGS,
    65, true, MONS_PHANTOM, MONS_PLAYER_GHOST, MH_UNDEAD, -5,
    { {AT_HIT, AF_PLAIN, 5} },
    4, 140,
    1, 2, MST_GHOST, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_PLAYER_GHOST }, TILE_ERROR
},
{
    MONS_PLAYER_ILLUSION, '@', WHITE, "player illusion",
    M_FLIES | M_FIGHTER | M_SPEAKS | M_GHOST_DEMON | M_INSUBSTANTIAL | M_NO_POLY_TO,
    MR_RES_POISON,
    40, true, MONS_PLAYER_ILLUSION, MONS_PLAYER_ILLUSION, MH_NATURAL, -5,
    { {AT_HIT, AF_PLAIN, 5} },
    4, 140,
    1, 2, MST_GHOST, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_PLAYER_GHOST }, TILE_ERROR
},
{
    MONS_PLAYER_SHADOW, '@', MAGENTA, "shadow",
    M_FLIES | M_INSUBSTANTIAL | M_NO_EXP_GAIN | M_NO_POLY_TO | M_TWO_WEAPONS,
    MR_NO_FLAGS,
    10, false, MONS_PLAYER_SHADOW, MONS_PLAYER_SHADOW, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 0} },
    1, 10,
    7, 20, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_PLAYER_SHADOW }, TILE_ERROR
},
{
    MONS_PLAYER, '@', LIGHTGRAY, "player",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_PLAYER, MONS_PLAYER, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, true, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_PLAYER_GHOST }, TILE_ERROR
},
{
    MONS_POLAR_BEAR, 'h', LIGHTBLUE, "polar bear",
    M_WARM_BLOOD,
    MR_RES_COLD,
    295, false, MONS_BEAR, MONS_POLAR_BEAR, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 20}, {AT_CLAW, AF_PLAIN, 5}, {AT_CLAW, AF_PLAIN, 5} },
    7, 455,
    7, 8, MST_BEAR, true, S_GROWL,
    I_ANIMAL, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED_TAILLESS, GOD_NO_GOD,
    { TILEP_MONS_POLAR_BEAR }, TILE_CORPSE_POLAR_BEAR
},
{
    MONS_POLTERGEIST, 'v', LIGHTGREEN, "poltergeist",
    M_FLIES | M_INSUBSTANTIAL,
    MR_RES_COLD,
    7, false, MONS_POLTERGEIST, MONS_POLTERGEIST, MH_UNDEAD, 80,
    { {AT_HIT, AF_PLAIN, 20} },
    11, 650,
    6, 18, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_POLTERGEIST }, TILE_ERROR
},
{
    MONS_POLTERGUARDIAN, 'v', LIGHTGREEN, "polterguardian",
    M_FLIES | M_INSUBSTANTIAL | M_CAUTIOUS | M_HAS_AURA,
    MR_RES_COLD,
    539, false, MONS_POLTERGUARDIAN, MONS_POLTERGUARDIAN, MH_UNDEAD, 80,
    { {AT_HIT, AF_PLAIN, 20} },
    11, 650,
    6, 18, MST_POLTERGUARDIAN, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_POLTERGUARDIAN }, TILE_ERROR
},
{
    MONS_POLYPHEMUS, 'C', BLUE, "Polyphemus",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    1540, false, MONS_GIANT, MONS_CYCLOPS, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 45}, {AT_HIT, AF_PLAIN, 30} },
    16, 1520,
    10, 3, MST_POLYPHEMUS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_POLYPHEMUS }, TILE_ERROR
},
{
    MONS_PRINCE_RIBBIT, 'F', LIGHTCYAN, "Prince Ribbit",
    M_SPEAKS | M_COLD_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    276, false, MONS_FROG, MONS_HUMAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 20} },
    6, 390,
    0, 16, MST_BLINKER, true, S_CROAK,
    I_HUMAN, HT_AMPHIBIOUS, 14, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_QUADRUPED_TAILLESS, GOD_NO_GOD,
    { TILEP_MONS_PRINCE_RIBBIT }, TILE_ERROR
},
{
    MONS_PROFANE_SERVITOR, 'A', RED, "profane servitor",
    M_FLIES | M_FIGHTER | M_SEE_INVIS | M_SPEAKS,
    MR_RES_ELEC | MR_RES_COLD,
    2323, false, MONS_ANGEL, MONS_PROFANE_SERVITOR, MH_UNDEAD, 140,
    { {AT_HIT, AF_VAMPIRIC, 25}, {AT_HIT, AF_DRAIN, 10} },
    18, 1530,
    10, 20, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID_WINGED, GOD_YREDELEMNUL,
    { TILEP_MONS_PROFANE_SERVITOR }, TILE_ERROR
},
{
    MONS_PROGRAM_BUG, 'B', LIGHTRED, "program bug",
    M_NO_EXP_GAIN | M_CANT_SPAWN | M_NO_THREAT,
    MR_NO_FLAGS,
    10, false, MONS_PROGRAM_BUG, MONS_PROGRAM_BUG, MH_NATURAL, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, true, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_ERROR
},
{
    MONS_PROTEAN_PROGENITOR, 'C', ETC_RANDOM, "protean progenitor",
    M_SPEAKS | M_WARM_BLOOD | M_FAST_REGEN | M_NO_POLY_TO | M_NO_ZOMBIE | M_NO_GEN_DERIVED,
    MR_RES_POISON,
    1314, false, MONS_GIANT, MONS_PROTEAN_PROGENITOR, MH_NATURAL, 120,
    { {AT_RANDOM, AF_PLAIN, 55} },
    14, 820,
    7, 8, MST_PROTEAN_PROGENITOR, false, S_GURGLE,
    I_HUMAN, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_PROTEAN_PROGENITOR }, TILE_ERROR
},
{
    MONS_PURPLE_DRACONIAN, 'd', MAGENTA, "purple draconian",
    M_SPEAKS | M_COLD_BLOOD,
    MR_NO_FLAGS,
    997, false, MONS_DRACONIAN, MONS_PURPLE_DRACONIAN, MH_NATURAL, 120,
    { {AT_HIT, AF_PLAIN, 20} },
    14, 980,
    9, 10, MST_NO_SPELLS, true, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_CORPSE_PURPLE_DRACONIAN
},
{
    MONS_PUTRID_MOUTH, 'W', LIGHTRED, "putrid mouth",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    MR_NO_FLAGS,
    1023, false, MONS_WRAITH, MONS_PUTRID_MOUTH, MH_UNDEAD, 100,
    { {AT_BITE, AF_POISON_STRONG, 30}, {AT_CLAW, AF_PLAIN, 20} },
    14, 700,
    5, 14, MST_PUTRID_MOUTH, false, S_MOAN,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_PUTRID_MOUTH }, TILE_ERROR
},
{
    MONS_QUEEN_BEE, 'y', LIGHTMAGENTA, "queen bee",
    M_FLIES | M_NO_SKELETON,
    mrd(MR_RES_POISON, -1),
    303, false, MONS_KILLER_BEE, MONS_QUEEN_BEE, MH_NATURAL, 20,
    { {AT_STING, AF_POISON, 20} },
    7, 385,
    10, 10, MST_QUEEN_BEE, true, S_BUZZ,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_INSECT_WINGED, GOD_NO_GOD,
    { TILEP_MONS_QUEEN_BEE }, TILE_CORPSE_QUEEN_BEE
},
{
    MONS_QUICKSILVER_DRAGON, 'D', LIGHTCYAN, "quicksilver dragon",
    M_FLIES | M_SEE_INVIS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1641, false, MONS_DRAGON, MONS_QUICKSILVER_DRAGON, MH_NATURAL, 140,
    { {AT_BITE, AF_PLAIN, 25}, {AT_CLAW, AF_PLAIN, 20} },
    16, 880,
    10, 15, MST_QUICKSILVER_DRAGON, true, S_LOUD_ROAR,
    I_ANIMAL, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_QUICKSILVER_DRAGON }, TILE_CORPSE_QUICKSILVER_DRAGON
},
{
    MONS_QUICKSILVER_ELEMENTAL, 'E', LIGHTCYAN, "quicksilver elemental",
    M_SEE_INVIS | M_BATTY,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, 3),
    1243, false, MONS_ELEMENTAL, MONS_QUICKSILVER_ELEMENTAL, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_ANTIMAGIC, 30} },
    16, 800,
    1, 20, MST_QUICKSILVER_DRAGON, false, S_SILENT,
    I_ANIMAL, HT_LAND, 20, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_QUICKSILVER_ELEMENTAL }, TILE_ERROR
},
{
    MONS_QUOKKA, 'r', WHITE, "quokka",
    M_WARM_BLOOD,
    MR_NO_FLAGS,
    2, false, MONS_QUOKKA, MONS_QUOKKA, MH_NATURAL, 0,
    { {AT_BITE, AF_PLAIN, 5} },
    1, 55,
    2, 13, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_QUOKKA }, TILE_CORPSE_QUOKKA
},
{
    MONS_RADROACH, 'B', LIGHTRED, "radroach",
    M_WEB_IMMUNE | M_NO_SKELETON,
    MR_NO_FLAGS,
    839, false, MONS_RADROACH, MONS_RADROACH, MH_NATURAL, 60,
    { {AT_BITE, AF_PLAIN, 28}, {AT_CLAW, AF_PLAIN, 16} },
    12, 800,
    13, 5, MST_RADROACH, true, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_INSECT, GOD_NO_GOD,
    { TILEP_MONS_RADROACH }, TILE_CORPSE_RADROACH
},
{
    MONS_RAGGED_HIEROPHANT, 'a', LIGHTMAGENTA, "ragged hierophant",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    897, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 12} },
    9, 1200,
    0, 10, MST_RAGGED_HIEROPHANT, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_RAGGED_HIEROPHANT }, TILE_ERROR
},
{
    MONS_RAIJU, 'h', LIGHTCYAN, "raiju",
    M_SEE_INVIS | M_UNBLINDABLE,
    mrd(MR_RES_ELEC, 3),
    264, false, MONS_HOUND, MONS_RAIJU, MH_NATURAL, 20,
    { {AT_BITE, AF_ELEC, 11} },
    7, 385,
    4, 14, MST_RAIJU, true, S_BARK,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_RAIJU }, TILE_CORPSE_RAIJU
},
{
    MONS_RAKSHASA, 'R', YELLOW, "rakshasa",
    M_SEE_INVIS,
    MR_RES_POISON,
    870, false, MONS_RAKSHASA, MONS_RAKSHASA, MH_DEMONIC, 140,
    { {AT_HIT, AF_PLAIN, 20} },
    11, 660,
    6, 14, MST_RAKSHASA, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_RAKSHASA }, TILE_ERROR
},
{
    MONS_RAT, 'r', BROWN, "rat",
    M_WARM_BLOOD,
    MR_NO_FLAGS,
    1, false, MONS_RAT, MONS_RAT, MH_NATURAL, 0,
    { {AT_BITE, AF_PLAIN, 3} },
    1, 25,
    1, 10, MST_NO_SPELLS, true, S_SQUEAK,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_RAT }, TILE_CORPSE_RAT
},
{
    MONS_RAVEN, 'b', BLUE, "raven",
    M_FLIES | M_SPEAKS,
    MR_NO_FLAGS,
    210, false, MONS_RAVEN, MONS_RAVEN, MH_NATURAL, 20,
    { {AT_PECK, AF_PLAIN, 19} },
    7, 320,
    2, 15, MST_RAVEN, true, S_CAW,
    I_ANIMAL, HT_LAND, 20, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_BIRD, GOD_NO_GOD,
    { TILEP_MONS_RAVEN }, TILE_CORPSE_RAVEN
},
{
    MONS_REAPER, '2', LIGHTGRAY, "reaper",
    M_FLIES | M_FIGHTER | M_SEE_INVIS | M_SPEAKS,
    MR_RES_POISON | MR_RES_COLD,
    1133, false, MONS_REAPER, MONS_REAPER, MH_DEMONIC, 100,
    { {AT_HIT, AF_DRAG, 36} },
    14, 710,
    15, 10, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_REAPER }, TILE_ERROR
},
{
    MONS_RED_DEVIL, '4', RED, "red devil",
    M_FLIES | M_FIGHTER,
    MR_RES_POISON | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1),
    319, false, MONS_RED_DEVIL, MONS_RED_DEVIL, MH_DEMONIC, 60,
    { {AT_HIT, AF_BARBS, 19} },
    7, 315,
    7, 13, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_WINGED, GOD_NO_GOD,
    { TILEP_MONS_RED_DEVIL }, TILE_ERROR
},
{
    MONS_RED_DRACONIAN, 'd', LIGHTRED, "red draconian",
    M_SPEAKS | M_COLD_BLOOD,
    MR_RES_FIRE,
    997, false, MONS_DRACONIAN, MONS_RED_DRACONIAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 20} },
    14, 980,
    9, 10, MST_NO_SPELLS, true, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_CORPSE_RED_DRACONIAN
},
{
    MONS_REDBACK, 's', LIGHTRED, "redback",
    M_WEB_IMMUNE | M_NO_SKELETON,
    mrd(MR_RES_POISON, -1),
    181, false, MONS_SPIDER, MONS_REDBACK, MH_NATURAL, 20,
    { {AT_BITE, AF_POISON_STRONG, 18} },
    9, 270,
    2, 12, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_ARACHNID, GOD_NO_GOD,
    { TILEP_MONS_REDBACK }, TILE_CORPSE_REDBACK
},
{
    MONS_RENDING_BLADE, '(', LIGHTMAGENTA, "rending blade",
    M_FLIES | M_PERIPHERAL,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    120, false, MONS_WRAITH, MONS_RENDING_BLADE, MH_NONLIVING, WILL_INVULN,
    {  },
    5, 400,
    15, 10, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 20, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_RENDING_BLADE }, TILE_ERROR
},
{
    MONS_REVENANT_SOULMONGER, 'z', MAGENTA, "revenant soulmonger",
    M_SEE_INVIS | M_SPEAKS,
    mrd(MR_RES_COLD, 2),
    1345, false, MONS_REVENANT_SOULMONGER, MONS_REVENANT_SOULMONGER, MH_UNDEAD, WILL_INVULN,
    { {AT_CLAW, AF_PLAIN, 26} },
    18, 810,
    8, 12, MST_REVENANT, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_REVENANT_SOULMONGER }, TILE_ERROR
},
{
    MONS_REVENANT, 'z', MAGENTA, "revenant",
    M_SEE_INVIS | M_SPEAKS,
    MR_RES_COLD,
    200, false, MONS_REVENANT, MONS_REVENANT, MH_UNDEAD, WILL_INVULN,
    { {AT_CLAW, AF_PLAIN, 14} },
    6, 360,
    4, 10, MST_NO_SPELLS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_REVENANT }, TILE_ERROR
},
{
    MONS_RIBBON_WORM, 'w', LIGHTRED, "ribbon worm",
    M_FAST_REGEN | M_NO_SKELETON,
    MR_NO_FLAGS,
    4, false, MONS_RIBBON_WORM, MONS_RIBBON_WORM, MH_NATURAL, 10,
    { {AT_BITE, AF_PLAIN, 9} },
    4, 180,
    1, 5, MST_RIBBON_WORM, true, S_SILENT,
    I_ANIMAL, HT_LAND, 8, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_RIBBON_WORM }, TILE_CORPSE_RIBBON_WORM
},
{
    MONS_RIME_DRAKE, 'k', BLUE, "rime drake",
    M_FLIES | M_WARM_BLOOD,
    MR_RES_COLD,
    372, false, MONS_DRAKE, MONS_RIME_DRAKE, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 8} },
    6, 330,
    3, 12, MST_RIME_DRAKE, true, S_HISS,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_RIME_DRAKE }, TILE_CORPSE_RIME_DRAKE
},
{
    MONS_RIVER_RAT, 'r', LIGHTGREEN, "river rat",
    M_WARM_BLOOD,
    MR_NO_FLAGS,
    13, false, MONS_RAT, MONS_RIVER_RAT, MH_NATURAL, 10,
    { {AT_BITE, AF_PLAIN, 10} },
    2, 110,
    5, 11, MST_NO_SPELLS, true, S_SQUEAK,
    I_ANIMAL, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_RIVER_RAT }, TILE_CORPSE_RIVER_RAT
},
{
    MONS_ROBIN, 'g', LIGHTCYAN, "Robin",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_GENDER_NEUTRAL,
    MR_NO_FLAGS,
    15, false, MONS_GOBLIN, MONS_HOBGOBLIN, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 2} },
    2, 160,
    1, 8, MST_ROBIN, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ROBIN }, TILE_ERROR
},
{
    MONS_ROCK_FISH, 'F', BROWN, "rock fish",
    M_NO_FLAGS,
    MR_RES_ELEC | MR_RES_PETRIFY,
    75, false, MONS_ROCK_FISH, MONS_ROCK_FISH, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 11} },
    5, 180,
    8, 8, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_WALL, 10, {10, 8, 10, 10, 10},
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_FISH, GOD_NO_GOD,
    { TILEP_MONS_ROCK_FISH }, TILE_ERROR
},
{
    MONS_ROCKSLIME, 'J', BROWN, "rockslime",
    M_EAT_DOORS | M_SEE_INVIS | M_UNBLINDABLE | M_AMORPHOUS | M_NO_SKELETON,
    MR_RES_ELEC | MR_RES_POISON | mrd(MR_RES_FIRE, 2),
    1312, false, MONS_JELLY, MONS_ROCKSLIME, MH_NATURAL, 60,
    { {AT_HIT, AF_TRAMPLE, 50} },
    20, 600,
    27, 2, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_BLOB, GOD_NO_GOD,
    { TILEP_MONS_ROCKSLIME }, TILE_ERROR
},
{
    MONS_ROXANNE, 'I', BLUE, "Roxanne",
    M_NO_WAND | M_SPEAKS | M_STATIONARY | M_UNIQUE | M_FEMALE,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, 2) | MR_RES_PETRIFY,
    1368, false, MONS_STATUE, MONS_STATUE, MH_NONLIVING, WILL_INVULN,
    {  },
    14, 1820,
    20, 0, MST_ROXANNE, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ROXANNE }, TILE_ERROR
},
{
    MONS_ROYAL_JELLY, 'J', YELLOW, "Royal Jelly",
    M_NAME_THE | M_EAT_DOORS | M_SEE_INVIS | M_UNBLINDABLE | M_AMORPHOUS | M_UNIQUE | M_ACID_SPLASH | M_NO_SKELETON | M_TALL_TILE,
    MR_RES_POISON | mrd(MR_RES_CORR, 3),
    7603, false, MONS_JELLY, MONS_JELLY, MH_NATURAL, 180,
    { {AT_HIT, AF_ACID, 50}, {AT_HIT, AF_ACID, 30} },
    21, 2310,
    8, 4, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_BLOB, GOD_JIYVA,
    { TILEP_MONS_ROYAL_JELLY }, TILE_ERROR
},
{
    MONS_ROYAL_MUMMY, 'M', WHITE, "royal mummy",
    M_SEE_INVIS | M_SPEAKS,
    MR_RES_ELEC | MR_RES_COLD,
    3477, false, MONS_MUMMY, MONS_MUMMY, MH_UNDEAD, 160,
    { {AT_HIT, AF_PLAIN, 35} },
    15, 1950,
    10, 6, MST_ROYAL_MUMMY, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ROYAL_MUMMY }, TILE_ERROR
},
{
    MONS_RUPERT, '@', LIGHTRED, "Rupert",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    1862, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 21} },
    16, 1200,
    0, 10, MST_RUPERT, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_RUPERT }, TILE_ERROR
},
{
    MONS_RUST_DEVIL, '4', BROWN, "rust devil",
    M_NO_FLAGS,
    MR_RES_ELEC | MR_RES_POISON | mrd(MR_RES_FIRE, 3) | MR_RES_COLD,
    455, false, MONS_RUST_DEVIL, MONS_RUST_DEVIL, MH_DEMONIC, 60,
    { {AT_HIT, AF_CORRODE, 12} },
    8, 440,
    10, 8, MST_NO_SPELLS, false, S_SCREECH,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_RUST_DEVIL }, TILE_ERROR
},
{
    MONS_SACRED_LOTUS, 'P', WHITE, "sacred lotus",
    M_STATIONARY | M_FAST_REGEN | M_NO_EXP_GAIN | M_NO_THREAT,
    mrd(MR_RES_POISON, 3) | mrd(MR_RES_NEG, 3) | MR_RES_MIASMA,
    10, false, MONS_PLANT, MONS_SACRED_LOTUS, MH_PLANT, WILL_INVULN,
    {  },
    22, 1600,
    24, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_WATER, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_PLANT, GOD_NO_GOD,
    { TILEP_MONS_SACRED_LOTUS, TVARY_MOD }, TILE_ERROR
},
{
    MONS_SAINT_ROKA, 'o', LIGHTBLUE, "Saint Roka",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_GENDER_NEUTRAL,
    MR_NO_FLAGS,
    2900, false, MONS_ORC, MONS_ORC, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 35} },
    18, 1980,
    3, 10, MST_SAINT_ROKA, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_BEOGH,
    { TILEP_MONS_SAINT_ROKA }, TILE_ERROR
},
{
    MONS_SALAMANDER_MYSTIC, 'N', YELLOW, "salamander mystic",
    M_WARM_BLOOD,
    mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1),
    759, false, MONS_NAGA, MONS_SALAMANDER, MH_NATURAL, 60,
    { {AT_HIT, AF_FIRE, 10} },
    10, 650,
    5, 7, MST_SALAMANDER_MYSTIC, true, S_SILENT,
    I_HUMAN, HT_AMPHIBIOUS_LAVA, 10, {10, 7, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_NAGA, GOD_NO_GOD,
    { TILEP_MONS_SALAMANDER_MYSTIC }, TILE_ERROR
},
{
    MONS_SALAMANDER_TYRANT, 'N', RED, "salamander tyrant",
    M_WARM_BLOOD,
    mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1),
    863, false, MONS_NAGA, MONS_SALAMANDER, MH_NATURAL, 60,
    { {AT_HIT, AF_FIRE, 15} },
    15, 675,
    5, 7, MST_SALAMANDER_TYRANT, true, S_SILENT,
    I_HUMAN, HT_AMPHIBIOUS_LAVA, 10, {10, 7, 10, 10, 10},
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_NAGA, GOD_NO_GOD,
    { TILEP_MONS_SALAMANDER_TYRANT }, TILE_ERROR
},
{
    MONS_SALAMANDER, 'N', LIGHTRED, "salamander",
    M_FIGHTER | M_WARM_BLOOD,
    mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1),
    530, false, MONS_NAGA, MONS_SALAMANDER, MH_NATURAL, 40,
    { {AT_HIT, AF_FIRE, 13} },
    8, 640,
    5, 7, MST_NO_SPELLS, true, S_SILENT,
    I_HUMAN, HT_AMPHIBIOUS_LAVA, 10, {10, 7, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_NAGA, GOD_NO_GOD,
    { TILEP_MONS_SALAMANDER }, TILE_CORPSE_SALAMANDER
},
{
    MONS_SALTLING, '9', WHITE, "saltling",
    M_NO_FLAGS,
    MR_NO_FLAGS,
    271, false, MONS_GOLEM, MONS_SALTLING, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 20} },
    8, 270,
    15, 5, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SALTLING }, TILE_ERROR
},
{
    MONS_SATYR, 'c', LIGHTGREEN, "satyr",
    M_SPEAKS | M_WARM_BLOOD | M_ARCHER | M_PREFER_RANGED,
    MR_NO_FLAGS,
    821, false, MONS_FAUN, MONS_SATYR, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 25} },
    12, 660,
    2, 12, MST_SATYR, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_SATYR }, TILE_CORPSE_SATYR
},
{
    MONS_SCORPION, 's', YELLOW, "scorpion",
    M_NO_SKELETON,
    mrd(MR_RES_POISON, -1),
    83, false, MONS_SCORPION, MONS_SCORPION, MH_NATURAL, 20,
    { {AT_STING, AF_POISON, 8} },
    4, 180,
    5, 10, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_ARACHNID, GOD_NO_GOD,
    { TILEP_MONS_SCORPION }, TILE_CORPSE_SCORPION
},
{
    MONS_SCREAMING_REFRACTION, 'z', ETC_BONE, "screaming refraction",
    M_FLIES | M_SEE_INVIS,
    MR_RES_FIRE | MR_RES_COLD,
    680, false, MONS_SCREAMING_REFRACTION, MONS_SCREAMING_REFRACTION, MH_UNDEAD, 60,
    { {AT_GORE, AF_PLAIN, 32} },
    12, 585,
    15, 2, MST_SCREAMING_REFRACTION, false, S_MOAN,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_SCREAMING_REFRACTION }, TILE_ERROR
},
{
    MONS_SCRUB_NETTLE, 'P', LIGHTRED, "scrub nettle",
    M_SEE_INVIS | M_STATIONARY,
    MR_RES_POISON,
    39, false, MONS_PLANT, MONS_BUSH, MH_PLANT, 40,
    {  },
    3, 280,
    8, 0, MST_SCRUB_NETTLE, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_PLANT, GOD_NO_GOD,
    { TILEP_MONS_SCRUB_NETTLE }, TILE_ERROR
},
{
    MONS_SEA_SNAKE, 'S', LIGHTRED, "sea snake",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    739, false, MONS_SNAKE, MONS_SEA_SNAKE, MH_NATURAL, 40,
    { {AT_BITE, AF_POISON_STRONG, 24} },
    10, 650,
    2, 15, MST_NO_SPELLS, true, S_HISS,
    I_ANIMAL, HT_AMPHIBIOUS, 12, {10, 4, 10, 10, 10},
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_SEA_SNAKE }, TILE_CORPSE_SEA_SNAKE
},
{
    MONS_SEARING_WRETCH, 'n', ETC_FIRE, "searing wretch",
    M_NO_ZOMBIE,
    mrd(MR_RES_FIRE, 3) | MR_RES_COLD,
    1625, false, MONS_GHOUL, MONS_SEARING_WRETCH, MH_UNDEAD, 80,
    { {AT_CLAW, AF_FIRE, 50}, {AT_BITE, AF_SEAR, 30} },
    18, 1600,
    4, 8, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_AMPHIBIOUS_LAVA, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SEARING_WRETCH }, TILE_ERROR
},
{
    MONS_SEISMOSAURUS_EGG, '*', LIGHTCYAN, "seismosaurus egg",
    M_STATIONARY | M_NO_SKELETON | M_NO_POLY_TO | M_NO_ZOMBIE | M_NO_GEN_DERIVED,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    10, false, MONS_SEISMOSAURUS_EGG, MONS_SEISMOSAURUS_EGG, MH_NATURAL, WILL_INVULN,
    {  },
    11, 440,
    15, 0, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_SEISMOSAURUS_EGG }, TILE_ERROR
},
{
    MONS_SEISMOSAURUS, 'l', LIGHTCYAN, "seismosaurus",
    M_COLD_BLOOD | M_NO_POLY_TO | M_NO_ZOMBIE,
    MR_NO_FLAGS,
    799, false, MONS_GIANT_LIZARD, MONS_SEISMOSAURUS, MH_NATURAL, 80,
    { {AT_TAIL_SLAP, AF_PLAIN, 31} },
    11, 810,
    13, 5, MST_SEISMOSAURUS, true, S_ROAR,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_SEISMOSAURUS }, TILE_CORPSE_SEISMOSAURUS
},
{
    MONS_SENSED_EASY, '{', LIGHTGRAY, "easy sensed monster",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    0, false, MONS_SENSED, MONS_SENSED, MH_NONLIVING, 0,
    {  },
    1, 10,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILE_MONS_SENSED_EASY }, TILE_ERROR
},
{
    MONS_SENSED_FRIENDLY, '{', GREEN, "friendly sensed monster",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    0, false, MONS_SENSED, MONS_SENSED, MH_NONLIVING, 0,
    {  },
    1, 10,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILE_MONS_SENSED_FRIENDLY }, TILE_ERROR
},
{
    MONS_SENSED_NASTY, '{', LIGHTRED, "nasty sensed monster",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    0, false, MONS_SENSED, MONS_SENSED, MH_NONLIVING, 0,
    {  },
    1, 10,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILE_MONS_SENSED_NASTY }, TILE_ERROR
},
{
    MONS_SENSED_TOUGH, '{', YELLOW, "tough sensed monster",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    0, false, MONS_SENSED, MONS_SENSED, MH_NONLIVING, 0,
    {  },
    1, 10,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILE_MONS_SENSED_TOUGH }, TILE_ERROR
},
{
    MONS_SENSED_TRIVIAL, '{', BLUE, "trivial sensed monster",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    0, false, MONS_SENSED, MONS_SENSED, MH_NONLIVING, 0,
    {  },
    1, 10,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILE_MONS_SENSED_TRIVIAL }, TILE_ERROR
},
{
    MONS_SENSED, '{', RED, "sensed monster",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    0, false, MONS_SENSED, MONS_SENSED, MH_NONLIVING, 0,
    {  },
    1, 10,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILE_UNSEEN_MONSTER }, TILE_ERROR
},
{
    MONS_SERAPH, 'A', LIGHTMAGENTA, "seraph",
    M_FLIES | M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_TALL_TILE,
    MR_RES_ELEC | MR_RES_POISON | mrd(MR_RES_FIRE, 3),
    6070, false, MONS_ANGEL, MONS_SERAPH, MH_HOLY, 160,
    { {AT_HIT, AF_PLAIN, 50}, {AT_HIT, AF_PLAIN, 20} },
    25, 2125,
    10, 20, MST_SERAPH, false, S_SHOUT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_WINGED, GOD_SHINING_ONE,
    { TILEP_MONS_SERAPH }, TILE_ERROR
},
{
    MONS_SERPENT_OF_HELL_COCYTUS, 'D', ETC_ICE, "Serpent of Hell",
    M_NAME_THE | M_CRASH_DOORS | M_FLIES | M_SEE_INVIS | M_UNIQUE | M_TALL_TILE,
    MR_RES_POISON | mrd(MR_RES_COLD, 3),
    6666, false, MONS_DRAGON, MONS_SERPENT_OF_HELL, MH_DEMONIC, 180,
    { {AT_BITE, AF_COLD, 35}, {AT_BITE, AF_COLD, 35}, {AT_BITE, AF_COLD, 35}, {AT_TRAMPLE, AF_TRAMPLE, 25} },
    17, 3230,
    20, 12, MST_SERPENT_OF_HELL_COC, false, S_LOUD_ROAR,
    I_HUMAN, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_SERPENT_OF_HELL_COCYTUS }, TILE_ERROR
},
{
    MONS_SERPENT_OF_HELL_DIS, 'D', ETC_IRON, "Serpent of Hell",
    M_NAME_THE | M_CRASH_DOORS | M_SEE_INVIS | M_UNIQUE | M_TALL_TILE,
    MR_RES_POISON | MR_RES_FIRE | MR_RES_COLD,
    6666, false, MONS_DRAGON, MONS_SERPENT_OF_HELL, MH_DEMONIC, 180,
    { {AT_BITE, AF_REACH, 40}, {AT_BITE, AF_REACH, 40}, {AT_BITE, AF_REACH, 40}, {AT_TRAMPLE, AF_TRAMPLE, 35} },
    17, 3230,
    28, 4, MST_SERPENT_OF_HELL_DIS, false, S_LOUD_ROAR,
    I_HUMAN, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_SERPENT_OF_HELL_DIS }, TILE_ERROR
},
{
    MONS_SERPENT_OF_HELL_TARTARUS, 'D', ETC_DEATH, "Serpent of Hell",
    M_NAME_THE | M_CRASH_DOORS | M_FLIES | M_SEE_INVIS | M_UNIQUE | M_TALL_TILE,
    MR_RES_POISON | mrd(MR_RES_COLD, 2),
    6666, false, MONS_DRAGON, MONS_SERPENT_OF_HELL, MH_DEMONIC, 180,
    { {AT_BITE, AF_DRAIN, 35}, {AT_BITE, AF_DRAIN, 35}, {AT_BITE, AF_DRAIN, 35}, {AT_TRAMPLE, AF_TRAMPLE, 25} },
    17, 3230,
    16, 12, MST_SERPENT_OF_HELL_TAR, false, S_LOUD_ROAR,
    I_HUMAN, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_SERPENT_OF_HELL_TARTARUS }, TILE_ERROR
},
{
    MONS_SERPENT_OF_HELL, 'D', ETC_FIRE, "Serpent of Hell",
    M_NAME_THE | M_CRASH_DOORS | M_FLIES | M_SEE_INVIS | M_UNIQUE | M_TALL_TILE,
    MR_RES_POISON | mrd(MR_RES_FIRE, 3),
    6666, false, MONS_DRAGON, MONS_SERPENT_OF_HELL, MH_DEMONIC, 180,
    { {AT_BITE, AF_FIRE, 35}, {AT_BITE, AF_FIRE, 35}, {AT_BITE, AF_FIRE, 35}, {AT_TRAMPLE, AF_TRAMPLE, 25} },
    17, 3230,
    16, 12, MST_SERPENT_OF_HELL_GEH, false, S_LOUD_ROAR,
    I_HUMAN, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_SERPENT_OF_HELL_GEHENNA }, TILE_ERROR
},
{
    MONS_SERVANT_OF_WHISPERS, 'a', BROWN, "servant of whispers",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    870, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 10} },
    12, 800,
    1, 12, MST_SERVANT_OF_WHISPERS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SERVANT_OF_WHISPERS }, TILE_ERROR
},
{
    MONS_SHADOW_DEMON, '2', MAGENTA, "shadow demon",
    M_SEE_INVIS,
    MR_RES_POISON | mrd(MR_RES_COLD, 2),
    713, false, MONS_SHADOW_DEMON, MONS_SHADOW_DEMON, MH_DEMONIC, 100,
    { {AT_HIT, AF_PLAIN, 21} },
    10, 550,
    7, 12, MST_SHADOW_DEMON, false, S_CROAK,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SHADOW_DEMON }, TILE_ERROR
},
{
    MONS_SHADOW_DRAGON, 'D', MAGENTA, "shadow dragon",
    M_FLIES | M_SEE_INVIS | M_COLD_BLOOD,
    MR_RES_POISON | mrd(MR_RES_COLD, 2) | mrd(MR_RES_NEG, 3),
    1406, false, MONS_DRAGON, MONS_SHADOW_DRAGON, MH_NATURAL, 120,
    { {AT_BITE, AF_DRAIN, 20}, {AT_CLAW, AF_PLAIN, 15}, {AT_CLAW, AF_PLAIN, 15} },
    17, 1275,
    15, 10, MST_SHADOW_DRAGON, true, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_SHADOW_DRAGON }, TILE_CORPSE_SHADOW_DRAGON
},
{
    MONS_SHADOW_IMP, '5', MAGENTA, "shadow imp",
    M_SPEAKS,
    MR_RES_POISON | mrd(MR_RES_COLD, 2),
    11, false, MONS_SHADOW_IMP, MONS_SHADOW_IMP, MH_DEMONIC, 10,
    { {AT_HIT, AF_PLAIN, 6} },
    2, 110,
    3, 11, MST_SHADOW_IMP, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LITTLE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SHADOW_IMP }, TILE_ERROR
},
{
    MONS_SHADOW_PRISM, '*', ETC_DITHMENOS, "shadow prism",
    M_FLIES | M_STATIONARY | M_NO_EXP_GAIN | M_NO_POLY_TO | M_PERIPHERAL | M_UNSTABLE,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    0, false, MONS_SHADOW_PRISM, MONS_SHADOW_PRISM, MH_NONLIVING, WILL_INVULN,
    {  },
    8, 250,
    5, 20, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_SHADOW_PRISM, TVARY_RANDOM }, TILE_ERROR
},
{
    MONS_SHADOW_PUPPET, 'E', MAGENTA, "shadow puppet",
    M_FLIES | M_FIGHTER | M_INSUBSTANTIAL | M_NO_EXP_GAIN | M_NO_POLY_TO,
    MR_NO_FLAGS,
    10, false, MONS_SHADOW_PUPPET, MONS_SHADOW_PUPPET, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_SWOOP, 1}, {AT_HIT, AF_FLANK, 1}, {AT_HIT, AF_CRUSH, 1} },
    10, 350,
    5, 20, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_SHADOW_PUPPET }, TILE_ERROR
},
{
    MONS_SHADOW_TURRET, 'I', MAGENTA, "shadow turret",
    M_INSUBSTANTIAL | M_NO_EXP_GAIN | M_NO_POLY_TO | M_SEE_INVIS | M_STATIONARY,
    MR_NO_FLAGS,
    10, false, MONS_SHADOW_TURRET, MONS_SHADOW_TURRET, MH_NONLIVING, WILL_INVULN,
    {  },
    10, 250,
    9, 15, MST_SHADOW_TURRET, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 5, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_SHADOW_TURRET }, TILE_ERROR
},
{
    MONS_SHADOW_WRAITH, 'W', LIGHTMAGENTA, "shadow wraith",
    M_FLIES | M_INVIS | M_SEE_INVIS | M_INSUBSTANTIAL,
    MR_NO_FLAGS,
    761, false, MONS_WRAITH, MONS_SHADOW_WRAITH, MH_UNDEAD, 100,
    { {AT_HIT, AF_DRAIN_SPEED, 27} },
    10, 550,
    7, 7, MST_NO_SPELLS, false, S_MOAN,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SHADOW_WRAITH }, TILE_ERROR
},
{
    MONS_SHADOWGHAST, 'W', MAGENTA, "shadowghast",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    mrd(MR_RES_COLD, 3),
    218, false, MONS_WRAITH, MONS_SHADOWGHAST, MH_UNDEAD, 40,
    { {AT_CLAW, AF_SHADOWSTAB, 14} },
    6, 240,
    7, 10, MST_SHADOWGHAST, false, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SHADOWGHAST }, TILE_ERROR
},
{
    MONS_SHAMBLING_MANGROVE, 'f', LIGHTRED, "shambling mangrove",
    M_NO_FLAGS,
    MR_RES_POISON,
    899, false, MONS_SHAMBLING_MANGROVE, MONS_SHAMBLING_MANGROVE, MH_PLANT, 100,
    { {AT_HIT, AF_PLAIN, 41} },
    13, 910,
    13, 3, MST_SHAMBLING_MANGROVE, false, S_SILENT,
    I_HUMAN, HT_AMPHIBIOUS, 8, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_PLANT, GOD_NO_GOD,
    { TILEP_MONS_TREANT }, TILE_ERROR
},
{
    MONS_SHAPESHIFTER, 'p', LIGHTRED, "shapeshifter",
    M_NO_FLAGS,
    MR_NO_FLAGS,
    295, false, MONS_SHAPESHIFTER, MONS_SHAPESHIFTER, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 5} },
    7, 385,
    0, 10, MST_NO_SPELLS, true, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SHAPESHIFTER }, TILE_CORPSE_SHAPESHIFTER
},
{
    MONS_SHARD_SHRIKE, 'b', LIGHTBLUE, "shard shrike",
    M_FLIES | M_BATTY | M_WARM_BLOOD,
    mrd(MR_RES_COLD, 2),
    3031, false, MONS_SHARD_SHRIKE, MONS_SHARD_SHRIKE, MH_NATURAL, 80,
    { {AT_CLAW, AF_COLD, 21} },
    21, 1050,
    2, 18, MST_SHARD_SHRIKE, true, S_SCREECH,
    I_ANIMAL, HT_LAND, 30, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_BIRD, GOD_NO_GOD,
    { TILEP_MONS_SHARD_SHRIKE }, TILE_CORPSE_SHARD_SHRIKE
},
{
    MONS_SHINING_EYE, 'G', LIGHTMAGENTA, "shining eye",
    M_FLIES | M_SEE_INVIS | M_NO_SKELETON | M_CAUTIOUS,
    MR_NO_FLAGS,
    546, false, MONS_FLOATING_EYE, MONS_SHINING_EYE, MH_NATURAL, 100,
    {  },
    10, 700,
    3, 1, MST_SHINING_EYE, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_SHINING_EYE }, TILE_ERROR
},
{
    MONS_SHOCK_SERPENT, 'S', LIGHTBLUE, "shock serpent",
    M_COLD_BLOOD,
    mrd(MR_RES_ELEC, 3),
    788, false, MONS_SNAKE, MONS_SHOCK_SERPENT, MH_NATURAL, 40,
    { {AT_BITE, AF_ELEC, 20} },
    10, 550,
    2, 15, MST_SHOCK_SERPENT, true, S_HISS,
    I_ANIMAL, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_SHOCK_SERPENT }, TILE_CORPSE_SHOCK_SERPENT
},
{
    MONS_SHOOTING_STAR, 'v', LIGHTMAGENTA, "shooting star",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL | M_NO_EXP_GAIN | M_NO_POLY_TO | M_PERIPHERAL | M_NO_THREAT,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, 3),
    0, false, MONS_SHOOTING_STAR, MONS_SHOOTING_STAR, MH_NONLIVING, WILL_INVULN,
    {  },
    1, 1,
    0, 20, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 20, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_SHOOTING_STAR }, TILE_ERROR
},
{
    MONS_SICKLY_MERFOLK_SIREN, 'm', BLUE, "sickly merfolk siren",
    M_SPEAKS | M_WARM_BLOOD | M_NO_POLY_TO,
    MR_NO_FLAGS,
    34, false, MONS_MERFOLK, MONS_MERFOLK, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 19} },
    3, 135,
    4, 12, MST_MERFOLK_SIREN, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, {10, 6, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_MERFOLK_SIREN, TVARY_WATER }, TILE_ERROR
},
{
    MONS_SIGMUND, '@', YELLOW, "Sigmund",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    229, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 1} },
    3, 270,
    0, 11, MST_ORC_WIZARD, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {10, 10, 15, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SIGMUND }, TILE_ERROR
},
{
    MONS_SILENT_SPECTRE, 'W', CYAN, "silent spectre",
    M_FLIES | M_SEE_INVIS | M_SPEAKS | M_INSUBSTANTIAL,
    mrd(MR_RES_COLD, 3),
    312, false, MONS_WRAITH, MONS_SILENT_SPECTRE, MH_UNDEAD, 40,
    { {AT_HIT, AF_PLAIN, 15} },
    8, 440,
    5, 15, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SILENT_SPECTRE }, TILE_ERROR
},
{
    MONS_SIMULACRUM, 'Z', LIGHTBLUE, "simulacrum",
    M_NO_REGEN,
    mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 3),
    9, false, MONS_SIMULACRUM, MONS_SIMULACRUM, MH_UNDEAD, -1,
    { {AT_HIT, AF_PLAIN, 6} },
    2, 110,
    10, 4, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 7, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_SIMULACRUM_SMALL }, TILE_ERROR
},
{
    MONS_SIN_BEAST, '2', CYAN, "sin beast",
    M_FIGHTER,
    MR_NO_FLAGS,
    1287, false, MONS_SIN_BEAST, MONS_SIN_BEAST, MH_DEMONIC, 20,
    { {AT_BITE, AF_ANTIMAGIC, 28}, {AT_TRAMPLE, AF_TRAMPLE, 20} },
    12, 810,
    5, 14, MST_NO_SPELLS, false, S_RANDOM,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SIN_BEAST }, TILE_ERROR
},
{
    MONS_SIXFIRHY, '3', LIGHTBLUE, "sixfirhy",
    M_NO_FLAGS,
    mrd(MR_RES_ELEC, 3),
    760, false, MONS_SIXFIRHY, MONS_SIXFIRHY, MH_DEMONIC, 60,
    { {AT_HIT, AF_ELEC, 15} },
    9, 385,
    2, 20, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 40, {6, 6, 10, 10, 10},
    MONUSE_OPEN_DOORS, SIZE_LITTLE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SIXFIRHY }, TILE_ERROR
},
{
    MONS_SKELETAL_WARRIOR, 'z', CYAN, "skeletal warrior",
    M_FIGHTER,
    MR_RES_COLD,
    759, false, MONS_SKELETAL_WARRIOR, MONS_SKELETAL_WARRIOR, MH_UNDEAD, 100,
    { {AT_HIT, AF_PLAIN, 25} },
    10, 650,
    15, 10, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SKELETAL_WARRIOR }, TILE_ERROR
},
{
    MONS_SKY_BEAST, 'F', CYAN, "sky beast",
    M_FLIES | M_NO_SKELETON,
    mrd(MR_RES_ELEC, 3),
    130, false, MONS_SKY_BEAST, MONS_SKY_BEAST, MH_NATURAL, 20,
    { {AT_HIT, AF_AIRSTRIKE, 6} },
    6, 275,
    3, 13, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_FISH, GOD_NO_GOD,
    { TILEP_MONS_SKY_BEAST }, TILE_CORPSE_SKY_BEAST
},
{
    MONS_SKYSHARK, 'F', WHITE, "skyshark",
    M_FLIES | M_COLD_BLOOD | M_NO_SKELETON,
    MR_NO_FLAGS,
    767, false, MONS_SKYSHARK, MONS_SKYSHARK, MH_NATURAL, 40,
    { {AT_BITE, AF_BLOODZERK, 20}, {AT_TAIL_SLAP, AF_PLAIN, 10}, {AT_TAIL_SLAP, AF_PLAIN, 10} },
    10, 750,
    6, 8, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_LAND, 10, {7, 7, 10, 10, 10},
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_FISH, GOD_NO_GOD,
    { TILEP_MONS_SKYSHARK }, TILE_CORPSE_SKYSHARK
},
{
    MONS_SLEEPCAP, 'f', BLUE, "sleepcap",
    M_NO_FLAGS,
    MR_RES_POISON,
    38, false, MONS_FUNGUS, MONS_SLEEPCAP, MH_PLANT, 10,
    { {AT_SPORE, AF_SLEEP, 9} },
    3, 270,
    5, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_FUNGUS, GOD_NO_GOD,
    { TILEP_MONS_SLEEPCAP }, TILE_ERROR
},
{
    MONS_SLIME_CREATURE, 'J', GREEN, "slime creature",
    M_UNBLINDABLE | M_AMORPHOUS | M_NO_SKELETON | M_HERD,
    MR_RES_POISON,
    236, false, MONS_JELLY, MONS_SLIME_CREATURE, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 22} },
    11, 605,
    1, 4, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_BLOB, GOD_NO_GOD,
    { TILEP_MONS_SLIME_CREATURE }, TILE_ERROR
},
{
    MONS_SMOKE_DEMON, '3', LIGHTGRAY, "smoke demon",
    M_FLIES | M_INSUBSTANTIAL,
    MR_RES_POISON | mrd(MR_RES_FIRE, 2),
    428, false, MONS_SMOKE_DEMON, MONS_SMOKE_DEMON, MH_DEMONIC, 60,
    { {AT_HIT, AF_PLAIN, 8}, {AT_HIT, AF_PLAIN, 5}, {AT_HIT, AF_PLAIN, 5} },
    7, 385,
    5, 9, MST_SMOKE_DEMON, false, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SMOKE_DEMON }, TILE_ERROR
},
{
    MONS_SNAKE, 'S', LIGHTGREEN, "snake",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_SNAKE, MONS_SNAKE, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, true, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_ADDER }, TILE_ERROR
},
{
    MONS_SNAPLASHER_VINE_SEGMENT, '*', LIGHTGREEN, "snaplasher vine segment",
    M_STATIONARY | M_NO_EXP_GAIN | M_NO_POLY_TO | M_NO_THREAT | M_PERIPHERAL,
    MR_RES_POISON,
    10, false, MONS_PLANT, MONS_SNAPLASHER_VINE, MH_PLANT, 40,
    {  },
    12, 360,
    6, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_ERROR
},
{
    MONS_SNAPLASHER_VINE, 'w', LIGHTGREEN, "snaplasher vine",
    M_STATIONARY | M_NO_EXP_GAIN | M_NO_POLY_TO | M_PERIPHERAL,
    MR_RES_POISON,
    10, false, MONS_PLANT, MONS_SNAPLASHER_VINE, MH_PLANT, 40,
    { {AT_CONSTRICT, AF_CRUSH, 0}, {AT_HIT, AF_PLAIN, 14} },
    12, 240,
    4, 7, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_ERROR
},
{
    MONS_SNAPPING_TURTLE, 't', GREEN, "snapping turtle",
    M_COLD_BLOOD,
    MR_NO_FLAGS,
    251, false, MONS_SNAPPING_TURTLE, MONS_SNAPPING_TURTLE, MH_NATURAL, 40,
    { {AT_BITE, AF_REACH, 35} },
    10, 600,
    16, 5, MST_NO_SPELLS, true, S_HISS,
    I_ANIMAL, HT_AMPHIBIOUS, 8, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_QUADRUPED_TAILLESS, GOD_NO_GOD,
    { TILEP_MONS_SNAPPING_TURTLE }, TILE_CORPSE_SNAPPING_TURTLE
},
{
    MONS_SNORG, 'T', LIGHTGREEN, "Snorg",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FAST_REGEN | M_FEMALE,
    MR_NO_FLAGS,
    946, false, MONS_TROLL, MONS_TROLL, MH_NATURAL, 60,
    { {AT_BITE, AF_PLAIN, 20}, {AT_CLAW, AF_PLAIN, 15}, {AT_CLAW, AF_PLAIN, 15} },
    8, 960,
    0, 10, MST_SNORG, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SNORG }, TILE_ERROR
},
{
    MONS_SOJOBO, 'Q', LIGHTGREEN, "Sojobo",
    M_FLIES | M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    3464, false, MONS_TENGU, MONS_TENGU, MH_NATURAL, 140,
    { {AT_HIT, AF_PLAIN, 28}, {AT_PECK, AF_PLAIN, 14}, {AT_CLAW, AF_PLAIN, 14} },
    20, 1500,
    2, 24, MST_SOJOBO, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SOJOBO }, TILE_ERROR
},
{
    MONS_SOLAR_EMBER, '*', RED, "solar ember",
    M_FLIES | M_SEE_INVIS | M_UNBLINDABLE | M_INSUBSTANTIAL | M_NO_EXP_GAIN | M_NO_POLY_TO | M_AVATAR | M_FAST_REGEN,
    mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1),
    10, false, MONS_SOLAR_EMBER, MONS_SOLAR_EMBER, MH_NONLIVING, WILL_INVULN,
    {  },
    5, 320,
    5, 15, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 40, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_SOLAR_EMBER }, TILE_ERROR
},
{
    MONS_SONJA, 'K', RED, "Sonja",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    780, false, MONS_KOBOLD, MONS_KOBOLD, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 9}, {AT_HIT, AF_PLAIN, 5}, {AT_HIT, AF_PLAIN, 5} },
    6, 300,
    2, 24, MST_SONJA, true, S_SHOUT,
    I_HUMAN, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SONJA }, TILE_ERROR
},
{
    MONS_SOUL_EATER, '3', MAGENTA, "soul eater",
    M_FLIES | M_SEE_INVIS,
    MR_RES_POISON | MR_RES_COLD,
    779, false, MONS_SOUL_EATER, MONS_SOUL_EATER, MH_DEMONIC, 140,
    { {AT_HIT, AF_DRAIN, 25} },
    11, 605,
    18, 10, MST_SOUL_EATER, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SOUL_EATER }, TILE_ERROR
},
{
    MONS_SOUL_WISP, '*', LIGHTBLUE, "soul wisp",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    MR_NO_FLAGS,
    11, false, MONS_SOUL_WISP, MONS_SOUL_WISP, MH_UNDEAD, 10,
    { {AT_TOUCH, AF_PLAIN, 4} },
    2, 65,
    3, 11, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_SOUL_WISP }, TILE_ERROR
},
{
    MONS_SPARK_WASP, 'y', LIGHTCYAN, "spark wasp",
    M_FLIES | M_WEB_IMMUNE | M_NO_SKELETON,
    mrd(MR_RES_ELEC, 3) | mrd(MR_RES_POISON, -1),
    981, false, MONS_SPARK_WASP, MONS_SPARK_WASP, MH_NATURAL, 40,
    { {AT_STING, AF_ELEC, 33} },
    12, 660,
    9, 14, MST_SPARK_WASP, true, S_BUZZ,
    I_ANIMAL, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_INSECT_WINGED, GOD_NO_GOD,
    { TILEP_MONS_SPARK_WASP }, TILE_CORPSE_SPARK_WASP
},
{
    MONS_SPATIAL_MAELSTROM, 'v', YELLOW, "spatial maelstrom",
    M_FLIES | M_BATTY | M_INSUBSTANTIAL,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, 2),
    756, false, MONS_SPATIAL_MAELSTROM, MONS_SPATIAL_MAELSTROM, MH_NONLIVING, WILL_INVULN,
    { {AT_TOUCH, AF_DISTORT, 20}, {AT_ENGULF, AF_DISTORT, 20} },
    10, 750,
    0, 5, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 16, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_SPATIAL_MAELSTROM, TVARY_CYCLE }, TILE_ERROR
},
{
    MONS_SPATIAL_VORTEX, 'v', ETC_RANDOM, "spatial vortex",
    M_FLIES | M_CONFUSED | M_INSUBSTANTIAL | M_PERIPHERAL,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    167, false, MONS_SPATIAL_VORTEX, MONS_SPATIAL_VORTEX, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_DISTORT, 30} },
    6, 540,
    0, 5, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_SPATIAL_VORTEX, TVARY_CYCLE }, TILE_ERROR
},
{
    MONS_SPECTATOR, 'p', LIGHTGRAY, "spectator",
    M_SPEAKS | M_WARM_BLOOD | M_NO_EXP_GAIN | M_NO_POLY_TO | M_NO_GEN_DERIVED | M_NO_THREAT,
    MR_NO_FLAGS,
    10, false, MONS_HUMAN, MONS_SPECTATOR, MH_NATURAL, 20,
    {  },
    20, 1000,
    0, 10, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_HUMAN, TVARY_MOD }, TILE_CORPSE_HUMAN
},
{
    MONS_SPECTRAL_THING, 'Z', GREEN, "spectral thing",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    MR_RES_COLD,
    11, false, MONS_WRAITH, MONS_SPECTRAL_THING, MH_UNDEAD, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 20} },
    8, 440,
    8, 5, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 7, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_SPECTRAL_LARGE }, TILE_ERROR
},
{
    MONS_SPECTRAL_WEAPON, '(', GREEN, "spectral weapon",
    M_FLIES | M_UNBLINDABLE | M_GHOST_DEMON | M_INSUBSTANTIAL | M_NO_EXP_GAIN | M_AVATAR,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    11, false, MONS_WRAITH, MONS_SPECTRAL_WEAPON, MH_NONLIVING, WILL_INVULN,
    { {AT_HIT, AF_PLAIN, 6} },
    5, 250,
    5, 10, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 30, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_SPECTRAL_SBL }, TILE_ERROR
},
{
    MONS_SPELLSPARK_SERVITOR, '9', LIGHTMAGENTA, "spellspark servitor",
    M_FLIES | M_NO_POLY_TO,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, 2),
    1450, false, MONS_GOLEM, MONS_SPELLSPARK_SERVITOR, MH_NONLIVING, WILL_INVULN,
    {  },
    8, 800,
    10, 10, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, {10, 10, 10, 10, 18},
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SPELLSPARK_SERVITOR }, TILE_ERROR
},
{
    MONS_SPHINX_MARAUDER, 'H', LIGHTGREEN, "sphinx marauder",
    M_FLIES | M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1615, false, MONS_SPHINX, MONS_SPHINX_MARAUDER, MH_NATURAL, 60,
    { {AT_POUNCE, AF_AIRSTRIKE, 13} },
    13, 840,
    4, 12, MST_SPHINX_MARAUDER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_LARGE, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_SPHINX_MARAUDER }, TILE_CORPSE_SPHINX_MARAUDER
},
{
    MONS_SPHINX, 'H', LIGHTGREY, "sphinx",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_SPHINX, MONS_SPHINX, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, true, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_GUARDIAN_SPHINX }, TILE_ERROR
},
{
    MONS_SPIDER, 's', CYAN, "spider",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_SPIDER, MONS_SPIDER, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, true, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_REDBACK }, TILE_ERROR
},
{
    MONS_SPLINTERFROST_BARRICADE, 'I', LIGHTCYAN, "splinterfrost barricade",
    M_STATIONARY | M_NO_EXP_GAIN | M_NO_THREAT,
    mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 3),
    725, false, MONS_SPLINTERFROST_BARRICADE, MONS_SPLINTERFROST_BARRICADE, MH_NONLIVING, WILL_INVULN,
    {  },
    10, 380,
    15, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_SPLINTERFROST_BARRICADE }, TILE_ERROR
},
{
    MONS_SPRIGGAN_AIR_MAGE, 'i', LIGHTCYAN, "spriggan air mage",
    M_FLIES | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    851, false, MONS_SPRIGGAN, MONS_SPRIGGAN, MH_NATURAL, 140,
    { {AT_HIT, AF_PLAIN, 16} },
    14, 490,
    1, 24, MST_SPRIGGAN_AIR_MAGE, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {6, 6, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LITTLE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SPRIGGAN_AIR_MAGE }, TILE_ERROR
},
{
    MONS_SPRIGGAN_BERSERKER, 'i', LIGHTRED, "spriggan berserker",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    792, false, MONS_SPRIGGAN, MONS_SPRIGGAN, MH_NATURAL, 120,
    { {AT_HIT, AF_PLAIN, 27} },
    12, 540,
    2, 18, MST_SPRIGGAN_BERSERKER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {6, 6, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LITTLE, MON_SHAPE_HUMANOID, GOD_TROG,
    { TILEP_MONS_SPRIGGAN_BERSERKER }, TILE_ERROR
},
{
    MONS_SPRIGGAN_DEFENDER, 'i', YELLOW, "spriggan defender",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1116, false, MONS_SPRIGGAN, MONS_SPRIGGAN, MH_NATURAL, 140,
    { {AT_HIT, AF_PLAIN, 30} },
    15, 675,
    3, 22, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 16, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LITTLE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SPRIGGAN_DEFENDER }, TILE_ERROR
},
{
    MONS_SPRIGGAN_DRUID, 'i', GREEN, "spriggan druid",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    726, false, MONS_SPRIGGAN, MONS_SPRIGGAN, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 18} },
    11, 440,
    1, 18, MST_SPRIGGAN_DRUID, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {6, 6, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LITTLE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SPRIGGAN_DRUID }, TILE_ERROR
},
{
    MONS_SPRIGGAN_RIDER, 'i', LIGHTBLUE, "spriggan rider",
    M_FLIES | M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    mrd(MR_RES_POISON, -1),
    734, false, MONS_SPRIGGAN, MONS_SPRIGGAN, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 27} },
    11, 605,
    1, 18, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {6, 6, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_SMALL, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SPRIGGAN_RIDER }, TILE_ERROR
},
{
    MONS_SPRIGGAN, 'i', LIGHTGRAY, "spriggan",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    217, false, MONS_SPRIGGAN, MONS_SPRIGGAN, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 15} },
    7, 245,
    1, 18, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {6, 6, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LITTLE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SPRIGGAN }, TILE_CORPSE_SPRIGGAN
},
{
    MONS_SPROZZ, 'g', CYAN, "Sprozz",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE | M_TWO_WEAPONS,
    MR_NO_FLAGS,
    575, false, MONS_GOBLIN, MONS_GOBLIN, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 6}, {AT_HIT, AF_PLAIN, 6} },
    5, 660,
    0, 10, MST_SPROZZ, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_SPROZZ }, TILE_ERROR
},
{
    MONS_STARCURSED_MASS, 'X', BLUE, "starcursed mass",
    M_SEE_INVIS | M_AMORPHOUS,
    MR_NO_FLAGS,
    993, false, MONS_STARCURSED_MASS, MONS_STARCURSED_MASS, MH_NONLIVING, 100,
    { {AT_ENGULF, AF_PLAIN, 16} },
    12, 1500,
    10, 0, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_STARCURSED_MASS }, TILE_ERROR
},
{
    MONS_STARFLOWER, 'P', LIGHTMAGENTA, "starflower",
    M_STATIONARY,
    MR_RES_POISON | MR_RES_FIRE | MR_RES_COLD | MR_RES_CORR,
    1062, false, MONS_PLANT, MONS_STARFLOWER, MH_PLANT, 100,
    { {AT_TENTACLE_SLAP, AF_RIFT, 22}, {AT_TENTACLE_SLAP, AF_REACH, 17}, {AT_TENTACLE_SLAP, AF_DISTORT, 13} },
    16, 900,
    16, 0, MST_STARFLOWER, false, S_GURGLE,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_PLANT, GOD_NO_GOD,
    { TILEP_MONS_STARFLOWER, TVARY_CYCLE }, TILE_ERROR
},
{
    MONS_STARSPAWN_TENTACLE_SEGMENT, '*', LIGHTCYAN, "starspawn tentacle segment",
    M_FLIES | M_STATIONARY | M_NO_EXP_GAIN | M_NO_POLY_TO | M_NO_THREAT | M_PERIPHERAL,
    MR_NO_FLAGS,
    10, false, MONS_TENTACLED_STARSPAWN, MONS_STARSPAWN_TENTACLE_SEGMENT, MH_NONLIVING, WILL_INVULN,
    {  },
    11, 220,
    8, 2, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_ERROR
},
{
    MONS_STARSPAWN_TENTACLE, 'w', LIGHTCYAN, "starspawn tentacle",
    M_FLIES | M_STATIONARY | M_NO_EXP_GAIN | M_NO_POLY_TO | M_PERIPHERAL,
    MR_NO_FLAGS,
    10, false, MONS_TENTACLED_STARSPAWN, MONS_STARSPAWN_TENTACLE, MH_NONLIVING, WILL_INVULN,
    { {AT_CONSTRICT, AF_CRUSH, 4} },
    21, 220,
    8, 2, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_ERROR
},
{
    MONS_STATUE, 'I', LIGHTGRAY, "statue",
    M_SPEAKS | M_STATIONARY | M_ARCHER | M_NO_POLY_TO | M_PREFER_RANGED,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, 2) | MR_RES_PETRIFY,
    10, false, MONS_STATUE, MONS_STATUE, MH_NONLIVING, WILL_INVULN,
    { {AT_WEAP_ONLY, AF_PLAIN, 20} },
    8, 720,
    12, 1, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_OBSIDIAN_STATUE }, TILE_ERROR
},
{
    MONS_STEAM_DRAGON, 'D', BLUE, "steam dragon",
    M_FLIES | M_WARM_BLOOD,
    MR_RES_STEAM,
    184, false, MONS_DRAGON, MONS_STEAM_DRAGON, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 12}, {AT_CLAW, AF_PLAIN, 6} },
    4, 300,
    5, 10, MST_STEAM_DRAGON, true, S_HISS,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_STEAM_DRAGON }, TILE_CORPSE_STEAM_DRAGON
},
{
    MONS_STEELBARB_WORM, 'w', LIGHTGRAY, "steelbarb worm",
    M_WEB_IMMUNE | M_NO_SKELETON,
    MR_RES_FIRE,
    634, false, MONS_RIBBON_WORM, MONS_STEELBARB_WORM, MH_NATURAL, 10,
    { {AT_HIT, AF_BARBS, 29} },
    10, 690,
    11, 7, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_STEELBARB_WORM }, TILE_CORPSE_STEELBARB_WORM
},
{
    MONS_STOKER, 'L', ETC_FIRE, "stoker",
    M_NO_SKELETON,
    mrd(MR_RES_FIRE, 3),
    831, false, MONS_LICH, MONS_STOKER, MH_UNDEAD, 120,
    { {AT_TOUCH, AF_FIRE, 15} },
    13, 800,
    5, 12, MST_STOKER, false, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS_LAVA, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_STOKER }, TILE_ERROR
},
{
    MONS_STONE_GIANT, 'C', LIGHTGRAY, "stone giant",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1084, false, MONS_GIANT, MONS_STONE_GIANT, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 45} },
    16, 880,
    12, 2, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_STONE_GIANT }, TILE_CORPSE_STONE_GIANT
},
{
    MONS_STORM_DRAGON, 'D', LIGHTBLUE, "storm dragon",
    M_FLIES | M_WARM_BLOOD,
    mrd(MR_RES_ELEC, 3),
    1391, false, MONS_DRAGON, MONS_STORM_DRAGON, MH_NATURAL, 100,
    { {AT_BITE, AF_PLAIN, 25}, {AT_CLAW, AF_PLAIN, 15}, {AT_TRAMPLE, AF_TRAMPLE, 15} },
    14, 1050,
    13, 10, MST_STORM_DRAGON, true, S_LOUD_ROAR,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_STORM_DRAGON }, TILE_CORPSE_STORM_DRAGON
},
{
    MONS_STRANGE_MACHINE, 'I', ETC_SILVER, "strange machine",
    M_STATIONARY | M_NO_POLY_TO,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, 2) | MR_RES_PETRIFY,
    1370, false, MONS_STRANGE_MACHINE, MONS_STRANGE_MACHINE, MH_NONLIVING, WILL_INVULN,
    {  },
    21, 900,
    12, 1, MST_STRANGE_MACHINE, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_STRANGE_MACHINE }, TILE_ERROR
},
{
    MONS_SUN_DEMON, '3', YELLOW, "sun demon",
    M_FLIES,
    MR_RES_ELEC | MR_RES_POISON | mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, -1),
    777, false, MONS_SUN_DEMON, MONS_SUN_DEMON, MH_DEMONIC, 80,
    { {AT_HIT, AF_FIRE, 30} },
    10, 550,
    10, 12, MST_NO_SPELLS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_SUN_DEMON }, TILE_ERROR
},
{
    MONS_SUN_MOTH, 'y', ETC_GOLD, "sun moth",
    M_FLIES | M_WEB_IMMUNE | M_NO_SKELETON,
    mrd(MR_RES_FIRE, 2),
    697, false, MONS_MOTH, MONS_SUN_MOTH, MH_NATURAL, 60,
    { {AT_BITE, AF_SWOOP, 27} },
    9, 605,
    6, 12, MST_SUN_MOTH, true, S_SILENT,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_INSECT_WINGED, GOD_NO_GOD,
    { TILEP_MONS_SUN_MOTH }, TILE_CORPSE_SUN_MOTH
},
{
    MONS_SWAMP_DRAGON, 'D', BROWN, "swamp dragon",
    M_FLIES | M_WARM_BLOOD,
    MR_RES_POISON,
    703, false, MONS_DRAGON, MONS_SWAMP_DRAGON, MH_NATURAL, 40,
    { {AT_BITE, AF_PLAIN, 20}, {AT_CLAW, AF_PLAIN, 11}, {AT_TRAMPLE, AF_TRAMPLE, 11} },
    9, 675,
    7, 7, MST_SWAMP_DRAGON, true, S_LOUD_ROAR,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_SWAMP_DRAGON }, TILE_CORPSE_SWAMP_DRAGON
},
{
    MONS_SWAMP_DRAKE, 'k', BROWN, "swamp drake",
    M_FLIES | M_WARM_BLOOD,
    MR_RES_POISON,
    135, false, MONS_DRAKE, MONS_SWAMP_DRAKE, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 14} },
    4, 300,
    3, 11, MST_SWAMP_DRAKE, true, S_ROAR,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_SWAMP_DRAKE }, TILE_CORPSE_SWAMP_DRAKE
},
{
    MONS_SWAMP_WORM, 'w', BROWN, "swamp worm",
    M_NO_SKELETON,
    MR_NO_FLAGS,
    162, false, MONS_RIBBON_WORM, MONS_SWAMP_WORM, MH_NATURAL, 10,
    { {AT_BITE, AF_PLAIN, 26} },
    10, 350,
    3, 12, MST_SWAMP_WORM, true, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS, 12, {12, 12, 10, 10, 10},
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_SWAMP_WORM, TVARY_WATER }, TILE_CORPSE_SWAMP_WORM
},
{
    MONS_TAINTED_LEVIATHAN, 'C', MAGENTA, "tainted leviathan",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_NO_ZOMBIE | M_MIASMA_RING,
    MR_RES_COLD,
    1771, false, MONS_GIANT, MONS_TAINTED_LEVIATHAN, MH_UNDEAD, 120,
    { {AT_HIT, AF_PLAIN, 50}, {AT_HIT, AF_DRAIN, 30} },
    18, 1500,
    15, 2, MST_TAINTED_LEVIATHAN, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_TAINTED_LEVIATHAN }, TILE_CORPSE_TAINTED_LEVIATHAN
},
{
    MONS_TARANTELLA, 's', LIGHTMAGENTA, "tarantella",
    M_WEB_IMMUNE | M_NO_SKELETON,
    mrd(MR_RES_POISON, -1),
    277, false, MONS_SPIDER, MONS_TARANTELLA, MH_NATURAL, 20,
    { {AT_TOUCH, AF_CONFUSE, 19} },
    8, 280,
    3, 14, MST_NO_SPELLS, true, S_FAINT_SKITTER,
    I_ANIMAL, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_ARACHNID, GOD_NO_GOD,
    { TILEP_MONS_TARANTELLA }, TILE_CORPSE_TARANTELLA
},
{
    MONS_TENGU_CONJURER, 'Q', BLUE, "tengu conjurer",
    M_FLIES | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    341, false, MONS_TENGU, MONS_TENGU, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 10}, {AT_PECK, AF_PLAIN, 5}, {AT_CLAW, AF_PLAIN, 5} },
    7, 315,
    2, 17, MST_TENGU_CONJURER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_TENGU_CONJURER }, TILE_ERROR
},
{
    MONS_TENGU_REAVER, 'Q', LIGHTMAGENTA, "tengu reaver",
    M_FLIES | M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1406, false, MONS_TENGU, MONS_TENGU, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 27}, {AT_PECK, AF_PLAIN, 11}, {AT_CLAW, AF_PLAIN, 11} },
    17, 850,
    2, 17, MST_TENGU_REAVER, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_TENGU_REAVER }, TILE_ERROR
},
{
    MONS_TENGU_WARRIOR, 'Q', CYAN, "tengu warrior",
    M_FLIES | M_FIGHTER | M_SPEAKS | M_WARM_BLOOD | M_ARCHER,
    MR_NO_FLAGS,
    808, false, MONS_TENGU, MONS_TENGU, MH_NATURAL, 40,
    { {AT_HIT, AF_FLANK, 16}, {AT_PECK, AF_PLAIN, 8}, {AT_CLAW, AF_PLAIN, 8} },
    10, 600,
    2, 17, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_TENGU_WARRIOR }, TILE_ERROR
},
{
    MONS_TENGU, 'Q', LIGHTBLUE, "tengu",
    M_FLIES | M_SPEAKS | M_NO_POLY_TO | M_NO_GEN_DERIVED | M_WARM_BLOOD,
    MR_NO_FLAGS,
    118, false, MONS_TENGU, MONS_TENGU, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 10}, {AT_PECK, AF_PLAIN, 5}, {AT_CLAW, AF_PLAIN, 5} },
    5, 225,
    2, 12, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_TENGU }, TILE_CORPSE_TENGU
},
{
    MONS_TENTACLED_MONSTROSITY, 'X', GREEN, "tentacled monstrosity",
    M_SEE_INVIS,
    MR_RES_ELEC | MR_RES_POISON | MR_RES_FIRE | MR_RES_COLD,
    1843, false, MONS_TENTACLED_MONSTROSITY, MONS_TENTACLED_MONSTROSITY, MH_DEMONIC, 160,
    { {AT_TENTACLE_SLAP, AF_PLAIN, 22}, {AT_TENTACLE_SLAP, AF_PLAIN, 17}, {AT_TENTACLE_SLAP, AF_PLAIN, 13}, {AT_CONSTRICT, AF_CRUSH, 6} },
    23, 1265,
    5, 5, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_GIANT, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_TENTACLED_MONSTROSITY }, TILE_ERROR
},
{
    MONS_TENTACLED_STARSPAWN, 'X', LIGHTCYAN, "tentacled starspawn",
    M_NO_FLAGS,
    MR_NO_FLAGS,
    1507, false, MONS_TENTACLED_STARSPAWN, MONS_TENTACLED_STARSPAWN, MH_NONLIVING, 120,
    { {AT_BITE, AF_PLAIN, 40}, {AT_ENGULF, AF_PLAIN, 25} },
    16, 880,
    5, 5, MST_TENTACLED_STARSPAWN, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_GIANT, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_TENTACLED_STARSPAWN }, TILE_ERROR
},
{
    MONS_TERENCE, '@', LIGHTCYAN, "Terence",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    36, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 10,
    { {AT_HIT, AF_PLAIN, 5} },
    2, 200,
    0, 10, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_TERENCE }, TILE_ERROR
},
{
    MONS_THERMIC_DYNAMO, 'v', ETC_VEHUMET, "thermic dynamo",
    M_FLIES | M_INSUBSTANTIAL | M_SPEAKS,
    mrd(MR_RES_FIRE, 3) | mrd(MR_RES_COLD, 3),
    634, false, MONS_FIRE_VORTEX, MONS_THERMIC_DYNAMO, MH_NONLIVING, WILL_INVULN,
    { {AT_TOUCH, AF_FIRE, 18}, {AT_ENGULF, AF_COLD, 14} },
    10, 380,
    4, 16, MST_THERMIC_DYNAMO, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, {8, 8, 10, 10, 10},
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_THERMIC_DYNAMO, TVARY_CYCLE }, TILE_ERROR
},
{
    MONS_THORN_HUNTER, 'f', WHITE, "thorn hunter",
    M_SEE_INVIS,
    MR_RES_POISON | mrd(MR_RES_FIRE, -1),
    1431, false, MONS_PLANT, MONS_THORN_HUNTER, MH_PLANT, 100,
    { {AT_HIT, AF_PLAIN, 27}, {AT_HIT, AF_PLAIN, 23} },
    15, 975,
    9, 9, MST_THORN_HUNTER, false, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS, 12, {10, 12, 10, 10, 10},
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_PLANT, GOD_NO_GOD,
    { TILEP_MONS_THORN_HUNTER }, TILE_ERROR
},
{
    MONS_THRASHING_HORROR, 'X', YELLOW, "thrashing horror",
    M_BATTY | M_NO_POLY_TO,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    795, false, MONS_THRASHING_HORROR, MONS_THRASHING_HORROR, MH_NONLIVING, 60,
    { {AT_TRAMPLE, AF_TRAMPLE, 17}, {AT_TRAMPLE, AF_TRAMPLE, 9} },
    9, 495,
    5, 10, MST_THRASHING_HORROR, false, S_ROAR,
    I_ANIMAL, HT_LAND, 25, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_THRASHING_HORROR }, TILE_ERROR
},
{
    MONS_TIAMAT, 'd', COLOUR_UNDEF, "Tiamat",
    M_FLIES | M_SEE_INVIS | M_SPEAKS | M_COLD_BLOOD | M_UNIQUE | M_FEMALE,
    MR_RES_POISON,
    5133, false, MONS_DRACONIAN, MONS_DRACONIAN, MH_NATURAL, 140,
    { {AT_HIT, AF_PLAIN, 60}, {AT_TAIL_SLAP, AF_PLAIN, 45} },
    22, 3850,
    30, 10, MST_NO_SPELLS, false, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_HUMANOID_WINGED_TAILED, GOD_NO_GOD,
    { TILEP_MONS_TIAMAT }, TILE_ERROR
},
{
    MONS_TITAN, 'C', LIGHTCYAN, "titan",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    mrd(MR_RES_ELEC, 3),
    1664, false, MONS_GIANT, MONS_TITAN, MH_NATURAL, 180,
    { {AT_HIT, AF_PLAIN, 55} },
    20, 1100,
    10, 3, MST_TITAN, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_GIANT, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_TITAN }, TILE_CORPSE_TITAN
},
{
    MONS_TOADSTOOL, 'P', COLOUR_UNDEF, "toadstool",
    M_STATIONARY | M_NO_EXP_GAIN | M_NO_THREAT,
    MR_RES_POISON,
    10, false, MONS_FUNGUS, MONS_TOADSTOOL, MH_PLANT, WILL_INVULN,
    {  },
    1, 30,
    1, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_FUNGUS, GOD_NO_GOD,
    { TILEP_MONS_TOADSTOOL, TVARY_MOD }, TILE_ERROR
},
{
    MONS_TOENAIL_GOLEM, '9', RED, "toenail golem",
    M_NO_FLAGS,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    477, false, MONS_GOLEM, MONS_TOENAIL_GOLEM, MH_NONLIVING, WILL_INVULN,
    { {AT_GORE, AF_PLAIN, 13} },
    9, 585,
    8, 5, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_TOENAIL_GOLEM }, TILE_ERROR
},
{
    MONS_TORMENTOR, '2', LIGHTMAGENTA, "tormentor",
    M_SPEAKS,
    MR_RES_POISON | MR_RES_FIRE,
    348, false, MONS_TORMENTOR, MONS_TORMENTOR, MH_DEMONIC, 60,
    { {AT_HIT, AF_PAIN, 8}, {AT_HIT, AF_PAIN, 8} },
    7, 385,
    12, 12, MST_TORMENTOR, false, S_ROAR,
    I_HUMAN, HT_LAND, 13, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_TORMENTOR }, TILE_ERROR
},
{
    MONS_TORPOR_SNAIL, 'w', GREEN, "torpor snail",
    M_WEB_IMMUNE | M_NO_SKELETON | M_HAS_AURA,
    MR_NO_FLAGS,
    423, false, MONS_ELEPHANT_SLUG, MONS_TORPOR_SNAIL, MH_NATURAL, 80,
    { {AT_BITE, AF_PLAIN, 25} },
    10, 600,
    8, 1, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS, 7, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_SNAIL, GOD_NO_GOD,
    { TILEP_MONS_TORPOR_SNAIL }, TILE_CORPSE_TORPOR_SNAIL
},
{
    MONS_TRAINING_DUMMY, 'I', LIGHTGRAY, "training dummy",
    M_STATIONARY,
    MR_RES_PETRIFY,
    10, false, MONS_TRAINING_DUMMY, MONS_TRAINING_DUMMY, MH_NONLIVING, WILL_INVULN,
    { {AT_WEAP_ONLY, AF_PLAIN, 1} },
    1, 60,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_TRAINING_DUMMY }, TILE_ERROR
},
{
    MONS_TROLL, 'T', BROWN, "troll",
    M_SPEAKS | M_WARM_BLOOD | M_FAST_REGEN,
    MR_NO_FLAGS,
    307, false, MONS_TROLL, MONS_TROLL, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 20}, {AT_CLAW, AF_PLAIN, 15}, {AT_CLAW, AF_PLAIN, 15} },
    7, 385,
    3, 10, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_TROLL }, TILE_CORPSE_TROLL
},
{
    MONS_TWISTER, 'v', ETC_AIR, "twister",
    M_FLIES | M_CONFUSED | M_BATTY | M_INSUBSTANTIAL | M_NO_EXP_GAIN | M_NO_POLY_TO,
    mrd(MR_RES_ELEC, 3) | MR_RES_FIRE | mrd(MR_RES_COLD, 3),
    5, false, MONS_FIRE_VORTEX, MONS_TWISTER, MH_NONLIVING, WILL_INVULN,
    {  },
    12, 120000,
    0, 5, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_TWISTER, TVARY_CYCLE }, TILE_ERROR
},
{
    MONS_TWO_HEADED_OGRE, 'O', LIGHTRED, "two-headed ogre",
    M_SPEAKS | M_WARM_BLOOD | M_TWO_WEAPONS,
    MR_NO_FLAGS,
    824, false, MONS_OGRE, MONS_TWO_HEADED_OGRE, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 20}, {AT_HIT, AF_PLAIN, 15} },
    10, 550,
    3, 6, MST_NO_SPELLS, true, S_SHOUT2,
    I_HUMAN, HT_LAND, 10, {10, 10, 15, 10, 10},
    MONUSE_STARTING_EQUIPMENT, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_TWO_HEADED_OGRE }, TILE_CORPSE_TWO_HEADED_OGRE
},
{
    MONS_TYRANT_LEECH, 'w', RED, "tyrant leech",
    M_NO_SKELETON,
    MR_NO_FLAGS,
    287, false, MONS_TYRANT_LEECH, MONS_TYRANT_LEECH, MH_NATURAL, 40,
    { {AT_BITE, AF_VAMPIRIC, 35} },
    12, 600,
    5, 15, MST_NO_SPELLS, true, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS, 8, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_TYRANT_LEECH }, TILE_CORPSE_TYRANT_LEECH
},
{
    MONS_TZITZIMITL, '1', MAGENTA, "Tzitzimitl",
    M_FLIES | M_SEE_INVIS,
    MR_RES_ELEC | MR_RES_POISON | mrd(MR_RES_COLD, 2),
    2056, false, MONS_TZITZIMITL, MONS_TZITZIMITL, MH_DEMONIC, WILL_INVULN,
    { {AT_ENGULF, AF_DRAIN_SPEED, 25}, {AT_BITE, AF_DRAIN, 25} },
    22, 1050,
    12, 16, MST_TZITZIMITL, false, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_TZITZIMITL }, TILE_ERROR
},
{
    MONS_UFETUBUS, '5', LIGHTCYAN, "ufetubus",
    M_NO_FLAGS,
    mrd(MR_RES_FIRE, -1) | MR_RES_COLD,
    8, false, MONS_UFETUBUS, MONS_UFETUBUS, MH_DEMONIC, 10,
    { {AT_HIT, AF_FLANK, 6}, {AT_HIT, AF_PLAIN, 6} },
    1, 90,
    2, 15, MST_NO_SPELLS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_SMALL, MON_SHAPE_BIRD, GOD_NO_GOD,
    { TILEP_MONS_UFETUBUS }, TILE_ERROR
},
{
    MONS_UGLY_THING, 'u', COLOUR_UNDEF, "ugly thing",
    M_WARM_BLOOD | M_GHOST_DEMON | M_HERD | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    555, false, MONS_UGLY_THING, MONS_UGLY_THING, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 17} },
    12, 660,
    4, 10, MST_NO_SPELLS, true, S_GURGLE,
    I_ANIMAL, HT_LAND, 10, {9, 9, 10, 10, 10},
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_UGLY_THING }, TILE_CORPSE_UGLY_THING
},
{
    MONS_UNDERTAKER, '9', ETC_BONE, "undertaker",
    M_NO_FLAGS,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    2415, false, MONS_UNDERTAKER, MONS_UNDERTAKER, MH_NONLIVING, WILL_INVULN,
    { {AT_PUNCH, AF_PLAIN, 42}, {AT_CLAW, AF_DRAG, 32} },
    19, 1240,
    18, 9, MST_UNDERTAKER, false, S_SILENT,
    I_BRAINLESS, HT_WALL, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_GIANT, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_UNDERTAKER }, TILE_ERROR
},
{
    MONS_UNDYING_ARMOURY, 'v', LIGHTMAGENTA, "undying armoury",
    M_FLIES | M_INSUBSTANTIAL | M_FIGHTER,
    MR_RES_FIRE | MR_RES_COLD | MR_RES_ELEC,
    1673, false, MONS_UNDYING_ARMOURY, MONS_UNDYING_ARMOURY, MH_UNDEAD, 120,
    { {AT_HIT, AF_PLAIN, 27}, {AT_HIT, AF_PLAIN, 27}, {AT_HIT, AF_PLAIN, 27} },
    17, 970,
    11, 19, MST_UNDYING_ARMOURY, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_UNDYING_ARMOURY }, TILE_ERROR
},
{
    MONS_UNSEEN_HORROR, 'x', MAGENTA, "unseen horror",
    M_INVIS | M_SEE_INVIS | M_BATTY,
    MR_NO_FLAGS,
    384, false, MONS_UNSEEN_HORROR, MONS_UNSEEN_HORROR, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 12} },
    7, 385,
    5, 10, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 30, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_UNSEEN_HORROR }, TILE_ERROR
},
{
    MONS_URUG, 'o', RED, "Urug",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    795, false, MONS_ORC, MONS_ORC, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 25} },
    9, 675,
    2, 13, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_URUG }, TILE_ERROR
},
{
    MONS_USHABTI, '9', BROWN, "ushabti",
    M_FIGHTER | M_SEE_INVIS,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    205, false, MONS_GOLEM, MONS_USHABTI, MH_NONLIVING, WILL_INVULN,
    { {AT_HEADBUTT, AF_PLAIN, 30} },
    7, 455,
    9, 6, MST_USHABTI, false, S_SILENT,
    I_HUMAN, HT_LAND, 8, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_USHABTI }, TILE_ERROR
},
{
    MONS_VAMPIRE_BAT, 'b', MAGENTA, "vampire bat",
    M_FLIES | M_SEE_INVIS | M_BATTY | M_WARM_BLOOD | M_NO_POLY_TO,
    MR_NO_FLAGS,
    64, false, MONS_BAT, MONS_VAMPIRE_BAT, MH_UNDEAD, 10,
    { {AT_BITE, AF_VAMPIRIC, 6} },
    3, 145,
    1, 14, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_LAND, 30, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_BAT, GOD_NO_GOD,
    { TILEP_MONS_VAMPIRE_BAT }, TILE_ERROR
},
{
    MONS_VAMPIRE_BLOODPRINCE, 'V', LIGHTRED, "vampire bloodprince",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_GENDER_NEUTRAL | M_FLIES,
    MR_RES_COLD,
    2240, false, MONS_VAMPIRE, MONS_VAMPIRE, MH_UNDEAD, 120,
    { {AT_CLAW, AF_PLAIN, 45}, {AT_BITE, AF_VAMPIRIC, 25} },
    17, 1250,
    15, 10, MST_VAMPIRE_BLOODPRINCE, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_VAMPIRE_BLOODPRINCE }, TILE_ERROR
},
{
    MONS_VAMPIRE_KNIGHT, 'V', CYAN, "vampire knight",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_RES_COLD,
    1049, false, MONS_VAMPIRE, MONS_VAMPIRE, MH_UNDEAD, 80,
    { {AT_HIT, AF_PLAIN, 33}, {AT_BITE, AF_VAMPIRIC, 15} },
    11, 715,
    10, 10, MST_VAMPIRE_KNIGHT, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_VAMPIRE_KNIGHT }, TILE_ERROR
},
{
    MONS_VAMPIRE_MAGE, 'V', MAGENTA, "vampire mage",
    M_FLIES | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_RES_COLD,
    802, false, MONS_VAMPIRE, MONS_VAMPIRE, MH_UNDEAD, 80,
    { {AT_HIT, AF_PLAIN, 15}, {AT_BITE, AF_VAMPIRIC, 15} },
    10, 550,
    10, 10, MST_VAMPIRE_MAGE, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_VAMPIRE_MAGE }, TILE_ERROR
},
{
    MONS_VAMPIRE_MOSQUITO, 'y', LIGHTGRAY, "vampire mosquito",
    M_FLIES | M_NO_SKELETON | M_NO_ZOMBIE,
    MR_NO_FLAGS,
    179, false, MONS_VAMPIRE_MOSQUITO, MONS_VAMPIRE_MOSQUITO, MH_UNDEAD, 20,
    { {AT_BITE, AF_VAMPIRIC, 13} },
    5, 275,
    2, 15, MST_NO_SPELLS, true, S_BUZZ,
    I_ANIMAL, HT_LAND, 19, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_INSECT_WINGED, GOD_NO_GOD,
    { TILEP_MONS_VAMPIRE_MOSQUITO }, TILE_CORPSE_VAMPIRE_MOSQUITO
},
{
    MONS_VAMPIRE, 'V', RED, "vampire",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_RES_COLD,
    214, false, MONS_VAMPIRE, MONS_VAMPIRE, MH_UNDEAD, 40,
    { {AT_HIT, AF_PLAIN, 15}, {AT_BITE, AF_VAMPIRIC, 15} },
    6, 330,
    10, 10, MST_VAMPIRE, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_VAMPIRE }, TILE_ERROR
},
{
    MONS_VASHNIA, 'N', LIGHTCYAN, "Vashnia",
    M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_ARCHER | M_FEMALE | M_PREFER_RANGED,
    MR_RES_POISON,
    3195, false, MONS_NAGA, MONS_NAGA, MH_NATURAL, 120,
    { {AT_HIT, AF_PLAIN, 25}, {AT_CONSTRICT, AF_CRUSH, 7} },
    16, 1600,
    6, 18, MST_VASHNIA, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, {14, 14, 10, 10, 10},
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_NAGA, GOD_NO_GOD,
    { TILEP_MONS_VASHNIA }, TILE_ERROR
},
{
    MONS_VAULT_GUARD, 'p', CYAN, "vault guard",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    869, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 20} },
    13, 715,
    1, 13, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_VAULT_GUARD }, TILE_ERROR
},
{
    MONS_VAULT_SENTINEL, 'p', LIGHTBLUE, "vault sentinel",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    448, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 15} },
    8, 520,
    1, 13, MST_VAULT_SENTINEL, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_VAULT_SENTINEL }, TILE_ERROR
},
{
    MONS_VAULT_WARDEN, 'p', LIGHTRED, "vault warden",
    M_FIGHTER | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    1219, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 36} },
    16, 880,
    1, 13, MST_VAULT_WARDEN, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_VAULT_WARDEN }, TILE_ERROR
},
{
    MONS_VERY_UGLY_THING, 'u', COLOUR_UNDEF, "very ugly thing",
    M_WARM_BLOOD | M_GHOST_DEMON | M_HERD | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    1094, false, MONS_UGLY_THING, MONS_VERY_UGLY_THING, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 27} },
    18, 990,
    6, 10, MST_NO_SPELLS, true, S_GURGLE,
    I_ANIMAL, HT_LAND, 10, {9, 9, 10, 10, 10},
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_VERY_UGLY_THING }, TILE_CORPSE_VERY_UGLY_THING
},
{
    MONS_VINE_STALKER, 'f', GREEN, "vine stalker",
    M_SPEAKS | M_WARM_BLOOD | M_FAST_REGEN | M_NO_SKELETON | M_NO_POLY_TO | M_NO_GEN_DERIVED,
    MR_NO_FLAGS,
    390, false, MONS_VINE_STALKER, MONS_VINE_STALKER, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 10}, {AT_BITE, AF_ANTIMAGIC, 10} },
    8, 360,
    2, 12, MST_NO_SPELLS, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_VINE_STALKER }, TILE_ERROR
},
{
    MONS_VOID_OOZE, 'J', CYAN, "void ooze",
    M_EAT_DOORS | M_SEE_INVIS | M_UNBLINDABLE | M_AMORPHOUS | M_NO_SKELETON,
    MR_RES_POISON | mrd(MR_RES_CORR, 3),
    1110, false, MONS_JELLY, MONS_VOID_OOZE, MH_NATURAL, WILL_INVULN,
    { {AT_ENGULF, AF_FLOOD, 27}, {AT_HIT, AF_ANTIMAGIC, 15} },
    13, 500,
    3, 15, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 16, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_BLOB, GOD_NO_GOD,
    { TILEP_MONS_VOID_OOZE }, TILE_ERROR
},
{
    MONS_VV, '9', MAGENTA, "Vv",
    M_UNIQUE | M_FEMALE,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD | MR_RES_PETRIFY,
    3226, false, MONS_VV, MONS_VV, MH_NONLIVING, 140,
    { {AT_HIT, AF_COLD, 35}, {AT_HIT, AF_FIRE, 35} },
    23, 2700,
    27, 12, MST_VV, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_VV }, TILE_ERROR
},
{
    MONS_WALKING_ALEMBIC, '9', ETC_ELVEN, "walking alembic",
    M_FIGHTER,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    350, false, MONS_GOLEM, MONS_WALKING_ALEMBIC, MH_NONLIVING, WILL_INVULN,
    { {AT_PUNCH, AF_ALEMBIC, 19} },
    9, 580,
    9, 8, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_WALKING_ALEMBIC }, TILE_ERROR
},
{
    MONS_WALKING_TOME, ';', BROWN, "walking tome",
    M_CANT_SPAWN,
    MR_NO_FLAGS,
    10, false, MONS_WALKING_TOME, MONS_WALKING_TOME, MH_NONLIVING, 10,
    {  },
    0, 0,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_CRYSTAL_TOME }, TILE_ERROR
},
{
    MONS_WANDERING_MUSHROOM, 'f', BROWN, "wandering mushroom",
    M_NO_FLAGS,
    MR_RES_POISON,
    315, false, MONS_FUNGUS, MONS_WANDERING_MUSHROOM, MH_PLANT, 40,
    { {AT_SPORE, AF_CONFUSE, 20} },
    8, 440,
    5, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_FUNGUS, GOD_NO_GOD,
    { TILEP_MONS_WANDERING_MUSHROOM }, TILE_ERROR
},
{
    MONS_WAR_GARGOYLE, '9', LIGHTCYAN, "war gargoyle",
    M_FLIES | M_FIGHTER | M_SEE_INVIS,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD | MR_RES_PETRIFY,
    992, false, MONS_GOLEM, MONS_WAR_GARGOYLE, MH_NONLIVING, 100,
    { {AT_HIT, AF_PLAIN, 40} },
    10, 520,
    25, 4, MST_WAR_GARGOYLE, false, S_SILENT,
    I_HUMAN, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_STARTING_EQUIPMENT, SIZE_MEDIUM, MON_SHAPE_HUMANOID_WINGED_TAILED, GOD_NO_GOD,
    { TILEP_MONS_WAR_GARGOYLE }, TILE_ERROR
},
{
    MONS_WARG, 'h', WHITE, "warg",
    M_SEE_INVIS | M_UNBLINDABLE | M_WARM_BLOOD,
    MR_RES_POISON,
    187, false, MONS_HOUND, MONS_WARG, MH_NATURAL, 40,
    { {AT_BITE, AF_PLAIN, 25} },
    5, 325,
    9, 12, MST_NO_SPELLS, true, S_HOWL,
    I_ANIMAL, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_WARG }, TILE_CORPSE_WARG
},
{
    MONS_WATER_ELEMENTAL, 'E', ETC_WATER, "water elemental",
    M_AMORPHOUS,
    MR_RES_ELEC | mrd(MR_RES_FIRE, -1),
    212, false, MONS_ELEMENTAL, MONS_WATER_ELEMENTAL, MH_NONLIVING, WILL_INVULN,
    { {AT_ENGULF, AF_FLOOD, 22} },
    6, 420,
    4, 7, MST_NO_SPELLS, false, S_SILENT,
    I_ANIMAL, HT_AMPHIBIOUS, 10, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_WATER_ELEMENTAL }, TILE_ERROR
},
{
    MONS_WATER_MOCCASIN, 'S', BROWN, "water moccasin",
    M_COLD_BLOOD,
    MR_RES_POISON,
    149, false, MONS_SNAKE, MONS_WATER_MOCCASIN, MH_NATURAL, 20,
    { {AT_BITE, AF_POISON, 10} },
    5, 275,
    2, 15, MST_NO_SPELLS, true, S_HISS,
    I_ANIMAL, HT_AMPHIBIOUS, 14, {10, 6, 10, 10, 10},
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_SNAKE, GOD_NO_GOD,
    { TILEP_MONS_WATER_MOCCASIN }, TILE_CORPSE_WATER_MOCCASIN
},
{
    MONS_WATER_NYMPH, 'm', MAGENTA, "water nymph",
    M_SPEAKS | M_WARM_BLOOD,
    MR_NO_FLAGS,
    444, false, MONS_WATER_NYMPH, MONS_WATER_NYMPH, MH_NATURAL, 100,
    { {AT_TOUCH, AF_DROWN, 12} },
    10, 400,
    2, 13, MST_WATER_NYMPH, true, S_SHOUT,
    I_HUMAN, HT_AMPHIBIOUS, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_WATER_NYMPH }, TILE_CORPSE_WATER_NYMPH
},
{
    MONS_WEEPING_SKULL, 'z', LIGHTBLUE, "weeping skull",
    M_FLIES,
    MR_RES_COLD,
    98, false, MONS_WEEPING_SKULL, MONS_WEEPING_SKULL, MH_UNDEAD, 20,
    { {AT_TOUCH, AF_DRAIN, 10} },
    5, 280,
    7, 3, MST_WEEPING_SKULL, false, S_MOAN,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_WEEPING_SKULL }, TILE_ERROR
},
{
    MONS_WENDIGO, 'R', BLUE, "wendigo",
    M_SEE_INVIS,
    MR_RES_POISON | mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 3),
    994, false, MONS_WENDIGO, MONS_WENDIGO, MH_DEMONIC, 140,
    { {AT_CLAW, AF_COLD, 30}, {AT_BITE, AF_VAMPIRIC, 20} },
    15, 880,
    4, 20, MST_WENDIGO, false, S_HOWL,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_WENDIGO }, TILE_ERROR
},
{
    MONS_WHITE_DRACONIAN, 'd', WHITE, "white draconian",
    M_SPEAKS | M_COLD_BLOOD,
    MR_RES_COLD,
    997, false, MONS_DRACONIAN, MONS_WHITE_DRACONIAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 20} },
    14, 980,
    9, 10, MST_NO_SPELLS, true, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_CORPSE_WHITE_DRACONIAN
},
{
    MONS_WHITE_IMP, '5', WHITE, "white imp",
    M_FLIES | M_SPEAKS,
    MR_RES_POISON | mrd(MR_RES_FIRE, -1) | mrd(MR_RES_COLD, 2),
    10, false, MONS_WHITE_IMP, MONS_WHITE_IMP, MH_DEMONIC, 10,
    { {AT_HIT, AF_COLD, 4} },
    2, 110,
    4, 10, MST_WHITE_IMP, false, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LITTLE, MON_SHAPE_HUMANOID_WINGED, GOD_NO_GOD,
    { TILEP_MONS_WHITE_IMP }, TILE_ERROR
},
{
    MONS_WIGHT, 'z', GREEN, "wight",
    M_NO_FLAGS,
    mrd(MR_RES_COLD, 2),
    73, false, MONS_WIGHT, MONS_WIGHT, MH_UNDEAD, 20,
    { {AT_HIT, AF_DRAIN, 8} },
    3, 165,
    4, 10, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_WIGHT }, TILE_ERROR
},
{
    MONS_WIGLAF, 'g', LIGHTGREEN, "Wiglaf",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_MALE,
    MR_NO_FLAGS,
    1913, false, MONS_DWARF, MONS_DWARF, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 26} },
    15, 1570,
    4, 7, MST_WIGLAF, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_WIGLAF }, TILE_ERROR
},
{
    MONS_WILL_O_THE_WISP, 'v', GREEN, "will-o-the-wisp",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    MR_RES_ELEC | mrd(MR_RES_FIRE, 2),
    532, false, MONS_WILL_O_THE_WISP, MONS_WILL_O_THE_WISP, MH_NONLIVING, WILL_INVULN,
    {  },
    10, 400,
    4, 10, MST_WILL_O_THE_WISP, false, S_MOAN,
    I_BRAINLESS, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_TINY, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_WILL_O_THE_WISP }, TILE_ERROR
},
{
    MONS_WIND_DRAKE, 'k', WHITE, "wind drake",
    M_FLIES | M_WARM_BLOOD,
    MR_NO_FLAGS,
    285, false, MONS_DRAKE, MONS_WIND_DRAKE, MH_NATURAL, 40,
    { {AT_BITE, AF_PLAIN, 12} },
    8, 600,
    3, 14, MST_WIND_DRAKE, true, S_HISS,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_WIND_DRAKE }, TILE_CORPSE_WIND_DRAKE
},
{
    MONS_WITHERED_PLANT, 'P', DARKGRAY, "withered plant",
    M_FRAGILE | M_STATIONARY | M_NO_EXP_GAIN | M_NO_THREAT,
    mrd(MR_RES_POISON, 3) | mrd(MR_RES_NEG, 3),
    10, false, MONS_PLANT, MONS_WITHERED_PLANT, MH_PLANT, WILL_INVULN,
    {  },
    10, 2000,
    0, 0, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 0, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_PLANT, GOD_NO_GOD,
    { TILEP_MONS_WITHERED_PLANT, TVARY_MOD }, TILE_ERROR
},
{
    MONS_WOLF_SPIDER, 's', WHITE, "wolf spider",
    M_WEB_IMMUNE | M_NO_SKELETON,
    mrd(MR_RES_POISON, -1),
    564, false, MONS_SPIDER, MONS_WOLF_SPIDER, MH_NATURAL, 20,
    { {AT_HIT, AF_PLAIN, 25}, {AT_BITE, AF_POISON, 15} },
    11, 550,
    3, 10, MST_NO_SPELLS, true, S_SKITTER,
    I_ANIMAL, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_ARACHNID, GOD_NO_GOD,
    { TILEP_MONS_WOLF_SPIDER }, TILE_CORPSE_WOLF_SPIDER
},
{
    MONS_WOLF, 'h', LIGHTGRAY, "wolf",
    M_SEE_INVIS | M_UNBLINDABLE | M_WARM_BLOOD,
    MR_NO_FLAGS,
    117, false, MONS_HOUND, MONS_WOLF, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 12} },
    4, 220,
    4, 15, MST_NO_SPELLS, true, S_HOWL,
    I_ANIMAL, HT_LAND, 17, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_MEDIUM, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_WOLF }, TILE_CORPSE_WOLF
},
{
    MONS_WORLDBINDER, 'x', CYAN, "worldbinder",
    M_FLIES,
    MR_NO_FLAGS,
    512, false, MONS_WORLDBINDER, MONS_WORLDBINDER, MH_NONLIVING, 60,
    { {AT_HIT, AF_PLAIN, 8}, {AT_HIT, AF_PLAIN, 8} },
    8, 400,
    12, 4, MST_WORLDBINDER, false, S_SILENT,
    I_ANIMAL, HT_LAND, 14, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_SMALL, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_WORLDBINDER }, TILE_ERROR
},
{
    MONS_WRAITH, 'W', LIGHTGRAY, "wraith",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    MR_RES_COLD,
    209, false, MONS_WRAITH, MONS_WRAITH, MH_UNDEAD, 60,
    { {AT_HIT, AF_DRAIN_SPEED, 15} },
    6, 330,
    10, 10, MST_NO_SPELLS, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_WRAITH }, TILE_ERROR
},
{
    MONS_WRETCHED_STAR, '*', MAGENTA, "wretched star",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    MR_RES_ELEC | MR_RES_FIRE | MR_RES_COLD,
    770, false, MONS_WRETCHED_STAR, MONS_WRETCHED_STAR, MH_NONLIVING, WILL_INVULN,
    {  },
    10, 700,
    10, 10, MST_WRETCHED_STAR, false, S_SILENT,
    I_HUMAN, HT_LAND, 10, {8, 8, 10, 10, 10},
    MONUSE_NOTHING, SIZE_LITTLE, MON_SHAPE_ORB, GOD_NO_GOD,
    { TILEP_MONS_WRETCHED_STAR }, TILE_ERROR
},
{
    MONS_WYRMHOLE, 'k', LIGHTMAGENTA, "wyrmhole",
    M_FLIES | M_SEE_INVIS | M_INSUBSTANTIAL,
    MR_RES_FIRE | MR_RES_COLD | MR_RES_ELEC,
    2297, false, MONS_WYRMHOLE, MONS_WYRMHOLE, MH_NONLIVING, WILL_INVULN,
    { {AT_BITE, AF_BLINK_WITH, 44} },
    18, 845,
    8, 22, MST_WYRMHOLE, false, S_HISS,
    I_ANIMAL, HT_LAND, 12, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_WYRMHOLE, TVARY_RANDOM }, TILE_ERROR
},
{
    MONS_WYVERN, 'k', LIGHTGREEN, "wyvern",
    M_FLIES | M_WARM_BLOOD,
    MR_NO_FLAGS,
    207, false, MONS_WYVERN, MONS_WYVERN, MH_NATURAL, 20,
    { {AT_BITE, AF_PLAIN, 20} },
    5, 275,
    5, 10, MST_NO_SPELLS, true, S_HISS,
    I_ANIMAL, HT_LAND, 15, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_WYVERN }, TILE_CORPSE_WYVERN
},
{
    MONS_XAKKRIXIS, 'B', LIGHTGREEN, "Xak'krixis",
    M_SEE_INVIS | M_SPEAKS | M_UNIQUE | M_WARM_BLOOD | M_NO_SKELETON | M_GENDER_NEUTRAL | M_BURROWS,
    MR_NO_FLAGS,
    1492, false, MONS_FORMICID, MONS_XAKKRIXIS, MH_NATURAL, 80,
    { {AT_HIT, AF_PLAIN, 24} },
    17, 1650,
    3, 10, MST_XAKKRIXIS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_XAKKRIXIS }, TILE_CORPSE_FORMICID
},
{
    MONS_XTAHUA, 'D', RED, "Xtahua",
    M_CRASH_DOORS | M_FLIES | M_SEE_INVIS | M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_GENDER_NEUTRAL,
    MR_RES_POISON | mrd(MR_RES_FIRE, 2) | mrd(MR_RES_COLD, -1),
    3664, false, MONS_DRAGON, MONS_FIRE_DRAGON, MH_NATURAL, 180,
    { {AT_BITE, AF_PLAIN, 44}, {AT_CLAW, AF_PLAIN, 20}, {AT_TRAMPLE, AF_TRAMPLE, 27} },
    20, 2350,
    18, 7, MST_XTAHUA, true, S_LOUD_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_GIANT, MON_SHAPE_QUADRUPED_WINGED, GOD_NO_GOD,
    { TILEP_MONS_XTAHUA }, TILE_ERROR
},
{
    MONS_YAK, 'Y', BROWN, "yak",
    M_WARM_BLOOD | M_HERD,
    MR_NO_FLAGS,
    204, false, MONS_YAK, MONS_YAK, MH_NATURAL, 20,
    { {AT_GORE, AF_PLAIN, 18} },
    7, 385,
    4, 7, MST_NO_SPELLS, true, S_BELLOW,
    I_ANIMAL, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_LARGE, MON_SHAPE_QUADRUPED, GOD_NO_GOD,
    { TILEP_MONS_YAK }, TILE_CORPSE_YAK
},
{
    MONS_YAKTAUR_CAPTAIN, 'c', LIGHTRED, "yaktaur captain",
    M_FIGHTER | M_SPEAKS | M_WARM_BLOOD | M_ARCHER,
    MR_NO_FLAGS,
    895, false, MONS_YAKTAUR, MONS_YAKTAUR, MH_NATURAL, 60,
    { {AT_HIT, AF_PLAIN, 30} },
    14, 770,
    5, 5, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_CENTAUR, GOD_NO_GOD,
    { TILEP_MONS_YAKTAUR_CAPTAIN }, TILE_ERROR
},
{
    MONS_YAKTAUR, 'c', RED, "yaktaur",
    M_SPEAKS | M_WARM_BLOOD | M_ARCHER,
    MR_NO_FLAGS,
    360, false, MONS_YAKTAUR, MONS_YAKTAUR, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 20} },
    8, 440,
    4, 4, MST_NO_SPELLS, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_LARGE, MON_SHAPE_CENTAUR, GOD_NO_GOD,
    { TILEP_MONS_YAKTAUR }, TILE_CORPSE_YAKTAUR
},
{
    MONS_YELLOW_DRACONIAN, 'd', YELLOW, "yellow draconian",
    M_SPEAKS | M_COLD_BLOOD,
    MR_RES_CORR,
    1042, false, MONS_DRACONIAN, MONS_YELLOW_DRACONIAN, MH_NATURAL, 40,
    { {AT_HIT, AF_PLAIN, 20}, {AT_BITE, AF_ACID, 12} },
    14, 980,
    9, 10, MST_NO_SPELLS, true, S_ROAR,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID_TAILED, GOD_NO_GOD,
    { TILEP_MONS_PROGRAM_BUG }, TILE_CORPSE_YELLOW_DRACONIAN
},
{
    MONS_YNOXINUL, '3', LIGHTCYAN, "ynoxinul",
    M_FLIES,
    MR_RES_ELEC | MR_RES_POISON | MR_RES_COLD,
    212, false, MONS_YNOXINUL, MONS_YNOXINUL, MH_DEMONIC, 40,
    { {AT_HIT, AF_PLAIN, 12} },
    6, 330,
    3, 10, MST_YNOXINUL, false, S_BELLOW,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_MEDIUM, MON_SHAPE_HUMANOID_WINGED, GOD_NO_GOD,
    { TILEP_MONS_YNOXINUL }, TILE_ERROR
},
{
    MONS_ZENATA, 'a', LIGHTGRAY, "Zenata",
    M_SPEAKS | M_WARM_BLOOD | M_UNIQUE | M_FEMALE,
    MR_NO_FLAGS,
    1864, false, MONS_HUMAN, MONS_HUMAN, MH_NATURAL, 100,
    { {AT_HIT, AF_PLAIN, 35} },
    15, 1800,
    10, 10, MST_ZENATA, true, S_SHOUT,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_WEAPONS_ARMOUR, SIZE_MEDIUM, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ZENATA }, TILE_ERROR
},
{
    MONS_ZOMBIE, 'Z', BROWN, "zombie",
    M_NO_REGEN,
    mrd(MR_RES_COLD, 2),
    9, false, MONS_ZOMBIE, MONS_ZOMBIE, MH_UNDEAD, -1,
    { {AT_HIT, AF_PLAIN, 10} },
    1, 75,
    0, 4, MST_NO_SPELLS, false, S_SILENT,
    I_BRAINLESS, HT_LAND, 5, DEFAULT_ENERGY,
    MONUSE_NOTHING, SIZE_SMALL, MON_SHAPE_MISC, GOD_NO_GOD,
    { TILEP_MONS_ZOMBIE_SMALL }, TILE_ERROR
},
{
    MONS_ZYKZYL, '2', LIGHTCYAN, "zykzyl",
    M_SEE_INVIS,
    MR_RES_ELEC | MR_RES_POISON,
    1200, false, MONS_ZYKZYL, MONS_ZYKZYL, MH_DEMONIC, 160,
    { {AT_HIT, AF_PLAIN, 31} },
    11, 1145,
    3, 7, MST_ZYKZYL, false, S_GURGLE,
    I_HUMAN, HT_LAND, 10, DEFAULT_ENERGY,
    MONUSE_OPEN_DOORS, SIZE_LARGE, MON_SHAPE_HUMANOID, GOD_NO_GOD,
    { TILEP_MONS_ZYKZYL }, TILE_ERROR
},

};
