"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
require("reflect-metadata");
const api_1 = require("@opentelemetry/api");
const sdk_trace_node_1 = require("@opentelemetry/sdk-trace-node");
const common_1 = require("@nestjs/common");
const span_1 = require("./span");
const TestDecoratorThatSetsMetadata = () => (0, common_1.SetMetadata)('some-metadata', true);
const symbol = Symbol('testSymbol');
class TestSpan {
    singleSpan() { }
    doubleSpan() {
        return this.singleSpan();
    }
    fooProducerSpan() { }
    argsInOptions(a, b) { }
    implicitSpanNameWithOptions() { }
    argsInOptionsWithImplicitName(a, b) { }
    error() {
        throw new Error('hello world');
    }
    metadata() { }
    [_a = symbol]() { }
}
__decorate([
    (0, span_1.Span)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TestSpan.prototype, "singleSpan", null);
__decorate([
    (0, span_1.Span)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TestSpan.prototype, "doubleSpan", null);
__decorate([
    (0, span_1.Span)('foo', { kind: api_1.SpanKind.PRODUCER }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TestSpan.prototype, "fooProducerSpan", null);
__decorate([
    (0, span_1.Span)('bar', (a, b) => ({ attributes: { a, b } })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", void 0)
], TestSpan.prototype, "argsInOptions", null);
__decorate([
    (0, span_1.Span)({ kind: api_1.SpanKind.PRODUCER }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TestSpan.prototype, "implicitSpanNameWithOptions", null);
__decorate([
    (0, span_1.Span)((a, b) => ({ attributes: { a, b } })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", void 0)
], TestSpan.prototype, "argsInOptionsWithImplicitName", null);
__decorate([
    (0, span_1.Span)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TestSpan.prototype, "error", null);
__decorate([
    (0, span_1.Span)(),
    TestDecoratorThatSetsMetadata(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TestSpan.prototype, "metadata", null);
__decorate([
    (0, span_1.Span)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TestSpan.prototype, _a, null);
describe('Span', () => {
    let instance;
    let traceExporter;
    let spanProcessor;
    let provider;
    beforeAll(async () => {
        instance = new TestSpan();
        traceExporter = new sdk_trace_node_1.InMemorySpanExporter();
        spanProcessor = new sdk_trace_node_1.SimpleSpanProcessor(traceExporter);
        provider = new sdk_trace_node_1.NodeTracerProvider({
            spanProcessors: [spanProcessor],
        });
        provider.register();
    });
    afterEach(async () => {
        spanProcessor.forceFlush();
        traceExporter.reset();
    });
    afterAll(async () => {
        await provider.shutdown();
    });
    it('should maintain reflect metadataa', async () => {
        expect(Reflect.getMetadata('some-metadata', instance.metadata)).toEqual(true);
    });
    it('should preserve the original method name', () => {
        const originalFunctionName = instance.singleSpan.name;
        expect(originalFunctionName).toEqual('singleSpan');
    });
    it('should set correct span', async () => {
        instance.singleSpan();
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(1);
        expect(spans.map(span => span.name)).toEqual(['TestSpan.singleSpan']);
    });
    it('should set correct span options', async () => {
        instance.fooProducerSpan();
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(1);
        expect(spans.map(span => span.kind)).toEqual([api_1.SpanKind.PRODUCER]);
    });
    it('should set correct span options with implicit span name', async () => {
        instance.implicitSpanNameWithOptions();
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(1);
        expect(spans[0].name).toEqual('TestSpan.implicitSpanNameWithOptions');
        expect(spans[0].kind).toEqual(api_1.SpanKind.PRODUCER);
    });
    it('should set correct span options based on method params', async () => {
        instance.argsInOptions(10, 'bar');
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(1);
        expect(spans[0].attributes).toEqual({ a: 10, b: 'bar' });
    });
    it('should set correct span options based on method params with implicit span name', async () => {
        instance.argsInOptionsWithImplicitName(10, 'bar');
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(1);
        expect(spans[0].attributes).toEqual({ a: 10, b: 'bar' });
    });
    it('should set correct span even when calling other method with Span decorator', async () => {
        instance.doubleSpan();
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(2);
        expect(spans.map(span => span.name)).toEqual(['TestSpan.singleSpan', 'TestSpan.doubleSpan']);
    });
    it('should propagate errors', () => {
        expect(instance.error).toThrowError('hello world');
    });
    it('should set setStatus to ERROR and message to error message', async () => {
        expect(instance.error).toThrowError('hello world');
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(1);
        expect(spans[0].status).toEqual({ code: api_1.SpanStatusCode.ERROR, message: 'hello world' });
    });
    it('should set recordException with error', () => {
        expect(instance.error).toThrowError('hello world');
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(1);
        // Contain one exception event
        expect(spans[0].events).toHaveLength(1);
        expect(spans[0].events[0]).toEqual({
            name: 'exception',
            attributes: expect.anything(),
            droppedAttributesCount: 0,
            time: expect.anything(),
        });
    });
    it('should handle symbols', () => {
        instance[symbol]();
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(1);
        expect(spans.map(span => span.name)).toEqual(['TestSpan.Symbol(testSymbol)']);
    });
});
