import { ClsService } from '../cls.service';
import { ProxyProviderDefinition } from './proxy-provider.interfaces';
export declare class ProxyProvidersResolver {
    private readonly cls;
    private readonly proxyProviderMap;
    private readonly proxyProviderDependenciesMap;
    constructor(cls: ClsService, proxyProviderMap: Map<symbol, ProxyProviderDefinition>);
    /**
     * Resolves all Proxy Providers that have been registered,
     * or only the ones that are passed as an argument and their dependencies.
     */
    resolve(providerSymbols?: symbol[]): Promise<void>;
    /**
     * ProxyProviderResolutionPromisesMap is a map scoped to the
     * current CLS context that holds reference to the Promises of
     * all Proxy Providers (those that have been resolved and those
     * that are being resolved)
     *
     * It is used to prevent multiple concurrent resolutions of the same
     * Proxy Provider and also to ensure that all Proxy Providers are
     * resolved in the correct order (dependencies first)
     */
    private getOrCreateCurrentProxyPromisesMap;
    /**
     * Gets a set of all Proxy Provider symbols that need to be resolved
     * and symbols of their dependencies (that have not been resolved yet)
     */
    private getAllNeededProviderSymbols;
    private resolveProxyProvider;
    private resolveProxyProviderInstance;
    private resolveProxyClassProviderInstance;
    private resolveProxyFactoryProviderInstance;
}
//# sourceMappingURL=proxy-provider-resolver.d.ts.map