"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.COMPLETION_ZSH_TEMPLATE = exports.COMPLETION_SH_TEMPLATE = exports.cliPluginError = exports.HelpMeta = exports.Inquirer = exports.CommanderOptions = exports.Commander = exports.MessageMeta = exports.DefaultMeta = exports.ChoicesMeta = exports.WhenMeta = exports.TransformMeta = exports.ValidateMeta = exports.QuestionMeta = exports.QuestionSetMeta = exports.OptionChoiceMeta = exports.OptionMeta = exports.RootCommandMeta = exports.SubCommandMeta = exports.CommandMeta = void 0;
const metaKeyBuilder = (suffix) => {
    return `CommandBuilder:${suffix}`;
};
const questionMetaBuilder = (suffix) => {
    return metaKeyBuilder(`Question:${suffix}`);
};
exports.CommandMeta = metaKeyBuilder('Command:Meta');
exports.SubCommandMeta = metaKeyBuilder('Subcommand:Meta');
exports.RootCommandMeta = metaKeyBuilder('RootCommand:Meta');
exports.OptionMeta = metaKeyBuilder('Option:Meta');
exports.OptionChoiceMeta = metaKeyBuilder('OptionChoice:Meta');
exports.QuestionSetMeta = metaKeyBuilder('QuestionSet:Meta');
exports.QuestionMeta = questionMetaBuilder('Meta');
exports.ValidateMeta = questionMetaBuilder('Validate');
exports.TransformMeta = questionMetaBuilder('Transform');
exports.WhenMeta = questionMetaBuilder('When');
exports.ChoicesMeta = questionMetaBuilder('Choices');
exports.DefaultMeta = questionMetaBuilder('Default');
exports.MessageMeta = questionMetaBuilder('Message');
exports.Commander = Symbol('Commander');
exports.CommanderOptions = Symbol('CommanderOptions');
exports.Inquirer = Symbol('Inquirer');
exports.HelpMeta = metaKeyBuilder('Command:Help');
const cliPluginError = (cliName = 'nest-commander', pluginsAvailable = true) => {
    return pluginsAvailable
        ? ''
        : `${cliName} is expecting a configuration file, but didn't find one. Are you in the right directory?`;
};
exports.cliPluginError = cliPluginError;
exports.COMPLETION_SH_TEMPLATE = `###-begin-{{app_name}}-completions-###
#
# nest commander command completion script
#
# Installation: {{app_path}} {{completion_command}} >> ~/.bashrc
#    or {{app_path}} {{completion_command}} >> ~/.bash_profile on OSX.
#
_{{app_name}}_nest_commander_completions()
{
    local cur_word args type_list

    cur_word="\${COMP_WORDS[COMP_CWORD]}"
    args=("\${COMP_WORDS[@]}")

    # Check if {{app_name}}_nest_commander_filesystem_completions is set to "true" or "1"
    # If it is, use filename completion if last word starts with common filesystem operator chars
    #  \`.\` , \`/\` or \`~\` e.g. \`./\`, \`../\`, \`/\`, \`~/\` 
    if [[ "\${{{app_name}}_nest_commander_filesystem_completions}" == "true" ]] || [[ "\${{{app_name}}_nest_commander_filesystem_completions}" == "1" ]]; then
        if [[ "\${cur_word}" =~ ^\\.  ]] || [[ "\${cur_word}" =~ ^/ ]] || [[ "\${cur_word}" =~ ^~ ]]; then
            COMPREPLY=($(compgen -f -- "\${cur_word}"))
            return 0
        fi
    fi

    # ask nest commander to generate completions.
    type_list=$({{app_path}} completion "\${args[@]}")

    COMPREPLY=( $(compgen -W "\${type_list}" -- \${cur_word}) )

    # if no match was found, fall back to filename completion
    if [ \${#COMPREPLY[@]} -eq 0 ]; then
      COMPREPLY=()
    fi

    return 0
}
complete -o bashdefault -o default -F _{{app_name}}_nest_commander_completions {{app_name}} completion
###-end-{{app_name}}-completions-###
`;
exports.COMPLETION_ZSH_TEMPLATE = `#compdef {{app_name}}
###-begin-{{app_name}}-completions-###
#
# nest commander command completion script
#
# Installation: {{app_path}} {{completion_command}} >> ~/.zshrc
#    or {{app_path}} {{completion_command}} >> ~/.zprofile on OSX.
#
_{{app_name}}_nest_commander_completions()
{
  local reply
  local si=$IFS

  # Check if {{app_name}}_nest_commander_filesystem_completions is set to "true" or "1"
  # If it is, use zsh filename completion if last word starts with common filesystem operator chars
  #  \`.\` , \`/\` or \`~\` e.g. \`./\`, \`../\`, \`/\`, \`~/\` 
  if [[ "\${{{app_name}}_nest_commander_filesystem_completions}" == "true" ]] || [[ "\${{{app_name}}_nest_commander_filesystem_completions}" == "1" ]]; then
    if [[ "\${words[-1]}" =~ ^\\.  ]] || [[ "\${words[-1]}" =~ ^/ ]] || [[ "\${words[-1]}" =~ ^~ ]]; then
      _path_files
      return
    fi
  fi

  IFS=$'\n' reply=($(COMP_CWORD="$((CURRENT-1))" COMP_LINE="$BUFFER" COMP_POINT="$CURSOR" {{app_path}} completion "\${words[@]}"))
  IFS=$si

  # if no match was found, fall back to filename completion
  if [[ -z "\${reply[*]}" ]]; then
    _path_files
    return
  fi

  _describe 'values' reply
}
compdef _{{app_name}}_nest_commander_completions {{app_name}}
###-end-{{app_name}}-completions-###
`;
//# sourceMappingURL=constants.js.map