"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Settings = exports.Setting = void 0;
const bc = __importStar(require("batch-cluster"));
const node_util_1 = require("node:util");
/**
 * A setting value that can be observed for changes.
 *
 * Each Setting instance manages its own value and listeners, providing
 * a clean, composable alternative to global event buses or proxies.
 */
class Setting {
    defaultValue;
    #value;
    #listeners = new Set();
    constructor(defaultValue) {
        this.defaultValue = defaultValue;
        this.#value = this.defaultValue;
    }
    /** Get the current value */
    get value() {
        return this.#value;
    }
    /** Set a new value, notifying listeners if changed */
    set value(newValue) {
        if (this.#value !== newValue) {
            const old = this.#value;
            this.#value = newValue;
            for (const ea of this.#listeners) {
                ea(old, newValue);
            }
        }
    }
    /**
     * Subscribe to value changes.
     *
     * @returns Unsubscribe function
     */
    onChange(listener) {
        this.#listeners.add(listener);
        return () => this.#listeners.delete(listener);
    }
    /** Reset to default value */
    reset() {
        this.value = this.defaultValue;
    }
    /** Allow implicit coercion in conditionals */
    valueOf() {
        return this.#value;
    }
    toString() {
        return String(this.#value);
    }
}
exports.Setting = Setting;
const _debuglog = (0, node_util_1.debuglog)("exiftool-vendored");
function noop() { }
const ConsoleLogger = {
    trace: noop,
    debug: _debuglog,
    info: _debuglog,
    warn: console.warn,
    error: console.error,
};
const defaultLogger = () => (_debuglog.enabled ? ConsoleLogger : bc.NoLogger);
/**
 * Library-wide configuration settings for exiftool-vendored
 *
 * @see ExifToolOptions for per-instance settings.
 */
exports.Settings = {
    /**
     * Allow parsing of archaic timezone offsets that are no longer in use.
     *
     * These include historical offsets like:
     * - "-10:30" (Hawaii 1896-1947)
     * - "-04:30" (Venezuela 1912-1965, 2007-2016)
     * - "+04:51" (Bombay until 1955)
     * - and others from
     *   https://en.wikipedia.org/wiki/List_of_tz_database_time_zones
     *
     * **Warning**: Enabling this may lead to incorrect timezone parsing for
     * modern files, as these offsets are not currently used anywhere. Only enable
     * this if you are specifically working with historical photographs or scanned
     * archival material.
     *
     * @default false
     */
    allowArchaicTimezoneOffsets: new Setting(false),
    /**
     * Allow parsing of the UTC-12:00 timezone offset ("Baker Island Time") as a
     * valid timezone.
     *
     * This timezone is not used for any populated land, and is disabled by
     * default to prevent incorrect timezone parsing from files with mangled
     * metadata.
     *
     * @default false
     */
    allowBakerIslandTime: new Setting(false),
    /**
     * Maximum distance (in minutes) from a valid timezone offset to accept when
     * inferring timezones from GPS or UTC timestamp comparisons.
     *
     * This threshold handles GPS time drift and clock skew. GPS acquisition may
     * lag behind the actual photo time, especially if the GPS fix is old or the
     * camera clock is slightly off.
     *
     * - **15 minutes**: Stricter matching, fewer false positives, but may reject
     *   photos with older GPS fixes
     * - **30 minutes**: More tolerant of GPS lag, recommended for photos that may
     *   have stale GPS data
     *
     * @default 30 minutes
     */
    maxValidOffsetMinutes: new Setting(30),
    /**
     * Logger instance used throughout exiftool-vendored.
     *
     * By default, this is set to ConsoleLogger if NODE_DEBUG=exiftool-vendored is
     * set, otherwise NoLogger.
     *
     * This can be changed at runtime to redirect logging output. When changed,
     * the batch-cluster global logger is also updated for consistency.
     *
     * @default ConsoleLogger or NoLogger based on NODE_DEBUG
     */
    logger: new Setting(defaultLogger),
    /** Reset all settings to their default values */
    reset() {
        for (const ea of Object.values(this)) {
            if (ea instanceof Setting)
                ea.reset();
        }
    },
};
//# sourceMappingURL=Settings.js.map