import { ExifToolOptions } from "./ExifToolOptions";
import { Maybe } from "./Maybe";
import { StrEnum, StrEnumKeys } from "./StrEnum";
export type GpsLocationTags = {
    GPSLatitude?: number;
    GPSLatitudeRef?: string;
    GPSLongitude?: number;
    GPSLongitudeRef?: string;
    GPSPosition?: string;
    GeolocationPosition?: string;
};
export declare const GpsLocationTagNames: StrEnum<"GPSLatitude" | "GPSLatitudeRef" | "GPSLongitude" | "GPSLongitudeRef" | "GPSPosition" | "GeolocationPosition">;
export type GpsLocationTagName = StrEnumKeys<typeof GpsLocationTagNames>;
export interface GpsParseResult {
    result: GpsLocationTags;
    details: string;
    invalid: boolean;
    warnings: string[];
}
export declare function parseGPSLocation(tags: GpsLocationTags, opts: Pick<ExifToolOptions, "ignoreZeroZeroLatLon">): Maybe<Partial<GpsParseResult>>;
