"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExifToolTask = void 0;
const bc = __importStar(require("batch-cluster"));
const IsWarning_1 = require("./IsWarning");
const String_1 = require("./String");
const BadPerlInstallationRE = /Can't locate \S+ in @INC/i;
class ExifToolTask extends bc.Task {
    args;
    options;
    static renderCommand(args, options) {
        const result = args.filter((ea) => !(0, String_1.blank)(ea));
        if (options?.ignoreMinorErrors === true) {
            result.push("-ignoreMinorErrors");
        }
        result.push("-execute");
        return result.join("\n") + "\n";
    }
    errors = [];
    warnings = [];
    constructor(args, options) {
        super(ExifToolTask.renderCommand(args, options), (stdout, stderr, passed) => this.#parser(stdout, stderr, passed));
        this.args = args;
        this.options = options;
    }
    onStderr(buf) {
        if (BadPerlInstallationRE.test(buf.toString())) {
            // This isn't an error we can recover from: there's a Perl module that
            // needs to be installed. See
            // https://github.com/photostructure/exiftool-vendored.js/issues/168 for
            // details.
            throw new Error(buf.toString());
        }
        super.onStderr(buf);
    }
    #parser(stdout, stderr, passed) {
        let error;
        if ((0, String_1.notBlank)(stderr) || !passed) {
            for (const line of (0, String_1.splitLines)(stderr ?? "")) {
                if ((0, IsWarning_1.isWarning)(line)) {
                    this.warnings.push(line);
                }
                else if (/error|warning/i.test(line)) {
                    this.errors.push(line);
                    // new Error() will add a "Error: " prefix:
                    error ??= new Error(line.replace(/^error: /i, ""));
                }
            }
        }
        return this.parse(stdout, error);
    }
}
exports.ExifToolTask = ExifToolTask;
//# sourceMappingURL=ExifToolTask.js.map